#version 3.8;

global_settings {assumed_gamma 1}

#declare N = 500;
#declare Seed = 23451;
#declare RArea = array [2] {<-5,-5>, <5,5>};
//#declare SArea = array [2] {<-3,-1>, <5.5,3>};
#declare SArea = array [2] {<-4,-5.5>, <-3,5.5>};

#include "rand.inc"

#declare RNG = seed(Seed);
// cf RArea.
#macro mkP(rng_) <SRand(rng_),SRand(rng_),0>*5 #end

#declare qtree_debug = no;
#include "quadtree.inc"

#declare T = qtree_new_tree();

qtree_make_root(T, RArea[0], RArea[1])

#for (i_, 0, N-1)
  #if (!qtree_insert_point(T, mkP(RNG)))
    #error "oops, insert failed."
  #end
#end

qtree_dump_tree(T)

#declare X = array {};

#declare NX = qtree_search_tree(T, SArea[0], SArea[1], X);

#debug concat("search area: <",vstr(2,SArea[0],",",0,4),">,<",
        vstr(2,SArea[1],",",0,4),">\n")
#debug concat("#points matched: ",str(dimension_size(X,1),0,0),"\n")

#for (i_, 0, NX-1)
  #debug concat("[",str(i_,0,0),"] <",vstr(3,X[i_],",",0,4),">\n")
#end

