#version 3.6; 
   
global_settings{ assumed_gamma 1.0 }  

// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 300                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 5            // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}



//*************************camera***************************************    
#declare camera_za=0;     
#declare camera_aa=0; 
#declare camera_h=4267.2; 
#declare camera_dist=4267.2+435;

#declare camera_y = camera_dist*cos(radians(camera_za));
#declare camera_LL = camera_dist*sin(radians(camera_za));
#declare camera_x = camera_LL*sin(radians(camera_aa));
#declare camera_z = camera_LL*cos(radians(camera_aa));
                   
camera              
{                
angle  7.54371                
location <camera_x,camera_y,camera_z >  
look_at <0,0,0>   
rotate <0,-31,0> 
right x  
up y  
}

//************************** sun ***************************************
#declare sun_za = 31.65; 
#declare sun_aa = 187.89; 
#declare sun_dist = 152589828000;  


#declare sun_y = sun_dist*cos(radians(sun_za));
#declare sun_LL = sun_dist*sin(radians(sun_za)); 
#declare sun_x = sun_LL*sin(radians(sun_aa));  
#declare sun_z = sun_LL*cos(radians(sun_aa)); 


light_source {<sun_x,sun_y,sun_z>
             color rgb 1   
           
             }        
            
//---------------------------- objects in scene ----------------------------                  

// draw a geometry stored in a file 
#declare geom_file_name = "pov-xyz.txt"; 
#declare spec_file_name = "pov-ref.txt"; 
// find max_x,max_y,max_z 
#declare max_x=689768.244495;
#declare max_y=455.000000;
#declare max_z=5200554.798986;
#fopen   Input_geom_file geom_file_name read
#while(defined(Input_geom_file)) 
    #read(Input_geom_file,x1,y1,z1,x2,y2,z2,x3,y3,z3)  
    #if(x1>max_x)
        #declare max_x = x1;
    #end
    #if(x2>max_x)
        #declare max_x = x2;
    #end
    #if(x3>max_x)
        #declare max_x = x3;
    #end
    #if(y1>max_y)
        #declare max_y = y1;
    #end
    #if(y2>max_y)
        #declare max_y = y2;
    #end
    #if(y3>max_y)
        #declare max_y = y3;
    #end
    #if(z1>max_z)
        #declare max_z = z1;
    #end
    #if(z2>max_z)
        #declare max_z = z2;
    #end
    #if(z3>max_z)
        #declare max_z = z3;
    #end
    
#end 
#debug concat(str(max_x,15,2),str(max_y,15,2),str(max_z,15,2),"\n")  
 
// find min_x,min_y,min_z 
#declare min_x=688921.731000;
#declare min_y=415.000000;
#declare min_z=5199708.285491;
#fopen   Input_geom_file geom_file_name read
#while(defined(Input_geom_file)) 
    #read(Input_geom_file,x1,y1,z1,x2,y2,z2,x3,y3,z3) 
    #if(x1<min_x)
        #declare min_x = x1;
    #end
    #if(x2<min_x)
        #declare min_x = x2;
    #end
    #if(x3<min_x)
        #declare min_x = x3;
    #end
    #if(y1<min_y)
        #declare min_y = y1;
    #end
    #if(y2<min_y)
        #declare min_y = y2;
    #end
    #if(y3<min_y)
        #declare min_y = y3;
    #end
    #if(z1<min_z)
        #declare min_z = z1;
    #end
    #if(z2<min_z)
        #declare min_z = z2;
    #end
    #if(z3<min_z)
        #declare min_z = z3;
    #end 
#end 
#debug concat(str(min_x,15,2),str(min_y,15,2),str(min_z,15,2),"\n")  

// find the center of the geometry   
#declare center_x = (min_x+max_x)*0.5;      
#declare center_y = (min_y+max_y)*0.5;
#declare center_z = (min_z+max_z)*0.5;
#debug concat(str(center_x,15,2),str(center_y,15,2),str(center_z,15,2),"\n\n")     
        
// move the center of the geometry to the original    
     
#declare n = 0;
#fopen   Input_geom_file geom_file_name read
#fopen   Input_spec_file spec_file_name read 
#while(defined(Input_geom_file)) 
#while(defined(Input_spec_file))     
    #read(Input_geom_file,x1,y1,z1) 
    #read(Input_spec_file,ref)  
 
        box     
        {
        -1.55,1.55                    
        rotate y*-31
        translate<x1-center_x,y1-center_y,z1-center_z>   
        pigment{color rgb ref}   
        finish{ambient 0 diffuse 1}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
        no_shadow                
         }                
   
    #declare n = n + 1;
#end      
#debug concat(str(n,15,2),"\n")  
#end                                                             






    