#version 3.7; 
   
global_settings{ assumed_gamma 1.0 }  
#include "spectral.inc"          
#declare SpectralWavelength =730;


//******************************************************************
#declare camera_za=0; 
#declare camera_aa=0; 
#declare camera_h=4267.2;
#declare camera_dist=4267.2+435;


#declare camera_y = camera_dist*cos(radians(camera_za));
#declare camera_LL = camera_dist*sin(radians(camera_za));
#declare camera_x = camera_LL*sin(radians(camera_aa));
#declare camera_z = camera_LL*cos(radians(camera_aa));
                   
camera              
{               
angle  7.54371               
location <camera_x,camera_y,camera_z >  
look_at <0,0,0>   
rotate <0,-31,0>  
right x  
up y  
}

     
//*****************************************************************
#declare sun_za = 31.65;
#declare sun_aa = 187.89; 
#declare sun_dist = 152589828000;  



#declare sun_y = sun_dist*cos(radians(sun_za));
#declare sun_LL = sun_dist*sin(radians(sun_za)); 
#declare sun_x = sun_LL*sin(radians(sun_aa));  
#declare sun_z = sun_LL*cos(radians(sun_aa));  

light_source {<sun_x,sun_y,sun_z>                     
             SpectralEmission(0.47262925)    //irradiance (in730nm)=1.33015(w/m2) lm/w=0.355(in 730nm)  
                                             //illuminance=1.33135* 0.355= 0.47262925(lx)         
                                                 
                
             }                                    
                                                 
//--------------------------- ----------------------------                  

// draw a geometry stored in a file 
#declare geom_file_name = "pov-xyz.txt"; 
#declare spec_file_name = "pov-ref.txt";
// find max_x,max_y,max_z 
#declare max_x=689768.244495;
#declare max_y=0.000000;
#declare max_z=5200554.798986;
#fopen   Input_geom_file geom_file_name read
#while(defined(Input_geom_file)) 
    #read(Input_geom_file,x1,y1,z1,x2,y2,z2,x3,y3,z3)  
    #if(x1>max_x)
        #declare max_x = x1;
    #end
    #if(x2>max_x)
        #declare max_x = x2;
    #end
    #if(x3>max_x)
        #declare max_x = x3;
    #end
    #if(y1>max_y)
        #declare max_y = y1;
    #end
    #if(y2>max_y)
        #declare max_y = y2;
    #end
    #if(y3>max_y)
        #declare max_y = y3;
    #end
    #if(z1>max_z)
        #declare max_z = z1;
    #end
    #if(z2>max_z)
        #declare max_z = z2;
    #end
    #if(z3>max_z)
        #declare max_z = z3;
    #end
    
#end 
#debug concat(str(max_x,15,2),str(max_y,15,2),str(max_z,15,2),"\n")  
 
// find min_x,min_y,min_z 
#declare min_x=688921.731000;
#declare min_y=0.000000;
#declare min_z=5199708.285491;
#fopen   Input_geom_file geom_file_name read
#while(defined(Input_geom_file)) 
    #read(Input_geom_file,x1,y1,z1,x2,y2,z2,x3,y3,z3) 
    #if(x1<min_x)
        #declare min_x = x1;
    #end
    #if(x2<min_x)
        #declare min_x = x2;
    #end
    #if(x3<min_x)
        #declare min_x = x3;
    #end
    #if(y1<min_y)
        #declare min_y = y1;
    #end
    #if(y2<min_y)
        #declare min_y = y2;
    #end
    #if(y3<min_y)
        #declare min_y = y3;
    #end
    #if(z1<min_z)
        #declare min_z = z1;
    #end
    #if(z2<min_z)
        #declare min_z = z2;
    #end
    #if(z3<min_z)
        #declare min_z = z3;
    #end 
#end 
#debug concat(str(min_x,15,2),str(min_y,15,2),str(min_z,15,2),"\n")  

// find the center of the geometry   
#declare center_x = (min_x+max_x)*0.5;      
#declare center_y = (min_y+max_y)*0.5;
#declare center_z = (min_z+max_z)*0.5;
#debug concat(str(center_x,15,2),str(center_y,15,2),str(center_z,15,2),"\n\n")     
        
// move the center of the geometry to the original    
  
#declare n = 0;
#fopen   Input_geom_file geom_file_name read
#fopen   Input_spec_file spec_file_name read 
#while(defined(Input_geom_file)) 
    
    #read(Input_geom_file,x1,y1,z1)  
    #read(Input_spec_file,ref)  
 
         sphere    
        {                    
       
      <x1-center_x,y1-center_y,z1-center_z>, 
         1.55                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
      
       
           finish {
                 ambient 0
                 emission 0
                 specular ref
                   }

          }  
        
    #declare n = n + 1;
#end      
#debug concat(str(n,15,2),"\n")     






 