#version unofficial megapov 1.21;

#include "stdinc.inc"
#include "metals.inc"
#include "textures.inc"
#include "glass.inc"
#include "triangulation.inc"

#declare FB = 0;
#declare Rad = 0;
#declare agatelense = 0;

/*global_settings {
  charset utf8
  assumed_gamma 1.0
  ambient_light 1
  adc_bailout 0.001 
  max_trace_level 10 */
  #if (Rad)
     #include "radiosity.inc"
  /*
    radiosity{
      pretrace_start 0.04
      pretrace_end   0.02
      count 100
      nearest_count 5
      error_bound 1.0
      recursion_limit 1
      low_error_factor .5
      minimum_reuse 0.01
      brightness 1
      adc_bailout 0.01
      normal on
      media on
    }        */
    #else 
    global_settings {
  charset utf8
  assumed_gamma 1.0
  ambient_light 1
  adc_bailout 0.003 
  max_trace_level 10 
  
  }
#end

#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
         [0.0 rgb <0.6,0.7,1.0>]
          [0.7 rgb <0.0,0.1,0.8>]
        }
    }
}

sky_sphere { sky_blue }

camera{
  up y
  right x*image_width/image_height
  angle 42.5
  //location -z*201.5
  location <0,50,-200>
  look_at  <0,13.4,0>
  #if (FB)
    aperture 1.2           // [0...N] larger is narrower depth of field (blurrier)
    blur_samples 100        // number of rays per pixel for sampling
    focal_point 0
    confidence .9           // [0...1] when to move on while sampling (smaller is less accurate)
    variance 1/1000            // [0...1] how precise to calculate (smaller is more accurate)
  #end
  #if (agatelense)
  normal{agate 0.05 scale 40 }
  #end
}                           

#declare tiletex =
texture {
    pigment { uv_mapping
      gradient x
      pigment_map{
        [1/20 rgb 0][1/20 gradient y
          colour_map{
            [1/20 rgb 0]
            [1/20 rgb <0.78431, 0.78431, 0.78431>]
          }
        ]
      }
      scale -<1/10,1/20,1>
    }
    //finish { ambient 0 diffuse 0.6}
    #if (10)
    
    finish {
    ambient 0.05
    brilliance 4
    diffuse 0.75
    metallic
    specular 0.2
    roughness 1/8
    } #end
}



#declare tiletex2 = 
texture {
    pigment { uv_mapping
      gradient x
      pigment_map{[1/80 rgb 0]
      
      [1/80 gradient y colour_map{[1/80 rgb 0]
      [1/80 rgb <0.78431, 0.78431, 0.78431>]}
      ]
      
      }
      //warp { turbulence 0.15 }
      scale -<1/10,1/20,1>
    } 

    finish {
    ambient 0.01
    brilliance 4
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/80
    #if (0)
       diffuse 0.4
irid {
//global_settings { irid_wavelength COLOR }
          0.4
          thickness .5
          turbulence .5
        }
        #else diffuse 0.6
#end
  reflection 0.0
  /* // fresnel requires interior statement and conserve_energy
  reflection {
    0.0, 1.0
    fresnel on
  }
  conserve_energy */
    }
    //normal{agate 0.05 scale 40 }
    

    //finish { ambient 0 diffuse 0.6 reflection 1 }
    }
                               

#include "CGSphere.inc"

#declare _z_ = <279.5,364.1,-434.8>;
#declare _x_ = vnormalize(vcross(y,_z_))*77;
#declare _y_ = vnormalize(vcross(_z_,_x_))*77;

#if (10)
  light_source { <279.5,364.1,-434.8> color rgb <.82,.88,.99>*.9 
  //fade_distance vlength(<279.5,364.1,-434.8>)+60 fade_power 2
    area_light _x_,_y_, 13,13 adaptive 0 jitter orient circular
    //#if (MediaAtmo) media_attenuation on #end
  }
#end  

#declare CGSphereO=sphere{0 40}

object{Ground}

#declare MatOut= //Chrome texture
material{
  texture{
    pigment{rgb 1}
    finish{
      conserve_energy
      diffuse 0.0
      ambient 0
      reflection{0 1 fresnel on metallic 1}
    }
  }
  interior{ior 25}
  rotate -y*90
  
}


#declare stream=seed(225111);
#declare stream2=seed(435111);
#declare stream3=seed(4145111);
#declare stream4 = seed(1231);
#if (0)
light_source{
  <0,0,0>,
  <0,0,1>
}
#else #if (0)
#declare _z_ = <0,0,1>;
#declare _x_ = vnormalize(vcross(y,_z_))*1;
#declare _y_ = vnormalize(vcross(_z_,_x_))*.15;

light_source { <0,0,-19> color rgb <0,0,1>
    area_light _x_,_y_, 13,13 adaptive 0 jitter orient circular 
    // fade_distance vlength(<0,0,80>)-4 fade_power 5
    //#if (MediaAtmo) media_attenuation on #end
  }
#end #end

//#include "tigy2.pov"
#include "tigy.pov"
                 
#declare tigy = union {
  #local scal = 41;
  #local i=0;
  //#local j=1;
  #while (i<62)
     object { tigyface(i) scale <scal*.8,1,scal*.8> rotate -x*90 translate z*radecs[i][2]*scal
     rotate <-radecs[i][1],0,0>
     rotate <0,-radecs[i][0]+90,0>
     }     


  #local i=i+1;
  //#local j=j+1;
  #end
}
//object { tigy pigment { rgb 1 } } //<.8,.5,.9> } }
#declare fxball =
union {
  sphere { <0,0,0>, 40 }
  sphere { <0,0,0>, 7 }
  cylinder{
     <0,-40,0>,<0,-6.5,0>,4 
     open
  }
  texture {
      pigment { color rgbf <0.82,0.82,0.82,0.9> }
       //finish { F_Glass3 }
       /*
  finish {
    specular 0.6 roughness 0.002 ambient 0 diffuse 0.1 brilliance 5     reflection {
      0.1, 1.0   fresnel on   }  conserve_energy
  }            */
       finish  {
          ambient 0.1
          diffuse 0.1
          reflection 0.1
          specular 0.5
          roughness 0.003
          phong .8
          phong_size 2500
       }

   }
  interior { ior 1.5 caustics 1 }
}
//object { fxball }
  // +a0.1 +am2     9min2s cgsphere5 lgiht -----   8min51s cgsphere7 pulse2 no light
#macro pulse2(col,pos,siz)
    glow { 
        location pos
        color rgb col
        size siz 
        type 0
        fade_power 1.5 
    } 
#end
 
//pulse2(<0,0.05,1>,<0,0,0>,4) ////////// center pulse
#macro pulse(col,pos)
    glow { 
        location pos
        color rgb col
        size 0.75/20 
        type 0
        fade_power 1.5 
    } 
#end 
   
#macro pulseline(col,spaceing,pos1,pos2,amp,freq)
        #local lpos = <0,0,0>;
        #local ii = 1;
        #local pos = pos1;
        #while (ii<vlength(pos2-pos1)/spaceing)
        // loop for 330. mult vector by iterator 1-330  (329)
        // div the vector (of len 33-330) by 330
        // and add back to startingpos = pos
          #local pos = pos1 + ii*(pos2-pos1)     /(vlength(pos2-pos1)/spaceing) ;
          #local perp1 = VPerp_To_Vector(pos);
          #local perp2 = VPerp_To_Plane(pos,perp1);
          // complete to 2 perp vectotrs to current position for sin1 cos2
          // -.5 to .5  + 1 = rand(.5 thru 1.5) times len current position
          // divided by 33 (overall len)  =  locamp
          #local perturb = SRand(stream4)/2;
          #local locamp = (perturb + amp)*vlength(pos)/vlength(pos2-pos1);
          //locamp times the normalized perp vectors
          // times sin/cos of fullcircle radians (pi2) *.1* len of curr pos
          #local pos = pos + locamp*vnormalize(perp1)*sin(2*pi*freq*vlength(pos))
           + locamp*vnormalize(perp2)*cos(2*pi*freq*vlength(pos));
          #if (vlength(pos-lpos) > 0.5)
            glow { 
	     	location pos
	  	color rgb col
	  	size 0.75/20 
	  	type 0
	  	fade_power 1.5 
	    } 
	    //sphere {pos,0.3 pigment {rgb <0,0,1>} finish {ambient 1 diffuse 0}}  
	    
	    #local lpos = pos;
	  #end
	  #local ii = ii + 1;
	#end 	   
#end 
   
#declare bluep=<0.4,0.4,1>*0.8;

#declare i = 0; 

#if (0)
#while (i<=10)
 #declare p = vnormalize(<SRand(stream4),SRand(stream2),SRand(stream3)>);
 pulseline(bluep,0.1,p*3,p*37,1,0.1)
 #declare i = i+1;
#end
#end

#declare m_glass = 
material { texture {
    pigment { rgbf <1.0, 1.0, 1.0,.9> }
    finish { F_Glass3 }
    }
  interior { ior 1.5 }
}


                  //"thing_without_name.pov"
                  //"Apollonian.pov"
                  //"Clifford.pov"

#include "mandel.inc"
   #declare mandelbot =
object {

#if (0) path1360
scale <0.111,1,0.111>
rotate <0,90,0>
rotate <-90,0,0>
#else path360
scale <0.171,1,0.131>
rotate <-90,0,0>
translate <0,-42.25556,0>
#end




    pigment
    { mandel 10000
      color_map { [0 rgb 0][.5 rgb x*.5+z][1 rgb z+y][1 rgb z*.2] }
  
      translate
       -<(-0.749979169204317290207435344827-0.749968488051973540207435344827)/2,
         (0.008640613399268010370560473549+0.008630313716650822870560473549)/2>
      scale 3500000*1.2
      rotate z*-48
      // right
      translate <-1,1,0>
      //translate x*-1
    }
    //finish { ambient 1 }
    //finish { F_Glass3 }
    
    finish {
    ambient .9
    brilliance 4
    diffuse 0.4
    metallic
    specular 0.2
    roughness 1/8
    }
    translate x*-.4
    scale 1.1
}
#macro mball(p,r)
   sphere { 0,r
   texture { T_Chrome_3C }
   translate p
   }
#end


#macro m_spheres()
        mball(0,40)
 #local i=0; #local j=0; #local k=0; #local l=0;
 #local deg = 52;
 #local nrs = 4;
 #local rads = pi*2/nrs;
 #local vv = rotation(radians(deg),z,y); 
 #local r=array[5] {30,15,7.5,3.75,1.625}

 #while (i<nrs)
   #local _v1 = vnormalize(rotation(rads*i,y,vv));
   #local lp1 = _v1*(r[0]+r[1]);
   mball(lp1,r[1])
   #local _v2 = rotation(radians(deg),VPerp_To_Vector(_v1),_v1);
   
   #local j=0;
   #while (j<nrs)
     #local _v2 = vnormalize(rotation(rads,_v1,_v2));
     #local lp2 = _v2*(r[1]+r[2])+lp1; 
     mball(lp2,r[2]) 
     #local _v3 = rotation(radians(deg),VPerp_To_Vector(_v2),_v2);
     
     #local k=0;
     #while (k<nrs)
        #local _v3 = vnormalize(rotation(rads,_v2,_v3));
        #local lp3 = _v3*(r[2]+r[3])+lp2; 
        mball(lp3,r[3])
        #local _v4 = rotation(radians(deg),VPerp_To_Vector(_v3),_v3);
        
        #local l=0;
        #while (l<nrs)
           #local _v4 = vnormalize(rotation(rads,_v3,_v4));
           mball(_v4*(r[3]+r[4])+lp3,r[4])
           #local l=l+1;     
        #end
        #local k=k+1;
       #end
       #local j=j+1;
    #end
    #local i=i+1;
  #end
#end

m_spheres()