/*

******************************************************************************
Triangulation.inc      ABC=vectors abc=floats 

3D Macros:
  incenter(A,B,C)
  centroid(A,B,C)
  ccenter(A,B,C)                   circumcenter
  orthocenter(A,B,C)
  normal_vector(A,B,C)
  midpoint(A,B)

  rotation(r,Axis,Point)
  _rotate(sine,cosine,Axis,Point)  
  
  circumradius(A,B,C)              float
  inner_radius(A,B,C)              float
  radang3(A,B,C)                   Angle at B in radians
  

Functions:
  inneradius(a,b,c)      3 lens
  outeradius(a,b,c)
  
  sss_area(a,b,c)
  sas_area(s,a,s2)
  bh_area(b,h)           Base Height

  sss_height(a,b,c)      height to side2
  sas_cos(s,a,s2)        Side Angle Side - solve length of missing side

  aas_sin(a,b,s)         AAS solve opposing side of angle2 (b)
  asa_sin(a,s,b)         ASA solve opposing side of angle2 (b)
  sss_cos(a,b,c)         SSS solve angle opposite side2    (b)
  ssa_acute(s,s2,a)      SSA solve angle opposite side2 
  

Float Macros:
  ssa_obtuse(s,s2,a)
  sa_height(s,a)         Side Angle unknown base
  _clamp(a,n,m)

  
Matrix:  
  pop_matrix(A,B,C)                   Matrix Transform (Shear_Trans())
  rotate_matrix(r,Axis)               Rotate ID Matrix (Axis_Rotate_Trans())
  
  rotate_matrix_M(r,Axis,A,B,C)       Rotate Matrix
  rotate_matrix_T(r,Axis,A,B,C,T)     Rotate Matrix Translate
  rotate_Matrix(r,Axis,m)             Rotate only and set
  pop_Matrix(m)                       Transform
         
    alphaQuad 10-2007
*******************************************************************************

*/

#declare PI = 3.1415926535897932;
#declare PI2 = 6.283185307179586;
#declare PI_5 = 1.570796326794897;
#declare PI1_5 = 4.71238898038469;
#macro incenter1(A,B,C)
      #local c = vlength(A-B);
      #local a = vlength(B-C);
      #local b = vlength(C-A);
      #local d = (a+b+c);
  #local result = 
      <((a*A.x) + (b*B.x) + (c*C.x))/d,
       ((a*A.y) + (b*B.y) + (c*C.y))/d,
       ((a*A.z) + (b*B.z) + (c*C.z))/d>;
  result
#end

#macro incenter(A,B,C)
      #local a = C*vlength(A-B);
      #local b = A*vlength(B-C);
      #local c = B*vlength(C-A);
      #local d = vlength(A-B)+
                 vlength(B-C)+
                 vlength(C-A);
  #local result = (a+b+c)/d;     
  result
#end
#macro centroid(A,B,C)
  #local result = (A+B+C)/3;
  result
#end

#macro circumcenter(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
      #local sp = (a+b+c)*0.5;

   #local cosineR = ((b*b + c*c - a*a)/(2*b*c))*
      a*b*c/(4*sqrt(sp*(sp-a)*(sp-b)*(sp-c))); //circumradius(A,B,C);
   #local mp = (A+B)/2; //midpoint(A,B)
   #local result = mp+(vnormalize(vcross(A-mp,vcross(C-B,A-B)))*cosineR);
   result
   /* "walks" to cCenter in 3D.
      Algebra core step=cos(angle)*R.
      Input order irrelevant since both (A-mp)
      and norm vectors reverse in sync */
#end

#macro outcenter(A,B,C)
   circumcenter(A,B,C)
#end 
#macro ccenter(A,B,C)
   circumcenter(A,B,C)
#end 

#macro orthocenter(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
      #local sp = (a+b+c)*0.5;

   #local cosineR = ((b*b + c*c - a*a)/(2*b*c))*
      a*b*c/(4*sqrt(sp*(sp-a)*(sp-b)*(sp-c))); //outeradius(a,b,c);
   #local mp = (A+B)/2; //midpoint(A,B)
   #local cc = mp+(vnormalize(vcross(A-mp,vcross(C-B,A-B)))*cosineR);
   
   #local result = ((A-cc)+(B-cc)+(C-cc)) + cc;
   result
#end

#macro inner_radius(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
   #local result = 0.5*sqrt(((b+c-a)*(c+a-b)*(a+b-c)) / (a+b+c));
   result      
#end
#macro tetrahedron_volume(A,B,C,D)
  #local result = abs(vdot(D-A,vcross(D-B,D-C))) / 6;
  result
#end
#macro pyramid_volume(A,B,C,D,E)
  // perimeter order for 1st 4 points
  #local result = 
     tetrahedron_volume(A,B,C,E) + tetrahedron_volume(A,C,D,E);
  result
#end
#macro triangle_area(A,B,C)
     //2D .z must be 0
   #local result = abs((B.x*A.y - A.x*B.y)+
                       (C.x*B.y - B.x*C.y)+
                       (A.x*C.y - C.x*A.y)) / 2;
   result      
#end
#declare inneradius = function(a,b,c) {
   //(3 lens)
   0.5*sqrt(((b+c-a)*(c+a-b)*(a+b-c)) / (a+b+c))
}
#macro circumradius(A,B,C)
      #local a = vlength(A-B);
      #local b = vlength(B-C);
      #local c = vlength(C-A);
   #local result = a*b*c/(4*sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*
                   (((a+b+c)/2)-b)*(((a+b+c)/2)-c)));
   result      
#end

#declare outeradius = function(a,b,c) {
  //(3 lens)
  a*b*c/(4*sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c)))
  //(a*b*c) / (4*sss_area(a,b,c))  
}

#declare sas_area = function(s,a,s2) {
   0.5 * s * sin(a) * s2
}

#declare sas_cos = function(s,a,s2) {
   sqrt((pow(s,2)+pow(s2,2))-2*s*s2*cos(a))
} // Side Angle Side - solve length of missing side


#declare sas_height = function(s,a,s2) {
    s*sin(a)*s2/sqrt((pow(s,2)+pow(s2,2))-2*s*s2*cos(a))
   //sas_area(s,a,s2) / (sas_cos(s,a,s2) * 0.5)
} // SAS height to missing side


#declare bh_area = function(b,h) {
   //(base,height)
   0.5 * b * h
}

#declare sss_height = function(a,b,c) {
  sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c))/(b*0.5)
  //sss_area(a,b,c) / (b * 0.5)
} // height to side2

#declare sss_area = function(a,b,c) {
   //semi perimeter
   sqrt(((a+b+c)/2)*(((a+b+c)/2)-a)*(((a+b+c)/2)-b)*(((a+b+c)/2)-c))
}

#declare vmyv = function {
//function that returns a vector
   transform {
     rotate <0, 0, 0>
     scale 1
   }
}

#declare aas_sin = function(a,b,s) {
   sin(b) * (s / sin(a))
} // AAS solve opposing side of angle2 (b)

#declare asa_sin = function(a,s,b) {
   sin(b) * (s / sin(pi-(a+b)))
} // ASA solve opposing side of angle2 (b)

#declare sss_cos = function(a,b,c) {
   acos((pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c))
} // SSS solve angle opposite side2 (b)
  // if (pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c) < 0 obtuse

#declare ssa_acute = function(s,s2,a) {
   asin(s2*sin(a)/s)
} // SSA solve angle opposite side2

/*
alias sss_area2 {
  ; (3 lens)
  return $calc(0.5 * ($1 + $2 + $3) * $inneradius($1,$2,$3))
}
alias sss_area3 {
  ; (3 lens)
  return $calc(($1 * $2 * $3) / (4 * $circumradius($1,$2,$3)))
}*/

/* help file stuff
#declare Count=0;
 #while (Count < 5)
  object { MyObject translate x*3*Count }
  #declare Count=Count+1;
 #end
*/
/*
  2*area/(a+b+c) where side lens are abc
  distance(D) of o(circumcenter) and i(incenter) = D = sqrt(R(R-2r)) R=outer or circumrad
  if circumcenter O has coordinates (0,0)
  then orthocenter H has coordinates ( x1+x2+x3 , y1+y2+y3 )
  if ABC lie on the unit circle, we have: (a1)^2 + (b1)^2 = (a2)^2 + (b2)^2 = (a3)^2 + (b3)^2 = 1 */


/*     383 156 0 645 254 0 465 289 0     
279.72843974111748 183.3712082089225 156.24659996300718
%tri.a 383 156
%tri.b 645 254
%tri.c 465 289
%tri.ab 279.72843974111748
%tri.bc 183.3712082089225
%tri.ca 156.24659996300718
%tri.ang.a 0.660369
%tri.ang.b 0.549982
%tri.ang.c 1.931241
  //e $ssa-obtuse(156.24659,279.728439,0.549982) == 1.931241 */
#macro ssa_obtuse(s,s2,a)
  // SSA solve ang opposite side2
  #local h = sin(a) * s2;
  #if (h = s2) // given right angle
     #local result = asin(h/s);
  #else
     #if (h = s) // right triangle solved
        #local result = pi/2;
     #else
        #if (s = s2) // isosceles triangle
           #local result = a;
        #else
  // if (s < h) // no solution return no solution
  // if ((%h < $1) && ($1 < $2)) _e two distinct solutions
  // if 3 sides known:
  // if (pow(a,2)+pow(c,2)-pow(b,2))/(2*a*c) < 0 obtuse sss_cos
  //obtuse
  #local result = pi - asin(h/s);
  #end
  #end
  #end
  result
#end

#macro sa_height(s,a)
// (side,angle) unknown base
  #local h = sin(a) * s;
  #if (a < pi)
     #local result = h;
  #else
     #local result = 0;
  #end
  result
#end
#macro _clamp(a,n,m)
   #local result = a;
   #if (a < n) #local result = n;
   #end
   #if (a > m) #local result = m;
   #end
   result
#end

#macro normal_vector(A,B,C)
 #local result = vcross(C-B,A-B);
 result
 // 1
 // |
 // 2__ 3 vz points at you (neg) unless reverse y like pov, then
 //
 // 2__ 3
 // |
 // 1
#end
#macro vlen(V)
   #local result = vlength(V)
   result
#end   
// functions must appear first, but not macros
// no function dependency, order irrelevant
// no operation redundancy
// no unnecessary stack set
// if result not set, available to macros but failed to echo to message tab
#macro midpoint(A,B)
  #local result = (A+B)/2;
  result
#end
                     //point=reservedword and seems to work here
#macro rotation(r,Axis,Point)

        #local s = sin(r);
	#local cs = cos(r);
	#local d = vlength(Axis);
	#if (d = 0) #local d = 1.0;
	#end 

	#local a = Axis.x/d;
	#local b = Axis.y/d;
	#local c = Axis.z/d;

	#local xx = a * a;
	#local yy = b * b;
	#local zz = c * c;
	#local xy = a * b;
	#local yz = b * c;
	#local zx = c * a;
	#local xs = a * s;
	#local ys = b * s;
	#local zs = c * s;
	#local one_c = 1.0 - cs;

	#local a = Point.x * ((one_c * xx) + cs);
	#local b = Point.x * ((one_c * xy) - zs);
	#local c = Point.x * ((one_c * zx) + ys);

	#local a = a + Point.y * ((one_c * xy) + zs);
	#local b = b + Point.y * ((one_c * yy) + cs);
	#local c = c + Point.y * ((one_c * yz) - xs);

	#local a = a + Point.z * ((one_c * zx) - ys);
	#local b = b + Point.z * ((one_c * yz) + xs);
	#local c = c + Point.z * ((one_c * zz) + cs);

#local result = <a,b,c>;
result
#end
#macro _rotate(sine,cosine,Axis,Point)

	#local d = vlength(Axis);
	#if (d = 0) #local d = 1.0;
	#end 

	#local a = Axis.x/d;
	#local b = Axis.y/d;
	#local c = Axis.z/d;

	#local xx = a * a;
	#local yy = b * b;
	#local zz = c * c;
	#local xy = a * b;
	#local yz = b * c;
	#local zx = c * a;
	#local xs = a * sine;
	#local ys = b * sine;
	#local zs = c * sine;
	#local one_c = 1.0 - cosine;

	#local a = Point.x * ((one_c * xx) + cosine);
	#local b = Point.x * ((one_c * xy) - zs);
	#local c = Point.x * ((one_c * zx) + ys);

	#local a = a + Point.y * ((one_c * xy) + zs);
	#local b = b + Point.y * ((one_c * yy) + cosine);
	#local c = c + Point.y * ((one_c * yz) - xs);

	#local a = a + Point.z * ((one_c * zx) - ys);
	#local b = b + Point.z * ((one_c * yz) + xs);
	#local c = c + Point.z * ((one_c * zz) + cosine);

#local result = <a,b,c>;
result
#end
#macro popmatrix(A, B, C,T)
   transform {
      matrix <A.x, A.y, A.z,
              B.x, B.y, B.z,
              C.x, C.y, C.z, T.x, T.y, T.z>
   }
#end
#macro pop_matrix(A, B, C)
   transform {
      matrix <A.x, A.y, A.z,
              B.x, B.y, B.z,
              C.x, C.y, C.z, 0, 0, 0>
   }
#end
#macro pop_matrix_T(A, B, C, T)
   transform {
      matrix <A.x, A.y, A.z,
              B.x, B.y, B.z,
              C.x, C.y, C.z, T.x,T.y,T.z>
   }
#end
#macro rotate_matrix(r,Axis)
   // ID matrix
   #local vX = rotation(r,Axis,x);
   #local vY = rotation(r,Axis,y);
   #local vZ = rotation(r,Axis,z);
   transform {
      matrix <vX.x,vX.y,vX.z,
              vY.x,vY.y,vY.z,
              vZ.x,vZ.y,vZ.z, 0,0,0>
   }
#end
#macro rotate_matrix_M(r,Axis,A,B,C)
   #local vX = rotation(r,Axis,A);
   #local vY = rotation(r,Axis,B);
   #local vZ = rotation(r,Axis,C);

   transform {
      matrix <vX.x,vX.y,vX.z,
              vY.x,vY.y,vY.z,
              vZ.x,vZ.y,vZ.z, 0,0,0>
   }
#end
#macro rotate_matrix_T(r,Axis,A,B,C,T)
   #local vX = _rotate(sin(r),cos(r),Axis,A);
   #local vY = rotation(r,Axis,B);
   #local vZ = rotation(r,Axis,C);
   
   transform {
      matrix <vX.x,vX.y,vX.z,
              vY.x,vY.y,vY.z,
              vZ.x,vZ.y,vZ.z, T.x,T.y,T.z>
   }
#end
#declare deg2rad = function(d) {
 d / 57.295779513082323
 //radians()
}
#declare rad2deg = function(r) {
 r * 57.295779513082323
 //degrees()
}
#macro radang2(A,B)
  #declare result =
    acos(_clamp(vdot(vnormalize(A),vnormalize(B)), -1.0, 1.0));
   result
#end
#macro radang3(A,B,C)
   // input is 3 points in 3D -- points to A and C, angle at B
   #declare result = 
     acos(_clamp(vdot(vnormalize(A-B),vnormalize(C-B)), -1.0, 1.0));
   result
#end
#macro rotate_Matrix(r,Axis,m)
   #local m[0] = rotation(r,Axis,m[0]);
   #local m[1] = rotation(r,Axis,m[1]);
   #local m[2] = rotation(r,Axis,m[2]);  
#end

#macro rotatem(_v,m)
   #local v0 = <m[0],m[1],m[2]>; //rotation(radians(_v.x),x,<m[0],m[1],m[2]>);
   #local v1 = rotation(radians(_v.x),v0,<m[4],m[5],m[6]>);
   #local v2 = rotation(radians(_v.x),v0,<m[8],m[9],m[10]>);
   
   #local v0 = rotation(radians(_v.y),v1,v0);
   //#local v1 = rotation(radians(_v.y),y,v1);
   #local v2 = rotation(radians(_v.y),v1,v2);
   #local v0 = rotation(radians(_v.z),v2,v0);
   #local v1 = rotation(radians(_v.z),v2,v1);
   //#local v2 = rotation(radians(_v.z),z,v2);
   
   #local m[0]=v0.x;
   #local m[1]=v0.y;
   #local m[2]=v0.z;
   #local m[4]=v1.x;
   #local m[5]=v1.y;
   #local m[6]=v1.z;
   #local m[8]=v2.x;
   #local m[9]=v2.y;
   #local m[10]=v2.z;
   
#end

#macro pop_Matrix(m)
   transform {
      matrix <m[0].x, m[0].y, m[0].z,
              m[1].x, m[1].y, m[1].z,
              m[2].x, m[2].y, m[2].z,
              m[3].x, m[3].y, m[3].z>
   }
#end

#macro popTmatrix4(m,V)

   transform {
      matrix <m[0], m[1], m[2],
              m[4], m[5], m[6],
              m[8], m[9], m[10],
              V.x, V.y, V.z>
   }
#end

#macro pop_matrix4(m,V)
  #local A=<m[0],m[1],m[2]>*V.x;
  #local B=<m[4],m[5],m[6]>*V.y;
  #local C=<m[8],m[9],m[10]>*V.z;
  #local C=A+B+C;
  C
#end

#macro pop_matrix3(A,B,C,V)
  #local r = A*V.x+A*V.y+C*V.z;
  r
#end
#declare mi2km = function(mi) { (mi * 1.609344) }
#declare km2mi = function(km) { (km / 1.609344) }
#declare au2km = function(au) { (au * 149597870.691) }
#declare au2mi = function(au) { (au * km2mi(au2km(1))) }
#declare pc2au = function(pc) { (pc * 206264.80624709636) }
#macro lightspeed(s)
  #local ls = 299792.458;
  #if (!strcmp(s,"km")) #local ls = 299792.458;
  #else
    #if (!strcmp(s,"mi")) #local ls = km2mi(299792.458);
    #end
  #end
  ls
  //; per secc
#end
#declare km2ly = function(km) { km / 9460730472580.7988 } //$calc($lightspeed(0).km * $jsecyear)365.25*24*3600*lightspeed("km")
#declare pc2ly = function(pc) { pc * 3.261563776971214 } //$km2ly($pc2km(1)))




/*
; ********YEARS of Earth In Degrees Per Day******
alias Sidereal_rotation_period return 360.98983412517123
alias Tropical_year {
  if ($prop == days) return 365.24218967
  return 0.985647359975756
}
alias Vernal_equinox_year {
  if ($prop == days) return 365.2424
  return $ldiv(360.0, 365.2424)
}
alias Calendar_year {
  if ($prop == days) return 365.2425
  return $ldiv(360.0, 365.2425)
  ; 0.985646522515863
}
alias Julian_year {
  if ($prop == days) return 365.25
  return $ldiv(360.0, 365.25)
  ; 0.985626283367556
}
alias Sidereal_year {
  ; if ($prop == days) return 365.25636042 
  if ($prop == days) return 365.256363051 
  return 0.985609112988222
}
alias Anomalistic_year {
  if ($prop == days) return 365.259635864
  return 0.985600281696721
}
alias Draconic {
  ; Draconic or Draconitic year, eclipse year
  if ($prop == days) return 346.620075883
  return $ldiv(360.0, 346.620075883)
}
alias yearsoflight {
  ; onlineconversion.com
  1 light year [Julian] = 5878625373183.607 mile
  1 light year [tropical] = 5878499814135.05 mile
  1 light year [traditional] = 5874601673407.301 mile

  1 light year [Julian] = 9460730472580.8 kilometer
  1 light year [tropical] = 9460528404879.357 kilometer
  1 light year [traditional] = 9454254955488.0 kilometer
}
alias ausinaparsec {
  return 206264.80624709636
  return 206264.80624872944
  ; height of right triangle L\ = $aas-sin($arcsec2rad(1),$lsub(%PI.5, $arcsec2rad(1)),1)
  ; hypot = $aas-sin($arcsec2rad(1),%PI.5,1) = 206264.80625115347 = $ldiv(1,$arcsec2rad(1))
  ; 30856775813057.293
  ; $ldiv(30856775813301.598, 149597870.691) km ... pc/au
  ; 3600 * 180 ISOSCELES height
  ; $ldiv(648000,%PI) = 206264.80624709636

  ; 149597870.691 km, $ausinaparsec, 299792.458 km,
  ; and mi/km ratio of 1.609344 are 4 constants for distance
}
alias pc2ly return $lmult($1, $km2ly($pc2km(1)))
alias pc2au return $lmult($1, $ausinaparsec)
alias pc2km return $lmult($1, $lmult($au2km(1), $ausinaparsec))
alias pc2mi return $lmult($1, $km2mi($pc2km(1)))

alias ly2pc return $lmult($1, $km2pc($ly2km(1)))
alias ly2au return $lmult($1, $km2au($ly2km(1)))
alias ly2mi return $lmult($1, $lightyearmi)
alias kly2mi return $lmult($1, 5878625373183607.4)
alias ly2km return $lmult($1, $lightyearkm)

alias lightspeed {
  if ($prop == km) return 299792.458
  return $km2mi(299792.458)
  ; per sec
}
alias lightyearkm return $calc($lightspeed(0).km * $jsecyear)
alias lightyearmi return $lmult($lightspeed, $jsecyear)
alias jsecyear return $calc($secday * 365.25)
alias gsecyear return $calc($secday * 365.2425)

alias au2pc return $ldiv($1, $ausinaparsec)
alias au2ly return $ldiv($1, $km2au($lightyearkm))
alias au2mi return $lmult($1, $km2mi($au2km(1)))
alias au2km return $lmult($1, 149597870.691)

alias mi2ly return $ldiv($1, $lightyearmi)
alias mi2pc return $ldiv($1, $km2mi($pc2km(1)))
alias mi2au return $ldiv($1, $km2mi($au2km(1)))
alias mi2km return $lmult($1,1.609344)

alias km2pc-2 return $au2pc($km2au($1))

alias km2mi return $ldiv($1, 1.609344)
alias km2ly return $ldiv($1, $lightyearkm)
alias km2pc return $ldiv($1, $calc($au2km(1) * $ausinaparsec))
alias km2au return $ldiv($1, 149597870.691)
alias km2earth return $calc($1 / 6378.003888)

; *********2d triangulation**********
alias arcmin2rad return $ldiv($1,$ldiv(10800,%PI))
alias arcsec2rad return $ldiv($1,$ausinaparsec)
alias marcsec2rad return $ldiv($1,$ldiv(648000000,%PI))
alias  rad2arcmin return $lmult($1,$ldiv(10800,%PI))
alias rad2arcsec return $lmult($1,$ausinaparsec)
alias rad2marcsec return $lmult($1,$ldiv(648000000,%PI))

alias arcmin2rad-1 return $deg2rad($ldiv($1, 60))
alias marcsec2rad-1 return $deg2rad($ldiv($1, 3600000))
alias arcsec2rad-1 {
  return $deg2rad($ldiv($1, 3600))
  return $lmult($1,$au2pc(1))
  $ldiv(%PI, $lmult(3600, 180))
}
alias parallax2parsec {
  ; (parallax-mas)
  var %r = $marcsec2rad($1)
  return $lmult($ldiv($au2pc(1), $lsin(%r)), $lsin($lsub(%PI.5, %r)))
  return $asa-sin(%PI.5,0.000004848136811,$lsub(%PI.5, $marcsec2rad($1)))
  _e $parallax2parsec(379.21) parsecs to Sirius
}
 */
/*

******************************************************************************
Triangulation.inc      ABC=vectors abc=floats

3D Macros:
  incenter(A,B,C)
  centroid(A,B,C)
  ccenter(A,B,C)                   circumcenter
  orthocenter(A,B,C)
  normal_vector(A,B,C)
  midpoint(A,B)

  rotation(r,Axis,Point)
  _rotate(sine,cosine,Axis,Point)  
  
  circumradius(A,B,C)              float
  inner_radius(A,B,C)              float
  radang3(A,B,C)                   Angle at B in radians
  

Functions:
  inneradius(a,b,c)      3 lens
  outeradius(a,b,c)
  
  sss_area(a,b,c)
  sas_area(s,a,s2)
  bh_area(b,h)           Base Height

  sss_height(a,b,c)      height to side2
  sas_cos(s,a,s2)        Side Angle Side - solve length of missing side

  aas_sin(a,b,s)         AAS solve opposing side of angle2 (b)
  asa_sin(a,s,b)         ASA solve opposing side of angle2 (b)
  sss_cos(a,b,c)         SSS solve angle opposite side2    (b)
  ssa_acute(s,s2,a)      SSA solve angle opposite side2 
  

Float Macros:
  ssa_obtuse(s,s2,a)
  sa_height(s,a)         Side Angle unknown base
  _clamp(a,n,m)

  
Matrix:  
  pop_matrix(A,B,C)                   Matrix Transform (Shear_Trans())
  rotate_matrix(r,Axis)               Rotate ID Matrix (Axis_Rotate_Trans())
  
  rotate_matrix_M(r,Axis,A,B,C)       Rotate Matrix
  rotate_matrix_T(r,Axis,A,B,C,T)     Rotate Matrix Translate
  rotate_Matrix(r,Axis,m)             Rotate only and set
  pop_Matrix(m)                       Transform
       
    alphaQuad 10-2007
*******************************************************************************

*/

#macro setmatrix()
 //#declare cameramatrix = array[16] { 1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1 }
 //#declare campos = <0,0,-3>;
 //#declare camlookat = <0,0,0>;
 //eye
 #local e = vnormalize(camlookat-campos); 
 //right
 #local r = vnormalize(vcross(<0,1,0>,e));
 //echov(vcross(<0,0,1>,<0,1,0>))
 //echo(" is a left vector")
 // up,eye is the only rule = both right and left-hand methods use it; vcross(up,eye)
 //echov(vcross(<0,1,0>,<0,0,1>))
 //echo(" is a right vector\n")
 // always end last string with \n     oic

 //up
 #local U = vnormalize(vcross(e,r)); 
 #declare cameramatrix = array[16] { r.x,r.y,r.z,0,U.x,U.y,U.z,0,e.x,e.y,e.z,0,0,0,0,1 }
 #local ab = invertmatrix(cameramatrix,worldmatrix);
#end

#macro radians2pos(ra,dec)
 <cos(ra)*cos(dec), sin(dec), sin(ra)*cos(dec)>
#end

#macro round(f,n)
  #local c = floor(pow(10.0,n));
  #local dd = 0.5 / c;
  #local dd = dd + abs(f);
  #local dd = dd * c;

  #local dd=floor(dd);
  #local dd = dd/c;
  #if (f < 0.0) #local dd = dd * -1; #end
  (dd)
#end