#include "stdinc.inc"
#declare _water = 10;
#include "metals.inc"
camera {location <0,0,-1>*1280 look_at <0,0,0> angle 26}
//light_source {   <300,800 ,-8300>, rgb <.8,.8,1>*.4 }
light_source {   <0,-10,-1100>, rgb .4 }

#declare Finsh_Glass =
finish {
  ambient 0.005
  diffuse 0.1
  reflection 0.05
  specular 0.8
  roughness 0.003
  phong .7
  phong_size 800

}

#include "butterflypath4_.pov"
#include "butterflypath6_.pov"
#include "butterflypath8_.pov"

 #declare buttex = 
 
   texture {
  #local cb = 6;
    pigment {
      agate
      color_map {
       [0.0 color rgb <0.1, 0.095, 0.09>*cb ]
        [0.2 color rgb <0.11, 0.12, 0.12>*cb ]
        [0.6 color rgb <0.13, 0.12, 0.13>*cb ]
        [1.0 color rgb <0.14, 0.13, 0.16>*cb ]
      }
      scale 40
      warp { turbulence 0.5 }
    }
    finish {
      specular 0.1
      diffuse 0.8
      ambient 0.1
    }
    normal {
      granite 0.6
      scale 40
   }
  }
 
#declare butterfly_wings =
object {

butterflypath4_
  texture {
    pigment { color rgbft <0.9,0.9,0.9,0.9,.1> }
    finish { Finsh_Glass }
    scale .1
  }
  interior{
    ior 2.5 dispersion 1 dispersion_samples 2
  }
  photons{
    target 
    refraction on
    collect off
  }
rotate -x*90
} 
 
#declare butterfly_skeleton = 
 difference {
  object { butterflypath6_ }
  object { butterflypath8_ }
  
  texture {
  buttex
  rotate -x*90
//rotate y*90

}

#declare sky_blue =
sky_sphere {
    pigment {
        gradient y
        color_map {
          [0.0 rgb <0.6,0.7,1.0>]
          [0.7 rgb <0.4,0.5,0.8>]
        }
    }
}

 sky_sphere { sky_blue }


#declare water = plane {
    y,-150 
    //rotate x*1
    texture {
       T_Chrome_3C
       normal {
          waves 0.2
          rotate y*45
          frequency 5000
          scale 40000
          phase clock*-.5+ .6
       }
   pigment{ rgb <0.3,0.4,0.85>*0.6 filter 0.05 }
   finish { ambient 0 }
   }
}
#if (_water)
light_group {
   light_source { <30, 50, 500> color White*0 }
   object { water }
}
#end
#if (10)
  object { butterfly_skeleton }
  object { butterfly_wings }
#end