#include "echo2.inc"
#include "triangulation.inc"
#include "math.inc"  //VEq
#declare FontSize = _clamp(1.2,0,1.2);// 1.3 render time devastated  [1.2 = 1m 25s @800.600 ]

#declare StarLabels = 10;
#include "Flam_Bayer.inc"

#declare PlanetLabels = 10;
#include "planets.inc"
#include "luna.inc"

#declare DrawRings=10;
#include "rings.inc"

#declare DrawMilkyway=10;
#include "milkyway.inc"

#declare DrawAtmo=0;                         // media time stealer. busted, not working right
#include "plradiosity.inc"



#declare camang = 60;
#declare worldmatrix = array[16] { 1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1 }
#declare cameramatrix = array[16] { 1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1 }



// ********************************** MOON **************************************************
#declare Long = 0.0; #declare Lat = 0.0; #declare Rad = 0.0;
#declare Luna_v = LunarPos(JulianDate,Long,Lat,Rad);// radians2position+orbitplane.

#declare Earth_v = orbital(3);
#declare Lunar_v =vnormalize(Luna_v)*IDS(vlength(Luna_v))+Earth_v; //IDS(au2km(0.00257))
//Final
sphere { <0,0,0>, 0.2724/10 
  material { MoonMap }
  //rotate <0,13.176358*days,0> matrix points to earth; sync'ed. 
  // up or axial tilt is 1.5424 degrees to eclip. 6.687 orbitplane - doesnt give north pole v
  //  orbit inclination       5.145 to the ecliptic[1]
  //(between 18.29 and 28.58 to Earth's equator)   rotate <0,0,6.687>?
  
  #local E = vnormalize(Earth_v-Lunar_v);
  #local R = vnormalize(vcross(<0,1,0>,E));
  rotate <0,90,0>
  popmatrix(R,vnormalize(vcross(E,R)),E,Lunar_v)
} // ********************************* Kilometers *******************************************





// *************************************************************************************************************
// ******************************** What to See ********************* MAIN Planetarium Program ************ MAIN
// *************************************************************************************************************
#ifndef (Earth_v) #declare Earth_v = orbital(3); #end

#declare Target = Earth_v;                                         //0.0004
#declare Source = <0,0,0>;

//#declare Source = Earth_v;
//#declare Target = Lunar_v;                                         //0.03

//#declare Target = orbital(8);                                    //0.00003 Nep
//#declare Target = orbital(7);                                    //0.00008 Ura
//#declare Target = orbital(6);                                    //0.0003 Sat
//#declare Target = orbital(5);                                    //0.0007 Jup
//#declare Target = orbital(4);                                    //0.0001 Mar

#if (!VEq(Target,Source))
#declare campos = vnormalize(Source-Target)*vlength(Target-Source)*0.0004+Target;
                                 //0.003 or could use a multiple of planet radius
#declare camlookat = Target;
setmatrix()


echo("Calculating Stars \n")
Stars(20, 512, 60,40)//min-size ($2,$3 not setup) star-size [angle would be (IS) a global] developed 1280.1024
echo("Stars Finished \n")
echo("Calculating Planets \n")
Planets(0)
#else echo("Set Target and Source (Target==Source) \n") #end






// *************************** Tell POV all about it ****************************
light_source{
  <0,0,0>,
  0.8
}

camera{
  location campos
  look_at camlookat
  angle camang
}











///////////////////////////////////////////////////// Cam Angle Readout *************

#macro camradec()
  #local eye = <cameramatrix[8],cameramatrix[9],cameramatrix[10]>;
  #local rad = abs(atan2(cameramatrix[10],cameramatrix[8]));

  #if (cameramatrix[10] < 0.0) #local rad = pi*2 - rad; #end
  #local rad = rad / (pi / 12);
  #local _v = <cameramatrix[8], 0.0, cameramatrix[10]>;
  #local dec = degrees(radang2(eye,_v));

  #local s = concat(str(floor(rad),0,0),"h ", str(round(mod(rad,1.0)*60,2)0,2) ,"m :: ");

  #local w = floor(dec);
  #if (cameramatrix[5] > 0.0) #local w = w * -1;
  #local dec = dec * -1; #end
  
  #local s = concat(s,str(w,0,0),"d ", str(round(abs(mod(dec,1.0))*60,2),0,2),"m");
  //echo(s) echo(" \n")
  #local ra = round((rad * 360 / 24),2);
  #local dec = round(dec,2);

  drawtext(1,<0.0015,0.0015, 0.00001>,-56,-40,0,s)

  #local s = concat("RA: ",str(round((rad * 360 / 24),2),0,2), " Dec: ", str(round(dec,2),0,2));
  drawtext(1,<0.0015,0.0015, .00001>,-56,-42,0,s)
  drawtext(1,<0.0015,0.0015, .00001>,46,-42,0,str(JulianDate,0,5))
  //echo(s) echo(" \n")
#end                

#macro drawtext(col,scal,X,Y,Z,Text)
#local _x = <cameramatrix[0],cameramatrix[1],cameramatrix[2]>*0.001;
#local _y = <cameramatrix[4],cameramatrix[5],cameramatrix[6]>*0.001;
#local _z = <cameramatrix[8],cameramatrix[9],cameramatrix[10]>*0.001;
  text {
      ttf "Arial.ttf" 
      Text
      1 0 scale scal
      texture {
        pigment { rgb col } 
        finish { ambient 1 diffuse 0 }
      }
      popTmatrix4(cameramatrix,vnormalize(camlookat-campos)*0.1+campos+(_x*X)+(_y*Y)+(_z*Z))
  }
#end
camradec()


#macro Drawtext3D(col,scal,T,Text)
#local _x = <cameramatrix[0],cameramatrix[1],cameramatrix[2]>*0.001;
#local _y = <cameramatrix[4],cameramatrix[5],cameramatrix[6]>*0.001;
#local _z = <cameramatrix[8],cameramatrix[9],cameramatrix[10]>*0.001;
  text {
      ttf "Arial.ttf" 
      Text
      1 0 scale scal
      texture {
        pigment { rgb col } 
        finish { ambient 1 diffuse 0 }
      }
      popTmatrix4(cameramatrix,T)
  }
#end



// ************************* Moon's Label *******************************
#if (PlanetLabels)
  #local vl = vlength(Lunar_v-campos)/100;

  #local camup = <cameramatrix[4],cameramatrix[5],cameramatrix[6]>;
  //#local E = vnormalize(Lunar_v-campos);
  //#local R = vnormalize(vcross(camup,E)); //<0,1,0>
  //#local U = vnormalize(vcross(E,R));
  //popmatrix(R,U,E,U*(0.2724/10)+Lunar_v)
  
  Drawtext3D(1,<vl*FontSize,vl*FontSize,0.000001>,-camup*(0.2724/9)+Lunar_v,plabels[11])
  //popTmatrix4(cameramatrix,-camup*(0.2724/9)+Lunar_v)
#end