#macro round(f,n)
  #local c = floor(pow(10.0,n));
  #local dd = 0.5 / c;
  #local dd = dd + abs(f);
  #local dd = dd * c;

  #local dd=floor(dd);
  #local dd = dd/c;
  #if (f < 0.0) #local dd = dd * -1; #end
  (dd)
#end

//////////////////////////////////////////////////////////////// ********************  TimeZone
#declare DST = 1;
#declare TimeZone = 6-DST;  // inlcude DST
#macro julian(Y,M,D)
  #if (M < 3)
    #local Y = Y - 1;
    #local M = M + 12;
  #end
  #local A = floor(Y / 100.0);
  #local B = 2 - A + floor(A / 4.0);
  #local J = floor(365.25 * (Y + 4716.0)) + floor(30.6001 * (M + 1)) + D + B - 1524.5;
  #local H = val(date("%H"))+TimeZone;
  #local M = val(date("%M"));
  #local S = val(date("%S"));
  #local J = J + ((H*3600 + M*60 + S)/86400);
  J
#end


#macro j2ctime(j)
  #local c = j - 2440587.5;
  #local c = c * 86400;
  round(c,0)
#end


/////////////////////////////////////////////////////////////// AutoDate  MegaPov
#version unofficial MegaPov 1.21;
#declare JulianDate = julian(val(date("%Y")),val(date("%m")),val(date("%d")));
#declare ctime = j2ctime(JulianDate);