#macro LunarPos(JD,Long,Lat,Rad)
  //double Lp, Lpr, D, Dr, M, Mr, Mp, Mpr, F, Fr, A1, A2, A3, E;
  //double T, T2, T3, T4, sumL, sumB, sumR;

  #local sumL = 0.0; #local sumB = 0.0; #local sumR = 0.0;
  #local T = (JD - 2451545.0) / 36525.0;
  #local T2 = T * T;
  #local T3 = T * T2;
  #local T4 = T3 * T;

  /* Compute moon's mean longitude <Lp>, in degrees */
  #local Lp = 218.3164591 + (481267.88134236 * T) - (0.0013268 * T2) +
  (T3 / 538841.0) - (T4 / 65194000);
  #while (Lp > 360.0) #local Lp = Lp-360.0; #end
  #while (Lp < 0.0) #local Lp = Lp+360.0; #end
  #local Lpr = deg2rad(Lp);      /* Create radians version for trig functions below */

  /* Mean elongation of the moon <D>, in degrees */
  #local D = 297.8502042 + (445267.1115168 * T) - (0.0016300 * T2) +
  (T3 / 545868.0) - (T4 / 113065000.0);
  #while (D > 360.0) #local D = D-360.0; #end
  #while (D < 0.0) #local D = D+360.0; #end
  #local Dr = deg2rad(D);

  /* Sun's mean anomaly <M>, in degrees */
  #local M = 357.5291092 + (35999.0502909 * T) - (0.0001536 * T2) +
  (T3 / 24490000.0);
  #while (M > 360.0) #local M = M-360.0; #end
  #while (M < 0.0) #local M = M+360.0; #end
  #local Mr = deg2rad(M);

  /* Moon's mean anomaly <Mp>, in degrees */
  #local Mp = 134.9634114 + (477198.8676313 * T) + (0.0089970 * T2) +
  (T3 / 69699.0) - (T4 / 14712000.0);
  #while (Mp > 360.0) #local Mp = Mp-360.0; #end
  #while (Mp < 0.0) #local Mp = Mp+360.0; #end
  #local Mpr = deg2rad(Mp);

  /* Moon's argument of latitude <F> */
  #local F = 93.2720993 + (483202.0175273 * T) - (0.0034029 * T2) -
  (T3 / 3526000.0) + (T4 / 863310000.0);
  #while (F > 360.0) #local F = F-360.0; #end
  #while (F < 0.0) #local F = F+360.0; #end
  #local Fr = deg2rad(F);

  #local A1 = 119.75 + (131.849 * T);
  #while (A1 > 360.0) #local A1 = A1-360.0; #end
  #while (A1 < 0.0) #local A1 = A1+360.0; #end

  #local A2 = 53.09 + (479264.290 * T);
  #while (A2 > 360.0) #local A2 = A2-360.0; #end
  #while (A2 < 0.0) #local A2 = A2+360.0; #end

  #local A3 = 313.45 + (481266.484 * T);
  #while (A3 > 360.0) #local A3 = A3-360.0; #end
  #while (A3 < 0.0) #local A3 = A3+360.0; #end

  #local E = 1.0 - (0.002516 * T) - (0.0000074 * T2);

  #local A1 = deg2rad(A1);
  #local A2 = deg2rad(A2);
  #local A3 = deg2rad(A3);

  #local sumL = sumL + 6288774 * sin(Mpr);
  #local sumL = sumL + 1274027 * sin(2.0 * Dr - Mpr);
  #local sumL = sumL + 658314 * sin(2.0 * Dr);
  #local sumL = sumL + 213618 * sin(2.0 * Mpr);
  #local sumL = sumL + (-185116 * sin(Mr)) * E;
  #local sumL = sumL + -114332 * sin(2.0 * Fr);
  #local sumL = sumL + 58793 * sin(2.0 * Dr - 2.0 * Mpr);
  #local sumL = sumL + (57066 * sin(2.0 * Dr - Mr - Mpr)) * E;
  #local sumL = sumL + 53322 * sin(2.0 * Dr + Mpr);
  #local sumL = sumL + (45758 * sin(2.0 * Dr - Mr)) * E;
  #local sumL = sumL + (-40923 * sin(Mr - Mpr)) * E;
  #local sumL = sumL + -34720 * sin(Dr);
  #local sumL = sumL + (-30383 * sin(Mr + Mpr)) * E;
  #local sumL = sumL + 15327 * sin(2.0 * Dr - 2.0 * Fr);
  #local sumL = sumL + -12528 * sin(Mpr + 2.0 * Fr);
  #local sumL = sumL + 10980 * sin(Mpr - 2.0 * Fr);
  #local sumL = sumL + 10675 * sin(4.0 * Dr - Mpr);
  #local sumL = sumL + 10034 * sin(3.0 * Mpr);
  #local sumL = sumL + 8548 * sin(4.0 * Dr - 2.0 * Mpr);
  #local sumL = sumL + (-7888 * sin(2.0 * Dr + Mr - Mpr)) * E;
  #local sumL = sumL + (-6766 * sin(2.0 * Dr + Mr)) * E;
  #local sumL = sumL + -5163 * sin(Dr - Mpr);
  #local sumL = sumL + (4987 * sin(Dr + Mr)) * E;
  #local sumL = sumL + (-4036 * sin(2.0 * Dr - Mr + Mpr)) * E;
  #local sumL = sumL + 3994 * sin(2.0 * Dr + 2.0 * Mpr);
  #local sumL = sumL + 3861 * sin(4.0 * Dr);
  #local sumL = sumL + 3665 * sin(2.0 * Dr - 3.0 * Mpr);
  #local sumL = sumL + (-2689 * sin(Mr - 2.0 * Mpr)) * E;
  #local sumL = sumL + -2602 * sin(2.0 * Dr - Mpr + 2.0 * Fr);
  #local sumL = sumL + (2390 * sin(2.0 * Dr - Mr - 2.0 * Mpr)) * E;
  #local sumL = sumL + -2348 * sin(Dr + Mpr);
  #local sumL = sumL + (2236 * sin(2.0 * Dr - 2.0 * Mr)) * E * E;
  #local sumL = sumL + (-2120 * sin(Mr + 2.0 * Mpr)) * E;
  #local sumL = sumL + (-2069 * sin(2.0 * Mr)) * E * E;
  #local sumL = sumL + (2048 * sin(2.0 * Dr - 2.0 * Mr - Mpr)) * E * E;
  #local sumL = sumL + -1773 * sin(2.0 * Dr + Mpr - 2.0 * Fr);
  #local sumL = sumL + -1595 * sin(2.0 * Dr + 2.0 * Fr);
  #local sumL = sumL + (1215 * sin(4.0 * Dr - Mr - Mpr)) * E;
  #local sumL = sumL + -1110 * sin(2.0 * Mpr + 2.0 * Fr);
  #local sumL = sumL + -892 * sin(3.0 * Dr - Mpr);
  #local sumL = sumL + (-810 * sin(2.0 * Dr + Mr + Mpr)) * E;
  #local sumL = sumL + (759 * sin(4.0 * Dr - Mr - 2.0 * Mpr)) * E;
  #local sumL = sumL + (-713 * sin(2.0 * Mr - Mpr)) * E * E;
  #local sumL = sumL + (-700 * sin(2.0 * Dr + 2.0 * Mr - Mpr)) * E * E;
  #local sumL = sumL + (691 * sin(2.0 * Dr + Mr - 2.0 * Mpr)) * E;
  #local sumL = sumL + (596 * sin(2.0 * Dr - Mr - 2.0 * F)) * E;
  #local sumL = sumL + 549 * sin(4.0 * Dr + Mpr);
  #local sumL = sumL + 537 * sin(4.0 * Mpr);
  #local sumL = sumL + (520 * sin(4.0 * Dr - Mr)) * E;
  #local sumL = sumL + -487 * sin(Dr - 2.0 * Mpr);
  #local sumL = sumL + (-399 * sin(2.0 * Dr + Mr - 2.0 * Fr)) * E;
  #local sumL = sumL + -381 * sin(2.0 * Mpr - 2.0 * Fr);
  #local sumL = sumL + (351 * sin(Dr + Mr + Mpr)) * E;
  #local sumL = sumL + -340 * sin(3.0 * Dr - 2.0 * Mpr);
  #local sumL = sumL + 330 * sin(4.0 * Dr - 3.0 * Mpr);
  #local sumL = sumL + (327 * sin(2.0 * Dr - Mr + 2.0 * Mpr)) * E;
  #local sumL = sumL + (-323 * sin(2.0 * Mr + Mpr)) * E * E;
  #local sumL = sumL + (299 * sin(Dr + Mr - Mpr)) * E;
  #local sumL = sumL + 294 * sin(2.0 * Dr + 3.0 * Mpr);
  #local sumL = sumL + 3958 * sin(A1);
  #local sumL = sumL + 1962 * sin(Lpr - Fr);
  #local sumL = sumL + 318 * sin(A2);
  #local Long = Lp + (sumL / 1E6);
  #while (Long > 360.0) Long = Long-360.0; #end
  #while (Long < 0.0) Long = Long+360.0; #end

  #local sumB =  sumB + 5128122 * sin(Fr);
  #local sumB =  sumB + 280602 * sin(Mpr + Fr);
  #local sumB =  sumB + 277693 * sin(Mpr - Fr);
  #local sumB =  sumB + 173237 * sin(2.0 * Dr - Fr);
  #local sumB =  sumB + 55413 * sin(2.0 * Dr - Mpr + Fr);
  #local sumB =  sumB + 46271 * sin(2.0 * Dr - Mpr - Fr);
  #local sumB =  sumB + 32573 * sin(2.0 * Dr + Fr);
  #local sumB =  sumB + 17198 * sin(2.0 * Mpr + Fr);
  #local sumB =  sumB + 9266 * sin(2.0 * Dr + Mpr - Fr);
  #local sumB =  sumB + 8822 * sin(2.0 * Mpr - Fr);
  #local sumB =  sumB + (8216 * sin(2.0 * Dr - Mr - Fr)) * E;
  #local sumB =  sumB + 4324 * sin(2.0 * Dr - 2.0 * Mpr - Fr);
  #local sumB =  sumB + 4200 * sin(2.0 * Dr + Mpr + Fr);
  #local sumB =  sumB + (-3359 * sin(2.0 * Dr + Mr - Fr)) * E;
  #local sumB =  sumB + (2463 * sin(2.0 * Dr - Mr - Mpr + Fr)) * E;
  #local sumB =  sumB + (2211 * sin(2.0 * Dr - Mr + Fr)) * E;
  #local sumB =  sumB + (2065 * sin(2.0 * Dr - Mr - Mpr - Fr)) * E;
  #local sumB =  sumB + (-1870 * sin(Mr - Mpr - Fr)) * E;
  #local sumB =  sumB + 1828 * sin(4.0 * Dr - Mpr - Fr);
  #local sumB =  sumB + (-1794 * sin(Mr + Fr)) * E;
  #local sumB =  sumB + -1749 * sin(3.0 * Fr);
  #local sumB =  sumB + (-1565 * sin(Mr - Mpr - Fr)) * E;
  #local sumB =  sumB + -1491 * sin(Dr - Fr);
  #local sumB =  sumB + (-1475 * sin(Mr + Mpr + Fr)) * E;
  #local sumB =  sumB + (-1410 * sin(Mr + Mpr - Fr)) * E;
  #local sumB =  sumB + (-1344 * sin(Mr - Fr)) * E;
  #local sumB =  sumB + -1335 * sin(Dr - Fr);
  #local sumB =  sumB + 1107 * sin(3.0 * Mpr + Fr);
  #local sumB =  sumB + 1021 * sin(4.0 * Dr - Fr);
  #local sumB =  sumB + 833 * sin(4.0 * Dr - Mpr + Fr);
  #local sumB =  sumB + 777 * sin(Mpr - 3.0 * Fr);
  #local sumB =  sumB + 671 * sin(4.0 * Dr - 2.0 * Mpr + Fr);
  #local sumB =  sumB + 607 * sin(2.0 * Dr - 3.0 * Fr);
  #local sumB =  sumB + 596 * sin(2.0 * Dr + 2.0 * Mpr - Fr);
  #local sumB =  sumB + (491 * sin(2.0 * Dr - Mr + Mpr - Fr)) * E;
  #local sumB =  sumB + -451 * sin(2.0 * Dr - 2.0 * Mpr + Fr);
  #local sumB =  sumB + 439 * sin(3.0 * Mpr - Fr);
  #local sumB =  sumB + 422 * sin(2.0 * Dr + 2.0 * Mpr + Fr);
  #local sumB =  sumB + 421 * sin(2.0 * Dr - 3.0 * Mpr - Fr);
  #local sumB =  sumB + (-366 * sin(2.0 * Dr + Mr - Mpr + Fr)) * E;
  #local sumB =  sumB + (-351 * sin(2.0 * Dr + Mr + Fr)) * E;
  #local sumB =  sumB + 331 * sin(4.0 * Dr + Fr);
  #local sumB =  sumB + (315 * sin(2.0 * Dr - Mr + Mpr + Fr)) * E;
  #local sumB =  sumB + (302 * sin(2.0 * Dr - 2.0 * Mr - Fr)) * E * E;
  #local sumB =  sumB + -283 * sin(Mpr + 3.0 * Fr);
  #local sumB =  sumB + (-229 * sin(2.0 * Dr + Mr + Mpr - Fr)) * E;
  #local sumB =  sumB + (223 * sin(Dr + Mr - Fr)) * E;
  #local sumB =  sumB + (223 * sin(Dr + Mr + Fr)) * E;
  #local sumB =  sumB + (-220 * sin(Mr - 2.0 * Mpr - Fr)) * E;
  #local sumB =  sumB + (-220 * sin(2.0 * Dr + Mr - Mpr - Fr)) * E;
  #local sumB =  sumB + -185 * sin(Dr + Mpr + Fr);
  #local sumB =  sumB + (181 * sin(2.0 * Dr - Mr - 2.0 * Mpr - Fr)) * E;
  #local sumB =  sumB + (-177 * sin(Mr + 2.0 * Mpr + Fr)) * E;
  #local sumB =  sumB + 176 * sin(4.0 * Dr - 2.0 * Mpr - Fr);
  #local sumB =  sumB + (166 * sin(4.0 * Dr - Mr - Mpr - Fr)) * E;
  #local sumB =  sumB + -164 * sin(Dr + Mpr - Fr);
  #local sumB =  sumB + 132 * sin(4.0 * Dr + Mpr - Fr);
  #local sumB =  sumB + -119 * sin(Dr - Mpr - Fr);
  #local sumB =  sumB + (115 * sin(4.0 * Dr - Mr - Fr)) * E;
  #local sumB =  sumB + (107 * sin(2.0 * Dr - 2.0 * Mr + Fr)) * E;
  #local sumB =  sumB + (-2235 * sin(Lpr));
  #local sumB =  sumB + 382 * sin(A3);
  #local sumB =  sumB + 175 * sin(A1 - Fr);
  #local sumB =  sumB + 175 * sin(A1 + Fr);
  #local sumB =  sumB + 127 * sin(Lpr - Mpr);
  #local sumB =  sumB + -115 * sin(Lpr + Mpr);
  #local Lat = sumB / 1E6;
  #while (Lat > 360.0) Lat = Lat-360.0; #end
  #while (Lat < -360.0) Lat = Lat+360.0; #end

  #local sumR =  sumR + -20905355 * cos(Mpr);
  #local sumR =  sumR + -3699111 * cos(2.0 * Dr - Mpr);
  #local sumR =  sumR + -2955968 * cos(2.0 * Dr);
  #local sumR =  sumR + -569925 * cos(2.0 * Mpr);
  #local sumR =  sumR + (48888 * cos(Mr)) * E;
  #local sumR =  sumR + -3149 * cos(2.0 * Fr);
  #local sumR =  sumR + 246158 * cos(2.0 * Dr - 2.0 * Mpr);
  #local sumR =  sumR + (-152138 * cos(2.0 * Dr - Mr - Mpr)) * E;
  #local sumR =  sumR + -170733 * cos(2.0 * Dr + Mpr);
  #local sumR =  sumR + (-204586 * cos(2.0 * Dr - Mr)) * E;
  #local sumR =  sumR + (-129620 * cos(Mr - Mpr)) * E;
  #local sumR =  sumR + 108743 * cos(Dr);
  #local sumR =  sumR + (104755 * cos(Mr + Mpr)) * E;
  #local sumR =  sumR + 10321 * cos(2.0 * Dr - 2.0 * Fr);
  #local sumR =  sumR + 79661 * cos(Mpr - 2.0 * Fr);
  #local sumR =  sumR + -34782 * cos(4.0 * Dr - Mpr);
  #local sumR =  sumR + -23210 * cos(3.0 * Mpr);
  #local sumR =  sumR + -21636 * cos(4.0 * Dr - 2.0 * Mpr);
  #local sumR =  sumR + (24208 * cos(2.0 * Dr + Mr - Mpr)) * E;
  #local sumR =  sumR + (30824 * cos(2.0 * Dr + Mr)) * E;
  #local sumR =  sumR + -8379 * cos(Dr - Mpr);
  #local sumR =  sumR + (-16675 * cos(Dr + Mr)) * E;
  #local sumR =  sumR + (-12831 * cos(2.0 * Dr - Mr + Mpr)) * E;
  #local sumR =  sumR + -10445 * cos(2.0 * Dr + 2.0 * Mpr);
  #local sumR =  sumR + -11650 * cos(4.0 * Dr);
  #local sumR =  sumR + 14403 * cos(2.0 * Dr - 3.0 * Mpr);
  #local sumR =  sumR + (-7003 * cos(Mr - 2.0 * Mpr)) * E;
  #local sumR =  sumR + (10056 * cos(2.0 * Dr - Mr - 2.0 * Mpr)) * E;
  #local sumR =  sumR + 6322 * cos(Dr + Mpr);
  #local sumR =  sumR + (-9884 * cos(2.0 * Dr - 2.0 * Mr)) * E * E;
  #local sumR =  sumR + (5751 * cos(Mr + 2.0 * Mpr)) * E;
  #local sumR =  sumR + (-4950 * cos(2.0 * Dr - 2.0 * Mr - Mpr)) * E * E;
  #local sumR =  sumR + 4130 * cos(2.0 * Dr + Mpr - 2.0 * Fr);
  #local sumR =  sumR + (-3958 * cos(4.0 * Dr - Mr - Mpr)) * E;
  #local sumR =  sumR + 3258 * cos(3.0 * Dr - Mpr);
  #local sumR =  sumR + (2616 * cos(2.0 * Dr + Mr + Mpr)) * E;
  #local sumR =  sumR + (-1897 * cos(4.0 * Dr - Mr - 2.0 * Mpr)) * E;
  #local sumR =  sumR + (-2117 * cos(2.0 * Mr - Mpr)) * E * E;
  #local sumR =  sumR + (2354 * cos(2.0 * Dr + 2.0 * Mr - Mpr)) * E * E;
  #local sumR =  sumR + -1423 * cos(4.0 * Dr + Mpr);
  #local sumR =  sumR + -1117 * cos(4.0 * Mpr);
  #local sumR =  sumR + (-1571 * cos(4.0 * Dr - Mr)) * E;
  #local sumR =  sumR + -1739 * cos(Dr - 2.0 * Mpr);
  #local sumR =  sumR + -4421 * cos(2.0 * Mpr - 2.0 * Fr);
  #local sumR =  sumR + (1165 * cos(2.0 * Mr + Mpr)) * E * E;
  #local sumR =  sumR + 8752 * cos(2.0 * Dr - Mpr - 2.0 * Fr);
  #local Rad = 385000.56 + (sumR / 1000.0);  /* Center of Earth to center of Moon in kilometers */
  //#local Rad = Rad/1.6093472;/* Return distance in Earth miles */
  //Rad = Rad/ 6378.1370;/* Return distance in Earth radii */
  #local Long = deg2rad(Long);
  #local Lat = deg2rad(Lat);
  pop_matrix4(orbitmatrix,radians2pos(Long,Lat)*Rad)
#end

  
#declare MoonMap =
material {
   texture {
      pigment {
         image_map {
            jpeg   "moon.jpg"
            map_type 1
            once
            interpolate 2
         }
         scale <1,1,1>
      }
      normal {
         bump_map {
            jpeg   "moonbump1k.jpg"
            map_type 1
            once
            interpolate 2
         }
         scale <1,1,1>
         bump_size 1.0
      }
      finish {
         ambient 0.0
         diffuse 1
         specular 0
      }
   }
}