// planets radiosity.inc
/*
global_settings{
 assumed_gamma 0.7
 max_trace_level 12
} */

global_settings {
  max_trace_level 10
  assumed_gamma 1.0
  adc_bailout 1/256
  // for HDR image file creation adc_bailout 1/1e6 = 0.000001
  
  // global setting adc_bailout keyword followed by float value to specify
  // the point at which a ray's contribution is considered insignificant
  // The default value is 1/255, or approximately 0.0039, since a change smaller than that could not be visible in a 24 bit image.
  // Setting adc_bailout to 0 will disable ADC

  radiosity {
    // controls radiosity pre-trace gathering step
    pretrace_start 0.08 //default 0.08 
    pretrace_end 0.01   // default 0.04
    //range 0.0 and 1.0 which specifies the size of the blocks in the
    // mosaic_preview as a percentage of the image size
    
    count 40 // The integer number of rays that are sent out whenever a new radiosity value has to be calculated is given by count.
    // A value of 35 is the default, the maximum is 1600.
    // When this value is too low, the light level will tend to look a little bit blotchy, as if the surfaces were 
    // slightly warped. If this is not important to your scene (as in the case that you have a bump map or if you have a strong texture)
    // then by all means use a lower number. 
    
    // minimum number of old ambient values blended together to create a new interpolated value. The total number blended will 
    // vary depending on error_bound. All previous values that fit within the specified error_bound will be used in the average. 
    nearest_count 8
    // lower than 4, things can get pretty patchy. Must be no more than 20, since that is the size of the array allocated.
    // default 5 

    error_bound 1.5  // default 1.8 is good for a smooth general lighting effect.
    // Lower values are more accurate, but will strongly increase the danger of artifacts
    // and therefore require higher count. You can use values even lower than 0.1 but both render time and memory
    // use can become extremely high then. 

    recursion_limit 3   // default 3
    // recursion levels are used to calculate the diffuse inter-reflection

    low_error_factor .5
    // The low_error_factor is a float tuning value which sets the amount that the error bound is dropped during the preliminary image passes. If your low error factor is 0.8 and your error bound is set to 0.4 it will really use an error bound of 0.32 during the first passes and 0.4 on the final pass.
    // default 0.5
     
    gray_threshold 0.01
    // The gray_threshold float value grays it down a little, to make your scene more believable. A value of .6 means to calculate the ambient
    // value as 60% of the equivalent gray value calculated, plus 40% of the actual value calculated. At 0%, this feature does nothing. At 100%, you always get white/gray ambient light, with no hue. 
    // default 0.0
    
    minimum_reuse 0.0095
    // This sets a minimum bound for the reuse. If this value is too low, (which it should be in theory) rendering gets slow, and inside corners can get a little grainy.
    // If it is set too high, you do not get the natural darkening of illumination near inside edges, since it reuses. At values higher than 2% you start getting more just plain errors, like reusing the illumination of the open table underneath the apple. Remember that this is a unit less ratio. 
    // default 0.015.
    
    brightness 1.0 // default 1.0
    // specifies a float value 
    // ambient_light in a non-Radiosity scene    //default <1,1,1>

    // Megapov 1.1
    // randomize on
    
    // Radiosity estimation affected by normals
    normal on
    media on
  }
}