//*PMRawBegin
#include "colors.inc"
#include "textures.inc"


background {rgb <0.054902, 0.21961,0.4>}
//*PMRawEnd

#declare figur1 = union {
   cone {
      <0, 0.5, 0>, 0.15,
      <0, -0.5, 0>, 0.5
   }
   
   sphere {
      <0, 0, 0>, 0.35
      translate y*0.7
   }
   
   pigment {
      color rgb <1.2, 1.2, 1.2>
   }
   
   finish {
      conserve_energy
      
      reflection {
         rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
      }
   }
}

#declare figur2 = union {
   cone {
      <0, 0.5, 0>, 0.15,
      <0, -0.5, 0>, 0.5
   }
   
   sphere {
      <0, 0, 0>, 0.35
      translate y*0.7
   }
   
   pigment {
      color rgb <0, 0, 0>
   }
   
   finish {
      conserve_energy
      
      reflection {
         rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
      }
   }
}

#declare figur3 = union {
   cone {
      <0, 0.5, 0>, 0.15,
      <0, -0.5, 0>, 0.5
   }
   
   sphere {
      <0, 0, 0>, 0.35
      translate y*0.7
   }
   
   pigment {
      planar
      turbulence <2, 4, 6>
      octaves 0
      omega 3
      lambda 0
      //*PMRawBegin
      color_map {
      [0.00 color rgbt <1, 1.0, 0.0, 0>]
      [0.25 color rgbt <0.5, 0.0, 0, 0>]
      [0.50 color rgbt <1.0, 0.0, 0, 0>]
      [0.50 color rgbt <1.0, 0.0, 1, 0>]
      [0.75 color rgbt <1.0, 0.5, 0, 0>]
      [1.00 color rgbt <1.0, 1.0, 0.5, 0>]
      }
      //*PMRawEnd
      scale 0.2
   }
   //*PMRawBegin
   /*
    normal { 
     crackle 2 frequency 100 //scale 0.2
   
    }
   */
   
   //*PMRawEnd
   
   finish {
      conserve_energy
      
      reflection {
         rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
      }
   }
}

#declare kerbe2 = union {
   torus {
      0.1, 0.025
      translate y*0.61
   }
   
   box {
      <-0.015, 0.025, -0.103>, <0.015, -0.025, 0.103>
      translate y*0.61
   }
}

#declare kerbe3 = superellipsoid {
   <0.25, 0.25>
   scale 0.35
}

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 256
   noise_generator 2
}

plane {
   <0, 1, 0>, 0
   
   texture {
      uv_mapping
      //*PMRawBegin
      Chrome_Metal
      
      //*PMRawEnd
      
      finish {
         roughness 0.05
         crand 0.025
      }
   }
   translate y*(-1.1)
   no_reflection
}

fog {
   fog_type 2
   distance 100
    rgb <0.054902, 0.219608, 0.4> 
   fog_offset 0.5
   fog_alt 1
   up <0, 1, 0>
}

union {
   //*PMName raeder
   
   difference {
      //*PMName Rad links
      
      merge {
         //*PMName Tab
         
         cone {
            <0, 0.6, 0>, 1.4,
            <0, 0.5, 0>, 1.5
         }
         
         cylinder {
            <0, 0.5, 0>, <0, -0.5, 0>, 1.5
         }
         
         cone {
            <0, -0.5, 0>, 1.5,
            <0, -0.6, 0>, 1.4
         }
      }
      
      union {
         //*PMRawBegin
         #declare ticker =1;
         #while (ticker<13)
           object {kerbe2 translate -1.2*z 
           rotate 30*ticker*y}
           #declare ticker= ticker+1;
         #end
         //*PMRawEnd
         rotate y*15
      }
      
      union {
         //*PMRawBegin
         #declare ticker =1;
         #while (ticker<13)
           object {kerbe3 translate -1.6*z 
           rotate 30*ticker*y}
           #declare ticker= ticker+1;
         #end
         //*PMRawEnd
      }
      
      texture {
         //*PMRawBegin
         Starfield scale 0.5
         //*PMRawEnd
      }
      
      finish {
         //*PMRawBegin
         Dull
         //*PMRawEnd
         crand 0.025
      }
      scale 1.5
      translate x*(-4.5)
   }
   
   difference {
      //*PMName Rad rechts
      
      merge {
         //*PMName Tab
         
         cone {
            <0, 0.6, 0>, 1.4,
            <0, 0.5, 0>, 1.5
         }
         
         cylinder {
            <0, 0.5, 0>, <0, -0.5, 0>, 1.5
         }
         
         cone {
            <0, -0.5, 0>, 1.5,
            <0, -0.6, 0>, 1.4
         }
      }
      
      union {
         //*PMRawBegin
         #declare ticker =1;
         #while (ticker<13)
           object {kerbe2 translate -1.2*z 
           rotate 30*ticker*y}
           #declare ticker= ticker+1;
         #end
         //*PMRawEnd
         rotate y*15
      }
      
      union {
         //*PMRawBegin
         #declare ticker =1;
         #while (ticker<13)
           object {kerbe3 translate -1.6*z 
           rotate 30*ticker*y}
           #declare ticker= ticker+1;
         #end
         //*PMRawEnd
      }
      
      texture {
         //*PMRawBegin
         Starfield scale 0.5
         //*PMRawEnd
      }
      
      finish {
         //*PMRawBegin
         Dull
         //*PMRawEnd
         crand 0.025
      }
      scale 1.5
      translate x*4.5
   }
   
   union {
      //*PMName Hammer links
      
      union {
         //*PMName Halter
         
         union {
            prism {
               linear_spline
               linear_sweep
               0, 0.2,
               7,
               <0.5, 1>, <1, 0>, <1.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
               scale <0.6, 1, 0.6>
               rotate x*(-90)
               translate z*0.5
            }
            
            prism {
               linear_spline
               linear_sweep
               0, 0.2,
               7,
               <0.5, 1>, <1, 0>, <1.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
               scale <0.6, 1, 0.6>
               rotate x*(-90)
               translate z*(-0.5)
            }
            
            texture {
               //*PMRawBegin
               Starfield scale 0.5
               //*PMRawEnd
            }
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
               crand 0.025
            }
            rotate y*180
            translate <-3.6255, 1.5, -0.2>
         }
         //*PMRawBegin
          object {kerbe2 
          rotate x*90
          translate <-3.66,1.5,-1.3>
         }
         //*PMRawEnd
      }
      
      union {
         cylinder {
            <0, 4, 0>, <0, -2.1, 0>, 0.225
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
               roughness 0.5
               crand 0.5
            }
            scale 1
            rotate z*(-90)
            translate <2.5514, 0.45, 0>
         }
         
         difference {
            cylinder {
               <0, 0.4, 0>, <0, -0.5, 0>, 0.5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            torus {
               0.5, 0.25
               scale 1
               rotate <0, 0, 0>
               translate y*0.2
            }
            
            sphere {
               <0, 0, 0>, 0.65
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
               inverse
            }
            rotate x*180
            translate y*0.875
         }
         
         box {
            <-0.4, 0.25, -0.5>, <0.4, 0.825, 0.5>
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.1)
         }
         
         difference {
            cylinder {
               <0, 0.4, 0>, <0, -0.5, 0>, 0.5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            torus {
               0.5, 0.25
               scale 1
               rotate <0, 0, 0>
               translate y*0.2
            }
            
            sphere {
               <0, 0, 0>, 0.65
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
               inverse
            }
            translate y*(-0.1)
         }
         
         finish {
            //*PMRawBegin
            Dull
            //*PMRawEnd
         }
         scale 0.7
         rotate <0, 180, 10.5>
         translate <-1.3, 1.6, -0.1>
      }
   }
   
   union {
      //*PMName Hammer rechts
      
      difference {
         //*PMName Halter
         
         union {
            prism {
               linear_spline
               linear_sweep
               0, 0.2,
               7,
               <0.5, 1>, <1, 0>, <1.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
               scale <0.6, 1, 0.6>
               rotate x*(-90)
               translate z*0.5
            }
            
            prism {
               linear_spline
               linear_sweep
               0, 0.2,
               7,
               <0.5, 1>, <1, 0>, <1.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
               scale <0.6, 1, 0.6>
               rotate x*(-90)
               translate z*(-0.5)
            }
            
            texture {
               //*PMRawBegin
               Starfield scale 0.5
               //*PMRawEnd
            }
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
               crand 0.025
            }
            translate <3.6255, 1.5, 0>
         }
         //*PMRawBegin
          object {kerbe2 
          rotate x*90
          translate <3.66,1.5,-1.3>
         }
         //*PMRawEnd
      }
      
      union {
         cylinder {
            <0, 4, 0>, <0, -2.1, 0>, 0.225
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
               roughness 0.5
               crand 0.5
            }
            scale 1
            rotate z*(-90)
            translate <2.5514, 0.45, 0>
         }
         
         difference {
            cylinder {
               <0, 0.4, 0>, <0, -0.5, 0>, 0.5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            torus {
               0.5, 0.25
               scale 1
               rotate <0, 0, 0>
               translate y*0.2
            }
            
            sphere {
               <0, 0, 0>, 0.65
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
               inverse
            }
            rotate x*180
            translate y*0.875
         }
         
         box {
            <-0.4, 0.25, -0.5>, <0.4, 0.825, 0.5>
            scale 1
            rotate <0, 0, 0>
            translate y*(-0.1)
         }
         
         difference {
            cylinder {
               <0, 0.4, 0>, <0, -0.5, 0>, 0.5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            torus {
               0.5, 0.25
               scale 1
               rotate <0, 0, 0>
               translate y*0.2
            }
            
            sphere {
               <0, 0, 0>, 0.65
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
               inverse
            }
            translate y*(-0.1)
         }
         
         finish {
            //*PMRawBegin
            Dull
            //*PMRawEnd
         }
         scale 0.7
         rotate z*(-10.5)
         translate <1.3, 1.6, -0.1>
      }
   }
}

union {
   //*PMName Band rechts
   
   box {
      <-1.4, 0, -6.5>, <0.75, 0.1, 1000>
      
      pigment {
         color rgb <0.8, 0, 0>
      }
      
      finish {
         //*PMRawBegin
         Dull
         //*PMRawEnd
      }
      translate <1.5, -1.05, 0>
      no_reflection
   }
   //*PMRawBegin
   #declare ticker =1;
   #while (ticker<200)
     object {figur1 
     translate x*1.2
     translate y*-0.5
     translate z*-8
     translate z*8*ticker
    }
     #declare ticker= ticker+1;
   #end
   object {figur3
     translate x*1.2
     translate y*-0.5
     translate z*-5
   }
   //*PMRawEnd
}

union {
   //*PMName Band links
   
   box {
      <-0.75, 0, -6.5>, <1.4, 0.1, 1000>
      
      pigment {
         color rgb <0.8, 0, 0>
      }
      
      finish {
         //*PMRawBegin
         Dull
         //*PMRawEnd
      }
      translate <-1.5, -1.05, 0>
      no_reflection
   }
   //*PMRawBegin
   #declare ticker =1;
   #while (ticker<200)
     object {figur2 
     translate -x*1.2
     translate y*-0.5
     translate z*-8
     translate z*8*ticker
    }
     #declare ticker= ticker+1;
   #end
   object {figur3
     rotate y*90
     translate -x*1.2
     translate y*-0.5
     translate z*-5.5
   
   
     
   }
   //*PMRawEnd
}

union {
   //*PMName Wand
   
   merge {
      box {
         //*PMName Mauer
         <-2, -0.5, -0.05>, <2, 1.5, 0.05>
         
         pigment {
            brick
            brick_size <0.15, 0.075, 0.125>
            mortar 0.01
         }
         
         normal {
            wrinkles
            0.75
            scale 0.01
         }
         
         finish {
            ambient rgbft <0.15, 0.15, 0.15, 0.15, 0.15>
            diffuse 0.85
            phong 0.2
         }
         scale <9, 5, 5>
         no_shadow
         hollow false
      }
      hollow false
      inverse
   }
   scale <4, 4, 1.5>
   translate <0, 9.1, 550>
}

light_source {
   <1.5, 8, -11>, rgb <1, 1, 1>
}

camera {
   perspective
   location <0, 3.5, -10.6>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 0, 0>
}