//*PMRawBegin
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

background {Black}

//*PMRawEnd

#declare kerbe1 = box {
   <-0.05, -0.601, -0.2>, <0.05, 0.601, 0>
}

#declare kerbe2 = cylinder {
   <0, 0.601, 0>, <0, -0.601, 0>, 0.05
}

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 256
   noise_generator 3
}

union {
   //*PMName Weltraumplattform
   
   union {
      //*PMName Dock
      
      prism {
         linear_spline
         linear_sweep
         -5, 5,
         7,
         <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
         scale <0.5, 0.55, 0.55>
         rotate <90, 0, 90>
         translate x*(-1)
      }
      
      prism {
         linear_spline
         linear_sweep
         -5, 5,
         7,
         <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
         scale 0.5
         rotate <0, 0, 0>
         translate x*(-1)
      }
      
      sphere {
         <0, 0, 0>, 0.85
         scale 1
         rotate <0, 0, 0>
         translate x*(-1)
      }
      
      torus {
         0.8, 0.2
         sturm
         
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            //*PMRawBegin
            Dull
            //*PMRawEnd
         }
         scale <1, 0.6, 1>
         rotate <0, 0, 0>
         translate x*(-1)
         hollow false
         inverse
      }
      
      cylinder {
         <0, 0, 0>, <0, -0.25, 0>, 0.58
         
         pigment {
            color rgb <1, 1, 1>
         }
         
         finish {
            conserve_energy
            
            reflection {
               rgb <0.01, 0.01, 0.01>, rgb <1, 1, 1>
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <-1, -2.5, 0>
      }
      
      cylinder {
         <0, 0, 0>, <0, -0.251, 0>, 0.46
         
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            conserve_energy
            
            reflection {
               rgb <0.01, 0.01, 0.01>, rgb <1, 1, 1>
            }
         }
         scale 1
         rotate <0, 0, 0>
         translate <-1, -2.5, 0>
         hollow
      }
      
      pigment {
         color rgb <1.2, 1.2, 1.2>
      }
   }
   
   merge {
      //*PMName Modulreihe vorn
      
      union {
         //*PMName Modul #1
         
         union {
            //*PMName Korrekturduese
            
            cylinder {
               <0, 0.2, 0>, <0, -0.25, 0>, 0.25
               
               pigment {
                  checker 
                  color rgb <0, 0, 0>
                  color rgb <1, 1, 1>
                  scale 0.5
               }
               scale 1
               rotate x*90
               translate <0, 0.3, -1.1>
            }
            
            cone {
               <0, 0.25, 0>, 0.035,
               <0, -0.25, 0>, 0.13
               open
               
               pigment {
                  color rgb <0.054902, 0.219608, 0.4>
               }
               scale 1
               rotate <0, 0, 0>
               translate z*(-1.25)
            }
            
            cone {
               <0, 0.25, 0>, 0.035,
               <0, -0.25, 0>, 0.12
               open
               
               pigment {
                  color rgb <0.054902, 0.219608, 0.4>
               }
               scale 1
               rotate z*(-90)
               translate <-0.3, 0.3, -1.25>
            }
            
            cone {
               <0, 0.25, 0>, 0.035,
               <0, -0.25, 0>, 0.12
               open
               
               pigment {
                  color rgb <0.054902, 0.219608, 0.4>
               }
               scale 1
               rotate z*180
               translate <0, 0.6, -1.25>
            }
            scale 0.8
            translate <0, 1, -0.13>
            no_shadow
         }
         
         intersection {
            //*PMName tank
            
            cylinder {
               <0, 1.25, 0>, <0, -1.25, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 2.5
               scale <1, 0.5, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            scale <1, 2, 1>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*2.266
         }
         
         cylinder {
            //*PMName Ringe(Mitte)
            <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate <0, 0, 0>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*(-2.266)
         }
         rotate z*90
         translate x*(-5.2)
      }
      
      cylinder {
         //*PMName Zwischenstueck
         <0, 0.5, 0>, <0, -0.5, 0>, 0.4
         
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            conserve_energy
            
            reflection {
               rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
            }
         }
         scale 1
         rotate z*90
         translate x*(-2.6)
      }
      
      union {
         //*PMName Modul #2
         
         intersection {
            //*PMName tank
            
            cylinder {
               <0, 1.25, 0>, <0, -1.25, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 2.5
               scale <1, 0.5, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            scale <1, 2, 1>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*2.266
         }
         
         cylinder {
            //*PMName Ringe(Mitte)
            <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate <0, 0, 0>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*(-2.266)
         }
         rotate z*90
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName Zwischenstueck
         <0, 0.5, 0>, <0, -0.5, 0>, 0.4
         
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            conserve_energy
            
            reflection {
               rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
            }
         }
         scale 1
         rotate z*90
         translate x*2.6
      }
      
      union {
         //*PMName Modul #3
         
         intersection {
            //*PMName tank
            
            cylinder {
               <0, 1.25, 0>, <0, -1.25, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 2.5
               scale <1, 0.5, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            scale <1, 2, 1>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*2.266
         }
         
         cylinder {
            //*PMName Ringe(Mitte)
            <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate <0, 0, 0>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*(-2.266)
         }
         
         cylinder {
            //*PMName esa-Logo
            <0, 0.5, 0>, <0, -0.5, 0>, 1.0001
            open
            
            pigment {
               image_map {
                  png
                  "esa.png"
                  once
                  map_type 0
               }
               rotate z*(-90)
               scale <0.5, 0.5, 1>
               translate <0, 0, 0>
            }
            scale <1, 1, 0.9>
            rotate y*(-20)
            translate <0, -1.4, -0.12>
            no_shadow
            hollow
         }
         rotate z*90
         translate x*5.2
      }
      
      union {
         //*PMName Korrekturduese
         
         cylinder {
            <0, 0.2, 0>, <0, -0.25, 0>, 0.25
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 1>
               scale 0.5
            }
            scale 1
            rotate x*90
            translate <0, 0.3, -1.1>
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate <0, 0, 0>
            translate z*(-1.25)
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate z*(-90)
            translate <-0.3, 0.3, -1.25>
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate z*180
            translate <0, 0.6, -1.25>
         }
         scale 0.8
         translate <0, -6.75, -0.13>
         rotate z*90
         no_shadow
      }
      translate z*(-3)
   }
   
   merge {
      //*PMName Modulreihe hinten
      
      union {
         //*PMName Modul #1
         
         intersection {
            //*PMName tank
            
            cylinder {
               <0, 1.25, 0>, <0, -1.25, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 2.5
               scale <1, 0.5, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            scale <1, 2, 1>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*2.266
         }
         
         cylinder {
            //*PMName Ringe(Mitte)
            <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate <0, 0, 0>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*(-2.266)
         }
         rotate z*90
         translate x*(-5.2)
      }
      
      union {
         //*PMName Korrekturduese
         
         cylinder {
            <0, 0.2, 0>, <0, -0.25, 0>, 0.25
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 1>
               scale 0.5
            }
            scale 1
            rotate x*90
            translate <0, 0.3, -1.1>
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate <0, 0, 0>
            translate z*(-1.25)
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate z*(-90)
            translate <-0.3, 0.3, -1.25>
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate z*180
            translate <0, 0.6, -1.25>
         }
         scale 0.8
         rotate <-179.9, 0, 90>
         translate <-6.7, 0, 0.13>
         no_shadow
      }
      
      cylinder {
         //*PMName Zwischenstueck
         <0, 0.5, 0>, <0, -0.5, 0>, 0.4
         
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            conserve_energy
            
            reflection {
               rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
            }
         }
         scale 1
         rotate z*90
         translate x*(-2.6)
      }
      
      union {
         //*PMName Modul #2
         
         intersection {
            //*PMName tank
            
            cylinder {
               <0, 1.25, 0>, <0, -1.25, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 2.5
               scale <1, 0.5, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            scale <1, 2, 1>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*2.266
         }
         
         cylinder {
            //*PMName Ringe(Mitte)
            <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate <0, 0, 0>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*(-2.266)
         }
         rotate z*90
         translate <0, 0, 0>
      }
      
      cylinder {
         //*PMName Zwischenstueck
         <0, 0.5, 0>, <0, -0.5, 0>, 0.4
         
         pigment {
            color rgb <0, 0, 0>
         }
         
         finish {
            conserve_energy
            
            reflection {
               rgb <0.03, 0.03, 0.03>, rgb <1, 1, 1>
            }
         }
         scale 1
         rotate z*90
         translate x*2.6
      }
      
      union {
         //*PMName Modul #3
         
         intersection {
            //*PMName tank
            
            cylinder {
               <0, 1.25, 0>, <0, -1.25, 0>, 1
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 2.5
               scale <1, 0.5, 1>
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            scale <1, 2, 1>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*2.266
         }
         
         cylinder {
            //*PMName Ringe(Mitte)
            <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate <0, 0, 0>
         }
         
         cylinder {
            //*PMName Aussenring
            <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            translate y*(-2.266)
         }
         rotate z*90
         translate x*5.2
      }
      
      union {
         //*PMName Korrekturduese
         
         cylinder {
            <0, 0.2, 0>, <0, -0.25, 0>, 0.25
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 1>
               scale 0.5
            }
            scale 1
            rotate x*90
            translate <0, 0.3, -1.1>
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate <0, 0, 0>
            translate z*(-1.25)
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate z*(-90)
            translate <-0.3, 0.3, -1.25>
         }
         
         cone {
            <0, 0.25, 0>, 0.035,
            <0, -0.25, 0>, 0.12
            open
            
            pigment {
               color rgb <0.054902, 0.219608, 0.4>
            }
            scale 1
            rotate z*180
            translate <0, 0.6, -1.25>
         }
         scale 0.8
         rotate <-179.9, 0, 90>
         translate <6.2, 0, 0.13>
         no_shadow
      }
      translate z*3
   }
   
   union {
      //*PMName Traeger 1
      
      intersection {
         //*PMName Befestigung
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 1.02
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         box {
            <-1.35, -0.11, -1.0833>, <0.70306, 0.11, 1.0968>
            scale 1
            rotate <0, -45, 90>
            translate <0, 0.17411, 0.188619>
            inverse
         }
         rotate y*180
         translate <-5.025, 0, 3>
      }
      
      cylinder {
         //*PMName Strebe 1
         <0, 2.3, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate x*(-45)
         translate <-5.025, 0.85, 2.2292>
      }
      
      cylinder {
         //*PMName Strebe 2
         <0, 1.5, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <-5.025, 1.09103, 2.55576>
      }
      
      cylinder {
         //*PMName Strebe 3
         <0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <-5.025, 1.09103, 2.55576>
      }
      
      cylinder {
         //*PMName Strebe 4
         <-0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <-5.025, 1.09103, 2.55576>
      }
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      no_shadow
   }
   
   union {
      //*PMName Traeger 2
      
      intersection {
         //*PMName Befestigung
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 1.02
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         box {
            <-1.35, -0.11, -1.0833>, <0.70306, 0.11, 1.0968>
            scale 1
            rotate <0, -45, 90>
            translate <0, 0.17411, 0.188619>
            inverse
         }
         rotate y*180
         translate <0.15, 0, 3>
      }
      
      cylinder {
         //*PMName Strebe 1
         <0, 2.3, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate x*(-45)
         translate <0.15, 0.85, 2.2292>
      }
      
      cylinder {
         //*PMName Strebe 2
         <0, 1.5, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0.15, 1.091, 2.5558>
      }
      
      cylinder {
         //*PMName Strebe 3
         <0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0.15, 1.091, 2.5558>
      }
      
      cylinder {
         //*PMName Strebe 4
         <-0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0.15, 1.091, 2.5558>
      }
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      no_shadow
   }
   
   union {
      //*PMName Traeger 3
      
      intersection {
         //*PMName Befestigung
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 1.02
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         box {
            <-1.35, -0.11, -1.0833>, <0.70306, 0.11, 1.0968>
            scale 1
            rotate <0, -45, 90>
            translate <0, 0.17411, 0.188619>
            inverse
         }
         rotate y*180
         translate <5.025, 0, 3>
      }
      
      cylinder {
         //*PMName Strebe 1
         <0, 2.3, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate x*(-45)
         translate <5.025, 0.85, 2.2292>
      }
      
      cylinder {
         //*PMName Strebe 2
         <0, 1.5, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <5.025, 1.091, 2.5558>
      }
      
      cylinder {
         //*PMName Strebe 3
         <0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <5.025, 1.091, 2.5558>
      }
      
      cylinder {
         //*PMName Strebe 4
         <-0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <5.025, 1.091, 2.5558>
      }
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      no_shadow
   }
   
   union {
      //*PMName Traeger 4
      
      intersection {
         //*PMName Befestigung
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 1.02
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         box {
            <-1.35, -0.11, -1.0833>, <0.70306, 0.11, 1.0968>
            scale 1
            rotate <0, -45, 90>
            translate <0, 0.17411, 0.188619>
            inverse
         }
         rotate <0, 0, 0>
         translate <-5.025, 0, -3>
      }
      
      cylinder {
         //*PMName Strebe 1
         <0, 2.3, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <-45, 180, 0>
         translate <-5.025, 0.85, -2.2292>
      }
      
      cylinder {
         //*PMName Strebe 2
         <0, 1.5, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <-5.025, 1.091, -2.5558>
      }
      
      cylinder {
         //*PMName Strebe 3
         <0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <-5.025, 1.091, -2.5558>
      }
      
      cylinder {
         //*PMName Strebe 4
         <-0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <-5.025, 1.091, -2.5558>
      }
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      no_shadow
   }
   
   union {
      //*PMName Traeger 5
      
      intersection {
         //*PMName Befestigung
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 1.02
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         box {
            <-1.35, -0.11, -1.0833>, <0.70306, 0.11, 1.0968>
            scale 1
            rotate <0, -45, 90>
            translate <0, 0.17411, 0.188619>
            inverse
         }
         rotate <0, 0, 0>
         translate <0.15, 0, -3>
      }
      
      cylinder {
         //*PMName Strebe 1
         <0, 2.3, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <-45, 180, 0>
         translate <0.15, 0.85, -2.2292>
      }
      
      cylinder {
         //*PMName Strebe 2
         <0, 1.5, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <0.15, 1.091, -2.5558>
      }
      
      cylinder {
         //*PMName Strebe 3
         <0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0.15, 1.091, -2.5558>
      }
      
      cylinder {
         //*PMName Strebe 4
         <-0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <0.15, 1.091, -2.5558>
      }
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      no_shadow
   }
   
   union {
      //*PMName Traeger 6
      
      intersection {
         //*PMName Befestigung
         
         cylinder {
            <0, 0.1, 0>, <0, -0.1, 0>, 1.02
            scale 1
            rotate z*90
            translate <0, 0, 0>
         }
         
         box {
            <-1.35, -0.11, -1.0833>, <0.70306, 0.11, 1.0968>
            scale 1
            rotate <0, -45, 90>
            translate <0, 0.17411, 0.188619>
            inverse
         }
         rotate <0, 0, 0>
         translate <5.025, 0, -3>
      }
      
      cylinder {
         //*PMName Strebe 1
         <0, 2.3, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <-45, 180, 0>
         translate <5.025, 0.85, -2.2292>
      }
      
      cylinder {
         //*PMName Strebe 2
         <0, 1.5, 0>, <0, -0.5, 0>, 0.08
         scale 1
         rotate <0, 0, 0>
         translate <5.025, 1.091, -2.5558>
      }
      
      cylinder {
         //*PMName Strebe 3
         <0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <5.025, 1.091, -2.5558>
      }
      
      cylinder {
         //*PMName Strebe 4
         <-0.82702, 1.4565, 0>, <0, -0.5, 0>, 0.05
         scale 1
         rotate <0, 0, 0>
         translate <5.025, 1.091, -2.5558>
      }
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      no_shadow
   }
   
   cylinder {
      //*PMName Strebe 1
      <0, 2.5, 0>, <0, -2.5, 0>, 0.08
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      scale 1
      rotate <90, 0, 90>
      translate <-5.025, 0.6, 0>
      no_shadow
   }
   
   cylinder {
      //*PMName Strebe 2
      <0, 2.5, 0>, <0, -2.5, 0>, 0.08
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      scale 1
      rotate <90, 0, 90>
      translate <0.15, 0.6, 0>
      no_shadow
   }
   
   cylinder {
      //*PMName Strebe 3
      <0, 2.5, 0>, <0, -2.5, 0>, 0.08
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      scale 1
      rotate <90, 0, 90>
      translate <5.025, 0.6, 0>
      no_shadow
   }
   
   union {
      //*PMName Deck
      
      light_source {
         <-1.00576, 2.87557, 0.00512977>, rgb <1, 1, 1>
      }
      
      box {
         //*PMName Plattform
         <-9.5, -0.1, -6>, <6.25, 0, 6>
         
         pigment {
            color rgb <1.2, 1.2, 1.2>
         }
         scale 1
         rotate <0, 0, 0>
         translate y*2.6
         no_shadow
      }
      
      union {
         //*PMName Umrandung
         
         box {
            <-9.49, 0.001, -5.99>, <6.24, 0, -5.8>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate y*2.60001
            no_shadow
         }
         
         box {
            <-9.49, 0.001, 5.99>, <6.24, 0, 5.8>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate y*2.6
            no_shadow
         }
         
         box {
            <-5.79, 0.001, 6.24>, <5.79, 0, 6.04>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate y*90
            translate y*2.6
            no_shadow
         }
         
         box {
            <-5.79, 0.001, -9.49>, <5.79, 0, -9.29>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate y*90
            translate y*2.6
            no_shadow
         }
         
         cylinder {
            <0, 0.3, 0>, <0, 0, 0>, 0.06
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-9.4, 2.6, -5.9>
         }
         
         cone {
            <0, 0.05, 0>, 0.06,
            <0, 0, 0>, 0.08
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-9.4, 2.6, -5.9>
         }
         
         cylinder {
            <0, 0.3, 0>, <0, 0, 0>, 0.06
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-9.4, 2.6, 5.9>
         }
         
         cone {
            <0, 0.05, 0>, 0.06,
            <0, 0, 0>, 0.08
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-9.4, 2.6, 5.9>
         }
         
         cylinder {
            <0, 0.3, 0>, <0, 0, 0>, 0.06
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <6.15, 2.6, -5.9>
         }
         
         cone {
            <0, 0.05, 0>, 0.06,
            <0, 0, 0>, 0.08
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <6.15, 2.6, -5.9>
         }
         
         cylinder {
            <0, 0.3, 0>, <0, 0, 0>, 0.06
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <6.15, 2.6, 5.9>
         }
         
         cone {
            <0, 0.05, 0>, 0.06,
            <0, 0, 0>, 0.08
            
            pigment {
               color rgb <1, 1, 0>
            }
            scale 1
            rotate <0, 0, 0>
            translate <6.15, 2.6, 5.9>
         }
         
         box {
            //*PMName Bande
            <-9.4, 0.18, -0.015>, <6.15, 0.28, 0.015>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 2.6, -5.9>
         }
         
         box {
            //*PMName Bande
            <-9.4, 0.18, -0.015>, <6.15, 0.28, 0.015>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 2.6, 5.9>
         }
         
         box {
            //*PMName Bande
            <-5.9, 0.18, -0.015>, <5.9, 0.28, 0.015>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate y*(-90)
            translate <6.15, 2.6, 0>
         }
         
         box {
            //*PMName Bande
            <-5.9, 0.18, -0.015>, <5.9, 0.28, 0.015>
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1, 1, 0>
               scale <0.25, 1, 1>
            }
            scale 1
            rotate y*(-90)
            translate <-9.4, 2.6, 0>
         }
         no_shadow
      }
      
      union {
         //*PMName Kollektormodul
         
         union {
            //*PMName Teleskopturm
            
            cone {
               <0, 0.4052, 0>, 0.472,
               <0, 0, 0>, 0.501
               
               pigment {
                  checker 
                  color rgb <0, 0, 0>
                  color rgb <1, 1, 0>
                  scale <0.125, 0.25, 1>
                  rotate z*90
               }
               scale 1
               rotate <0, 0, 0>
               translate <4, 2.6, 0>
            }
            
            cone {
               <0, 1.5, 0>, 0.4,
               <0, 0, 0>, 0.5
               scale 1
               rotate <0, 0, 0>
               translate <4, 2.6, 0>
            }
            
            cone {
               <0, 3, 0>, 0.26,
               <0, 0, 0>, 0.38
               scale 1
               rotate <0, 0, 0>
               translate <4, 2.6, 0>
            }
            
            cone {
               <0, 4, 0>, 0.16,
               <0, 0, 0>, 0.26
               scale 1
               rotate <0, 0, 0>
               translate <4, 2.6, 0>
            }
         }
         
         union {
            //*PMName Gelenk
            
            difference {
               //*PMName Halter
               
               box {
                  <-0.25, -0.5, -0.75>, <0.25, 0, 0.75>
                  
                  pigment {
                     color rgb <1.2, 1.2, 1.2>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.05, 0>
               }
               
               box {
                  <-0.26, -0.3, -0.5>, <0.26, 0.01, 0.5>
                  
                  pigment {
                     color rgb <1.2, 1.2, 1.2>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.05, 0>
               }
            }
            
            cylinder {
               <0, 0.5, 0>, <0, -0.5, 0>, 0.2
               
               texture {
                  //*PMRawBegin
                  Silver_Metal
                  //*PMRawEnd
               }
               scale 1
               rotate x*90
               translate <4, 6.76, 0>
            }
         }
         
         union {
            //*PMName Kollektoren
            
            cylinder {
               <0, 0.59, 0>, <0, -0.25, 0>, 0.14
               scale 1
               rotate <0, 0, 0>
               translate <4, 7, 0>
            }
            
            cylinder {
               <0, 0.6, 0>, <0, 0.25, 0>, 0.45
               scale 1
               rotate <0, 0, 0>
               translate <4, 7, 0>
            }
            
            cylinder {
               <0, 0.39, 0>, <0, 0.37, 0>, 0.451
               
               pigment {
                  color rgb <0, 0, 0>
               }
               scale 1
               rotate <0, 0, 0>
               translate <4, 7, 0>
            }
            
            cylinder {
               //*PMName Hauptkreuzstrebe
               <0, 2.5, 0>, <0, -2.5, 0>, 0.05
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <90, 0, 90>
               translate <4, 7.5, 0>
               no_shadow
            }
            
            cylinder {
               //*PMName Hauptkreuzstrebe
               <0, 2.5, 0>, <0, -2.5, 0>, 0.05
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <180, 0, 90>
               translate <4, 7.5, 0>
               no_shadow
            }
            
            cylinder {
               //*PMName Querstrebe
               <0, 2.5, 0>, <0, -2.5, 0>, 0.05
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <90, 0, 90>
               translate <1.5, 7.5, 0>
               no_shadow
            }
            
            cylinder {
               //*PMName Querstrebe
               <0, 2.5, 0>, <0, -2.5, 0>, 0.05
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <90, 0, 90>
               translate <6.5, 7.5, 0>
               no_shadow
            }
            
            union {
               //*PMName stab 1/l
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate <-2.5, 0, 2.5>
            }
            
            union {
               //*PMName stab 2/l
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate x*(-2.5)
            }
            
            union {
               //*PMName stab 3/l
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate <-2.5, 0, -2.5>
            }
            
            union {
               //*PMName stab 1/m
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate z*2.5
            }
            
            union {
               //*PMName stab 2/m
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate <0, 0, 0>
            }
            
            union {
               //*PMName stab 3/m
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate z*(-2.5)
            }
            
            union {
               //*PMName stab 1/r
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate <2.5, 0, 2.5>
            }
            
            union {
               //*PMName stab 2/r
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate x*2.5
            }
            
            union {
               //*PMName stab 3/r
               
               cylinder {
                  <0, 0.27, 0>, <0, 0.21, 0>, 0.09
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               cylinder {
                  <0, 0.2, 0>, <0, 0, 0>, 0.05
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.5, 0>
               }
               
               sphere {
                  <0, 0, 0>, 0.05
                  
                  pigment {
                     color rgb <0.933333, 0.933333, 0.933333>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.7, 0>
               }
               translate <2.5, 0, -2.5>
            }
            
            union {
               //*PMName panel 1/l
               
               box {
                  //*PMName k1/1
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <1.5, 7.8, 2.5>
               }
               
               box {
                  //*PMName fr1/1
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <1.5, 7.8, 2.5>
               }
            }
            
            union {
               //*PMName panel 2/l
               
               box {
                  //*PMName k2/1
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.8, 2.5>
               }
               
               box {
                  //*PMName fr2/1
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.8, 2.5>
               }
            }
            
            union {
               //*PMName panel 3/l
               
               box {
                  //*PMName k3/1
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <6.5, 7.8, 2.5>
               }
               
               box {
                  //*PMName fr3/1
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <6.5, 7.8, 2.5>
               }
            }
            
            union {
               //*PMName panel 1/m
               
               box {
                  //*PMName k1/2
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <1.5, 7.8, 0>
               }
               
               box {
                  //*PMName fr1/2
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <1.5, 7.8, 0>
               }
            }
            
            union {
               //*PMName panel 2/m
               
               box {
                  //*PMName k2/2
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.8, 0>
               }
               
               box {
                  //*PMName fr2/2
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.8, 0>
               }
            }
            
            union {
               //*PMName panel 3/m
               
               box {
                  //*PMName k3/2
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <6.5, 7.8, 0>
               }
               
               box {
                  //*PMName fr3/2
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <6.5, 7.8, 0>
               }
            }
            
            union {
               //*PMName panel 1/r
               
               box {
                  //*PMName k1/3
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <1.5, 7.8, -2.5>
               }
               
               box {
                  //*PMName fr1/3
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <1.5, 7.8, -2.5>
               }
            }
            
            union {
               //*PMName panel 2/r
               
               box {
                  //*PMName k2/3
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.8, -2.5>
               }
               
               box {
                  //*PMName fr2/3
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <4, 7.8, -2.5>
               }
            }
            
            union {
               //*PMName panel 3/r
               
               box {
                  //*PMName k3/3
                  <-0.97, -0.029, -0.97>, <0.97, 0.03, 0.97>
                  
                  texture {
                     //*PMRawBegin
                     Starfield
                     //*PMRawEnd
                     
                     finish {
                        //*PMRawBegin
                        Dull
                        //*PMRawEnd
                        conserve_energy
                        
                        reflection {
                           rgb <0.1, 0.1, 0.1>
                        }
                     }
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <6.5, 7.8, -2.5>
               }
               
               box {
                  //*PMName fr3/3
                  <-1, -0.03, -1>, <1, 0.029, 1>
                  
                  pigment {
                     color rgb <1, 1, 1>
                  }
                  scale 1
                  rotate <0, 0, 0>
                  translate <6.5, 7.8, -2.5>
               }
            }
            scale 1
            translate <-4.9506, 1.03671, 0>
            rotate z*(-37.6)
         }
         
         pigment {
            color rgb <1, 1, 1>
         }
         no_shadow
      }
      
      difference {
         //*PMName Ein-/Ausgang
         
         cylinder {
            <0, 0.5, 0>, <0, -0.5, 0>, 1
            
            pigment {
               color rgb <1, 1, 1>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-1, 2.9, 0>
         }
         
         cylinder {
            <0, 0.499, 0>, <0, -0.31, 0>, 0.9
            
            pigment {
               color rgb <0.811765, 0.811765, 0.811765>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-1, 2.9, 0>
         }
         
         box {
            //*PMName Door
            <-0.2, -0.3, -1>, <0.2, 0.4, -0.66928>
            
            pigment {
               color rgb <0.811765, 0.811765, 0.811765>
            }
            scale 1
            rotate <0, 0, 0>
            translate <-1, 2.8, 0>
         }
         
         union {
            //*PMName taster
            
            box {
               <-0.1, -0.1, 0.04>, <0.1, 0.1, 0.15>
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <0, 0, 0>
               translate <-0.6, 2.95, -1>
               no_shadow
            }
            
            cylinder {
               <0, 0.151, 0>, <0, 0.07, 0>, 0.05
               
               pigment {
                  color rgb <1, 0, 0>
               }
               scale 1
               rotate x*90
               translate <-0.6, 2.95, -1>
            }
         }
         
         box {
            //*PMName Windows
            <-0.1, 0.1, -1>, <0.1, 0.4, 1>
            
            pigment {
               color rgb <0.811765, 0.811765, 0.811765>
            }
            scale 1
            rotate y*90
            translate <-1, 2.8, 0>
         }
      }
      
      union {
         //*PMName Aufbauten
         
         union {
            //*PMName Aggregat
            
            box {
               <-1, 0, -2>, <1, 0.75, 2.25>
               
               pigment {
                  color rgb <0.6, 0.6, 0.5>
               }
               scale 1
               rotate <0, 0, 0>
               translate <-7.7, 2.6, -2.5>
            }
            
            box {
               <0.99, 0, 0.7>, <1.001, 0.6, 2>
               
               pigment {
                  color rgb <0.054902, 0.219608, 0.4>
               }
               
               finish {
                  //*PMRawBegin
                  //Phong_Dull
                  //*PMRawEnd
               }
               scale 1
               rotate <0, 0, 0>
               translate <-7.7, 2.6, -2.5>
            }
            
            merge {
               torus {
                  0.325, 0.1
                  scale 1
                  rotate z*90
                  translate <-7.1, 3.35, -1>
               }
               
               cylinder {
                  <0, 0.7, 0>, <0, -0.7, 0>, 0.3
                  scale 1
                  rotate <90, 90, 0>
                  translate <-7.7, 3.35, -1>
               }
               
               torus {
                  0.325, 0.1
                  scale 1
                  rotate z*90
                  translate <-8.3, 3.35, -1>
               }
               
               finish {
                  //*PMRawBegin
                  Dull
                  //*PMRawEnd
               }
            }
            
            merge {
               torus {
                  0.325, 0.1
                  scale 1
                  rotate z*90
                  translate <-7.1, 3.35, -3.8>
               }
               
               cylinder {
                  <0, 0.7, 0>, <0, -0.7, 0>, 0.3
                  scale 1
                  rotate <90, 90, 0>
                  translate <-7.7, 3.35, -3.8>
               }
               
               torus {
                  0.325, 0.1
                  scale 1
                  rotate z*90
                  translate <-8.3, 3.35, -3.8>
               }
               
               finish {
                  //*PMRawBegin
                  Dull
                  //*PMRawEnd
               }
            }
            //*PMRawBegin
            object {
             Wire_Box_Union (
             <-0.1, -0.1, -0.1>,
             <1,0.7,0.5>,
             0.05
            )
            
            texture {Silver_Metal}
            no_shadow
            translate <-7,2.6,-4>
            }
            
            //*PMRawEnd
            //*PMRawBegin
            object {
             Wire_Box_Union (
             <-0.1, -0.1, -0.1>,
             <2,0.5,0.5>,
             0.05
            )
            
            texture {Polished_Chrome}
            no_shadow
            translate <-7,2.6,-3.3>
            }
            
            //*PMRawEnd
            //*PMRawBegin
            object {
             Wire_Box_Union (
             <-0.1, -0.1, -0.1>,
             <1,0.7,0.5>,
             0.05
            )
            
            texture {Silver_Metal}
            no_shadow
            translate <-7.5,2.6,-2.6>
            }
            
            //*PMRawEnd
            no_shadow
         }
         
         union {
            //*PMName D1
            
            intersection {
               difference {
                  merge {
                     cone {
                        <0, 0.6, 0>, 0.45,
                        <0, 0.5, 0>, 0.5
                     }
                     
                     cylinder {
                        <0, 0.4999, 0>, <0, -0.4999, 0>, 0.5
                     }
                     
                     cone {
                        <0, -0.5, 0>, 0.5,
                        <0, -0.6, 0>, 0.45
                     }
                  }
                  //*PMRawBegin
                  #declare ticker =1;
                  #while (ticker<13)
                    object {kerbe1 translate -0.475*z 
                    rotate 30*ticker*y}
                    #declare ticker= ticker+1;
                  #end
                  //*PMRawEnd
                  //*PMRawBegin
                  #declare ticker =1;
                  #while (ticker<13)
                    object {kerbe2 translate -0.35*z 
                    rotate 30*ticker*y}
                    #declare ticker= ticker+1;
                  #end
                  //*PMRawEnd
               }
               
               sphere {
                  <0, -0.6, 0>, 0.601
               }
               
               pigment {
                  color rgb <1, 1, 1>
               }
            }
            scale 1.5
            translate <-7, 3.5, 3.5>
            no_shadow
         }
         
         union {
            //*PMName D2
            
            intersection {
               difference {
                  merge {
                     cone {
                        <0, 0.6, 0>, 0.45,
                        <0, 0.5, 0>, 0.5
                     }
                     
                     cylinder {
                        <0, 0.4999, 0>, <0, -0.4999, 0>, 0.5
                     }
                     
                     cone {
                        <0, -0.5, 0>, 0.5,
                        <0, -0.6, 0>, 0.45
                     }
                  }
                  //*PMRawBegin
                  #declare ticker =1;
                  #while (ticker<13)
                    object {kerbe1 translate -0.472*z 
                    rotate 30*ticker*y}
                    #declare ticker= ticker+1;
                  #end
                  //*PMRawEnd
                  //*PMRawBegin
                  #declare ticker =1;
                  #while (ticker<13)
                    object {kerbe2 translate -0.35*z 
                    rotate 30*ticker*y}
                    #declare ticker= ticker+1;
                  #end
                  //*PMRawEnd
               }
               
               sphere {
                  <0, 0, 0>, 0.601
               }
               
               pigment {
                  color rgb <1.2, 1.2, 1.2>
               }
            }
            translate <-5.9442, 2.92, 2.9684>
            no_shadow
         }
         //*PMRawBegin
         object {
          Wire_Box_Union (
          <-0.1, -0.1, -0.1>,
          <0.8,0.568,1.75>,
          0.02
         )
         
         pigment {Black}
         no_shadow
         translate <4.66,2.6,3.5>
         }
         
         //*PMRawEnd
         
         union {
            //*PMName Tank
            
            intersection {
               //*PMName tank
               
               cylinder {
                  <0, 1.25, 0>, <0, -1.25, 0>, 1
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 2.5
                  scale <1, 0.5, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               pigment {
                  color rgb <1.2, 1.2, 1.2>
               }
               scale <1, 2, 1>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*2.266
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*(-2.266)
            }
            scale 0.25
            rotate z*90
            translate <5, 2.9, 5>
            no_shadow
         }
         
         union {
            //*PMName Tank
            
            intersection {
               //*PMName tank
               
               cylinder {
                  <0, 1.25, 0>, <0, -1.25, 0>, 1
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 2.5
                  scale <1, 0.5, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               pigment {
                  color rgb <1.2, 1.2, 1.2>
               }
               scale <1, 2, 1>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*2.266
            }
            
            cylinder {
               //*PMName Ringe(Mitte)
               <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate <0, 0, 0>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*(-2.266)
            }
            scale 0.25
            rotate z*90
            translate <5, 2.9, 4.4>
            no_shadow
         }
         
         union {
            //*PMName Tank
            
            intersection {
               //*PMName tank
               
               cylinder {
                  <0, 1.25, 0>, <0, -1.25, 0>, 1
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 2.5
                  scale <1, 0.5, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               pigment {
                  color rgb <1.2, 1.2, 1.2>
               }
               scale <1, 2, 1>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*2.266
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*(-2.266)
            }
            scale 0.25
            rotate z*90
            translate <5, 2.9, 3.8>
            no_shadow
         }
         
         union {
            //*PMName Tank
            
            intersection {
               //*PMName tank
               
               cylinder {
                  <0, 1.25, 0>, <0, -1.25, 0>, 1
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 2.5
                  scale <1, 0.5, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               pigment {
                  color rgb <1.2, 1.2, 1.2>
               }
               scale <1, 2, 1>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*2.266
            }
            
            cylinder {
               //*PMName Ringe(Mitte)
               <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate <0, 0, 0>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*(-2.266)
            }
            scale <0.25, 0.3, 0.3>
            rotate <90, 0, 90>
            translate <5.35, 2.9, 2.5>
            no_shadow
         }
         //*PMRawBegin
         object {
          Wire_Box_Union (
          <-0.1, -0.1, -0.1>,
          <0.6,0.568,1>,
          0.02
         )
         
         pigment {Black}
         no_shadow
         translate <5.125,2.6,2.05>
         }
         
         //*PMRawEnd
         
         cylinder {
            //*PMName Zwischenstueck
            <0, 0.9, 0>, <0, -5, 0>, 0.03
            
            pigment {
               color rgb <0, 0, 0>
            }
            
            finish {
               conserve_energy
               
               reflection {
                  rgb <0.01, 0.01, 0.01>, rgb <1, 1, 1>
               }
            }
            scale 1
            rotate <90, 0, 90>
            translate <5.35, 2.9, 1>
            no_shadow
         }
         
         box {
            //*PMName Verteiler
            <-0.1, -0.35, -0.1>, <0.1, 0.1, 0.1>
            
            pigment {
               color rgb <0, 0.5, 0.5>
            }
            scale 1
            rotate <0, 0, 0>
            translate <5.35, 2.9, 0>
            no_shadow
         }
         
         cylinder {
            //*PMName Zwischenstueck
            <0, 0.55, 0>, <0, -0.35, 0>, 0.03
            
            pigment {
               color rgb <0, 0, 0>
            }
            
            finish {
               conserve_energy
               
               reflection {
                  rgb <0.01, 0.01, 0.01>, rgb <1, 1, 1>
               }
            }
            scale 1
            rotate z*90
            translate <5, 2.75, 0>
            no_shadow
         }
         
         union {
            //*PMName Tank
            
            intersection {
               //*PMName tank
               
               cylinder {
                  <0, 1.25, 0>, <0, -1.25, 0>, 1
                  scale 1
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               sphere {
                  <0, 0, 0>, 2.5
                  scale <1, 0.5, 1>
                  rotate <0, 0, 0>
                  translate <0, 0, 0>
               }
               
               pigment {
                  color rgb <1.2, 1.2, 1.2>
               }
               scale <1, 2, 1>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*2.266
            }
            
            cylinder {
               //*PMName Ringe(Mitte)
               <0, 0.025, 0>, <0, -0.025, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate <0, 0, 0>
            }
            
            cylinder {
               //*PMName Aussenring
               <0, 0.02, 0>, <0, -0.02, 0>, 1.0001
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               translate y*(-2.266)
            }
            scale <0.25, 0.3, 0.3>
            rotate <90, 0, 90>
            translate <5.35, 2.9, -4.6>
            no_shadow
         }
         //*PMRawBegin
         object {
          Wire_Box_Union (
          <-0.1, -0.1, -0.1>,
          <0.6,0.568,1>,
          0.02
         )
         
         pigment {Black}
         no_shadow
         translate <5.125,2.6,-5>
         }
         
         //*PMRawEnd
         
         prism {
            linear_spline
            linear_sweep
            0, 0.9,
            7,
            <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
            sturm
            
            pigment {
               color rgb <0.388235, 0.541176, 0.537255>
            }
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
            }
            scale 1
            rotate <0, 0, 0>
            translate <0.5, 2.5, 4>
         }
         
         box {
            <-0.43992, 0, -0.46665>, <0.42214, 0.85, -0.11082>
            
            pigment {
               color rgb <1, 1, 0>
            }
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
            }
            scale 1
            rotate y*63.5
            translate <0.0130088, 2.5, 3.58417>
            no_shadow
         }
         
         prism {
            linear_spline
            linear_sweep
            0, 1.2,
            7,
            <0.5, 1>, <1, 0>, <0.5, -1>, <-0.5, -1>, <-1, 0>, <-0.5, 1>, <0.5, 1>
            sturm
            
            pigment {
               color rgb <1.2, 1.2, 1.2>
            }
            
            finish {
               //*PMRawBegin
               Dull
               //*PMRawEnd
            }
            scale 1
            rotate <0, 0, 0>
            translate <-1.01, 2.5, 2.9>
         }
         
         union {
            //*PMName stromkasten
            
            superellipsoid {
               <0.2, 0.2>
               
               pigment {
                  color rgb <1, 0.3, 0>
               }
               scale <0.2, 0.12, 0.1>
               rotate y*(-63.6)
               translate <-0.24583, 3.3, 2.4278>
            }
            
            cylinder {
               <0, 0.2, 0>, <0, -0.5, 0>, 0.025
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <0, 0, 0>
               translate <-0.286112, 3, 2.28806>
            }
            
            cylinder {
               <0, 0.2, 0>, <0, -0.5, 0>, 0.025
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <0, 0, 0>
               translate <-0.22319, 3, 2.41299>
            }
            
            cylinder {
               <0, 0.2, 0>, <0, -0.5, 0>, 0.025
               
               pigment {
                  color rgb <0.388235, 0.541176, 0.537255>
               }
               scale 1
               rotate <0, 0, 0>
               translate <-0.159236, 3, 2.54211>
            }
            translate <0.0190697, 0, 0.0206499>
            no_shadow
         }
         
         cylinder {
            <0, 0.1, 0>, <0, -1, 0>, 0.3
            
            pigment {
               checker 
               color rgb <0, 0, 0>
               color rgb <1.5, 1.5, 1.5>
               scale 0.25
            }
            scale 1
            rotate <-90, 0, 90>
            translate <-1, 2.8, 1>
            no_shadow
         }
         no_shadow
      }
   }
   
   cylinder {
      //*PMName Stab
      <0, 0.5, 0>, <0, -0.8, 0>, 0.04
      
      pigment {
         color rgb <0.388235, 0.541176, 0.537255>
      }
      scale 1
      rotate <0, 0, 0>
      translate <-1, 4.198, 0>
      no_shadow
   }
   
   union {
      //*PMName satellitenschuessel
      
      union {
         //*PMName Schuessel
         
         union {
            //*PMName Gelenk
            
            cylinder {
               <0, 0.06, 0>, <0, -0.05, 0>, 0.05
               scale 1
               rotate <90, 90, 0>
               translate z*(-0.55)
            }
            
            cylinder {
               <0, 0.05, 0>, <0, 0.048, 0>, 0.0501
               
               pigment {
                  color rgb <0, 0, 0>
               }
               scale 1
               rotate <90, 90, 0>
               translate z*(-0.55)
            }
            
            cylinder {
               <0, -0.038, 0>, <0, -0.04, 0>, 0.0501
               
               pigment {
                  color rgb <0, 0, 0>
               }
               scale 1
               rotate <90, 90, 0>
               translate z*(-0.55)
            }
         }
         
         difference {
            //*PMName Halter
            
            cylinder {
               <0, -0.4, 0>, <0, -0.52, 0>, 0.08
               scale 1
               rotate x*90
               translate <0, 0, 0>
            }
            
            sphere {
               <0, 0, 0>, 0.499
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.01)
            }
         }
         
         difference {
            //*PMName Teller
            
            sphere {
               <0, 0, 0>, 0.499
               scale 1
               rotate <0, 0, 0>
               translate z*(-0.01)
            }
            
            sphere {
               <0, 0, 0>, 0.5
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
            
            box {
               <-0.5, -0.5, -0.4>, <0.5, 0.5, 0.5>
               scale 1
               rotate <0, 0, 0>
               translate <0, 0, 0>
            }
         }
         
         pigment {
            color rgb <0.933333, 0.933333, 0.933333>
         }
      }
      
      union {
         //*PMName Empfaenger
         
         cylinder {
            //*PMName stab
            <0, 0.51, 0>, <0, 0.15, 0>, 0.005
            scale 1
            rotate x*(-33)
            translate <0, -0.135, -0.125>
         }
         
         cylinder {
            //*PMName stab
            <0, 0.51, 0>, <0, 0.15, 0>, 0.005
            scale 1
            rotate <-33, 0, 180>
            translate <0, 0.135, -0.125>
         }
         
         cylinder {
            //*PMName stab
            <0, 0.51, 0>, <0, 0.15, 0>, 0.005
            scale 1
            rotate <-33, 0, 90>
            translate <0.135, 0, -0.125>
         }
         
         cylinder {
            //*PMName stab
            <0, 0.51, 0>, <0, 0.15, 0>, 0.005
            scale 1
            rotate <-33, 0, 270>
            translate <-0.135, 0, -0.125>
         }
         
         cylinder {
            <0, 0.245, 0>, <0, 0.2, 0>, 0.035
            
            pigment {
               color rgb <0.811765, 0.811765, 0.811765>
            }
            scale 1
            rotate x*(-90)
            translate <0, 0, 0>
         }
         
         pigment {
            color rgb <1.2, 1.2, 1.2>
         }
      }
      scale 1
      rotate <-160, 90, 0>
      translate <-1.524, 4.84, 0.005>
      no_shadow
   }
   scale 1
   rotate y*27
   //*PMRawBegin
   rotate <0,360*clock,0>
   //*PMRawEnd
   translate y*(-1)
}

light_source {
   <1, 11, -14>, rgb <1, 1, 1>
}

light_source {
   <0, 11, 100>, rgb <1, 1, 1>
}

camera {
   perspective
   location <0, 6, -21>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 0, 0>
}