//*PMRawBegin
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"

//*PMRawEnd

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 1.5
   max_trace_level 2048
   noise_generator 2
}

sphere {
   //*PMName Explosion
   <0, 0, 0>, 1.5
   
   pigment {
      color rgbt <1, 1, 1, 1>
   }
   
   interior {
      media {
         density {
            spherical
            turbulence <1.5, 1.5, 1.5>
            scale <0.8, 0.8, 1>
            
            density_map {
               [ 0.125 color rgb <0, 0, 0>
               ]
               [ 0.25 color rgb <0.5, 0, 0>
               ]
               [ 0.5 color rgb <1, 1, 0>
               ]
               [ 0.75 color rgb <0.5, 0, 0>
               ]
               [ 1 color rgb <0, 0, 0>
               ]
            }
            //*PMRawBegin
            frequency 2
            //*PMRawEnd
         }
         emission rgb <1, 1, 1>
      }
   }
   scale 4
   rotate <0, 0, 0>
   translate <-16.01, 0, 6.50957>
   hollow
}

torus {
   15, 6
   sturm
   
   texture {
      pigment {
         uv_mapping
         brick
         color rgb <1.25, 1.25, 1.25>
         color rgb <0, 0, 0>
         brick_size <1, 1, 1>
         mortar 0.04
         scale 0.02
      }
      
      normal {
         uv_mapping
         cells
         1
         turbulence <0.03, 0.06, 0.1>
         
         slope_map {
            [ 0 <0, 0.5>
            ]
            [ 0.2 <0.1, 0.5>
            ]
         }
         scale 0.01
         bump_size -2
         accuracy 0.01
      }
   }
   
   finish {
      //*PMRawBegin
      Phong_Shiny
      //roughness 0.02
      //*PMRawEnd
      specular 0.55
   }
   scale <1.2, 0.8, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
   hollow
}

torus {
   //*PMName Band
   9.05, 0.1
   sturm
   
   texture {
      //*PMRawBegin
      Chrome_Metal
      //*PMRawEnd
      
      normal {
         radial
         -3
         frequency 180
         scale <0, 0.01, 0>
         rotate <0, 0, 0>
      }
   }
   
   finish {
      //*PMRawBegin
      Glossy
      //*PMRawEnd
   }
   scale <1.2, 0.8, 1>
   rotate <0, 0, 0>
   translate <0, 0, 0>
   hollow
}

disc {
   //*PMName Floor
   <0, 0, 0>,<0, 1, 0>, 21,8
   
   texture {
      //*PMRawBegin
      Rusty_Iron
      //*PMRawEnd
      
      normal {
         agate
         agate_turb 0.5
      }
   }
   
   texture {
      pigment {
         onion
         
         color_map {
            [ 0 color rgb <0, 0, 0>
            ]
            [ 0.001 color rgb <0, 0, 0>
            ]
            [ 0.1 color rgbt <1, 1, 1, 1>
            ]
         }
         frequency 1
      }
   }
   
   finish {
      //*PMRawBegin
      /*Shiny
      roughness 0.02
      */
      //*PMRawEnd
   }
   scale <1.2, 1, 1>
   rotate <0, 0, 0>
   translate y*(-3.09)
}

blob {
   //*PMName Slime
   threshold 0.5
   
   sphere {
      <0, 0, 0>, 1,
      strength 0.7
      //*PMRawBegin
      texture {
      pigment {Red}
       normal { bumps 2 scale 0.05}
      finish {phong 1}
      
      }
      
      translate <0,0.6*sin(2*pi*clock),0>
      rotate <0,-360*clock,0>
      //*PMRawEnd
      translate <-4.56045, -0.0690911, -7.70203>
   }
   
   sphere {
      <0, 0, 0>, 2.15,
      strength 1
      
      pigment {
         color rgb <1, 1, 0>
      }
      scale <6, 0.01, 6>
      //*PMRawBegin
      
      finish {Phong_Glossy}
      //*PMRawEnd
      
      normal {
         crackle
         turbulence <2, 4, 8>
      }
   }
   scale <2, 1.5, 2>
   rotate <0, 0, 0>
   translate y*(-3.1015)
   no_shadow
}

merge {
   //*PMName left pillar
   
   torus {
      0.5, 0.06
      scale 1
      rotate <0, 0, 0>
      translate y*2.5
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate x*0.5
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <0.354, 0, 0.35>
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate x*(-0.5)
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <0.354, 0, -0.35>
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate z*(-0.5)
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <-0.354, 0, -0.35>
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate z*0.5
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <-0.354, 0, 0.35>
   }
   
   cylinder {
      //*PMName segment - oben
      <0, 0.5, 0>, <0, 0, 0>, 0.62
      
      texture {
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            //*PMRawBegin
            ambient Black
            //*PMRawEnd
            roughness 0.05
         }
         scale 0.5
      }
      translate y*1.5
   }
   
   cylinder {
      //*PMName segment - mitte
      <0, 0.75, 0>, <0, -0.75, 0>, 0.62
      
      texture {
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            //*PMRawBegin
            ambient White*1.15
            
            //*PMRawEnd
            roughness 0.05
         }
         scale 0.5
      }
      translate <0, 0, 0>
   }
   
   cylinder {
      //*PMName segment unten
      <0, 0.5, 0>, <0, 0, 0>, 0.62
      
      texture {
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            //*PMRawBegin
            ambient Black
            //*PMRawEnd
            roughness 0.05
         }
         scale 0.5
      }
      translate y*(-2)
   }
   
   torus {
      0.5, 0.06
      scale 1
      rotate <0, 0, 0>
      translate y*(-2.5)
   }
   
   texture {
      //*PMRawBegin
      Gold_Metal
      //*PMRawEnd
   }
   scale 1
   rotate <0, 0, 0>
   translate <-22.8613, 0, 0.0622022>
}

merge {
   //*PMName right pillar
   
   torus {
      0.5, 0.06
      scale 1
      rotate <0, 0, 0>
      translate y*2.5
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate x*0.5
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <0.354, 0, 0.35>
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate x*(-0.5)
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <0.354, 0, -0.35>
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate z*(-0.5)
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <-0.354, 0, -0.35>
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      translate z*0.5
   }
   
   cylinder {
      <0, 2.5, 0>, <0, -2.5, 0>, 0.03
      
      texture {
         //*PMRawBegin
         Silver_Metal
         //*PMRawEnd
      }
      translate <-0.354, 0, 0.35>
   }
   
   cylinder {
      //*PMName segment - oben
      <0, 0.5, 0>, <0, 0, 0>, 0.62
      
      texture {
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            //*PMRawBegin
            ambient Black
            //*PMRawEnd
            roughness 0.05
         }
         scale 0.5
      }
      translate y*1.5
   }
   
   cylinder {
      //*PMName segment - mitte
      <0, 0.75, 0>, <0, -0.75, 0>, 0.62
      
      texture {
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            //*PMRawBegin
            ambient White*1.15
            
            //*PMRawEnd
            roughness 0.05
         }
         scale 0.5
      }
      translate <0, 0, 0>
   }
   
   cylinder {
      //*PMName segment unten
      <0, 0.5, 0>, <0, 0, 0>, 0.62
      
      texture {
         //*PMRawBegin
         Chrome_Metal
         //*PMRawEnd
         
         finish {
            //*PMRawBegin
            ambient Black
            //*PMRawEnd
            roughness 0.05
         }
         scale 0.5
      }
      translate y*(-2)
   }
   
   torus {
      0.5, 0.06
      scale 1
      rotate <0, 0, 0>
      translate y*(-2.5)
   }
   
   texture {
      //*PMRawBegin
      Gold_Metal
      //*PMRawEnd
   }
   scale 1
   rotate <0, 0, 0>
   translate <-22.3637, 0, 3.60773>
}

light_source {
   <0, 0, -15>, rgb <1, 1, 1>
}

light_source {
   <10.725, 1, 13.153>, rgb <0.9, 0.9, 0.9>
}

light_source {
   <-12.188, 0, -14.982>, rgb <0.5, 0.5, 0.5>
}

camera {
   perspective
   location <0.197467, 0, -20.1321>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <-20, 0, 0>
   angle 80
}