// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;



#declare Photons = on;
global_settings {
  assumed_gamma 1.0
  #if (Photons)          // global photon block
    photons {
      spacing 0.001                 // specify the density of photons
      //count 1000000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      //jitter 1.0                 // jitter phor photon rays
      //max_trace_level 5          // optional separate max_trace_level
      //adc_bailout 1/255          // see global adc_bailout
      //save_file "filename"       // save photons to file
      //load_file "filename"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }
  #end
}

// ----------------------------------------

camera {
  location  <0.0, 1.5, -4.0>
  direction 2*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
  rotate -12 * y
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-15, 100, -10>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}
  
  
  
  
  
  
  
  
  
#declare M_Glass=    // Glass material
material {
  texture {
    pigment { rgbt 0.8}
    finish {
      ambient 0.0
      diffuse 0.05
      specular 0.6
      roughness 0.005
      reflection {
        0.1, 1.0
        fresnel on
      }
      conserve_energy
    }
    
    
    
    normal{
          bump_map { 
            jpeg "lens.jpg" 
            map_type 0        // 0=planar
            interpolate 2     
            bump_size -8     
          } 
    }
    
  }
  interior {
    ior 1.5
    fade_power 1001
    fade_distance 0.9
    fade_color <0.5,0.8,0.6>
  }
  
}


box {
     0,
     1 
     scale 0.05 * z    
     material { M_Glass }
     rotate  90 * x
     translate <-0.5, 0.0, +0.5>
     
     
     photons{
          target 1.0          // spacing multiplier for photons hitting the object
          refraction on
          reflection off
     }
// photon block for an object
  photons{
    target 1.0          // spacing multiplier for photons hitting the object
    refraction on
    reflection on
    //collect off       // ignore photons
    //pass_through      // do not influence photons
  }
     
     
}


