// Define the various body parts of the Mech robot.


#ifndef (Lower_Left_Arm_Rotation)
   #declare Lower_Left_Arm_Rotation = 0;
#end 

#ifndef (Upper_Left_Arm_Rotation)
   #declare Upper_Left_Arm_Rotation = 0;
#end                       

#ifndef (Upper_Right_Leg_Rotation)
   #declare Upper_Right_Leg_Rotation = 0;
#end                       

#ifndef (Lower_Right_Leg_Rotation)
   #declare Lower_Right_Leg_Rotation = 0;
#end
                       
#ifndef (Lower_Left_Leg_Rotation)
   #declare Lower_Left_Leg_Rotation = 0;
#end  

#ifndef (Upper_Left_Leg_Rotation)
   #declare Upper_Left_Leg_Rotation = 0;
#end  

#ifndef (Lower_Right_Arm_Rotation)
   #declare Lower_Right_Arm_Rotation = 0;
#end  

#ifndef (Upper_Right_Arm_Rotation)
   #declare Upper_Right_Arm_Rotation = 0;
#end  

#ifndef (Upper_Body_Rotation)
   #declare Upper_Body_Rotation = 0;
#end  
//
// ********  MATERIALS  *******
//

#include "scorpionmat.inc"


//
// ********  Objects that build the robot parts  *******
//
         
#include "scorpionobj.inc"         

#declare Left_Red_Missiles = union {
  object { // LRM_6 -> LRM_5
    LRM_5
    photons {
      collect off
    }
    translate  0.3*y
  }
  object { LRM_5 }
  photons {
    collect off
  }
  translate  <-0.510317, -0.71, 0.010317>
}




//
// ********  OBJECTS  *******
//





#declare Blue_Missiles = union {
  object { // Streak_SRM3 -> Streak_SRM2
    Streak_SRM2
    photons {
      collect off
    }
    rotate <0.0, -0.0, -0.0>
    translate  <-0.080726, -0.0, -0.060545>
  }
  object { Streak_SRM2 }
  photons {
    collect off
  }
  scale 1.5
  translate  <-0.16603, -1.050937, -0.62811>
}


#declare Lower_Right_Leg = union {
  object { Knees1 }
  object { Shins1 }
  object { Ankles1 }
  object { Feet1 }
  // Scaling fixed
  // Rot Y limited (-10.0 to   90.0)
  // Translation fixed             
  
  rotate Lower_Right_Leg_Rotation*y
  rotate <180.0, 85.0, 180.0>
  translate  <-0.906305, 0.0, -1.97259>
}
#declare Right_Leg = union {
  object { Hips1 }
  object { Thighs1 }
  object { Lower_Right_Leg }
  material {
    Mechtextur
  }                      
  rotate Upper_Right_Leg_Rotation*y
  rotate <-5.0, -50.0, 0.0>
  translate  <-0.1, 1.89, 0.1>
}
#declare Lower_Left_Leg = union {
  object { Knees2 }
  object { Shins2 }
  object { Ankles2 }
  object { Feet2 }   
  rotate Lower_Left_Leg_Rotation*y
  translate  <1.6, 0.4, -1.5>
}
#declare Left_Leg = union {
  object { Hips2 }
  object { Thighs2 }
  object { Lower_Left_Leg }
  rotate Upper_Left_Leg_Rotation*y
  translate  <-0.1, -1.71, 0.1>
}
#declare Lower_Body = union {
  object { Pelvis }
  object { Right_Leg }
  object { Left_Leg }
  translate  <0.5, 0.71, -0.9>
}
#declare Nose = union {
  object { sPatchObj }
  object { sPatchObj2 }
  object { sPatchObj3 }
  object { sPatchObj4 }
  object { sPatchObj5 }
  object { // NoMercy -> sPatchObj2
    sPatchObj2
    material {
      Texture3
      scale <1.195839, 0.352643, 1.0>
      rotate 90.0*x
      translate <-2.116134, 0.000000, -0.473088>
    }
    no_shadow
    photons {
      collect off
      pass_through
    }
    translate  <0.0, -0.030994, 0.030994>
  }
  material {
    Mechtextur
  }
  photons {
    collect off
  }
  translate  <-0.5, -0.71, 0.0>
}


#declare Left_Hand_Weapons = union {
  object { LWGroup7 }
  object { LWGroup003 }
  object { Left_Lower_Gun }
  object { Left_Upper_Gun }
  photons {
    collect off
  }
  rotate 0.050419*y
  translate  <-0.984909, 1.572397, 1.589917>
}

#declare Lower_Left_Arm = union {
  object { Elbows1 }
  object { Forearm1 }
  object { Hand_Wire1 }
  object { Hand1 }
  object { Left_Hand_Weapons }  
  rotate Lower_Left_Arm_Rotation*y
  translate  <1.26, -0.6, -1.37>
}

#declare Left_Arm = union {
  object { Shoulder_Wire1 }
  object { Upper_Arms1 }
  object { Shoulder_Joint1 }
  box { // Left_Shoulder_Insignia
    <-1, -1, -1>, <1, 1, 1>
    material {
      Clan_Jade_Falcon
      scale 1.5
      rotate 90.0*x
      translate <-0.809515, 0.000000, -0.769039>
    }
    photons {
      collect off
    }
    scale <0.4, 0.01, 0.4>
    rotate 75.0*y
    translate  <0.033257, -0.705335, 0.013028>
  }
  object { Lower_Left_Arm }  
  rotate Upper_Left_Arm_Rotation*y 
  material { 
    Mechtextur
  }
  translate  <-0.24, -1.71, 0.5>
} 

#declare Lower_Right_Arm = union {
  object { Elbows }
  object { Forearm }
  object { Hand }
  object { Hand_Wire }
  object { Right_Weapons }   
  rotate Lower_Right_Arm_Rotation*y
  translate  <1.26, 0.5, -1.37>
}
#declare Right_Arm = union {
  object { Shoulder_Wire }
  object { Upper_Arms }
  object { Shoulder_Joint }
  object { Lower_Right_Arm }  
  rotate Upper_Right_Arm_Rotation*y
  translate  <-0.24, 1.79, 0.5>
  material {   //material seems to work better here since
    Mechtextur //when applied to whole body, the pattern rotates during animation
  }
}

#declare Upper_Body = union {
  object { Torso }
  object { Nose }
  object { Blue_Missiles }
  object { // Right_Red_Missiles -> Left Red Missiles
    Left_Red_Missiles
    photons {
      collect off
    }
    translate  2.2*y
  }
  object { Left_Shoulder_Box }
  object { Right_Shoulder_Box }
  box { // Top_Plate
    <-1, -1, -1>, <1, 1, 1>
    material {
      Logo1
      scale 2.0
      rotate -90.0*z
      translate <-1.000000, 1.000000, 0.000000>
    }
    no_shadow
    photons {
      collect off
      pass_through off
    }
    scale <0.5, 0.5, 0.01>
    translate  <-0.107256, 0.046651, 0.996499>
  }
  object { Left_Red_Missiles }
  object { Right_Arm }
  object { Left_Arm }
  translate  <0.5, 0.71, 0.0>
}

#declare Scorpion_Mech = union { // Scorpion
  object { Lower_Body }
  object { Upper_Body rotate Upper_Body_Rotation*z }
  material {
    Mechtextur
  }
  photons {
    collect off
  }
}
