#include "bezier.inc"
#include "colors.inc"
#include "textures.inc"

/*
 camera {
  location <0, .1, -50>
  right x*image_width/image_height
  angle 30
  look_at 0  //  always last
     }
light_source{ <300, 300, -1000> White }
background { color Gray50 }
*/
camera {location <0.0 , 1.0 ,-5.0>
        look_at  <0.0 , 1.0 , 0.0>}
// sun ------------------------------------
light_source{ <300, 300, -1000> White }
// sky ------------------------------------
sphere{ <0,0,0>,1 hollow 
       texture{
               
             pigment{
                       gradient <0,1,0>
                       color_map{
                         [0 color White]
                         [1 color Blue ]}
                      }// end of pigment
               finish{ambient 1 diffuse 0}
          }// end of texture
       scale 10000
      } // end of sphere

#declare M_Wood3A =
color_map {
    [0.0, 0.1 color rgb <0.57, 0.77, 0.51>
              color rgb <0.57, 0.77, 0.51>]
    [0.1, 0.9 color rgb <0.57, 0.77, 0.51>
              color rgb <0.47, 0.72, 0.46>]
    [0.9, 1.0 color rgb <0.47, 0.72, 0.46>
              color rgb <0.57, 0.77, 0.51>]
}

#declare M_Wood3B =
color_map {
    [0.0, 0.1 color rgbt <0.70, 0.60, 0.40, 0.100>
              color rgbt <0.70, 0.60, 0.40, 0.500>]
    [0.1, 0.9 color rgbt <0.70, 0.60, 0.40, 0.650>
              color rgbt <0.75, 0.70, 0.60, 0.975>]
    [0.9, 1.0 color rgbt <0.75, 0.70, 0.60, 0.975>
              color rgbt <0.70, 0.60, 0.40, 1.000>]
}

#declare P_WoodGrain3A = 
pigment {
    wood  
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    rotate <2,2,0>
}

#declare P_WoodGrain3B =
pigment {
    wood  
    turbulence <0.1, 0.5, 1> 
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2
}

#declare T_Wood3   =         
    texture { pigment { P_WoodGrain3A  color_map { M_Wood3A }}} 
    texture { pigment { P_WoodGrain3B  color_map { M_Wood3B }}}


#declare Hyperboloid_Y =
 quadric                 /* Vertical hyperboloid */
  {<100, -1,  100>,          /*                      */
   <0,  0,  0>,          /*            \   /     */
   <0,  0,  0>, -1       /* Like this:  ) (      */
  }                      /*            /   \     */


#declare stem =
intersection {
         plane { y, 0.7 }
         object { Hyperboloid_Y}
         object { Hyperboloid_Y inverse }
         plane { y, -0.7 inverse }
         texture {T_Wood3}
         //scale <.1, 1, .1>
         }


#declare stems =
union{
#declare Index = 0;
#while(Index <= 3)           //set of toruses for the sword handle
object{stem
 translate y*1.4*Index rotate z*-10}
 #declare Index = Index + 1;
#end
}
#declare leaf =
intersection {
    sphere { <1, 0, 1.732> 2.01 }
    sphere { <1, 0, 1.732> 2 inverse}
    box{ <0, 0, 0> < 2,  2, -2> rotate x*-10}
    box{ <0, 0, 0> < 2, -2, -2> rotate x*10}
   pigment{DarkGreen}
   }
   


object {stems}
object {stems rotate y*70 translate x*-0.5}




#declare BezRad = 0.01;
#declare BezTex = texture { pigment { ForestGreen  } finish { phong 1 } }
#declare FullCurve = true;

#declare branch1 = union{
object {leaf scale x*.7 rotate z*50 translate < 1,3,0>}
DrawSpline(array[4] { <0,1.5,0>,<0.3,1.9,0>,< 0.3,2.2,0>,< 1,3,0> })
object {leaf scale <.5,1.2,1.2> rotate x*25 translate < 0,1.5,0>}
object {leaf translate x*-2 scale <.6,1.1,0.7> rotate <45,40,0> translate < 0,1.5,0>}
DrawSpline(array[4] { <-1,-0.9,-0.5>,<-0.3,0.8,-0.3>,< -0.3,1.1,0>,< 0,1.5,0> })
}

object {branch1}