// Date: 21/08/2004
// Con Radiosity a 1280 2h 56' 47" sul PC di casa
// Aggiunta neve sulla torta secondo suggerimenti dal news.povray.org (povray.binaries.images)
// Sul PC dell'ufficio a 1280 1h 15' 17"
// Si potrebbe anche aggiungere media ed una luce che viene dal cielo, ma ci metterebbe un mese a tracciarlo.... 

#version 3.5;

#include "colors.inc"
#include "textures.inc"

#include "tortaneve.inc"
#include "ciotola.inc"
#include "candelabig.inc"
#include "monster.inc"


// uncomment to render with radiosity
/*
global_settings {
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "file_name"       // save radiosity data
    //load_file "file_name"       // load saved radiosity data
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}
*/

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

// ----------------------------------------

camera {
  location  <-1, 10, -20>
  angle 60
  look_at   <0, 3, -2>
}

light_source {<-10, 20, 100> rgb 1 shadowless}
light_source {<0, 60, 0> rgb .5}


fog{ fog_type   2
     distance   50
     color      Black
     fog_offset 0.1
     fog_alt    2.0
     turbulence 0.8
   }
   
// ground ------------------------------------------------------------------

plane { <0,1,0>, 0 
        texture { pigment{color rgb<0.35,0.65,0.0>}
                  normal {bumps 0.75 scale 0.015  }
                  finish {ambient 0.1 diffuse 0.8 }
                }
      }


#declare monster_candela=union {

	object { monster 
		//scale 0.1
 	 	//rotate <0,-60,0>
		translate <0.5,.5,-2.5>
	}
	object {
		ciotola
		scale 0.15
		translate <-1.2,2.0,-2.4>
		texture {pigment {Red}}
	}
	object{
		Candle
		scale 0.15
		translate <0,1,-4>
	}
	// create a point "spotlight" (conical directed) light source
	light_source {
	  0*x                     // light's position (translated below)
	  color rgb <1,1,1>       // light's color
	  spotlight               // this kind of light source
	  translate <0, 2, -4> // <x y z> position of light
	  point_at <0, 0, 0>      // direction of spotlight
	  radius 5                // hotspot (inner, in degrees)
	  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
	  falloff 8               // intensity falloff radius (outer, in degrees)
	}
}



object {
	torta
	scale 1.8
}


// Prima fila di monsters (16)
#declare ig=16; //16
#declare angolo=22.5;
#declare raggio=9.3;
#declare altezza=0;
#while (ig>=0)
	object {
		monster_candela
		translate <raggio,altezza,0>
		rotate <0,angolo*ig,0>
	}
	#declare ig=ig-1;	
#end

// Seconda fila di monsters (16)
#declare ig=16;
#declare angolo=22.5;
#declare raggio=5.7;
#declare altezza=1.85;
#while (ig>=0)
	object {
		monster_candela
		translate <raggio,altezza,0>
		rotate <0,angolo*ig,0>
	}
	#declare ig=ig-1;	
#end

// Terza fila di monsters (8)

#declare ig=8;
#declare angolo=45;
#declare raggio=2.1;
#declare altezza=3.65;
#while (ig>=0)
	object {
		monster_candela
		translate <raggio,altezza,0>
		rotate <0,angolo*ig,0>
	}
	#declare ig=ig-1;	
#end

