// Date: 22/05/2004
//

#version 3.5;

#include "colors.inc"
#include "textures.inc"

#include "torta.inc"
#include "ciotola.inc"
#include "candela.inc"
#include "Cassidy.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

// ----------------------------------------

camera {
  location  <-1, 10, -20>
  angle 60
  look_at   <0, 3, -2>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------
/*
plane {  // floor
  y, 0
  texture {
    pigment {
	  hexagon 
		pigment { Jade },
    	pigment { White_Marble },
    	pigment { Blue_Agate }
    }
    finish{
      diffuse 0.8
      ambient 0.1
    }
  }
}
*/

/*
plane { <0,1,0>, 0 
        texture{ pigment{color rgb<0.35,0.65,0.0>}
	         normal {bumps 0.75 scale 0.015}
                 finish {ambient 0.1 diffuse 0.8}
               } // end of texture
      } // end of plane
*/


fog{ fog_type   2
     distance   50
     color      White
     fog_offset 0.1
     fog_alt    2.0
     turbulence 0.8
   }
// ground ------------------------------------------------------------------

plane { <0,1,0>, 0 
        texture { pigment{color rgb<0.35,0.65,0.0>}
                  normal {bumps 0.75 scale 0.015  }
                  finish {ambient 0.1 diffuse 0.8 }
                }
      }


#declare gatto_candela=union {
	object { Cassidy (<-30,20,0>)
		scale 0.1
 	 	//rotate <0,-60,0>
		//translate <0,0,-9>
	}
	object {
		ciotola
		scale 0.09
		translate <-0.7,1.8,0>
		texture {pigment {Red}}
	}
	object{
		Candle
		scale 0.04
		translate <-0.8,2.2,-0.35>
	}
}



object {
	torta
	scale 1.8
}


// Prima fila di gatti (16)
#declare ig=16;
#declare angolo=22.5;
#declare raggio=9.3;
#declare altezza=0;
#while (ig>=0)
	object {
		gatto_candela
		translate <raggio,altezza,0>
		rotate <0,angolo*ig,0>
	}
	#declare ig=ig-1;	
#end

// Seconda fila di gatti (16)

#declare ig=16;
#declare angolo=22.5;
#declare raggio=5.7;
#declare altezza=1.85;
#while (ig>=0)
	object {
		gatto_candela
		translate <raggio,altezza,0>
		rotate <0,angolo*ig,0>
	}
	#declare ig=ig-1;	
#end

// Terza fila di gatti (8)

#declare ig=8;
#declare angolo=45;
#declare raggio=2.1;
#declare altezza=3.65;
#while (ig>=0)
	object {
		gatto_candela
		translate <raggio,altezza,0>
		rotate <0,angolo*ig,0>
	}
	#declare ig=ig-1;	
#end

