#declare tex_specchio=texture {
    pigment {
      color rgb <0.8,0.8,1.0>
    }
    finish{
      diffuse 0.3
      ambient 0.0
      specular 0.6
      reflection {
        0.8
        metallic
      }
      conserve_energy
    }
}

#declare tex_torta=texture {
	//pigment {color White}
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         normal
         {
            bumps , 2.0
            scale  0.15
         }      
         finish
         {
            ambient 0.3
            diffuse 0.6
            phong 0.25
            phong_size 20.0
            roughness 0.0
         }
	
}

#declare T_pallina = texture {      
     pigment {
        color rgb <1.0, 0, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_verde = texture {      
     pigment {
        color rgb <0, 1, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_gialla = texture {      
     pigment {
        color rgb <1.0, 1.0, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_blu = texture {      
     pigment {
        color rgb <0, 0, 1>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare torta=union {
	union {
		cylinder { <0, 0, 0>, <0, 1, 0>, 5 }
		cylinder { <0, 1, 0>, <0, 2, 0>, 3 }
		cylinder { <0, 2, 0>, <0, 3, 0>, 1 }
		texture {tex_torta}
	}
	// Banda rossa sotto
	#declare it=60;
	union {
		#while (it>0)
			sphere {
				<0,0,0> 0.2 
				texture {T_pallina_verde}
				translate <4.9,0.5+0.4*sin(it),0>
				rotate <0,6*it,0>
			}
			#declare it=it-1;
		#end
	}
	// Banda gialla media
	#declare it=60;
	union {
		#while (it>0)
			sphere {
				<0,0,0> 0.2 
				texture {T_pallina_blu}
				translate <2.9,1.5+0.4*sin(it),0>
				rotate <0,6*it,0>
			}
			#declare it=it-1;
		#end
	}
	// Banda rossa sopra
	#declare it=20;
	union {
		#while (it>0)
			sphere {
				<0,0,0> 0.2 
				texture {T_pallina}
				translate <0.9,2.5+0.4*sin(it),0>
				rotate <0,18*it,0>
			}
			#declare it=it-1;
		#end
	}
}