#include "makesnow.inc"
#declare Particles=5000; // number of snow particles
#declare Size=0.2; // size of the largest snow particle
#declare Thickness=0.5; // thickness of the particles      
#declare MinHeight=0; // snow starts falling from this height ( 1 = max height of the object)
#declare MaxHeight=1.3; // snow stops falling from this height  ( 1 = max height of the object)
#declare Direction=-y+x*0.2+z*0.3; // Direction of gravity, wind etc.(-y = vertical, no wind)


#declare tex_specchio=texture {
    pigment {
      color rgb <0.8,0.8,1.0>
    }
    finish{
      diffuse 0.3
      ambient 0.0
      specular 0.6
      reflection {
        0.8
        metallic
      }
      conserve_energy
    }
}

#declare tex_torta=texture {
	//pigment {color White}
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         normal
         {
            bumps , 2.0
            scale  0.15
         }      
         finish
         {
            ambient 0.3
            diffuse 0.6
            phong 0.25
            phong_size 20.0
            roughness 0.0
         }
	
}

#declare T_pallina = texture {      
     pigment {
        color rgb <1.0, 0, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_verde = texture {      
     pigment {
        color rgb <0, 1, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_gialla = texture {      
     pigment {
        color rgb <1.0, 1.0, 0>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare T_pallina_blu = texture {      
     pigment {
        color rgb <0, 0, 1>
     }      
     finish {
         ambient 0.1
         diffuse 0.65
         brilliance 1.5
         specular 0.85
         roughness 0.01
         reflection 0.45
     }
}

#declare tortabase=union {
		cylinder { <0, 0, 0>, <0, 1, 0>, 5 }
		cylinder { <0, 1, 0>, <0, 2, 0>, 3 }
		cylinder { <0, 2, 0>, <0, 3, 0>, 1 }
		texture {tex_torta}
}

#declare torta=union {
    union{
        object{tortabase}
        object{
            MakeSnow(tortabase,Particles,Size,Thickness,MinHeight,MaxHeight,Direction)
            scale <0.95,1,1>
       }
    }
	// Banda rossa sotto
	#declare it=60;
	union {
		#while (it>0)
			sphere {
				<0,0,0> 0.2 
				texture {T_pallina_verde}
				translate <4.9,0.5+0.4*sin(it),0>
				rotate <0,6*it,0>
			}
			#declare it=it-1;
		#end
	}
	// Banda gialla media
	#declare it=60;
	union {
		#while (it>0)
			sphere {
				<0,0,0> 0.2 
				texture {T_pallina_blu}
				translate <2.9,1.5+0.4*sin(it),0>
				rotate <0,6*it,0>
			}
			#declare it=it-1;
		#end
	}
	// Banda rossa sopra
	#declare it=20;
	union {
		#while (it>0)
			sphere {
				<0,0,0> 0.2 
				texture {T_pallina}
				translate <0.9,2.5+0.4*sin(it),0>
				rotate <0,18*it,0>
			}
			#declare it=it-1;
		#end
	}
}


////////////////////////
                        
/*


object {
	torta
	//scale 1.8
} 



global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

camera {
  location  <-1, 4, -8>
  angle 60
  look_at   <0, 2, -1>
}

plane { <0,1,0>, 0 
        texture { pigment{color rgb<0.35,0.65,0.0>}
                  normal {bumps 0.75 scale 0.015  }
                  finish {ambient 0.1 diffuse 0.8 }
                }
      }

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}
*/