// -----------------------------------------------------------------------------
// 2024-12-25, lb
// v3
// -----------------------------------------------------------------------------
#version 3.8;



// -----------------------------------------------------------------------------
// --- INCLUDES ----------------------------------------------------------------
// -----------------------------------------------------------------------------
#include "colors"
#include "math"
//#include "myMacros"

//#declare displayAxis = true;
#declare areaLights = false;




// -----------------------------------------------------------------------------
// --- SETTINGS ----------------------------------------------------------------
// -----------------------------------------------------------------------------
global_settings {
	assumed_gamma 1.80
	max_trace_level 5 
	}

#default {
	finish {
		ambient 0.00
		emission 0.40
		diffuse 0.60
		}
	} 


// -----------------------------------------------------------------------------
// --- SCENE -------------------------------------------------------------------
// -----------------------------------------------------------------------------
#declare CameraDistance = 50;
camera {
//	location p2r(30, 20, CameraDistance, true)
	location <40,  17,  24>
	up y
	right x*image_width/image_height
	look_at <0, 0, 0>
	angle 36
	}

// --------------------------------------------------------------------------
// --- area_light size is power of 2 plus 1
// --- 2^2+1 = 5, 2^3+1 = 9, 2^4+1 = 17, 2^5+1=33, 2^6+1=65...
// --------------------------------------------------------------------------
#macro alPower (number) 1+pow(2,number) #end

#declare areaSize = CameraDistance*4;
#declare areaPower = alPower(3);
light_source {
//	p2r(30, 30, 100,true)
	<75, 50, 43>

	color White
	#if (areaLights)
		#debug "\n--- Using area lights\n"
		area_light -<areaSize, 0, areaSize>, +<areaSize, 0, areaSize>, areaPower, areaPower
		adaptive 1
		jitter 
		orient 
		circular 
	#end
	}


sky_sphere {
	pigment {
		function { abs(y) }
		color_map {
			[0.0 color SlateBlue*0.50 ]
			[1.0 color White*1.25 ]
			}
		}
	}


//#if (displayAxis)
//	drawAxis(12, 0.03)
//#end



// -----------------------------------------------------------------------------
// --- FUNCTIONS ---------------------------------------------------------------
// -----------------------------------------------------------------------------

// MathMod : "PrettyBall_1 by Abderrahman Taha 03/08/2020"

// --- Const
#declare L = 23/2;
#declare c = 1/10000;
#declare Th2 = -8/10;
#declare Th1 = 5/10;
#declare N = 2;


// "Iso=cos(x)*sin(y)+cos(y)*sin(z)+cos(z)*sin(x)",
#declare Iso = function (x,y,z,p) { cos(x)*sin(y) + cos(y)*sin(z) + cos(z)*sin(x) }


// "DFx=((Iso(x+c,y,z,p)-Iso(x,y,z,p))/c)",
#declare DFx = function (x,y,z,p) { (Iso(x+c,y,z,p)-Iso(x,y,z,p))/c }

// "DFy=((Iso(x,y+c,z,p)-Iso(x,y,z,p))/c)",
#declare DFy = function (x,y,z,p) { (Iso(x,y+c,z,p)-Iso(x,y,z,p))/c }

// "DFz=((Iso(x,y,z+c,p)-Iso(x,y,z,p))/c)",
#declare DFz = function (x,y,z,p) { (Iso(x,y,z+c,p)-Iso(x,y,z,p))/c }

// "Rapp=(x/sqrt(x*x+y*y+z*z))",
#declare Rapp = function (x,y,z,p) { x/sqrt(x*x+y*y+z*z) }

// "Iso2=(Iso(x+Th2*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),y+Th2*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),z+Th2*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),p))",
#declare Iso2 = function (x,y,z,p) {
	Iso (
		x+Th2*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),
		y+Th2*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),
		z+Th2*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),
		p
		)
	}

// "Iso3=(Iso(x-Th2*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),y-Th2*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),z-Th2*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),p))",
#declare Iso3 = function (x,y,z,p) {
	Iso (
		x-Th2*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),
		y-Th2*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),
		z-Th2*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),
		p
		)
	}

// "Iso4=(Iso(x+Th1*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),y+Th1*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),z+Th1*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),p))",
#declare Iso4 = function (x,y,z,p) {
	Iso (
		x+Th1*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),
		y+Th1*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),
		z+Th1*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),
		p
		)
	}

// "Iso5=(Iso(x-Th1*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),y-Th1*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),z-Th1*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),p))",
#declare Iso5 = function (x,y,z,p) {
	Iso (
		x-Th1*Rapp(DFx(x,y,z,p),DFy(x,y,z,p),DFz(x,y,z,p),p),
		y-Th1*Rapp(DFy(x,y,z,p),DFz(x,y,z,p),DFx(x,y,z,p),p),
		z-Th1*Rapp(DFz(x,y,z,p),DFx(x,y,z,p),DFy(x,y,z,p),p),
		p
		)
	}

// "isoCondition=(x^N+y^N+z^N-(L-1/10)^N)",
#declare isoCondition = function (x,y,z,p) { pow(x,N) + pow(y,N) + pow(z,N) - pow(L-1/10,N) }

// "ThickIso2=(Iso4(x,y,z,p)*Iso5(x,y,z,p))",
#declare ThickIso2 = function (x,y,z,p) { Iso4(x,y,z,p)*Iso5(x,y,z,p) }



// -----------------------------------------------------------------------------
// "GyroidLatice_1=if(isoCondition(x,y,z,p)<(0),Iso2(x,y,z,p),1)-exp(isoCondition(x,y,z,p)/5)",
#declare GyroidLatice_1 = function (x,y,z,p) {
	select (
		isoCondition(x,y,z,p),	// condition
		Iso2(x,y,z,p),				// < 0
		1								// >0 0	
		)
	-exp(isoCondition(x,y,z,p)/5)
	}


// "GyroidLatice_2=if(isoCondition(x,y,z,p)<(0),Iso3(x,y,z,p),1)+exp(isoCondition(x,y,z,p)/5)",
#declare GyroidLatice_2 = function (x,y,z,p) {
	select (
		isoCondition(x,y,z,p),	// condition
		Iso3(x,y,z,p),				// < 0
		1								// >=0
		)
	+exp(isoCondition(x,y,z,p)/5)
	}

// "GyroidLatice_3=if(isoCondition(x,y,z,p)<(0),phickIso2(x,y,z,p),1)+exp(isoCondition(x,y,z,p)/5)"
#declare GyroidLatice_3 = function (x,y,z,p) {
	select (
		isoCondition(x,y,z,p),	// condition
		ThickIso2(x,y,z,p),		// < 0
		1								// >= 0	
		)
	+exp(isoCondition(x,y,z,p)/5)
	}





// -----------------------------------------------------------------------------
#declare Color1 = rgb <0.285437, 0.207759, 0.106593>;
#declare Color2 = rgb <0.2837, 0.2731, 0.2290>; // OK
#declare Color3 = rgb <0.908712, 0.782364, 0.605954>; // OK

#declare Finish = finish {
	specular 1
	roughness 0.0005
	metallic 1.0
//	brilliance 2
	}



isosurface {
	function { GyroidLatice_1(x,y,z,0) }
	max_gradient 3424
	contained_by { sphere { <0,0,0>, +L } }
	open
	
	pigment { Color1  }
	finish { Finish }
	}

isosurface {
	function { GyroidLatice_2(x,y,z,0) }
	max_gradient 4512
	contained_by { sphere { <0,0,0>, +L } }
	open
	
	pigment { Color2  }
	finish { Finish }
	}

isosurface {
	function { GyroidLatice_3(x,y,z,0) }
	max_gradient 162
	contained_by { sphere { <0,0,0>, +L } }
	open
	
	pigment { Color3  }
	finish { Finish }
	}
	








// --- eof ---------------------------------------------------------------------
