// The pool itself
difference {
	box {<-14,-16,-20>,<14,0,20>}
	box {<-9,-15,-15>, <9,1,15>}
	texture {
		pigment {color rgb 1}
		normal {bumps 1/8 scale 1/(12*50)}
	}
}

#declare tile = intersection {
	box {<1/4-6,0,1/4-6>*inches,<6-1/4,1/4,6-1/4>*inches}
	union {
		#declare corner = <6-1/2,0,6-1/2>*inches;
		sphere {corner, inch/4}
		sphere {corner*<1,0,-1>, inch/4}
		sphere {corner*<-1,0,1>, inch/4}
		sphere {corner*<-1,0,-1>, inch/4}
		cylinder {corner, corner*<1,0,-1>, inch/4}
		cylinder {corner, corner*<-1,0,1>, inch/4}
		cylinder {corner*<-1,0,-1>, corner*<1,0,-1>, inch/4}
		cylinder {corner*<-1,0,-1>, corner*<-1,0,1>, inch/4}
		box {corner, corner*<-1,0,-1>+y}
	}
	texture {
		pigment {
			gradient z
			color_map {
				[0.0 color rgb 0]
				[0.2 color rgb y/4]
				[0.5 color rgb z/2]
				[1.0 color rgb z/3]
			}
			turbulence 2.5
		}
		finish {specular 1}
		scale 1/2
	}
}

#declare c = -14.5;
#while (c <= 14.5)
	object {tile rotate -z*90 translate <-9,-6*inches,c>}
	object {tile rotate -z*90 translate <-9,-18*inches,c>}
	object {tile rotate -z*90 translate <-9,-30*inches,c>}
	object {tile              translate <-9.5,0,c>}
	object {tile              translate <-10.5,0,c>}
	object {tile              translate <-11.5,0,c>}
	
	object {tile rotate z*90 translate <9,-6*inches,c>}
	object {tile rotate z*90 translate <9,-18*inches,c>}
	object {tile rotate z*90 translate <9,-30*inches,c>}
	object {tile             translate <9.5,0,c>}
	object {tile             translate <10.5,0,c>}
	object {tile             translate <11.5,0,c>}
#declare c = c + 1;
#end

#declare c = -8.5;
#while (c <= 8.5)
	object {tile rotate -x*90 translate <c,-6*inches,15>}
	object {tile rotate -x*90 translate <c,-18*inches,15>}
	object {tile rotate -x*90 translate <c,-30*inches,15>}
	object {tile              translate <c,0,15.5>}
	object {tile              translate <c,0,16.5>}
	object {tile              translate <c,0,17.5>}
	
	object {tile rotate x*90 translate <c,-6*inches,-15>}
	object {tile rotate x*90 translate <c,-18*inches,-15>}
	object {tile rotate x*90 translate <c,-30*inches,-15>}
	object {tile             translate <c,0,-15.5>}
	object {tile             translate <c,0,-16.5>}
	object {tile             translate <c,0,-17.5>}
#declare c = c + 1;
#end

#declare c1 = 0;
#while (c1 < 3)
	#declare c2 = 0;
	#while (c2 < 3)
		object {tile translate <9.5+c1, 0, 15.5+c2>}
		object {tile translate <9.5+c1, 0, 15.5+c2> scale < 1,1,-1>}
		object {tile translate <9.5+c1, 0, 15.5+c2> scale <-1,1, 1>}
		object {tile translate <9.5+c1, 0, 15.5+c2> scale <-1,1,-1>}
	#declare c2 = c2 + 1;
	#end
#declare c1 = c1 + 1;
#end

#declare pool_light = union {
	difference {
		sphere {0, 1/2}
		sphere {0, 9/20}
		texture {
			pigment {color transmit 1}
			finish {specular 1}
		}
		interior {
			ior 1.5
		}
		scale <1,1/4,1>
	}
	light_source {
		y/16
		color rgb <4,4,3>/5
		fade_distance 1/2
		fade_power 2
	}
}

#declare c = -12.5;
#while (c <= 12.5)
	object {pool_light rotate -z*90 translate <-9,-12,c>}
	object {pool_light rotate z*90 translate <9,-12,c>}
#declare c = c + 8;
#end

#declare c = -8;
#while (c <= 8)
	object {pool_light rotate x*-90 translate <c,-12,15>}
	object {pool_light rotate x*90 translate <c,-12,-15>}
#declare c = c + 8;
#end
