/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */
#declare Beam3= cylinder {<0,0,0><0,200,0>,0.75 pigment{Beam_pigment} no_shadow} ;


#include "logotex.inc"

#declare LDEPTH = 20       ;

//DLM no trihy font - change text below to use myfont variable
//#declare myfont="trihy.ttf";
#declare myfont="cyrvetic.ttf";
#declare NCENTURY =
text { ttf myfont, "CENTURY",  (LDEPTH - 1.4),  0}
#declare NPOV =
text { ttf myfont, "POV",  (LDEPTH - 1.4),  0}
#declare N1 =
text { ttf myfont, "1",  (LDEPTH - 1.4),  0}
#declare N3 =
text { ttf myfont, "3",  (LDEPTH - 1.4),  0}
#declare NT =
text { ttf myfont, "t",  (LDEPTH - 1.4),  0}
#declare NH =
text { ttf myfont, "h",  (LDEPTH - 1.4),  0}

#declare LOGO =
union {
box {<-8.00,-10.90,0.20><8.00,0.00,LDEPTH> texture{Logo_lower}}
box {<-8.20,0.00,0.00><8.20,0.40,LDEPTH> texture{Logo_lower}}
box {<-7.60,0.40,0.60><7.60,1.30,LDEPTH> texture{Logo_lower}}
box {<-7.80,1.30,0.40><7.80,1.70,LDEPTH> texture{Logo_lower}}
box {<-7.20,3.00,1.00><7.20,3.40,LDEPTH> texture{Logo_upper}}
box {<-7.20,5.40,1.00><7.20,5.80,LDEPTH> texture{Logo_upper}}
box {<-7.20,7.30,1.00><7.20,7.70,LDEPTH> texture{Logo_upper}}
box {<-8.00,7.70,0.20><8.00,8.10,LDEPTH> texture{Logo_upper}}

difference {
	box {<-7.20,1.70,1.00><7.20,3.00,LDEPTH> texture{Logo_lower}}

	box {<-10,-10,0><10,10,-10> rotate <17,0,0> translate <0,1.7,1> texture{Logo_lower}}
	box {<0,-10,-10><10,10,(LDEPTH + 5)> rotate <0,0,17> translate <7.2,1.7,0> texture{Logo_lower}}
	box {<0,-10,-10><-10,10,(LDEPTH + 5)> rotate <0,0,-17> translate <-7.2,1.7,0> texture{Logo_lower}}
}

object {NPOV 		scale <6.84,2.86,1>  translate <-6.86,3.40,1.40> texture{Logo_upper}}
object {NCENTURY 	scale <2.79,2.16,1>  translate <-6.83,5.80,1.40> texture{Logo_upper}}
object {N1 			scale <12.98,8.87,1> translate <-8.00,8.10,1.40> texture{Logo_upper}}
object {N3 			scale <13.12,8.68,1> translate <-2.74,8.10,1.40> texture{Logo_upper}}
object {NH 			scale <2.36,5.11,1>  translate <5.44,8.10,1.40> texture{Logo_upper}}
object {NT 			scale <2.30,3.76,1>  translate <4.70,8.10,1.40> texture{Logo_upper}}

#include "arch1.inc"
object {Arch scale .5 translate <8.00,-5,3> texture{Logo_lower}}

#include "platform.inc"
object {Platform translate <4,-7,0> texture{Logo_lower}}

#include "platform2.inc"
object {Platform2 translate <0,3,0> texture{Logo_lower}}

light_source
{
  <-4, -1, -10>
  color rgb <1,1,1>
  spotlight
  point_at <-3, 7, 1>
  radius 60
  tightness 50
  falloff 20
  //DLM atmosphere off
}

object {Beam3 translate <-5,-20,10>}
object {Beam3 rotate <0,0,-25> translate <-10,-20,25>}

}








