// Persistence of Vision Ray Tracer Scene Description File
// File: gettime.pov
// Vers: 3.1
// Desc: Use to get system time after gettime.bat file is run.
// Date: 99.66 
// Auth: Bob Hughes
// Mail: inversez@aol.com?Subject=PoV-Scene
/* Note: Use with Gettime.ini to run the batch file gettime.bat via Pre_Scene_Command.
         Acquires the current system time. Could be used to operate other parameters,
         for example by using the HourTime and MinuteTime values.
         Font used here is needed to align correctly, a change would necessitate realignment.
*/

#fopen MyFile "c:\gottime.txt" read

#read (MyFile,MyTime)

#fclose MyFile

#declare HourTime = val(substr(MyTime,20,2))
#declare MinuteTime = val(substr(MyTime,23,2))
#declare DayTime = substr(MyTime,31,1)

#declare Hours = str(HourTime,2,0)
#declare Minutes = str(MinuteTime,2,0)

#declare SystemTime =
 concat("Time is      Hours and       Minutes")

 text{ttf "timrom.ttf",SystemTime,0.05,0 scale <.75,1.25,1> translate -y/2
  pigment {rgb 1}
   finish {ambient 1}
  translate -5.75*x
}

#declare HTime =
 concat("             ", str(HourTime,2,0))

 text{ttf "timrom.ttf",HTime,0.05,0 scale <.75,1.25,1> translate -y/2

#if (HourTime<7) pigment {rgb <1,.25,0>} #else  pigment {rgb <1,1,0>} #end
   finish {ambient 1}
  translate -5.75*x
}

#declare MTime =
 concat("                                    ", str(MinuteTime,2,0))

 text{ttf "timrom.ttf",MTime,0.05,0 scale <.75,1.25,1> translate -y/2

#if (MinuteTime<31) pigment {rgb <1,0,.25>} #else  pigment {rgb <1,0,1>} #end
   finish {ambient 1}
  translate -5.75*x
}

#declare DTime =
 concat("                                                        ", DayTime,"m")

 text{ttf "timrom.ttf",DTime,0.05,0 scale <.75,1.25,1> translate -y/2

//#if (DayTime!="p") // no obvious way of trapping a letter?
 pigment {rgb <0,1,1>}// #else  pigment {rgb <0,.25,1>} #end
   finish {ambient 1}
  translate -5.75*x
}

// backdrop
#if (HourTime<6)
 #if (MinuteTime<30)
 
 sphere {0,1 scale <8,1.75,1> pigment {rgb<.75,.25,.5>} finish {specular .5 roughness .025 reflection .25} translate 3*z}

 #else

 sphere {0,1 scale <8,1.75,1> pigment {rgb<0,.75,0>} finish {specular .5 roughness .025 reflection .25} translate 3*z}

 #end

#else
 #if (MinuteTime<30)

 sphere {0,1 scale <8,1.75,1> pigment {rgb<.75,.25,1>} finish {specular .5 roughness .025 reflection .25} translate 3*z}
 #else

 sphere {0,1 scale <8,1.75,1> pigment {rgb<.25,1,.5>} finish {specular .5 roughness .025 reflection .25} translate 3*z}

#end
#end

background {rgb .33}

light_source {<-5,10,-100>, rgb 1}

camera {
  location  <0,0,-26>
  up y right 5*x
  angle 27
  look_at   <0,0,0>
}
