//      BALL_NO                 The number of the ball
//      BALL_INSERTION          Insertion point of ball 0=center 1=quadrant corner        default=0
//      BALL_RADIUS             Radius of ball                                            default=0.5
//      BALL_TRANSLATION          Translation of ball                                       default=<0,0,0> 
//      BALL_C1                 Color of ball#1                                           default=about right
//      BALL_C2                 Color of ball#2                                           .......
//      ....... and so on
//      BALL_CW                 Color of white ball                                       .......

//      BALL_REFLECTION         Reflection value in finish-statement                      default=0.1
//      BALL_SPECULAR           Specular value                                            default=1     
//      BALL_DIFFUSE            Diffusion value                                           default=0.7     
//      BALL_ROUGHNESS          Roughness value                                           default=0.0005     
//      BALL_RX                 Ball rotation x                                           default=random
//      BALL_RY                 Ball rotation y                                           default=random
//      BALL_RZ                 Ball rotation z                                           default=random
//      BALL_SEEDVAL            Seed value     


#ifndef (BALL_CW) #declare BALL_CW=pigment{rgb<1,0.95,0.8>} #end   
#ifndef (BALL_SEEDVAL) #declare BALL_SEEDVAL = seed(6521); #end // Please feel free to change seed value if needed  
#ifndef (BALL_RADIUS) #declare BALL_RADIUS=0.5; #end
#ifndef (BALL_RX) #declare BALL_RX=rand(BALL_SEEDVAL)*360; #end
#ifndef (BALL_RY) #declare BALL_RY=rand(BALL_SEEDVAL)*360; #end
#ifndef (BALL_RZ) #declare BALL_RZ=rand(BALL_SEEDVAL)*360; #end  
#ifndef (BALL_INSERTION) #declare BALL_INSERTION=0; #end 
#ifndef (BALL_TRANSLATION) #declare BALL_TRANSLATION=<0,0,0>; #end

#ifndef (BALL_REFLECTION) #declare BALL_REFLECTION=0.1; #end
#ifndef (BALL_DIFFUSE) #declare BALL_DIFFUSE=0.7; #end
#ifndef (BALL_SPECULAR) #declare BALL_SPECULAR=1; #end
#ifndef (BALL_ROUGHNESS) #declare BALL_ROUGHNESS=0.0005; #end




#switch (BALL_NO)


#case(0)  // White ball
sphere{<0, 0, 0> BALL_RADIUS 
pigment {BALL_CW} 
finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}
rotate<BALL_RX,BALL_RY,BALL_RZ>
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS
}
#break

#case(1)
#ifndef (BALL_C1) #declare BALL_C1=pigment{rgb<1,0.7,0.18>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C1} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "I" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.04*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "I" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.04*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.04*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.04*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break
  
  
  
  
#case(2) 
#ifndef (BALL_C2) #declare BALL_C2=pigment{rgb<0,0.21,0.38>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C2} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break               

#case(3) 
#ifndef (BALL_C3) #declare BALL_C3=pigment{rgb<0.73,0,0.17>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C3} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(4)
#ifndef (BALL_C4) #declare BALL_C4=pigment{rgb<0.17,0.17,0.34>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C4} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.14*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.14*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.14*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.14*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(5)
#ifndef (BALL_C5) #declare BALL_C5=pigment{rgb<0.94,0.35,0.16>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C5} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(6)
#ifndef (BALL_C6) #declare BALL_C6=pigment{rgb<0.1,0.4,0.3>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C6} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "6" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.12*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "6" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.12*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "6" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.12*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "6" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.12*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(7)
#ifndef (BALL_C7) #declare BALL_C7=pigment{rgb<0.42,0.086,0.176>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C7} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "7" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "7" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "7" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "7" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(8)
#ifndef (BALL_C8) #declare BALL_C8=pigment{rgb<0,0,0>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_C8} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "8" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "8" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "8" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "8" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(9)
#ifndef (BALL_C9) #declare BALL_C9=pigment{rgb<1,0.7,0.18>}     #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C9} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "9" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "9" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "9" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "9" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.11*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break  

#case(10)
#ifndef (BALL_C10) #declare BALL_C10=pigment{rgb<0,0.21,0.38>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C10} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "I0" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "I0" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I0" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I0" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(11)
#ifndef (BALL_C11) #declare BALL_C11=pigment{rgb<0.73,0,0.17>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C11} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "II" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.10*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "II" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.10*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "II" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.10*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "II" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.10*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(12)
#ifndef (BALL_C12) #declare BALL_C12=pigment{rgb<0.17,0.17,0.34>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C12} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "I2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "I2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I2" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(13)
#ifndef (BALL_C13) #declare BALL_C13=pigment{rgb<0.94,0.35,0.16>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C13} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "I3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "I3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I3" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(14)
#ifndef (BALL_C14) #declare BALL_C14=pigment{rgb<0.1,0.4,0.3>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C14} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "I4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "I4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I4" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break

#case(15)
#ifndef (BALL_C15) #declare BALL_C15=pigment{rgb<0.42,0.086,0.176>} #end
union{difference{union{difference{sphere{<0, 0, 0> BALL_RADIUS} 
cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
box{<-2*BALL_RADIUS,-2*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,-0.5*BALL_RADIUS,2*BALL_RADIUS>}
box{<-2*BALL_RADIUS,0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,2*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_C15} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS} cylinder{-2*BALL_RADIUS*z, 2*BALL_RADIUS*z,0.3*BALL_RADIUS}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}}
text { ttf "trebucbd.ttf" "I5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
text { ttf "trebucbd.ttf" "I5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0>} 
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
intersection{sphere{<0, 0, 0> BALL_RADIUS}
text { ttf "trebucbd.ttf" "I5" BALL_RADIUS*2, 0 scale BALL_RADIUS/2 translate z*BALL_RADIUS*-1 translate <-1*0.17*BALL_RADIUS,-1*0.17*BALL_RADIUS,0> rotate y*180}
pigment{rgb<0,0,0>} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
difference{
sphere{<0, 0, 0> BALL_RADIUS} 
box{<-2*BALL_RADIUS,-0.5*BALL_RADIUS,-2*BALL_RADIUS> <2*BALL_RADIUS,0.5*BALL_RADIUS,2*BALL_RADIUS>}
pigment {BALL_CW} finish{reflection BALL_REFLECTION diffuse BALL_DIFFUSE specular BALL_SPECULAR roughness BALL_ROUGHNESS}}
rotate x*BALL_RX
rotate y*BALL_RY
rotate z*BALL_RZ
translate BALL_TRANSLATION+x*BALL_INSERTION*BALL_RADIUS+y*BALL_INSERTION*BALL_RADIUS+z*BALL_INSERTION*BALL_RADIUS}
#break


#end 

#undef BALL_RX
#undef BALL_RY
#undef BALL_RZ