/*------------------------------------------------------
Thsi is a cathedral, centered on the origin, and stretchign from
z=0 to z=400 (?) with only three walls.  This is just the structure,
it must be used in conjunction with sg_window.inc, which has stained
glass window definitions.
the main part is 200 wide, with pillars, and the sides are each 60 wide.
The ceiling is 270 units high.

!!!The variable candle_lit must be declared as 0 for unlit candles or 1 for lit candles,
before including this file!!!
------------------------------------------------------*/
#include "candle.inc"            
/*------------------------------------------------------
TEXTURES AND COLORS
------------------------------------------------------*/    
#declare altar_text=texture {T_Stone21}
#declare ColumnTexture = texture {
  pigment {
    marble
    turbulence 1
    color_map {
      [0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                      color rgbf <0.745, 0.745, 0.753, 0.000>]
      [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                      color rgbf <0.902, 0.902, 0.859, 0.000>]
      [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                      color rgbf <0.729, 0.706, 0.694, 0.000>]
      [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                      color rgbf <0.588, 0.592, 0.635, 0.000>]
      [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                      color rgbf <0.608, 0.616, 0.659, 0.000>]
      [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                      color rgbf <0.894, 0.886, 0.886, 0.000>]
    }
  }
  scale <2, 5, 2>
  rotate <0, 0, 50>
  finish{ambient 0.2 crand 0.03}
}
texture{
  pigment {
    granite
    turbulence 1
    color_map {
      [0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                      color rgbf <0.322, 0.369, 0.416, 0.847>]
      [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                      color rgbf <0.424, 0.369, 0.420, 0.549>]
      [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                      color rgbf <0.373, 0.424, 0.518, 0.965>]
      [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                      color rgbf <0.482, 0.573, 0.533, 0.741>]
      [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                      color rgbf <0.310, 0.384, 0.420, 0.631>]
    }
  }
  scale <1, 3, 2>
  rotate <0, 0, -30>
}
texture {
  pigment {
    color rgbf <0.752941, 0.752941, 0.752941, .5>
  }
  finish {
    phong .5
    phong_size 150
    ambient .15
    diffuse .6
  }
scale 10
}

#declare brick_text1=texture{ColumnTexture scale 5} 
#declare brick_normal=normal {bump_map {gif "brick_bm.gif" bump_size 20 map_type 0 interpolate 2}scale <50,30,50>}
#declare brick_text=texture {brick_text1 normal {brick_normal}}



/*------------------------------------------------------
OBJECTS
------------------------------------------------------*/
#declare wall_p1=difference {
cylinder {<0,0,-2.5>,<0,0,2.5>,169.7}
box {<200,0,-3>,<-120,200,3>}
box {<-200,0,-5>,<200,-200,5>}
}

#declare wall_piece=merge{
object {wall_p1 translate <120.01,150,0> scale <90/49.7,1,1>}
object {wall_p1 translate <120.01,150,0> scale <90/49.7,1,1> rotate y*180}
box {<-90,0,-2.5>,<90,150.03,2.5>}
}

#declare wall_piece2=merge{
object {wall_p1 translate <120.01,450,0> scale <30/49.7,40/120,1>}
object {wall_p1 translate <120.01,450,0> scale <30/49.7,40/120,1> rotate y*180}
box {<-30,0,-2.5>,<30,150.03,2.5>}
}

#declare column=merge{
cylinder {<0,0,0>,<0,150,0>,5}
torus {5,2 translate <0,5,0> texture {T_Gold_5B}}
torus {5,2 translate <0,148,0> texture {T_Gold_5B}}
torus {6,4 translate <0,2,0> texture {T_Gold_5B}} 
texture {ColumnTexture}
}   

#declare rose_window=cylinder {<0,0,-.1>,<0,0,0.1>,50
texture { pigment { image_map { gif "glass.gif" //filter 255 , 1
                                       filter all 2 transmit all .25 }
}//end pigment
translate <-.5,-.5,0>
scale 100
}//end texture
translate <0,170,0>
}  
  
#declare small_window=box {<-25,0,0.1>,<25,100,-.1>
pigment {image_map{gif "sacred_heart.gif" transmit all .25 filter all 1}
        translate <-.5,-.5,0>
        scale <50,100,1>
        translate <0,50,0>
        }
}               

#declare altar_cloth=merge{
box {<-15,17.99,-2.5>,<15,18.2,2.5> pigment {color White}}
cylinder {<-15,18.1,-2.51>,<-15,18.1,2.51>,.1 pigment {color White}}
cylinder {<15,18.1,-2.51>,<15,18.1,2.51>,.1 pigment {color White}}
box {<-15,18.1,-2.5>,<-15.1,7,2.5> pigment {color White}}   
box {<15,18.1,-2.5>,<15.1,7,2.5> pigment {color White}}
translate <0,0,0>
}

#declare altar=union{
merge{
box {<-30,3,-37>,<30,8,-67>}
box {<-25,7.99,-42>,<25,28,-62>}
box {<-30,27.99,-37>,<30,33,-67>}
texture {T_Stone21}
}//end merge of altar stones
object {altar_cloth scale <2,2,3> translate <0,-3,-52>
}
merge{
box {<-1.5,8,-61.99>,<1.5,28,-67>}
box {<-6.5,19.5,-61.99>,<6.5,22.5,-67.01>}
texture {T_Gold_5B}
}//end merge of altar cross
box {<-27.5,7.99,-62>,<-22.5,28.01,-67> texture {T_Gold_5B}}
box {<27.5,7.99,-62>,<22.5,28.01,-67> texture {T_Gold_5B}}

#declare altar_cross=
merge{
box {<-7.5,0,-7.5>,<7.5,2.5,7.5> scale .5}
box {<-.6,2.5,-.6>,<.6,25,.6>}
box {<-6,17.3,-.6>,<6,18.5,.6>}
difference{
        cylinder {<0,17.9,-.3>,<0,17.9,.3>,4}
        cylinder {<0,17.9,-1>,<0,17.9,1>,3.5}
        }
box {<-6,-.2,-.3>,<6,.2,.3> rotate z*45 translate <0,17.9,0>}
box {<-6,-.2,-.3>,<6,.2,.3> rotate z*-45 translate <0,17.9,0>}
box {<-5,-.2,-.3>,<5,.2,.3> rotate z*22.5 translate <0,17.9,0>}
box {<-5,-.2,-.3>,<5,.2,.3> rotate z*67.5 translate <0,17.9,0>}
box {<-5,-.2,-.3>,<5,.2,.3> rotate z*-22.5 translate <0,17.9,0>}
box {<-5,-.2,-.3>,<5,.2,.3> rotate z*-67.5 translate <0,17.9,0>}
texture {T_Gold_3E}
}

}//end altar union


#declare candle_holder=union{
merge{
cone {<0,0,0>,5,<0,2,0>,1.5}
cone {<0,1.99,0>,1.5,<0,20,0>,1}
cone {<0,19.99,0>,1,<0,32,0>,1.5}
cone {<0,31.99,0>,1.5,<0,35,0>,2.5}
texture {T_Gold_3E}
}      
#if (candle_lit=1)
        object {lit_candle scale <4/3,2,4/3> translate <0,35,0>}
#else 
        object {unlit_candle scale <4/3,2,4/3> translate <0,35,0>}
#end           
}//end candle_holder

#declare pew_ends=
difference{
merge{
box {<-30,0,-10>,<-25,25,10>}  
box {<30,0,-10>,<25,25,10>}
cylinder {<-30,25,-7.5>,<-25,25,-7.5>,2.5}
cylinder {<30,25,-7.5>,<25,25,-7.5>,2.5}
}
cylinder {<31,0,0>,<-31,0,0>,5}
box {<-31,11,12>,<31,26,-5>}
texture {T_Wood17 rotate x*90}
}

#declare pew_back=
merge{
cylinder {<-25.01,25,-7.5>,<25.01,25,-7.5>,1}
box {<-25.01,25,-6.5>,<25.01,10,-8.5>}
texture {T_Wood17 scale 10 rotate y*85 translate <0,10,0>}
}                                                        

#declare pew_seat=
merge{
box {<-25.01,10,-8.5>,<25.01,8,8.5>}
cylinder {<-25.01,9,8.5>,<25.01,9,8.5>,1}
texture {T_Wood17 scale 10 rotate y*90}
}                 

#declare pew=merge{
object {pew_ends}
object {pew_back}
object {pew_seat}
}


/*------------------------------------------------------
Final Assemblies
------------------------------------------------------*/
#declare roof=difference{
box {<-160,150,2.5>,<160,270,-400>}
object {wall_piece scale <1,1,100> translate <0,0,-240>}
object {wall_piece2 translate <130,0,0> scale <1,1,100> translate <0,0,-240>}
object {wall_piece2 translate <-130,0,0> scale <1,1,100> translate <0,0,-240>}
object {wall_piece2 scale <1,1,100> rotate y*90 translate <0,0,-35>}
object {wall_piece2 scale <1,1,100> rotate y*90 translate <0,0,-105>}
object {wall_piece2 scale <1,1,100> rotate y*90 translate <0,0,-175>}
object {wall_piece2 scale <1,1,100> rotate y*90 translate <0,0,-245>}
object {wall_piece2 scale <1,1,100> rotate y*90 translate <0,0,-315>}
}

#declare columns=union{
object {column translate <-95,0,0> }
object {column translate <95,0,0> }
object {column translate <-95,0,-70> }
object {column translate <95,0,-70> }
object {column translate <-95,0,-140> }
object {column translate <95,0,-140> }
object {column translate <-95,0,-210> }
object {column translate <95,0,-210> }
object {column translate <-95,0,-280> }
object {column translate <95,0,-280> }
}


#declare altar_walls=union{
difference{
merge{
box {<95,0,0>,<100,270,-70.01> texture {brick_text rotate y*90}}
box {<-95,0,0>,<-100,270,-70.01> texture {brick_text rotate y*90}}
box {<95,0,-70>,<160,270,-64.99> }
box {<-95,0,-70>,<-160,270,-64.99> }
}//end merge
box {<-25,0,20>,<25,100,-20> translate <130,50,-70>}
box {<-25,0,20>,<25,100,-20> translate <-130,50,-70>}
box {<-25,0,20>,<25,100,-20> rotate y*90 translate <90,50,-35>}
box {<-25,0,20>,<25,100,-20> rotate y*90 translate <-90,50,-35>}

}                          
object {small_window
translate <130,50,-70>
}
object {small_window
translate <-130,50,-70>
}
object {small_window
rotate y*90
translate <-95,50,-35>
}
object {small_window
rotate y*90
translate <95,50,-35>
}
texture {brick_text}
}//end altar_walls with windows

#declare behind_altar=union{
difference {          
object {wall_piece }
cylinder {<0,170,5>,<0,170,-5>, 50} //window cutout
}                           
object {rose_window}
texture {brick_text}
}


#declare side_walls=union{
box {<-160,0,2.5>,<-165,200,-400>}
box {<160,0,2.5>,<165,200,-400>}
texture {brick_text rotate y*90}
}

#declare altar_steps=merge{
box {<-105,0,0>,<105,1,-140> }
box {<-105,0,0>,<105,2,-122.5>}
box {<-105,0,0>,<105,3,-105>}
}

#declare flr=merge{
object {altar_steps}
box {<-170,0,2.5>,<170,-.5,-400>}
}



#declare pew_c1=10;
#declare pews=union{
#while (pew_c1>=0)
object {pew  translate <-50,0,-175-(pew_c1*60)>}
object {pew  translate <50,0,-175-(pew_c1*60)>}
#declare pew_c1=pew_c1-1;
#end
}//end pews
  
  
#declare candle_holders=union{
object {candle_holder translate <-40,3,-27>}
object {candle_holder translate <40,3,-27>}
object {candle_holder translate <-40,3,-77>}
object {candle_holder translate <40,3,-77>}
object {candle_holder translate <-95,2,-113.75> }
object {candle_holder translate <95,2,-113.75> }    
object {candle_holder translate <-95,0,-175> }
object {candle_holder translate <95,0,-175> }
object {candle_holder translate <-95,0,-245> }
object {candle_holder translate <95,0,-245> }
object {candle_holder translate <-95,0,-315> }
object {candle_holder translate <95,0,-315> }
}


#declare cathedral=
union{
object {flr texture {ColumnTexture scale 5}}  
object {columns}
object {behind_altar texture {brick_text}}
object {altar_walls texture {brick_text}}
object {side_walls texture {brick_text}} 
object {roof texture {ColumnTexture scale 5}}
object {altar}
object {altar_cross translate <0,33,-55>}
object {pews}                          
object {candle_holders}
}


