vector vsnoise(vector x)
{
    return 2*vector(noise(x))-1;
}

vector vfBm(point p; uniform float octaves, lacunarity, gain)
{
    uniform float amp = 1;
    uniform point pp = p;
    varying vector sum = 0;
    uniform float i;
    for (i=0; i<octaves; i+= 1){
        sum += amp*vsnoise(pp);
        amp *= gain;
        pp *= lacunarity;
    }
    return sum;
}


surface waves(float scale=5){

  point pt = transform("shader", P)*scale;
  float lac =2;
  vector NewVect = vfBm(P, 5, lac, 1/lac);
  color C = color normalize(NewVect);
  Ci = C;

}