//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.4;
#local pov=<2/3,1/3,1>;
#local dist=900;
#local poi=<0,0,0>;
#local pov=vnormalize(pov)*dist+poi;
#local rot=0;
#local quality = 0;

#include "mercury2ships.inc"

camera {
	location pov
	sky vrotate(y,rot)
	right vrotate(x*image_width/image_height,rot)
	look_at poi
	normal { bump_map { png "logomask.png" interpolate 2 } 1 translate -0.5 }
}

light_source { pov rgb 1 }

global_settings {
	max_trace_level 20
	number_of_waves 20
	post_process {
		//focal_blur{dist, dist, 8}
		//soft_glow{1,8}
	}
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}

#declare sthing = object {
	mercury2()
}

object { sthing }

#macro shield(ShieldedObject,ObjectScale,ShieldDistance,Densityu,Densityv,SmoothLevel,SmoothBias,ShieldTexture)
	#if (SmoothLevel<1) #local SmoothLevel = 1; #end
	#local vecs = array [Densityu][Densityv+1][2][SmoothLevel]
	#local vecnorm = <0,0,0>;
	
	#local aux = trace(ShieldedObject,<0,0,-ObjectScale>,<0,0,ObjectScale>,vecnorm);
	#local vecs[0][0][0][0] = aux+vecnorm*ShieldDistance;
	#local vecs[0][0][1][0] = vecnorm;
	
	#local aux = trace(ShieldedObject,<0,0,ObjectScale>,<0,0,-ObjectScale>,vecnorm);
	#local vecs[Densityu-1][0][0][0] = aux+vecnorm*ShieldDistance;
	#local vecs[Densityu-1][0][1][0] = vecnorm;
	
	#local i = 1;
	#while (i<=Densityv)
		#local vecs[0][i][0][0] = vecs[0][0][0][0];
		#local vecs[0][i][1][0] = vecs[0][0][1][0];
		#local vecs[Densityu-1][i][0][0] = vecs[Densityu-1][0][0][0];
		#local vecs[Densityu-1][i][1][0] = vecs[Densityu-1][0][1][0];
		#local i = i +1;
	#end
	
	#local i = 1;
	#while (i<Densityu-1)
		#local j = 0;
		#while (j<=Densityv)
			#local sp = z*-ObjectScale;
			#local sp = vrotate(sp,x*((180/Densityu)*i));
			#local sp = vrotate(sp,z*((360/Densityv)*j));
			#local aux = trace(ShieldedObject,sp,-sp,vecnorm);
			#local vecs[i][j][0][0] = aux+vecnorm*ShieldDistance;
			#local vecs[i][j][1][0] = vecnorm;
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end
	
	#local i = 1;
	#while (i< SmoothLevel)
		#local avg = <0,0,0>;
		#local avgn = <0,0,0>;
		#local j=0;
		#while (j<Densityv)
			#local avg = avg+vecs[1][j][0][i-1];
			#local avgn = avgn+vecs[1][j][1][i-1];
			#local j=j+1;
		#end
		#local avg = avg/Densityv;
		#local avgn = avgn/Densityv;
		#if (vlength(avg)>vlength(vecs[0][0][0][i-1]))
			#local vecs[0][0][0][i] = avg*SmoothBias;
			#local vecs[0][0][1][i] = avgn;
		#else
			#local vecs[0][0][0][i] = vecs[0][0][0][i-1];
			#local vecs[0][0][1][i] = vecs[0][0][1][i-1];
		#end

		#local avg = <0,0,0>;
		#local avgn = <0,0,0>;
		#local j=0;
		#while (j<Densityv)
			#local avg = avg+vecs[Densityu-2][j][0][i-1];
			#local avgn = avgn+vecs[Densityu-2][j][1][i-1];
			#local j=j+1;
		#end
		#local avg = avg/Densityv;
		#local avgn = avgn/Densityv;
		#if (vlength(avg)>vlength(vecs[Densityu-1][0][0][i-1]))
			#local vecs[Densityu-1][0][0][i] = avg*SmoothBias;
			#local vecs[Densityu-1][0][1][i] = avgn;
		#else
			#local vecs[Densityu-1][0][0][i] = vecs[Densityu-1][0][0][i-1];
			#local vecs[Densityu-1][0][1][i] = vecs[Densityu-1][0][1][i-1];
		#end

		#local j = 1;
		#while (j<=Densityv)
			#local vecs[0][j][0][i] = vecs[0][0][0][i];
			#local vecs[0][j][1][i] = vecs[0][0][1][i];
			#local vecs[Densityu-1][j][0][i] = vecs[Densityu-1][0][0][i];
			#local vecs[Densityu-1][j][1][i] = vecs[Densityu-1][0][1][i];
			#local j = j +1;
		#end
		
		#local j=1;
		#while (j<Densityu-1)
			#local k=0;
			#while (k<=Densityv)
				#local sv1 = k-1;
				#local sv2 = k;
				#local sv3 = k+1;
				#local su1 = j-1;
				#local su2 = j;
				#local su3 = j+1;
				#if (sv1<0) #local sv1 = sv1+Densityv; #end
				#if (sv2<0) #local sv2 = sv2+Densityv; #end
				#if (sv3<0) #local sv3 = sv3+Densityv; #end
				#if (sv1>=Densityv) #local sv1 = sv1-Densityv; #end
				#if (sv2>=Densityv) #local sv2 = sv2-Densityv; #end
				#if (sv3>=Densityv) #local sv3 = sv3-Densityv; #end
				#local avg = vecs[su1][sv2][0][i-1]+vecs[su3][sv2][0][i-1]+vecs[su2][sv1][0][i-1]+vecs[su2][sv3][0][i-1]+vecs[su1][sv1][0][i-1]+vecs[su1][sv3][0][i-1]+vecs[su3][sv1][0][i-1]+vecs[su3][sv3][0][i-1];
				#local avgn = vecs[su1][sv2][1][i-1]+vecs[su3][sv2][1][i-1]+vecs[su2][sv1][1][i-1]+vecs[su2][sv3][1][i-1]+vecs[su1][sv1][1][i-1]+vecs[su1][sv3][1][i-1]+vecs[su3][sv1][1][i-1]+vecs[su3][sv3][1][i-1];
				#local avg = avg/8;
				#local avgn = avgn/8;
				#if (vlength(avg)>vlength(vecs[j][k][0][i-1]))
					#local vecs[j][k][0][i] = avg*SmoothBias;
					#local vecs[j][k][1][i] = avgn;
				#else
					#local vecs[j][k][0][i] = vecs[j][k][0][i-1];
					#local vecs[j][k][1][i] = vecs[j][k][1][i-1];
				#end
				#local k= k+1;
			#end
			#local j=j+1;
		#end
		#local i=i+1;
	#end

	#local ev = SmoothLevel-1;	
	mesh {
		#local i = 0;
		#while (i<Densityu-1)
			#local j = 0;
			#while (j<Densityv)
				smooth_triangle {
					vecs[i][j][0][ev],vecs[i][j][1][ev]
					vecs[i][j+1][0][ev],vecs[i][j+1][1][ev]
					vecs[i+1][j][0][ev],vecs[i+1][j][1][ev]
				}
				smooth_triangle {
					vecs[i][j+1][0][ev],vecs[i][j+1][1][ev]
					vecs[i+1][j+1][0][ev],vecs[i+1][j+1][1][ev]
					vecs[i+1][j][0][ev],vecs[i+1][j][1][ev]
				}
				#local j=j+1;
			#end
			#local i = i+1;
		#end
		texture { ShieldTexture }
		hollow
	}
				
#end

/*object {
	shield(sthing,2000,50,60,20,5,1.1,texture { pigment { rgbt 1 }})
	hollow
	interior {
		media {
			emission <0.2,0,0>
			absorption 0.2
			method 3
			intervals 1
			samples 10,10
			confidence 1-1/10
			variance 1/64
		}
	}
}*/

		
	
	
         