//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 4 materials and 5 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 03/24/1999    (24.03.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment
#declare phd=1.0;  // lower this value for a higher density (better
                   //   quality render)
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }  
  photons{
    gather 20,100
    radius 0.1*phd, 2, 0.1*phd
    autostop 0
  }

}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -12.000,     -20.000,      15.000>
  direction <        0.0,         0.0,      4.4191> // Aperture is 0.23 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.254,       0.707,       1.213>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <      0.000,      -0.001,      11.000> // Attached to Spotlight001
  direction <        0.0,         0.0,      1.3589> // Aperture is 0.71 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,      10.000> // Following Spotlight001
}

*/

//
// *******  L I G H T S *******
//

  

light_source {   // Light2
  <0.000, 0.000, 10.000>
  color rgb <1.000, 1.000, 1.000>    
  photons{
    reflection on
    refraction on
  }
}

light_source {   // Light1
  <0.000, -20.000, 20.000>
  color rgb <1.000, 1.000, 1.000>    
  photons{
    reflection on
    refraction on
  }
}


//
// ********  MATERIALS  *******
//

#include "temp.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//



plane { // Plane001
  z,0
  material {
    Black_Vein_Granit
  }
}


torus { // Torus001
  1.5, 0.5  rotate -x*90
  material {
    Gold_Texture
  }
  scale <1.0, 1.0, 2.5>
  translate  -0.5*z 
  photons{
    density 0.01*phd
    reflection on    refraction on
  }

}


sphere { // Sphere001
  <0,0,0>,1
  material {
    Glass
  }
  scale 2.0
  translate  2.1*z     
  photons{
    density 0.01*phd
    reflection on    refraction on
  }

}




