//
// BIG_E.POV
//
// Written by Ville Saari
// Created: 25-Sep-92
// Updated: 22-Jan-93
//
// Revised for Jose Luis Arranz
// Updated: 22-Jan-1999
//
// PoV-Ray scene description for the starship U.S.S Enterprise
// NCC-1701-A
//



//
// Get the definition for the starship
//

#include "big_e.inc"



//
// Very distant light source
//

object { light_source { <-10000000 -100000 -5000000> colour White } }



//
// A planet from planet.pov
//

composite
   {
   object
      {
      sphere { <0 0 0> 3000000 }

      texture
         {
         0.08

         bozo

         color_map
            {
            [0   0.7  color MediumBlue  color MediumBlue ]
            [0.7 1    color ForestGreen color Bronze2    ]
            [1.0 1.01 color Bronze2     color Brown      ]
            }

         turbulence 0.5

         scale <700000 700000 700000>
         translate <0 5000000 0>
         }
      }

   object
      {
      sphere { <0 0 0> 3005000 }

      texture
         {
         bozo

         color_map
            {
            [0   0.4 color Clear color Clear ]
            [0.4 0.9 color Clear color White ]
            [0.9 1   color White color White ]
            }

         turbulence 1

         scale <240000 60000 240000>
         }
      }

   translate <0 0 -5700000>
   rotate <0 -40 -30>
   }



//
// The observer
//

camera
   {
   location <-400 -160 1600>
   direction <0 0 12.1>
   sky <-7 90 0>
   look_at <12 -15 0>
   }



//
// And the starship
//

   union { NCC_1701_A }
   
