#include "bishop.inc"
#include "king.inc"
#include "knight.inc"
#include "pawn.inc"
#include "queen.inc"
#include "rook.inc"


#declare board =
texture {
        pigment {
                checker
                pigment {
                        marble
                        color_map {
                                  [ 0.0     rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
                                  [ 0.736655  rgbft <0.0, 0.0, 1.0, 0.0, 0.0> ]
                                  [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
                                  }
                                  turbulence 3.0
                        }
                pigment {
                        marble
                        color_map {
                                  [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                                  [ 0.049822  rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
                                  [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
                                  }
                                  turbulence 2.0
                        }
                 }
        finish {
               ambient 0.1
               reflection 0.1151
               }
}



#declare board2 = 
// board2
texture
      {      
         pigment
         {
            checker
               pigment
               {
                  marble
                  color_map
                  {
                     [ 0.0     rgbft <0.0, 0.0, 0.666667, 0.0, 0.0> ]
                     [ 0.736655  rgbft <0.0, 0.0, 0.729133, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.864567, 0.864567, 0.864567, 0.0, 0.0> ]
                  }
                  turbulence 3.0
                  ramp_wave
               }
               pigment
               {
                  marble
                  color_map
                  {
                     [ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
                     [ 0.049822  rgbft <0.3854, 0.3854, 0.3854, 0.0, 0.0> ]
                     [ 1.0     rgbft <0.8854, 0.8854, 0.8854, 0.0, 0.0> ]
                  }
                  turbulence 2.0
                  ramp_wave
               }
         }      
         normal
         {
            crackle 5
         }
         normal {
            dents 5
            }
         finish
         {
            ambient 0.1
            reflection 0
         }      
      }



#declare blue_piece =
texture {
        pigment {
                color rgb <0.5, 0.5, 1.0>
                }
        #if (clock = 2)
        finish {
                ambient 0.01
                diffuse 0.5
                brilliance 1
                roughness 1
        }
        #else
        finish {
               ambient 0.25
               diffuse 0.3
               brilliance 2.4
               phong 0.352
               specular 0.3
               reflection 0.35
               metallic
        }
        #end
}


#declare white_piece =
   texture {
           pigment {
                   color rgb <0.75, 0.75, 0.75>
                   }
        #if (clock = 2)
        finish {
                ambient 0.01
                diffuse 0.5
                brilliance 1
                roughness 1
        }
        #else
           finish {
                  ambient 0.25
                  diffuse 0.25
                  brilliance 2.481
                  phong 0.3525
                  specular 0.3
                  reflection 0.35
                  metallic
           }
           #end
}

#declare board_border =
texture {
        pigment {
                wood
                color_map {
                          [ 0.0     rgbft <0.552067, 0.343733, 0.0, 0.0, 0.0> ]
                          [ 0.775801  rgbft <0.468733, 0.171867, 0.0052, 0.0, 0.0> ]
                          [ 1.0     rgbft <0.3854, 0.0, 0.0104, 0.0, 0.0> ]
                          }
                turbulence <0.25, 0.25, 0>
                sine_wave
                }
        finish {
               ambient 0.1
               specular 0.064733
               roughness 1.0
               }
}

#declare board_border2 =
texture {
        pigment {
                wood
                color_map {
                          [ 0.0     rgbft <0.452067, 0.243733, 0.0, 0.0, 0.0> ]
                          [ 0.775801  rgbft <0.368733, 0.071867, 0.0052, 0.0, 0.0> ]
                          [ 1.0     rgbft <0.2854, 0.0, 0.0104, 0.0, 0.0> ]
                          }
                turbulence <0.25, 0.25, 0>
                sine_wave
                }
        normal { crackle 10}
        normal { dents 3}
        finish {
               roughness 3.0
               }
}


#declare Chess_Board =
union {
      box { //border
      <-4.25, -1, -4.25>, <4.25, -0.0009, 4.25>
         #if (clock = 2)
         texture {board_border2}
         texture {pigment{
                bozo
                        color_map {
                                [0.0 rgbt<0, 0, 0, 0.7>]
                                [0.5 rgbt <0, 0, 0, 0.3>]
                        }
                        turbulence 0.5
                }
                
         normal {crackle 10}
         normal {dents 3}
         }
         

         #else
         texture { board_border }
         #end
      }
      box { // board center
          <-4, -0.9, -4>, <4, 0, 4>
          #if (clock = 2)
          texture {board2}
         texture {pigment{
                bozo 
                        color_map {
                                [0.0 rgbt<0,0,0,0.7>]
                                [.5 rgbt <0, 0, 0, 0.3>]
                        }
                        turbulence 0.5
                }
                
         normal {crackle 10}
         normal {dents 3}
}
          #else
          texture { board }
          #end
      }
      
}

#declare piece_burn =
texture {
        pigment{
                bozo
                color_map {
                        [0.5 rgbt<0,0,0,0.7>]
                        [1.0 rgbt <0, 0, 0, 0.3>]
                }
                turbulence 0.5
        }
        scale 0.5
}

