// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Chess set... before and after <VEG> 
// Date: February 10, 1999 
// Auth: David S. Helfrich, Jr.

// For the melted set, render with a clock setting of 2...
// any other clock will render the shiny set...

#include "chess.inc"



//lights and camera

light_source {<6, 10, 0>
        color rgb 1
}

light_source {<-6, 10, 0>
        color rgb 1
}

camera {
        location <5, 3, 3.5>
        look_at <0, 0, 0>
}

// some constants

#declare board_grid = 
array [4] [8]
{
        {<-3.5, 0, -3.5>, <-2.5, 0, -3.5>, <-1.5, 0, -3.5>, <-0.5, 0, -3.5>, < 0.5, 0, -3.5>, < 1.5, 0, -3.5>, < 2.5, 0, -3.5>, < 3.5, 0, -3.5>}
        {<-3.5, 0, -2.5>, <-2.5, 0, -2.5>, <-1.5, 0, -2.5>, <-0.5, 0, -2.5>, < 0.5, 0, -2.5>, < 1.5, 0, -2.5>, < 2.5, 0, -2.5>, < 3.5, 0, -2.5>}
        {<-3.5, 0, 3.5>, <-2.5, 0, 3.5>, <-1.5, 0, 3.5>, <-0.5, 0, 3.5>, < 0.5, 0, 3.5>, < 1.5, 0, 3.5>, < 2.5, 0, 3.5>, < 3.5, 0, 3.5>}
        {<-3.5, 0, 2.5>, <-2.5, 0, 2.5>, <-1.5, 0, 2.5>, <-0.5, 0, 2.5>, < 0.5, 0, 2.5>, < 1.5, 0, 2.5>, < 2.5, 0, 2.5>, < 3.5, 0, 2.5>}
}

#declare blobscale = <1, 0.5, 1>;

#declare blob1 =
blob {
   threshold 0.600000
   component 1.000000, 0.276541, <-0.389130, 0.000000, -0.061069>
   component 1.000000, 0.234006, <-0.282310, 0.000000, 0.015267>
   component 1.000000, 0.265058, <-0.190750, 0.000000, -0.091603>
   component 1.000000, 0.259140, <-0.038150, 0.000000, -0.106870>
   component 1.000000, 0.231855, <0.114450, 0.000000, -0.122137>
   component 1.000000, 0.276541, <0.297570, 0.000000, -0.183206>
   component 1.000000, 0.431272, <0.602770, 0.000000, -0.076336>
   component 1.000000, 0.329785, <0.000000, 0.022814, 0.205230>
   component 1.000000, 0.416293, <0.000000, 0.007605, 0.038005>

   scale blobscale
}

#declare blob2 =
blob {
   threshold 0.600000
   component 1.000000, 0.227384, <-0.007630, 0.000000, 0.702290>
   component 1.000000, 0.330960, <-0.022890, 0.000000, 0.442748>
   component 1.000000, 0.468200, <0.114450, 0.000000, 0.244275>
   component 1.000000, 0.402885, <0.068670, 0.000000, -0.076336>
   component 1.000000, 0.546616, <-0.358610, 0.000000, 0.030534>
   component 1.000000, 0.244884, <0.007630, 0.000000, -0.442748>
   component 1.000000, 0.160786, <0.434910, 0.000000, -0.229008>
   component 1.000000, 0.346321, <0.297570, 0.000000, 0.000000>
   component 1.000000, 0.143798, <-0.175490, 0.000000, -0.274809>
   component 1.000000, 0.234100, <0.526470, 0.000000, 0.259542>
   component 1.000000, 0.227332, <0.648550, 0.000000, 0.000000>
   component 1.000000, 0.251108, <0.236530, 0.000000, -0.381679>
   component 1.000000, 0.296416, <-0.312830, 0.000000, -0.442748>
   component 1.000000, 0.143798, <-0.282310, 0.000000, 0.412214>

   scale blobscale
}

#declare blob3 =
blob {
   threshold 0.600000
   component 1.000000, 0.734653, <-0.083930, 0.000000, 0.244275>
   component 1.000000, 0.766816, <0.053410, 0.000000, 0.000000>
   component 1.000000, 0.502215, <0.343350, 0.000000, 0.229008>
   component 1.000000, 0.203371, <0.556990, 0.000000, 0.000000>
   component 1.000000, 0.555112, <0.526470, 0.000000, -0.396947>
   component 1.000000, 0.359393, <-0.206010, 0.000000, -0.366412>
   component 1.000000, 0.437251, <-0.007630, 0.000000, -0.488550>

   scale blobscale
}

#declare blob4 =
blob {
   threshold 0.600000
   component 1.000000, 0.296468, <0.083930, 0.000000, 0.030534>
   component 1.000000, 0.287515, <0.190750, 0.000000, -0.183206>
   component 1.000000, 0.331042, <0.419650, 0.000000, 0.030534>
   component 1.000000, 0.303268, <0.556990, 0.000000, -0.259542>
   component 1.000000, 0.545598, <0.251790, 0.000000, -0.473282>
   component 1.000000, 0.535025, <-0.251790, 0.000000, -0.412214>
   component 1.000000, 0.316687, <-0.022890, 0.000000, -0.564885>
   component 1.000000, 0.463627, <-0.129710, 0.000000, -0.167939>
   component 1.000000, 0.388526, <-0.236530, 0.000000, 0.152672>
   component 1.000000, 0.366637, <0.144970, 0.000000, 0.274809>
   component 1.000000, 0.160759, <0.419650, 0.000000, 0.290076>
   component 1.000000, 0.303331, <0.694330, 0.000000, 0.152672>
   component 1.000000, 0.160759, <0.801150, 0.000000, -0.076336>
   component 1.000000, 0.244884, <0.770630, 0.000000, -0.213740>
   component 1.000000, 0.096472, <0.862190, 0.000000, -0.412214>
   component 1.000000, 0.447871, <-0.572250, 0.000000, -0.030534>
   component 1.000000, 0.347783, <-0.663810, 0.000000, -0.290076>
   component 1.000000, 0.422768, <-0.907970, 0.000000, -0.732824>
   component 1.000000, 0.259258, <-0.160230, 0.000000, 0.488550>
   component 1.000000, 0.244884, <0.144970, 0.000000, 0.564885>

   scale blobscale
}

#declare blob5 =
blob {
   threshold 0.600000
   component 1.000000, 0.562452, <0.068670, 0.000000, -0.091603>
   component 1.000000, 0.555112, <0.068670, 0.000000, 0.595420>
   component 1.000000, 0.359523, <0.404390, 0.000000, 0.305344>
   component 1.000000, 0.347783, <-0.389130, 0.000000, 0.061069>
   component 1.000000, 0.160759, <0.419650, 0.000000, -0.152672>
   component 1.000000, 0.143798, <-0.022890, 0.000000, 0.229008>
   component 1.000000, 0.205869, <-0.328090, 0.000000, 0.519084>
   component 1.000000, 0.187484, <-0.175490, 0.000000, -0.366412>
   component 1.000000, 0.132584, <0.618030, 0.000000, 0.427481>
   component 1.000000, 0.195602, <0.099190, 0.000000, 1.083969>
   component 1.000000, 0.160759, <0.083930, 0.000000, -0.549618>
   component 1.000000, 0.181866, <-0.709590, 0.000000, -0.045802>

   scale blobscale
}

#declare blob6 =
blob {
   threshold 0.600000
   component 1.000000, 0.181866, <0.236530, 0.000000, 0.320611>
   component 1.000000, 0.205848, <0.282310, 0.000000, 0.167939>
   component 1.000000, 0.160738, <0.129710, 0.000000, -0.061069>
   component 1.000000, 0.346321, <0.114450, 0.000000, 0.213740>
   component 1.000000, 0.215697, <-0.022890, 0.000000, 0.076336>
   component 1.000000, 0.205848, <-0.144970, 0.000000, -0.030534>
   component 1.000000, 0.090933, <0.038150, 0.000000, -0.244275>
   component 1.000000, 0.532252, <-0.236530, 0.000000, 0.274809>
   component 1.000000, 0.205869, <-0.221270, 0.000000, -0.091603>
   component 1.000000, 0.101647, <-0.114450, 0.000000, -0.274809>
   component 1.000000, 0.132529, <-0.053410, 0.000000, -0.106870>
   component 1.000000, 0.071899, <0.160230, 0.000000, -0.320611>
   component 1.000000, 0.136399, <0.114450, 0.000000, -0.259542>
   component 1.000000, 0.287515, <0.251790, 0.000000, -0.106870>
   component 1.000000, 0.428839, <-0.434910, 0.000000, -0.366412>
   component 1.000000, 0.163967, <-0.236530, 0.000000, -0.244275>
   component 1.000000, 0.231855, <-0.007630, 0.000000, -0.396947>

   scale blobscale
}

#declare pawnblob1 =
blob {
   threshold 0.600000
   component 1.000000, 0.215636, <-0.007630, 0.000000, 0.015267>
   component 1.000000, 0.160759, <0.221270, 0.000000, -0.091603>
   component 1.000000, 0.090933, <0.206010, 0.000000, 0.122137>
   component 1.000000, 0.234100, <-0.129710, 0.000000, 0.122137>
   component 1.000000, 0.071879, <-0.083930, 0.000000, -0.167939>
   component 1.000000, 0.215697, <0.114450, 0.000000, -0.030534>
   component 1.000000, 0.259168, <0.068670, 0.000000, 0.122137>
   component 1.000000, 0.136399, <0.267050, 0.000000, 0.061069>
   component 1.000000, 0.321475, <0.190750, 0.000000, -0.290076>
scale blobscale
}

#declare pawnblob2 =
blob {
   threshold 0.600000
   component 1.000000, 0.316687, <-0.022890, 0.000000, 0.091603>
   component 1.000000, 0.387144, <0.221270, 0.000000, 0.137405>
   component 1.000000, 0.303268, <-0.022890, 0.000000, 0.442748>
   component 1.000000, 0.305056, <-0.251790, 0.000000, 0.167939>
   component 1.000000, 0.417876, <-0.480690, 0.000000, -0.305344>
   component 1.000000, 0.251108, <-0.236530, 0.000000, -0.091603>
   component 1.000000, 0.366584, <0.282310, 0.000000, -0.198473>
scale blobscale
}

#declare pawnblob3 =
blob {
   threshold 0.600000
   component 1.000000, 0.572377, <0.007630, 0.000000, 0.030534>
   component 1.000000, 0.160148, <-0.007601, 0.509506, 0.000000>
   component 1.000000, 0.214877, <0.007601, 0.387833, 0.000000>
   component 1.000000, 0.115907, <0.236530, 0.000000, -0.030534>
   component 1.000000, 0.090933, <0.358610, 0.000000, 0.030534>
   component 1.000000, 0.205869, <0.282310, 0.000000, 0.213740>
   component 1.000000, 0.115907, <0.022890, 0.000000, 0.335878>
   component 1.000000, 0.090933, <-0.251790, 0.000000, 0.244275>
   component 1.000000, 0.244805, <-0.282310, 0.000000, -0.045802>
   component 1.000000, 0.173161, <-0.114450, 0.000000, -0.167939>
   component 1.000000, 0.064284, <-0.022890, 0.000000, -0.305344>
scale blobscale
}

#declare pawnblob4 =
blob {
   threshold 0.600000
   component 1.000000, 0.437251, <-0.312830, 0.000000, 0.030534>
   component 1.000000, 0.460412, <0.190750, 0.000000, 0.274809>
   component 1.000000, 0.419138, <0.236530, 0.000000, -0.137405>
   component 1.000000, 0.215697, <-0.114450, 0.000000, -0.198473>
   component 1.000000, 0.418015, <-0.297570, 0.000000, 0.763359>
   component 1.000000, 0.143798, <-0.144970, 0.000000, 0.503817>
   component 1.000000, 0.244805, <-0.221270, 0.000000, 0.381679>
scale blobscale
}





#declare blobedge =
blob {
   threshold 0.600000
   component 1.000000, 0.518460, <0.572250, 0.000000, -0.152672>
   component 1.000000, 0.366637, <0.297570, 0.000000, -0.595420>
   component 1.000000, 0.518516, <0.007630, 0.000000, 0.045802>
   component 1.000000, 0.366488, <0.038150, 0.000000, -0.259542>
   component 1.000000, 0.064314, <0.282310, 0.000000, -0.106870>
   component 1.000000, 0.136399, <0.251790, 0.000000, -0.351145>
   component 1.000000, 0.032142, <0.480690, 0.000000, -0.442748>
   component 1.000000, 0.258185, <-0.448465, -0.007605, 0.000000>
   component 1.000000, 0.143212, <-0.235634, -0.083650, 0.000000>
   component 1.000000, 0.290087, <-0.494071, -0.479087, 0.000000>
   component 1.000000, 0.205067, <-0.433262, -0.296578, 0.000000>
   component 1.000000, 0.401256, <-0.448465, -0.281369, 0.235634>
   component 1.000000, 0.214819, <-0.372454, -0.524715, -0.266038>
   component 1.000000, 0.340469, <-0.402858, -0.326996, -0.433262>
}



object {Chess_Board}

sky_sphere {
        pigment {
                color rgb <0.25, 0.25, 1.00>
        }
        pigment {
                bozo
                turbulence 2
                octaves 6
                lambda 3
                color_map {
                        [0.40 rgbt < 1.00, 1.00, 1.00, 1.00 >]
                        [0.55 rgbt < 0.97, 0.97, 0.97, 0.10 >]
                        [0.70 rgbt < 0.85, 0.85, 0.85, 0.00 >]
                        [1.00 rgbt < 0.75, 0.75, 0.75, 0.00 >]
                }
                scale 0.5
                rotate <0, 0, 37>
                rotate 180*clock
       }
}



#if (clock = 2)
union {
        object {rook
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate -1*y
                rotate -45*z
                translate 0.25*x 
                texture {blue_piece}
                texture {piece_burn}
        }
        
        object {rook
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate -0.5*y
                rotate 225*z
                translate -0.25*x
                texture {blue_piece}
                texture {piece_burn}
        }
        
        object {
                blob1
                texture {blue_piece}
                texture {piece_burn}
                scale <1.5, 1, 1.5>
        }
        translate <-2.5, 0, -1.5>
        
}

union {
        object {knight
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate  -0.75375*y
                rotate -30*x
                texture {blue_piece}
                texture {piece_burn}
        }
        
        object {
                blob2
                texture {blue_piece}
                texture {piece_burn}
        }
        translate <3.5, 0, -2.5>
}

union {
        object {knight
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate -0.25*y
                rotate <-10, 0, -10>
                texture {blue_piece}
                texture {piece_burn}
        }
        
        object {blob2
                texture {blue_piece}
                texture {piece_burn}
                translate -0.1*y
        }
        translate <3.5, 0, 2.5>
}

union {
        object {bishop
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                rotate 90*x
                rotate 43*y
                translate <-0.3, 0, -0.3>
                texture {blue_piece}
                texture {piece_burn}
        }
        
        object {blob3
                texture {blue_piece}
                texture {piece_burn}
                scale <1.5, 0.15, 0.5>
                rotate -47*y
        }
        translate <2, 0, -1>
}
      

#declare bend_object =
object {bishop
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        texture {blue_piece}
        texture {piece_burn}
}

#declare object_axis1=-y;
#declare object_axis2= y;
#declare bend_angle = 30;
#declare bend_direction = x;
#declare bend_smoothness = 100;
#declare bend_start = 0.75;
#declare bend_finish = 1.00;
object {
        #include "bend.inc"
        translate board_grid [0][5]
}

        
union {
        object {queen
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate 1*-y
                texture {white_piece}
                texture {piece_burn}
        }
        
        object {blob4
                translate 0.10*-y
                texture {white_piece}
                texture {piece_burn}
        }
        translate <2.5, 0, 1.5>
}                   

union {
        object {king
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate -.75*y
                texture {blue_piece}
                texture {piece_burn}
        }
        
        object {blob4
                texture {blue_piece}
                texture {piece_burn}
        }
        
        translate <-3, 0, 3>
}

object {
        blobedge
        translate <-4, 0, 0>
        texture {blue_piece}
        texture {piece_burn}
}


object {
        pawnblob1
        translate <-1.5, 0, 1.5>
        texture {blue_piece}
        texture {piece_burn}
}

object {pawnblob2
        translate <2.5, 0, 3.5>
        texture {blue_piece}
        texture {piece_burn}
}

#declare gradtexb = 
        texture {blue_piece}
        texture {piece_burn}

#declare gradtexw =
        texture {white_piece}
        texture {piece_burn}


union {
        object {pawnblob3
                translate <-0.25, 0.0, 0.0>
        }
        object {pawnblob4
                translate <0.25, 0.0, 0.0>
        }
        texture {
                gradient x
                texture_map {
                        [0.5 gradtexb]
                        [1.0 gradtexw]
                }
        }
        translate <0, 0, -3.0>
}


object {pawnblob2
        rotate 84*y
        translate <-1.5, 0, -0.5>
        texture {gradtexb}
}

object {pawnblob3
        rotate 73*y
        translate <1.5, 0, 0.5>
        texture {gradtexw}
}

object {blobedge
        rotate 180*y
        translate <4, 0, -0.5>
        texture {gradtexb}
}

object {pawnblob1
        rotate 42*y
        translate <-0.5, 0, 0.5>
        texture {gradtexw}                
}                

union {
        object {rook
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                translate -1*y
                texture {white_piece}
                texture {piece_burn}
        }
        
        object {blob6
                texture {white_piece}
                texture {piece_burn}
        }
        translate <-2.5, 0, 1.5>
}
union {
        object {rook
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                rotate <90, 73, 0>
                translate <-0.5, 0, -0.4>
                texture {white_piece}
                texture {piece_burn}
        }
        
        object {blob4
                texture {white_piece}
                texture {piece_burn}
        }
        translate <0.5, 0, 3.2>
}


#declare bend_object =
union {
        object {knight
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                rotate 90*x
                translate -0.5*z
                texture {white_piece}
                texture {piece_burn}
        }
        
        object {blob1
                scale <0.75, 1, 3.5>
                texture {white_piece}
                texture {piece_burn}
        }
}
#declare object_axis1 = z;
#declare object_axis2 = -z;
#declare bend_start = 0;
#declare bend_finish = 1;
#declare bend_angle = 53;
#declare bend_direction = x;
object {#include "bend.inc"
        translate <-3.5, 0, -3>}
        

union {
        object {bishop
                rotate 180*x
                translate 0.40200*y
                scale 3.75
                rotate 180*x
                translate .75*y
                texture {white_piece}
        }
        object {
                blob2
                texture {white_piece}
                texture {piece_burn}
        }
        
        translate (board_grid [2][2] - <0, 0, 0.1>)
}




#else
// the nice set

object {rook
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][0]
        texture {blue_piece}
}
object {rook
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][7]
        texture {blue_piece}
}

object {knight
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][1]
        texture {blue_piece}
}

object {knight
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][6]
        texture {blue_piece}
}

object {bishop
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][2]
        texture {blue_piece}
}

object {bishop
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][5]
        texture {blue_piece}
}

object {queen
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][3]
        texture {blue_piece}
}

object {king
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [0][4]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][0]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][1]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][2]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][3]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][4]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][5]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][6]
        texture {blue_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [1][7]
        texture {blue_piece}
}

object {rook
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][0]
        texture {white_piece}
}
object {rook
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][7]
        texture {white_piece}
}

object {knight
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][1]
        texture {white_piece}
}

object {knight
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][6]
        texture {white_piece}
}

object {bishop
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][2]
        texture {white_piece}
}

object {bishop
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][5]
        texture {white_piece}
}

object {queen
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][3]
        texture {white_piece}
}

object {king
        rotate 180*x
        translate 0.40200*y
        scale 3.75
        translate board_grid [2][4]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][0]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][1]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][2]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][3]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][4]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][5]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][6]
        texture {white_piece}
}

object {pawn
        rotate 180*x
        translate 0.310*y
        scale 3.75
        translate board_grid [3][7]
        texture {white_piece}
}


#end
// but is it REALLY the end?
