/*


Parachute from Leroy
5.5.2025

https://news.povray.org/povray.binaries.animations/message/%3Cweb.6817be5a9555a195c2822566f712fc00%40news.povray.org%3E/#%3Cweb.6817be5a9555a195c2822566f712fc00%40news.povray.org%3E


povray +Ileroy_chute.pov +Oleroy_chute_00.png +w512 +h288 -GR +A
povray +Ileroy_chute.pov +Oleroy_chute_00.png +w1200 +h675 +GD +GF -GR +GS +GW +Q9 +A
povray +Ileroy_chute.pov +Oleroy_chute_00.png +w1920 +h1080 -GR +A



*/

#version 3.7;


#default {
	finish { ambient 0.05 diffuse 0.99 }
}
global_settings {
	assumed_gamma 1.0
}


#include "functions.inc"
#include "colors.inc"
#include "textures.inc"

#macro BG_BlueSky ()
	plane {
		<0,1,0>,1 hollow
		texture {
			pigment { color rgb<0.1,0.3,0.75>*0.7 transmit 0 }
			finish { emission 1 diffuse 0}
		}
		scale 10000
	}
#end


#macro Chute ()

	#local nCords	= 40;	//Number of cords
	#local tCords	= .005; //Thickness (org 0.5, better 0.015 or smaller)

	#declare PPig = pigment {
		radial color_map {
			[0 Black]
			[.05 Tan]
			//[.1 rgb<.9,.9,.85>]
			//[.9 rgb<.9,.8,.85>]
			[.1 rgb<.95,.95,.95> * 1.005]
			[.9 rgb<.95,.95,.95> * 1.005]
			[.95 Tan]
			[1 Black]
		}
		frequency nCords
	}

	#declare PPigGap = pigment {
		radial color_map {
			[0 Black]
			[.01 Tan]
			//[.02 rgbt<.9,.9,.85, 1>]
			//[.98 rgbt<.9,.8,.85, 1>]
			[.02 Tan transmit 1]
			[.98 Tan transmit 1]
			[.99 Tan]
			[1 Black]
		}
		frequency nCords
	}


	#declare Para = union {
		//Upper Part, between hole and gap
		sphere{
			0,4
			translate y*2
			clipped_by {
				box {
					<-4.1,4.4,-4.1>, <4.1,5.9,4.1>
				}
			}
		}
		//Lower part, between gap and cone
		sphere {
			0,4
			translate y*2
			#if (1)
				//Gap
				clipped_by {
					box {
						<-4.1,3.5,-4.1>,<4.1,2,4.1>
					}
				}
			#end
		}
		//Lowest part, below sphere, cone-shaped
		cone {
			y*2,4,-y*.25,3.9
			open
		}
	}

	//Gap, only to simulate cord inside the gap
	#declare ParaGap = sphere {
		0,4
		translate y*2
		#if (1)
			//Gap
			clipped_by {
				box {
					<-4.1,3.5,-4.1>,<4.1,4.4,4.1>
				}
			}
		#end
	}

	#declare ParaChute = union {
		object{
			Para
			texture {
				pigment { PPig }
				//https://wiki.povray.org/content/Reference:Finish
				//finish { emission 0.5 diffuse 0.95}
			}
			translate y*50
		}
		//New
		object{
			ParaGap
			pigment { PPigGap }
			translate y*50
		}

		//cords
		#declare Cnt = 0;
		#while (Cnt < 360)
			cylinder	{
				//0,<3.9,20,0>,.015 		//.05 org
				0,<3.9,19.75,0>, tCords 		//.05 org
				rotate y*Cnt
				pigment {Tan*.5}
				translate y*30
			}
			#declare Cnt = Cnt + 360/nCords;
		#end
		#if (0)
			//Stabalizer?
			sphere {
				0,1
				scale<1,.25,1>
				translate y*25
				pigment { rgb<.25,.15,.25> }
			}
		#end
		#if (0)
			cone {
				y*25,.15,y*31,.2
				pigment { rgb 0 }
			}
			cylinder {
				0,y*30,.15
				pigment { rgb 0 }
			}
		#end
	}

	object {
		ParaChute
	}


#end


#macro ChuteOrg ()



 #declare PPig=pigment{radial color_map{[0 Black][.1 Tan]
                    [.3 rgb<.9,.9,.85>][.6 rgb<.9,.8,.85>]
                    [.9 Tan][1 Black]}
                    frequency 20}
 #declare Para= union{sphere{0,4 translate y*2
                    clipped_by{ box {<-4.1,4.4,-4.1>,<4.1,5.9,4.1>}}}
                    sphere{0,4 translate y*2
                    clipped_by{ box {<-4.1,3.5,-4.1>,<4.1,2,4.1>}}}
                    cone{y*2,4,-y*.25,3.9 open}
                    }
#declare ParaChute=
 union{
  object{Para pigment{PPig} translate y*50}
  sphere{0,1 scale<1,.25,1> translate y*25 pigment{rgb<.25,.15,.25>}}

 //cords
   #declare Cnt = 0;
  #while (Cnt < 360)
   cylinder{0,<4,20,0>,.05 rotate y*Cnt pigment{Tan*.5} translate y*30}
  #declare Cnt = Cnt+20;
  #end
   cone{y*25,.15,y*31,.2 pigment{rgb 0}}//short link
   cylinder{0,y*30,.15 pigment{rgb 0}}//long link
 }

 	object {
		ParaChute
	}



#end


	BG_BlueSky ()

	#local oChute = Chute()
	//#local oChute = ChuteOrg()
	//Spacecraft = MA_Spacecraft1 ("", "", mParams, "y+")



	object {
		oChute
		scale 0.9993
		translate <0,-30,0>
		rotate <70,0,0>
	}



   #if (1)
      camera {
         right		x*image_width/image_height
         location <-1,1,-50>
         look_at  <0,4,0>
         angle    20
         //angle    90
      }
   #elseif (1)
      camera {
         right		x*image_width/image_height
         location <3,1,-35>
         look_at  <0,10,-5>
         angle    70
      }
   #end



   light_source {
      <7, 30, -30> * 100
      colour rgb 1
   }


	plane {
		<0,1,0>, 0
		texture {
			pigment { color rgb<0.35,0.65,0.0>*0.6 }
			normal { bumps 0.75 scale 0.015}
			finish { ambient 0.1 diffuse 0.8}
			//scale 30
			scale 10
		}
	}







