/* usaf.inc  macros + constant data for 'usaf.pov' */

#ifndef (usaf_include_temp)

#declare usaf_include_temp = version;

#version 3.8;

#ifdef (View_POV_Include_Stack)
#debug "including 'usaf.inc'\n"
#end

/* -----[constants etc]------------------------------------------------------ *
 * files    - state, items, log, camera.
 * obj      - "robot" from TOA.
 * radii    - line, prime spheres.
 * rotates  - cf facing.
 * textures - line, primes.
 * yoffs    - height (y) component of "line".
 */

#declare usaf__data_files_ = array [4] {
  "usaf_state.csv","usaf_items.csv","usaf_frame_log.txt","usaf_cam_vars.csv"
};

#declare usaf__data_obj_ = merge {
  difference {
    cylinder {<0,0,0>,<0,1.25,0>,.30}
    text {
      ttf "cyrvetic.ttf","0",1.5,0
      scale <.9,.9,1.5>
      translate <-.22375,.2,-.5>
    }
  }
  cone {<0,.95,0>,.25,<0,.85,.65>,0 scale <.5,1,1>}
};

#declare usaf__data_radii_ = array [2] {.075,.125};

#declare usaf__data_rotates_ = array [4] {0,90,180,270};

#declare usaf__data_textures_ = array [2] {
  texture {pigment {color rgb <0,0,1>} finish {ambient 0 emission 1}},
  texture {pigment {color rgb <1,1,0>} finish {ambient 0 emission 1}}
};

#declare usaf__data_yoffs_ = .15;

#macro usaf__incr(v_,optional n_)
  #if (!defined(local.n_))
    #local n_ = 1;
  #end
  #local v_ = v_ + n_;
#end

/* convert 2-vector pos to 3-vector point, tile centre */
#macro usaf__pos2point(v_)
  <(v_.x + .5), usaf__data_yoffs_, (v_.y + .5)>
#end

/* test for existence of both, or neither, state and items files,
 * depending on flag, not logfile.  camera separate.
 */
#macro usaf__chkFilesExist(exist_)
  #local fs_ = file_exists(concat(fild_workingDir,usaf__data_files_[0]));
  #local fi_ = file_exists(concat(fild_workingDir,usaf__data_files_[1]));
  #if (exist_)
    #local r_ = (fs_ & fi_);
  #else
    #local r_ = (!(fs_ | fi_));
  #end
  r_
#end

#macro usaf__haveCamFile()
  file_exists(concat(fild_workingDir,usaf__data_files_[3]))
#end

/* add a log entry, frame# + state */
#macro usaf__add2log(d_,n_,s_)
  #local d_.Data[dimension_size(d_.Data,1)] = array mixed [7]
      {n_, s_[0], s_[1], s_[2], s_[3], s_[4], s_[5]};
#end

/* frame 0 setup.  create cam vars, items, state, and log if used;
 * log includes prev + curr pos, for generating intermediates.
 * return state + cam vars dictionaries.
 */
#macro usaf__frame_0_init()
  #local dc_ = dictionary {
    .File    : usaf__data_files_[3],
    .Access  : "w",
    .Fields  : camrcd_,
    .Data    : array {array [3] {2.5, 12, 2}},
    .Verbose : verbose_
  };
  Filed(dc_)
  #local di_ = dictionary {
    .File    : usaf__data_files_[1],
    .Access  : "w",
    .Fields  : itmrcd_,
    .Data    : array {array mixed [2] {0, (usaf__pos2point(<0,0>))}},
    .Verbose : verbose_
  };
  Filed(di_)
  // nb. "workings" rely on exact initial values.
  #local ds_ = dictionary {
    .File    : usaf__data_files_[0],
    .Access  : "w",
    .Fields  : objrcd_,
    .Data    : array {array mixed [6] {<0,0>,<0,0>,1,1,1,1}},
    .Verbose : verbose_
  };
  Filed(ds_)
  #if (global.log_frames_)
    #local dl_ = dictionary {
      .File     : usaf__data_files_[2],
      .Access   : "w",
      .Fields   : logrcd_,
      .hasNames : true,
      .Names    : array [7] {"frm#","prev","curr","face","stride","leg","n"},
      .Data     : array,
      .Verbose  : verbose_
    };
    usaf__add2log(dl_,frame_number,ds_.Data[0])
    Filed(dl_)
  #end
  (ds_,dc_)
#end

/* line + prime sphere items */
#macro usaf__mkItems(i_,elem_,arg_)
  union {
    cylinder {arg_.last_, elem_[1], usaf__data_radii_[0]}
    sphere {elem_[1], usaf__data_radii_[0]}
    texture {usaf__data_textures_[0]}
  }
  #if (elem_[0])
    sphere {
      elem_[1], usaf__data_radii_[1]
      texture {usaf__data_textures_[1]}
    }
  #end
  #local arg_.last_ = elem_[1];
#end

/* true if n_ in a_[] */
#macro usaf__isPrime(a_,n_)
  #local r_ = false;
  #for (i_,0,dimension_size(a_,1)-1)
    #if (n_ = a_[i_])
      #local r_ = true;
      #break
    #end
  #end
  r_
#end

/* new position after step in direction facing */
#macro usaf__newPos(pos_,df_)
  #local x_ = pos_.x;  #local y_ = pos_.y;
  #switch (df_)
    #case (0) #local y_ = 1 + y_; #break
    #case (1) #local x_ = 1 + x_; #break
    #case (2) #local y_ = y_ - 1; #break
    #case (3) #local x_ = x_ - 1; #break
    #else
      #error "oops, \"cannot happen\" error in '__newPos()'."
  #end
  <x_,y_>
#end

/* turn left ;-) */
#macro usaf__newFace(df_)
  mod((4 + df_ - 1),4)
#end

/* the "bot" {prev, curr, face, stride, leg, n} */
#macro usaf__obj(self_)
  #local self_[0] = self_[1];
  #if (!self_[5])
    #local self_[2] = usaf__newFace(self_[2]);
    #if (self_[4])
      usaf__incr(self_[4],-1)
    #else
      #local self_[4] = 1;
      usaf__incr(self_[3],)
    #end
    #local self_[5] = self_[3];
  #end
  #local self_[1] = usaf__newPos(self_[1],self_[2]);
  usaf__incr(self_[5],-1)
#end

#version usaf_include_temp;

#end

