/* Mark Newbold's 'kaleido2.html' #1, modified */

#version 3.7;

global_settings {
  assumed_gamma 1
  max_trace_level 35
}

camera {
  location <0, 0, -4>
  right x
  angle 35
  look_at <0, 0, 0>
}

/* image and Z-axis, different rates */
#declare currI_ = .5 * frame_number;
#declare currZ_ = .25 * frame_number;

#declare Mirrors = union {
#local P = 3;
#local Count = 0;
#while (Count < P)
  #local Theta = (2*Count*pi/P);
  plane { <cos(Theta),sin(Theta),0>, .245
    finish {
      reflection 1
      ambient 0
      specular 0
    }
  }
  #declare Count = Count + 1;
#end
};

#declare myimage = pigment {
  image_map {png "bg2.png" once}
  translate -.5
  rotate z * currI_
  translate .5
  scale 1.15
};

union {
  plane {
    <0, 0, -1>, 0
    pigment {myimage}
    translate <-.5,-.5,0>
    finish {ambient 1.4 emission 0}
  }
  object {
    Mirrors
    rotate -z * currZ_
  }
}

