// Persistence of Vision Ray Tracer Scene Description File
// for FreeCAD (http://www.freecadweb.org)

#version 3.8;

#include "colors.inc"
#include "metals.inc"
#include "rad_def.inc"
#include "math.inc"
#include "textures.inc"

global_settings {
	radiosity {
		Rad_Settings(Radiosity_Normal,off,off)
//		Rad_Settings(Radiosity_Final,on,on)
	}
	assumed_gamma 1.6
}

#default {finish{ambient 0}}

#declare StdFinish = finish { specular 0.02 roughness 0.00003 phong 2 phong_size 4000 reflection { metallic} };

// declares position and view direction

#declare cam_location = < 0, 0, -25 >;
#declare cam_look_at  = < 0, 0, 0 >;
#declare cam_angle    = 75; 


camera {
	location  cam_location
	look_at   cam_look_at
	angle     cam_angle 
	right     x * image_width / image_height
}






box {
        < -1000, -1000, 2 >, < 1000, 1000, 2 >
        pigment { color rgbt <0.0, 0.0, 0.0, 0.0> }
        no_shadow
	finish {
		diffuse 0.8
		specular 0.2 roughness 0.3 phong 0.0100 phong_size 4000
		reflection {
			0
		}
	}
}





#declare mytime = datetime(now, "%H:%M:%S");
#declare myhours = val(substr(mytime, 1, 2));
#declare mymins = val(substr(mytime, 4, 2));
#declare mysecs = val(substr(mytime, 7, 2));

#warning concat("mytime is:", mytime,"\n")


#declare NumberOn = pigment { color rgb < 80, 30, 0 > transmit 0 };
#declare NumberOff = pigment { color rgb < 0.2, 0.2, 0.2 > transmit 0.8 };
#declare TubeMetal = pigment { color rgb < 0.1, 0.1, 0.1 > };


#declare ts_number = int(div(myhours, 10) + 1e-6);
#declare myhours = myhours - ts_number * 10;
#warning concat("ts_number is:",str(ts_number,5,0),"\n")
#declare Xpos = -6.4;
#include "tube.inc"

#declare ts_number = myhours;
#warning concat("ts_number is:",str(ts_number,5,0),"\n")
#declare Xpos = -4.2;
#include "tube.inc"

#declare ts_number = int(div(mymins, 10) + 1e-6);
#declare mymins = mymins - ts_number * 10;
#warning concat("ts_number is:",str(ts_number,5,0),"\n")
#declare Xpos = -1.1;
#include "tube.inc"

#declare ts_number = mymins;
#warning concat("ts_number is:",str(ts_number,5,0),"\n")
#declare Xpos = 1.1;
#include "tube.inc"

#declare ts_number = int(div(mysecs, 10) + 1e-6);
#declare mysecs = mysecs - ts_number * 10;
#warning concat("ts_number is:",str(ts_number,5,0),"\n")
#declare Xpos = 4.2;
#include "tube.inc"

#declare ts_number = mysecs;
#warning concat("ts_number is:",str(ts_number,5,0),"\n")
#declare Xpos = 6.4;
#include "tube.inc"



light_source {
        < -6.4, 6, -45 >
        color rgb < 0.65, 0.6, 0.6 >
        spotlight
        point_at < -6.4, 0, 0 >
        radius 60
        tightness 100
        falloff 60
}
light_source {
        < -4.2, 6, -45 >
        color rgb < 0.65, 0.6, 0.6 >
        spotlight
        point_at < -4.2, 0, 0 >
        radius 60
        tightness 100
        falloff 60
}
light_source {
        < -1.1, 6, -45 >
        color rgb < 0.65, 0.6, 0.6 >
        spotlight
        point_at < -1.1, 0, 0 >
        radius 60
        tightness 100
        falloff 60
}
light_source {
        < 1.1, 6, -45 >
        color rgb < 0.65, 0.6, 0.6 >
        spotlight
        point_at < 1.1, 0, 0 >
        radius 60
        tightness 100
        falloff 60
}
light_source {
        < 4.2, 6, -45 >
        color rgb < 0.65, 0.6, 0.6 >
        spotlight
        point_at < 4.2, 0, 0 >
        radius 60
        tightness 100
        falloff 60
}
light_source {
        < 6.4, 6, -45 >
        color rgb < 0.65, 0.6, 0.6 >
        spotlight
        point_at < 6.4, 0, 0 >
        radius 60
        tightness 100
        falloff 60
}
