#include "math.inc"
/*************************************************
* Name: initAnimation             Date: 9/14/2010 *
*                                                 *
* Auth: Anthony D. Baye                           *
* Args: Time                                      *
* Desc: Takes the animation length as a ordered-  *
*     triple in the form <h, m, s>.  Re-computes  *
*     duration in seconds and defines a global    *
*     constant called "tick".  Also defines a flag*
*     for error-checking purposes.                *
*       Ensures that the clock is running, before *
*     initializing animation environment.         *
 *************************************************/
#macro initAnimation(Time)
     #if(clock_on)
          #local Seconds = Time.x*3600 + Time.y*60 + Time.z;
          #declare _TICK_ = (final_clock - initial_clock) / Seconds;

          #declare _ANIMATION_TIMER_ = true;
//          #debug concat("_TICK_ = " str(_TICK_,0,6) "\n")
//          #debug concat("clock_delta = " str(final_clock/final_frame,0,6) "\n")
/*     #else
          fatal "Error! clock not initialized.\n"*/
     #end
#end

/*************************************************
* Name: eClock                    Date: 9/14/2010 *
*                                                 *
* Auth: Anthony D. Baye                           *
* Args: Time                                      *
* Desc: Receives a time index as an ordered-triple*
*     recomputes the time in seconds and returns  *
*     the corresponding number of ticks.          *
 *************************************************/
#macro eClock(Time)
//     #ifdef(_ANIMATION_TIMER_)
          #local Seconds = Time.x*3600 + Time.y*60 + Time.z;
//          #debug concat("event_clock = " str(_TICK_*Seconds,0,6) "\n")
          _TICK_*Seconds
          
//     #else
//          #fatal "Animation timer not defined: Call initAnimation first.\n"
//     #end
#end


/*************************************************
* Name: Timer                     Date: 9/14/2010 *
*                                                 *
* Auth: Anthony D. Baye                           *
* Args: Type, Start, Finish, speed                *
* Desc: Computes an event timer for an effect.    *
*     Can be multiplied by a direction-vector.    *
*                                                 *
*     Type: type of motion; accelerating/steady   *
*     Start: Starting time index for event.       *
*     Finish: Ending time index for event.        *
*     speed: event speed in units per second.     *
*           If type=1 this is Delta-V             *
*           If type=2 this is the acceleration    *
*           If type=3 this is the speed           *
 *************************************************/
#macro Timer(Type, Start, Finish, Q)
     #ifdef(_ANIMATION_TIMER_)
          #local D = Finish - Start;
          #local T = D.x*3600 + D.y*60 + D.z;
          #if((clock > eClock(Start)) & (clock <= eClock(Finish)))
               #switch(Type)
               #case(1)
                    (T*Q/2)*pow((clock-eClock(Start))/eClock(D),2)
                    #break
               #case(2)
                    ((Q*T*T)/2)*pow((clock-eClock(Start))/eClock(D),2)
                    #break
               #case(3)
                    T*Q*((clock-eClock(Start))/eClock(D))
                    #break
               #end
          #else
               0
          #end

/*               #if((Type != 1) & (Type != 2) & (Type != 3))
                    #warning "first parameter must be 1 or 2\n
                         1: accelerating motion based on ending velocity\n
                         2: steady motion\n"
                         3: accelerating motion based on acceleration\n"
               #end
     #else
          #warning "Animation timer not defined:
               \n\tCall initAnimation first.\n"*/
     #end
#end
