// PoVRay 3.7 Scene File "five_intersecting_tetrahedra.pov"
// author:  Bruno Gimeno
// date:    circa 2018-2019
//------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"
#include "transforms.inc"
//---------------------------------------------------------------------------------
#macro CW_Angle (COLOR,A)
   #local RGB = color COLOR;
   #local R = (RGB.red);
   #local G = (RGB.green);
   #local B = (RGB.blue);
   #local Min = min(R,min(G,B));
   #local Max = max(R,max(G,B));
   #local Span = Max-Min;
   #local H = CRGB2H (<R,G,B>, Max, Span);
   #local S = 0; #if (Max!=0) #local S = Span/Max; #end
   
   #local P = <H+A,S,Max> ;
   
   #local HSV = color P ;
   #local H = (HSV.red);
   #local S = (HSV.green);
   #local V = (HSV.blue);
   #local SatRGB = CH2RGB(H);
   #local RGB = ( ((1-S)*<1,1,1> + S*SatRGB) * V );
   rgb <RGB.red,RGB.green,RGB.blue>
#end

//---------------------------------------------------------------------------------
#declare Camera_Number = 1 ;
//---------------------------------------------------------------------------------
// camera -------------------------------------------------------------------------
#switch ( Camera_Number )
#case (0)
  #declare Camera_Location = < 0.00, 1.00,-40.00> ;  // front view
  #declare Camera_Look_At  = < 0.00, 1.00,  0.00> ;
  #declare Camera_Angle    =  15 ;
#break
#case (1)
  #declare Camera_Location =  <20.0 , 14.0 ,-20.0> ;  // diagonal view
  #declare Camera_Look_At  =  < 0.0 , 0.0 , 0.0> ;
  #declare Camera_Angle    =  10 ;
#break
#case (2)
  #declare Camera_Location = < 3.0, 1.0 , 0.0> ;  // right side view
  #declare Camera_Look_At  = < 0.0, 1.0,  0.0> ;
  #declare Camera_Angle    =  90 ;
#break
#case (3)
  #declare Camera_Location = < 0.00, 5.00,  0+0.000> ;  // top view
  #declare Camera_Look_At  = < 0.00, 0.00,  0+0.001> ;
  #declare Camera_Angle    = 90 ;
#break
#else
  #declare Camera_Location = < 0.00, 1.00, -3.50> ;  // front view
  #declare Camera_Look_At  = < 0.00, 1.00,  0.00> ;
  #declare Camera_Angle    =  75 ;
#break
#break
#end // of "#switch ( Camera_Number )"  
//--------------------------------------------------------------------------
camera{ // ultra_wide_angle // orthographic 
        location Camera_Location
        right    x*image_width/image_height
        angle    Camera_Angle
        look_at  Camera_Look_At
      }
//------------------------------------------------------------------------
// sun -------------------------------------------------------------------
light_source{<-500,2000,-2000> color rgb<1,1,1>*0.9}                // sun 
light_source{<500,-2000,1000> color rgb<1,1,1>*0.3 shadowless}                // sun 
//light_source{ Camera_Location   color rgb<0.9,0.9,1>*0.1 shadowless}// flash
light_source{<0,0,0> color rgb<1,1,1>*0.2 shadowless}                // center flash
// sky -------------------------------------------------------------------
sky_sphere{ pigment{ gradient <0,1,0>
                     color_map{ [0   color rgb<1,1,1>         ]//White
                                [0.4 color rgb<0.14,0.14,0.56>]//~Navy
                                [0.6 color rgb<0.14,0.14,0.56>]//~Navy
                                [1.0 color rgb<1,1,1>         ]//White
                              }
                     scale 2 }
           } // end of sky_sphere 
//------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//--------------------------------------------------------------------------

#macro Triangle (L,sdv,r_c,r_s)
#local L_sdv = (L/sdv)*.5 ;
#local Cylinder_TXT =
            texture { 
                pigment {White}
                finish {reflection .2
                        phong .4
                       }
               }
#local Cylinder_TXT2 =
            texture { 
                pigment {Red}
                finish {reflection .2
                        phong .4
                       }
               }

  #local Side =
     union {
            cylinder {<-L/2,0,0>,<(L/2),0,0>,r_c texture {Cylinder_TXT}}

            cylinder {<-(L/2)+L_sdv,0,L_sdv/tand(30)>
                      < (L/2)-L_sdv,0,L_sdv/tand(30)>,r_c*.75
                     texture {Cylinder_TXT} }

            #if (sdv>1)
            #local sdv_counter = 0 ;
            #while ( sdv_counter < sdv )
       union {
             cylinder {<0,0,0>,<0,0,L_sdv*2>,r_c*.75
                       rotate y*30
                       translate x*-L/2
                       translate x*sdv_counter*L_sdv*2
                       }
             cylinder {<0,0,0>,<0,0,L_sdv*2>,r_c*.75
                       rotate y*-30
                       translate x*L/2
                       translate x*-sdv_counter*L_sdv*2
                       }

             sphere {<0,0,L_sdv*2>,r_s
                     rotate y*30
                     translate x*-L/2
                     translate x*sdv_counter*L_sdv*2
                    }
             sphere {<0,0,0>,r_s
                     rotate y*30
                     translate x*-L/2
                     translate x*sdv_counter*L_sdv*2
                    }
            texture {Cylinder_TXT}}

            #local sdv_counter = sdv_counter + 1 ;
            #end

            #local sdv_counter2 = 0 ;
            #while ( sdv_counter2 < sdv-1 )
             triangle {
                      <-L/2,0,0>,<(-L/2)+(L_sdv),0,(L_sdv)*cosd(30)*2>,<-(L/2)+(L_sdv*2),0,0>
                       translate x*sdv_counter2*L_sdv*2
//                     pigment {Red}
                      }

             triangle {
                      <(-L/2)+(L_sdv),0,(L_sdv)*cosd(30)*2>
                      <-(L/2)+(L_sdv*2),0,0>
                      <(-L/2)+(L_sdv*3),0,(L_sdv)*cosd(30)*2>
                       translate x*sdv_counter2*L_sdv*2
//                      pigment {Orange}
                      }

            #local sdv_counter2 = sdv_counter2 + 1 ;
            #end




#local a_alpha = 60 ;
#local l_a = (L/2)/tand(a_alpha);
#local l_b = (L/2)/sind(a_alpha);
#local l_c = l_a + l_b ;
#local a_beta = acosd(l_a/l_c);// dihedral angle
#local l_d = sind(a_beta)*l_c;
#local l_e = L_sdv*sind(60);
#local l_f = 2*sind(a_beta/2)*l_e;
#local a_gamma = 90-a_beta ;
#local l_g = cosd(a_gamma)*l_e;
#local l_h = sind(a_gamma)*l_e;
#local l_i = l_e-l_h;

#local p1a =  <-(L/2)+(L_sdv*3),0,L_sdv/tand(30)> ;
#local p2a = < (L/2)-(L_sdv*3),0,L_sdv/tand(30)> ;
#local p3a = <-(L/2)+(L_sdv*3),l_g,(L_sdv/tand(30))-l_i> ;
#local p4a = < (L/2)-(L_sdv*3),l_g,(L_sdv/tand(30))-l_i> ;

            cylinder { p1a, p2a,r_c  texture {Cylinder_TXT}  }
            triangle {p1a,p2a,p3a }
            triangle {p2a,p3a,p4a }

            #local sdv_counter3 = 0 ;
            #while ( sdv_counter3 < sdv -2)
            cylinder {p1a,p3a,r_c*1 translate x*sdv_counter3*L_sdv*2
                      texture {Cylinder_TXT} 
                      }

            #local sdv_counter3 = sdv_counter3 + 1 ;
            #end

            #end
            sphere {<L/2,0,0>,r_s texture {Cylinder_TXT} }
            translate y*max(r_c,r_s)
            translate -z*((L/2)/tand(60) )
           }
union {
object {Side }
object {Side rotate y*120}
object {Side rotate y*240}
}
#end

/*
object {
Triangle (
           5, // longitud arista
           6, // subdivisiones
          .04, // grosor arista
          .1 // grosor esferas
         )
        pigment {Orange}
        finish {
               phong .5
               reflection .3
               }
        }
*/

#macro Tetra_Net (L,sdv,r_c,r_s)
#local _a_ = (L/2)/tand(60) ;
#local _b_ = (L/2)/sind(60) ;
#local _alfa_ = acosd(_a_/(_a_+_b_)) ;
#local _d_ = 
     transform {
               translate -y*max(r_c,r_s)
               rotate z*180
               translate z*((L/2)/tand(60)) 
               rotate x*-_alfa_ 
               translate -z*((L/2)/tand(60))
               translate y*max(r_c,r_s)
               }

union {
      object { Triangle (L,sdv,r_c,r_s) }
      object { Triangle (L,sdv,r_c,r_s)  transform _d_ }
      object { Triangle (L,sdv,r_c,r_s)  transform _d_ rotate y*120 }
      object { Triangle (L,sdv,r_c,r_s)  transform _d_ rotate y*240 }
      }
      
#end
/*
object {
Tetra_Net (
           4, // longitud arista
           12, // subdivisiones
          .03, // grosor arista
          .05 // grosor esferas
         )
        pigment {Tan}
        finish {
               phong .5
               reflection .3
               }
        }
*/


//  ---------------------------------------------------------------
#macro five_tetra (L,SBD,G_a,G_c) 
//  ---------------------------------------------------------------
#local tetrapos =
transform {  
  rotate z*180
  translate <0,(sqrt(6)/12)*L,0>
  rotate y*30
  rotate x*37.377368144604          
          }

#declare COLOR1 = rgb <225,129,36>/255 ;

union {
object { 
        Tetra_Net ( L,SBD,G_a,G_c )
        pigment {Gray50}
//          pigment {CW_Angle(CW_Angle(COLOR1,clock),clock)}
        finish { reflection .2
               }
	transform {tetrapos} rotate y*72*0
        }

object {
	Tetra_Net ( L,SBD,G_a,G_c )
        pigment {Gray50}
//        pigment {CW_Angle(CW_Angle(COLOR1,(clock+(72*1))),(clock+(72*1)))}
        finish { reflection .2
               }
	transform {tetrapos} rotate y*72*1
        }

object {
	Tetra_Net ( L,SBD,G_a,G_c )
        pigment {Gray50}
//          pigment {CW_Angle(CW_Angle(COLOR1,(clock+(72*2))),(clock+(72*2)))}
        finish { reflection .2
               }
	transform {tetrapos} rotate y*72*2
        }
object {
	Tetra_Net ( L,SBD,G_a,G_c ) 
        pigment {Gray50}
//       pigment {CW_Angle(CW_Angle(COLOR1,(clock+(72*3))),(clock+(72*3)))}
        finish { reflection .2
               }
	transform {tetrapos} rotate y*72*3
        }                 

object {
	Tetra_Net ( L,SBD,G_a,G_c )
        pigment {Gray50}
//        pigment {CW_Angle(CW_Angle(COLOR1,(clock+(72*4))),(clock+(72*4)))}
        finish { reflection .2
               }
	transform {tetrapos} rotate y*72*4
        }         
}
//  ---------------------------------------------------------------
#end // end macro five thetraedra
//  ---------------------------------------------------------------

object {
five_tetra (3.75,16,.01,.01) 
rotate y*clock
rotate -x*clock*5
}


