// Vers: 3.6
// Auth: Leroy Whetstone Email lrwii@joplin.com
//====================================================================
#include "colors.inc"
global_settings {max_trace_level 20}

camera{ location <0,0,-10> //don't change
        look_at <0,0,0>    //don't change
        right x*image_width/image_height //don't change
        //normal{agate.02 translate -clock*40}
        }
//can change
 light_source{<200,30,400> color White}
 light_source{<-200,-30,400> color White}
 light_source{<0,10,-100> color White}

//----Display variable changes ---------------
#declare Debug= 0;//0=no debug 1=Lite 2= backgound only
#declare Fps= 24;//frames per second
#declare Text=#include"Test2.inc" //Credits file
#declare Start_Offset=0;//-2.5 +toward top -toward bottom
#declare End_Offset=0; //-1.492+toward top -toward bottom

#declare Background_image="";//"Balls00.tga";//back ground pigment
#declare Background_Animation=0;//yes no
#declare Background_Ambient=.1;//.1 default ambient value Background

#declare Text_Material=
    material{ 
           texture{
            pigment{gradient y color_map{[0 rgb 1][.5 Gold][1 rgb 1]}
                    frequency 14 scale image_width/20 }
            normal{agate.5}
            finish{specular .3 roughness 1/23}
            }
           //interior{ior 1.33} 
          }
//----end of changes ---------------

//====================  Start of Work =================================================

#declare End_Offset=End_Offset-Start_Offset;

//screen size
#declare Asp = image_width/image_height;
               //#debug concat("Asp="str(Asp,3,3),"\n") 
#declare dl=abs(0.5*Asp/tan(radians(33.69)));
            //#debug concat("Dl="str(dl,3,3),"\n") 
#declare Angle=degrees(atan(0.5*Asp/dl));
             //#debug concat("Angle="str(Angle,3,3),"\n") 

#declare Dx=tan(radians(Angle))*dl*vlength(-z*10);//dislay width in pov units
           #if(Debug=1) #debug concat("Display_X= "str(Dx,3,3),"\n") #end
#declare Dy=Dx/Asp;                               //dislay height in pov units
           #if(Debug=1) #debug concat("Display_Y= "str(Dy,3,3),"\n") #end
           // sphere{x*Dx,.1 pigment{Gold} finish{ambient 1 }}
           // sphere{y*Dy,.1 pigment{Gold} finish{ambient 1 }}

//text stuff
//#declare L=max_extent(Text)-min_extent(Text);
//#debug concat("Text size= <",vstr(3,L,",",3,3),">\n")


#if(abs(min_extent(Text).y)<max_extent(Text).y)
    #declare L=-max_extent(Text).y; 
    #declare Sb=abs(min_extent(Text).y); 
    #if(Debug) #debug "Scroll Down \\/"#end
#else 
 #if(abs(min_extent(Text).y)=max_extent(Text).y)
  #declare L=-max_extent(Text).y; 
  #if(Debug)#debug " Only One line " #end
  #declare Sb=abs(min_extent(Text).y); 
 #else   
    #if(Debug)#debug "Scroll Up /\\" #end
    #declare L=-min_extent(Text).y;
    #declare Sb=-(max_extent(Text).y);  
 #end
#end

#declare TL=L;
#declare L=L+End_Offset;//+Start_Offset;

#declare Speed=abs(L)/final_frame; 

#if(Debug=1)
 #debug concat("  Pov_Units/Frames =",str(Speed,4,4),"\n\n")
#end

#declare Speed=final_frame/Fps; 
#if(Debug=1)
 #debug concat("Total Time =",str(Speed,2,2)," at ",str(Fps,2,2)" frame per second\n\n")

 #debug concat("Center of last Text =",str(Text_End,3,3)," (Text_End)\n")
 #debug concat("Start of Text block = ",str(-Sb,4,4),"\n")
 #debug concat("End of Text block = ",str(-L,4,4),"\n\n")
 #if(Start_Offset=0)
 #debug concat("Estimated End Offset to center Last Text = ",str(-TL-Text_End,4,4),"\n")
 #debug concat("Estimated End Offset to take Last Text offscreen= ",str(Dy-(-TL-Text_End),4,4),"\n\n")
 #else
 #debug " Set Start_Offset=0  For Estimated End Offsets\n\n"
 #end
#end

//============= TEXT OBJECT ==============================================

object{Text material{Text_Material} translate y*(L*clock+Start_Offset)}
/*object{Text //pigment{gradient y color_map{[0 rgb 1][.5 Gold][1 rgb 1]}
            //frequency 14 scale image_width/20 }
         pigment{White}
       //scale<1,1,.1>
       //normal{agate.5}
       finish{specular .3 roughness 1/23}
       //finish{ambient 1}
       translate y*(L*clock+Start_Offset)
       }
*/
// see center of screen and end of text
#if(Debug)
 sphere{0,.2 pigment{Red}} //center point
 sphere{y*Text_End+x*.25,.2 pigment{Green} translate y*(L*clock+Start_Offset)}                     
 sphere{-y*L.y+x*.45,.2 pigment{Gold} translate y*(L*clock+Start_Offset)}
#end

//_________________ Background image map _______________________________

#if(strlen(Background_image))
 #macro FixVal(Scene) // decode (name,id,type) from backgound Scenes
  #local A=1;
  #local B=0;
  #local C=strlen(Scene);
  #local D=0;

  #while(B=0)
   #local N=substr(Scene,A,1);
   #if(strcmp(N,"0")=0) #local B=A; #end
   #if(val(N)>0) #local B=A; #end
   #local A=A+1; 
   //#debug concat(D," A=",str(A,3,3),"  ",str(B,3,3),"\n")
   #if (A>C) #debug concat("\n**** Error: __",Scene,"__ number not right ***\n\n")
    #error "Scene number not right" 
   #end
  #end
  
  #while(D=0)
   #local N=substr(Scene,A,1);
    #if(strcmp(N,".")=0) #local D=A; #end
   #local A=A+1; 
   //#debug concat(D," A=",str(A,3,3),"  ",str(B,3,3),"\n")
    #if (A>C) #debug concat("\n**** Error: __",Scene,"__ Type not right ***\n\n")
      #error "Scene Type not right" 
   #end
  #end
 
  #declare Sname=substr(Scene,1,B-1);
  #declare Stype=substr(Scene,D+1,3)
  #declare Sid=D-B;
  #declare Fdata=val(substr(Scene,B,Sid))+frame_number;
  //#debug concat(N," C=",str(D,3,3),"  ",str(B,3,3),"  ",str(Sid,3,3),"  ",str(Fdata,3,3),"\n")
  //#if(Debug>1)
  //#debug concat("\nSname= ",Sname," Stype=",Stype," ",str(Fdata,-Sid,0)"\n")
  //#end
 #end

 // start of background work 

 #declare Asp = image_width/image_height;
 #declare dl=abs(0.5*Asp/tan(radians(33.69)));
 #declare Angle=degrees(atan(0.5*Asp/dl));
 #declare Dx=tan(radians(Angle))*dl*vlength(-z*10);//dislay width in pov units
 #declare Dy=Dx/Asp;                               //dislay height in pov units
 #if(Background_Animation)
  FixVal(Background_image)
  #declare Pimage=concat(Sname,str(Fdata,-Sid,0),".",Stype);
  #if(Debug>1) #debug concat("\nBackground_image= ",Pimage,"\n")#end
 #else
  #if(Debug>1) #debug concat("\nBackground_image= ",Background_image,"\n")#end
 #end
 box{<-.5,-.5,0><.5,.5,.1>
     #if(Background_Animation)
      pigment{image_map{tga Pimage}translate<-.5,-.5,0> }
     #else
     pigment{image_map{tga Background_image}translate<-.5,-.5,0> }
     #end
      finish{ambient Background_Ambient}
     scale <Dx*2,Dy*2,1>
    } 
#else
 #if(Debug>1) #debug "\n No Background Image \n" #end
#end

