// string control functions in text
// 3 remark lines
// trying to combine text
// Vers: 3.6
// Auth: Leroy Whetstone Email lrwii@joplin.com
//====================================================================
//
//text file control data
//      LRcontrol =  Control Flag  mark string as a control string
// Function string  Variable  type      does
//         Tfont  = Font      <String>  default Texts font
//         TScale = TextScale <float>   default Scale Text
//         Tspace = TextAdj <float>(adjust y location of text's height)
//         TOffX  =  TXoff; <float> x value of Text's Offset 
//         TOffY  =  TYoff; <float> y value of Text's Offset 
//         Tjust  = TextJust <float>  text justifycation
//         Lspace = LineSpace <float>(space's height)
//         Lborder= LineBorder <float>(border from x egdes)
//         Llock  = LineLock  <on/off>,<1,0> next text on same line
                    
#if(frame_number>initial_frame) //stop render
                    #debug"\n*************************\n"
                    #debug"\nOnly need on one Run!!\n\n"
                    #debug"*************************\n"
                    #error"Stopped"
#end

#include "colors.inc"

//------ Change to show debug statments ----------
#declare Debug=1;//1= light info 2=more info 

//-------Text defaults can change---------
#declare TextFile="Text2.txt"//read text file
#declare ObjFile="Test2.inc"// place text objects
#declare Style=1;//scroll  0=down 1=up
#declare Font="timrom.ttf"//% font
#declare TextThick=.4;//.4 float text z start thickness
#declare TextPlace=-.2;//-.2 z direction adjust
#declare TextScale=2;//%2 float scale text
#declare TXoff=0;//%0 text object <value,0,0>
#declare TYoff=0;//%0 text object <0,value,0>
#declare TextAdj=1;//%1 pov units added to text height
#declare TextJust=0;//%0 -1 left 0 center 1 right
#declare LineSpace=1;//%1 pov units spaces height
#declare LineBorder=1;//%1 pov units from sides
#declare LineLock=0;//%0 lock texts to a single line

// '% default value' mean that the text file can change Ideam

//----end of Text changes --------------- 
//----end of Changes --------------- 



#declare Control_Word="LRcontrol";
#declare Fnc_Wrd=array[9]{"Tscale","Tjust","Tadj","Lspace","Lborder","Llock","TOffX","TOffY","Tfont"}
   
#declare TxtXloc=0;
#declare TxtYloc=0;
#declare String="txt"
#declare LockCnt=0;
#declare TextOff=<TXoff,TYoff,0>;


// macros-----------------
#macro ControlCK(As)
 #local L=strlen(As);
 #local Lc=strlen(Control_Word);
 #local Out=0;
 #if(Lc>L)
  #local Out=-10;
 #else  
  #local Out =strcmp(Control_Word,substr(As,1,Lc));
  //#debug concat(substr(As,1,Lc+1),"..\n")
 #end
 (Out)
#end
#macro FncWrd(Ts)//find func words
   #local Out=0;
   #local Cnt = 0;
  // #debug concat("..",Ts,"..\n")
   #while (Cnt < 9)
    #local Tsa=Fnc_Wrd[Cnt]
    //#debug concat("     ..",Fnc_Wrd[Cnt],"..\n")
    #if(strcmp(Ts,Tsa)=0) #local Out=Cnt+1; #end
   #local Cnt = Cnt+1; 
   #end
  (Out)
#end
#macro ControlFix(SA) //-- control changes-

 #local L=strlen(SA);
 #local Str=concat(substr(SA,11,L-10)," ");
 #local L=strlen(Str);
 //#debug concat(Str,"___",str(L,0,0),"\n")
  #local Cnt = 1;
  #local Qs=chr(64);
  #while (Cnt <= L)//get func words and vaules
   #if(strcmp(substr(Str,Cnt,1),",")=0)
    #local Qs=concat(Qs,chr(Cnt+64))
   #end
  #local Cnt = Cnt+1; 
  #end
   #local Qs=concat(Qs,chr(L+64))
   #local Ql=strlen(Qs); 
   //#debug concat(" \n",str(L,0,0),",",str(Ql,0,0)," ",Qs,"\n\n")

 
  #local Cnt = 1;
  #while (Cnt <= Ql-2)//get func words and vaules
    //#debug concat("Cnt =",str(Cnt,0,0),"\n")
    #local S=asc(substr(Qs,Cnt,1))-64; //#debug concat("S =",str(S,0,0),"\n")
    #local E=asc(substr(Qs,Cnt+1,1))-64;//#debug concat("E =",str(E,0,0),"\n")
    #local N=asc(substr(Qs,Cnt+2,1))-64;//#debug concat("N =",str(N,0,0),"\n")
    
    #local Smp=substr(Str,S+1,E-S-1)
    #local Ssv=substr(Str,E+1,N-E-1)
     #if(Debug>1) #debug concat("   Function =",Smp,"   Value =",Ssv,"\n")#end
    #local Fs=FncWrd(Smp);//#debug concat("   Fs =",str(Fs,3,3),"\n")
  
    #switch (Fs)
     #case(0) #debug "\n********************************\n"
              #debug concat("\n Text File Control error!!! Line: ",str(LineCnt+2,0,0)," \n\n")
              #debug concat("   Control= ",Smp,"  ControlValue=",Ssv,"\n\n")
              #debug "*********************************\n\n"
              #error"Text error stopped"
              #break
     #case(1) #declare TextScale=val(Ssv); #break
     #case(2) #declare TextJust=val(Ssv); #break
     #case(3) #declare LSpace=val(Ssv); 
              #if(LineCnt>1)
               #if(Style)
                #declare TxtYloc=TxtYloc+TextAdj;
                #declare TxtYloc=TxtYloc-LSpace;
               #else
                #declare TxtYloc=TxtYloc-TextAdj;
                #declare TxtYloc=TxtYloc+LSpace;
               #end
              #end
              #declare TextAdj=LSpace;
              #break

     #case(4) #declare LineSpace=val(Ssv); #break
     #case(5) #declare LineBorder=val(Ssv); 
              #declare DBx=Dx-LineBorder;
              #break
     #case(6) #declare LineLock=val(Ssv); 
              #declare LockCnt=0;
              #break
     #case(7) #declare TXoff=val(Ssv); 
              #declare TextOff=<TXoff,TYoff,0>; 
              #break
     #case(8) #declare TYoff=val(Ssv); 
              #declare TextOff=<TXoff,TYoff,0>; 
              #break
     #case(9) #declare Font=Ssv; #break
    #end
  #local Cnt = Cnt+2; 
  #end // loop
#end //end of macro


camera{ location <0,0,-10>
        look_at <0,0,0>
        right x*image_width/image_height
        }
#if(Debug>0)
  #debug concat(" TextFile= ",TextFile,"\n")
  #debug concat(" ObjFile= ",ObjFile,"\n\n")
#end
//------------- calc screen size----------------------
#declare Asp = image_width/image_height;
               //#debug concat("Asp="str(Asp,3,3),"\n") 
#declare dl=abs(0.5*Asp/tan(radians(33.69)));
            //#debug concat("Dl="str(dl,3,3),"\n") 
#declare Angle=degrees(atan(0.5*Asp/dl));
             //#debug concat("Angle="str(Angle,3,3),"\n") 

#declare Dx=tan(radians(Angle))*dl*vlength(-z*10);//dislay width in pov units
            #if(Debug>0) #debug concat("Display_X= "str(Dx,3,3),"\n") #end
#declare Dy=Dx/Asp;                               //dislay height in pov units
            #if(Debug>0)#debug concat("Display_Y= "str(Dy,3,3),"\n") #end
#declare DBx=Dx-LineBorder;                     //max text width in pov units
            #if(Debug>0)#debug concat("Display_Border_X= "str(DBx,3,3),"\n") #end
            sphere{x*Dx,.1 pigment{Gold} finish{ambient 1 }}
            sphere{y*Dy,.1 pigment{Gold} finish{ambient 1 }}
            sphere{x*DBx,.1 pigment{Gold} finish{ambient 1 }}




//read Text file
#fopen Mfile TextFile read
#fopen Nfile ObjFile write
 #read (Mfile,Comment1) //#debug concat("Comment: ",Comment,"\n")
 #read (Mfile,Comment2)
 #read (Mfile,Comment3)
 #write(Nfile,"//",Comment1,"\n")
 #write(Nfile,"//",Comment2,"\n")
 #write(Nfile,"//",Comment3,"\n")
 #if(Style) #write(Nfile,"//  Scroll Up\n")
 #else  #write(Nfile,"// Scroll Down\n")
 #end
 #write(Nfile,"union{\n")
 #declare LineCnt=1;
 #while(defined(Mfile))
  #read (Mfile,SA) 
   #declare Va=ControlCK(SA); //#debug concat("Va =",str(Va,3,3),"\n")
   #if (Va=0) //fix controls
     #if(Debug>1)  #debug concat("Function String =",SA,"\n") #end
     ControlFix(SA)
   #else     //process string
   #declare String=SA;

//----------------fix fuctions -----------------------
 
   #declare Tmp = text {ttf Font String 1 TextOff}
   #declare TxtXloc=0;
    #declare Trans=max_extent(Tmp)-min_extent(Tmp);
    #declare Center=(max_extent(Tmp)+min_extent(Tmp))/2;
//    #debug concat("Trans= <",vstr(3,Center,",",3,3),">\n")
   #if(Center.x=0)// spaces only text 
     #if(LineLock=0)
      #if(Style)
      #declare TxtYloc=TxtYloc-LineSpace;       //up
      #else  #declare TxtYloc=TxtYloc+LineSpace;  //down
      #end
     #end 
   #else
 //size adjusment
     #if(DBx>Trans.x/2*TextScale)
      #declare TextSize=<TextScale,TextScale,1>; //text fits after scale
     #else 
      #declare TextSize= <DBx/Trans.x*2,DBx/Trans.x*2*TextScale,1>;
      #if(TextSize.y>Dy) #declare TextSize= <DBx/Trans.x*2,Dy,1>;
        #if(LineLock) #debug "\n\n Warning Lock on and Line Full\n\n" #end
      #end
    #end
   //#debug concat("  TextSize= <",vstr(3,TextSize,",",3,3),">\n")
   //#debug concat("    Trans= <",vstr(3,Trans,",",3,3),">\n")
   //#debug concat("      TxtYloc =",str(TxtYloc,3,3),"\n")
   #if(TxtYloc)//beyond first line
     #if(LockCnt=0)
      #if(Style)
      #declare TxtYloc=TxtYloc-Trans.y*TextSize.y/2;       //up 
      #else  #declare TxtYloc=TxtYloc+Trans.y*TextSize.y/2;  //down
      #end
     #end
   #end
   #if(DBx>Trans.x/2*TextScale)//text within screen
     //#debug concat("   DBx =",str(DBx,3,3),"\n")
     //#debug concat("   Trans =",str(Trans.x/2*TextScale,3,3),"\n")
    #if(TextJust>0) #declare TxtXloc= DBx-Trans.x/2*TextScale-(TextJust-1);
       //#debug"*"
    #end           
    #if(TextJust<0)#declare TxtXloc= Trans.x/2*TextScale-DBx-(TextJust+1);
    #end
   #end
   //#debug concat("      TxtYloc2 =",str(TxtYloc,3,3),"\n")
// Write Text object
   #if(strlen(String))
    #write(Nfile,"text{ttf \"",Font,"\" ","\"",String,"\" ",TextThick,",")
    #if(vlength(TextAdj)=0)  #write(Nfile,"0\n")
    #else #write(Nfile, TextOff,"\n")
    #end
    #write(Nfile,"    translate <",-Center.x,",",-Center.y,",",TextPlace,">\n")
     #write(Nfile,"    scale ",TextSize,"\n")
     #if((TxtYloc!=0)&(TextJust!=0))
       #write(Nfile,"    translate <",TxtXloc,","TxtYloc,",0>\n")
     #else
      #if(TxtYloc)
       #if(TxtYloc<0)#write(Nfile,"    translate -y*",-TxtYloc,"\n")
       #else #write(Nfile,"    translate y*",TxtYloc,"\n")
       #end
      #else
       #if(TextJust)
        #if(TxtXloc<0)#write(Nfile,"    translate -x*",-TxtXloc,"\n")
        #else #write(Nfile,"    translate x*",TxtXloc,"\n")
        #end
      #end
     #end
    #end
    #write(Nfile,"    }\n")
   #end
   #if(LineLock=0)
    #if(Style)
     #declare TxtYloc=TxtYloc-TextAdj-Trans.y*TextSize.y/2;       //up Center
     #else  #declare TxtYloc=TxtYloc+TextAdj+Trans.y*TextSize.y/2;  //down
    #end
   #else
    #declare LockCnt=LockCnt+1;
    //#debug concat("LineCnt =",str(LockCnt,0,0),"\n")
   #end
   //#debug concat("     TxtYloc3 =",str(TxtYloc,3,3),"\n")
  #end //text space test
 #end //Line change
  #declare LineCnt=LineCnt+1;

#end //defined(Mfile)



#write(Nfile,"}\n")
   #if(Style)
    #declare Text_End=TxtYloc+TextAdj+Trans.y*TextSize.y/2;       //up
    #else  #declare Text_End=TxtYloc-TextAdj-Trans.y*TextSize.y/2;  //down
   #end
//#debug concat("Center.y =",str(Text_End,4,4),"\n")
#write(Nfile,"#declare Text_End=",str(Text_End,4,4)"; \n")
#fclose Nfile
#if(Debug>0) #debug concat("\nText_End= ",str(Text_End,4,4)," (y value)\n")#end
//#debug "\n\n"


/*
text {ttf Font String TextThick, TextAdj
      pigment{White} finish{ambient 1}
      translate <-Center.x,-Center.y,-.1>
      scale TextSize
      //translate y*TxtYloc+x*TxtXloc
     }  
box{-Trans/2,Trans/2
      pigment{Pink} finish{ambient 1}
      //translate <-Center.x,-Center.y,.2>
      scale TextSize
      translate z*.5
      }
sphere{0,.2 pigment{Green}finish{ambient 1 }}
*/
