//----------------------------------------------------------
// Test for uv_mapping & mesh & radiosity & 3.7 beta version
//
// Zoly
//----------------------------------------------------------

//--- This macro creates a vault. The parameters give
//    the size and shape.
#macro Vault(P01,r1,a1,n1,P02,r2,a2,n2,h)   
	#declare dd=0.001;
	#local dl=0.05;
	#local h1=r1*sqrt(2*n1-1);
	#local h2=r2*sqrt(2*n2-1);
	#local x01=P01.x;
	#local x02=P02.x;
	#local z01=P01.z;
	#local z02=P02.z;

	#local fr1=function(y) {
		(y>=h-h1)*(-r1*(n1-1)+sqrt(pow(r1*n1,2)-(y>=h-h1)*pow(y-(h-h1),2)))+(y<h-h1)*r1
	}

	#local fr2=function(y) {
		(y>=h-h2)*(-r2*(n2-1)+sqrt(pow(r2*n2,2)-pow(y-(h-h2),2)))+(y<h-h2)*r2
	}
   
	#local x1=function(y) {x01+fr1(y)*cos(radians(a1))}
	#local x2=function(y) {x02+fr2(y)*cos(radians(a2))}
   #local z1=function(y) {z01-fr1(y)*sin(radians(a1))}
	#local z2=function(y) {z02-fr2(y)*sin(radians(a2))}
   
   //--- Use of U and Uinc, thanks to Kyle from news.povray.org           
   mesh {
		#local i=h;
		#local U=0;
		#while (i>0)
			#local a_i=i;
			#local i=i-dl/sqrt(1+pow((fr1(i)-fr1(i-dd))/dd,2));
			#local Uinc=abs(vlength(<x2(a_i),a_i,z2(a_i)>-<x2(i),i,z2(i)>));
			triangle {
				<x1(a_i),a_i,z1(a_i)> <x2(a_i),a_i,z2(a_i)> <x1(i),i,z1(i)>
				uv_vectors <U,z1(a_i)> <U,z2(a_i)> <U+Uinc,z1(i)>
			}
			triangle {
				<x2(a_i),a_i,z2(a_i)> <x1(i),i,z1(i)> <x2(i),i,z2(i)>
				uv_vectors <U,z2(a_i)> <U+Uinc,z1(i)> <U+Uinc,z2(i)>
			}
			#local U=U+Uinc;
		#end
		texture {
//------------------------------------------------------------
			uv_mapping // <<<=== REMOVING THIS, FIXES THE PROBLEM
//------------------------------------------------------------
			pigment {
				brick 
					pigment {rgb 0.7*<0.9,0.8,0.7>}
					pigment {
						granite
						color_map {
							[0.4 rgb 0.9*<0.62,0.50,0.46>]
							[1.0 rgb 0.6*<0.62,0.50,0.46>]
						}
						scale 0.3
					}
				scale 0.08
				rotate 90*z
			}
			normal {
				granite 0.3
				scale 0.04
			}
			finish {
				ambient 0
				diffuse 0.8
			}
		}
	}	
#end



//=== HERE STARTS THE TEST SCENE

global_settings {
	#if (version < 3.69)
		assumed_gamma 1
	#end
	radiosity {
		always_sample off
		count 1000
		low_error_factor 0.1
	}
}

//--- External light (Sun)
light_source {
	<0,0,-1000>
	rgb 10*<1.8,1.5,1.2>
	rotate <45,160,0>
}

//--- Sky
sphere {
	<0,0,0> 1000
	hollow
	texture {
		pigment {rgb <0.5,0.5,1>}
		finish {
			ambient 1
			diffuse 0
		}
	}
}

//--- Camera
camera {
	location <0,1,-9>
	look_at 4*y
	rotate 30*y
}

//--- Floor
box {
	<-10.3,-0.2,-10.3> <10.3,0,10.3>
	texture {
		pigment {rgb 1}
		finish {ambient 0 diffuse 1}
	}
}

//--- Walls
#local i=0;
#while (i<4)
	difference {
		box {<-10,0,10> <10,10,10.3>}
		cylinder {<0,4,9.9> <0,4,10.4> 1}
		texture {
			pigment {rgb 1}
			finish {ambient 0 diffuse 1}
		}
		rotate i*90*y
	}
	#local i=i+1;
#end

//--- Ceiling
#local i=0;
#while (i<4)
	object {Vault(<0,10,-10>,10,0,1.3,<0,10,0>,10*sqrt(2),45,1,10) rotate i*90*y}
	object {Vault(<0,10,-10>,10,0,1.3,<0,10,0>,10*sqrt(2),45,1,10) scale <-1,1,1> rotate i*90*y}
	#local i=i+1;
#end

//--- Some details to give it a nicer look
#local i=-1;
#while (i<2)
	torus {
		10*sqrt(2) 0.1
		rotate <90,45*i,0>
		translate 10*(1-sqrt(2))*y
		texture {
			pigment {rgb 0.5}
			finish {ambient 0 diffuse 1}
		}
	}
	#local i=i+2;
#end
#local i=0;
#while (i<4)
	union {
		torus {13 0.1 rotate 90*x translate <3,-2.7,10>}
		torus {13 0.1 rotate 90*x translate <-3,-2.7,10>}
		box {<-9,0,9> <-10,1,10>}
		rotate i*90*y
		texture {
			pigment {rgb 0.5}
			finish {ambient 0 diffuse 1}
		}
	}
	#local i=i+1;
#end
