// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//


#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <5, 2, -20.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <5, 2,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}

//==========================================================================================================================================
#declare VOC_ENKHUIZEN3kleur = 
   material  // VOC_ENKHUIZEN3kleur
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               gif   "nl-vocen.gif"
               once
            }
         }      
         finish
         {
            ambient 0
            diffuse 1
         }
      }
   }

#declare FM_VOC3kleurObj = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <0.069233, -1.360350, -0.316084>, <-1.880889, -2.815826, 1.186020>, <1.067012, -1.674983, 0.052098>, 
      <-1.525475, -1.019614, 0.101656>, <0.651240, -0.423269, -0.316084>, <-0.675782, -1.995595, 1.186020>, <1.544113, -1.031597, -0.426703>, 
      <-1.525475, -0.019614, 0.101656>, <0.651240, 0.576731, -0.316084>, <-0.675782, -0.995595, 1.186020>, <1.474827, -0.031597, -0.557311>, 
      <-2.000000, 1.000000, 0.000000>, <0.069233, 1.639650, -0.316084>, <-1.239437, -0.224415, 1.186020>, <0.820011, 1.031323, -0.659777>
    }
  }
  uv_mapping
  translate  <2.0, 2.0, 0.0>
  material {
    VOC_ENKHUIZEN3kleur
  }
  photons {
    collect off
  }
  scale <3.0, 2.0, 2.0>
  //rotate <90.004295, 5.343792, 151.994888>
  //translate  5.0*z
}

object {FM_VOC3kleurObj}