// Persistence Of Vision raytracer version 3.1g file  Megapov 0.7
// File by Patrick Dugan

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
#include "woods.inc"

#version 3.5
global_settings {
   assumed_gamma 2.2
   max_trace_level 25   
   radiosity{recursion_limit 2 brightness 0.9 normal on}

}


light_source {< 25, 50, -50> color White * 1.0
   photons {
     refraction on
     reflection on
   }
} 


camera {
   location <0,0,-2>
   look_at  <0,0,0>
   rotate <0,-30,0>
}         



#declare GMetal3 =
   texture {
      
      pigment{ 
         bozo
         color_map {
            [0.0   color rgb <1.25, 0.91, 0.50>] 
            [0.7   color rgb <1.25, 0.91, 0.50>] 
            [0.9   color rgb <0.75, 0.487, 0.30>]
            [1.0   color rgb <1.25, 0.91, 0.50>]

         }                                                                                                          
         turbulence 5.0
      }                   
      normal {
        bumps -0.03
        scale <0.001, 1, 0.001>
      }
      finish{
         metallic
         reflection 0.3
         brilliance 10.0
         diffuse 0.75
         phong 1.0
      }       
   }

        
box {<-0.5,-0.5,-0.5>,<0.5,0.5,0.5>
   rotate <20,0,0> 
   texture {GMetal3}
   photons { target reflection on }
}


// Table/Desk top...
box {<-4.5,-2,-4.5>,<4.5,-0.7128,4.5>
   texture {T_Wood6 scale 1 rotate y * 27}
   finish {
      crand 0.05
      ambient 0.4
      diffuse 0.6
      reflection 0.2
      brilliance 3.0
   }   
   photons { target reflection on }
}

     
sphere {<0,0,0> , 1300.0 texture {pigment { Gray90 }} hollow}





