// ************************************************************************
// O_HOUSE0.INC                                               26 July 99
// aka  HELPME
// Final version of Our House
// ************************************************************************
// ************************************************************************

#include "colors.inc"
#include "shapes.inc"

// ************************************************************************
//                         DEFINE Constants
// ************************************************************************

#declare None = 0                      // numbers for distances, scaling,
#declare LittleSpan = 5                // translations, and spacing
#declare SmallSpan = 10
#declare LargeSpan = 20

#declare Lights = true                 // lights on
//#declare Lights = false                // lights off

//#declare Furnishings = true            // chairs, tables, etc.
#declare Furnishings = false

// ************************************************************************
//                             DEFINE Textures
// ************************************************************************

#declare Red_Tex =
texture {
   pigment { Red
      quick_color Red }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } }

// *************************************

#declare Green_Tex =
texture {
   pigment { Green
      quick_color Green }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } }

// *************************************

#declare Blue_Tex =
texture {
   pigment { Blue
      quick_color Blue }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } }

// *************************************

#declare Yellow_Tex =
texture {
   pigment { Yellow
      quick_color Yellow }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } }

// *************************************

#declare White_Tex =
texture {
   pigment { White
      quick_color White }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } }

// *************************************

#declare Black_Tex =
texture {
   pigment { Black
      quick_color Black }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } } // end texture

// *************************************

#declare GreenYellow_Tex =
texture {
   pigment { GreenYellow
      quick_color GreenYellow }
   finish {
      ambient 0.0
      diffuse 0.6
      specular 1.00
      roughness 0.00001 } } // end texture

// *************************************

#declare LB_Tex =
texture {
   pigment { LightBlue
      quick_color LightBlue }
   finish {
      ambient 0.2
      diffuse 0.5
      specular 1.00
      roughness 0.00001 } }

// *************************************

#declare Gray25_Tex =
texture {
   pigment { Gray25
      quick_color Gray25 }
   finish {
      ambient 0.5
      diffuse 0.5
      specular 0.5
      roughness 0.001 } } // end texture

// *************************************

#declare Gray50_Tex =
texture {
   pigment { Gray50
      quick_color Gray50 }
   finish {
      ambient 0.0
      diffuse 0.0
      specular 0.5
      roughness 0.00001 } }

// *************************************

#declare Gray75_Tex =
texture {
   pigment { Gray75
      quick_color Gray75 }
   finish {
      ambient 0.0
      diffuse 0.0
      specular 0.5
      roughness 0.00001 } } // end texture

// *************************************

#declare LtGray_Tex =
texture {
   pigment { VLightGray
      quick_color VLightGray }
   finish {
      ambient 0.4
      diffuse 0.4
      specular 0.5
      roughness 0.001 } } // end texture

// *************************************

#declare Gray_Tex =
texture {
   pigment { Gray
      quick_color Gray }
   finish {
      ambient 0.4
      diffuse 0.4
      specular 0.5
      roughness 0.001 } } // end texture

// ************************************************************************

#declare T_Grnt0 =                     // Gray Tan with Rose
texture {
   pigment
      { granite
        turbulence 0.4
        color_map {
           [ 0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.000>
                            color rgbf <0.769, 0.686, 0.592, 0.000> ]
           [ 0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.000>
                            color rgbf <0.843, 0.753, 0.718, 0.000> ]
           [ 0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.000>
                            color rgbf <0.780, 0.667, 0.561, 0.000> ]
           [ 0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.000>
                            color rgbf <0.741, 0.659, 0.576, 0.000> ]
           [ 0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.000>
                            color rgbf <0.729, 0.502, 0.451, 0.000> ]
                  } //end map
        quick_color Yellow
      } // end pigment
        } // end texture G_0

// *************************************

#declare T_Grnt0a =                    // Translucent T_Grnt0
texture {
   pigment {
      granite
      turbulence 0.6
      color_map {
         [ 0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>
                          color rgbf <0.769, 0.686, 0.592, 0.792> ]
         [ 0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>
                          color rgbf <0.843, 0.753, 0.718, 0.396> ]
         [ 0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>
                          color rgbf <0.780, 0.667, 0.561, 0.976> ]
         [ 0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>
                          color rgbf <0.741, 0.659, 0.576, 0.820> ]
         [ 0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                          color rgbf <0.729, 0.502, 0.451, 0.306> ]
                } //end map
           } //end pigment
        } //end texture

// *************************************

#declare T_Grnt7 =                     // Dark Orchid Olive & Dark Putty
texture {
   pigment {
      granite
      turbulence 0.5
      color_map {
         [ 0.000, 0.153   color rgbf <0.439, 0.310, 0.282, 0.000>
                          color rgbf <0.463, 0.369, 0.259, 0.000> ]
         [ 0.153, 0.398   color rgbf <0.463, 0.369, 0.259, 0.000>
                          color rgbf <0.541, 0.369, 0.298, 0.000> ]
         [ 0.398, 0.559   color rgbf <0.541, 0.369, 0.298, 0.000>
                          color rgbf <0.573, 0.424, 0.286, 0.000> ]
         [ 0.559, 0.729   color rgbf <0.573, 0.424, 0.286, 0.000>
                          color rgbf <0.494, 0.396, 0.306, 0.000> ]
         [ 0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.000>
                          color rgbf <0.439, 0.310, 0.282, 0.000> ]
                } // end  map
      quick_color Red
           } // end pigment
        } // end texture


// *************************************

#declare T_Grnt7a =                    // Translucent T_Grnt7
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.439, 0.310, 0.282, 0.631>
                    color rgbf <0.463, 0.369, 0.259, 0.847>]
    [0.119, 0.322   color rgbf <0.463, 0.369, 0.259, 0.847>
                    color rgbf <0.541, 0.369, 0.298, 0.549>]
    [0.322, 0.449   color rgbf <0.541, 0.369, 0.298, 0.549>
                    color rgbf <0.573, 0.424, 0.286, 0.965>]
    [0.449, 0.729   color rgbf <0.573, 0.424, 0.286, 0.965>
                    color rgbf <0.494, 0.396, 0.306, 0.741>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.741>
                    color rgbf <0.439, 0.310, 0.282, 0.631>]
   }//end map
 } // end pig
 } // end tex 7a

// ************************************************************************

// Light Greenish Tan Marble with Agate style veining

#declare T_Stone2 =
   texture { T_Grnt0  scale <2, 3, 2>  rotate <0, 0, 40> }
   texture { T_Grnt7a scale <1.3, 2, 1.3> rotate <0, 0, -30> rotate <40, 0, 0>
             finish { phong 1.0  phong_size 90  ambient 0.2 } }

// ************************************************************************

// Deep Rose & Green Marble with large White Swirls

#declare T_Stone1 =
   texture { T_Grnt7  scale <3, 4, 3> rotate <0, 0, 40> }
   texture { T_Grnt0a scale <2, 3, 2> rotate <0, 0,-30>
             finish { phong 0.25  phong_size 80 } }

// ************************************************************************
//                           GLASS TEXTURES
// ************************************************************************

#declare Glass_Finish=
finish {
    specular 0.5
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
    refraction 1
    ior 1.5 }

#declare Glass =
texture {
    pigment { color rgbf < 1.0, 1.0, 1.0, 1.0 > }
    finish  { Glass_Finish } }

//*************************************************************************
//                         WOOD MAPS & PIGMENTS
//*************************************************************************

#declare M_Wood2A =
color_map {
    [0.0, 0.1 color rgb <0.35, 0.16, 0.12 >* 0.5
              color rgb <0.35, 0.16, 0.12>* 0.5]
    [0.1, 0.9 color rgb <0.35, 0.20, 0.16>* 0.5
              color rgb <0.46, 0.26, 0.18>* 0.5]
    [0.9, 1.0 color rgb <0.46, 0.26, 0.18>* 0.5
              color rgb <0.35, 0.16, 0.12>* 0.5] }
#declare M_Wood2B =
color_map {
    [0.0, 0.1 color rgbf <0.50, 0.30, 0.20, 0.100>
              color rgbf <0.50, 0.30, 0.20, 0.500>]
    [0.1, 0.9 color rgbf <0.50, 0.30, 0.20, 0.650>
              color rgbf <0.50, 0.25, 0.15, 0.975>]
    [0.9, 1.0 color rgbf <0.50, 0.25, 0.15, 0.975>
              color rgbf <0.50, 0.30, 0.20, 0.000>] }

// **************************************

#declare M_Wood5A =
color_map {
    [0.0, 0.3 color rgb <0.50, 0.35, 0.10>
              color rgb <0.50, 0.35, 0.10>]
    [0.3, 0.6 color rgb <0.50, 0.35, 0.10>
              color rgb <0.60, 0.45, 0.10>]
    [0.6, 1.0 color rgb <0.60, 0.45, 0.10>
              color rgb <0.50, 0.35, 0.10>] }
#declare M_Wood5B =
color_map {
    [0.0, 0.1 color rgbf <0.40, 0.35, 0.10, 1.00>
              color rgbf <0.40, 0.00, 0.10, 0.60>]
    [0.1, 0.9 color rgbf <0.40, 0.00, 0.10, 0.75>
              color rgbf <0.35, 0.40, 0.15, 0.90>]
    [0.9, 1.0 color rgbf <0.35, 0.40, 0.15, 0.90>
              color rgbf <0.40, 0.35, 0.10, 1.00>] }

// **************************************

#declare P_WoodGrain2A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.15, .15, 1> }
#declare P_WoodGrain2B =
pigment {
    wood
    turbulence <0.1, 0.35, 0.1>
    octaves 5
    lambda 3.25
    scale <0.25, .25, 1>
    rotate <5, 10, 5>
    translate -x*2 }

// **************************************

#declare P_WoodGrain5A =
pigment {
    wood
    turbulence <0.04, 0.04, 0.1>
    octaves 4
    omega 1.25
    scale <0.15, .15, 1> }
#declare P_WoodGrain5B =
pigment {
    wood
    turbulence <0.025, 0.025, 0.1>
    octaves 4
    omega 1.3
    scale <0.30, .20, 1>
    translate <0.1, 0.1, 0.20> }

// ************************************************************************
//                            WOOD TEXTURES
// ************************************************************************

#declare T_Wood2   =                   // Dark brown
    texture { pigment { P_WoodGrain2A
                        color_map { M_Wood2A }
                        quick_color Firebrick } }
    texture { pigment { P_WoodGrain2B
                        color_map { M_Wood2B }
                        quick_color Firebrick } }

// ************************************************************************

#declare T_Wood2b =
texture { T_Wood2
          scale < .55, 1.1, 1 >
          finish {
               specular 0.1
               roughness 0.025
                }//end finish
        } // end texture Wood 2b

// ************************************************************************

#declare T_Wood5 =                     // Dark yellow with reddish overgrain
    texture { pigment { P_WoodGrain5A
                        color_map { M_Wood5A }
                        quick_color Blue } }
    texture { pigment { P_WoodGrain5B
                        color_map { M_Wood5B }
                        quick_color Blue } }

// ************************************************************************

#declare DMFWood2 =                    //Our House door
pigment {
    wood
    turbulence 0.03
    octaves 4
    scale < 0.05, 0.05, 1 >
    color_map {
        [ 0.0, 0.1 color rgb < 0.52, 0.37, 0.26 >
                   color rgb < 0.52, 0.37, 0.26 > ]
        [ 0.1, 0.9 color rgb < 0.52, 0.37, 0.26 >
                   color rgb < 0.42, 0.26, 0.15 > ]
        [ 0.9, 1.0 color rgb < 0.42, 0.26, 0.15 >
                   color rgb < 0.42, 0.26, 0.15 > ]
              }//end map
    quick_color Red }

// ************************************************************************

#declare EMBWood1 =
texture {                              // Bottom wood-grain layer
    pigment {
        wood
        turbulence 0.5       // 0.05
        color_map {
            [0.00 0.34  color rgb <0.58, 0.45, 0.23>
                        color rgb <0.65, 0.45, 0.25>]
            [0.34 0.40  color rgb <0.65, 0.45, 0.25>
                        color rgb <0.33, 0.23, 0.13>]
            [0.40 0.47  color rgb <0.33, 0.23, 0.13>
                        color rgb <0.60, 0.40, 0.20>]
            [0.47 1.00  color rgb <0.60, 0.40, 0.20>
                        color rgb <0.25, 0.15, 0.05>]
                  }//end map
        quick_color Yellow
            }//end pigment
    finish {
        crand 0.02
        ambient 0.32
        diffuse 0.63
        phong 0.2
        phong_size 10
           }//end finish
    normal { bumps 0.05 }
}
texture {                              // top layer, adds small dark spots
    pigment {
        bozo
        color_map {
            [ 0.0 0.8  color rgbf < 1.00, 1.00, 1.00, 1.00 >
                       color rgbf < 1.00, 0.90, 0.80, 0.80 > ]
            [ 0.8 1.0  color rgbf < 1.00, 0.90, 0.80, 0.80 >
                       color rgbf < 0.30, 0.20, 0.10, 0.40 > ]
                  }//end map
    scale 0.25
    quick_color Yellow
            }//end pigment
        } // end texture 2nd layer

// ************************************************************************

//   DEFINE Seams Texture: to simulate the seams between wooden boards

#declare Seams_X =
texture {
   pigment {
      gradient x
      turbulence 0.0
      frequency 2
      color_map {
         [ 0.0 0.1  color Black  color Black ]
         [ 0.1 1.0  color Clear  color Clear ]
                } //end map
           } //end pigmnet
   scale 0.1                          // scaled to make 1 board per unit
        } // end Seams X-axis

// ***********************************************************************

//   DEFINE RosewoodB  to fit 1x 0.5y 1z box scaled to 30x 1y 20z

#declare RosewoodB =
texture {
   pigment {
      bozo
      turbulence  0.4
      color_map {
      [0.000, 0.256   color rgbf <0.204, 0.110, 0.078, 0.000>
                      color rgbf <0.231, 0.125, 0.080, 0.000>]
      [0.256, 0.393   color rgbf <0.231, 0.125, 0.080, 0.000>
                      color rgbf <0.244, 0.135, 0.089, 0.000>]
      [0.393, 0.581   color rgbf <0.244, 0.135, 0.089, 0.000>
                      color rgbf <0.245, 0.135, 0.075, 0.000>]
      [0.581, 0.826   color rgbf <0.245, 0.135, 0.075, 0.000>
                      color rgbf <0.260, 0.134, 0.102, 0.000>]
      [0.826, 0.983   color rgbf <0.260, 0.134, 0.102, 0.000>
                      color rgbf <0.231, 0.126, 0.186, 0.000>]
      [0.983, 1.000   color rgbf <0.231, 0.126, 0.186, 0.000>
                      color rgbf <0.204, 0.110, 0.078, 0.000>] } //end map
      scale < 0.15, 0.05, 0.5 >
      rotate z*3
      quick_color Yellow
           } //end pigment
   finish {
      ambient 0.2
      diffuse 0.22
      reflection 0.08 } //end finish
        } // end texture layer 1

// Rosewood layer 2
texture {
   pigment {
      wood
      turbulence 0.4
      color_map {
         [ 0.000, 0.139  color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.139, 0.148  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.148, 0.287  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ]
         [ 0.287, 0.443  color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ]
         [ 0.443, 0.626  color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.626, 0.635  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.000, 0.000, 0.000, 0.004 > ]
         [ 0.635, 0.843  color rgbf < 0.000, 0.000, 0.000, 0.004 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ]
         [ 0.843, 1      color rgbf < 0.545, 0.349, 0.247, 1.000 >
                         color rgbf < 0.545, 0.349, 0.247, 1.000 > ] }
      scale < 0.15, 0.05, 1 >
      rotate z*3
      quick_color Yellow
           } //end pigment
   finish {
      ambient 0.2
      diffuse 0.2
      reflection 0.08 } //end finish
        } // end texture layer 2

// ************************************************************************

#declare Spex=                         // By Dan Farmer
texture {
    pigment {
        granite
        color_map {
            [ 0.0 0.7  color Black   color Black  ]
            [ 0.7 1.0  color Orange  color Orange ]
                  }//end map
        quick_color Blue
            }//end pigment
    finish {
        phong 0.35
        phong_size 15
        ambient 0.3
        diffuse 0.3
        reflection 0.5
            }//end finish
        } // end texture

// ************************************************************************

#declare Grnt20 =                      // White Marble, gray feather veins
texture {
   pigment {
      granite
      turbulence 0.5
      color_map {
         [ 0.0  0.3  color Black  color White ]
         [ 0.3  0.4  color White  color White ]
         [ 0.4  0.7  color White  color White ]
         [ 0.7  1.0  color White  color Gray50 ]
                }  // end color map
   quick_color Yellow
           }//end pigment
   finish {
      ambient 0.3
      diffuse 0.3
      reflection 0.25
          }//end finish
        }  // end texture

// ************************************************************************

//AQUA09 version

#declare Bright_AquaBlue4 =
pigment {
   bozo
   turbulence  0.75
   octaves 5
   lambda 9
   color_map {
      [ 0.0  0.2  color rgbt < 0.4392, 0.7008, 0.7606, 0.0 >
                  color rgbt < 0.4,    0.6,    0.8,    0.0 > ]
      [ 0.2  0.5  color rgbt < 0.4     0.6     0.8,    0.0 >
                  color rgbt < 0.5,    0.5,    0.9,    0.0 > ]
      [ 0.5  0.7  color rgbt < 0.5,    0.5,    1.0,    0.0 >
                  color rgbt < 1.0,    1.0,    1.0,    0.0 > ]
      [ 0.7  1.0  color rgbt < 1.0,    1.0,    1.0,    0.0 >
                  color rgbt < 0.5,    0.5,    0.5,    0.0 > ] } //end map
        } // end pigment

// ************************************************************************

#declare Grass =
texture {
   pigment {
      spotted
      color_map {
         [ 0.00  0.35  color Green        color PaleGreen   ]
         [ 0.35  0.60  color PaleGreen    color Green       ]
         [ 0.60  0.80  color Green        color SpringGreen ]
         [ 0.80  1.00  color SpringGreen  color LimeGreen   ]
                } // end color map
   turbulence 7.5
   quick_color Green
           } // end pigment
   scale < 0.75 0.4 0.75 >
   normal { bumps 0.4 scale 0.2 }
        } // end Grass texture

// ************************************************************************

// DEFINE A Variant of Jade for Tree Foliage   *****

#declare TreeJade =
texture {
   pigment {
      marble
      color_map {
         [ 0.0  0.2   color red 0.1  green 0.8  blue 0.1
                      color red 0.0  green 0.4  blue 0.0 ]
         [ 0.2  0.5   color red 0.1  green 0.7  blue 0.1
                      color red 0.0  green 0.3  blue 0.0 ]
         [ 0.5  0.85  color red 0.1  green 0.6  blue 0.1
                      color red 0.0  green 0.3  blue 0.0 ]
         [ 0.85 1.0   color red 0.1  green 0.6  blue 0.1  filter 0.6
                      color red 0.0  green 0.2  blue 0.0  filter 0.6 ]
                } // end color map
      turbulence 19
      quick_color Green
           }//end pigment
   finish {
      ambient 0.01
      reflection 0.0
      diffuse    0.1
      brilliance 0.0002
          }//end finish
   scale < 3.5 3.0 2.5 >
        } // end texture Tree Jade

// ************************************************************************

#declare Polished_Brass =
texture {
    pigment { color rgb <0.578, 0.422, 0.195>
              quick_color Red }
    finish {
        metallic
        ambient 0.5
        diffuse 0.8
        brilliance 6.0
        reflection 0.4
        phong 0.8
        phong_size 120 } }

// ************************************************************************

#declare Starfield2A =
    pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.285 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.285  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.485 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.485  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.695 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.695  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.895 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.895  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ] }
    turbulence 1
    sine_wave
    scale .5 } // end pigment

// ************************************************************************

//  DEFINE Brendan's Red Brick

#declare B_Red_Brick =
texture {
   pigment { brick  Gray50  Firebrick  scale 0.25 } //end pigment
   finish  { ambient 0.1   diffuse 0.1
             specular 0.2  roughness 0.002 }
        } //end texture

// ************************************************************************
//                         DEFINE Basic Elements
// ************************************************************************

#declare Semi_Circle =
object {
   Disk_Z  scale 1  clipped_by { plane { -y, 0 } }
       }  // end Semi Circle

// ************************************************************************

#declare GrayRod =
object {
   Cylinder_X
   clipped_by {
      plane {  x, 1 }
      plane { -x, 1 }
              }//end clip
   texture { Gray75_Tex }
   scale < 1.0, 0.2, 0.2 > }

// ************************************************************************

#declare XCyl_1 =
object { Disk_X  scale < 1.0 1.0 1.0 > }  // end X Cylinder 1

#declare YCyl_1 =
object { Disk_Y  scale < 1.0 1.0 1.0 > }  // end Y Cylinder 1

#declare ZCyl_1 =
object { Disk_Z  scale < 1.0 1.0 1.0 > }  // end Z Cylinder 1

#declare YCyl_2 =
object { Disk_Y  scale < 0.8 1.1 0.8 > }  // end Y Cylinder 2

#declare ZCyl_2 =
object { Disk_Z  scale < 0.7 0.7 1.1 > }  // end Z Cylinder 2

#declare ZCyl_3 =
object { Disk_Z  scale < 0.95 0.95 1.1 > }  // end Z Cylinder 3

// ************************************************************************

#declare Arch_Z =
difference {
   object { ZCyl_1 }
   object { ZCyl_2 }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z

// ************************************************************************

#declare Arch_Z2 =
difference {
   object { ZCyl_1 }
   object { ZCyl_3 }
   clipped_by { plane { -y, 0 } }
           } // end Arch_Z

// ************************************************************************

//   DEFINE  a clipped plane as a test floor

#declare Clip_Floor =
plane { y, 0
   texture { GreenYellow_Tex
             scale 4 } //end texture
   finish {
      ambient 0.2
      diffuse 0.8 } //end finish
   hollow
   clipped_by { UnitBox scale < 1000, 1, 1000 > }
      } // end Clipped Floor

// ************************************************************************

#declare Grass_Floor =
plane { y, 0
   texture { Grass
             scale 4 } //end texture
   finish {
      ambient 0.2
      diffuse 0.9 } //end finish
   hollow
      } // end Grass Floor

// ************************************************************************

#declare Test_Floor =
plane { y, 0
   texture { GreenYellow_Tex
             scale 4
           } //end texture
   finish {
      ambient 0.2
      diffuse 0.8
          } //end finish
   hollow
      } // end Test Floor

// ************************************************************************

//  Define a basic cylinder

#declare Post01 =
object { Disk_Y  scale 2.5 } // end Post 01

#declare Post02 =
object { Disk_Y  scale 1 } // end Post 02

#declare Post03 =
object { Disk_X  scale 1 } // end Post 03

// ************************************************************************

//  Define three square axis posts: scaled to display a 1-unit cube

#declare Post_NX =
object { UnitBox  scale 0.5 } // end Post X axis

#declare Post_NY =
object { UnitBox  scale 0.5 } // end Post Y axis

#declare Post_NZ =
object { UnitBox  scale 0.5 } // end Post Z axis

// ************************************************************************

//  Define three square axis posts: 2 units long in one axis

#declare Post_X =
object { UnitBox  scale < 2, 0.5, 0.5 > } // end Post X axis

#declare Post_Y =
object { UnitBox  scale < 0.5, 2, 0.5 > } // end Post Y axis

#declare Post_Z =
object { UnitBox  scale < 0.5, 0.5, 2 > } // end Post Z axis

// ************************************************************************

#declare XRod =                        // Define an x-axis rod
object {
   Cylinder_X
   clipped_by {
      plane {  x, 5 }
      plane { -x, 5 } }
   scale < 1.0, 0.25, 0.25 > }

#declare ZRod =                        // Define a z-axis rod
object {
   Cylinder_Z
   clipped_by {
      plane {  z, 5 }
      plane { -z, 5 } }
   scale < 0.25, 0.25, 1.0 > }

#declare YRod =                        // Define a y-axis rod
object {
   Cylinder_Y
   clipped_by {
      plane {  y, 5 }
      plane { -y, 5 } }
   scale < 0.25, 1.0, 0.25 > }

// ************************************************************************

//   DEFINE  a 3-axis grid marker

#declare Mark01 =
union {
   object { XRod texture { Red_Tex } }
   object { YRod  texture { Green_Tex } }
   object { ZRod  texture { Yellow_Tex } }
      } // end Marker 1

// ************************************************************************
//                         Our House Exterior Lights
// ************************************************************************

//   DEFINE   an object as a light source

#declare Globe_Light =
object {
   sphere { 0, 1
      texture { Glass }
      pigment { color rgbt <1, 1, 1, 1> }
      halo {
         emitting
         spherical_mapping
         linear
         dust
         dust_type 1
         color_map {
            [ 0.0 color rgbt <1.0, 1.0, 1.0,  1.0> ]
            [ 0.5 color rgbt <1.0, 1.0, 1.0, -1.0> ]
            [ 1.0 color rgbt <1.0, 1.0, 1.0,  1.0> ]
                   }//end map
         frequency 2
         samples 50
         aa_level 3
         aa_threshold 0.2
         jitter 0.1
         scale 1.0
           }// end halo
      hollow
          } // end sphere halo
       } // end obj Globe Light

// ************************************************************************

//   DEFINE   A Wall Lamp   light source on

#declare WallLamp_A =
union {
   object {
      UnitBox                          // lamp base
      pigment { DMFWood2
                rotate y*84
                turbulence 0.5 }
      scale < 1.5 1.5 0.5 >
      translate < -1, 0, 0.75 >        //adj back to 0 0 0
          } //end object Lamp Base
   light_source {                      // sphere as light bulb
      < 0, 0, 0 >
      color White
      looks_like { Globe_Light }
      translate x*-1
      fade_distance 20
      fade_power 2
      atmospheric_attenuation on
                } // end light source
      } // end union Wall Lamp A

// ************************************************************************

//   DEFINE   A Wall Lamp   light source off

#declare WallLamp_B =
union {
   object {
      UnitBox                          // lamp base
      pigment { DMFWood2
                rotate y*84
                turbulence 0.5 }
      scale < 1.5, 1.5, 0.5 >
      translate < -1, 0, 0.75 >        //adj back to 0 0 0
          } //end object Lamp Base
   object { Sphere
            texture{ Glass }
            translate x*-1 }
      } // end union Wall Lamp B

// ************************************************************************

//   DEFINE   A Wall Lamp   cylinder light source on

#declare WallLamp_C =
union {
   object {
      UnitBox                          // lamp base
      pigment { DMFWood2
                rotate y*84
                turbulence 0.5 }
      scale < 1.5 1.5 0.5 >
      translate < -1, 0, 0.75 >        //adj back to 0 0 0
      hollow
          } //end object Lamp Base
   light_source {                      // sphere as light bulb
      < 0, 0, 0 >
      color White
      spotlight
      looks_like { Globe_Light }
      translate x*-1
      radius 20
      falloff 10
      tightness 5
      point_at < 0, -20, 0 >
      fade_distance 30
      fade_power 2
      atmospheric_attenuation on
                } // end light source
    hollow
      } // end union Wall Lamp C

// ************************************************************************
// ************************************************************************
//                       WINDOW PANELS: stained & clear
// ************************************************************************

//   DEFINE   A beveled-edged square box: glass version

#declare Win_Box_One =
intersection {
   object { Cube                       //body of roof
            scale < 1.0, 0.1, 1.0 > }
                                       //beveled edges
   plane { < 0 1 0 > 0.5                    // top front x edge
           scale < 1.0 1.0 0.25 >
           rotate < -45 0 0 >
           translate < 0 0.35 0 >
         } //end plane a
   plane { < 0 1 0 > 0.5                    // top rear x edge
           scale < 1.0 1.0 0.25 >
           rotate < 45 0 0 >
           translate < 0 0.35 0 >
         } //end plane b
   plane { < 0 1 0 > 0.5                    // top left z edge
           scale < 1.0 1.0 0.25 >
           rotate < -45 90 0 >
           translate < 0 0.35 0 >
         } //end plane c
   plane { < 0 1 0 > 0.5                    // top right z edge
           scale < 1.0 1.0 0.25 >
           rotate < 45 90 0 >
           translate < 0 0.35 0 >
         } //end plane d
             } // end obj Window Box One

// ************************************************************************

#declare S_Window_4 =                  // all clear glass rect. pattern
union {
object { Win_Box_One
         texture { Glass }
         scale < 3, 1, 3 >  rotate x*90  rotate z*45 }
object { GrayRod scale < 2, 1, 1 > rotate z*45  translate < -3.8,  1.3, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*-45 translate < -3.8, -1.3, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*-45 translate <  3.8,  1.3, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*45  translate <  3.8, -1.3, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*-45 translate <  1.3,  3.8, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*45  translate < -1.3,  3.8, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*-45 translate < -1.3, -3.8, 0 > }
object { GrayRod scale < 2, 1, 1 > rotate z*45  translate <  1.3, -3.8, 0 > }
      } // end Stained Glass Window 4

// ************************************************************************

//   DEFINE  Stained Glass Window Unit 4: all clear panes, rect. frames

#declare Stained_Four =
union {
   object { S_Window_4  rotate z*45  translate y*4.5  translate x*-3.5 }
   object { S_Window_4  rotate z*45  translate y*4.5  translate x*3.5  }
   object { S_Window_4  rotate z*45  translate y*12   translate x*-3.5 }
   object { S_Window_4  rotate z*45  translate y*12   translate x*3.5  }
   object { Post_Y   texture { T_Wood2b }
                     scale < 1.1, 3.75, 1.1 >
                     translate < -7.5, 8.2, 0 > }
   object { Post_Y   texture { T_Wood2b }
                     scale < 1.1, 3.75, 1.1 >
                     translate <  7.5, 8.2, 0 > }
   object { Post_X   texture { T_Wood2b }
                     scale < 4, 1.1, 1.1 >
                     translate <  0, 1, 0 > }
   object { Post_X   texture { T_Wood2b }
                     scale < 4, 1.1, 1.1 >
                     translate <  0, 15.4, 0 > }
      } // end Stained Four

// ************************************************************************

//   DEFINE   A window panel scaled for Frame_A: Stained Glass 4

#declare Panel_SG4 =
union {
   object { Stained_Four scale < 0.65, 0.65, 1 > translate < -4.6, -0.5, 0 > }
   object { Stained_Four scale < 0.65, 0.65, 1 > translate < -4.6,  -10, 0 > }
   object { Stained_Four scale < 0.65, 0.65, 1 > translate <  4.6, -0.5, 0 > }
   object { Stained_Four scale < 0.65, 0.65, 1 > translate <  4.6,  -10, 0 > }
      } // end Panel Stained Glass 4

// ************************************************************************
// ************************************************************************
//                              Floors & Roofs
// ************************************************************************

//   DEFINE   basic floor: 2x 0.5y 2z

#declare Floor_One =
object { UnitBox  scale < 1, 0.25, 1 > }

// ************************************************************************

//  DEFINE  a tiled Floor

#declare Tiled_Floor_1 =
object {
   UnitBox
   scale < 5, 0.5, 5 >
   translate < 0, 0.02, 0 >
   texture {
      tiles {
        texture { Spex }
      tile2
        texture { Grnt20 }
            }  //end of tiles
           }  //end of texture
       }  //end of Tiled Floor 1

// ***********************************************************************

// declare the set of tiles as a union built by a loop: WHILTILE.POV

#declare Max  = 16                     // # of tiles across and down
#declare XMax = Max/2
#declare ZMax = Max/2
#declare ZCount = -ZMax

#declare Tiled_Floor_2 =
union {
    #while (ZCount <= ZMax)
      #declare XCount = -XMax
      #while (XCount <= XMax)
      object {
        UnitBox scale 0.5
        #if(XCount=0 & ZCount=0)
        // Center tile
          texture { Red_Tex }
        #else
          #if (abs(XCount) = abs(ZCount))
            // An "X" pattern of tiles, diagonal through origin
            texture { Grnt20 }
          #else
            #if (abs(XCount)*abs(ZCount) < XMax)
              // A "fat plus" pattern, centered on origin
              texture { Spex }
            #else
              #if (abs(mod(XCount,3)) = abs(mod(ZCount,2)))
                // An alternating sprinkle of remaining tiles
                texture { Spex }
              #else
                texture { Spex }
              #end
            #end
          #end
        #end
        translate <XCount, 0, ZCount>
      }
      #declare XCount = XCount+1
      #end  // Inner X loop
    #declare ZCount = ZCount+1
    #end  // Outer Z loop
      } // end union

// ************************************************************************

//   DEFINE  a flat slab roof: 2x 1y 1z

#declare Roof_One =
object { Cube  scale < 1, 0.5, 1 > }

// ************************************************************************

//   DEFINE   A beveled-edged square box: original version

#declare Roof_Two =
intersection {
   object { Cube                       //body of roof
            scale < 1, 1, 1 > }
                                       //beveled edges
   plane { < 0, 1, 0 > 0.5                  // front x edge
           scale < 1, 1, 0.25 >
           rotate < -75, 0, 0 >
           translate < 0, 0.15, 0 >
         } //end plane a
   plane { < 0, 1, 0 > 0.5                  // rear x edge
           scale < 1, 1, 0.25 >
           rotate < 75, 0, 0 >
           translate < 0, 0.15, 0 >
         } //end plane b
   plane { < 0, 1, 0 > 0.5                  // left z edge
           scale < 1, 1, 0.25 >
           rotate < -75, 90, 0 >
           translate < 0, 0.15, 0 >
         } //end plane c
   plane { < 0, 1, 0 > 0.5                  // right z edge
           scale < 1, 1, 0.25 >
           rotate < 75, 90, 0 >
           translate < 0, 0.15, 0 >
         } //end plane d
             } // end intersection Roof Two

// ************************************************************************
//                             Atrium Front Yard
// ************************************************************************

//   DEFINE   a large arch/roof/barrel dome:

#declare BigArch_1 =
object { Arch_Z2
         texture { T_Stone2
         scale < 1.5, .5, 1.5 >
                   finish { ambient 0.5
                            diffuse 0.5
                            reflection 0.1
                          }//end finish
                 } // end texture
         scale < 20, 18, 7.5 >
       } // end Big Arch 1

// ***********************************************************************

#declare BigArch_Posts =
union {
   object { Post02  scale < 0.7, 6, 0.7 >  translate < -19.5, -4, -4 > }
   object { Post02  scale < 0.7, 6, 0.7 >  translate < -19.5, -4,  4 > }
   object { Post02  scale < 0.7, 6, 0.7 >  translate <  19.5, -4, -4 > }
   object { Post02  scale < 0.7, 6, 0.7 >  translate <  19.5, -4,  4 > }
   object { Post_NZ scale < 2, 2, 16 >  translate <  19.5,   2,  0 > }
   object { Post_NZ scale < 2, 2, 16 >  translate < -19.5,   2,  0 > }
   object { Post_NZ scale < 2, 2, 16 >  translate <  19.5,  -9,  0 > }
   object { Post_NZ scale < 2, 2, 16 >  translate < -19.5,  -9,  0 > }
   texture { T_Stone1
             finish { ambient 0.5
                      diffuse 0.6
                      reflection 0.1 } //end finish
           } // end texture
      } // end Posts for Front Arch

// ************************************************************************

//   DEFINE an arch way for Atrium

#declare Front_Arch =
union {
   object { BigArch_Posts  translate < 0, 0, 0 > }
   object { BigArch_1      translate < 0, 1, 0 > }
      } // end Front Arch

// ************************************************************************

//   DEFINE   planter boxes

#declare Front_Boxes =
union {
   object {                            // east box
      difference {
         object { UnitBox
                  scale < 3, 2, 5 >
                } // end Box outside
         object { UnitBox
                  scale < 2.5, 1.5, 4.5 >
                  translate y*1.6
                } // end Box inside
         texture { TreeJade }
                  } // end difference
      translate < 12.5, -8.75, 0 >
         } // end object whole box
   object {                            // west box
      difference {
         object { UnitBox
                  scale < 3, 2, 5 >
                } // end Box outside
         object { UnitBox
                  scale < 2.5, 1.5, 4.5 >
                  translate y*1.6
                } // end Box inside
         texture { TreeJade }
                  } // end difference
      translate < -12.5, -8.75, 0 >
         } // end object whole box
      } // end union Front Boxes

// ************************************************************************
// ************************************************************************

//   DEFINE  front yard lanscaping CURRENTLY--18 NOV 98--INCOMPLETE

#declare Front_Yard =
union {
object { Tiled_Floor_2
         scale < 1.1, 1, 1.1 >
         translate <   0, 0, 10 > }    // patio: north cntr section
object { Tiled_Floor_1
         scale < 2, 1, 2 >
         translate <  20, 0, 10 > }    //      : north east section
object { Tiled_Floor_1
         scale < 2, 1, 2 >
         translate < -20, 0, 10 > }    //      : north west section
object { Tiled_Floor_2
         scale < 1.1, 1, 1.1 >
         translate <  20, 0, -10 > }   //      : middle east section
object { Tiled_Floor_2
         scale < 1.1, 1, 1.1 >
         translate < -20, 0, -10 > }   //      : middle west section
object { Tiled_Floor_2
         scale < 1.1, 1, 1.1 >
         translate <   0, 0, -30 > }   //      : south cntr section
object { Tiled_Floor_1
         scale < 2, 1, 2 >
         translate <  20, 0, -30 > }   //      : south east section
object { Tiled_Floor_1
         scale < 2, 1, 2 >
         translate < -20, 0, -30 > }   //      : south west section
      } // end union Front Yard

// ************************************************************************
// ************************************************************************
//                       Balconies, Stairs, Railings
// ************************************************************************

//   DEFINE  A step

#declare Step=
   object { UnitBox
            scale < 3, 0.5, 0.5  >
          } //end obj Step

// ************************************************************************

#declare Stairway_A =
union {
   object { Step                            //bottom step
            translate < 0,  1.00,  0.00 > }
   object { Step
            translate < 0,  1.75,  0.75 > }
   object { Step
            translate < 0,  2.50,  1.50 > }
   object { Step
            translate < 0,  3.25,  2.25 > }
   object { Step
            translate < 0,  4.00,  3.00 > }
   object { Step
            translate < 0,  4.75,  3.75 > }
   object { Step
            translate < 0,  5.50,  4.50 > }
   object { Step                            // middle
            translate < 0,  6.25,  5.25 > }
   object { Step
            translate < 0,  7.00,  6.00 > }
   object { Step
            translate < 0,  7.75,  6.75 > }
   object { Step
            translate < 0,  8.50,  7.50 > }
   object { Step
            translate < 0,  9.25,  8.25 > }
   object { Step
            translate < 0, 10.00,  9.00 > }
   object { Step
            translate < 0, 10.75,  9.75 > }
   object { Step                            // top step
            translate < 0, 11.50, 10.50 > }
   texture { Gray25_Tex }
          } // end composite Stairs A

// ************************************************************************
// ************************************************************************

//  DEFINE  basic Railing Unit:  e/w  3 units wide

#declare Railing_Unit_A =
union {
   object { YCyl_1
            scale < 0.25, 2, 0.25 >
            translate < -1.5, 0, 0 >
          } //end Post
   object { YCyl_1
            scale < 0.25, 2, 0.25 >
            translate <  1.5, 0, 0 >
          } //end Post
   object { XCyl_1                     // Bannister
            scale < 1.5, 0.25, 0.25 >
            translate < 0, 2, 0 >
          } //end horz bannister
   texture { Polished_Brass }
      } // end basic Railing unit A

// ************************************************************************

//  DEFINE  basic Railing Unit:  n/s  3 units wide

#declare Railing_Unit_B =
union {
   object { YCyl_1
            scale < 0.25, 2, 0.25 >
            translate < 0, 0, -1.5 >
          } //end Post
   object { YCyl_1
            scale < 0.25, 2, 0.25 >
            translate < 0, 0, 1.5 >
          } //end Post
   object { ZCyl_1                     // Bannister
            scale < 0.4, 0.4, 1.5 >
            translate < 0, 2, 0 >
          } //end horz bannister
   texture { Polished_Brass }
      } // end basic Railing unit  B

// ************************************************************************

//  DEFINE  Balcony Railing: 10 units wide n/s

#declare Railing_Unit_C =
union {
   object { Railing_Unit_B
            translate < 0, 0, -9 >     // north
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -6 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -3 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 0 >      // center
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 3 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 6 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 9 >
          } //end Post
   texture { Polished_Brass }
     }  //  end Railing Unit C

// ************************************************************************

//  DEFINE  Balcony Railing: 20 units wide  n/s

#declare Railing_Unit_D =
union {
   object { Railing_Unit_B
            translate < 0, 0, -18 >    // north end
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -15 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -12 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -9 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -6 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, -3 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 0 >      // center
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 3 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 6 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 9 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 12 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 15 >
          } //end Post
   object { Railing_Unit_B
            translate < 0, 0, 18 >
          } //end Post
   texture { Polished_Brass }
     }  //  end Railing Unit D

// ************************************************************************
//                         INTERIOR FURNISHINGS
// ************************************************************************

// DEFINE  Fire Place

#declare FirePlace_A =
union {
   object {                            //the Firebox
      difference { object { UnitBox         //Outside box
                            scale < 8, 4.0, 4 > }
                   object { UnitBox         // Inside box
                            scale < 6, 4.5, 3 > }
                 } //end diference
      rotate x*-90
      translate y*3.5  translate z*2
          } // end object fire box
   object { UnitBox                    // Rear Wall
            scale < 8, 4, 0.5 >
            translate < 0, 3, 6 >
          }  // end obj Box
   object { UnitBox                    // Fire floor
            scale < 10, 0.5, 6 >
            translate < 0, 0, 2.5 >
          }  // end obj Box
   object { UnitBox                    // Base platform
            scale < 11, 1, 7 >
            translate < 0, -1, 2.5 >
          }  // end obj Box
   object { UnitBox                    // Chimney
            scale < 6, 18, 2.5 >
            translate < 0, 20, 4 >
          } // end object
   texture { Grnt20  rotate < 10, 0, 20 > }
      }  // end union Fire Place A

// ************************************************************************
// ************************************************************************
//                        Define Basic Wall Elements
// ************************************************************************

//  DEFINE  Frames: *******************************************************

//  DEFINE    the frame of a wall unit 20x / 20y, faces n/s

#declare Frame_NA =
union {
   object { Post_NY
            scale < 1, 20, 1 >  translate < -10,   0, 0 > }
   object { Post_NY
            scale < 1, 20, 1 >  translate <  10,   0, 0 > }
   object { Post_NX
            scale < 21, 1, 1 >  translate <   0,  10, 0 > }
   object { Post_NX
            scale < 21, 1, 1 >  translate <   0, -10, 0 > }
      } // end Frame New A

// ***********************************************************************

//  DEFINE    the frame of a wall unit 40x 30y, faces n/s, arches

#declare Frame_NB =
union {
   object { Post_NY                                        // left
            scale < 1, 30, 1 >  translate < -20,   5, 0 > }
   object { Post_NY                                        // right
            scale < 1, 30, 1 >  translate <  20,   5, 0 > }
   object { Post_NY                                        // left of door
            scale < 1, 30, 1 >  translate <  -5,   5, 0 > }
   object { Post_NY                                        // right of door
            scale < 1, 30, 1 >  translate <   5,   5, 0 > }
   object { Post_NX                                        // top
            scale < 41, 1, 1 >  translate <   0,  20, 0 > }
   object { Post_NX                                        // middle
            scale < 41, 1, 1 >  translate <   0,  10, 0 > }
   object { Post_NX                                        // bottom
            scale < 41, 1, 1 >  translate <   0, -10, 0 > }
   object { Post_NX                                        // above door
            scale < 41, 1.5, 1 >  translate <   0, 2, 0 > }
   object { Arch_Z2                                        // the arch
            scale < 20, 18, 1 > translate <   0, 2, -0.5 > }
   object { Arch_Z2                                        // the arch
            scale <  5, 5, 0.5 > translate < -25, 15, 0 > }
   object { Arch_Z2                                        // the arch
            scale <  5, 5, 0.5 > translate <  25, 15, 0 > }
      } // end Frame New B

// ************************************************************************

//  DEFINE    the half-height frame of a wall unit 20x 10y faces n/s

#declare Frame_NC =
union {
   object { Post_NY                                        // left
            scale < 1, 10, 1 >   translate < -10,  0, 0 > }
   object { Post_NY                                        // right
            scale < 1, 10, 1 >   translate <  10,  0, 0 > }
   object { Post_NX                                        // top
            scale < 21, 1, 1 >  translate <   0,  5, 0 > }
   object { Post_NX                                        // bottom
            scale < 21, 1, 1 >  translate <   0, -5, 0 > }
      } // end Frame NC

// ************************************************************************

//  DEFINE    the frame of a ceiling unit 20x 20y faces up & down

#declare Frame_ND =
union {
   object { Post_NZ
            scale < 1, 1, 20 >  translate < -10, 0,   0 > }
   object { Post_NZ
            scale < 1, 1, 20 >  translate <  10, 0,   0 > }
   object { Post_NX
            scale < 21, 1, 1 >  translate <   0, 0, -10 > }
   object { Post_NX
            scale < 21, 1, 1 >  translate <   0, 0,  10 > }
      } // end Frame New D

// ************************************************************************

//  DEFINE   half-wide frame unit 10x 20y

#declare Frame_NE =
union {
   object { Post_NY
            scale < 1, 20, 1 >  translate < -5, 0,   0 > }
   object { Post_NY
            scale < 1, 20, 1 >  translate <  5, 0,   0 > }
   object { Post_NX
            scale < 11, 1, 1 >  translate <  0, -10, 0 > }
   object { Post_NX
            scale < 11, 1, 1 >  translate <  0,  10, 0 > }
      } // end Frame New E

// ************************************************************************

//   DEFINE   a 10x 10y frame

#declare Frame_NF =
union {
   object { Post_NY
            scale < 1, 10, 1 >  translate < -5,  0, 0 > }
   object { Post_NY
            scale < 1, 10, 1 >  translate <  5,  0, 0 > }
   object { Post_NX
            scale < 11, 1, 1 >  translate <  0,  5, 0 > }
   object { Post_NX
            scale < 11, 1, 1 >  translate <  0, -5, 0 > }
      } // end Frame New F

// ***********************************************************************

//   DEFINE  basic door frame inset for 20x 20y Frame

#declare Frame_Door_A1 =
union {
   object { Post_NY                                        // west of door
            scale < 1, 20, 1 >  translate < -3, 0, 0 > }
   object { Post_NY                                        // east of door
            scale < 1, 20, 1 >  translate <  3, 0, 0 > }
   object { Post_NX                                        // above door
            scale < 20, 1, 1 >  translate <  0, 3, 0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end Frame for Door  A1

// ************************************************************************
// ************************************************************************

//   DEFINE  Panels: ******************************************************

//   DEFINE the basic 20x 20y wall panel: scaled for Frame_NA

#declare Panel_NA =
object { UnitBox
         scale < 10.5, 10.5, 0.25 >
         texture { EMBWood1
                   scale < 11, 0.5, 0.5 >
                   rotate < 70 0 0 > }
       } // end Panel NA

// ***********************************************************************

//   DEFINE   A window panel scaled for Frame_NA

#declare Panel_NB =
union {
   object { UnitBox
            texture { Glass }
            scale < 3.5, 5, 0.35 >
            translate < 0, 0, 0 > } // end window Box
   object { UnitBox
            texture { EMBWood1  scale < 1, 7, 1 >  rotate < 70 0 0 > }
            scale < 3.5, 2.5, 0.25 >
            translate y*7.25 } // end above window Box
   object { UnitBox
            texture { EMBWood1  scale < 1, 7, 1 >  rotate < 70 0 0 > }
            scale < 3.5, 2.5, 0.25 >
            translate y*-7.5 } // end below window Box
   object { UnitBox
            texture { EMBWood1  scale < 1, 13, 1 >  rotate < 70 0 0 > }
            scale < 3, 10, 0.25 >
            translate x*-7.5 } // end left panel Box
   object { UnitBox
            texture { EMBWood1  scale < 1, 13, 1 >  rotate < 70 0 0 > }
            scale < 3, 10, 0.25 >
            translate x*7.5 } // end right panel Box
   object { Post_NY
            texture { T_Wood5  scale 0.5 }
            scale < 1, 20, 1 >  translate <  4, 0, 0 > }
   object { Post_NY
            texture { T_Wood5  scale 0.5 }
            scale < 1, 20, 1 >  translate < -4, 0, 0 > }
   object { Post_NX
            texture { T_Wood5  scale 0.5 }
            scale < 10, 1, 1 >  translate <   0,  5, 0 > }
   object { Post_NX
            texture { T_Wood5  scale 0.5 }
            scale < 10, 1, 1 >  translate <   0, -5, 0 > }
      } // end union panel New B: a window & frames

// ************************************************************************

//   DEFINE 20x 20y panel: Decco template

#declare Panel_NC =
union {
   object { UnitBox
            scale < 10.5, 10.5, 0.25 >
          } // end horiz panel
   object { Post02                     // y cylinder
            scale < 0.25, 10.5, 0.25 >
            translate < 10.5, 0, 0 >
          } // end round edge right
   object { Post02                     // y cylinder
            scale < 0.25, 10.5, 0.25 >
            translate < -10.5, 0, 0 >
          } // end round edge left
   object { UnitBox
            scale < 2, 10.5, 0.25 >
            rotate y*90
            translate < 10.5, 0, 2 >
          } // end horiz panel
   object { UnitBox
            scale < 2, 10.5, 0.25 >
            rotate y*90
            translate < -10.5, 0, 2 >
          } // end horiz panel
   texture { EMBWood1
             scale < 11, 0.5, 0.5 >
             rotate < 70 0 0 > }
      } // end Panel New C

// ************************************************************************

//   DEFINE 10x 10y panel: Decco round edges: scale suit use

#declare Panel_ND =
union {
   object { UnitBox
            scale < 5.5, 5.5, 0.25 >
          } // end horiz panel
   object { Post02                     // y cylinder
            scale < 0.25, 5.5, 0.25 >
            translate < 5.5, 0, 0 >
          } // end round edge right
   object { Post02                     // y cylinder
            scale < 0.25, 5.5, 0.25 >
            translate < -5.5, 0, 0 >
          } // end round edge left
   texture { EMBWood1
             scale < 11, 0.5, 0.5 >
             rotate < 70 0 0 > }
      } // end Panel New D

// ************************************************************************

//   DEFINE 10x 10y panel: Decco round edges: Glass

#declare Panel_NE =
union {
   object { UnitBox
            scale < 5.5, 5.5, 0.25 >
          } // end horiz panel
   object { Post02                     // y cylinder
            scale < 0.25, 5.5, 0.25 >
            translate < 5.5, 0, 0 >
          } // end round edge right
   object { Post02                     // y cylinder
            scale < 0.25, 5.5, 0.25 >
            translate < -5.5, 0, 0 >
          } // end round edge left
   texture { Glass }
      } // end Panel New E

// ************************************************************************

//   DEFINE the basic 20x 20y wall panel: scaled for Frame_NA: glass

#declare Panel_NF =
object { UnitBox
         scale < 10.5, 10.5, 0.25 >
         texture { Glass }
       } // end Panel NF

// ************************************************************************

//   DEFINE a basic 10x 20y wall panel: scaled for Frame_NE

#declare Panel_NG =
object { UnitBox
         scale < 5.5, 10.5, 0.25 >
         texture { EMBWood1
                   scale < 11, 0.5, 0.5 >
                   rotate < 70 0 0 > }
       } // end Panel NG

// ************************************************************************

//   DEFINE a basic 10x 20y wall panel: scaled for Frame_NE

#declare Panel_NH =
object { UnitBox
         scale < 5.5, 10.5, 0.25 >
         texture { Glass }
       } // end Panel NH

// ************************************************************************

//   DEFINE a basic 10x 10y wall panel: scaled for Frame_NF

#declare Panel_NI =
object { UnitBox
         scale < 5.5, 5.5, 0.25 >
//         scale < 10.5, 5.5, 0.25 >
         texture { EMBWood1
                   scale < 11, 0.5, 0.5 >
                   rotate < 60 0 0 > }
       } // end Panel New I

// ************************************************************************

//   DEFINE a glass 20x 10y wall panel: scaled for Frame_NF

#declare Panel_NJ =
object { UnitBox
         scale < 10.5, 5.5, 0.25 >
         texture { Glass }
       } // end Panel New J

// ************************************************************************
// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK1 =
union {
   object { UnitBox                                        // upper tier
            scale < 5,  5, 0.25 >  translate < -25,   15, 0 >
          }// box upper left
   object { UnitBox
            scale < 7,  5, 0.25 >  translate < -12.5, 15, 0 >
          }// box upper mid left
   object { UnitBox
            scale < 5,  5, 0.25 >  translate <   0,   15, 0 >
          }// box upper center
   object { UnitBox
            scale < 7,  5, 0.25 >  translate <  12.5, 15, 0 >
          }// box upper mid right
   object { UnitBox
            scale < 5,  5, 0.25 >  translate <  25,   15, 0 >
          }// box upper right
   texture { Glass }
      } // end panel NK1 Glass

// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK2 =
union {
   object { UnitBox                                        // upper tier
            scale < 5,  5, 0.25 >  translate < -25,   15, 0 >
          }// box upper left
   object { UnitBox
            scale < 7,  5, 0.25 >  translate < -12.5, 15, 0 >
          }// box upper mid left
   object { UnitBox
            scale < 5,  5, 0.25 >  translate <   0,   15, 0 >
          }// box upper center
   object { UnitBox
            scale < 7,  5, 0.25 >  translate <  12.5, 15, 0 >
          }// box upper mid right
   object { UnitBox
            scale < 5,  5, 0.25 >  translate <  25,   15, 0 >
          }// box upper right
   texture { EMBWood1 scale < 11, 0.5, 0.5 >  rotate < 60 0 0 > }
      } // end panel NK2 wood

// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK3 =
union {
   object { UnitBox                                        //middle tier
            scale < 7, 4, 0.25 >  translate < -12.5,   6, 0 >
          }// box middle mid left
   object { UnitBox
            scale < 5,  4, 0.25 >  translate <   0,    6, 0 >
          }// box middle center  above door
   object { UnitBox
            scale < 7, 4, 0.25 >  translate <  12.5,   6, 0 >
          }// box middle mid right
   texture { Glass }
      } // end panel NK3 Glass

// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK4 =
union {
   object { UnitBox                                        //middle tier
            scale < 7, 4, 0.25 >  translate < -12.5,   6, 0 >
          }// box middle mid left
   object { UnitBox
            scale < 5,  4, 0.25 >  translate <   0,    6, 0 >
          }// box middle center  above door
   object { UnitBox
            scale < 7, 4, 0.25 >  translate <  12.5,   6, 0 >
          }// box middle mid right
   texture { EMBWood1 scale < 11, 0.5, 0.5 >  rotate < 60 0 0 > }
      } // end panel NK4 wood

// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK5 =
union {
   object { UnitBox                                        // lower tier
            scale < 5, 10, 0.25 >  translate < -25,    0, 0 >
          }// box lower left
   object { UnitBox
            scale < 7, 6, 0.25 >  translate < -12.5,  -4, 0 >
          }// box lower mid left
   object { UnitBox
            scale < 7, 6, 0.25 >  translate <  12.5,  -4, 0 >
          }// box lower mid right
   object { UnitBox
            scale < 5, 10, 0.25 >  translate <  25,    0, 0 >
          }// box lower right
   texture { Glass }
      } // end panel NK5 glass

// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK6 =
union {
   object { UnitBox                                        // lower tier
            scale < 5, 10, 0.25 >  translate < -25,    0, 0 >
          }// box lower left
   object { UnitBox
            scale < 7, 6, 0.25 >  translate < -12.5,  -4, 0 >
          }// box lower mid left
   object { UnitBox
            scale < 7, 6, 0.25 >  translate <  12.5,  -4, 0 >
          }// box lower mid right
   object { UnitBox
            scale < 5, 10, 0.25 >  translate <  25,    0, 0 >
          }// box lower right
   texture { EMBWood1 scale < 11, 0.5, 0.5 >  rotate < 60 0 0 > }
      } // end panel NK6 wood

// ************************************************************************

//  DEFINE  sub-panels for atrium wall

#declare Panel_NK7 =
union {
   object { UnitBox                                        // lower tier
            scale < 5, 10, 0.25 >  translate < -25, 0, 0 >
            texture { EMBWood1 scale < 15, 0.5, 0.5 >  rotate < 60, 0, 0 > }
          }// box lower left
   object { UnitBox
            scale < 5, 10, 0.25 >  translate < 25, 0, 0 >
            texture { EMBWood1 scale < 15, 0.5, 0.5 >  rotate < 60, 0, 0 > }
          }// box lower right
   object { UnitBox
            scale < 7, 6, 1 >  translate < -12.5, -4, 0 >
            texture {
               pigment { brick Gray50 Firebrick scale 0.25 } //end pigment
                    } //end texture
          }// box lower mid left
   object { UnitBox
            scale < 7, 6, 1 >  translate <  12.5, -4, 0 >
            texture {
               pigment { brick Gray50 Firebrick scale 0.25 } //end pigment
                    } //end texture
          }// box lower mid right
      } // end panel NK7 brick

// ************************************************************************
// ************************************************************************

//   DEFINE   Atrium paneling for Frame_NB: 40x  30y facing south

#declare Panel_NK =
union {
   object { Panel_NK1 }                // upper tier glass
//   object { Panel_NK2 }                // upper tier solid
   object { Panel_NK3 }                // middle tier glass
//   object { Panel_NK4 }                // middle tier solid
//   object { Panel_NK5 }                // lower tier glass
//   object { Panel_NK6 }                // lower tier solid WOOD
   object { Panel_NK7 }                // lower tier BRICK & WOOD
   object { UnitBox
            texture { T_Wood2 }
            scale < 5, 6, 0.25 >  translate < 0, -4, 0 >
          }// door: closed
/*
   object { UnitBox
            texture { T_Wood2 }
            scale < 5, 6, 0.25 >  translate < -2.5, -4, -5 >
            rotate y*-45
          }// door: open
*/
      } // end union Panel New K: Atrium south

// ************************************************************************

//   DEFINE 10x 10y panel: Door

#declare Panel_NL =
union {
   union {
      object { UnitBox                    // the door
               scale < 1.5, 3.5, 0.4 >
               translate y*-1.5
              } // end door panel
      object { UnitBox                    // above the door
               scale < 5, 1.25, 0.5 >
               translate y*4
              } // end door panel
      object { UnitBox                    // right side
               scale < 2, 3.5, 0.5 >
               translate < -3.5, -1.5, 0 >
              } // end door panel
      object { UnitBox                    // left side
               scale < 2, 3.5, 0.5 >
               translate < 3.5, -1.5, 0 >
              } // end door panel
      texture { EMBWood1
                scale < 11, 0.5, 0.5 > //scale < 22, 1, 1 >
                rotate < 70 0 0 > }
         } // end union door + panels
   union {
      object { Post_NY                                     // west of door
               scale <  1, 10, 1 >  translate < -1.5, 0, 0 > }
      object { Post_NY                                     // east of door
               scale <  1, 10, 1 >  translate <  1.5, 0, 0 > }
      object { Post_NX                                     // above door
               scale < 11,  1, 1 >  translate <  0, 2.5, 0 > }
      texture { T_Wood5  scale 0.5 } // end door frame texture
         } // end union door frames
      } // end Panel New L

// ************************************************************************

//  DEFINE  low brick panels for walls

#declare Panel_NM =
object { UnitBox
         scale < 10.5, 2.5, 1 >
         texture { B_Red_Brick }
       } // end brick panel New M

// ************************************************************************

//  DEFINE  low brick panels for walls: half length

#declare Panel_NN =
object { UnitBox
         scale < 5.5, 2.5, 1 >
         texture { B_Red_Brick }
       } // end brick panel New N

// ************************************************************************
//                                DOORS
// ************************************************************************

//   DEFINE  a 6x 12y door: scaled for Door_Front  CLOSED

#declare Panel_Door_A1 =
object { UnitBox
         scale < 3, 6.25, 0.35 >  translate < 0, -3.5, 0 >
         texture { EMBWood1 }
       } // end Panel New Door A1

// ************************************************************************

//   DEFINE  a 6x 12y door: scaled for Door_Front   OPEN

#declare Panel_Door_B1 =
object { UnitBox
         scale < 3, 6.25, 0.35 >  translate < 0, -3.5, -3 >
         rotate y*-45
         texture { EMBWood1 }
       } // end Panel New Door B1

// ************************************************************************

//   DEFINE  set of wall panels scaled for Door_Front

#declare Panel_Door_A2 =
union {
   object { UnitBox                                             // LL
            scale < 3, 7, 1 >    translate < -6.5, -3.5, 0 > }
   object { UnitBox                                             // LR
            scale < 3, 7, 1 >    translate <  6.5, -3.5, 0 > }
   object { UnitBox                                             // UL
            scale < 3, 3.5, 1 >  translate < -6.5,  6.5, 0 > }
   object { UnitBox                                             // UR
            scale < 3, 3.5, 1 >  translate <  6.5,  6.5, 0 > }
   object { UnitBox                                             // UC
            scale < 3, 3.5, 1 >  translate <    0,  6.5, 0 > }
   texture { EMBWood1  scale < 11, 0.5, 0.5 >  rotate < 60 0 0 > }
      } // end Panels New Door A2

// ************************************************************************

//   DEFINE   a front door for Atrium wall

#declare Door_Front =
union {
   object { Panel_Door_A1 }            // door, closed
//   object { Panel_Door_B1 }            // door, open
   object { Panel_Door_A2 }            // panels around door
   object { Frame_Door_A1 }            // door jams
      } // end Front Door

// ************************************************************************

//  DEFINE  a thin door unit

#declare Door_Thin =
union {
object { Panel_Door_A1  scale < 1.5, 1, 1 >     translate < 0, 0.0, 0 > }
object { Post_NX
         texture { T_Wood5  scale 0.5 } // end texture
         scale < 10, 1, 1 >      translate < 0, 3.0, 0 > }
object { Panel_NA
         texture { EMBWood1 scale < 25, 1, 0.5 >  rotate < 30, 0, 0 > }
         scale < 0.5, 0.35, 1 >  translate < 0, 6.5, 0 > }
      }  // end union Door Thin

// ************************************************************************
// ************************************************************************
//                            Define Wall Units
// ************************************************************************
//            NewWall_Location_n = frame + frame + ... + texture
// ************************************************************************

//   DEFINE  a Wall Section 60x 20y

#declare NW_South_1 =                  // A South-facing Wall
union {
   object { Frame_NA  translate < -20, 0,  0.0 > }    // west
   object { Frame_NA  translate <   0, 0,  0.0 > }    // center panel
   object { Frame_NA  translate <  20, 0,  0.0 > }    // east
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall South 1

// ************************************************************************

//   DEFINE  a Wall Section 60x 30y

#declare NW_South_2 =                  // A South-facing Wall
union {
   object { Frame_NC  translate < -20,  0,  0.0 > }   // lower
   object { Frame_NC  translate <   0,  0,  0.0 > }
   object { Frame_NC  translate <  20,  0,  0.0 > }
   object { Frame_NC  translate < -20, 10,  0.0 > }   // upper
   object { Frame_NC  translate <   0, 10,  0.0 > }
   object { Frame_NC  translate <  20, 10,  0.0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall South 2

// ************************************************************************

//   DEFINE  a Wall Section 60x 10y

#declare NW_South_3 =                  // A South-facing Wall
union {
   object { Frame_NC  translate <  20, 0, 0 > }
   object { Frame_NC  translate <   0, 0, 0 > }
   object { Frame_NC  translate < -20, 0, 0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New South Wall 3

// ************************************************************************

//   DEFINE  a Wall Section 80x 20y: revised for Room 3

#declare NW_South_4 =                  // A South-facing Wall
union {
   object { Frame_NE  translate <  35,  0, 0 > }      // lower teir
   object { Frame_NA  translate <  20,  0, 0 > }
   object { Frame_NA  translate <   0,  0, 0 > }
   object { Frame_NA  translate < -20,  0, 0 > }
   object { Frame_NE  translate < -35,  0, 0 > }
   object { Frame_NE  translate <  35, 20, 0 > }      // upper teir
   object { Frame_NA  translate <  20, 20, 0 > }
   object { Frame_NA  translate <   0, 20, 0 > }
   object { Frame_NA  translate < -20, 20, 0 > }
   object { Frame_NE  translate < -35, 20, 0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New South Wall 4

// ************************************************************************

//   DEFINE  a Wall Section 80x 20y: revised for Room 3

#declare NW_South_5 =                  // A South-facing Wall
union {
   object { Frame_NE  translate <  35,  0, 0 > }      // lower teir
   object { Frame_NA  translate <  20,  0, 0 > }
   object { Frame_NA  translate <   0,  0, 0 > }
   object { Frame_NA  translate < -20,  0, 0 > }
   object { Frame_NE  translate < -35,  0, 0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New South Wall 5

// ************************************************************************

//   DEFINE  a Wall Section  60x 20y

#declare NW_North_1 =                  // A north-facing Wall
union {
   object { Frame_NA  translate < -20, 0,  0.0 > }    // west
   object { Frame_NA  translate <   0, 0,  0.0 > }    // center panel
   object { Frame_NA  translate <  20, 0,  0.0 > }    // east
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall North 1

// ************************************************************************

//   DEFINE  a Wall Section: 2 frames: 40x 20y

#declare NW_East_1 =                   // An East-facing Wall
union {
   object { Frame_NA  rotate y*90  translate <  0, 0,  10.0 > } // north
   object { Frame_NA  rotate y*90  translate <  0, 0, -10.0 > } // south
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall East 1

// ************************************************************************

//   DEFINE  a Wall Section: 3 frames   60x  20y

#declare NW_East_2 =                   // faces e/w
union {
   object { Frame_NA  rotate y*90  translate <  0,  0, -20 > }
   object { Frame_NA  rotate y*90  translate <  0,  0,   0 > }
   object { Frame_NA  rotate y*90  translate <  0,  0,  20 > }
   object { Frame_NA  rotate y*90  translate <  0, 20, -20 > }
   object { Frame_NA  rotate y*90  translate <  0, 20,   0 > }
   object { Frame_NA  rotate y*90  translate <  0, 20,  20 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall East 2

// ************************************************************************

//   DEFINE  a Wall Section: 2 frames    40x  20y

#declare NW_West_1 =                   // A West-facing Wall
union {
   object { Frame_NA  rotate y*-90  translate < 0, 0,  10.0 > } // north
   object { Frame_NA  rotate y*-90  translate < 0, 0, -10.0 > } // south
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall West 1

// ************************************************************************

//   DEFINE  a Wall Section: 3 frames    60x  20y

#declare NW_West_2 =                   // A West-facing Wall
union {
   object { Frame_NA  rotate y*-90  translate < 0,  0,  20 > }  // lower
   object { Frame_NA  rotate y*-90  translate < 0,  0,   0 > }
   object { Frame_NA  rotate y*-90  translate < 0,  0, -20 > }
   object { Frame_NA  rotate y*90   translate < 0, 20, -20 > }  // upper
   object { Frame_NA  rotate y*90   translate < 0, 20,   0 > }
   object { Frame_NA  rotate y*90   translate < 0, 20,  20 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall West 2

// ************************************************************************
//                        Atrium Wall Frames
// ************************************************************************

//   DEFINE  Atrium Wall Frame: 3 wide, 1.5 tall   60x  30y

#declare NW_South_A1 =                 // south atrium
union {
   object { Frame_NA  translate <  20,  0, 0 > }      // lower tier
   object { Frame_NA  translate <   0,  0, 0 > }
   object { Frame_NA  translate < -20,  0, 0 > }
   object { Frame_NC  translate <  20, 15, 0 > }      // upper tier
   object { Frame_NC  translate <   0, 15, 0 > }
   object { Frame_NC  translate < -20, 15, 0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end N Wall South A1

// ************************************************************************

//   DEFINE  Atrium Wall Frame: old arch style,  60x  30y

#declare NW_South_A2 =                 // south atrium
union {
   object { Frame_NE  translate <  25,  0, 0 > }      // lower tier
   object { Frame_NB  translate <   0,  0, 0 > }      // with arches
   object { Frame_NE  translate < -25,  0, 0 > }
   object { Frame_NF  translate <  25, 15, 0 > }      // upper tier
   object { Frame_NF  translate < -25, 15, 0 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end N Wall South A2

// ************************************************************************

//   DEFINE  a Wall Section: 5 frames:  80x  10y

#declare NW_West_A2 =                  // atrium west A1 REVISED
union {
   object { Frame_NC  rotate y*90  translate < 0, 15, -30 > }   // upper tier
   object { Frame_NF  rotate y*90  translate < 0, 15, -15 > }
   object { Frame_NC  rotate y*90  translate < 0, 15,   0 > }
   object { Frame_NF  rotate y*90  translate < 0, 15,  15 > }
   object { Frame_NA  rotate y*90  translate < 0, 0, -30 > }    // lower tier
   object { Frame_NE  rotate y*90  translate < 0, 0, -15 > }
   object { Frame_NA  rotate y*90  translate < 0, 0,   0 > }
   object { Frame_NE  rotate y*90  translate < 0, 0,  15 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall West A2

// ************************************************************************

//   DEFINE  a Wall Section: 5 frames:  80x  30y

#declare NW_East_A2 =                  // atrium east A1 REVISED
union {
   object { Frame_NC  rotate y*90  translate < 0, 15, -30 > }   // upper tier
   object { Frame_NF  rotate y*90  translate < 0, 15, -15 > }
   object { Frame_NC  rotate y*90  translate < 0, 15,   0 > }
   object { Frame_NF  rotate y*90  translate < 0, 15,  15 > }
   object { Frame_NA  rotate y*90  translate < 0, 0, -30 > }    // lower tier
   object { Frame_NE  rotate y*90  translate < 0, 0, -15 > }
   object { Frame_NA  rotate y*90  translate < 0, 0,   0 > }
   object { Frame_NE  rotate y*90  translate < 0, 0,  15 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end New Wall East A2

// ************************************************************************
// ************************************************************************
//                           Define Complex Rooms
// ************************************************************************
//      Room_n = frame + siding + floor + roof + lights + other stuff
// ************************************************************************
//                         DEFINE ROOM 1A: East Wing
// ************************************************************************

//   DEFINE  a T-shaped room frame: Room 1A

#declare R_Frame_1A =
union {
   object { Frame_NA               translate < -20, 0, -40 > }  // south
   object { Frame_NA  rotate y*90  translate < -10, 0, -30 > }
   object { Frame_NA               translate <   0, 0, -20 > }
   object { Frame_NA               translate <  20, 0, -20 > }
   object { Frame_NA               translate < -10, 0,  40 > }  // north
   object { Frame_NA  rotate y*90  translate <   0, 0,  30 > }
   object { Frame_NE               translate <   5, 0,  20 > }
   object { Frame_NA               translate <  20, 0,  20 > }
   object { Frame_NA  rotate y*90  translate <  30, 0, -10 > }  // east
   object { Frame_NA  rotate y*90  translate <  30, 0,  10 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end Room Frame 1a

// ***********************************************************************

//   DEFINE   a t-shaped room: Wing_One variant: east wing

#declare Room_1A =
union {
   // floor:
   object { Floor_One texture { RosewoodB }
                      texture { Seams_X }
            scale < 11, 2, 11 >  translate < -20, -SmallSpan, -30 > }
   object { Floor_One texture { RosewoodB }
                      texture { Seams_X }
            scale < 11, 2, 11 >  translate < -10, -SmallSpan, 30 > }
   object { Floor_One texture { RosewoodB }
                      texture { Seams_X }
            scale < 31, 2, 21 >  translate <   0, -SmallSpan,   0 > }
   // the wall frames:
   object { R_Frame_1A }
   // the wall sidings:
   object { Panel_SG4               translate < -20,  0, -40 > }  // south
   object { Panel_NM                translate < -20, -7, -40 > }
   object { Panel_NA   rotate y*90  translate < -10,  0, -30 > }
   object { Panel_NA                translate <   0,  0, -20 > }
   object { Panel_SG4               translate <  20,  0, -20 > }
   object { Panel_NM                translate <  20, -7, -20 > }
   object { Panel_SG4               translate < -10,  0,  40 > }  // north
   object { Panel_NM                translate < -10, -7,  40 > }
   object { Panel_NA   rotate y*90  translate <   0,  0,  30 > }
   object { Panel_NG                translate <   5,  0,  20 > }
   object { Panel_SG4               translate <  20,  0,  20 > }
   object { Panel_NM                translate <  20, -7,  20 > }
   object { Panel_SG4  rotate y*90  translate <  30,  0, -10 > }  // east
   object { Panel_NM   rotate y*90  translate <  30, -7, -10 > }
   object { Panel_SG4  rotate y*90  translate <  30,  0,  10 > }
   object { Panel_NM   rotate y*90  translate <  30, -7,  10 > }
   // Fireplace:
   object { FirePlace_A  rotate y*180  translate < 0, -SmallSpan, -15 > }
   // roof railings: south side:
   object { Railing_Unit_C
            rotate y*90  translate < -20, 12, -39.5 > }         // sw
   object { Railing_Unit_C
            rotate y*90  translate <  3, 12, -19.5 > }          // se
   object { Railing_Unit_C
            rotate y*90  translate <  15, 12, -19.5 > }         // se
   object { Railing_Unit_C  translate < -10.5, 12, -30 > }      // s
   // roof railings: north side:
   object { Railing_Unit_C
            rotate y*90  translate < -10, 12,  39.5 > }         // nw
   object { Railing_Unit_C
            rotate y*90  translate <  15, 12,  19.5 > }         // ne
   object { Railing_Unit_C  translate < 0.5, 12, 30 > }         // n
   // roof railings: east side:
   object { Railing_Unit_D  translate < 30, 12, 0 > }           // e
   // roof:
   object { Roof_One
            texture { T_Grnt0 }
            scale < 12, 1.1, 12 >  translate < -10, SmallSpan,  30 > }
   object { Roof_One
            texture { T_Grnt0 }
            scale < 12, 1.1, 12 >  translate < -20, SmallSpan, -30 > }
   object { Roof_One
            texture { T_Grnt0 }
            scale < 32, 1.1, 22 >  translate <   0, SmallSpan,   0 > }
#if ( Lights )
   // interior lights:
   object { WallLamp_A  rotate x*-90  translate <  0, 9.2, 0 > }
   object { WallLamp_A  rotate x*-90  translate < 20, 9.2, 0 > }
#else
   // interior lights:
   object { WallLamp_B  rotate x*-90  translate <  0, 9.2, 0 > }
   object { WallLamp_B  rotate x*-90  translate < 20, 9.2, 0 > }
#end

/*
#if ( Furnishings )
   #include "do_table.inc"
   object { DO_Table3
            scale 10
            translate < 7, -SmallSpan, 15 > }
   #include "do_lamps.inc"
   object { DO_DeskLamp1
            scale 12
            translate < 7, -2.5, 15 > }
   #include "do_chair.inc"
   object { DO_Chair1
            rotate y*25
            scale 10
            translate < 18, -SmallSpan, 15 > }
#end
*/
      } // end Room 1A

// ************************************************************************
//                          DEFINE ROOM 1B: West Wing
// ************************************************************************

//   DEFINE  a T-shaped room frame: Room 1B: west wing

#declare R_Frame_1B =
union {
   object { Frame_NA               translate <  20, 0, -40 > }  // south
   object { Frame_NA  rotate y*90  translate <  10, 0, -30 > }
   object { Frame_NA               translate <   0, 0, -20 > }
   object { Frame_NA               translate < -20, 0, -20 > }
   object { Frame_NA               translate <  10, 0,  40 > }  // north
   object { Frame_NA  rotate y*90  translate <   0, 0,  30 > }
   object { Frame_NE               translate <  -5, 0,  20 > }
   object { Frame_NA               translate < -20, 0,  20 > }
   object { Frame_NA  rotate y*90  translate < -30, 0, -10 > }  // west
   object { Frame_NA  rotate y*90  translate < -30, 0,  10 > }
   texture { T_Wood5  scale 0.5 } // end texture
      } // end Room Frame 1B

// ***********************************************************************

//   DEFINE   a t-shaped room: west wing

#declare Room_1B =
union {
   // floor:
   object { Floor_One texture { RosewoodB }
                      texture { Seams_X }
            scale < 11, 2, 11 >  translate < 10, -SmallSpan,  30 > }
   object { Floor_One texture { RosewoodB }
                      texture { Seams_X }
            scale < 11, 2, 11 >  translate < 20, -SmallSpan, -30 > }
   object { Floor_One texture { RosewoodB }
                      texture { Seams_X }
            scale < 31, 2, 21 >  translate <  0, -SmallSpan,   0 > }
   // the wall frames:
   object { R_Frame_1B }
   // the wall siding:
   object { Panel_SG4               translate < -20,  0, -20 > } // south
   object { Panel_NM                translate < -20, -7, -20 > }
   object { Panel_NA   rotate y*90  translate <  10,  0, -30 > }
   object { Panel_NA                translate <   0,  0, -20 > }
   object { Panel_SG4               translate <  20,  0, -40 > }
   object { Panel_NM                translate <  20, -7, -40 > }
   object { Panel_SG4               translate <  10,  0,  40 > } // north
   object { Panel_NM                translate <  10, -7,  40 > }
   object { Panel_NA   rotate y*90  translate <   0,  0,  30 > }
   object { Panel_NG                translate <  -5,  0,  20 > }
   object { Panel_SG4               translate < -20,  0,  20 > }
   object { Panel_NM                translate < -20, -7,  20 > }
   object { Panel_SG4  rotate y*90  translate < -30,  0, -10 > } // west
   object { Panel_NM   rotate y*90  translate < -30, -7, -10 > }
   object { Panel_SG4  rotate y*90  translate < -30,  0,  10 > }
   object { Panel_NM   rotate y*90  translate < -30, -7,  10 > }
   // roof railings: north side:
   object { Railing_Unit_C
            rotate y*90  translate < 11, 12,  39.5 > }          // ne
   object { Railing_Unit_C
            rotate y*90  translate < -15, 12,  19.5 > }         // nw
   object { Railing_Unit_C  translate < 0.5, 12, 30 > }         // nw
   // roof railings: south side:
   object { Railing_Unit_C
            rotate y*90  translate < 21, 12, -39.5 > }          // se
   object { Railing_Unit_C
            rotate y*90  translate < -2, 12, -19.5 > }          // sw
   object { Railing_Unit_C
            rotate y*90  translate < -16, 12, -19.5 > }         // sw
   object { Railing_Unit_C  translate < 10.5, 12, -30 > }       // s
   // roof railings: west side:
   object { Railing_Unit_D  translate < -30, 12, 0 > }          // w
   // roof:
   object { Roof_One
            texture { T_Grnt0 }
            scale < 12, 1.1, 12 >  translate < 10, SmallSpan, 30 > }
   object { Roof_One
            texture { T_Grnt0 }
            scale < 12, 1.1, 12 >  translate < 20, SmallSpan, -30 > }
   object { Roof_One
            texture { T_Grnt0 }
            scale < 32, 1.1, 22 >  translate <  0, SmallSpan,   0 > }
#if ( Lights )
   // interior lights
   object { WallLamp_A  rotate x*-90  translate < -20, 9.2, 0 > }
   object { WallLamp_A  rotate x*-90  translate <   0, 9.2, 0 > }
#else
   // interior lights
   object { WallLamp_B  rotate x*-90  translate < -20, 9.2, 0 > }
   object { WallLamp_B  rotate x*-90  translate <   0, 9.2, 0 > }
#end
      } // end Room 1B

// ***********************************************************************
//                         DEFINE ROOM 2: Atrium
// ************************************************************************

//   DEFINE  Atrium frame: w/ arches: scaled to fit R_Siding_A1

#declare R_Frame_A1 =
union {
   object { NW_South_A2  translate <   0, 0, -40 > }            // arches
   object { NW_East_A2   translate <  30, 0,   0 > }
   object { NW_West_A2   translate < -30, 0,   0 > }
      } // end Room Frame Atrium 1

// ************************************************************************

//   DEFINE Atrium Interior frame: scaled to fit R_Siding_A3

#declare R_Frame_A2 =
union {
   object { Frame_NA  rotate y*90   translate < -10, 0,  10 > } //west n
   object { Frame_NA  rotate y*90   translate < -10, 0, -30 > } //west s
   object { Frame_NA  rotate y*90   translate <  10, 0,  10 > } //east n
   texture { T_Wood5  scale 0.5 } // end texture
      } // end Room Frame Atrium 2

// ************************************************************************

//   DEFINE  Atrium siding w/ arches: scaled to fit R_Frame_A1

#declare R_Siding_A1 =
union {
   // old style arched wall:
   object { Panel_NK               translate <   0,  0, -40 > } // south
   // new style other walls:
   object { Panel_NE  rotate y*90  translate < -30, 15,  15 > } // west
   object { Panel_NJ  rotate y*90  translate < -30, 15,   0 > }
   object { Panel_ND  rotate y*90  translate < -30, 15, -15 > }
   object { Panel_NJ  rotate y*90  translate < -30, 15, -30 > }

   object { Panel_NI  rotate y*90  translate <  30, 15,  15 > } // east
   object { Panel_NJ  rotate y*90  translate <  30, 15,   0 > }
   object { Panel_NE  rotate y*90  translate <  30, 15, -15 > }
   object { Panel_NJ  rotate y*90  translate <  30, 15, -30 > }
      }  // end Room Siding Atrium A1

// ************************************************************************

//   DEFINE   The Atrium: the center of the New House

#declare Atrium_1 =
union {
   // ground floor:
   object { Floor_One
               texture { RosewoodB }
               texture { Seams_X }
               scale < 31, 2, 31 >
               translate < 0, -SmallSpan, -10 > }
   // the wall frames:
   object { R_Frame_A1 }               // exterior  w/ arches
   object { R_Frame_A2 }               // interior
   // exterior panels:
   object { R_Siding_A1 }
/*
   // east balcony:
   object { Floor_One
               texture { RosewoodB }
               texture { Seams_X  rotate y*45 }
               scale < 10, 2, 15 >
               translate < 20, SmallSpan, 5 > }
   object { Railing_Unit_C  translate < 11, 11.9, 10 > }
   object { Railing_Unit_B  translate < 11, 11.9, -2 > }
   object { Railing_Unit_B  translate < 11, 11.9, -5 > }
   object { Railing_Unit_B  translate < 11, 11.9, -8 > }
   // west balcony:
   object { Floor_One
               texture { RosewoodB }
               texture { Seams_X  rotate y*45 }
               scale < 10, 2, 30 >
               translate < -20, SmallSpan, -10 > }
   object { Railing_Unit_D  translate < -11, 11.9,  -0.5 > }
   object { Railing_Unit_C  translate < -11, 11.9, -27.5 > }
   // stairs:
   object { Stairway_A  scale 2  translate < 20, -13.5, -30 > }
   // the roof:
   object { Roof_Two
            texture { T_Grnt0 }
            scale < 42, 4, 41 >  translate < 0, 24, -13 > }
*/
   // south wall trim & decore:
   object { Front_Arch  translate < 0, 0, -48.5 > }
   object { Front_Boxes translate < 0, 0, -50.0 > }

#if ( Lights )
   // interior lights:
//   object { WallLamp_A  rotate x*-90  translate <  15, 19.5,   5.0 > }
//   object { WallLamp_A  rotate x*-90  translate < -15, 19.5,   5.0 > }
//   object { WallLamp_A  rotate x*-90  translate <  15, 19.5, -17.5 > }
//   object { WallLamp_A  rotate x*-90  translate < -15, 19.5, -17.5 > }
   // exterior lights: south wall
   object { WallLamp_C  translate < -6.0, 8.0, -40.75 > }
   object { WallLamp_C  translate <  8.0, 8.0, -40.75 > }
#else
   // interior lights:
   object { WallLamp_B  rotate x*-90  translate <  15, 19.5,   5.0 > }
   object { WallLamp_B  rotate x*-90  translate < -15, 19.5,   5.0 > }
   object { WallLamp_B  rotate x*-90  translate <  15, 19.5, -17.5 > }
   object { WallLamp_B  rotate x*-90  translate < -15, 19.5, -17.5 > }
   // exterior lights: south wall
   object { WallLamp_B  translate < -6.0, 8.0, -40.75 > }
   object { WallLamp_B  translate <  8.0, 8.0, -40.75 > }
#end

/*
#if ( Furnishings )
   #include "do_table.inc"
   object { DO_Table3
            scale 9
            translate < 12, -SmallSpan, 14 > }
   #include "do_chair.inc"
   object { DO_Chair1
            rotate y*25
            scale 9
            translate < 20, -SmallSpan, 12.5 > }
#end
*/
      } // end Atrium 1

// ************************************************************************
//                       DEFINE ROOM 2: North Wing
// ************************************************************************

//   DEFINE  a square room 60x 30y 60z: Room 2

#declare R_Frame_2 =
union {
   object { NW_South_4  translate <   0,  0,  30 > }            // north
   object { NW_South_5  translate <   0,  0, -30 > }            // south
   object { NW_East_2   translate <  40,  0,   0 > }            // east
   object { NW_West_2   translate < -40,  0,   0 > }            // west
      } // end Room Frame 2

// ************************************************************************

//   DEFINE  a interior frames for Room 2: ground floor

#declare R_Frame_3 =
union {
   object { Frame_NA               translate <  30, 0,  10 > }  // NE
   object { Frame_NE               translate <  15, 0,  10 > }  //
   object { Frame_NA  rotate y*90  translate <  10, 0,  20 > }  //
   object { Frame_NA               translate < -30, 0,  10 > }  // NW
   object { Frame_NE               translate < -15, 0,  10 > }  //
   object { Frame_NA  rotate y*90  translate < -10, 0,  20 > }  //
   object { Frame_NA               translate <  30, 0, -10 > }  // SE
   object { Frame_NE               translate <  15, 0, -10 > }  //
   object { Frame_NA  rotate y*90  translate <  10, 0, -20 > }  //
   object { Frame_NA               translate < -30, 0, -10 > }  // SW
   object { Frame_NE               translate < -15, 0, -10 > }  //
   object { Frame_NA  rotate y*90  translate < -10, 0, -20 > }  //
   texture { T_Wood5  scale 0.5 } // end texture
      } // end Room Frame 3

// ************************************************************************

//   DEFINE  a interior frames for Room 2: second floor

#declare R_Frame_4 =
union {
   object { Frame_NA               translate <  30, 0, -10 > }  // NE
   object { Frame_NE               translate <  15, 0, -10 > }  //
   object { Frame_NA  rotate y*90  translate <  10, 0,  20 > }  //
   object { Frame_NA  rotate y*90  translate <  10, 0,   0 > }  //
   object { Frame_NA               translate < -30, 0, -10 > }  // NW
   object { Frame_NE               translate < -15, 0, -10 > }  //
   object { Frame_NA  rotate y*90  translate < -10, 0,  20 > }  //
   object { Frame_NA  rotate y*90  translate < -10, 0,   0 > }  //
   texture { T_Wood5  scale 0.5 } // end texture
      } // end Room Frame 4

// ************************************************************************

//   DEFINE   a box of siding to fit R_Frame_3

#declare R_Siding_1 =
union {
   // lower tier:
   //west
   object { Panel_NA          rotate y*-90 translate < -40.3,  0,  20 > }
   object { Panel_NM
            scale < 1, 2, 1 > rotate y*-90 translate < -40.3, -5,  20 > }
   object { Panel_NF          rotate y*-90 translate < -40.3, 0,    0 > }
   object { Panel_NM
            scale < 1, 2, 1 > rotate y*-90 translate < -40.3, -7,   0 > }
   object { Panel_NA          rotate y*-90 translate < -40.3,  0, -20 > }
   object { Panel_NM
            scale < 1, 2, 1 > rotate y*-90 translate < -40.3, -5, -20 > }
   //north
   object { Panel_NH          rotate y*180 translate < -35,  0, 30.3 > }
   object { Panel_NN
            scale < 1, 2, 1 > rotate y*180 translate < -35, -5, 30.3 > }
   object { Panel_NA          rotate y*180 translate < -20,  0, 30.3 > }
   object { Panel_NM
            scale < 1, 2, 1 > rotate y*180 translate < -20, -5, 30.3 > }
   object { Door_Front  rotate y*180 translate < 0, 0, 30.3 > }
   object { Panel_NA          rotate y*180 translate <  20,  0, 30.3 > }
   object { Panel_NM
            scale < 1, 2, 1 > rotate y*180 translate <  20, -5, 30.3 > }
   object { Panel_NH          rotate y*180 translate <  35,  0, 30.3 > }
   object { Panel_NN
            scale < 1, 2, 1 > rotate y*180 translate <  35, -5, 30.3 > }
   //east
   object { Panel_NA                   rotate y*90 translate < 40.3,  0,  20 > }
   object { Panel_NM scale < 1, 2, 1 > rotate y*90 translate < 40.3, -5,  20 > }
   object { Panel_NF                   rotate y*90 translate < 40.3,  0,   0 > }
   object { Panel_NM scale < 1, 2, 1 > rotate y*90 translate < 40.3, -7,   0 > }
   object { Panel_NA                   rotate y*90 translate < 40.3,  0, -20 > }
   object { Panel_NM scale < 1, 2, 1 > rotate y*90 translate < 40.3, -5, -20 > }
   //south
   object { Panel_NH                   translate < -35,   0, -30.3 > }
   object { Panel_NN scale < 1, 2, 1 > translate < -35,  -5, -30.3 > }
   object { Panel_NA                   translate < -20,   0, -30.3 > }
   object { Panel_NM scale < 1, 1, 1 > translate < -20, -7.5, -30.3 > }
   object { Door_Front                 translate <   0,   0, -30.3 > }
   object { Panel_NA                   translate <  20,   0, -30.3 > }
   object { Panel_NM scale < 1, 1, 1 > translate <  20, -7.5, -30.3 > }
   object { Panel_NH                   translate <  35,   0, -30.3 > }
   object { Panel_NN scale < 1, 2, 1 > translate <  35,  -5, -30.3 > }
   // upper tier:
   //north
   object { Panel_NH  rotate y*180  translate < -35, 20,  30.3 > }
   object { Panel_NA  rotate y*180  translate < -20, 20,  30.3 > }
   object { Panel_NF  rotate y*180  translate <   0, 20,  30.3 > }
   object { Panel_NA  rotate y*180  translate <  20, 20,  30.3 > }
   object { Panel_NH  rotate y*180  translate <  35, 20,  30.3 > }
   //west
   object { Panel_NA  rotate y*-90  translate < -40.3, 20,  20 > }
   object { Panel_NF  rotate y*-90  translate < -40.3, 20,   0 > }
   object { Panel_NA  rotate y*-90  translate < -40.3, 20, -20 > }
   //east
   object { Panel_NA  rotate y*90   translate <  40.3, 20,  20 > }
   object { Panel_NF  rotate y*90   translate <  40.3, 20,   0 > }
   object { Panel_NA  rotate y*90   translate <  40.3, 20, -20 > }
   //south
   object { Panel_NH                       translate < -35, 20, -30.3 > }
   object { Panel_NH                       translate <  35, 20, -30.3 > }
   object { Panel_NF  scale < 1, 0.5, 1 >  translate < -20, 25, -30.0 > }
   object { Panel_NF  scale < 1, 0.5, 1 >  translate <   0, 25, -30.0 > }
   object { Panel_NF  scale < 1, 0.5, 1 >  translate <  20, 25, -30.0 > }
     } // end Room Siding 1

// ************************************************************************

//   DEFINE   interior siding first floor

#declare R_Siding_2 =
union {
   object { Panel_NA               translate <  30, 0, -10 > }  // SE
   object { Panel_NA  rotate y*90  translate <  10, 0, -20 > }  //
   object { Panel_NA               translate < -30, 0, -10 > }  // SW
   object { Panel_NA  rotate y*90  translate < -10, 0, -20 > }  //
   object { Panel_NA               translate <  30, 0,  10 > }  // NW
   object { Panel_NA  rotate y*90  translate <  10, 0,  20 > }  //
   object { Panel_NA               translate < -30, 0,  10 > }  // NE
   object { Panel_NA  rotate y*90  translate < -10, 0,  20 > }  //
     } // end Room Siding 2

// ************************************************************************

//   DEFINE   interior siding second floor

#declare R_Siding_3 =
union {
   object { Panel_NA               translate <  30, 0, -10 > }  // NE
   object { Panel_NA  rotate y*90  translate <  10, 0,  20 > }  //
   object { Panel_NA  rotate y*90  translate <  10, 0,   0 > }  //
   object { Panel_NA               translate < -30, 0, -10 > }  // NW
   object { Panel_NA  rotate y*90  translate < -10, 0,  20 > }  //
   object { Panel_NA  rotate y*90  translate < -10, 0,   0 > }  //
     } // end Room Siding 3

// ************************************************************************

//   DEFINE NORTH ROOM:

#declare Room_2 =
union {
   // floors:
   object { Floor_One                            // ground floor
            texture { RosewoodB }
            texture { Seams_X  rotate y*90 }
            scale < 41, 2, 31 >
            translate < 0, -SmallSpan, 0 > }
   object { Floor_One                            // 2nd story floor
            texture { RosewoodB }
            texture { Seams_X }
            scale < 40, 2, 30 >
            translate < 0, SmallSpan+0.2, 0 > }
   object { Railing_Unit_C
            rotate y*90
            translate < 0, 11.9, -29 > }
   // the wall frames:
   object { R_Frame_2 }                          // exterior frame
   object { R_Frame_3 }                          // interior frame 1st floor
   object { R_Frame_4  translate y*LargeSpan }   // interior frame 2nd floor
   // some doors
   object { Door_Thin  translate <  15, 0, 10 > }
   object { Door_Thin  translate < -15, 0, 10 > }
   object { Door_Thin  translate <  15, 0, -10 > }
   object { Door_Thin  translate < -15, 0, -10 > }
   object { Door_Thin  translate <  15, LargeSpan, -10 > }
   object { Door_Thin  translate < -15, LargeSpan, -10 > }
   // the wall siding:
   object { R_Siding_1 }                         // exterior walls
   object { R_Siding_2 }                         // interior walls 1st floor
   object { R_Siding_3  translate y*LargeSpan }  // interior walls 2nd floor
   // roof:
   object { Roof_Two
            texture { T_Grnt0 }
            scale < 55, 4.5, 45 >  translate < 0, 34, 0 >
          } // end Roof
/*
#if ( Furnishings )
   #include "do_table.inc"
   object { DO_Table3
            scale 9
            rotate y*90
            translate < -5, SmallSpan, -5 > }
   #include "do_chair.inc"
   object { DO_Chair1
            rotate y*35
            scale 9
            translate < 3, SmallSpan, -5 > }
#end
*/

#if (Lights)
   // interior lights: upstairs
   object { WallLamp_A  rotate x*-90  translate <  22.5, 29.5, 10 > }
   object { WallLamp_A  rotate x*-90  translate < -22.5, 29.5, 10 > }
   object { WallLamp_A  rotate x*-90  translate <   0.0, 29.5,  0 > }
   // interior lights: downstairs
   object { WallLamp_A  rotate x*-90  translate <  22.5,  9.4,  17.5 > }
   object { WallLamp_A  rotate x*-90  translate <  22.5,  9.4, -20.0 > }
   object { WallLamp_A  rotate x*-90  translate < -22.5,  9.4,  17.5 > }
   object { WallLamp_A  rotate x*-90  translate < -22.5,  9.4, -20.0 > }
   object { WallLamp_A  rotate x*-90  translate <   0.0,  9.4,   0.0 > }
#else
   // interior lights: upstairs
   object { WallLamp_B  rotate x*-90  translate <  22.5, 29.5,  10 > }
   object { WallLamp_B  rotate x*-90  translate < -22.5, 29.5,  10 > }
   object { WallLamp_B  rotate x*-90  translate <   0.0, 29.5,   0.0 > }
   // interior lights: downstairs
   object { WallLamp_B  rotate x*-90  translate <  22.5,  9.4,  17.5 > }
   object { WallLamp_B  rotate x*-90  translate <  22.5,  9.4, -20.0 > }
   object { WallLamp_B  rotate x*-90  translate < -22.5,  9.4,  17.5 > }
   object { WallLamp_B  rotate x*-90  translate < -22.5,  9.4, -20.0 > }
   object { WallLamp_B  rotate x*-90  translate <   0.0,  9.4,   0.0 > }
#end     // end of lights on/off
      } // end Room 2

// ************************************************************************
//                        Define Wings of the House
// ************************************************************************
//                    New_Wing_n = room + room + decore
// ************************************************************************

//   DEFINE   a room north of atrium, version 2

#declare New_Wing_1 =
union {
   object { Room_1A  translate <  60, SmallSpan,  0 > }    // east room
   object { Room_1B  translate < -60, SmallSpan,  0 > }    // west room
   object { Atrium_1 translate <   0, SmallSpan,  0 > }    // atrium
   object { Room_2   translate <   0, SmallSpan, 50 > }    // north room
      } // end New Wing 1

// ************************************************************************
// ************************************************************************
//                            DEFINE Our_House
// ************************************************************************

#declare Our_House =
union {
   object { New_Wing_1 }
   object { Front_Yard  translate z*-60 }
      } // end union Our House

// ************************************************************************
// ************************************************************************
//           O_HOUSE0.INC  Michael Brendan Hurley (c) Summer 1999
// ************************************************************************
// ************************************************************************
                                       
