
#pragma once
#include <string>
#include <vector>

namespace povjson {
  struct Message {
    std::string severity;   // error | warning | debug
    std::string category;   // syntax | semantic | include | directive | version | other
    std::string code;       // optional code
    std::string text;
    std::string file;
    int line = 0;
    int column = 0;
    std::string near;
    std::string suggestion;
  };

  struct Report {
    std::string versionUsed;
    std::vector<std::string> files;
    std::vector<Message> messages;
  };

  std::string to_json(const Report& r);
}

extern "C" {
  int         pov_init_parse_env(const char* json_options);
  const char* pov_parse_text(const char* filename, const char* file_text);
  const char* pov_parse_file(const char* filename);
  void        pov_free_json(const char* ptr);
}
