
# Build POV‑Ray parser JS (single file) from the official repo

This bundle adds a GitHub Actions workflow and a small `libpov_sdl_parse` module so you can build a **single JavaScript file** (ES module) that embeds the WASM and exposes a parse‑only API from the **official [POV‑Ray/povray] repo**.

> The official repo: https://github.com/POV-Ray/povray (AGPL‑3.0) — see README and build notes. 

## What this produces
- Artifact: `pov_parse_single.mjs` (a single ES module with embedded WASM via `-s SINGLE_FILE=1 -s MODULARIZE=1 -s EXPORT_ES6=1`).
- Exports you will call from JS (via `cwrap`):
  - `pov_init_parse_env(jsonOptions)`
  - `pov_parse_text(filename, text)`
  - `pov_parse_file(filename)`
  - `pov_free_json(ptr)`

## How to use
1. **Copy** this bundle into the root of your fork of `POV-Ray/povray`.
2. Commit and push; GitHub Actions will run automatically (or trigger with **Run workflow**).
3. Download the artifact `pov_parse_single.mjs` from the workflow run and paste it into your single‑file HTML.

## Why Emscripten flags
- `SINGLE_FILE=1`: embeds the WASM in the generated JS so you can ship **one file**. 
- `MODULARIZE=1` + `EXPORT_ES6=1`: produces an ES‑module **factory**; the default export is a function that creates the module instance (see Emscripten’s modularized output docs). 

## References
- POV‑Ray repo & README (build, license): `POV-Ray/povray`.
- Emscripten modularized output & ES modules: `-s MODULARIZE`, `-s EXPORT_ES6`.
- Packaging files & embedding: `SINGLE_FILE` and `--embed-file` to keep one asset.

## Notes
- This workflow links a static library (`libpov_sdl_parse.a`) built by CMake to a single JS module. If your environment needs extra sources linked, add them in the `emcc` link step.
- To wire the **official parser** internals, replace the stub implementation in `embedded_parse_api.cpp` with direct calls into `source/parser/*.cpp` entry points in the upstream tree, following the project’s include hierarchy rules.
