-- Copyright (C) 2001 Severin Dietschi

-- The first thing we have to do is init an empty "class" in which
-- we'll add methods later.
Parkett={}

-- The method init holds the object's initialization code. Here you
-- can set default values for the object's properties.
function Parkett:init()
 self.lang=7
 self.breit=7
 self.sdi=12356789
 self.reflection=0
 self.texture=""
end

-- This method is called just before the object is freed from memory.
-- You probably won't need to put any code here because Lua is a
-- garbage collected language.
function Parkett:destroy()
end

-- The method load is called when the object is being read from a .MDL
-- file. The "stream" object passed to it has methods to load
-- booleans, bytes, ints, doubles and strings. Note that for Lua all
-- numbers are doubles. When you write bytes and ints a conversion
-- from double to these types will be done. Watch out for overflows.
function Parkett:load(stream)
 stream:readByte()
 self.lang=stream:readDouble()
 self.breit=stream:readDouble()
 self.reflection=stream:readDouble()
 self.texture=stream:readString()
 self.sdi=stream:readDouble()
end

-- This methods saves the object to a .MDL file. The "stream" object
-- passed to it has methods to save booleans, bytes, ints, doubles and
-- strings. You should always save a "version" byte before the actual
-- object properties, so if you change your object's functionality in
-- the future you can test for the version inside "load" and make
-- aproppriate decisions.
function Parkett:save(stream)
 stream:writeByte(1)
 stream:writeDouble(self.lang)
 stream:writeDouble(self.breit)
 stream:writeDouble(self.reflection)
 stream:writeString(self.texture)
 stream:writeDouble(self.sdi)
end


-- This method is called to retrive the object's name, category, UID
-- created with MkUID.exe and icon created with bitmap.exe.
function Parkett:getProperties()
 return "Parkett",
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"..
  "0333033330333033"

end

-- The method "getDialog" is used to build the dialog that is seen in
-- Moray's "Modify" tab. The "dialog" object passed to it supports
-- :addEditBox(label,value,min,max,decimals) to add number edit boxes,
-- :addTextEdit(label,value) to add free text edit boxes,
-- :addTexture(value) to add texture select buttons,
-- :addSeparator(label) to add flow-breaking horizontal bars and
-- :addCheckBox(label,value) to add check boxes,
-- :addListBox(options,value) to add list boxes,
-- :addRadioButton(label,value) to add radio buttons. All these
-- methods except "addSeparator" return a control ID, which must be
-- kept somewhere to be used in "valueChanged".
function Parkett:getDialog(dialog)
 self.langID=dialog:addEditBox("x (only uneven):",self.lang,1,1000,0)
self.breitID=dialog:addEditBox("y:",self.breit,1,1000,0)
 self.sdiID=dialog:addEditBox("random seed:",self.sdi,0,99999999,0)
 self.reflectionID=dialog:addEditBox("Reflection:",self.reflection,0,1,2)
 self.textureID=dialog:addTexture(self.texture)
end

-- This method is called whenever a control's value changes. It's
-- called with the id of the control returned by one of the "dialog"
-- methods and the new value of the control. You can test these values
-- to decide if the property should be updated (the value can be out
-- of range, for example). For radio buttons, this function is only
-- called when the control is checked. To uncheck the other radio
-- buttons of a group, set their variables to nil and the controls
-- will be automatically updated. Note that number edit boxes already
-- keep the control's value inside the range you specified in
-- "getDialog". You can also call "self:redraw()" to cause Moray to
-- redraw your object's wireframe and "scene:invalidate()" to make
-- Moray set the scene as modified.
function Parkett:valueChanged(id,value)
 if id==self.langID then
  self.lang=value
  self:redraw()
 end

 if id==self.breitID then
  self.breit=value
  self:redraw()
 end

 if id==self.textureID then
  self.texture=value
 end

 if id==self.sdiID then
  self.sdi=value
 end

 if id==self.reflectionID then
  self.reflection=value
 end

 scene:invalidate()
end

-- This method is used only when the object is part of a CSG object.
-- You should return 1 is the given point <x,y,z> is inside the object
-- and 0 otherwise. If you're too lazy like me you can return "nil"
-- which means "not implemented".
function Parkett:getInside(x,y,z)
 return nil
end

-- The method "wireframe" build the object's wireframe. The "wire"
-- object passed to it has methods :line(x0,y0,x1,y1),
-- :squareX(y0,z0,y1,z1,x) to draw a square in the X plane,
-- :squareY(x0,z0,x1,z1,y), :squareZ(x0,y0,x1,y1,z),
-- :cube(x0,y0,z0,x1,y1,z1) to draw a cube (box?),
-- :circleX(x,y,z,r,i,j) to draw a circle in the X plane,
-- :circleY(x,y,z,r,i,j), :circleZ(x,y,z,r,i,j), :sphere(x,y,z,r) and
-- :heightField(x0,x1,sx,y0,y1,sy,f) to draw a height field using
-- function "f" to calculate z for each <x,y> (see function.lua).
function Parkett:wireframe(wire)
 local lang,breit
 breit=self.breit
 lang=self.lang

 while breit~=0  do
  while lang~=0  do
  wire:squareZ(lang-1, breit-1, lang, breit,0)
  lang=lang-1
  end
 lang=self.lang
 breit=breit-1
 end
end

-- This method "prints" the object to Pov-Ray. The "pov" object passed
-- to it has methods :write(...) to print all arguments to Pov,
-- :texture(name) to print a texture statement, :transforms(xforms) to
-- print the object's transforms and :heightField(x0,x1,sx,y0,y1,sy,f)
-- to print a function (see remarks for method "wireframe").
function Parkett:toPOV(pov)
 local lang,breit,weg,zrot
 breit=self.breit
 lang=self.lang
 weg=0
 zrot=0

 pov:write(" #declare sd=seed(",self.sdi,"); ")

 while breit~=0 do
  while lang~=0  do
  pov:write(" #declare one = rand(sd)*.2; ")
  pov:write(" #declare two = rand(sd)*.2; ")
  pov:write(" #declare three = rand(sd)*.2; ")

   while weg~=1 do
   pov:write(" box{<1, 1, 0> <.795-",weg,", 0, 0>	pigment{wood
turbulence .05 scale <rand(sd)*.2,rand(sd)*.2,rand(sd)*.2> color_map{[0
rgb<one+.7, one+.45, 0>][.4 rgb<two+.8, two +.5, 0>][1 rgb<three+.65,
three+.4, 0>]}}finish{ambient rand(sd)*.2+.3 reflection ",self.reflection,"}
")
   pov:write(" translate <-.5,-.5,0> ")
   pov:write(" rotate ",zrot,"*z ")
   pov:write(" translate <+.5,+.5,0> ")
   pov:write(" translate <+",lang,"-1,+",breit,"-1,0> ")
   pov:transforms(self.xforms)
   pov:write(" } ")
   weg=weg+.2
   end

  weg=0
  lang=lang-1
  zrot=zrot+90 --rotation by 90 degrees
  if zrot>90 then --
  zrot=zrot-180 --
  end  --
  end
 lang=self.lang
 breit=breit-1
 end

end

-- You must register the class so Moray can instantiate object's of
-- this type as needed.
registerClass(Parkett,"Parkett")

