-- Copyright (C) 2001 Stephen Shonfield
-- morayplugin@yahoo.ca
-- ca.geocities.com/morayplugin

Isosurface={}

function Isosurface:init()
	self.pluginversion=1.4 
	self.poversion=1 --Pov 3.5 
	self.item1="Povray 3.5 syntax" 
	self.item2="MegaPov 0.7 syntax" -- not implemented
	self.listbox={self.item1}
	self.declareitemA=""
	self.declareitemB=""
	self.declareitemC=""
	self.declareitemD=""
	self.declareitemE=""
	self.declareitemF=""
	self.declareitemG=""
	self.declareitemH=""
	self.declareitemI=""
	self.declareitemJ=""
	self.declareitemK=""
	self.declareitemL=""
	self.declareitemM=""
	self.declareitemN=""
	self.declarelistA={"#declared A","#declared B","#declared C","#declared D","#declared E","#declared F","#declared G"}
	self.declarenumA=1
	self.povcodeSA=self.declareitemA
	self.declarelistB={"#declared H","#declared I","#declared J","#declared K","#declared L","#declared M","#declared N"}
	self.declarenumB=1
	self.povcodeSB=self.declareitemH
	self.povcodeA=""
	self.povcodeB=""
	self.povcodeC=""
	self.isomath="sqrt(x*x + y*y + z*z) - 1" 
	self.boxcontain=1
	self.minx=-1.0
	self.miny=-1.0
	self.minz=-1.0
	self.maxx=1.0
	self.maxy=1.0
	self.maxz=1.0
	self.spherecontain=nil
	self.xsphere=0.0
	self.ysphere=0.0
	self.zsphere=0.0
	self.rsphere=1.0
	self.threshold=0.0 
	self.accuracy=0.01
	self.evalP0=1
	self.evalP1=10
	self.evalP2=0.99
	self.maxgradient=0 
	self.open=nil
	self.maxtrace=5
	self.allint=nil
	self.flags=1
   	self.doubleilluminate=nil 
	    self.flagscheck=self.doubleilluminate
	   self.hollow=nil
	   self.inverse=nil
	   self.noimage=nil
	   self.noreflection=nil
	   self.noshadow=nil
	self.photons=1
	   self.collect=1
	      self.photonscheck=self.collect
	   self.passthrough=nil
	   self.reflection=nil
	   self.refraction=nil
	   self.target=nil
	   self.spacingmultiplier=1
	self.mytexture=""
	self.texture=""
	self.viewdetail=3
	self.copyright=" by S Shonfield, morayplugin@yahoo.ca"
	self.howtouse="\n\nWhen you create an isosurface object, a wire frame of the contained_by statement is displayed.\n"..
	              "There are 17 possible places to declare constants, functions, variables.\n"..
                 "2 lists of 7 each, and 3 listed separatly. The plugin will automaticly place a '#declare' at the begining and a ';' at the end.\n"..
                 "If you want to, you can declare your entire isosurface in the function statement.\n\n"..
      
                 "If max_gradient is set to '0.0' then evaluate is used and max_gradient is set to 1\n"..
                 "If max_gradient is set to anything other than '0.0' then only max_gradient is used\n\n"..
      
                 "You can declare your entire texture if you want, if it is left blank then the 'texture' button is used.\n"..
                 "The 'texture' button only lists textures already made for this scene in Moray.\n"..
      
                 "The declare, function, and texture statements are limited to 255 characters each.\n\n"..
      
                 "Moray's local co-ordinates, No shadow, Hollow, do not work with this plugin.\n\n"..
                 
                 "New to version 1.1\n"..
                 "List output, lists what this plugin exports to Pov\n"..
                 "wireframe detail, 0 = no wireframe\n"..
                 "                          1 = corners\n"..
                 "              2 or more = full"..
                 "\nNew to version 1.4"..
	              "\nPhotons"..
	              "\n  If you select target, you must also select reflection and/or refraction"..
	              "\n  or photons will not react with object."
end

function Isosurface:destroy()
end

function Isosurface:load(stream)
   self.pluginversion=stream:readDouble()
   self.poversion=stream:readDouble()
   self.declareitemA=stream:readString()
   self.declareitemB=stream:readString()
   self.declareitemC=stream:readString()
   self.declareitemD=stream:readString()
   self.declareitemE=stream:readString()
   self.declareitemF=stream:readString()
   self.declareitemG=stream:readString()
   self.declareitemH=stream:readString()
   self.declareitemI=stream:readString()
   self.declareitemJ=stream:readString()
   self.declareitemK=stream:readString()
   self.declareitemL=stream:readString()
   self.declareitemM=stream:readString()
   self.declareitemN=stream:readString()
   self.declarenumA=stream:readDouble()
   self.declarenumB=stream:readDouble()
   self.povcodeSA=stream:readString()
   self.povcodeSB=stream:readString()
   self.povcodeA=stream:readString()
   self.povcodeB=stream:readString()
   self.povcodeC=stream:readString()
   self.isomath=stream:readString()
   self.boxcontain=stream:readBoolean()
  	self.minx=stream:readDouble()
  	self.miny=stream:readDouble()
  	self.minz=stream:readDouble()
  	self.maxx=stream:readDouble()
  	self.maxy=stream:readDouble()
  	self.maxz=stream:readDouble()
  	self.spherecontain=stream:readBoolean()
	self.xsphere=stream:readDouble()
   self.ysphere=stream:readDouble()
	self.zsphere=stream:readDouble()
	self.rsphere=stream:readDouble()
   self.threshold=stream:readDouble()
   self.accuracy=stream:readDouble()
   self.evalP0=stream:readDouble()
   self.evalP1=stream:readDouble()
   self.evalP2=stream:readDouble()
   self.maxgradient=stream:readDouble()
   self.open=stream:readBoolean()
   self.maxtrace=stream:readDouble()
   self.allint=stream:readBoolean()
   self.noimage=stream:readBoolean()
   self.noreflection=stream:readBoolean()
   self.noshadow=stream:readBoolean()
   self.doubleilluminate=stream:readBoolean()
   self.hollow=stream:readBoolean()
   self.inverse=stream:readBoolean()
   self.mytexture=stream:readString()
   self.texture=stream:readString()
   if self.pluginversion>=1.1 then
      self.viewdetail=stream:readDouble()
	end
	if self.pluginversion>=1.4 then
	   self.photons=stream:readBoolean()
	   self.collect=stream:readBoolean()
	   self.passthrough=stream:readBoolean()
	   self.reflection=stream:readBoolean()
	   self.refraction=stream:readBoolean()
	   self.target=stream:readBoolean()
	   self.spacingmultiplier=stream:readDouble()
	end
end

function Isosurface:save(stream)
	self.pluginversion=1.4
	stream:writeDouble(self.pluginversion)
	stream:writeDouble(self.poversion)
	stream:writeString(self.declareitemA)
	stream:writeString(self.declareitemB)
	stream:writeString(self.declareitemC)
	stream:writeString(self.declareitemD)
	stream:writeString(self.declareitemE)
	stream:writeString(self.declareitemF)
	stream:writeString(self.declareitemG)
	stream:writeString(self.declareitemH)
	stream:writeString(self.declareitemI)
	stream:writeString(self.declareitemJ)
	stream:writeString(self.declareitemK)
	stream:writeString(self.declareitemL)
	stream:writeString(self.declareitemM)
	stream:writeString(self.declareitemN)
	stream:writeDouble(self.declarenumA)
	stream:writeDouble(self.declarenumB)
	stream:writeString(self.povcodeSA)
	stream:writeString(self.povcodeSB)
	stream:writeString(self.povcodeA)
	stream:writeString(self.povcodeB)
	stream:writeString(self.povcodeC)
	stream:writeString(self.isomath)
	stream:writeBoolean(self.boxcontain)
	stream:writeDouble(self.minx)
	stream:writeDouble(self.miny)
	stream:writeDouble(self.minz)
	stream:writeDouble(self.maxx)
	stream:writeDouble(self.maxy)
	stream:writeDouble(self.maxz)
	stream:writeBoolean(self.spherecontain)
	stream:writeDouble(self.xsphere)
	stream:writeDouble(self.ysphere)
	stream:writeDouble(self.zsphere)
	stream:writeDouble(self.rsphere)
	stream:writeDouble(self.threshold)
	stream:writeDouble(self.accuracy)
	stream:writeDouble(self.evalP0)
	stream:writeDouble(self.evalP1)
	stream:writeDouble(self.evalP2)
	stream:writeDouble(self.maxgradient)
	stream:writeBoolean(self.open)
	stream:writeDouble(self.maxtrace)
	stream:writeBoolean(self.allint)
	stream:writeBoolean(self.noimage)
	stream:writeBoolean(self.noreflection)
	stream:writeBoolean(self.noshadow)
	stream:writeBoolean(self.doubleilluminate)
	stream:writeBoolean(self.hollow)
	stream:writeBoolean(self.inverse)
	stream:writeString(self.mytexture)
	stream:writeString(self.texture) 
	stream:writeDouble(self.viewdetail)
	stream:writeBoolean(self.photons)
	stream:writeBoolean(self.collect)
	stream:writeBoolean(self.passthrough)
	stream:writeBoolean(self.reflection)
	stream:writeBoolean(self.refraction)
	stream:writeBoolean(self.target)
	stream:writeDouble(self.spacingmultiplier)
end

function Isosurface:getProperties()
	return	"Isosurface",
      "3461F5471093613A",
		"3339999333333333"..
		"3399999333333333"..
		"3999999933333333"..
		"3999999933333333"..
		"3999999933333333"..
		"3999999993333333"..
		"9999939993333333"..
		"9999339999933999"..
		"3333333399993999"..
		"3333333399999999"..
		"3333333339999999"..
		"3333333339999999"..
		"3333333339999999"..
		"3333333333999993"..
		"3333333333999933"..
		"3333333333333333"
end

function Isosurface:getDialog(dialog)
   self.poversionID=dialog:addListBox(self.listbox,self.poversion)
	self.listoutputID=dialog:addButton("List output")
   self.declareAID=dialog:addListBox(self.declarelistA,self.declarenumA)
   self.povcodeSAID=dialog:addTextEdit("#declared code",self.povcodeSA)
	dialog:addSeparator()
   self.declareBID=dialog:addListBox(self.declarelistB,self.declarenumB)
   self.povcodeSBID=dialog:addTextEdit("#declared code",self.povcodeSB)
	dialog:addSeparator()
	self.povcodeAID=dialog:addTextEdit("#declare",self.povcodeA)
	self.povcodeBID=dialog:addTextEdit("#declare",self.povcodeB)
	self.povcodeCID=dialog:addTextEdit("#declare",self.povcodeC)
	dialog:addSeparator("isosurface{")
	self.isomathID=dialog:addTextEdit("function {      }",self.isomath)
	self.boxcontainID=dialog:addRadioButton("contained_by {box(      )}",self.boxcontain)
   self.minboxxID=dialog:addEditBox("     < x",self.minx,-1000,1000,2)
   self.minboxyID=dialog:addEditBox("       ,y",self.miny,-1000,1000,2)
   self.minboxzID=dialog:addEditBox("       ,z>",self.minz,-1000,1000,2)
   self.maxboxxID=dialog:addEditBox("     < x",self.maxx,-1000,1000,2)
   self.maxboxyID=dialog:addEditBox("       ,y",self.maxy,-1000,1000,2)
   self.maxboxzID=dialog:addEditBox("       ,z>",self.maxz,-1000,1000,2)
	self.spherecontainID=dialog:addRadioButton("contained_by {sphere(  )}",self.spherecontain)
   self.xsphereID=dialog:addEditBox("     < x",self.xsphere,-1000,1000,2)
   self.ysphereID=dialog:addEditBox("       ,y",self.ysphere,-1000,1000,2)
   self.zsphereID=dialog:addEditBox("       ,z>",self.zsphere,-1000,1000,2)
   self.rsphereID=dialog:addEditBox("       ,r",self.rsphere,0,1000,2)
	self.thresholdID=dialog:addEditBox("threshold",self.threshold,0,10,2) 
	self.accuracyID=dialog:addEditBox("accuracy",self.accuracy,0,10,3) 
	self.evalP0ID=dialog:addEditBox("evaluate(P0",self.evalP0,0,100,0)
	self.evalP1ID=dialog:addEditBox("               P1",self.evalP1,1,100,0)
	self.evalP2ID=dialog:addEditBox("               P2)",self.evalP2,0,1,2)
	self.maxgradientID=dialog:addEditBox("max_gradient",self.maxgradient,0,5000,3)
	self.openID=dialog:addCheckBox("open",self.open) 
	self.maxtraceID=dialog:addEditBox("max_trace",self.maxtrace,1,50,0) 
	self.allintID=dialog:addCheckBox("all_intersections",self.allint)
	dialog:addSeparator("flags")
   self.flagsID=dialog:addListBox({"double_illuminate","hollow","inverse","no_image","no_reflection","no_shadow"},self.flags)
	self.flagscheckID=dialog:addCheckBox("",self.flagscheck)
	dialog:addSeparator("photons")
   self.photonsID=dialog:addListBox({"collect","pass_through","reflection","refraction","target"},self.photons)
	self.photonscheckID=dialog:addCheckBox("",self.photonscheck)
   self.spacingmultiplierID=dialog:addEditBox("spacing_multiplier",self.spacingmultiplier,.01,100,2)
	self.mytextureID=dialog:addTextEdit("texture",self.mytexture)
	dialog:addSeparator("}")
	self.textureID=dialog:addTexture(self.texture)
	self.aboutID=dialog:addButton("About this plugin")
   self.viewdetailID=dialog:addEditBox("view detail",self.viewdetail,0,4,0)
end

function Isosurface:valueChanged(id,value)
	if id==self.poversionID then
		if value==1 then  --Povray 3.5
   	   self.poversion=value
      end
   	scene:invalidate()
	elseif id==self.declareAID then
		if value==1 then  --item 1
   	   self.povcodeSA=self.declareitemA
   	   self.declarenumA=value
		elseif value==2 then  --item 1
   	   self.povcodeSA=self.declareitemB
   	   self.declarenumA=value
		elseif value==3 then  --item 1
   	   self.povcodeSA=self.declareitemC
   	   self.declarenumA=value
		elseif value==4 then  --item 1
   	   self.povcodeSA=self.declareitemD
   	   self.declarenumA=value
		elseif value==5 then  --item 1
   	   self.povcodeSA=self.declareitemE
   	   self.declarenumA=value
		elseif value==6 then  --item 1
   	   self.povcodeSA=self.declareitemF
   	   self.declarenumA=value
		elseif value==7 then  --item 1
   	   self.povcodeSA=self.declareitemG
   	   self.declarenumA=value
      end
   	scene:invalidate()
	elseif id==self.povcodeSAID then
		if self.declarenumA == 1 then
		   self.declareitemA=value
		elseif self.declarenumA==2 then
		   self.declareitemB=value
		elseif self.declarenumA==3 then
		   self.declareitemC=value
		elseif self.declarenumA==4 then
		   self.declareitemD=value
		elseif self.declarenumA==5 then
		   self.declareitemE=value
		elseif self.declarenumA==6 then
		   self.declareitemF=value
		elseif self.declarenumA==7 then
		   self.declareitemG=value
		end
		self.povcodeSA=value 
   	scene:invalidate()
	elseif id==self.declareBID then
		if value==1 then  --item 1
   	   self.povcodeSB=self.declareitemH
   	   self.declarenumB=value
		elseif value==2 then  --item 1
   	   self.povcodeSB=self.declareitemI
   	   self.declarenumB=value
		elseif value==3 then  --item 1
   	   self.povcodeSB=self.declareitemJ
   	   self.declarenumB=value
		elseif value==4 then  --item 1
   	   self.povcodeSB=self.declareitemK
   	   self.declarenumB=value
		elseif value==5 then  --item 1
   	   self.povcodeSB=self.declareitemL
   	   self.declarenumB=value
		elseif value==6 then  --item 1
   	   self.povcodeSB=self.declareitemM
   	   self.declarenumB=value
		elseif value==7 then  --item 1
   	   self.povcodeSB=self.declareitemN
   	   self.declarenumB=value
      end
   	scene:invalidate()
	elseif id==self.povcodeSBID then
		if self.declarenumB == 1 then
		   self.declareitemH=value
		elseif self.declarenumB==2 then
		   self.declareitemI=value
		elseif self.declarenumB==3 then
		   self.declareitemJ=value
		elseif self.declarenumB==4 then
		   self.declareitemK=value
		elseif self.declarenumB==5 then
		   self.declareitemL=value
		elseif self.declarenumB==6 then
		   self.declareitemM=value
		elseif self.declarenumB==7 then
		   self.declareitemN=value
		end
		self.povcodeSB=value 
   	scene:invalidate()
   end
	if id==self.povcodeAID then
		self.povcodeA=value 
   	scene:invalidate()
	elseif id==self.povcodeBID then
		self.povcodeB=value 
   	scene:invalidate()
	elseif id==self.povcodeCID then
		self.povcodeC=value 
   	scene:invalidate()
	elseif id==self.isomathID then
		self.isomath=value 
   	scene:invalidate()
   elseif id==self.boxcontainID then
      self.boxcontain=value
      self.spherecontain=nil
      scene:invalidate() 
      self:redraw()   
   elseif id==self.minboxxID then
      self.minx=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.minboxyID then
      self.miny=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.minboxzID then
      self.minz=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.maxboxxID then
      self.maxx=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.maxboxyID then
      self.maxy=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.maxboxzID then
      self.maxz=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.spherecontainID then
      self.boxcontain=nil
      self.spherecontain=value
      scene:invalidate()    
      self:redraw()   
   elseif id==self.xsphereID then
      self.xsphere=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.ysphereID then
      self.ysphere=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.zsphereID then
      self.zsphere=value
      scene:invalidate() 
      self:redraw()   
   elseif id==self.rsphereID then
      self.rsphere=value
      scene:invalidate() 
      self:redraw()   
	elseif id==self.thresholdID then
		self.threshold=value 
   	scene:invalidate()
	elseif id==self.accuracyID then
		self.accuracy=value 
   	scene:invalidate()
	elseif id==self.evalP0ID then
		self.evalP0=value 
   	scene:invalidate()
	elseif id==self.evalP1ID then
		self.evalP1=value 
   	scene:invalidate()
	elseif id==self.evalP2ID then
		self.evalP2=value 
   	scene:invalidate()
	elseif id==self.maxgradientID then
		self.maxgradient=value 
   	scene:invalidate()
	elseif id==self.openID then
		self.open=value 
   	scene:invalidate()
	elseif id==self.maxtraceID then
		self.maxtrace=value 
   	scene:invalidate()
	elseif id==self.allintID then
		self.allint=value 
   	scene:invalidate()
	elseif id==self.flagsID then
	   self.flags=value
	   if self.flags==1 then 
	      self.flagscheck=self.doubleilluminate
	   elseif self.flags==2 then 
	      self.flagscheck=self.hollow
	   elseif self.flags==3 then 
	      self.flagscheck=self.inverse
	   elseif self.flags==4 then 
	      self.flagscheck=self.noimage
	   elseif self.flags==5 then 
	      self.flagscheck=self.noreflection
	   elseif self.flags==6 then 
	      self.flagscheck=self.noshadow
      end
   	scene:invalidate()
	elseif id==self.flagscheckID then
	   self.flagscheck=value
	   if self.flags==1 then 
	      self.doubleilluminate=value
	   elseif self.flags==2 then 
	      self.hollow=value
	   elseif self.flags==3 then 
	      self.inverse=value
	   elseif self.flags==4 then 
	      self.noimage=value
	   elseif self.flags==5 then 
	      self.noreflection=value
	   elseif self.flags==6 then 
	      self.noshadow=value
      end
   	scene:invalidate()
	elseif id==self.photonsID then
	   self.photons=value
	   if self.photons==1 then 
	      self.photonscheck=self.collect
	   elseif self.photons==2 then 
	      self.photonscheck=self.passthrough
	   elseif self.photons==3 then 
	      self.photonscheck=self.reflection
	   elseif self.photons==4 then 
	      self.photonscheck=self.refraction
	   elseif self.photons==5 then 
	      self.photonscheck=self.target
      end
   	scene:invalidate()
	elseif id==self.photonscheckID then
	   self.photonscheck=value
	   if self.photons==1 then 
	      self.collect=value
	   elseif self.photons==2 then 
	      self.passthrough=value
	   elseif self.photons==3 then 
	      self.reflection=value
	   elseif self.photons==4 then 
	      self.refraction=value
	   elseif self.photons==5 then 
	      self.target=value
      end
   	scene:invalidate()
	elseif id==self.spacingmultiplierID then
	   self.spacingmultiplier=value
   	scene:invalidate()
	elseif id==self.mytextureID then
		self.mytexture=value 
   	scene:invalidate()
	elseif id==self.listoutputID then
      messageBox("List Isosurface output",self:listfunction(f,"plugin") )
	elseif id==self.aboutID then
      messageBox("About this plugin", "Isosurface plugin " ..self.pluginversion .."b"..self.copyright..self.howtouse)
	elseif id==self.textureID then
      self.texture=value 
      scene:invalidate()
	elseif id==self.viewdetailID then
		self.viewdetail=value
      self:redraw()
	end
end

function Isosurface:listfunction(f,option)
	local f
	f=""
   if self.declareitemA ~= "" then
      f=f.."#declare "..self.declareitemA.." ;\n"
   end
   if self.declareitemB ~= "" then
      f=f.."#declare "..self.declareitemB.." ;\n"
   end
   if self.declareitemC ~= "" then
      f=f.."#declare "..self.declareitemC.." ;\n"
   end
   if self.declareitemD ~= "" then
      f=f.."#declare "..self.declareitemD.." ;\n"
   end
   if self.declareitemE ~= "" then
      f=f.."#declare "..self.declareitemE.." ;\n"
   end
   if self.declareitemF ~= "" then
      f=f.."#declare "..self.declareitemF.." ;\n"
   end
   if self.declareitemG ~= "" then
      f=f.."#declare "..self.declareitemG.." ;\n"
   end
   if self.declareitemH ~= "" then
      f=f.."#declare "..self.declareitemH.." ;\n"
   end
   if self.declareitemI ~= "" then
      f=f.."#declare "..self.declareitemI.." ;\n"
   end
   if self.declareitemJ ~= "" then
      f=f.."#declare "..self.declareitemJ.." ;\n"
   end
   if self.declareitemK ~= "" then
      f=f.."#declare "..self.declareitemK.." ;\n"
   end
   if self.declareitemL ~= "" then
      f=f.."#declare "..self.declareitemL.." ;\n"
   end
   if self.declareitemM ~= "" then
      f=f.."#declare "..self.declareitemM.." ;\n"
   end
   if self.declareitemN ~= "" then
      f=f.."#declare "..self.declareitemN.." ;\n"
   end
   if self.povcodeA ~= "" then
      f=f.."#declare "..self.povcodeA.." ;\n"
   end
   if self.povcodeB ~= "" then
      f=f.."#declare "..self.povcodeB.." ;\n"
   end
   if self.povcodeC ~= "" then
      f=f.."#declare "..self.povcodeC.." ;\n"
   end
   f=f.."isosurface {\n"
      .."   function {\n"
      .."      "..self.isomath.."\n"
      .."   }\n"
   if self.boxcontain==1 then
      f=f.."   contained_by {box{<"..self.minx..","..self.miny..","..self.minz..">,<"..self.maxx..","..self.maxy..","..self.maxz..">}}\n"
   else
      f=f.."   contained_by {sphere{<"..self.xsphere..","..self.ysphere..","..self.zsphere..">,"..self.rsphere.."}}\n"
   end
   f=f.."   threshold " .. self.threshold.."\n"
   f=f.."   accuracy " .. self.accuracy.."\n"
   if self.maxgradient == 0 then
      f=f.."   evaluate "..self.evalP0..", "..self.evalP1..", "..self.evalP2.."\n"
      f=f.."   max_gradient 1\n"
   else
      f=f.."   max_gradient "..self.maxgradient.."\n"
   end     
   if self.open==1 then
      f=f.."   open\n"
   end
   if self.allint==1 then
      f=f.."   all_intersections\n"
   else
      f=f.."   max_trace "..self.maxtrace.."\n"
   end
   if self.noimage == 1 then
      f=f.."   no_image\n"
   end
   if self.noreflection == 1 then
      f=f.."   no_reflection\n"
   end
   if self.noshadow == 1 then
      f=f.."   no_shadow\n"
   end
   if self.doubleilluminate == 1 then
      f=f.."   double_illuminate\n"
   end
   if self.hollow == 1 then
      f=f.."   hollow\n"
   end
   if self.inverse == 1 then
      f=f.."   inverse\n"
   end
   if self.collect==nil or self.target==1 or self.passthrough==1 or self.reflection==1 or self.refraction==1 then  -- use photon{} if anything is different from default
      f=f.."   photons{\n"
      if self.collect==nil then
         f=f.."      collect off\n"
      end
      if self.target==1 then
         f=f.."      target "..self.spacingmultiplier.."\n"
      end
      if self.reflection==1 then
         f=f.."      reflection on\n"
      end
      if self.refraction==1 then
         f=f.."      refraction on\n"
      end
      if self.passthrough==1 then
         f=f.."      pass_through\n"
      end
      f=f.."   }\n"
   end
   if self.mytexture ~= "" then
      f=f..self.mytexture.."\n"
   elseif self.texture ~= "" then
      f=f.."material { "..gsub(self.texture,"%s","%_").." }\n"
   end
	if option=="plugin" then
	   f=f.."Transformation\n"
   	f=f.."} // end isosurface"
	elseif option=="pov" then
	end
	return f
end

function Isosurface:getInside(x,y,z)
	return nil
end

function Isosurface:wireframe(wire)  
   if self.boxcontain == 1 then
      if self.viewdetail <1 then -- no desplay
      elseif self.viewdetail ==1 then
         wire:line(self.minx,self.miny,self.minz,self.minx+(abs(self.maxx-self.minx)/10),self.miny,self.minz)
         wire:line(self.maxx-(abs(self.maxx-self.minx)/10),self.miny,self.minz,self.maxx,self.miny,self.minz)
         wire:line(self.minx,self.maxy,self.minz,self.minx+(abs(self.maxx-self.minx)/10),self.maxy,self.minz)
         wire:line(self.maxx-(abs(self.maxx-self.minx)/10),self.maxy,self.minz,self.maxx,self.maxy,self.minz)
         wire:line(self.minx,self.miny,self.maxz,self.minx+(abs(self.maxx-self.minx)/10),self.miny,self.maxz)
         wire:line(self.maxx-(abs(self.maxx-self.minx)/10),self.miny,self.maxz,self.maxx,self.miny,self.maxz)
         wire:line(self.minx,self.maxy,self.maxz,self.minx+(abs(self.maxx-self.minx)/10),self.maxy,self.maxz)
         wire:line(self.maxx-(abs(self.maxx-self.minx)/10),self.maxy,self.maxz,self.maxx,self.maxy,self.maxz)
         wire:line(self.minx,self.miny,self.minz,self.minx,self.miny+(abs(self.maxy-self.miny)/10),self.minz)
         wire:line(self.minx,self.maxy-(abs(self.maxy-self.miny)/10),self.minz,self.minx,self.maxy,self.minz)
         wire:line(self.maxx,self.miny,self.minz,self.maxx,self.miny+(abs(self.maxy-self.miny)/10),self.minz)
         wire:line(self.maxx,self.maxy-(abs(self.maxy-self.miny)/10),self.minz,self.maxx,self.maxy,self.minz)
         wire:line(self.minx,self.miny,self.maxz,self.minx,self.miny+(abs(self.maxx-self.minx)/10),self.maxz)
         wire:line(self.minx,self.maxy-(abs(self.maxy-self.miny)/10),self.maxz,self.minx,self.maxy,self.maxz)
         wire:line(self.maxx,self.miny,self.maxz,self.maxx,self.miny+(abs(self.maxy-self.miny)/10),self.maxz)
         wire:line(self.maxx,self.maxy-(abs(self.maxy-self.miny)/10),self.maxz,self.maxx,self.maxy,self.maxz)
         wire:line(self.minx,self.miny,self.minz,self.minx,self.miny,self.minz+(abs(self.maxz-self.minz)/10))
         wire:line(self.minx,self.miny,self.maxz-(abs(self.maxz-self.minz)/10),self.minx,self.miny,self.maxz)
         wire:line(self.minx,self.maxy,self.minz,self.minx,self.maxy,self.minz+(abs(self.maxz-self.minz)/10))
         wire:line(self.minx,self.maxy,self.maxz-(abs(self.maxz-self.minz)/10),self.minx,self.maxy,self.maxz)
         wire:line(self.maxx,self.miny,self.minz,self.maxx,self.miny,self.minz+(abs(self.maxz-self.minz)/10))
         wire:line(self.maxx,self.miny,self.maxz-(abs(self.maxz-self.minz)/10),self.maxx,self.miny,self.maxz)
         wire:line(self.maxx,self.maxy,self.minz,self.maxx,self.maxy,self.minz+(abs(self.maxz-self.minz)/10))
         wire:line(self.maxx,self.maxy,self.maxz-(abs(self.maxz-self.minz)/10),self.maxx,self.maxy,self.maxz)
      elseif self.viewdetail ==2 then
         wire:cube(self.minx,self.miny,self.minz,self.maxx,self.maxy,self.maxz)
      elseif self.viewdetail >=3 then
         wire:cube(self.minx,self.miny,self.minz,self.maxx,self.maxy,self.maxz)
      end
   else   
      if self.viewdetail <1 then -- no desplay
      elseif self.viewdetail ==1 then
         wire:circleX(self.xsphere,self.ysphere,self.zsphere,self.rsphere,350,10)
         wire:circleX(self.xsphere,self.ysphere,self.zsphere,self.rsphere,80,100)
         wire:circleX(self.xsphere,self.ysphere,self.zsphere,self.rsphere,170,190)
         wire:circleX(self.xsphere,self.ysphere,self.zsphere,self.rsphere,260,280)
         wire:circleY(self.xsphere,self.ysphere,self.zsphere,self.rsphere,350,10)
         wire:circleY(self.xsphere,self.ysphere,self.zsphere,self.rsphere,80,100)
         wire:circleY(self.xsphere,self.ysphere,self.zsphere,self.rsphere,170,190)
         wire:circleY(self.xsphere,self.ysphere,self.zsphere,self.rsphere,260,280)
         wire:circleZ(self.xsphere,self.ysphere,self.zsphere,self.rsphere,350,10)
         wire:circleZ(self.xsphere,self.ysphere,self.zsphere,self.rsphere,80,100)
         wire:circleZ(self.xsphere,self.ysphere,self.zsphere,self.rsphere,170,190)
         wire:circleZ(self.xsphere,self.ysphere,self.zsphere,self.rsphere,260,280)
      elseif self.viewdetail ==2 then
         wire:circleX(self.xsphere,self.ysphere,self.zsphere,self.rsphere,0,360)
         wire:circleY(self.xsphere,self.ysphere,self.zsphere,self.rsphere,0,360)
         wire:circleZ(self.xsphere,self.ysphere,self.zsphere,self.rsphere,0,360)
      elseif self.viewdetail >=3 then
         wire:sphere(self.xsphere,self.ysphere,self.zsphere,self.rsphere)
      end
   end 
end

function Isosurface:toPOV(pov)
   pov:write("// Isosurface plugin "..self.pluginversion.."beta by S. Shonfield, morayplugin@yahoo.ca")
      pov:write(self:listfunction(f,"pov"))
      pov:transforms(self.xforms) 
      pov:write("} // end isosurface")
end

registerClass(Isosurface,"Isosurface")

