// Parallel Lightsource

#declare LD = 10; //Length Distance
#declare RD = 5; //Radius Distance
#declare FD = 10; //Falloff Distance

#declare RA = degrees(asin(RD * sqrt( (RD*RD) + (LD*LD) ) ) ); //Radius Angle
#declare FA = degrees(asin(FD * sqrt( (FD*FD) + (LD*LD) ) ) ); //Falloff Angle

#declare Light_Color = rgb <0.500, 0.500, 1.000>

#declare Parallel_Spot =
	light_source {
		<0.000, 0.000, 0.000>
		color Light_Color
		parallel
		spotlight
		point_at <0.000, 0.000, -LD>
		falloff    FA  // outer radius (in deg)
		radius     RA  // inner radius
		tightness  10.000
}

#declare Parallel_Point =
	light_source {
		<0.000, 0.000, 0.000>
		color Light_Color
		parallel
		point_at <0.000, 0.000, -LD>
}
