//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 16 materials and 52 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/09/1999    (09.04.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -12.000,    -146.416,      66.279>
  direction <        0.0,         0.0,      1.5118> // Aperture is 0.64 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.257,      -1.556,      15.400>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <-42.732, 5.750, 59.977>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 1.0
}

light_source {   // Spotlight Spotlight001
  <5.838, 6.588, 31.380>
  color rgb <1.000, 1.000, 1.000>*1.8961
  spotlight
    point_at  <5.321, 6.588, 29.448>
    falloff    86.220  // outer radius (in deg)
    radius     84.831  // inner radius
    tightness  0.000
}


//
// ********  MATERIALS  *******
//

#include "desk.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

union { // Monitor
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      ComputerWhite
    }
    scale <3.0, 3.0, 1.0>
    translate  <20.067457, -1.625539, 23.597206>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      ComputerWhite
    }
    scale <4.0, 4.0, 1.0>
    rotate -35.0*z
    translate  <19.999631, -1.755372, 22.535299>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      ComputerWhite
    }
    scale 5.0
    rotate <-5.0, 0.0, -35.0>
    translate  <23.170949, 2.84263, 32.733641>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      ComputerWhite
    }
    scale <8.0, 4.0, 8.0>
    rotate <-5.0, 0.0, -35.0>
    translate  <18.234652, -4.499502, 32.933098>
  }
}


union { // FloorLamp
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      ColorBlack1
    }
    scale <1.0, 1.0, 50.0>
    translate  <-42.820085, 5.716683, 2.091603>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      ColorBlack1
    }
    scale <8.0, 8.0, 3.0>
    rotate 180.0*x
    translate  <-42.772058, 5.689388, 3.121062>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      ColorBlack1
    }
    scale <3.0, 3.0, 4.0>
    translate  <-42.772058, 5.689388, 50.774367>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      ColorBlack1
    }
    scale <0.2, 0.2, 4.0>
    translate  <-40.437665, 6.596172, 54.582101>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    material {
      ColorBlack
    }
    scale <12.0, 12.0, 3.0>
    rotate -180.0*x
    translate  <-42.772058, 5.689388, 61.167378>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      ColorBlack1
    }
    scale <0.2, 0.2, 4.0>
    translate  <-45.178633, 6.596172, 54.582101>
  }
}


union { // Walls_and_Floor
  plane { // Plane001
    z,0
    material {
      Grass1
    }
    scale <9999999.0, 2147483648.0, 0.00001>
  }
  plane { // Plane002
    z,0
    material {
      Maple
    }
    scale <2147483648.0, 2147483648.0, 0.00001>
    rotate -90.0*x
    translate  <0.0, 16.380724, -0.356103>
  }
  plane { // Plane003
    z,0
    material {
      Maple
    }
    scale <2147483648.0, 2147483648.0, 0.00001>
    rotate <-90.0, 0.0, -90.0>
    translate  <32.768453, 16.380724, -0.356103>
  }
  plane { // Plane004
    z,0
    material {
      ColorWhite
    }
    scale <9999999.0, 2147483648.0, 0.00001>
    translate  79.154067*z
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      Carribean_Cloud_Sky
    }
    scale <14.0, 14.0, 1.0>
    rotate -90.0*y
    translate  <33.52675, -10.429534, 41.336013>
  }
}


box { // Cube014
  <-1, -1, -1>, <1, 1, 1>
  material {
    ComputerWhite
  }
  scale <10.0, 4.0, 8.0>
  translate  <-21.892115, 10.861132, 29.230832>
}


#declare CSG001 = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    scale <0.5, 0.5, 5.0>
    rotate <90.0, -90.0, 0.0>
    translate  <25.796442, -16.558775, 15.857575>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    scale <0.5, 0.5, 5.0>
    rotate <90.0, -90.0, 0.0>
    translate  <21.055474, -16.558775, 15.857575>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    scale <0.5, 0.5, 5.0>
    rotate <90.0, -90.0, 0.0>
    translate  <25.378121, -16.558775, 10.698286>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    scale <0.5, 0.5, 5.0>
    rotate <90.0, -90.0, 0.0>
    translate  <21.055474, -16.558775, 10.698286>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    scale <0.5, 0.5, 5.0>
    rotate <0.0, -90.0, 0.0>
    translate  <25.796442, -21.366162, 15.857575>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome
    }
    scale <0.5, 0.5, 5.0>
    rotate <0.0, -90.0, 0.0>
    translate  <25.796442, -21.544213, 10.694085>
  }
  material {
    Chrome
  }
  translate  <0.0, 4.273232, -2.136616>
}
union { // Desk
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      ColorBlack
    }
    scale <6.0, 15.0, 8.0>
    translate  <23.147077, -0.356103, 11.155218>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <1.0, 1.0, 10.0>
    translate  <-30.072479, -14.397018, 9.792824>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <1.0, 1.0, 10.0>
    translate  <-30.072479, 14.218967, 9.792824>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <1.0, 1.0, 10.0>
    translate  <30.275672, 14.218967, 9.792824>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <1.0, 1.0, 10.0>
    translate  <30.275672, -14.481447, 9.792824>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      ColorBlack
    }
    scale <23.0, 15.0, 2.0>
    translate  <-5.99593, -0.356103, 17.151148>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFDarkOak
    }
    scale <32.0, 16.0, 1.0>
    translate  <0.0, -0.178051, 20.297854>
  }
  object { CSG001 }
}


#declare DomeFace1 = mesh {
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.079375, 0.000135, 0.997158> }
triangle { <0.079375, 0.000135, 0.997158>, <0.078459, 0.000000, 0.996917>, <0.000000, 0.000000, 1.000000> }
triangle { <0.078459, 0.000000, 0.996917>, <0.079375, 0.000135, 0.997158>, <0.158261, 0.000270, 0.988651> }
triangle { <0.158261, 0.000270, 0.988651>, <0.156434, 0.000000, 0.987688>, <0.078459, 0.000000, 0.996917> }
triangle { <0.156434, 0.000000, 0.987688>, <0.158261, 0.000270, 0.988651>, <0.236171, 0.000402, 0.974531> }
triangle { <0.236171, 0.000402, 0.974531>, <0.233445, 0.000000, 0.972370>, <0.156434, 0.000000, 0.987688> }
triangle { <0.233445, 0.000000, 0.972370>, <0.236171, 0.000402, 0.974531>, <0.312625, 0.000533, 0.954885> }
triangle { <0.312625, 0.000533, 0.954885>, <0.309017, 0.000000, 0.951057>, <0.233445, 0.000000, 0.972370> }
triangle { <0.309017, 0.000000, 0.951057>, <0.312625, 0.000533, 0.954885>, <0.387152, 0.000660, 0.929833> }
triangle { <0.387152, 0.000660, 0.929833>, <0.382683, 0.000000, 0.923880>, <0.309017, 0.000000, 0.951057> }
triangle { <0.382683, 0.000000, 0.923880>, <0.387152, 0.000660, 0.929833>, <0.459292, 0.000783, 0.899532> }
triangle { <0.459292, 0.000783, 0.899532>, <0.453990, 0.000000, 0.891007>, <0.382683, 0.000000, 0.923880> }
triangle { <0.453990, 0.000000, 0.891007>, <0.459292, 0.000783, 0.899532>, <0.528600, 0.000901, 0.864166> }
triangle { <0.528600, 0.000901, 0.864166>, <0.522499, 0.000000, 0.852640>, <0.453990, 0.000000, 0.891007> }
triangle { <0.522499, 0.000000, 0.852640>, <0.528600, 0.000901, 0.864166>, <0.594649, 0.001013, 0.823955> }
triangle { <0.594649, 0.001013, 0.823955>, <0.587785, 0.000000, 0.809017>, <0.522499, 0.000000, 0.852640> }
triangle { <0.587785, 0.000000, 0.809017>, <0.594649, 0.001013, 0.823955>, <0.657032, 0.001119, 0.779146> }
triangle { <0.657032, 0.001119, 0.779146>, <0.649448, 0.000000, 0.760406>, <0.587785, 0.000000, 0.809017> }
triangle { <0.649448, 0.000000, 0.760406>, <0.657032, 0.001119, 0.779146>, <0.715364, 0.001219, 0.730016> }
triangle { <0.715364, 0.001219, 0.730016>, <0.707107, 0.000000, 0.707107>, <0.649448, 0.000000, 0.760406> }
triangle { <0.707107, 0.000000, 0.707107>, <0.715364, 0.001219, 0.730016>, <0.769285, 0.001311, 0.676867> }
triangle { <0.769285, 0.001311, 0.676867>, <0.760406, 0.000000, 0.649448>, <0.707107, 0.000000, 0.707107> }
triangle { <0.760406, 0.000000, 0.649448>, <0.769285, 0.001311, 0.676867>, <0.818464, 0.001395, 0.620028> }
triangle { <0.818464, 0.001395, 0.620028>, <0.809017, 0.000000, 0.587785>, <0.760406, 0.000000, 0.649448> }
triangle { <0.809017, 0.000000, 0.587785>, <0.818464, 0.001395, 0.620028>, <0.862596, 0.001470, 0.559847> }
triangle { <0.862596, 0.001470, 0.559847>, <0.852640, 0.000000, 0.522499>, <0.809017, 0.000000, 0.587785> }
triangle { <0.852640, 0.000000, 0.522499>, <0.862596, 0.001470, 0.559847>, <0.901411, 0.001536, 0.496698> }
triangle { <0.901411, 0.001536, 0.496698>, <0.891007, 0.000000, 0.453990>, <0.852640, 0.000000, 0.522499> }
triangle { <0.891007, 0.000000, 0.453990>, <0.901411, 0.001536, 0.496698>, <0.934667, 0.001593, 0.430968> }
triangle { <0.934667, 0.001593, 0.430968>, <0.923880, 0.000000, 0.382683>, <0.891007, 0.000000, 0.453990> }
triangle { <0.923880, 0.000000, 0.382683>, <0.934667, 0.001593, 0.430968>, <0.962162, 0.001639, 0.363064> }
triangle { <0.962162, 0.001639, 0.363064>, <0.951057, 0.000000, 0.309017>, <0.923880, 0.000000, 0.382683> }
triangle { <0.951057, 0.000000, 0.309017>, <0.962162, 0.001639, 0.363064>, <0.983724, 0.001676, 0.293403> }
triangle { <0.983724, 0.001676, 0.293403>, <0.972370, 0.000000, 0.233445>, <0.951057, 0.000000, 0.309017> }
triangle { <0.972370, 0.000000, 0.233445>, <0.983724, 0.001676, 0.293403>, <0.999221, 0.001702, 0.222416> }
triangle { <0.999221, 0.001702, 0.222416>, <0.987688, 0.000000, 0.156434>, <0.972370, 0.000000, 0.233445> }
triangle { <0.987688, 0.000000, 0.156434>, <0.999221, 0.001702, 0.222416>, <1.008558, 0.001718, 0.150539> }
triangle { <1.008558, 0.001718, 0.150539>, <0.996917, 0.000000, 0.078459>, <0.987688, 0.000000, 0.156434> }
triangle { <0.996917, 0.000000, 0.078459>, <1.008558, 0.001718, 0.150539>, <1.011677, 0.001724, 0.078217> }
triangle { <1.011677, 0.001724, 0.078217>, <1.000000, 0.000000, -0.000000>, <0.996917, 0.000000, 0.078459> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.081970, 0.001058, 0.997394> }
triangle { <0.081970, 0.001058, 0.997394>, <0.079375, 0.000135, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <0.079375, 0.000135, 0.997158>, <0.081970, 0.001058, 0.997394>, <0.163434, 0.002110, 0.989591> }
triangle { <0.163434, 0.002110, 0.989591>, <0.158261, 0.000270, 0.988651>, <0.079375, 0.000135, 0.997158> }
triangle { <0.158261, 0.000270, 0.988651>, <0.163434, 0.002110, 0.989591>, <0.243891, 0.003149, 0.976639> }
triangle { <0.243891, 0.003149, 0.976639>, <0.236171, 0.000402, 0.974531>, <0.158261, 0.000270, 0.988651> }
triangle { <0.236171, 0.000402, 0.974531>, <0.243891, 0.003149, 0.976639>, <0.322844, 0.004169, 0.958619> }
triangle { <0.322844, 0.004169, 0.958619>, <0.312625, 0.000533, 0.954885>, <0.236171, 0.000402, 0.974531> }
triangle { <0.312625, 0.000533, 0.954885>, <0.322844, 0.004169, 0.958619>, <0.399806, 0.005163, 0.935641> }
triangle { <0.399806, 0.005163, 0.935641>, <0.387152, 0.000660, 0.929833>, <0.312625, 0.000533, 0.954885> }
triangle { <0.387152, 0.000660, 0.929833>, <0.399806, 0.005163, 0.935641>, <0.474304, 0.006125, 0.907847> }
triangle { <0.474304, 0.006125, 0.907847>, <0.459292, 0.000783, 0.899532>, <0.387152, 0.000660, 0.929833> }
triangle { <0.459292, 0.000783, 0.899532>, <0.474304, 0.006125, 0.907847>, <0.545877, 0.007049, 0.875409> }
triangle { <0.545877, 0.007049, 0.875409>, <0.528600, 0.000901, 0.864166>, <0.459292, 0.000783, 0.899532> }
triangle { <0.528600, 0.000901, 0.864166>, <0.545877, 0.007049, 0.875409>, <0.614085, 0.007929, 0.838525> }
triangle { <0.614085, 0.007929, 0.838525>, <0.594649, 0.001013, 0.823955>, <0.528600, 0.000901, 0.864166> }
triangle { <0.594649, 0.001013, 0.823955>, <0.614085, 0.007929, 0.838525>, <0.678507, 0.008761, 0.797425> }
triangle { <0.678507, 0.008761, 0.797425>, <0.657032, 0.001119, 0.779146>, <0.594649, 0.001013, 0.823955> }
triangle { <0.657032, 0.001119, 0.779146>, <0.678507, 0.008761, 0.797425>, <0.738746, 0.009539, 0.752361> }
triangle { <0.738746, 0.009539, 0.752361>, <0.715364, 0.001219, 0.730016>, <0.657032, 0.001119, 0.779146> }
triangle { <0.715364, 0.001219, 0.730016>, <0.738746, 0.009539, 0.752361>, <0.794430, 0.010258, 0.703611> }
triangle { <0.794430, 0.010258, 0.703611>, <0.769285, 0.001311, 0.676867>, <0.715364, 0.001219, 0.730016> }
triangle { <0.769285, 0.001311, 0.676867>, <0.794430, 0.010258, 0.703611>, <0.845216, 0.010914, 0.651476> }
triangle { <0.845216, 0.010914, 0.651476>, <0.818464, 0.001395, 0.620028>, <0.769285, 0.001311, 0.676867> }
triangle { <0.818464, 0.001395, 0.620028>, <0.845216, 0.010914, 0.651476>, <0.890791, 0.011503, 0.596277> }
triangle { <0.890791, 0.011503, 0.596277>, <0.862596, 0.001470, 0.559847>, <0.818464, 0.001395, 0.620028> }
triangle { <0.862596, 0.001470, 0.559847>, <0.890791, 0.011503, 0.596277>, <0.930874, 0.012020, 0.538354> }
triangle { <0.930874, 0.012020, 0.538354>, <0.901411, 0.001536, 0.496698>, <0.862596, 0.001470, 0.559847> }
triangle { <0.901411, 0.001536, 0.496698>, <0.930874, 0.012020, 0.538354>, <0.965218, 0.012464, 0.478064> }
triangle { <0.965218, 0.012464, 0.478064>, <0.934667, 0.001593, 0.430968>, <0.901411, 0.001536, 0.496698> }
triangle { <0.934667, 0.001593, 0.430968>, <0.965218, 0.012464, 0.478064>, <0.993611, 0.012830, 0.415780> }
triangle { <0.993611, 0.012830, 0.415780>, <0.962162, 0.001639, 0.363064>, <0.934667, 0.001593, 0.430968> }
triangle { <0.962162, 0.001639, 0.363064>, <0.993611, 0.012830, 0.415780>, <1.015878, 0.013118, 0.351885> }
triangle { <1.015878, 0.013118, 0.351885>, <0.983724, 0.001676, 0.293403>, <0.962162, 0.001639, 0.363064> }
triangle { <0.983724, 0.001676, 0.293403>, <1.015878, 0.013118, 0.351885>, <1.031881, 0.013324, 0.286773> }
triangle { <1.031881, 0.013324, 0.286773>, <0.999221, 0.001702, 0.222416>, <0.983724, 0.001676, 0.293403> }
triangle { <0.999221, 0.001702, 0.222416>, <1.031881, 0.013324, 0.286773>, <1.041523, 0.013449, 0.220845> }
triangle { <1.041523, 0.013449, 0.220845>, <1.008558, 0.001718, 0.150539>, <0.999221, 0.001702, 0.222416> }
triangle { <1.008558, 0.001718, 0.150539>, <1.041523, 0.013449, 0.220845>, <1.044744, 0.013490, 0.154508> }
triangle { <1.044744, 0.013490, 0.154508>, <1.011677, 0.001724, 0.078217>, <1.008558, 0.001718, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.085802, 0.003444, 0.997617> }
triangle { <0.085802, 0.003444, 0.997617>, <0.081970, 0.001058, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <0.081970, 0.001058, 0.997394>, <0.085802, 0.003444, 0.997617>, <0.171075, 0.006866, 0.990483> }
triangle { <0.171075, 0.006866, 0.990483>, <0.163434, 0.002110, 0.989591>, <0.081970, 0.001058, 0.997394> }
triangle { <0.163434, 0.002110, 0.989591>, <0.171075, 0.006866, 0.990483>, <0.255293, 0.010246, 0.978642> }
triangle { <0.255293, 0.010246, 0.978642>, <0.243891, 0.003149, 0.976639>, <0.163434, 0.002110, 0.989591> }
triangle { <0.243891, 0.003149, 0.976639>, <0.255293, 0.010246, 0.978642>, <0.337938, 0.013563, 0.962166> }
triangle { <0.337938, 0.013563, 0.962166>, <0.322844, 0.004169, 0.958619>, <0.243891, 0.003149, 0.976639> }
triangle { <0.322844, 0.004169, 0.958619>, <0.337938, 0.013563, 0.962166>, <0.418498, 0.016797, 0.941159> }
triangle { <0.418498, 0.016797, 0.941159>, <0.399806, 0.005163, 0.935641>, <0.322844, 0.004169, 0.958619> }
triangle { <0.399806, 0.005163, 0.935641>, <0.418498, 0.016797, 0.941159>, <0.496479, 0.019927, 0.915748> }
triangle { <0.496479, 0.019927, 0.915748>, <0.474304, 0.006125, 0.907847>, <0.399806, 0.005163, 0.935641> }
triangle { <0.474304, 0.006125, 0.907847>, <0.496479, 0.019927, 0.915748>, <0.571399, 0.022934, 0.886090> }
triangle { <0.571399, 0.022934, 0.886090>, <0.545877, 0.007049, 0.875409>, <0.474304, 0.006125, 0.907847> }
triangle { <0.545877, 0.007049, 0.875409>, <0.571399, 0.022934, 0.886090>, <0.642795, 0.025799, 0.852369> }
triangle { <0.642795, 0.025799, 0.852369>, <0.614085, 0.007929, 0.838525>, <0.545877, 0.007049, 0.875409> }
triangle { <0.614085, 0.007929, 0.838525>, <0.642795, 0.025799, 0.852369>, <0.710229, 0.028506, 0.814793> }
triangle { <0.710229, 0.028506, 0.814793>, <0.678507, 0.008761, 0.797425>, <0.614085, 0.007929, 0.838525> }
triangle { <0.678507, 0.008761, 0.797425>, <0.710229, 0.028506, 0.814793>, <0.773284, 0.031036, 0.773592> }
triangle { <0.773284, 0.031036, 0.773592>, <0.738746, 0.009539, 0.752361>, <0.678507, 0.008761, 0.797425> }
triangle { <0.738746, 0.009539, 0.752361>, <0.773284, 0.031036, 0.773592>, <0.831571, 0.033376, 0.729022> }
triangle { <0.831571, 0.033376, 0.729022>, <0.794430, 0.010258, 0.703611>, <0.738746, 0.009539, 0.752361> }
triangle { <0.794430, 0.010258, 0.703611>, <0.831571, 0.033376, 0.729022>, <0.884732, 0.035510, 0.681356> }
triangle { <0.884732, 0.035510, 0.681356>, <0.845216, 0.010914, 0.651476>, <0.794430, 0.010258, 0.703611> }
triangle { <0.845216, 0.010914, 0.651476>, <0.884732, 0.035510, 0.681356>, <0.932438, 0.037424, 0.630889> }
triangle { <0.932438, 0.037424, 0.630889>, <0.890791, 0.011503, 0.596277>, <0.845216, 0.010914, 0.651476> }
triangle { <0.890791, 0.011503, 0.596277>, <0.932438, 0.037424, 0.630889>, <0.974395, 0.039108, 0.577932> }
triangle { <0.974395, 0.039108, 0.577932>, <0.930874, 0.012020, 0.538354>, <0.890791, 0.011503, 0.596277> }
triangle { <0.930874, 0.012020, 0.538354>, <0.974395, 0.039108, 0.577932>, <1.010344, 0.040551, 0.522811> }
triangle { <1.010344, 0.040551, 0.522811>, <0.965218, 0.012464, 0.478064>, <0.930874, 0.012020, 0.538354> }
triangle { <0.965218, 0.012464, 0.478064>, <1.010344, 0.040551, 0.522811>, <1.040065, 0.041744, 0.465867> }
triangle { <1.040065, 0.041744, 0.465867>, <0.993611, 0.012830, 0.415780>, <0.965218, 0.012464, 0.478064> }
triangle { <0.993611, 0.012830, 0.415780>, <1.040065, 0.041744, 0.465867>, <1.063373, 0.042679, 0.407450> }
triangle { <1.063373, 0.042679, 0.407450>, <1.015878, 0.013118, 0.351885>, <0.993611, 0.012830, 0.415780> }
triangle { <1.015878, 0.013118, 0.351885>, <1.063373, 0.042679, 0.407450>, <1.080125, 0.043352, 0.347920> }
triangle { <1.080125, 0.043352, 0.347920>, <1.031881, 0.013324, 0.286773>, <1.015878, 0.013118, 0.351885> }
triangle { <1.031881, 0.013324, 0.286773>, <1.080125, 0.043352, 0.347920>, <1.090218, 0.043757, 0.287645> }
triangle { <1.090218, 0.043757, 0.287645>, <1.041523, 0.013449, 0.220845>, <1.031881, 0.013324, 0.286773> }
triangle { <1.041523, 0.013449, 0.220845>, <1.090218, 0.043757, 0.287645>, <1.093589, 0.043892, 0.226995> }
triangle { <1.093589, 0.043892, 0.226995>, <1.044744, 0.013490, 0.154508>, <1.041523, 0.013449, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.090208, 0.007754, 0.997823> }
triangle { <0.090208, 0.007754, 0.997823>, <0.085802, 0.003444, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <0.085802, 0.003444, 0.997617>, <0.090208, 0.007754, 0.997823>, <0.179859, 0.015459, 0.991307> }
triangle { <0.179859, 0.015459, 0.991307>, <0.171075, 0.006866, 0.990483>, <0.085802, 0.003444, 0.997617> }
triangle { <0.171075, 0.006866, 0.990483>, <0.179859, 0.015459, 0.991307>, <0.268402, 0.023070, 0.980490> }
triangle { <0.268402, 0.023070, 0.980490>, <0.255293, 0.010246, 0.978642>, <0.171075, 0.006866, 0.990483> }
triangle { <0.255293, 0.010246, 0.978642>, <0.268402, 0.023070, 0.980490>, <0.355290, 0.030538, 0.965441> }
triangle { <0.355290, 0.030538, 0.965441>, <0.337938, 0.013563, 0.962166>, <0.255293, 0.010246, 0.978642> }
triangle { <0.337938, 0.013563, 0.962166>, <0.355290, 0.030538, 0.965441>, <0.439987, 0.037818, 0.946251> }
triangle { <0.439987, 0.037818, 0.946251>, <0.418498, 0.016797, 0.941159>, <0.337938, 0.013563, 0.962166> }
triangle { <0.418498, 0.016797, 0.941159>, <0.439987, 0.037818, 0.946251>, <0.521972, 0.044864, 0.923039> }
triangle { <0.521972, 0.044864, 0.923039>, <0.496479, 0.019927, 0.915748>, <0.418498, 0.016797, 0.941159> }
triangle { <0.496479, 0.019927, 0.915748>, <0.521972, 0.044864, 0.923039>, <0.600738, 0.051635, 0.895948> }
triangle { <0.600738, 0.051635, 0.895948>, <0.571399, 0.022934, 0.886090>, <0.496479, 0.019927, 0.915748> }
triangle { <0.571399, 0.022934, 0.886090>, <0.600738, 0.051635, 0.895948>, <0.675801, 0.058086, 0.865145> }
triangle { <0.675801, 0.058086, 0.865145>, <0.642795, 0.025799, 0.852369>, <0.571399, 0.022934, 0.886090> }
triangle { <0.642795, 0.025799, 0.852369>, <0.675801, 0.058086, 0.865145>, <0.746697, 0.064180, 0.830821> }
triangle { <0.746697, 0.064180, 0.830821>, <0.710229, 0.028506, 0.814793>, <0.642795, 0.025799, 0.852369> }
triangle { <0.710229, 0.028506, 0.814793>, <0.746697, 0.064180, 0.830821>, <0.812990, 0.069878, 0.793186> }
triangle { <0.812990, 0.069878, 0.793186>, <0.773284, 0.031036, 0.773592>, <0.710229, 0.028506, 0.814793> }
triangle { <0.773284, 0.031036, 0.773592>, <0.812990, 0.069878, 0.793186>, <0.874270, 0.075145, 0.752473> }
triangle { <0.874270, 0.075145, 0.752473>, <0.831571, 0.033376, 0.729022>, <0.773284, 0.031036, 0.773592> }
triangle { <0.831571, 0.033376, 0.729022>, <0.874270, 0.075145, 0.752473>, <0.930161, 0.079949, 0.708932> }
triangle { <0.930161, 0.079949, 0.708932>, <0.884732, 0.035510, 0.681356>, <0.831571, 0.033376, 0.729022> }
triangle { <0.884732, 0.035510, 0.681356>, <0.930161, 0.079949, 0.708932>, <0.980316, 0.084260, 0.662833> }
triangle { <0.980316, 0.084260, 0.662833>, <0.932438, 0.037424, 0.630889>, <0.884732, 0.035510, 0.681356> }
triangle { <0.932438, 0.037424, 0.630889>, <0.980316, 0.084260, 0.662833>, <1.024427, 0.088052, 0.614459> }
triangle { <1.024427, 0.088052, 0.614459>, <0.974395, 0.039108, 0.577932>, <0.932438, 0.037424, 0.630889> }
triangle { <0.974395, 0.039108, 0.577932>, <1.024427, 0.088052, 0.614459>, <1.062223, 0.091300, 0.564108> }
triangle { <1.062223, 0.091300, 0.564108>, <1.010344, 0.040551, 0.522811>, <0.974395, 0.039108, 0.577932> }
triangle { <1.010344, 0.040551, 0.522811>, <1.062223, 0.091300, 0.564108>, <1.093469, 0.093986, 0.512092> }
triangle { <1.093469, 0.093986, 0.512092>, <1.040065, 0.041744, 0.465867>, <1.010344, 0.040551, 0.522811> }
triangle { <1.040065, 0.041744, 0.465867>, <1.093469, 0.093986, 0.512092>, <1.117974, 0.096092, 0.458730> }
triangle { <1.117974, 0.096092, 0.458730>, <1.063373, 0.042679, 0.407450>, <1.040065, 0.041744, 0.465867> }
triangle { <1.063373, 0.042679, 0.407450>, <1.117974, 0.096092, 0.458730>, <1.135586, 0.097606, 0.404352> }
triangle { <1.135586, 0.097606, 0.404352>, <1.080125, 0.043352, 0.347920>, <1.063373, 0.042679, 0.407450> }
triangle { <1.080125, 0.043352, 0.347920>, <1.135586, 0.097606, 0.404352>, <1.146197, 0.098518, 0.349293> }
triangle { <1.146197, 0.098518, 0.349293>, <1.090218, 0.043757, 0.287645>, <1.080125, 0.043352, 0.347920> }
triangle { <1.090218, 0.043757, 0.287645>, <1.146197, 0.098518, 0.349293>, <1.149742, 0.098823, 0.293893> }
triangle { <1.149742, 0.098823, 0.293893>, <1.093589, 0.043892, 0.226995>, <1.090218, 0.043757, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.094392, 0.014170, 0.998007> }
triangle { <0.094392, 0.014170, 0.998007>, <0.090208, 0.007754, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <0.090208, 0.007754, 0.997823>, <0.094392, 0.014170, 0.998007>, <0.188202, 0.028253, 0.992041> }
triangle { <0.188202, 0.028253, 0.992041>, <0.179859, 0.015459, 0.991307>, <0.090208, 0.007754, 0.997823> }
triangle { <0.179859, 0.015459, 0.991307>, <0.188202, 0.028253, 0.992041>, <0.280851, 0.042162, 0.982139> }
triangle { <0.280851, 0.042162, 0.982139>, <0.268402, 0.023070, 0.980490>, <0.179859, 0.015459, 0.991307> }
triangle { <0.268402, 0.023070, 0.980490>, <0.280851, 0.042162, 0.982139>, <0.371769, 0.055811, 0.968361> }
triangle { <0.371769, 0.055811, 0.968361>, <0.355290, 0.030538, 0.965441>, <0.268402, 0.023070, 0.980490> }
triangle { <0.355290, 0.030538, 0.965441>, <0.371769, 0.055811, 0.968361>, <0.460395, 0.069116, 0.950792> }
triangle { <0.460395, 0.069116, 0.950792>, <0.439987, 0.037818, 0.946251>, <0.355290, 0.030538, 0.965441> }
triangle { <0.439987, 0.037818, 0.946251>, <0.460395, 0.069116, 0.950792>, <0.546183, 0.081995, 0.929542> }
triangle { <0.546183, 0.081995, 0.929542>, <0.521972, 0.044864, 0.923039>, <0.439987, 0.037818, 0.946251> }
triangle { <0.521972, 0.044864, 0.923039>, <0.546183, 0.081995, 0.929542>, <0.628603, 0.094368, 0.904740> }
triangle { <0.628603, 0.094368, 0.904740>, <0.600738, 0.051635, 0.895948>, <0.521972, 0.044864, 0.923039> }
triangle { <0.600738, 0.051635, 0.895948>, <0.628603, 0.094368, 0.904740>, <0.707148, 0.106159, 0.876540> }
triangle { <0.707148, 0.106159, 0.876540>, <0.675801, 0.058086, 0.865145>, <0.600738, 0.051635, 0.895948> }
triangle { <0.675801, 0.058086, 0.865145>, <0.707148, 0.106159, 0.876540>, <0.781332, 0.117296, 0.845115> }
triangle { <0.781332, 0.117296, 0.845115>, <0.746697, 0.064180, 0.830821>, <0.675801, 0.058086, 0.865145> }
triangle { <0.746697, 0.064180, 0.830821>, <0.781332, 0.117296, 0.845115>, <0.850700, 0.127710, 0.810660> }
triangle { <0.850700, 0.127710, 0.810660>, <0.812990, 0.069878, 0.793186>, <0.746697, 0.064180, 0.830821> }
triangle { <0.812990, 0.069878, 0.793186>, <0.850700, 0.127710, 0.810660>, <0.914823, 0.137336, 0.773387> }
triangle { <0.914823, 0.137336, 0.773387>, <0.874270, 0.075145, 0.752473>, <0.812990, 0.069878, 0.793186> }
triangle { <0.874270, 0.075145, 0.752473>, <0.914823, 0.137336, 0.773387>, <0.973305, 0.146116, 0.733525> }
triangle { <0.973305, 0.146116, 0.733525>, <0.930161, 0.079949, 0.708932>, <0.874270, 0.075145, 0.752473> }
triangle { <0.930161, 0.079949, 0.708932>, <0.973305, 0.146116, 0.733525>, <1.025787, 0.153995, 0.691321> }
triangle { <1.025787, 0.153995, 0.691321>, <0.980316, 0.084260, 0.662833>, <0.930161, 0.079949, 0.708932> }
triangle { <0.980316, 0.084260, 0.662833>, <1.025787, 0.153995, 0.691321>, <1.071944, 0.160924, 0.647034> }
triangle { <1.071944, 0.160924, 0.647034>, <1.024427, 0.088052, 0.614459>, <0.980316, 0.084260, 0.662833> }
triangle { <1.024427, 0.088052, 0.614459>, <1.071944, 0.160924, 0.647034>, <1.111493, 0.166861, 0.600938> }
triangle { <1.111493, 0.166861, 0.600938>, <1.062223, 0.091300, 0.564108>, <1.024427, 0.088052, 0.614459> }
triangle { <1.062223, 0.091300, 0.564108>, <1.111493, 0.166861, 0.600938>, <1.144189, 0.171769, 0.553316> }
triangle { <1.144189, 0.171769, 0.553316>, <1.093469, 0.093986, 0.512092>, <1.062223, 0.091300, 0.564108> }
triangle { <1.093469, 0.093986, 0.512092>, <1.144189, 0.171769, 0.553316>, <1.169830, 0.175619, 0.504463> }
triangle { <1.169830, 0.175619, 0.504463>, <1.117974, 0.096092, 0.458730>, <1.093469, 0.093986, 0.512092> }
triangle { <1.117974, 0.096092, 0.458730>, <1.169830, 0.175619, 0.504463>, <1.188259, 0.178385, 0.454680> }
triangle { <1.188259, 0.178385, 0.454680>, <1.135586, 0.097606, 0.404352>, <1.117974, 0.096092, 0.458730> }
triangle { <1.135586, 0.097606, 0.404352>, <1.188259, 0.178385, 0.454680>, <1.199363, 0.180052, 0.404273> }
triangle { <1.199363, 0.180052, 0.404273>, <1.146197, 0.098518, 0.349293>, <1.135586, 0.097606, 0.404352> }
triangle { <1.146197, 0.098518, 0.349293>, <1.199363, 0.180052, 0.404273>, <1.203071, 0.180609, 0.353553> }
triangle { <1.203071, 0.180609, 0.353553>, <1.149742, 0.098823, 0.293893>, <1.146197, 0.098518, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.097542, 0.022569, 0.998164> }
triangle { <0.097542, 0.022569, 0.998164>, <0.094392, 0.014170, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <0.094392, 0.014170, 0.998007>, <0.097542, 0.022569, 0.998164>, <0.194482, 0.044998, 0.992669> }
triangle { <0.194482, 0.044998, 0.992669>, <0.188202, 0.028253, 0.992041>, <0.094392, 0.014170, 0.998007> }
triangle { <0.188202, 0.028253, 0.992041>, <0.194482, 0.044998, 0.992669>, <0.290223, 0.067150, 0.983547> }
triangle { <0.290223, 0.067150, 0.983547>, <0.280851, 0.042162, 0.982139>, <0.188202, 0.028253, 0.992041> }
triangle { <0.280851, 0.042162, 0.982139>, <0.290223, 0.067150, 0.983547>, <0.384175, 0.088888, 0.970855> }
triangle { <0.384175, 0.088888, 0.970855>, <0.371769, 0.055811, 0.968361>, <0.280851, 0.042162, 0.982139> }
triangle { <0.371769, 0.055811, 0.968361>, <0.384175, 0.088888, 0.970855>, <0.475758, 0.110078, 0.954671> }
triangle { <0.475758, 0.110078, 0.954671>, <0.460395, 0.069116, 0.950792>, <0.371769, 0.055811, 0.968361> }
triangle { <0.460395, 0.069116, 0.950792>, <0.475758, 0.110078, 0.954671>, <0.564409, 0.130589, 0.935095> }
triangle { <0.564409, 0.130589, 0.935095>, <0.546183, 0.081995, 0.929542>, <0.460395, 0.069116, 0.950792> }
triangle { <0.546183, 0.081995, 0.929542>, <0.564409, 0.130589, 0.935095>, <0.649579, 0.150295, 0.912248> }
triangle { <0.649579, 0.150295, 0.912248>, <0.628603, 0.094368, 0.904740>, <0.546183, 0.081995, 0.929542> }
triangle { <0.628603, 0.094368, 0.904740>, <0.649579, 0.150295, 0.912248>, <0.730744, 0.169075, 0.886271> }
triangle { <0.730744, 0.169075, 0.886271>, <0.707148, 0.106159, 0.876540>, <0.628603, 0.094368, 0.904740> }
triangle { <0.707148, 0.106159, 0.876540>, <0.730744, 0.169075, 0.886271>, <0.807405, 0.186812, 0.857324> }
triangle { <0.807405, 0.186812, 0.857324>, <0.781332, 0.117296, 0.845115>, <0.707148, 0.106159, 0.876540> }
triangle { <0.781332, 0.117296, 0.845115>, <0.807405, 0.186812, 0.857324>, <0.879087, 0.203397, 0.825585> }
triangle { <0.879087, 0.203397, 0.825585>, <0.850700, 0.127710, 0.810660>, <0.781332, 0.117296, 0.845115> }
triangle { <0.850700, 0.127710, 0.810660>, <0.879087, 0.203397, 0.825585>, <0.945349, 0.218728, 0.791249> }
triangle { <0.945349, 0.218728, 0.791249>, <0.914823, 0.137336, 0.773387>, <0.850700, 0.127710, 0.810660> }
triangle { <0.914823, 0.137336, 0.773387>, <0.945349, 0.218728, 0.791249>, <1.005783, 0.232711, 0.754530> }
triangle { <1.005783, 0.232711, 0.754530>, <0.973305, 0.146116, 0.733525>, <0.914823, 0.137336, 0.773387> }
triangle { <0.973305, 0.146116, 0.733525>, <1.005783, 0.232711, 0.754530>, <1.060016, 0.245259, 0.715652> }
triangle { <1.060016, 0.245259, 0.715652>, <1.025787, 0.153995, 0.691321>, <0.973305, 0.146116, 0.733525> }
triangle { <1.025787, 0.153995, 0.691321>, <1.060016, 0.245259, 0.715652>, <1.107714, 0.256295, 0.674856> }
triangle { <1.107714, 0.256295, 0.674856>, <1.071944, 0.160924, 0.647034>, <1.025787, 0.153995, 0.691321> }
triangle { <1.071944, 0.160924, 0.647034>, <1.107714, 0.256295, 0.674856>, <1.148582, 0.265751, 0.632393> }
triangle { <1.148582, 0.265751, 0.632393>, <1.111493, 0.166861, 0.600938>, <1.071944, 0.160924, 0.647034> }
triangle { <1.111493, 0.166861, 0.600938>, <1.148582, 0.265751, 0.632393>, <1.182369, 0.273568, 0.588525> }
triangle { <1.182369, 0.273568, 0.588525>, <1.144189, 0.171769, 0.553316>, <1.111493, 0.166861, 0.600938> }
triangle { <1.144189, 0.171769, 0.553316>, <1.182369, 0.273568, 0.588525>, <1.208866, 0.279699, 0.543523> }
triangle { <1.208866, 0.279699, 0.543523>, <1.169830, 0.175619, 0.504463>, <1.144189, 0.171769, 0.553316> }
triangle { <1.169830, 0.175619, 0.504463>, <1.208866, 0.279699, 0.543523>, <1.227911, 0.284105, 0.497664> }
triangle { <1.227911, 0.284105, 0.497664>, <1.188259, 0.178385, 0.454680>, <1.169830, 0.175619, 0.504463> }
triangle { <1.188259, 0.178385, 0.454680>, <1.227911, 0.284105, 0.497664>, <1.239384, 0.286760, 0.451230> }
triangle { <1.239384, 0.286760, 0.451230>, <1.199363, 0.180052, 0.404273>, <1.188259, 0.178385, 0.454680> }
triangle { <1.199363, 0.180052, 0.404273>, <1.239384, 0.286760, 0.451230>, <1.243217, 0.287647, 0.404508> }
triangle { <1.243217, 0.287647, 0.404508>, <1.203071, 0.180609, 0.353553>, <1.199363, 0.180052, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.098941, 0.032528, 0.998291> }
triangle { <0.098941, 0.032528, 0.998291>, <0.097542, 0.022569, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <0.097542, 0.022569, 0.998164>, <0.098941, 0.032528, 0.998291>, <0.197272, 0.064855, 0.993173> }
triangle { <0.197272, 0.064855, 0.993173>, <0.194482, 0.044998, 0.992669>, <0.097542, 0.022569, 0.998164> }
triangle { <0.194482, 0.044998, 0.992669>, <0.197272, 0.064855, 0.993173>, <0.294387, 0.096783, 0.984679> }
triangle { <0.294387, 0.096783, 0.984679>, <0.290223, 0.067150, 0.983547>, <0.194482, 0.044998, 0.992669> }
triangle { <0.290223, 0.067150, 0.983547>, <0.294387, 0.096783, 0.984679>, <0.389687, 0.128114, 0.972861> }
triangle { <0.389687, 0.128114, 0.972861>, <0.384175, 0.088888, 0.970855>, <0.290223, 0.067150, 0.983547> }
triangle { <0.384175, 0.088888, 0.970855>, <0.389687, 0.128114, 0.972861>, <0.482584, 0.158655, 0.957791> }
triangle { <0.482584, 0.158655, 0.957791>, <0.475758, 0.110078, 0.954671>, <0.384175, 0.088888, 0.970855> }
triangle { <0.475758, 0.110078, 0.954671>, <0.482584, 0.158655, 0.957791>, <0.572506, 0.188217, 0.939563> }
triangle { <0.572506, 0.188217, 0.939563>, <0.564409, 0.130589, 0.935095>, <0.475758, 0.110078, 0.954671> }
triangle { <0.564409, 0.130589, 0.935095>, <0.572506, 0.188217, 0.939563>, <0.658899, 0.216620, 0.918289> }
triangle { <0.658899, 0.216620, 0.918289>, <0.649579, 0.150295, 0.912248>, <0.564409, 0.130589, 0.935095> }
triangle { <0.649579, 0.150295, 0.912248>, <0.658899, 0.216620, 0.918289>, <0.741229, 0.243687, 0.894101> }
triangle { <0.741229, 0.243687, 0.894101>, <0.730744, 0.169075, 0.886271>, <0.649579, 0.150295, 0.912248> }
triangle { <0.730744, 0.169075, 0.886271>, <0.741229, 0.243687, 0.894101>, <0.818989, 0.269251, 0.867146> }
triangle { <0.818989, 0.269251, 0.867146>, <0.807405, 0.186812, 0.857324>, <0.730744, 0.169075, 0.886271> }
triangle { <0.807405, 0.186812, 0.857324>, <0.818989, 0.269251, 0.867146>, <0.891700, 0.293155, 0.837592> }
triangle { <0.891700, 0.293155, 0.837592>, <0.879087, 0.203397, 0.825585>, <0.807405, 0.186812, 0.857324> }
triangle { <0.879087, 0.203397, 0.825585>, <0.891700, 0.293155, 0.837592>, <0.958913, 0.315252, 0.805620> }
triangle { <0.958913, 0.315252, 0.805620>, <0.945349, 0.218728, 0.791249>, <0.879087, 0.203397, 0.825585> }
triangle { <0.945349, 0.218728, 0.791249>, <0.958913, 0.315252, 0.805620>, <1.020214, 0.335406, 0.771428> }
triangle { <1.020214, 0.335406, 0.771428>, <1.005783, 0.232711, 0.754530>, <0.945349, 0.218728, 0.791249> }
triangle { <1.005783, 0.232711, 0.754530>, <1.020214, 0.335406, 0.771428>, <1.075225, 0.353491, 0.735227> }
triangle { <1.075225, 0.353491, 0.735227>, <1.060016, 0.245259, 0.715652>, <1.005783, 0.232711, 0.754530> }
triangle { <1.060016, 0.245259, 0.715652>, <1.075225, 0.353491, 0.735227>, <1.123607, 0.369397, 0.697240> }
triangle { <1.123607, 0.369397, 0.697240>, <1.107714, 0.256295, 0.674856>, <1.060016, 0.245259, 0.715652> }
triangle { <1.107714, 0.256295, 0.674856>, <1.123607, 0.369397, 0.697240>, <1.165062, 0.383026, 0.657700> }
triangle { <1.165062, 0.383026, 0.657700>, <1.148582, 0.265751, 0.632393>, <1.107714, 0.256295, 0.674856> }
triangle { <1.148582, 0.265751, 0.632393>, <1.165062, 0.383026, 0.657700>, <1.199333, 0.394293, 0.616852> }
triangle { <1.199333, 0.394293, 0.616852>, <1.182369, 0.273568, 0.588525>, <1.148582, 0.265751, 0.632393> }
triangle { <1.182369, 0.273568, 0.588525>, <1.199333, 0.394293, 0.616852>, <1.226211, 0.403129, 0.574948> }
triangle { <1.226211, 0.403129, 0.574948>, <1.208866, 0.279699, 0.543523>, <1.182369, 0.273568, 0.588525> }
triangle { <1.208866, 0.279699, 0.543523>, <1.226211, 0.403129, 0.574948>, <1.245528, 0.409480, 0.532246> }
triangle { <1.245528, 0.409480, 0.532246>, <1.227911, 0.284105, 0.497664>, <1.208866, 0.279699, 0.543523> }
triangle { <1.227911, 0.284105, 0.497664>, <1.245528, 0.409480, 0.532246>, <1.257166, 0.413306, 0.489009> }
triangle { <1.257166, 0.413306, 0.489009>, <1.239384, 0.286760, 0.451230>, <1.227911, 0.284105, 0.497664> }
triangle { <1.239384, 0.286760, 0.451230>, <1.257166, 0.413306, 0.489009>, <1.261054, 0.414584, 0.445503> }
triangle { <1.261054, 0.414584, 0.445503>, <1.243217, 0.287647, 0.404508>, <1.239384, 0.286760, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.098073, 0.043391, 0.998383> }
triangle { <0.098073, 0.043391, 0.998383>, <0.098941, 0.032528, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <0.098941, 0.032528, 0.998291>, <0.098073, 0.043391, 0.998383>, <0.195542, 0.086514, 0.993543> }
triangle { <0.195542, 0.086514, 0.993543>, <0.197272, 0.064855, 0.993173>, <0.098941, 0.032528, 0.998291> }
triangle { <0.197272, 0.064855, 0.993173>, <0.195542, 0.086514, 0.993543>, <0.291805, 0.129104, 0.985509> }
triangle { <0.291805, 0.129104, 0.985509>, <0.294387, 0.096783, 0.984679>, <0.197272, 0.064855, 0.993173> }
triangle { <0.294387, 0.096783, 0.984679>, <0.291805, 0.129104, 0.985509>, <0.386268, 0.170898, 0.974331> }
triangle { <0.386268, 0.170898, 0.974331>, <0.389687, 0.128114, 0.972861>, <0.294387, 0.096783, 0.984679> }
triangle { <0.389687, 0.128114, 0.972861>, <0.386268, 0.170898, 0.974331>, <0.478351, 0.211638, 0.960077> }
triangle { <0.478351, 0.211638, 0.960077>, <0.482584, 0.158655, 0.957791>, <0.389687, 0.128114, 0.972861> }
triangle { <0.482584, 0.158655, 0.957791>, <0.478351, 0.211638, 0.960077>, <0.567484, 0.251074, 0.942836> }
triangle { <0.567484, 0.251074, 0.942836>, <0.572506, 0.188217, 0.939563>, <0.482584, 0.158655, 0.957791> }
triangle { <0.572506, 0.188217, 0.939563>, <0.567484, 0.251074, 0.942836>, <0.653118, 0.288961, 0.922714> }
triangle { <0.653118, 0.288961, 0.922714>, <0.658899, 0.216620, 0.918289>, <0.572506, 0.188217, 0.939563> }
triangle { <0.658899, 0.216620, 0.918289>, <0.653118, 0.288961, 0.922714>, <0.734726, 0.325067, 0.899835> }
triangle { <0.734726, 0.325067, 0.899835>, <0.741229, 0.243687, 0.894101>, <0.658899, 0.216620, 0.918289> }
triangle { <0.741229, 0.243687, 0.894101>, <0.734726, 0.325067, 0.899835>, <0.811804, 0.359169, 0.874340> }
triangle { <0.811804, 0.359169, 0.874340>, <0.818989, 0.269251, 0.867146>, <0.741229, 0.243687, 0.894101> }
triangle { <0.818989, 0.269251, 0.867146>, <0.811804, 0.359169, 0.874340>, <0.883877, 0.391057, 0.846386> }
triangle { <0.883877, 0.391057, 0.846386>, <0.891700, 0.293155, 0.837592>, <0.818989, 0.269251, 0.867146> }
triangle { <0.891700, 0.293155, 0.837592>, <0.883877, 0.391057, 0.846386>, <0.950501, 0.420533, 0.816145> }
triangle { <0.950501, 0.420533, 0.816145>, <0.958913, 0.315252, 0.805620>, <0.891700, 0.293155, 0.837592> }
triangle { <0.958913, 0.315252, 0.805620>, <0.950501, 0.420533, 0.816145>, <1.011264, 0.447417, 0.783805> }
triangle { <1.011264, 0.447417, 0.783805>, <1.020214, 0.335406, 0.771428>, <0.958913, 0.315252, 0.805620> }
triangle { <1.020214, 0.335406, 0.771428>, <1.011264, 0.447417, 0.783805>, <1.065792, 0.471542, 0.749564> }
triangle { <1.065792, 0.471542, 0.749564>, <1.075225, 0.353491, 0.735227>, <1.020214, 0.335406, 0.771428> }
triangle { <1.075225, 0.353491, 0.735227>, <1.065792, 0.471542, 0.749564>, <1.113750, 0.492760, 0.713633> }
triangle { <1.113750, 0.492760, 0.713633>, <1.123607, 0.369397, 0.697240>, <1.075225, 0.353491, 0.735227> }
triangle { <1.123607, 0.369397, 0.697240>, <1.113750, 0.492760, 0.713633>, <1.154841, 0.510940, 0.676235> }
triangle { <1.154841, 0.510940, 0.676235>, <1.165062, 0.383026, 0.657700>, <1.123607, 0.369397, 0.697240> }
triangle { <1.165062, 0.383026, 0.657700>, <1.154841, 0.510940, 0.676235>, <1.188812, 0.525970, 0.637599> }
triangle { <1.188812, 0.525970, 0.637599>, <1.199333, 0.394293, 0.616852>, <1.165062, 0.383026, 0.657700> }
triangle { <1.199333, 0.394293, 0.616852>, <1.188812, 0.525970, 0.637599>, <1.215454, 0.537757, 0.597964> }
triangle { <1.215454, 0.537757, 0.597964>, <1.226211, 0.403129, 0.574948>, <1.199333, 0.394293, 0.616852> }
triangle { <1.226211, 0.403129, 0.574948>, <1.215454, 0.537757, 0.597964>, <1.234601, 0.546229, 0.557574> }
triangle { <1.234601, 0.546229, 0.557574>, <1.245528, 0.409480, 0.532246>, <1.226211, 0.403129, 0.574948> }
triangle { <1.245528, 0.409480, 0.532246>, <1.234601, 0.546229, 0.557574>, <1.246138, 0.551333, 0.516678> }
triangle { <1.246138, 0.551333, 0.516678>, <1.257166, 0.413306, 0.489009>, <1.245528, 0.409480, 0.532246> }
triangle { <1.257166, 0.413306, 0.489009>, <1.246138, 0.551333, 0.516678>, <1.249991, 0.553038, 0.475528> }
triangle { <1.249991, 0.553038, 0.475528>, <1.261054, 0.414584, 0.445503>, <1.257166, 0.413306, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.094693, 0.054351, 0.998440> }
triangle { <0.094693, 0.054351, 0.998440>, <0.098073, 0.043391, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <0.098073, 0.043391, 0.998383>, <0.094693, 0.054351, 0.998440>, <0.188802, 0.108367, 0.993768> }
triangle { <0.188802, 0.108367, 0.993768>, <0.195542, 0.086514, 0.993543>, <0.098073, 0.043391, 0.998383> }
triangle { <0.195542, 0.086514, 0.993543>, <0.188802, 0.108367, 0.993768>, <0.281748, 0.161715, 0.986015> }
triangle { <0.281748, 0.161715, 0.986015>, <0.291805, 0.129104, 0.985509>, <0.195542, 0.086514, 0.993543> }
triangle { <0.291805, 0.129104, 0.985509>, <0.281748, 0.161715, 0.986015>, <0.372956, 0.214065, 0.975227> }
triangle { <0.372956, 0.214065, 0.975227>, <0.386268, 0.170898, 0.974331>, <0.291805, 0.129104, 0.985509> }
triangle { <0.386268, 0.170898, 0.974331>, <0.372956, 0.214065, 0.975227>, <0.461865, 0.265096, 0.961471> }
triangle { <0.461865, 0.265096, 0.961471>, <0.478351, 0.211638, 0.960077>, <0.386268, 0.170898, 0.974331> }
triangle { <0.478351, 0.211638, 0.960077>, <0.461865, 0.265096, 0.961471>, <0.547926, 0.314493, 0.944832> }
triangle { <0.547926, 0.314493, 0.944832>, <0.567484, 0.251074, 0.942836>, <0.478351, 0.211638, 0.960077> }
triangle { <0.567484, 0.251074, 0.942836>, <0.547926, 0.314493, 0.944832>, <0.630609, 0.361950, 0.925413> }
triangle { <0.630609, 0.361950, 0.925413>, <0.653118, 0.288961, 0.922714>, <0.567484, 0.251074, 0.942836> }
triangle { <0.653118, 0.288961, 0.922714>, <0.630609, 0.361950, 0.925413>, <0.709404, 0.407177, 0.903333> }
triangle { <0.709404, 0.407177, 0.903333>, <0.734726, 0.325067, 0.899835>, <0.653118, 0.288961, 0.922714> }
triangle { <0.734726, 0.325067, 0.899835>, <0.709404, 0.407177, 0.903333>, <0.783825, 0.449892, 0.878728> }
triangle { <0.783825, 0.449892, 0.878728>, <0.811804, 0.359169, 0.874340>, <0.734726, 0.325067, 0.899835> }
triangle { <0.811804, 0.359169, 0.874340>, <0.783825, 0.449892, 0.878728>, <0.853414, 0.489834, 0.851750> }
triangle { <0.853414, 0.489834, 0.851750>, <0.883877, 0.391057, 0.846386>, <0.811804, 0.359169, 0.874340> }
triangle { <0.883877, 0.391057, 0.846386>, <0.853414, 0.489834, 0.851750>, <0.917742, 0.526756, 0.822566> }
triangle { <0.917742, 0.526756, 0.822566>, <0.950501, 0.420533, 0.816145>, <0.883877, 0.391057, 0.846386> }
triangle { <0.950501, 0.420533, 0.816145>, <0.917742, 0.526756, 0.822566>, <0.976411, 0.560430, 0.791355> }
triangle { <0.976411, 0.560430, 0.791355>, <1.011264, 0.447417, 0.783805>, <0.950501, 0.420533, 0.816145> }
triangle { <1.011264, 0.447417, 0.783805>, <0.976411, 0.560430, 0.791355>, <1.029060, 0.590650, 0.758310> }
triangle { <1.029060, 0.590650, 0.758310>, <1.065792, 0.471542, 0.749564>, <1.011264, 0.447417, 0.783805> }
triangle { <1.065792, 0.471542, 0.749564>, <1.029060, 0.590650, 0.758310>, <1.075365, 0.617227, 0.723634> }
triangle { <1.075365, 0.617227, 0.723634>, <1.113750, 0.492760, 0.713633>, <1.065792, 0.471542, 0.749564> }
triangle { <1.113750, 0.492760, 0.713633>, <1.075365, 0.617227, 0.723634>, <1.115040, 0.639999, 0.687542> }
triangle { <1.115040, 0.639999, 0.687542>, <1.154841, 0.510940, 0.676235>, <1.113750, 0.492760, 0.713633> }
triangle { <1.154841, 0.510940, 0.676235>, <1.115040, 0.639999, 0.687542>, <1.147840, 0.658826, 0.650255> }
triangle { <1.147840, 0.658826, 0.650255>, <1.188812, 0.525970, 0.637599>, <1.154841, 0.510940, 0.676235> }
triangle { <1.188812, 0.525970, 0.637599>, <1.147840, 0.658826, 0.650255>, <1.173563, 0.673590, 0.612004> }
triangle { <1.173563, 0.673590, 0.612004>, <1.215454, 0.537757, 0.597964>, <1.188812, 0.525970, 0.637599> }
triangle { <1.215454, 0.537757, 0.597964>, <1.173563, 0.673590, 0.612004>, <1.192051, 0.684201, 0.573024> }
triangle { <1.192051, 0.684201, 0.573024>, <1.234601, 0.546229, 0.557574>, <1.215454, 0.537757, 0.597964> }
triangle { <1.234601, 0.546229, 0.557574>, <1.192051, 0.684201, 0.573024>, <1.203190, 0.690595, 0.533557> }
triangle { <1.203190, 0.690595, 0.533557>, <1.246138, 0.551333, 0.516678>, <1.234601, 0.546229, 0.557574> }
triangle { <1.246138, 0.551333, 0.516678>, <1.203190, 0.690595, 0.533557>, <1.206910, 0.692730, 0.493844> }
triangle { <1.206910, 0.692730, 0.493844>, <1.249991, 0.553038, 0.475528>, <1.246138, 0.551333, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.088865, 0.064564, 0.998459> }
triangle { <0.088865, 0.064564, 0.998459>, <0.094693, 0.054351, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <0.094693, 0.054351, 0.998440>, <0.088865, 0.064564, 0.998459>, <0.177181, 0.128730, 0.993844> }
triangle { <0.177181, 0.128730, 0.993844>, <0.188802, 0.108367, 0.993768>, <0.094693, 0.054351, 0.998440> }
triangle { <0.188802, 0.108367, 0.993768>, <0.177181, 0.128730, 0.993844>, <0.264406, 0.192102, 0.986185> }
triangle { <0.264406, 0.192102, 0.986185>, <0.281748, 0.161715, 0.986015>, <0.188802, 0.108367, 0.993768> }
triangle { <0.281748, 0.161715, 0.986015>, <0.264406, 0.192102, 0.986185>, <0.350000, 0.254290, 0.975528> }
triangle { <0.350000, 0.254290, 0.975528>, <0.372956, 0.214065, 0.975227>, <0.281748, 0.161715, 0.986015> }
triangle { <0.372956, 0.214065, 0.975227>, <0.350000, 0.254290, 0.975528>, <0.433436, 0.314910, 0.961940> }
triangle { <0.433436, 0.314910, 0.961940>, <0.461865, 0.265096, 0.961471>, <0.372956, 0.214065, 0.975227> }
triangle { <0.461865, 0.265096, 0.961471>, <0.433436, 0.314910, 0.961940>, <0.514200, 0.373588, 0.945503> }
triangle { <0.514200, 0.373588, 0.945503>, <0.547926, 0.314493, 0.944832>, <0.461865, 0.265096, 0.961471> }
triangle { <0.547926, 0.314493, 0.944832>, <0.514200, 0.373588, 0.945503>, <0.591794, 0.429964, 0.926320> }
triangle { <0.591794, 0.429964, 0.926320>, <0.630609, 0.361950, 0.925413>, <0.547926, 0.314493, 0.944832> }
triangle { <0.630609, 0.361950, 0.925413>, <0.591794, 0.429964, 0.926320>, <0.665740, 0.483688, 0.904508> }
triangle { <0.665740, 0.483688, 0.904508>, <0.709404, 0.407177, 0.903333>, <0.630609, 0.361950, 0.925413> }
triangle { <0.709404, 0.407177, 0.903333>, <0.665740, 0.483688, 0.904508>, <0.735580, 0.534430, 0.880203> }
triangle { <0.735580, 0.534430, 0.880203>, <0.783825, 0.449892, 0.878728>, <0.709404, 0.407177, 0.903333> }
triangle { <0.783825, 0.449892, 0.878728>, <0.735580, 0.534430, 0.880203>, <0.800886, 0.581878, 0.853553> }
triangle { <0.800886, 0.581878, 0.853553>, <0.853414, 0.489834, 0.851750>, <0.783825, 0.449892, 0.878728> }
triangle { <0.853414, 0.489834, 0.851750>, <0.800886, 0.581878, 0.853553>, <0.861254, 0.625738, 0.824724> }
triangle { <0.861254, 0.625738, 0.824724>, <0.917742, 0.526756, 0.822566>, <0.853414, 0.489834, 0.851750> }
triangle { <0.917742, 0.526756, 0.822566>, <0.861254, 0.625738, 0.824724>, <0.916312, 0.665740, 0.793893> }
triangle { <0.916312, 0.665740, 0.793893>, <0.976411, 0.560430, 0.791355>, <0.917742, 0.526756, 0.822566> }
triangle { <0.976411, 0.560430, 0.791355>, <0.916312, 0.665740, 0.793893>, <0.965721, 0.701637, 0.761249> }
triangle { <0.965721, 0.701637, 0.761249>, <1.029060, 0.590650, 0.758310>, <0.976411, 0.560430, 0.791355> }
triangle { <1.029060, 0.590650, 0.758310>, <0.965721, 0.701637, 0.761249>, <1.009175, 0.733209, 0.726995> }
triangle { <1.009175, 0.733209, 0.726995>, <1.075365, 0.617227, 0.723634>, <1.029060, 0.590650, 0.758310> }
triangle { <1.075365, 0.617227, 0.723634>, <1.009175, 0.733209, 0.726995>, <1.046408, 0.760260, 0.691342> }
triangle { <1.046408, 0.760260, 0.691342>, <1.115040, 0.639999, 0.687542>, <1.075365, 0.617227, 0.723634> }
triangle { <1.115040, 0.639999, 0.687542>, <1.046408, 0.760260, 0.691342>, <1.077189, 0.782624, 0.654508> }
triangle { <1.077189, 0.782624, 0.654508>, <1.147840, 0.658826, 0.650255>, <1.115040, 0.639999, 0.687542> }
triangle { <1.147840, 0.658826, 0.650255>, <1.077189, 0.782624, 0.654508>, <1.101329, 0.800163, 0.616723> }
triangle { <1.101329, 0.800163, 0.616723>, <1.173563, 0.673590, 0.612004>, <1.147840, 0.658826, 0.650255> }
triangle { <1.173563, 0.673590, 0.612004>, <1.101329, 0.800163, 0.616723>, <1.118679, 0.812768, 0.578217> }
triangle { <1.118679, 0.812768, 0.578217>, <1.192051, 0.684201, 0.573024>, <1.173563, 0.673590, 0.612004> }
triangle { <1.192051, 0.684201, 0.573024>, <1.118679, 0.812768, 0.578217>, <1.129132, 0.820363, 0.539230> }
triangle { <1.129132, 0.820363, 0.539230>, <1.203190, 0.690595, 0.533557>, <1.192051, 0.684201, 0.573024> }
triangle { <1.203190, 0.690595, 0.533557>, <1.129132, 0.820363, 0.539230>, <1.132624, 0.822899, 0.500000> }
triangle { <1.132624, 0.822899, 0.500000>, <1.206910, 0.692730, 0.493844>, <1.203190, 0.690595, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.080953, 0.073263, 0.998440> }
triangle { <0.080953, 0.073263, 0.998440>, <0.088865, 0.064564, 0.998459>, <0.000000, 0.000000, 1.000000> }
triangle { <0.088865, 0.064564, 0.998459>, <0.080953, 0.073263, 0.998440>, <0.161406, 0.146074, 0.993768> }
triangle { <0.161406, 0.146074, 0.993768>, <0.177181, 0.128730, 0.993844>, <0.088865, 0.064564, 0.998459> }
triangle { <0.177181, 0.128730, 0.993844>, <0.161406, 0.146074, 0.993768>, <0.240865, 0.217985, 0.986015> }
triangle { <0.240865, 0.217985, 0.986015>, <0.264406, 0.192102, 0.986185>, <0.177181, 0.128730, 0.993844> }
triangle { <0.264406, 0.192102, 0.986185>, <0.240865, 0.217985, 0.986015>, <0.318838, 0.288552, 0.975227> }
triangle { <0.318838, 0.288552, 0.975227>, <0.350000, 0.254290, 0.975528>, <0.264406, 0.192102, 0.986185> }
triangle { <0.350000, 0.254290, 0.975528>, <0.318838, 0.288552, 0.975227>, <0.394846, 0.357340, 0.961471> }
triangle { <0.394846, 0.357340, 0.961471>, <0.433436, 0.314910, 0.961940>, <0.350000, 0.254290, 0.975528> }
triangle { <0.433436, 0.314910, 0.961940>, <0.394846, 0.357340, 0.961471>, <0.468419, 0.423925, 0.944832> }
triangle { <0.468419, 0.423925, 0.944832>, <0.514200, 0.373588, 0.945503>, <0.433436, 0.314910, 0.961940> }
triangle { <0.514200, 0.373588, 0.945503>, <0.468419, 0.423925, 0.944832>, <0.539104, 0.487896, 0.925413> }
triangle { <0.539104, 0.487896, 0.925413>, <0.591794, 0.429964, 0.926320>, <0.514200, 0.373588, 0.945503> }
triangle { <0.591794, 0.429964, 0.926320>, <0.539104, 0.487896, 0.925413>, <0.606466, 0.548859, 0.903333> }
triangle { <0.606466, 0.548859, 0.903333>, <0.665740, 0.483688, 0.904508>, <0.591794, 0.429964, 0.926320> }
triangle { <0.665740, 0.483688, 0.904508>, <0.606466, 0.548859, 0.903333>, <0.670088, 0.606438, 0.878728> }
triangle { <0.670088, 0.606438, 0.878728>, <0.735580, 0.534430, 0.880203>, <0.665740, 0.483688, 0.904508> }
triangle { <0.735580, 0.534430, 0.880203>, <0.670088, 0.606438, 0.878728>, <0.729580, 0.660278, 0.851750> }
triangle { <0.729580, 0.660278, 0.851750>, <0.800886, 0.581878, 0.853553>, <0.735580, 0.534430, 0.880203> }
triangle { <0.800886, 0.581878, 0.853553>, <0.729580, 0.660278, 0.851750>, <0.784573, 0.710048, 0.822566> }
triangle { <0.784573, 0.710048, 0.822566>, <0.861254, 0.625738, 0.824724>, <0.800886, 0.581878, 0.853553> }
triangle { <0.861254, 0.625738, 0.824724>, <0.784573, 0.710048, 0.822566>, <0.834729, 0.755439, 0.791355> }
triangle { <0.834729, 0.755439, 0.791355>, <0.916312, 0.665740, 0.793893>, <0.861254, 0.625738, 0.824724> }
triangle { <0.916312, 0.665740, 0.793893>, <0.834729, 0.755439, 0.791355>, <0.879738, 0.796174, 0.758310> }
triangle { <0.879738, 0.796174, 0.758310>, <0.965721, 0.701637, 0.761249>, <0.916312, 0.665740, 0.793893> }
triangle { <0.965721, 0.701637, 0.761249>, <0.879738, 0.796174, 0.758310>, <0.919324, 0.831999, 0.723634> }
triangle { <0.919324, 0.831999, 0.723634>, <1.009175, 0.733209, 0.726995>, <0.965721, 0.701637, 0.761249> }
triangle { <1.009175, 0.733209, 0.726995>, <0.919324, 0.831999, 0.723634>, <0.953242, 0.862695, 0.687542> }
triangle { <0.953242, 0.862695, 0.687542>, <1.046408, 0.760260, 0.691342>, <1.009175, 0.733209, 0.726995> }
triangle { <1.046408, 0.760260, 0.691342>, <0.953242, 0.862695, 0.687542>, <0.981282, 0.888072, 0.650255> }
triangle { <0.981282, 0.888072, 0.650255>, <1.077189, 0.782624, 0.654508>, <1.046408, 0.760260, 0.691342> }
triangle { <1.077189, 0.782624, 0.654508>, <0.981282, 0.888072, 0.650255>, <1.003273, 0.907974, 0.612004> }
triangle { <1.003273, 0.907974, 0.612004>, <1.101329, 0.800163, 0.616723>, <1.077189, 0.782624, 0.654508> }
triangle { <1.101329, 0.800163, 0.616723>, <1.003273, 0.907974, 0.612004>, <1.019078, 0.922278, 0.573024> }
triangle { <1.019078, 0.922278, 0.573024>, <1.118679, 0.812768, 0.578217>, <1.101329, 0.800163, 0.616723> }
triangle { <1.118679, 0.812768, 0.578217>, <1.019078, 0.922278, 0.573024>, <1.028601, 0.930896, 0.533557> }
triangle { <1.028601, 0.930896, 0.533557>, <1.129132, 0.820363, 0.539230>, <1.118679, 0.812768, 0.578217> }
triangle { <1.129132, 0.820363, 0.539230>, <1.028601, 0.930896, 0.533557>, <1.031781, 0.933774, 0.493844> }
triangle { <1.031781, 0.933774, 0.493844>, <1.132624, 0.822899, 0.500000>, <1.129132, 0.820363, 0.539230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.071573, 0.079865, 0.998383> }
triangle { <0.071573, 0.079865, 0.998383>, <0.080953, 0.073263, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <0.080953, 0.073263, 0.998440>, <0.071573, 0.079865, 0.998383>, <0.142706, 0.159237, 0.993543> }
triangle { <0.142706, 0.159237, 0.993543>, <0.161406, 0.146074, 0.993768>, <0.080953, 0.073263, 0.998440> }
triangle { <0.161406, 0.146074, 0.993768>, <0.142706, 0.159237, 0.993543>, <0.212958, 0.237627, 0.985509> }
triangle { <0.212958, 0.237627, 0.985509>, <0.240865, 0.217985, 0.986015>, <0.161406, 0.146074, 0.993768> }
triangle { <0.240865, 0.217985, 0.986015>, <0.212958, 0.237627, 0.985509>, <0.281897, 0.314553, 0.974331> }
triangle { <0.281897, 0.314553, 0.974331>, <0.318838, 0.288552, 0.975227>, <0.240865, 0.217985, 0.986015> }
triangle { <0.318838, 0.288552, 0.975227>, <0.281897, 0.314553, 0.974331>, <0.349099, 0.389539, 0.960077> }
triangle { <0.349099, 0.389539, 0.960077>, <0.394846, 0.357340, 0.961471>, <0.318838, 0.288552, 0.975227> }
triangle { <0.394846, 0.357340, 0.961471>, <0.349099, 0.389539, 0.960077>, <0.414148, 0.462123, 0.942836> }
triangle { <0.414148, 0.462123, 0.942836>, <0.468419, 0.423925, 0.944832>, <0.394846, 0.357340, 0.961471> }
triangle { <0.468419, 0.423925, 0.944832>, <0.414148, 0.462123, 0.942836>, <0.476643, 0.531859, 0.922714> }
triangle { <0.476643, 0.531859, 0.922714>, <0.539104, 0.487896, 0.925413>, <0.468419, 0.423925, 0.944832> }
triangle { <0.539104, 0.487896, 0.925413>, <0.476643, 0.531859, 0.922714>, <0.536200, 0.598315, 0.899835> }
triangle { <0.536200, 0.598315, 0.899835>, <0.606466, 0.548859, 0.903333>, <0.539104, 0.487896, 0.925413> }
triangle { <0.606466, 0.548859, 0.903333>, <0.536200, 0.598315, 0.899835>, <0.592452, 0.661082, 0.874340> }
triangle { <0.592452, 0.661082, 0.874340>, <0.670088, 0.606438, 0.878728>, <0.606466, 0.548859, 0.903333> }
triangle { <0.670088, 0.606438, 0.878728>, <0.592452, 0.661082, 0.874340>, <0.645050, 0.719774, 0.846386> }
triangle { <0.645050, 0.719774, 0.846386>, <0.729580, 0.660278, 0.851750>, <0.670088, 0.606438, 0.878728> }
triangle { <0.729580, 0.660278, 0.851750>, <0.645050, 0.719774, 0.846386>, <0.693672, 0.774028, 0.816145> }
triangle { <0.693672, 0.774028, 0.816145>, <0.784573, 0.710048, 0.822566>, <0.729580, 0.660278, 0.851750> }
triangle { <0.784573, 0.710048, 0.822566>, <0.693672, 0.774028, 0.816145>, <0.738017, 0.823510, 0.783805> }
triangle { <0.738017, 0.823510, 0.783805>, <0.834729, 0.755439, 0.791355>, <0.784573, 0.710048, 0.822566> }
triangle { <0.834729, 0.755439, 0.791355>, <0.738017, 0.823510, 0.783805>, <0.777811, 0.867914, 0.749564> }
triangle { <0.777811, 0.867914, 0.749564>, <0.879738, 0.796174, 0.758310>, <0.834729, 0.755439, 0.791355> }
triangle { <0.879738, 0.796174, 0.758310>, <0.777811, 0.867914, 0.749564>, <0.812811, 0.906968, 0.713633> }
triangle { <0.812811, 0.906968, 0.713633>, <0.919324, 0.831999, 0.723634>, <0.879738, 0.796174, 0.758310> }
triangle { <0.919324, 0.831999, 0.723634>, <0.812811, 0.906968, 0.713633>, <0.842799, 0.940430, 0.676235> }
triangle { <0.842799, 0.940430, 0.676235>, <0.953242, 0.862695, 0.687542>, <0.919324, 0.831999, 0.723634> }
triangle { <0.953242, 0.862695, 0.687542>, <0.842799, 0.940430, 0.676235>, <0.867590, 0.968094, 0.637599> }
triangle { <0.867590, 0.968094, 0.637599>, <0.981282, 0.888072, 0.650255>, <0.953242, 0.862695, 0.687542> }
triangle { <0.981282, 0.888072, 0.650255>, <0.867590, 0.968094, 0.637599>, <0.887033, 0.989789, 0.597964> }
triangle { <0.887033, 0.989789, 0.597964>, <1.003273, 0.907974, 0.612004>, <0.981282, 0.888072, 0.650255> }
triangle { <1.003273, 0.907974, 0.612004>, <0.887033, 0.989789, 0.597964>, <0.901007, 1.005382, 0.557574> }
triangle { <0.901007, 1.005382, 0.557574>, <1.019078, 0.922278, 0.573024>, <1.003273, 0.907974, 0.612004> }
triangle { <1.019078, 0.922278, 0.573024>, <0.901007, 1.005382, 0.557574>, <0.909426, 1.014776, 0.516678> }
triangle { <0.909426, 1.014776, 0.516678>, <1.028601, 0.930896, 0.533557>, <1.019078, 0.922278, 0.573024> }
triangle { <1.028601, 0.930896, 0.533557>, <0.909426, 1.014776, 0.516678>, <0.912239, 1.017914, 0.475528> }
triangle { <0.912239, 1.017914, 0.475528>, <1.031781, 0.933774, 0.493844>, <1.028601, 0.930896, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.061510, 0.084047, 0.998291> }
triangle { <0.061510, 0.084047, 0.998291>, <0.071573, 0.079865, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <0.071573, 0.079865, 0.998383>, <0.061510, 0.084047, 0.998291>, <0.122642, 0.167576, 0.993173> }
triangle { <0.122642, 0.167576, 0.993173>, <0.142706, 0.159237, 0.993543>, <0.071573, 0.079865, 0.998383> }
triangle { <0.142706, 0.159237, 0.993543>, <0.122642, 0.167576, 0.993173>, <0.183017, 0.250071, 0.984679> }
triangle { <0.183017, 0.250071, 0.984679>, <0.212958, 0.237627, 0.985509>, <0.142706, 0.159237, 0.993543> }
triangle { <0.212958, 0.237627, 0.985509>, <0.183017, 0.250071, 0.984679>, <0.242263, 0.331025, 0.972861> }
triangle { <0.242263, 0.331025, 0.972861>, <0.281897, 0.314553, 0.974331>, <0.212958, 0.237627, 0.985509> }
triangle { <0.281897, 0.314553, 0.974331>, <0.242263, 0.331025, 0.972861>, <0.300016, 0.409938, 0.957791> }
triangle { <0.300016, 0.409938, 0.957791>, <0.349099, 0.389539, 0.960077>, <0.281897, 0.314553, 0.974331> }
triangle { <0.349099, 0.389539, 0.960077>, <0.300016, 0.409938, 0.957791>, <0.355920, 0.486324, 0.939563> }
triangle { <0.355920, 0.486324, 0.939563>, <0.414148, 0.462123, 0.942836>, <0.349099, 0.389539, 0.960077> }
triangle { <0.414148, 0.462123, 0.942836>, <0.355920, 0.486324, 0.939563>, <0.409629, 0.559711, 0.918289> }
triangle { <0.409629, 0.559711, 0.918289>, <0.476643, 0.531859, 0.922714>, <0.414148, 0.462123, 0.942836> }
triangle { <0.476643, 0.531859, 0.922714>, <0.409629, 0.559711, 0.918289>, <0.460812, 0.629647, 0.894101> }
triangle { <0.460812, 0.629647, 0.894101>, <0.536200, 0.598315, 0.899835>, <0.476643, 0.531859, 0.922714> }
triangle { <0.536200, 0.598315, 0.899835>, <0.460812, 0.629647, 0.894101>, <0.509154, 0.695702, 0.867146> }
triangle { <0.509154, 0.695702, 0.867146>, <0.592452, 0.661082, 0.874340>, <0.536200, 0.598315, 0.899835> }
triangle { <0.592452, 0.661082, 0.874340>, <0.509154, 0.695702, 0.867146>, <0.554358, 0.757467, 0.837592> }
triangle { <0.554358, 0.757467, 0.837592>, <0.645050, 0.719774, 0.846386>, <0.592452, 0.661082, 0.874340> }
triangle { <0.645050, 0.719774, 0.846386>, <0.554358, 0.757467, 0.837592>, <0.596143, 0.814562, 0.805620> }
triangle { <0.596143, 0.814562, 0.805620>, <0.693672, 0.774028, 0.816145>, <0.645050, 0.719774, 0.846386> }
triangle { <0.693672, 0.774028, 0.816145>, <0.596143, 0.814562, 0.805620>, <0.634253, 0.866635, 0.771428> }
triangle { <0.634253, 0.866635, 0.771428>, <0.738017, 0.823510, 0.783805>, <0.693672, 0.774028, 0.816145> }
triangle { <0.738017, 0.823510, 0.783805>, <0.634253, 0.866635, 0.771428>, <0.668453, 0.913365, 0.735227> }
triangle { <0.668453, 0.913365, 0.735227>, <0.777811, 0.867914, 0.749564>, <0.738017, 0.823510, 0.783805> }
triangle { <0.777811, 0.867914, 0.749564>, <0.668453, 0.913365, 0.735227>, <0.698532, 0.954464, 0.697240> }
triangle { <0.698532, 0.954464, 0.697240>, <0.812811, 0.906968, 0.713633>, <0.777811, 0.867914, 0.749564> }
triangle { <0.812811, 0.906968, 0.713633>, <0.698532, 0.954464, 0.697240>, <0.724303, 0.989678, 0.657700> }
triangle { <0.724303, 0.989678, 0.657700>, <0.842799, 0.940430, 0.676235>, <0.812811, 0.906968, 0.713633> }
triangle { <0.842799, 0.940430, 0.676235>, <0.724303, 0.989678, 0.657700>, <0.745610, 1.018791, 0.616852> }
triangle { <0.745610, 1.018791, 0.616852>, <0.867590, 0.968094, 0.637599>, <0.842799, 0.940430, 0.676235> }
triangle { <0.867590, 0.968094, 0.637599>, <0.745610, 1.018791, 0.616852>, <0.762319, 1.041622, 0.574948> }
triangle { <0.762319, 1.041622, 0.574948>, <0.887033, 0.989789, 0.597964>, <0.867590, 0.968094, 0.637599> }
triangle { <0.887033, 0.989789, 0.597964>, <0.762319, 1.041622, 0.574948>, <0.774328, 1.058031, 0.532246> }
triangle { <0.774328, 1.058031, 0.532246>, <0.901007, 1.005382, 0.557574>, <0.887033, 0.989789, 0.597964> }
triangle { <0.901007, 1.005382, 0.557574>, <0.774328, 1.058031, 0.532246>, <0.781564, 1.067918, 0.489009> }
triangle { <0.781564, 1.067918, 0.489009>, <0.909426, 1.014776, 0.516678>, <0.901007, 1.005382, 0.557574> }
triangle { <0.909426, 1.014776, 0.516678>, <0.781564, 1.067918, 0.489009>, <0.783980, 1.071220, 0.445503> }
triangle { <0.783980, 1.071220, 0.445503>, <0.912239, 1.017914, 0.475528>, <0.909426, 1.014776, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.051606, 0.085794, 0.998164> }
triangle { <0.051606, 0.085794, 0.998164>, <0.061510, 0.084047, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <0.061510, 0.084047, 0.998291>, <0.051606, 0.085794, 0.998164>, <0.102894, 0.171058, 0.992669> }
triangle { <0.102894, 0.171058, 0.992669>, <0.122642, 0.167576, 0.993173>, <0.061510, 0.084047, 0.998291> }
triangle { <0.122642, 0.167576, 0.993173>, <0.102894, 0.171058, 0.992669>, <0.153547, 0.255268, 0.983547> }
triangle { <0.153547, 0.255268, 0.983547>, <0.183017, 0.250071, 0.984679>, <0.122642, 0.167576, 0.993173> }
triangle { <0.183017, 0.250071, 0.984679>, <0.153547, 0.255268, 0.983547>, <0.203254, 0.337904, 0.970855> }
triangle { <0.203254, 0.337904, 0.970855>, <0.242263, 0.331025, 0.972861>, <0.183017, 0.250071, 0.984679> }
triangle { <0.242263, 0.331025, 0.972861>, <0.203254, 0.337904, 0.970855>, <0.251708, 0.418457, 0.954671> }
triangle { <0.251708, 0.418457, 0.954671>, <0.300016, 0.409938, 0.957791>, <0.242263, 0.331025, 0.972861> }
triangle { <0.300016, 0.409938, 0.957791>, <0.251708, 0.418457, 0.954671>, <0.298609, 0.496430, 0.935095> }
triangle { <0.298609, 0.496430, 0.935095>, <0.355920, 0.486324, 0.939563>, <0.300016, 0.409938, 0.957791> }
triangle { <0.355920, 0.486324, 0.939563>, <0.298609, 0.496430, 0.935095>, <0.343670, 0.571343, 0.912248> }
triangle { <0.343670, 0.571343, 0.912248>, <0.409629, 0.559711, 0.918289>, <0.355920, 0.486324, 0.939563> }
triangle { <0.409629, 0.559711, 0.918289>, <0.343670, 0.571343, 0.912248>, <0.386612, 0.642732, 0.886271> }
triangle { <0.386612, 0.642732, 0.886271>, <0.460812, 0.629647, 0.894101>, <0.409629, 0.559711, 0.918289> }
triangle { <0.460812, 0.629647, 0.894101>, <0.386612, 0.642732, 0.886271>, <0.427170, 0.710159, 0.857324> }
triangle { <0.427170, 0.710159, 0.857324>, <0.509154, 0.695702, 0.867146>, <0.460812, 0.629647, 0.894101> }
triangle { <0.509154, 0.695702, 0.867146>, <0.427170, 0.710159, 0.857324>, <0.465095, 0.773208, 0.825585> }
triangle { <0.465095, 0.773208, 0.825585>, <0.554358, 0.757467, 0.837592>, <0.509154, 0.695702, 0.867146> }
triangle { <0.554358, 0.757467, 0.837592>, <0.465095, 0.773208, 0.825585>, <0.500152, 0.831490, 0.791249> }
triangle { <0.500152, 0.831490, 0.791249>, <0.596143, 0.814562, 0.805620>, <0.554358, 0.757467, 0.837592> }
triangle { <0.596143, 0.814562, 0.805620>, <0.500152, 0.831490, 0.791249>, <0.532126, 0.884645, 0.754530> }
triangle { <0.532126, 0.884645, 0.754530>, <0.634253, 0.866635, 0.771428>, <0.596143, 0.814562, 0.805620> }
triangle { <0.634253, 0.866635, 0.771428>, <0.532126, 0.884645, 0.754530>, <0.560818, 0.932346, 0.715652> }
triangle { <0.560818, 0.932346, 0.715652>, <0.668453, 0.913365, 0.735227>, <0.634253, 0.866635, 0.771428> }
triangle { <0.668453, 0.913365, 0.735227>, <0.560818, 0.932346, 0.715652>, <0.586054, 0.974299, 0.674856> }
triangle { <0.586054, 0.974299, 0.674856>, <0.698532, 0.954464, 0.697240>, <0.668453, 0.913365, 0.735227> }
triangle { <0.698532, 0.954464, 0.697240>, <0.586054, 0.974299, 0.674856>, <0.607676, 1.010245, 0.632393> }
triangle { <0.607676, 1.010245, 0.632393>, <0.724303, 0.989678, 0.657700>, <0.698532, 0.954464, 0.697240> }
triangle { <0.724303, 0.989678, 0.657700>, <0.607676, 1.010245, 0.632393>, <0.625551, 1.039963, 0.588525> }
triangle { <0.625551, 1.039963, 0.588525>, <0.745610, 1.018791, 0.616852>, <0.724303, 0.989678, 0.657700> }
triangle { <0.745610, 1.018791, 0.616852>, <0.625551, 1.039963, 0.588525>, <0.639570, 1.063268, 0.543523> }
triangle { <0.639570, 1.063268, 0.543523>, <0.762319, 1.041622, 0.574948>, <0.745610, 1.018791, 0.616852> }
triangle { <0.762319, 1.041622, 0.574948>, <0.639570, 1.063268, 0.543523>, <0.649646, 1.080019, 0.497664> }
triangle { <0.649646, 1.080019, 0.497664>, <0.774328, 1.058031, 0.532246>, <0.762319, 1.041622, 0.574948> }
triangle { <0.774328, 1.058031, 0.532246>, <0.649646, 1.080019, 0.497664>, <0.655716, 1.090111, 0.451230> }
triangle { <0.655716, 1.090111, 0.451230>, <0.781564, 1.067918, 0.489009>, <0.774328, 1.058031, 0.532246> }
triangle { <0.781564, 1.067918, 0.489009>, <0.655716, 1.090111, 0.451230>, <0.657743, 1.093481, 0.404508> }
triangle { <0.657743, 1.093481, 0.404508>, <0.783980, 1.071220, 0.445503>, <0.781564, 1.067918, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.042646, 0.085393, 0.998007> }
triangle { <0.042646, 0.085393, 0.998007>, <0.051606, 0.085794, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <0.051606, 0.085794, 0.998164>, <0.042646, 0.085393, 0.998007>, <0.085028, 0.170260, 0.992041> }
triangle { <0.085028, 0.170260, 0.992041>, <0.102894, 0.171058, 0.992669>, <0.051606, 0.085794, 0.998164> }
triangle { <0.102894, 0.171058, 0.992669>, <0.085028, 0.170260, 0.992041>, <0.126887, 0.254077, 0.982139> }
triangle { <0.126887, 0.254077, 0.982139>, <0.153547, 0.255268, 0.983547>, <0.102894, 0.171058, 0.992669> }
triangle { <0.153547, 0.255268, 0.983547>, <0.126887, 0.254077, 0.982139>, <0.167963, 0.336327, 0.968361> }
triangle { <0.167963, 0.336327, 0.968361>, <0.203254, 0.337904, 0.970855>, <0.153547, 0.255268, 0.983547> }
triangle { <0.203254, 0.337904, 0.970855>, <0.167963, 0.336327, 0.968361>, <0.208003, 0.416504, 0.950792> }
triangle { <0.208003, 0.416504, 0.950792>, <0.251708, 0.418457, 0.954671>, <0.203254, 0.337904, 0.970855> }
triangle { <0.251708, 0.418457, 0.954671>, <0.208003, 0.416504, 0.950792>, <0.246761, 0.494113, 0.929542> }
triangle { <0.246761, 0.494113, 0.929542>, <0.298609, 0.496430, 0.935095>, <0.251708, 0.418457, 0.954671> }
triangle { <0.298609, 0.496430, 0.935095>, <0.246761, 0.494113, 0.929542>, <0.283998, 0.568676, 0.904740> }
triangle { <0.283998, 0.568676, 0.904740>, <0.343670, 0.571343, 0.912248>, <0.298609, 0.496430, 0.935095> }
triangle { <0.343670, 0.571343, 0.912248>, <0.283998, 0.568676, 0.904740>, <0.319484, 0.639732, 0.876540> }
triangle { <0.319484, 0.639732, 0.876540>, <0.386612, 0.642732, 0.886271>, <0.343670, 0.571343, 0.912248> }
triangle { <0.386612, 0.642732, 0.886271>, <0.319484, 0.639732, 0.876540>, <0.353000, 0.706845, 0.845115> }
triangle { <0.353000, 0.706845, 0.845115>, <0.427170, 0.710159, 0.857324>, <0.386612, 0.642732, 0.886271> }
triangle { <0.427170, 0.710159, 0.857324>, <0.353000, 0.706845, 0.845115>, <0.384340, 0.769599, 0.810660> }
triangle { <0.384340, 0.769599, 0.810660>, <0.465095, 0.773208, 0.825585>, <0.427170, 0.710159, 0.857324> }
triangle { <0.465095, 0.773208, 0.825585>, <0.384340, 0.769599, 0.810660>, <0.413310, 0.827609, 0.773387> }
triangle { <0.413310, 0.827609, 0.773387>, <0.500152, 0.831490, 0.791249>, <0.465095, 0.773208, 0.825585> }
triangle { <0.500152, 0.831490, 0.791249>, <0.413310, 0.827609, 0.773387>, <0.439732, 0.880516, 0.733525> }
triangle { <0.439732, 0.880516, 0.733525>, <0.532126, 0.884645, 0.754530>, <0.500152, 0.831490, 0.791249> }
triangle { <0.532126, 0.884645, 0.754530>, <0.439732, 0.880516, 0.733525>, <0.463443, 0.927994, 0.691321> }
triangle { <0.463443, 0.927994, 0.691321>, <0.560818, 0.932346, 0.715652>, <0.532126, 0.884645, 0.754530> }
triangle { <0.560818, 0.932346, 0.715652>, <0.463443, 0.927994, 0.691321>, <0.484297, 0.969751, 0.647034> }
triangle { <0.484297, 0.969751, 0.647034>, <0.586054, 0.974299, 0.674856>, <0.560818, 0.932346, 0.715652> }
triangle { <0.586054, 0.974299, 0.674856>, <0.484297, 0.969751, 0.647034>, <0.502164, 1.005530, 0.600938> }
triangle { <0.502164, 1.005530, 0.600938>, <0.607676, 1.010245, 0.632393>, <0.586054, 0.974299, 0.674856> }
triangle { <0.607676, 1.010245, 0.632393>, <0.502164, 1.005530, 0.600938>, <0.516936, 1.035108, 0.553316> }
triangle { <0.516936, 1.035108, 0.553316>, <0.625551, 1.039963, 0.588525>, <0.607676, 1.010245, 0.632393> }
triangle { <0.625551, 1.039963, 0.588525>, <0.516936, 1.035108, 0.553316>, <0.528521, 1.058305, 0.504463> }
triangle { <0.528521, 1.058305, 0.504463>, <0.639570, 1.063268, 0.543523>, <0.625551, 1.039963, 0.588525> }
triangle { <0.639570, 1.063268, 0.543523>, <0.528521, 1.058305, 0.504463>, <0.536847, 1.074978, 0.454680> }
triangle { <0.536847, 1.074978, 0.454680>, <0.649646, 1.080019, 0.497664>, <0.639570, 1.063268, 0.543523> }
triangle { <0.649646, 1.080019, 0.497664>, <0.536847, 1.074978, 0.454680>, <0.541863, 1.085022, 0.404273> }
triangle { <0.541863, 1.085022, 0.404273>, <0.655716, 1.090111, 0.451230>, <0.649646, 1.080019, 0.497664> }
triangle { <0.655716, 1.090111, 0.451230>, <0.541863, 1.085022, 0.404273>, <0.543539, 1.088377, 0.353553> }
triangle { <0.543539, 1.088377, 0.353553>, <0.657743, 1.093481, 0.404508>, <0.655716, 1.090111, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.035250, 0.083397, 0.997823> }
triangle { <0.035250, 0.083397, 0.997823>, <0.042646, 0.085393, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <0.042646, 0.085393, 0.998007>, <0.035250, 0.083397, 0.997823>, <0.070282, 0.166279, 0.991307> }
triangle { <0.070282, 0.166279, 0.991307>, <0.085028, 0.170260, 0.992041>, <0.042646, 0.085393, 0.998007> }
triangle { <0.085028, 0.170260, 0.992041>, <0.070282, 0.166279, 0.991307>, <0.104881, 0.248136, 0.980490> }
triangle { <0.104881, 0.248136, 0.980490>, <0.126887, 0.254077, 0.982139>, <0.085028, 0.170260, 0.992041> }
triangle { <0.126887, 0.254077, 0.982139>, <0.104881, 0.248136, 0.980490>, <0.138834, 0.328464, 0.965441> }
triangle { <0.138834, 0.328464, 0.965441>, <0.167963, 0.336327, 0.968361>, <0.126887, 0.254077, 0.982139> }
triangle { <0.167963, 0.336327, 0.968361>, <0.138834, 0.328464, 0.965441>, <0.171930, 0.406766, 0.946251> }
triangle { <0.171930, 0.406766, 0.946251>, <0.208003, 0.416504, 0.950792>, <0.167963, 0.336327, 0.968361> }
triangle { <0.208003, 0.416504, 0.950792>, <0.171930, 0.406766, 0.946251>, <0.203967, 0.482561, 0.923039> }
triangle { <0.203967, 0.482561, 0.923039>, <0.246761, 0.494113, 0.929542>, <0.208003, 0.416504, 0.950792> }
triangle { <0.246761, 0.494113, 0.929542>, <0.203967, 0.482561, 0.923039>, <0.234746, 0.555380, 0.895948> }
triangle { <0.234746, 0.555380, 0.895948>, <0.283998, 0.568676, 0.904740>, <0.246761, 0.494113, 0.929542> }
triangle { <0.283998, 0.568676, 0.904740>, <0.234746, 0.555380, 0.895948>, <0.264078, 0.624775, 0.865145> }
triangle { <0.264078, 0.624775, 0.865145>, <0.319484, 0.639732, 0.876540>, <0.283998, 0.568676, 0.904740> }
triangle { <0.319484, 0.639732, 0.876540>, <0.264078, 0.624775, 0.865145>, <0.291781, 0.690319, 0.830821> }
triangle { <0.291781, 0.690319, 0.830821>, <0.353000, 0.706845, 0.845115>, <0.319484, 0.639732, 0.876540> }
triangle { <0.353000, 0.706845, 0.845115>, <0.291781, 0.690319, 0.830821>, <0.317686, 0.751606, 0.793186> }
triangle { <0.317686, 0.751606, 0.793186>, <0.384340, 0.769599, 0.810660>, <0.353000, 0.706845, 0.845115> }
triangle { <0.384340, 0.769599, 0.810660>, <0.317686, 0.751606, 0.793186>, <0.341632, 0.808259, 0.752473> }
triangle { <0.341632, 0.808259, 0.752473>, <0.413310, 0.827609, 0.773387>, <0.384340, 0.769599, 0.810660> }
triangle { <0.413310, 0.827609, 0.773387>, <0.341632, 0.808259, 0.752473>, <0.363472, 0.859930, 0.708932> }
triangle { <0.363472, 0.859930, 0.708932>, <0.439732, 0.880516, 0.733525>, <0.413310, 0.827609, 0.773387> }
triangle { <0.439732, 0.880516, 0.733525>, <0.363472, 0.859930, 0.708932>, <0.383070, 0.906298, 0.662833> }
triangle { <0.383070, 0.906298, 0.662833>, <0.463443, 0.927994, 0.691321>, <0.439732, 0.880516, 0.733525> }
triangle { <0.463443, 0.927994, 0.691321>, <0.383070, 0.906298, 0.662833>, <0.400307, 0.947079, 0.614459> }
triangle { <0.400307, 0.947079, 0.614459>, <0.484297, 0.969751, 0.647034>, <0.463443, 0.927994, 0.691321> }
triangle { <0.484297, 0.969751, 0.647034>, <0.400307, 0.947079, 0.614459>, <0.415076, 0.982021, 0.564108> }
triangle { <0.415076, 0.982021, 0.564108>, <0.502164, 1.005530, 0.600938>, <0.484297, 0.969751, 0.647034> }
triangle { <0.502164, 1.005530, 0.600938>, <0.415076, 0.982021, 0.564108>, <0.427286, 1.010908, 0.512092> }
triangle { <0.427286, 1.010908, 0.512092>, <0.516936, 1.035108, 0.553316>, <0.502164, 1.005530, 0.600938> }
triangle { <0.516936, 1.035108, 0.553316>, <0.427286, 1.010908, 0.512092>, <0.436862, 1.033563, 0.458730> }
triangle { <0.436862, 1.033563, 0.458730>, <0.528521, 1.058305, 0.504463>, <0.516936, 1.035108, 0.553316> }
triangle { <0.528521, 1.058305, 0.504463>, <0.436862, 1.033563, 0.458730>, <0.443744, 1.049845, 0.404352> }
triangle { <0.443744, 1.049845, 0.404352>, <0.536847, 1.074978, 0.454680>, <0.528521, 1.058305, 0.504463> }
triangle { <0.536847, 1.074978, 0.454680>, <0.443744, 1.049845, 0.404352>, <0.447891, 1.059655, 0.349293> }
triangle { <0.447891, 1.059655, 0.349293>, <0.541863, 1.085022, 0.404273>, <0.536847, 1.074978, 0.454680> }
triangle { <0.541863, 1.085022, 0.404273>, <0.447891, 1.059655, 0.349293>, <0.449276, 1.062931, 0.293893> }
triangle { <0.449276, 1.062931, 0.293893>, <0.543539, 1.088377, 0.353553>, <0.541863, 1.085022, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.029789, 0.080538, 0.997617> }
triangle { <0.029789, 0.080538, 0.997617>, <0.035250, 0.083397, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <0.035250, 0.083397, 0.997823>, <0.029789, 0.080538, 0.997617>, <0.059395, 0.160580, 0.990483> }
triangle { <0.059395, 0.160580, 0.990483>, <0.070282, 0.166279, 0.991307>, <0.035250, 0.083397, 0.997823> }
triangle { <0.070282, 0.166279, 0.991307>, <0.059395, 0.160580, 0.990483>, <0.088635, 0.239632, 0.978642> }
triangle { <0.088635, 0.239632, 0.978642>, <0.104881, 0.248136, 0.980490>, <0.070282, 0.166279, 0.991307> }
triangle { <0.104881, 0.248136, 0.980490>, <0.088635, 0.239632, 0.978642>, <0.117328, 0.317206, 0.962166> }
triangle { <0.117328, 0.317206, 0.962166>, <0.138834, 0.328464, 0.965441>, <0.104881, 0.248136, 0.980490> }
triangle { <0.138834, 0.328464, 0.965441>, <0.117328, 0.317206, 0.962166>, <0.145298, 0.392825, 0.941159> }
triangle { <0.145298, 0.392825, 0.941159>, <0.171930, 0.406766, 0.946251>, <0.138834, 0.328464, 0.965441> }
triangle { <0.171930, 0.406766, 0.946251>, <0.145298, 0.392825, 0.941159>, <0.172372, 0.466022, 0.915748> }
triangle { <0.172372, 0.466022, 0.915748>, <0.203967, 0.482561, 0.923039>, <0.171930, 0.406766, 0.946251> }
triangle { <0.203967, 0.482561, 0.923039>, <0.172372, 0.466022, 0.915748>, <0.198383, 0.536345, 0.886090> }
triangle { <0.198383, 0.536345, 0.886090>, <0.234746, 0.555380, 0.895948>, <0.203967, 0.482561, 0.923039> }
triangle { <0.234746, 0.555380, 0.895948>, <0.198383, 0.536345, 0.886090>, <0.223171, 0.603362, 0.852369> }
triangle { <0.223171, 0.603362, 0.852369>, <0.264078, 0.624775, 0.865145>, <0.234746, 0.555380, 0.895948> }
triangle { <0.264078, 0.624775, 0.865145>, <0.223171, 0.603362, 0.852369>, <0.246583, 0.666659, 0.814793> }
triangle { <0.246583, 0.666659, 0.814793>, <0.291781, 0.690319, 0.830821>, <0.264078, 0.624775, 0.865145> }
triangle { <0.291781, 0.690319, 0.830821>, <0.246583, 0.666659, 0.814793>, <0.268475, 0.725846, 0.773592> }
triangle { <0.268475, 0.725846, 0.773592>, <0.317686, 0.751606, 0.793186>, <0.291781, 0.690319, 0.830821> }
triangle { <0.317686, 0.751606, 0.793186>, <0.268475, 0.725846, 0.773592>, <0.288712, 0.780558, 0.729022> }
triangle { <0.288712, 0.780558, 0.729022>, <0.341632, 0.808259, 0.752473>, <0.317686, 0.751606, 0.793186> }
triangle { <0.341632, 0.808259, 0.752473>, <0.288712, 0.780558, 0.729022>, <0.307169, 0.830457, 0.681356> }
triangle { <0.307169, 0.830457, 0.681356>, <0.363472, 0.859930, 0.708932>, <0.341632, 0.808259, 0.752473> }
triangle { <0.363472, 0.859930, 0.708932>, <0.307169, 0.830457, 0.681356>, <0.323732, 0.875236, 0.630889> }
triangle { <0.323732, 0.875236, 0.630889>, <0.383070, 0.906298, 0.662833>, <0.363472, 0.859930, 0.708932> }
triangle { <0.383070, 0.906298, 0.662833>, <0.323732, 0.875236, 0.630889>, <0.338299, 0.914619, 0.577932> }
triangle { <0.338299, 0.914619, 0.577932>, <0.400307, 0.947079, 0.614459>, <0.383070, 0.906298, 0.662833> }
triangle { <0.400307, 0.947079, 0.614459>, <0.338299, 0.914619, 0.577932>, <0.350780, 0.948364, 0.522811> }
triangle { <0.350780, 0.948364, 0.522811>, <0.415076, 0.982021, 0.564108>, <0.400307, 0.947079, 0.614459> }
triangle { <0.415076, 0.982021, 0.564108>, <0.350780, 0.948364, 0.522811>, <0.361099, 0.976261, 0.465867> }
triangle { <0.361099, 0.976261, 0.465867>, <0.427286, 1.010908, 0.512092>, <0.415076, 0.982021, 0.564108> }
triangle { <0.427286, 1.010908, 0.512092>, <0.361099, 0.976261, 0.465867>, <0.369191, 0.998139, 0.407450> }
triangle { <0.369191, 0.998139, 0.407450>, <0.436862, 1.033563, 0.458730>, <0.427286, 1.010908, 0.512092> }
triangle { <0.436862, 1.033563, 0.458730>, <0.369191, 0.998139, 0.407450>, <0.375007, 1.013863, 0.347920> }
triangle { <0.375007, 1.013863, 0.347920>, <0.443744, 1.049845, 0.404352>, <0.436862, 1.033563, 0.458730> }
triangle { <0.443744, 1.049845, 0.404352>, <0.375007, 1.013863, 0.347920>, <0.378511, 1.023337, 0.287645> }
triangle { <0.378511, 1.023337, 0.287645>, <0.447891, 1.059655, 0.349293>, <0.443744, 1.049845, 0.404352> }
triangle { <0.447891, 1.059655, 0.349293>, <0.378511, 1.023337, 0.287645>, <0.379681, 1.026501, 0.226995> }
triangle { <0.379681, 1.026501, 0.226995>, <0.449276, 1.062931, 0.293893>, <0.447891, 1.059655, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.026337, 0.077631, 0.997394> }
triangle { <0.026337, 0.077631, 0.997394>, <0.029789, 0.080538, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <0.029789, 0.080538, 0.997617>, <0.026337, 0.077631, 0.997394>, <0.052511, 0.154783, 0.989591> }
triangle { <0.052511, 0.154783, 0.989591>, <0.059395, 0.160580, 0.990483>, <0.029789, 0.080538, 0.997617> }
triangle { <0.059395, 0.160580, 0.990483>, <0.052511, 0.154783, 0.989591>, <0.078361, 0.230981, 0.976639> }
triangle { <0.078361, 0.230981, 0.976639>, <0.088635, 0.239632, 0.978642>, <0.059395, 0.160580, 0.990483> }
triangle { <0.088635, 0.239632, 0.978642>, <0.078361, 0.230981, 0.976639>, <0.103729, 0.305754, 0.958619> }
triangle { <0.103729, 0.305754, 0.958619>, <0.117328, 0.317206, 0.962166>, <0.088635, 0.239632, 0.978642> }
triangle { <0.117328, 0.317206, 0.962166>, <0.103729, 0.305754, 0.958619>, <0.128457, 0.378643, 0.935641> }
triangle { <0.128457, 0.378643, 0.935641>, <0.145298, 0.392825, 0.941159>, <0.117328, 0.317206, 0.962166> }
triangle { <0.145298, 0.392825, 0.941159>, <0.128457, 0.378643, 0.935641>, <0.152393, 0.449197, 0.907847> }
triangle { <0.152393, 0.449197, 0.907847>, <0.172372, 0.466022, 0.915748>, <0.145298, 0.392825, 0.941159> }
triangle { <0.172372, 0.466022, 0.915748>, <0.152393, 0.449197, 0.907847>, <0.175389, 0.516982, 0.875409> }
triangle { <0.175389, 0.516982, 0.875409>, <0.198383, 0.536345, 0.886090>, <0.172372, 0.466022, 0.915748> }
triangle { <0.198383, 0.536345, 0.886090>, <0.175389, 0.516982, 0.875409>, <0.197304, 0.581579, 0.838525> }
triangle { <0.197304, 0.581579, 0.838525>, <0.223171, 0.603362, 0.852369>, <0.198383, 0.536345, 0.886090> }
triangle { <0.223171, 0.603362, 0.852369>, <0.197304, 0.581579, 0.838525>, <0.218003, 0.642591, 0.797425> }
triangle { <0.218003, 0.642591, 0.797425>, <0.246583, 0.666659, 0.814793>, <0.223171, 0.603362, 0.852369> }
triangle { <0.246583, 0.666659, 0.814793>, <0.218003, 0.642591, 0.797425>, <0.237357, 0.699641, 0.752361> }
triangle { <0.237357, 0.699641, 0.752361>, <0.268475, 0.725846, 0.773592>, <0.246583, 0.666659, 0.814793> }
triangle { <0.268475, 0.725846, 0.773592>, <0.237357, 0.699641, 0.752361>, <0.255248, 0.752377, 0.703611> }
triangle { <0.255248, 0.752377, 0.703611>, <0.288712, 0.780558, 0.729022>, <0.268475, 0.725846, 0.773592> }
triangle { <0.288712, 0.780558, 0.729022>, <0.255248, 0.752377, 0.703611>, <0.271566, 0.800475, 0.651476> }
triangle { <0.271566, 0.800475, 0.651476>, <0.307169, 0.830457, 0.681356>, <0.288712, 0.780558, 0.729022> }
triangle { <0.307169, 0.830457, 0.681356>, <0.271566, 0.800475, 0.651476>, <0.286209, 0.843638, 0.596277> }
triangle { <0.286209, 0.843638, 0.596277>, <0.323732, 0.875236, 0.630889>, <0.307169, 0.830457, 0.681356> }
triangle { <0.323732, 0.875236, 0.630889>, <0.286209, 0.843638, 0.596277>, <0.299088, 0.881599, 0.538354> }
triangle { <0.299088, 0.881599, 0.538354>, <0.338299, 0.914619, 0.577932>, <0.323732, 0.875236, 0.630889> }
triangle { <0.338299, 0.914619, 0.577932>, <0.299088, 0.881599, 0.538354>, <0.310122, 0.914125, 0.478064> }
triangle { <0.310122, 0.914125, 0.478064>, <0.350780, 0.948364, 0.522811>, <0.338299, 0.914619, 0.577932> }
triangle { <0.350780, 0.948364, 0.522811>, <0.310122, 0.914125, 0.478064>, <0.319245, 0.941015, 0.415780> }
triangle { <0.319245, 0.941015, 0.415780>, <0.361099, 0.976261, 0.465867>, <0.350780, 0.948364, 0.522811> }
triangle { <0.361099, 0.976261, 0.465867>, <0.319245, 0.941015, 0.415780>, <0.326399, 0.962103, 0.351885> }
triangle { <0.326399, 0.962103, 0.351885>, <0.369191, 0.998139, 0.407450>, <0.361099, 0.976261, 0.465867> }
triangle { <0.369191, 0.998139, 0.407450>, <0.326399, 0.962103, 0.351885>, <0.331541, 0.977260, 0.286773> }
triangle { <0.331541, 0.977260, 0.286773>, <0.375007, 1.013863, 0.347920>, <0.369191, 0.998139, 0.407450> }
triangle { <0.375007, 1.013863, 0.347920>, <0.331541, 0.977260, 0.286773>, <0.334639, 0.986392, 0.220845> }
triangle { <0.334639, 0.986392, 0.220845>, <0.378511, 1.023337, 0.287645>, <0.375007, 1.013863, 0.347920> }
triangle { <0.378511, 1.023337, 0.287645>, <0.334639, 0.986392, 0.220845>, <0.335674, 0.989442, 0.154508> }
triangle { <0.335674, 0.989442, 0.154508>, <0.379681, 1.026501, 0.226995>, <0.378511, 1.023337, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024657, 0.075449, 0.997158> }
triangle { <0.024657, 0.075449, 0.997158>, <0.026337, 0.077631, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <0.026337, 0.077631, 0.997394>, <0.024657, 0.075449, 0.997158>, <0.049162, 0.150432, 0.988651> }
triangle { <0.049162, 0.150432, 0.988651>, <0.052511, 0.154783, 0.989591>, <0.026337, 0.077631, 0.997394> }
triangle { <0.052511, 0.154783, 0.989591>, <0.049162, 0.150432, 0.988651>, <0.073364, 0.224488, 0.974531> }
triangle { <0.073364, 0.224488, 0.974531>, <0.078361, 0.230981, 0.976639>, <0.052511, 0.154783, 0.989591> }
triangle { <0.078361, 0.230981, 0.976639>, <0.073364, 0.224488, 0.974531>, <0.097113, 0.297160, 0.954885> }
triangle { <0.097113, 0.297160, 0.954885>, <0.103729, 0.305754, 0.958619>, <0.078361, 0.230981, 0.976639> }
triangle { <0.103729, 0.305754, 0.958619>, <0.097113, 0.297160, 0.954885>, <0.120264, 0.368000, 0.929833> }
triangle { <0.120264, 0.368000, 0.929833>, <0.128457, 0.378643, 0.935641>, <0.103729, 0.305754, 0.958619> }
triangle { <0.128457, 0.378643, 0.935641>, <0.120264, 0.368000, 0.929833>, <0.142673, 0.436570, 0.899532> }
triangle { <0.142673, 0.436570, 0.899532>, <0.152393, 0.449197, 0.907847>, <0.128457, 0.378643, 0.935641> }
triangle { <0.152393, 0.449197, 0.907847>, <0.142673, 0.436570, 0.899532>, <0.164203, 0.502450, 0.864166> }
triangle { <0.164203, 0.502450, 0.864166>, <0.175389, 0.516982, 0.875409>, <0.152393, 0.449197, 0.907847> }
triangle { <0.175389, 0.516982, 0.875409>, <0.164203, 0.502450, 0.864166>, <0.184720, 0.565231, 0.823955> }
triangle { <0.184720, 0.565231, 0.823955>, <0.197304, 0.581579, 0.838525>, <0.175389, 0.516982, 0.875409> }
triangle { <0.197304, 0.581579, 0.838525>, <0.184720, 0.565231, 0.823955>, <0.204099, 0.624528, 0.779146> }
triangle { <0.204099, 0.624528, 0.779146>, <0.218003, 0.642591, 0.797425>, <0.197304, 0.581579, 0.838525> }
triangle { <0.218003, 0.642591, 0.797425>, <0.204099, 0.624528, 0.779146>, <0.222219, 0.679974, 0.730016> }
triangle { <0.222219, 0.679974, 0.730016>, <0.237357, 0.699641, 0.752361>, <0.218003, 0.642591, 0.797425> }
triangle { <0.237357, 0.699641, 0.752361>, <0.222219, 0.679974, 0.730016>, <0.238969, 0.731229, 0.676867> }
triangle { <0.238969, 0.731229, 0.676867>, <0.255248, 0.752377, 0.703611>, <0.237357, 0.699641, 0.752361> }
triangle { <0.255248, 0.752377, 0.703611>, <0.238969, 0.731229, 0.676867>, <0.254245, 0.777974, 0.620028> }
triangle { <0.254245, 0.777974, 0.620028>, <0.271566, 0.800475, 0.651476>, <0.255248, 0.752377, 0.703611> }
triangle { <0.271566, 0.800475, 0.651476>, <0.254245, 0.777974, 0.620028>, <0.267955, 0.819924, 0.559847> }
triangle { <0.267955, 0.819924, 0.559847>, <0.286209, 0.843638, 0.596277>, <0.271566, 0.800475, 0.651476> }
triangle { <0.286209, 0.843638, 0.596277>, <0.267955, 0.819924, 0.559847>, <0.280012, 0.856818, 0.496698> }
triangle { <0.280012, 0.856818, 0.496698>, <0.299088, 0.881599, 0.538354>, <0.286209, 0.843638, 0.596277> }
triangle { <0.299088, 0.881599, 0.538354>, <0.280012, 0.856818, 0.496698>, <0.290343, 0.888429, 0.430968> }
triangle { <0.290343, 0.888429, 0.430968>, <0.310122, 0.914125, 0.478064>, <0.299088, 0.881599, 0.538354> }
triangle { <0.310122, 0.914125, 0.478064>, <0.290343, 0.888429, 0.430968>, <0.298883, 0.914564, 0.363064> }
triangle { <0.298883, 0.914564, 0.363064>, <0.319245, 0.941015, 0.415780>, <0.310122, 0.914125, 0.478064> }
triangle { <0.319245, 0.941015, 0.415780>, <0.298883, 0.914564, 0.363064>, <0.305582, 0.935059, 0.293403> }
triangle { <0.305582, 0.935059, 0.293403>, <0.326399, 0.962103, 0.351885>, <0.319245, 0.941015, 0.415780> }
triangle { <0.326399, 0.962103, 0.351885>, <0.305582, 0.935059, 0.293403>, <0.310396, 0.949790, 0.222416> }
triangle { <0.310396, 0.949790, 0.222416>, <0.331541, 0.977260, 0.286773>, <0.326399, 0.962103, 0.351885> }
triangle { <0.331541, 0.977260, 0.286773>, <0.310396, 0.949790, 0.222416>, <0.313296, 0.958665, 0.150539> }
triangle { <0.313296, 0.958665, 0.150539>, <0.334639, 0.986392, 0.220845>, <0.331541, 0.977260, 0.286773> }
triangle { <0.334639, 0.986392, 0.220845>, <0.313296, 0.958665, 0.150539>, <0.314265, 0.961629, 0.078217> }
triangle { <0.314265, 0.961629, 0.078217>, <0.335674, 0.989442, 0.154508>, <0.334639, 0.986392, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024245, 0.074619, 0.996917> }
triangle { <0.024245, 0.074619, 0.996917>, <0.024657, 0.075449, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024657, 0.075449, 0.997158>, <0.024245, 0.074619, 0.996917>, <0.048341, 0.148778, 0.987688> }
triangle { <0.048341, 0.148778, 0.987688>, <0.049162, 0.150432, 0.988651>, <0.024657, 0.075449, 0.997158> }
triangle { <0.049162, 0.150432, 0.988651>, <0.048341, 0.148778, 0.987688>, <0.072139, 0.222020, 0.972370> }
triangle { <0.072139, 0.222020, 0.972370>, <0.073364, 0.224488, 0.974531>, <0.049162, 0.150432, 0.988651> }
triangle { <0.073364, 0.224488, 0.974531>, <0.072139, 0.222020, 0.972370>, <0.095492, 0.293893, 0.951057> }
triangle { <0.095492, 0.293893, 0.951057>, <0.097113, 0.297160, 0.954885>, <0.073364, 0.224488, 0.974531> }
triangle { <0.097113, 0.297160, 0.954885>, <0.095492, 0.293893, 0.951057>, <0.118256, 0.363954, 0.923880> }
triangle { <0.118256, 0.363954, 0.923880>, <0.120264, 0.368000, 0.929833>, <0.097113, 0.297160, 0.954885> }
triangle { <0.120264, 0.368000, 0.929833>, <0.118256, 0.363954, 0.923880>, <0.140291, 0.431771, 0.891007> }
triangle { <0.140291, 0.431771, 0.891007>, <0.142673, 0.436570, 0.899532>, <0.120264, 0.368000, 0.929833> }
triangle { <0.142673, 0.436570, 0.899532>, <0.140291, 0.431771, 0.891007>, <0.161461, 0.496926, 0.852640> }
triangle { <0.161461, 0.496926, 0.852640>, <0.164203, 0.502450, 0.864166>, <0.142673, 0.436570, 0.899532> }
triangle { <0.164203, 0.502450, 0.864166>, <0.161461, 0.496926, 0.852640>, <0.181636, 0.559017, 0.809017> }
triangle { <0.181636, 0.559017, 0.809017>, <0.184720, 0.565231, 0.823955>, <0.164203, 0.502450, 0.864166> }
triangle { <0.184720, 0.565231, 0.823955>, <0.181636, 0.559017, 0.809017>, <0.200690, 0.617662, 0.760406> }
triangle { <0.200690, 0.617662, 0.760406>, <0.204099, 0.624528, 0.779146>, <0.184720, 0.565231, 0.823955> }
triangle { <0.204099, 0.624528, 0.779146>, <0.200690, 0.617662, 0.760406>, <0.218508, 0.672499, 0.707107> }
triangle { <0.218508, 0.672499, 0.707107>, <0.222219, 0.679974, 0.730016>, <0.204099, 0.624528, 0.779146> }
triangle { <0.222219, 0.679974, 0.730016>, <0.218508, 0.672499, 0.707107>, <0.234978, 0.723189, 0.649448> }
triangle { <0.234978, 0.723189, 0.649448>, <0.238969, 0.731229, 0.676867>, <0.222219, 0.679974, 0.730016> }
triangle { <0.238969, 0.731229, 0.676867>, <0.234978, 0.723189, 0.649448>, <0.250000, 0.769421, 0.587785> }
triangle { <0.250000, 0.769421, 0.587785>, <0.254245, 0.777974, 0.620028>, <0.238969, 0.731229, 0.676867> }
triangle { <0.254245, 0.777974, 0.620028>, <0.250000, 0.769421, 0.587785>, <0.263480, 0.810909, 0.522499> }
triangle { <0.263480, 0.810909, 0.522499>, <0.267955, 0.819924, 0.559847>, <0.254245, 0.777974, 0.620028> }
triangle { <0.267955, 0.819924, 0.559847>, <0.263480, 0.810909, 0.522499>, <0.275336, 0.847398, 0.453990> }
triangle { <0.275336, 0.847398, 0.453990>, <0.280012, 0.856818, 0.496698>, <0.267955, 0.819924, 0.559847> }
triangle { <0.280012, 0.856818, 0.496698>, <0.275336, 0.847398, 0.453990>, <0.285494, 0.878662, 0.382683> }
triangle { <0.285494, 0.878662, 0.382683>, <0.290343, 0.888429, 0.430968>, <0.280012, 0.856818, 0.496698> }
triangle { <0.290343, 0.888429, 0.430968>, <0.285494, 0.878662, 0.382683>, <0.293893, 0.904508, 0.309017> }
triangle { <0.293893, 0.904508, 0.309017>, <0.298883, 0.914564, 0.363064>, <0.290343, 0.888429, 0.430968> }
triangle { <0.298883, 0.914564, 0.363064>, <0.293893, 0.904508, 0.309017>, <0.300479, 0.924779, 0.233445> }
triangle { <0.300479, 0.924779, 0.233445>, <0.305582, 0.935059, 0.293403>, <0.298883, 0.914564, 0.363064> }
triangle { <0.305582, 0.935059, 0.293403>, <0.300479, 0.924779, 0.233445>, <0.305212, 0.939347, 0.156434> }
triangle { <0.305212, 0.939347, 0.156434>, <0.310396, 0.949790, 0.222416>, <0.305582, 0.935059, 0.293403> }
triangle { <0.310396, 0.949790, 0.222416>, <0.305212, 0.939347, 0.156434>, <0.308064, 0.948125, 0.078459> }
triangle { <0.308064, 0.948125, 0.078459>, <0.313296, 0.958665, 0.150539>, <0.310396, 0.949790, 0.222416> }
triangle { <0.313296, 0.958665, 0.150539>, <0.308064, 0.948125, 0.078459>, <0.309017, 0.951057, 0.000000> }
triangle { <0.309017, 0.951057, 0.000000>, <0.314265, 0.961629, 0.078217>, <0.313296, 0.958665, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024400, 0.075532, 0.997158> }
triangle { <0.024400, 0.075532, 0.997158>, <0.024245, 0.074619, 0.996917>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024245, 0.074619, 0.996917>, <0.024400, 0.075532, 0.997158>, <0.048649, 0.150599, 0.988651> }
triangle { <0.048649, 0.150599, 0.988651>, <0.048341, 0.148778, 0.987688>, <0.024245, 0.074619, 0.996917> }
triangle { <0.048341, 0.148778, 0.987688>, <0.048649, 0.150599, 0.988651>, <0.072598, 0.224737, 0.974531> }
triangle { <0.072598, 0.224737, 0.974531>, <0.072139, 0.222020, 0.972370>, <0.048341, 0.148778, 0.987688> }
triangle { <0.072139, 0.222020, 0.972370>, <0.072598, 0.224737, 0.974531>, <0.096100, 0.297489, 0.954885> }
triangle { <0.096100, 0.297489, 0.954885>, <0.095492, 0.293893, 0.951057>, <0.072139, 0.222020, 0.972370> }
triangle { <0.095492, 0.293893, 0.951057>, <0.096100, 0.297489, 0.954885>, <0.119009, 0.368407, 0.929833> }
triangle { <0.119009, 0.368407, 0.929833>, <0.118256, 0.363954, 0.923880>, <0.095492, 0.293893, 0.951057> }
triangle { <0.118256, 0.363954, 0.923880>, <0.119009, 0.368407, 0.929833>, <0.141185, 0.437054, 0.899532> }
triangle { <0.141185, 0.437054, 0.899532>, <0.140291, 0.431771, 0.891007>, <0.118256, 0.363954, 0.923880> }
triangle { <0.140291, 0.431771, 0.891007>, <0.141185, 0.437054, 0.899532>, <0.162490, 0.503006, 0.864166> }
triangle { <0.162490, 0.503006, 0.864166>, <0.161461, 0.496926, 0.852640>, <0.140291, 0.431771, 0.891007> }
triangle { <0.161461, 0.496926, 0.852640>, <0.162490, 0.503006, 0.864166>, <0.182793, 0.565858, 0.823955> }
triangle { <0.182793, 0.565858, 0.823955>, <0.181636, 0.559017, 0.809017>, <0.161461, 0.496926, 0.852640> }
triangle { <0.181636, 0.559017, 0.809017>, <0.182793, 0.565858, 0.823955>, <0.201969, 0.625220, 0.779146> }
triangle { <0.201969, 0.625220, 0.779146>, <0.200690, 0.617662, 0.760406>, <0.181636, 0.559017, 0.809017> }
triangle { <0.200690, 0.617662, 0.760406>, <0.201969, 0.625220, 0.779146>, <0.219900, 0.680728, 0.730016> }
triangle { <0.219900, 0.680728, 0.730016>, <0.218508, 0.672499, 0.707107>, <0.200690, 0.617662, 0.760406> }
triangle { <0.218508, 0.672499, 0.707107>, <0.219900, 0.680728, 0.730016>, <0.236476, 0.732039, 0.676867> }
triangle { <0.236476, 0.732039, 0.676867>, <0.234978, 0.723189, 0.649448>, <0.218508, 0.672499, 0.707107> }
triangle { <0.234978, 0.723189, 0.649448>, <0.236476, 0.732039, 0.676867>, <0.251593, 0.778836, 0.620028> }
triangle { <0.251593, 0.778836, 0.620028>, <0.250000, 0.769421, 0.587785>, <0.234978, 0.723189, 0.649448> }
triangle { <0.250000, 0.769421, 0.587785>, <0.251593, 0.778836, 0.620028>, <0.265159, 0.820832, 0.559847> }
triangle { <0.265159, 0.820832, 0.559847>, <0.263480, 0.810909, 0.522499>, <0.250000, 0.769421, 0.587785> }
triangle { <0.263480, 0.810909, 0.522499>, <0.265159, 0.820832, 0.559847>, <0.277091, 0.857767, 0.496698> }
triangle { <0.277091, 0.857767, 0.496698>, <0.275336, 0.847398, 0.453990>, <0.263480, 0.810909, 0.522499> }
triangle { <0.275336, 0.847398, 0.453990>, <0.277091, 0.857767, 0.496698>, <0.287314, 0.889414, 0.430968> }
triangle { <0.287314, 0.889414, 0.430968>, <0.285494, 0.878662, 0.382683>, <0.275336, 0.847398, 0.453990> }
triangle { <0.285494, 0.878662, 0.382683>, <0.287314, 0.889414, 0.430968>, <0.295765, 0.915577, 0.363064> }
triangle { <0.295765, 0.915577, 0.363064>, <0.293893, 0.904508, 0.309017>, <0.285494, 0.878662, 0.382683> }
triangle { <0.293893, 0.904508, 0.309017>, <0.295765, 0.915577, 0.363064>, <0.302393, 0.936095, 0.293403> }
triangle { <0.302393, 0.936095, 0.293403>, <0.300479, 0.924779, 0.233445>, <0.293893, 0.904508, 0.309017> }
triangle { <0.300479, 0.924779, 0.233445>, <0.302393, 0.936095, 0.293403>, <0.307157, 0.950842, 0.222416> }
triangle { <0.307157, 0.950842, 0.222416>, <0.305212, 0.939347, 0.156434>, <0.300479, 0.924779, 0.233445> }
triangle { <0.305212, 0.939347, 0.156434>, <0.307157, 0.950842, 0.222416>, <0.310027, 0.959727, 0.150539> }
triangle { <0.310027, 0.959727, 0.150539>, <0.308064, 0.948125, 0.078459>, <0.305212, 0.939347, 0.156434> }
triangle { <0.308064, 0.948125, 0.078459>, <0.310027, 0.959727, 0.150539>, <0.310986, 0.962694, 0.078217> }
triangle { <0.310986, 0.962694, 0.078217>, <0.309017, 0.951057, 0.000000>, <0.308064, 0.948125, 0.078459> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024323, 0.078285, 0.997394> }
triangle { <0.024323, 0.078285, 0.997394>, <0.024400, 0.075532, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024400, 0.075532, 0.997158>, <0.024323, 0.078285, 0.997394>, <0.048497, 0.156087, 0.989591> }
triangle { <0.048497, 0.156087, 0.989591>, <0.048649, 0.150599, 0.988651>, <0.024400, 0.075532, 0.997158> }
triangle { <0.048649, 0.150599, 0.988651>, <0.048497, 0.156087, 0.989591>, <0.072371, 0.232927, 0.976639> }
triangle { <0.072371, 0.232927, 0.976639>, <0.072598, 0.224737, 0.974531>, <0.048649, 0.150599, 0.988651> }
triangle { <0.072598, 0.224737, 0.974531>, <0.072371, 0.232927, 0.976639>, <0.095799, 0.308331, 0.958619> }
triangle { <0.095799, 0.308331, 0.958619>, <0.096100, 0.297489, 0.954885>, <0.072598, 0.224737, 0.974531> }
triangle { <0.096100, 0.297489, 0.954885>, <0.095799, 0.308331, 0.958619>, <0.118637, 0.381834, 0.935641> }
triangle { <0.118637, 0.381834, 0.935641>, <0.119009, 0.368407, 0.929833>, <0.096100, 0.297489, 0.954885> }
triangle { <0.119009, 0.368407, 0.929833>, <0.118637, 0.381834, 0.935641>, <0.140743, 0.452982, 0.907847> }
triangle { <0.140743, 0.452982, 0.907847>, <0.141185, 0.437054, 0.899532>, <0.119009, 0.368407, 0.929833> }
triangle { <0.141185, 0.437054, 0.899532>, <0.140743, 0.452982, 0.907847>, <0.161982, 0.521338, 0.875409> }
triangle { <0.161982, 0.521338, 0.875409>, <0.162490, 0.503006, 0.864166>, <0.141185, 0.437054, 0.899532> }
triangle { <0.162490, 0.503006, 0.864166>, <0.161982, 0.521338, 0.875409>, <0.182221, 0.586480, 0.838525> }
triangle { <0.182221, 0.586480, 0.838525>, <0.182793, 0.565858, 0.823955>, <0.162490, 0.503006, 0.864166> }
triangle { <0.182793, 0.565858, 0.823955>, <0.182221, 0.586480, 0.838525>, <0.201338, 0.648006, 0.797425> }
triangle { <0.201338, 0.648006, 0.797425>, <0.201969, 0.625220, 0.779146>, <0.182793, 0.565858, 0.823955> }
triangle { <0.201969, 0.625220, 0.779146>, <0.201338, 0.648006, 0.797425>, <0.219213, 0.705537, 0.752361> }
triangle { <0.219213, 0.705537, 0.752361>, <0.219900, 0.680728, 0.730016>, <0.201969, 0.625220, 0.779146> }
triangle { <0.219900, 0.680728, 0.730016>, <0.219213, 0.705537, 0.752361>, <0.235736, 0.758717, 0.703611> }
triangle { <0.235736, 0.758717, 0.703611>, <0.236476, 0.732039, 0.676867>, <0.219900, 0.680728, 0.730016> }
triangle { <0.236476, 0.732039, 0.676867>, <0.235736, 0.758717, 0.703611>, <0.250806, 0.807220, 0.651476> }
triangle { <0.250806, 0.807220, 0.651476>, <0.251593, 0.778836, 0.620028>, <0.236476, 0.732039, 0.676867> }
triangle { <0.251593, 0.778836, 0.620028>, <0.250806, 0.807220, 0.651476>, <0.264330, 0.850747, 0.596277> }
triangle { <0.264330, 0.850747, 0.596277>, <0.265159, 0.820832, 0.559847>, <0.251593, 0.778836, 0.620028> }
triangle { <0.265159, 0.820832, 0.559847>, <0.264330, 0.850747, 0.596277>, <0.276224, 0.889028, 0.538354> }
triangle { <0.276224, 0.889028, 0.538354>, <0.277091, 0.857767, 0.496698>, <0.265159, 0.820832, 0.559847> }
triangle { <0.277091, 0.857767, 0.496698>, <0.276224, 0.889028, 0.538354>, <0.286415, 0.921828, 0.478064> }
triangle { <0.286415, 0.921828, 0.478064>, <0.287314, 0.889414, 0.430968>, <0.277091, 0.857767, 0.496698> }
triangle { <0.287314, 0.889414, 0.430968>, <0.286415, 0.921828, 0.478064>, <0.294840, 0.948944, 0.415780> }
triangle { <0.294840, 0.948944, 0.415780>, <0.295765, 0.915577, 0.363064>, <0.287314, 0.889414, 0.430968> }
triangle { <0.295765, 0.915577, 0.363064>, <0.294840, 0.948944, 0.415780>, <0.301448, 0.970211, 0.351885> }
triangle { <0.301448, 0.970211, 0.351885>, <0.302393, 0.936095, 0.293403>, <0.295765, 0.915577, 0.363064> }
triangle { <0.302393, 0.936095, 0.293403>, <0.301448, 0.970211, 0.351885>, <0.306197, 0.985495, 0.286773> }
triangle { <0.306197, 0.985495, 0.286773>, <0.307157, 0.950842, 0.222416>, <0.302393, 0.936095, 0.293403> }
triangle { <0.307157, 0.950842, 0.222416>, <0.306197, 0.985495, 0.286773>, <0.309058, 0.994703, 0.220845> }
triangle { <0.309058, 0.994703, 0.220845>, <0.310027, 0.959727, 0.150539>, <0.307157, 0.950842, 0.222416> }
triangle { <0.310027, 0.959727, 0.150539>, <0.309058, 0.994703, 0.220845>, <0.310013, 0.997779, 0.154508> }
triangle { <0.310013, 0.997779, 0.154508>, <0.310986, 0.962694, 0.078217>, <0.310027, 0.959727, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.023239, 0.082667, 0.997617> }
triangle { <0.023239, 0.082667, 0.997617>, <0.024323, 0.078285, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024323, 0.078285, 0.997394>, <0.023239, 0.082667, 0.997617>, <0.046335, 0.164824, 0.990483> }
triangle { <0.046335, 0.164824, 0.990483>, <0.048497, 0.156087, 0.989591>, <0.024323, 0.078285, 0.997394> }
triangle { <0.048497, 0.156087, 0.989591>, <0.046335, 0.164824, 0.990483>, <0.069145, 0.245965, 0.978642> }
triangle { <0.069145, 0.245965, 0.978642>, <0.072371, 0.232927, 0.976639>, <0.048497, 0.156087, 0.989591> }
triangle { <0.072371, 0.232927, 0.976639>, <0.069145, 0.245965, 0.978642>, <0.091529, 0.325589, 0.962166> }
triangle { <0.091529, 0.325589, 0.962166>, <0.095799, 0.308331, 0.958619>, <0.072371, 0.232927, 0.976639> }
triangle { <0.095799, 0.308331, 0.958619>, <0.091529, 0.325589, 0.962166>, <0.113348, 0.403206, 0.941159> }
triangle { <0.113348, 0.403206, 0.941159>, <0.118637, 0.381834, 0.935641>, <0.095799, 0.308331, 0.958619> }
triangle { <0.118637, 0.381834, 0.935641>, <0.113348, 0.403206, 0.941159>, <0.134469, 0.478337, 0.915748> }
triangle { <0.134469, 0.478337, 0.915748>, <0.140743, 0.452982, 0.907847>, <0.118637, 0.381834, 0.935641> }
triangle { <0.140743, 0.452982, 0.907847>, <0.134469, 0.478337, 0.915748>, <0.154761, 0.550519, 0.886090> }
triangle { <0.154761, 0.550519, 0.886090>, <0.161982, 0.521338, 0.875409>, <0.140743, 0.452982, 0.907847> }
triangle { <0.161982, 0.521338, 0.875409>, <0.154761, 0.550519, 0.886090>, <0.174098, 0.619307, 0.852369> }
triangle { <0.174098, 0.619307, 0.852369>, <0.182221, 0.586480, 0.838525>, <0.161982, 0.521338, 0.875409> }
triangle { <0.182221, 0.586480, 0.838525>, <0.174098, 0.619307, 0.852369>, <0.192362, 0.684277, 0.814793> }
triangle { <0.192362, 0.684277, 0.814793>, <0.201338, 0.648006, 0.797425>, <0.182221, 0.586480, 0.838525> }
triangle { <0.201338, 0.648006, 0.797425>, <0.192362, 0.684277, 0.814793>, <0.209441, 0.745028, 0.773592> }
triangle { <0.209441, 0.745028, 0.773592>, <0.219213, 0.705537, 0.752361>, <0.201338, 0.648006, 0.797425> }
triangle { <0.219213, 0.705537, 0.752361>, <0.209441, 0.745028, 0.773592>, <0.225227, 0.801185, 0.729022> }
triangle { <0.225227, 0.801185, 0.729022>, <0.235736, 0.758717, 0.703611>, <0.219213, 0.705537, 0.752361> }
triangle { <0.235736, 0.758717, 0.703611>, <0.225227, 0.801185, 0.729022>, <0.239626, 0.852403, 0.681356> }
triangle { <0.239626, 0.852403, 0.681356>, <0.250806, 0.807220, 0.651476>, <0.235736, 0.758717, 0.703611> }
triangle { <0.250806, 0.807220, 0.651476>, <0.239626, 0.852403, 0.681356>, <0.252547, 0.898366, 0.630889> }
triangle { <0.252547, 0.898366, 0.630889>, <0.264330, 0.850747, 0.596277>, <0.250806, 0.807220, 0.651476> }
triangle { <0.264330, 0.850747, 0.596277>, <0.252547, 0.898366, 0.630889>, <0.263910, 0.938790, 0.577932> }
triangle { <0.263910, 0.938790, 0.577932>, <0.276224, 0.889028, 0.538354>, <0.264330, 0.850747, 0.596277> }
triangle { <0.276224, 0.889028, 0.538354>, <0.263910, 0.938790, 0.577932>, <0.273647, 0.973426, 0.522811> }
triangle { <0.273647, 0.973426, 0.522811>, <0.286415, 0.921828, 0.478064>, <0.276224, 0.889028, 0.538354> }
triangle { <0.286415, 0.921828, 0.478064>, <0.273647, 0.973426, 0.522811>, <0.281697, 1.002060, 0.465867> }
triangle { <0.281697, 1.002060, 0.465867>, <0.294840, 0.948944, 0.415780>, <0.286415, 0.921828, 0.478064> }
triangle { <0.294840, 0.948944, 0.415780>, <0.281697, 1.002060, 0.465867>, <0.288010, 1.024516, 0.407450> }
triangle { <0.288010, 1.024516, 0.407450>, <0.301448, 0.970211, 0.351885>, <0.294840, 0.948944, 0.415780> }
triangle { <0.301448, 0.970211, 0.351885>, <0.288010, 1.024516, 0.407450>, <0.292547, 1.040656, 0.347920> }
triangle { <0.292547, 1.040656, 0.347920>, <0.306197, 0.985495, 0.286773>, <0.301448, 0.970211, 0.351885> }
triangle { <0.306197, 0.985495, 0.286773>, <0.292547, 1.040656, 0.347920>, <0.295281, 1.050380, 0.287645> }
triangle { <0.295281, 1.050380, 0.287645>, <0.309058, 0.994703, 0.220845>, <0.306197, 0.985495, 0.286773> }
triangle { <0.309058, 0.994703, 0.220845>, <0.295281, 1.050380, 0.287645>, <0.296194, 1.053628, 0.226995> }
triangle { <0.296194, 1.053628, 0.226995>, <0.310013, 0.997779, 0.154508>, <0.309058, 0.994703, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.020502, 0.088189, 0.997823> }
triangle { <0.020502, 0.088189, 0.997823>, <0.023239, 0.082667, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <0.023239, 0.082667, 0.997617>, <0.020502, 0.088189, 0.997823>, <0.040877, 0.175833, 0.991307> }
triangle { <0.040877, 0.175833, 0.991307>, <0.046335, 0.164824, 0.990483>, <0.023239, 0.082667, 0.997617> }
triangle { <0.046335, 0.164824, 0.990483>, <0.040877, 0.175833, 0.991307>, <0.061000, 0.262394, 0.980490> }
triangle { <0.061000, 0.262394, 0.980490>, <0.069145, 0.245965, 0.978642>, <0.046335, 0.164824, 0.990483> }
triangle { <0.069145, 0.245965, 0.978642>, <0.061000, 0.262394, 0.980490>, <0.080747, 0.347337, 0.965441> }
triangle { <0.080747, 0.347337, 0.965441>, <0.091529, 0.325589, 0.962166>, <0.069145, 0.245965, 0.978642> }
triangle { <0.091529, 0.325589, 0.962166>, <0.080747, 0.347337, 0.965441>, <0.099997, 0.430139, 0.946251> }
triangle { <0.099997, 0.430139, 0.946251>, <0.113348, 0.403206, 0.941159>, <0.091529, 0.325589, 0.962166> }
triangle { <0.113348, 0.403206, 0.941159>, <0.099997, 0.430139, 0.946251>, <0.118629, 0.510289, 0.923039> }
triangle { <0.118629, 0.510289, 0.923039>, <0.134469, 0.478337, 0.915748>, <0.113348, 0.403206, 0.941159> }
triangle { <0.134469, 0.478337, 0.915748>, <0.118629, 0.510289, 0.923039>, <0.136531, 0.587292, 0.895948> }
triangle { <0.136531, 0.587292, 0.895948>, <0.154761, 0.550519, 0.886090>, <0.134469, 0.478337, 0.915748> }
triangle { <0.154761, 0.550519, 0.886090>, <0.136531, 0.587292, 0.895948>, <0.153591, 0.660675, 0.865145> }
triangle { <0.153591, 0.660675, 0.865145>, <0.174098, 0.619307, 0.852369>, <0.154761, 0.550519, 0.886090> }
triangle { <0.174098, 0.619307, 0.852369>, <0.153591, 0.660675, 0.865145>, <0.169703, 0.729984, 0.830821> }
triangle { <0.169703, 0.729984, 0.830821>, <0.192362, 0.684277, 0.814793>, <0.174098, 0.619307, 0.852369> }
triangle { <0.192362, 0.684277, 0.814793>, <0.169703, 0.729984, 0.830821>, <0.184770, 0.794793, 0.793186> }
triangle { <0.184770, 0.794793, 0.793186>, <0.209441, 0.745028, 0.773592>, <0.192362, 0.684277, 0.814793> }
triangle { <0.209441, 0.745028, 0.773592>, <0.184770, 0.794793, 0.793186>, <0.198697, 0.854702, 0.752473> }
triangle { <0.198697, 0.854702, 0.752473>, <0.225227, 0.801185, 0.729022>, <0.209441, 0.745028, 0.773592> }
triangle { <0.225227, 0.801185, 0.729022>, <0.198697, 0.854702, 0.752473>, <0.211399, 0.909341, 0.708932> }
triangle { <0.211399, 0.909341, 0.708932>, <0.239626, 0.852403, 0.681356>, <0.225227, 0.801185, 0.729022> }
triangle { <0.239626, 0.852403, 0.681356>, <0.211399, 0.909341, 0.708932>, <0.222798, 0.958374, 0.662833> }
triangle { <0.222798, 0.958374, 0.662833>, <0.252547, 0.898366, 0.630889>, <0.239626, 0.852403, 0.681356> }
triangle { <0.252547, 0.898366, 0.630889>, <0.222798, 0.958374, 0.662833>, <0.232823, 1.001498, 0.614459> }
triangle { <0.232823, 1.001498, 0.614459>, <0.263910, 0.938790, 0.577932>, <0.252547, 0.898366, 0.630889> }
triangle { <0.263910, 0.938790, 0.577932>, <0.232823, 1.001498, 0.614459>, <0.241413, 1.038447, 0.564108> }
triangle { <0.241413, 1.038447, 0.564108>, <0.273647, 0.973426, 0.522811>, <0.263910, 0.938790, 0.577932> }
triangle { <0.273647, 0.973426, 0.522811>, <0.241413, 1.038447, 0.564108>, <0.248515, 1.068994, 0.512092> }
triangle { <0.248515, 1.068994, 0.512092>, <0.281697, 1.002060, 0.465867>, <0.273647, 0.973426, 0.522811> }
triangle { <0.281697, 1.002060, 0.465867>, <0.248515, 1.068994, 0.512092>, <0.254084, 1.092951, 0.458730> }
triangle { <0.254084, 1.092951, 0.458730>, <0.288010, 1.024516, 0.407450>, <0.281697, 1.002060, 0.465867> }
triangle { <0.288010, 1.024516, 0.407450>, <0.254084, 1.092951, 0.458730>, <0.258087, 1.110169, 0.404352> }
triangle { <0.258087, 1.110169, 0.404352>, <0.292547, 1.040656, 0.347920>, <0.288010, 1.024516, 0.407450> }
triangle { <0.292547, 1.040656, 0.347920>, <0.258087, 1.110169, 0.404352>, <0.260498, 1.120542, 0.349293> }
triangle { <0.260498, 1.120542, 0.349293>, <0.295281, 1.050380, 0.287645>, <0.292547, 1.040656, 0.347920> }
triangle { <0.295281, 1.050380, 0.287645>, <0.260498, 1.120542, 0.349293>, <0.261304, 1.124007, 0.293893> }
triangle { <0.261304, 1.124007, 0.293893>, <0.296194, 1.053628, 0.226995>, <0.295281, 1.050380, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.015692, 0.094151, 0.998007> }
triangle { <0.015692, 0.094151, 0.998007>, <0.020502, 0.088189, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <0.020502, 0.088189, 0.997823>, <0.015692, 0.094151, 0.998007>, <0.031287, 0.187721, 0.992041> }
triangle { <0.031287, 0.187721, 0.992041>, <0.040877, 0.175833, 0.991307>, <0.020502, 0.088189, 0.997823> }
triangle { <0.040877, 0.175833, 0.991307>, <0.031287, 0.187721, 0.992041>, <0.046689, 0.280134, 0.982139> }
triangle { <0.046689, 0.280134, 0.982139>, <0.061000, 0.262394, 0.980490>, <0.040877, 0.175833, 0.991307> }
triangle { <0.061000, 0.262394, 0.980490>, <0.046689, 0.280134, 0.982139>, <0.061803, 0.370820, 0.968361> }
triangle { <0.061803, 0.370820, 0.968361>, <0.080747, 0.347337, 0.965441>, <0.061000, 0.262394, 0.980490> }
triangle { <0.080747, 0.347337, 0.965441>, <0.061803, 0.370820, 0.968361>, <0.076537, 0.459220, 0.950792> }
triangle { <0.076537, 0.459220, 0.950792>, <0.099997, 0.430139, 0.946251>, <0.080747, 0.347337, 0.965441> }
triangle { <0.099997, 0.430139, 0.946251>, <0.076537, 0.459220, 0.950792>, <0.090798, 0.544789, 0.929542> }
triangle { <0.090798, 0.544789, 0.929542>, <0.118629, 0.510289, 0.923039>, <0.099997, 0.430139, 0.946251> }
triangle { <0.118629, 0.510289, 0.923039>, <0.090798, 0.544789, 0.929542>, <0.104500, 0.626998, 0.904740> }
triangle { <0.104500, 0.626998, 0.904740>, <0.136531, 0.587292, 0.895948>, <0.118629, 0.510289, 0.923039> }
triangle { <0.136531, 0.587292, 0.895948>, <0.104500, 0.626998, 0.904740>, <0.117557, 0.705342, 0.876540> }
triangle { <0.117557, 0.705342, 0.876540>, <0.153591, 0.660675, 0.865145>, <0.136531, 0.587292, 0.895948> }
triangle { <0.153591, 0.660675, 0.865145>, <0.117557, 0.705342, 0.876540>, <0.129890, 0.779338, 0.845115> }
triangle { <0.129890, 0.779338, 0.845115>, <0.169703, 0.729984, 0.830821>, <0.153591, 0.660675, 0.865145> }
triangle { <0.169703, 0.729984, 0.830821>, <0.129890, 0.779338, 0.845115>, <0.141421, 0.848528, 0.810660> }
triangle { <0.141421, 0.848528, 0.810660>, <0.184770, 0.794793, 0.793186>, <0.169703, 0.729984, 0.830821> }
triangle { <0.184770, 0.794793, 0.793186>, <0.141421, 0.848528, 0.810660>, <0.152081, 0.912487, 0.773387> }
triangle { <0.152081, 0.912487, 0.773387>, <0.198697, 0.854702, 0.752473>, <0.184770, 0.794793, 0.793186> }
triangle { <0.198697, 0.854702, 0.752473>, <0.152081, 0.912487, 0.773387>, <0.161803, 0.970820, 0.733525> }
triangle { <0.161803, 0.970820, 0.733525>, <0.211399, 0.909341, 0.708932>, <0.198697, 0.854702, 0.752473> }
triangle { <0.211399, 0.909341, 0.708932>, <0.161803, 0.970820, 0.733525>, <0.170528, 1.023168, 0.691321> }
triangle { <0.170528, 1.023168, 0.691321>, <0.222798, 0.958374, 0.662833>, <0.211399, 0.909341, 0.708932> }
triangle { <0.222798, 0.958374, 0.662833>, <0.170528, 1.023168, 0.691321>, <0.178201, 1.069208, 0.647034> }
triangle { <0.178201, 1.069208, 0.647034>, <0.232823, 1.001498, 0.614459>, <0.222798, 0.958374, 0.662833> }
triangle { <0.232823, 1.001498, 0.614459>, <0.178201, 1.069208, 0.647034>, <0.184776, 1.108655, 0.600938> }
triangle { <0.184776, 1.108655, 0.600938>, <0.241413, 1.038447, 0.564108>, <0.232823, 1.001498, 0.614459> }
triangle { <0.241413, 1.038447, 0.564108>, <0.184776, 1.108655, 0.600938>, <0.190211, 1.141268, 0.553316> }
triangle { <0.190211, 1.141268, 0.553316>, <0.248515, 1.068994, 0.512092>, <0.241413, 1.038447, 0.564108> }
triangle { <0.248515, 1.068994, 0.512092>, <0.190211, 1.141268, 0.553316>, <0.194474, 1.166844, 0.504463> }
triangle { <0.194474, 1.166844, 0.504463>, <0.254084, 1.092951, 0.458730>, <0.248515, 1.068994, 0.512092> }
triangle { <0.254084, 1.092951, 0.458730>, <0.194474, 1.166844, 0.504463>, <0.197538, 1.185226, 0.454680> }
triangle { <0.197538, 1.185226, 0.454680>, <0.258087, 1.110169, 0.404352>, <0.254084, 1.092951, 0.458730> }
triangle { <0.258087, 1.110169, 0.404352>, <0.197538, 1.185226, 0.454680>, <0.199383, 1.196301, 0.404273> }
triangle { <0.199383, 1.196301, 0.404273>, <0.260498, 1.120542, 0.349293>, <0.258087, 1.110169, 0.404352> }
triangle { <0.260498, 1.120542, 0.349293>, <0.199383, 1.196301, 0.404273>, <0.200000, 1.200000, 0.353553> }
triangle { <0.200000, 1.200000, 0.353553>, <0.261304, 1.124007, 0.293893>, <0.260498, 1.120542, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.008678, 0.099742, 0.998164> }
triangle { <0.008678, 0.099742, 0.998164>, <0.015692, 0.094151, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <0.015692, 0.094151, 0.998007>, <0.008678, 0.099742, 0.998164>, <0.017303, 0.198868, 0.992669> }
triangle { <0.017303, 0.198868, 0.992669>, <0.031287, 0.187721, 0.992041>, <0.015692, 0.094151, 0.998007> }
triangle { <0.031287, 0.187721, 0.992041>, <0.017303, 0.198868, 0.992669>, <0.025821, 0.296769, 0.983547> }
triangle { <0.025821, 0.296769, 0.983547>, <0.046689, 0.280134, 0.982139>, <0.031287, 0.187721, 0.992041> }
triangle { <0.046689, 0.280134, 0.982139>, <0.025821, 0.296769, 0.983547>, <0.034179, 0.392840, 0.970855> }
triangle { <0.034179, 0.392840, 0.970855>, <0.061803, 0.370820, 0.968361>, <0.046689, 0.280134, 0.982139> }
triangle { <0.061803, 0.370820, 0.968361>, <0.034179, 0.392840, 0.970855>, <0.042327, 0.486489, 0.954671> }
triangle { <0.042327, 0.486489, 0.954671>, <0.076537, 0.459220, 0.950792>, <0.061803, 0.370820, 0.968361> }
triangle { <0.076537, 0.459220, 0.950792>, <0.042327, 0.486489, 0.954671>, <0.050214, 0.577139, 0.935095> }
triangle { <0.050214, 0.577139, 0.935095>, <0.090798, 0.544789, 0.929542>, <0.076537, 0.459220, 0.950792> }
triangle { <0.090798, 0.544789, 0.929542>, <0.050214, 0.577139, 0.935095>, <0.057792, 0.664230, 0.912248> }
triangle { <0.057792, 0.664230, 0.912248>, <0.104500, 0.626998, 0.904740>, <0.090798, 0.544789, 0.929542> }
triangle { <0.104500, 0.626998, 0.904740>, <0.057792, 0.664230, 0.912248>, <0.065013, 0.747226, 0.886271> }
triangle { <0.065013, 0.747226, 0.886271>, <0.117557, 0.705342, 0.876540>, <0.104500, 0.626998, 0.904740> }
triangle { <0.117557, 0.705342, 0.876540>, <0.065013, 0.747226, 0.886271>, <0.071833, 0.825615, 0.857324> }
triangle { <0.071833, 0.825615, 0.857324>, <0.129890, 0.779338, 0.845115>, <0.117557, 0.705342, 0.876540> }
triangle { <0.129890, 0.779338, 0.845115>, <0.071833, 0.825615, 0.857324>, <0.078211, 0.898914, 0.825585> }
triangle { <0.078211, 0.898914, 0.825585>, <0.141421, 0.848528, 0.810660>, <0.129890, 0.779338, 0.845115> }
triangle { <0.141421, 0.848528, 0.810660>, <0.078211, 0.898914, 0.825585>, <0.084106, 0.966671, 0.791249> }
triangle { <0.084106, 0.966671, 0.791249>, <0.152081, 0.912487, 0.773387>, <0.141421, 0.848528, 0.810660> }
triangle { <0.152081, 0.912487, 0.773387>, <0.084106, 0.966671, 0.791249>, <0.089483, 1.028469, 0.754530> }
triangle { <0.089483, 1.028469, 0.754530>, <0.161803, 0.970820, 0.733525>, <0.152081, 0.912487, 0.773387> }
triangle { <0.161803, 0.970820, 0.733525>, <0.089483, 1.028469, 0.754530>, <0.094308, 1.083925, 0.715652> }
triangle { <0.094308, 1.083925, 0.715652>, <0.170528, 1.023168, 0.691321>, <0.161803, 0.970820, 0.733525> }
triangle { <0.170528, 1.023168, 0.691321>, <0.094308, 1.083925, 0.715652>, <0.098551, 1.132698, 0.674856> }
triangle { <0.098551, 1.132698, 0.674856>, <0.178201, 1.069208, 0.647034>, <0.170528, 1.023168, 0.691321> }
triangle { <0.178201, 1.069208, 0.647034>, <0.098551, 1.132698, 0.674856>, <0.102187, 1.174488, 0.632393> }
triangle { <0.102187, 1.174488, 0.632393>, <0.184776, 1.108655, 0.600938>, <0.178201, 1.069208, 0.647034> }
triangle { <0.184776, 1.108655, 0.600938>, <0.102187, 1.174488, 0.632393>, <0.105193, 1.209037, 0.588525> }
triangle { <0.105193, 1.209037, 0.588525>, <0.190211, 1.141268, 0.553316>, <0.184776, 1.108655, 0.600938> }
triangle { <0.190211, 1.141268, 0.553316>, <0.105193, 1.209037, 0.588525>, <0.107551, 1.236132, 0.543523> }
triangle { <0.107551, 1.236132, 0.543523>, <0.194474, 1.166844, 0.504463>, <0.190211, 1.141268, 0.553316> }
triangle { <0.194474, 1.166844, 0.504463>, <0.107551, 1.236132, 0.543523>, <0.109245, 1.255606, 0.497664> }
triangle { <0.109245, 1.255606, 0.497664>, <0.197538, 1.185226, 0.454680>, <0.194474, 1.166844, 0.504463> }
triangle { <0.197538, 1.185226, 0.454680>, <0.109245, 1.255606, 0.497664>, <0.110266, 1.267338, 0.451230> }
triangle { <0.110266, 1.267338, 0.451230>, <0.199383, 1.196301, 0.404273>, <0.197538, 1.185226, 0.454680> }
triangle { <0.199383, 1.196301, 0.404273>, <0.110266, 1.267338, 0.451230>, <0.110607, 1.271257, 0.404508> }
triangle { <0.110607, 1.271257, 0.404508>, <0.200000, 1.200000, 0.353553>, <0.199383, 1.196301, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000361, 0.104150, 0.998291> }
triangle { <-0.000361, 0.104150, 0.998291>, <0.008678, 0.099742, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <0.008678, 0.099742, 0.998164>, <-0.000361, 0.104150, 0.998291>, <-0.000721, 0.207658, 0.993173> }
triangle { <-0.000721, 0.207658, 0.993173>, <0.017303, 0.198868, 0.992669>, <0.008678, 0.099742, 0.998164> }
triangle { <0.017303, 0.198868, 0.992669>, <-0.000721, 0.207658, 0.993173>, <-0.001075, 0.309886, 0.984679> }
triangle { <-0.001075, 0.309886, 0.984679>, <0.025821, 0.296769, 0.983547>, <0.017303, 0.198868, 0.992669> }
triangle { <0.025821, 0.296769, 0.983547>, <-0.001075, 0.309886, 0.984679>, <-0.001423, 0.410204, 0.972861> }
triangle { <-0.001423, 0.410204, 0.972861>, <0.034179, 0.392840, 0.970855>, <0.025821, 0.296769, 0.983547> }
triangle { <0.034179, 0.392840, 0.970855>, <-0.001423, 0.410204, 0.972861>, <-0.001763, 0.507992, 0.957791> }
triangle { <-0.001763, 0.507992, 0.957791>, <0.042327, 0.486489, 0.954671>, <0.034179, 0.392840, 0.970855> }
triangle { <0.042327, 0.486489, 0.954671>, <-0.001763, 0.507992, 0.957791>, <-0.002091, 0.602648, 0.939563> }
triangle { <-0.002091, 0.602648, 0.939563>, <0.050214, 0.577139, 0.935095>, <0.042327, 0.486489, 0.954671> }
triangle { <0.050214, 0.577139, 0.935095>, <-0.002091, 0.602648, 0.939563>, <-0.002407, 0.693589, 0.918289> }
triangle { <-0.002407, 0.693589, 0.918289>, <0.057792, 0.664230, 0.912248>, <0.050214, 0.577139, 0.935095> }
triangle { <0.057792, 0.664230, 0.912248>, <-0.002407, 0.693589, 0.918289>, <-0.002707, 0.780254, 0.894101> }
triangle { <-0.002707, 0.780254, 0.894101>, <0.065013, 0.747226, 0.886271>, <0.057792, 0.664230, 0.912248> }
triangle { <0.065013, 0.747226, 0.886271>, <-0.002707, 0.780254, 0.894101>, <-0.002991, 0.862108, 0.867146> }
triangle { <-0.002991, 0.862108, 0.867146>, <0.071833, 0.825615, 0.857324>, <0.065013, 0.747226, 0.886271> }
triangle { <0.071833, 0.825615, 0.857324>, <-0.002991, 0.862108, 0.867146>, <-0.003257, 0.938647, 0.837592> }
triangle { <-0.003257, 0.938647, 0.837592>, <0.078211, 0.898914, 0.825585>, <0.071833, 0.825615, 0.857324> }
triangle { <0.078211, 0.898914, 0.825585>, <-0.003257, 0.938647, 0.837592>, <-0.003503, 1.009399, 0.805620> }
triangle { <-0.003503, 1.009399, 0.805620>, <0.084106, 0.966671, 0.791249>, <0.078211, 0.898914, 0.825585> }
triangle { <0.084106, 0.966671, 0.791249>, <-0.003503, 1.009399, 0.805620>, <-0.003726, 1.073927, 0.771428> }
triangle { <-0.003726, 1.073927, 0.771428>, <0.089483, 1.028469, 0.754530>, <0.084106, 0.966671, 0.791249> }
triangle { <0.089483, 1.028469, 0.754530>, <-0.003726, 1.073927, 0.771428>, <-0.003927, 1.131835, 0.735227> }
triangle { <-0.003927, 1.131835, 0.735227>, <0.094308, 1.083925, 0.715652>, <0.089483, 1.028469, 0.754530> }
triangle { <0.094308, 1.083925, 0.715652>, <-0.003927, 1.131835, 0.735227>, <-0.004104, 1.182764, 0.697240> }
triangle { <-0.004104, 1.182764, 0.697240>, <0.098551, 1.132698, 0.674856>, <0.094308, 1.083925, 0.715652> }
triangle { <0.098551, 1.132698, 0.674856>, <-0.004104, 1.182764, 0.697240>, <-0.004256, 1.226401, 0.657700> }
triangle { <-0.004256, 1.226401, 0.657700>, <0.102187, 1.174488, 0.632393>, <0.098551, 1.132698, 0.674856> }
triangle { <0.102187, 1.174488, 0.632393>, <-0.004256, 1.226401, 0.657700>, <-0.004381, 1.262477, 0.616852> }
triangle { <-0.004381, 1.262477, 0.616852>, <0.105193, 1.209037, 0.588525>, <0.102187, 1.174488, 0.632393> }
triangle { <0.105193, 1.209037, 0.588525>, <-0.004381, 1.262477, 0.616852>, <-0.004479, 1.290770, 0.574948> }
triangle { <-0.004479, 1.290770, 0.574948>, <0.107551, 1.236132, 0.543523>, <0.105193, 1.209037, 0.588525> }
triangle { <0.107551, 1.236132, 0.543523>, <-0.004479, 1.290770, 0.574948>, <-0.004549, 1.311104, 0.532246> }
triangle { <-0.004549, 1.311104, 0.532246>, <0.109245, 1.255606, 0.497664>, <0.107551, 1.236132, 0.543523> }
triangle { <0.109245, 1.255606, 0.497664>, <-0.004549, 1.311104, 0.532246>, <-0.004592, 1.323355, 0.489009> }
triangle { <-0.004592, 1.323355, 0.489009>, <0.110266, 1.267338, 0.451230>, <0.109245, 1.255606, 0.497664> }
triangle { <0.110266, 1.267338, 0.451230>, <-0.004592, 1.323355, 0.489009>, <-0.004606, 1.327447, 0.445503> }
triangle { <-0.004606, 1.327447, 0.445503>, <0.110607, 1.271257, 0.404508>, <0.110266, 1.267338, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.010961, 0.106682, 0.998383> }
triangle { <-0.010961, 0.106682, 0.998383>, <-0.000361, 0.104150, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.000361, 0.104150, 0.998291>, <-0.010961, 0.106682, 0.998383>, <-0.021854, 0.212706, 0.993543> }
triangle { <-0.021854, 0.212706, 0.993543>, <-0.000721, 0.207658, 0.993173>, <-0.000361, 0.104150, 0.998291> }
triangle { <-0.000721, 0.207658, 0.993173>, <-0.021854, 0.212706, 0.993543>, <-0.032613, 0.317418, 0.985509> }
triangle { <-0.032613, 0.317418, 0.985509>, <-0.001075, 0.309886, 0.984679>, <-0.000721, 0.207658, 0.993173> }
triangle { <-0.001075, 0.309886, 0.984679>, <-0.032613, 0.317418, 0.985509>, <-0.043170, 0.420174, 0.974331> }
triangle { <-0.043170, 0.420174, 0.974331>, <-0.001423, 0.410204, 0.972861>, <-0.001075, 0.309886, 0.984679> }
triangle { <-0.001423, 0.410204, 0.972861>, <-0.043170, 0.420174, 0.974331>, <-0.053462, 0.520339, 0.960077> }
triangle { <-0.053462, 0.520339, 0.960077>, <-0.001763, 0.507992, 0.957791>, <-0.001423, 0.410204, 0.972861> }
triangle { <-0.001763, 0.507992, 0.957791>, <-0.053462, 0.520339, 0.960077>, <-0.063423, 0.617295, 0.942836> }
triangle { <-0.063423, 0.617295, 0.942836>, <-0.002091, 0.602648, 0.939563>, <-0.001763, 0.507992, 0.957791> }
triangle { <-0.002091, 0.602648, 0.939563>, <-0.063423, 0.617295, 0.942836>, <-0.072994, 0.710447, 0.922714> }
triangle { <-0.072994, 0.710447, 0.922714>, <-0.002407, 0.693589, 0.918289>, <-0.002091, 0.602648, 0.939563> }
triangle { <-0.002407, 0.693589, 0.918289>, <-0.072994, 0.710447, 0.922714>, <-0.082115, 0.799218, 0.899835> }
triangle { <-0.082115, 0.799218, 0.899835>, <-0.002707, 0.780254, 0.894101>, <-0.002407, 0.693589, 0.918289> }
triangle { <-0.002707, 0.780254, 0.894101>, <-0.082115, 0.799218, 0.899835>, <-0.090729, 0.883061, 0.874340> }
triangle { <-0.090729, 0.883061, 0.874340>, <-0.002991, 0.862108, 0.867146>, <-0.002707, 0.780254, 0.894101> }
triangle { <-0.002991, 0.862108, 0.867146>, <-0.090729, 0.883061, 0.874340>, <-0.098784, 0.961460, 0.846386> }
triangle { <-0.098784, 0.961460, 0.846386>, <-0.003257, 0.938647, 0.837592>, <-0.002991, 0.862108, 0.867146> }
triangle { <-0.003257, 0.938647, 0.837592>, <-0.098784, 0.961460, 0.846386>, <-0.106230, 1.033932, 0.816145> }
triangle { <-0.106230, 1.033932, 0.816145>, <-0.003503, 1.009399, 0.805620>, <-0.003257, 0.938647, 0.837592> }
triangle { <-0.003503, 1.009399, 0.805620>, <-0.106230, 1.033932, 0.816145>, <-0.113021, 1.100029, 0.783805> }
triangle { <-0.113021, 1.100029, 0.783805>, <-0.003726, 1.073927, 0.771428>, <-0.003503, 1.009399, 0.805620> }
triangle { <-0.003726, 1.073927, 0.771428>, <-0.113021, 1.100029, 0.783805>, <-0.119115, 1.159343, 0.749564> }
triangle { <-0.119115, 1.159343, 0.749564>, <-0.003927, 1.131835, 0.735227>, <-0.003726, 1.073927, 0.771428> }
triangle { <-0.003927, 1.131835, 0.735227>, <-0.119115, 1.159343, 0.749564>, <-0.124475, 1.211511, 0.713633> }
triangle { <-0.124475, 1.211511, 0.713633>, <-0.004104, 1.182764, 0.697240>, <-0.003927, 1.131835, 0.735227> }
triangle { <-0.004104, 1.182764, 0.697240>, <-0.124475, 1.211511, 0.713633>, <-0.129068, 1.256208, 0.676235> }
triangle { <-0.129068, 1.256208, 0.676235>, <-0.004256, 1.226401, 0.657700>, <-0.004104, 1.182764, 0.697240> }
triangle { <-0.004256, 1.226401, 0.657700>, <-0.129068, 1.256208, 0.676235>, <-0.132864, 1.293161, 0.637599> }
triangle { <-0.132864, 1.293161, 0.637599>, <-0.004381, 1.262477, 0.616852>, <-0.004256, 1.226401, 0.657700> }
triangle { <-0.004381, 1.262477, 0.616852>, <-0.132864, 1.293161, 0.637599>, <-0.135842, 1.322141, 0.597964> }
triangle { <-0.135842, 1.322141, 0.597964>, <-0.004479, 1.290770, 0.574948>, <-0.004381, 1.262477, 0.616852> }
triangle { <-0.004479, 1.290770, 0.574948>, <-0.135842, 1.322141, 0.597964>, <-0.137982, 1.342970, 0.557574> }
triangle { <-0.137982, 1.342970, 0.557574>, <-0.004549, 1.311104, 0.532246>, <-0.004479, 1.290770, 0.574948> }
triangle { <-0.004549, 1.311104, 0.532246>, <-0.137982, 1.342970, 0.557574>, <-0.139271, 1.355519, 0.516678> }
triangle { <-0.139271, 1.355519, 0.516678>, <-0.004592, 1.323355, 0.489009>, <-0.004549, 1.311104, 0.532246> }
triangle { <-0.004592, 1.323355, 0.489009>, <-0.139271, 1.355519, 0.516678>, <-0.139702, 1.359710, 0.475528> }
triangle { <-0.139702, 1.359710, 0.475528>, <-0.004606, 1.327447, 0.445503>, <-0.004592, 1.323355, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.022429, 0.106854, 0.998440> }
triangle { <-0.022429, 0.106854, 0.998440>, <-0.010961, 0.106682, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.010961, 0.106682, 0.998383>, <-0.022429, 0.106854, 0.998440>, <-0.044720, 0.213049, 0.993768> }
triangle { <-0.044720, 0.213049, 0.993768>, <-0.021854, 0.212706, 0.993543>, <-0.010961, 0.106682, 0.998383> }
triangle { <-0.021854, 0.212706, 0.993543>, <-0.044720, 0.213049, 0.993768>, <-0.066735, 0.317930, 0.986015> }
triangle { <-0.066735, 0.317930, 0.986015>, <-0.032613, 0.317418, 0.985509>, <-0.021854, 0.212706, 0.993543> }
triangle { <-0.032613, 0.317418, 0.985509>, <-0.066735, 0.317930, 0.986015>, <-0.088339, 0.420852, 0.975227> }
triangle { <-0.088339, 0.420852, 0.975227>, <-0.043170, 0.420174, 0.974331>, <-0.032613, 0.317418, 0.985509> }
triangle { <-0.043170, 0.420174, 0.974331>, <-0.088339, 0.420852, 0.975227>, <-0.109398, 0.521179, 0.961471> }
triangle { <-0.109398, 0.521179, 0.961471>, <-0.053462, 0.520339, 0.960077>, <-0.043170, 0.420174, 0.974331> }
triangle { <-0.053462, 0.520339, 0.960077>, <-0.109398, 0.521179, 0.961471>, <-0.129782, 0.618292, 0.944832> }
triangle { <-0.129782, 0.618292, 0.944832>, <-0.063423, 0.617295, 0.942836>, <-0.053462, 0.520339, 0.960077> }
triangle { <-0.063423, 0.617295, 0.942836>, <-0.129782, 0.618292, 0.944832>, <-0.149367, 0.711593, 0.925413> }
triangle { <-0.149367, 0.711593, 0.925413>, <-0.072994, 0.710447, 0.922714>, <-0.063423, 0.617295, 0.942836> }
triangle { <-0.072994, 0.710447, 0.922714>, <-0.149367, 0.711593, 0.925413>, <-0.168030, 0.800508, 0.903333> }
triangle { <-0.168030, 0.800508, 0.903333>, <-0.082115, 0.799218, 0.899835>, <-0.072994, 0.710447, 0.922714> }
triangle { <-0.082115, 0.799218, 0.899835>, <-0.168030, 0.800508, 0.903333>, <-0.185658, 0.884487, 0.878728> }
triangle { <-0.185658, 0.884487, 0.878728>, <-0.090729, 0.883061, 0.874340>, <-0.082115, 0.799218, 0.899835> }
triangle { <-0.090729, 0.883061, 0.874340>, <-0.185658, 0.884487, 0.878728>, <-0.202140, 0.963012, 0.851750> }
triangle { <-0.202140, 0.963012, 0.851750>, <-0.098784, 0.961460, 0.846386>, <-0.090729, 0.883061, 0.874340> }
triangle { <-0.098784, 0.961460, 0.846386>, <-0.202140, 0.963012, 0.851750>, <-0.217377, 1.035601, 0.822566> }
triangle { <-0.217377, 1.035601, 0.822566>, <-0.106230, 1.033932, 0.816145>, <-0.098784, 0.961460, 0.846386> }
triangle { <-0.106230, 1.033932, 0.816145>, <-0.217377, 1.035601, 0.822566>, <-0.231273, 1.101804, 0.791355> }
triangle { <-0.231273, 1.101804, 0.791355>, <-0.113021, 1.100029, 0.783805>, <-0.106230, 1.033932, 0.816145> }
triangle { <-0.113021, 1.100029, 0.783805>, <-0.231273, 1.101804, 0.791355>, <-0.243744, 1.161215, 0.758310> }
triangle { <-0.243744, 1.161215, 0.758310>, <-0.119115, 1.159343, 0.749564>, <-0.113021, 1.100029, 0.783805> }
triangle { <-0.119115, 1.159343, 0.749564>, <-0.243744, 1.161215, 0.758310>, <-0.254712, 1.213466, 0.723634> }
triangle { <-0.254712, 1.213466, 0.723634>, <-0.124475, 1.211511, 0.713633>, <-0.119115, 1.159343, 0.749564> }
triangle { <-0.124475, 1.211511, 0.713633>, <-0.254712, 1.213466, 0.723634>, <-0.264109, 1.258236, 0.687542> }
triangle { <-0.264109, 1.258236, 0.687542>, <-0.129068, 1.256208, 0.676235>, <-0.124475, 1.211511, 0.713633> }
triangle { <-0.129068, 1.256208, 0.676235>, <-0.264109, 1.258236, 0.687542>, <-0.271878, 1.295249, 0.650255> }
triangle { <-0.271878, 1.295249, 0.650255>, <-0.132864, 1.293161, 0.637599>, <-0.129068, 1.256208, 0.676235> }
triangle { <-0.132864, 1.293161, 0.637599>, <-0.271878, 1.295249, 0.650255>, <-0.277971, 1.324276, 0.612004> }
triangle { <-0.277971, 1.324276, 0.612004>, <-0.135842, 1.322141, 0.597964>, <-0.132864, 1.293161, 0.637599> }
triangle { <-0.135842, 1.322141, 0.597964>, <-0.277971, 1.324276, 0.612004>, <-0.282350, 1.345138, 0.573024> }
triangle { <-0.282350, 1.345138, 0.573024>, <-0.137982, 1.342970, 0.557574>, <-0.135842, 1.322141, 0.597964> }
triangle { <-0.137982, 1.342970, 0.557574>, <-0.282350, 1.345138, 0.573024>, <-0.284989, 1.357707, 0.533557> }
triangle { <-0.284989, 1.357707, 0.533557>, <-0.139271, 1.355519, 0.516678>, <-0.137982, 1.342970, 0.557574> }
triangle { <-0.139271, 1.355519, 0.516678>, <-0.284989, 1.357707, 0.533557>, <-0.285870, 1.361905, 0.493844> }
triangle { <-0.285870, 1.361905, 0.493844>, <-0.139702, 1.359710, 0.475528>, <-0.139271, 1.355519, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.033943, 0.104467, 0.998459> }
triangle { <-0.033943, 0.104467, 0.998459>, <-0.022429, 0.106854, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.022429, 0.106854, 0.998440>, <-0.033943, 0.104467, 0.998459>, <-0.067677, 0.208289, 0.993844> }
triangle { <-0.067677, 0.208289, 0.993844>, <-0.044720, 0.213049, 0.993768>, <-0.022429, 0.106854, 0.998440> }
triangle { <-0.044720, 0.213049, 0.993768>, <-0.067677, 0.208289, 0.993844>, <-0.100994, 0.310828, 0.986185> }
triangle { <-0.100994, 0.310828, 0.986185>, <-0.066735, 0.317930, 0.986015>, <-0.044720, 0.213049, 0.993768> }
triangle { <-0.066735, 0.317930, 0.986015>, <-0.100994, 0.310828, 0.986185>, <-0.133688, 0.411450, 0.975528> }
triangle { <-0.133688, 0.411450, 0.975528>, <-0.088339, 0.420852, 0.975227>, <-0.066735, 0.317930, 0.986015> }
triangle { <-0.088339, 0.420852, 0.975227>, <-0.133688, 0.411450, 0.975528>, <-0.165558, 0.509535, 0.961940> }
triangle { <-0.165558, 0.509535, 0.961940>, <-0.109398, 0.521179, 0.961471>, <-0.088339, 0.420852, 0.975227> }
triangle { <-0.109398, 0.521179, 0.961471>, <-0.165558, 0.509535, 0.961940>, <-0.196407, 0.604479, 0.945503> }
triangle { <-0.196407, 0.604479, 0.945503>, <-0.129782, 0.618292, 0.944832>, <-0.109398, 0.521179, 0.961471> }
triangle { <-0.129782, 0.618292, 0.944832>, <-0.196407, 0.604479, 0.945503>, <-0.226045, 0.695696, 0.926320> }
triangle { <-0.226045, 0.695696, 0.926320>, <-0.149367, 0.711593, 0.925413>, <-0.129782, 0.618292, 0.944832> }
triangle { <-0.149367, 0.711593, 0.925413>, <-0.226045, 0.695696, 0.926320>, <-0.254290, 0.782624, 0.904508> }
triangle { <-0.254290, 0.782624, 0.904508>, <-0.168030, 0.800508, 0.903333>, <-0.149367, 0.711593, 0.925413> }
triangle { <-0.168030, 0.800508, 0.903333>, <-0.254290, 0.782624, 0.904508>, <-0.280967, 0.864727, 0.880203> }
triangle { <-0.280967, 0.864727, 0.880203>, <-0.185658, 0.884487, 0.878728>, <-0.168030, 0.800508, 0.903333> }
triangle { <-0.185658, 0.884487, 0.878728>, <-0.280967, 0.864727, 0.880203>, <-0.305911, 0.941498, 0.853553> }
triangle { <-0.305911, 0.941498, 0.853553>, <-0.202140, 0.963012, 0.851750>, <-0.185658, 0.884487, 0.878728> }
triangle { <-0.202140, 0.963012, 0.851750>, <-0.305911, 0.941498, 0.853553>, <-0.328970, 1.012465, 0.824724> }
triangle { <-0.328970, 1.012465, 0.824724>, <-0.217377, 1.035601, 0.822566>, <-0.202140, 0.963012, 0.851750> }
triangle { <-0.217377, 1.035601, 0.822566>, <-0.328970, 1.012465, 0.824724>, <-0.350000, 1.077189, 0.793893> }
triangle { <-0.350000, 1.077189, 0.793893>, <-0.231273, 1.101804, 0.791355>, <-0.217377, 1.035601, 0.822566> }
triangle { <-0.231273, 1.101804, 0.791355>, <-0.350000, 1.077189, 0.793893>, <-0.368872, 1.135273, 0.761249> }
triangle { <-0.368872, 1.135273, 0.761249>, <-0.243744, 1.161215, 0.758310>, <-0.231273, 1.101804, 0.791355> }
triangle { <-0.243744, 1.161215, 0.758310>, <-0.368872, 1.135273, 0.761249>, <-0.385471, 1.186357, 0.726995> }
triangle { <-0.385471, 1.186357, 0.726995>, <-0.254712, 1.213466, 0.723634>, <-0.243744, 1.161215, 0.758310> }
triangle { <-0.254712, 1.213466, 0.723634>, <-0.385471, 1.186357, 0.726995>, <-0.399692, 1.230126, 0.691342> }
triangle { <-0.399692, 1.230126, 0.691342>, <-0.264109, 1.258236, 0.687542>, <-0.254712, 1.213466, 0.723634> }
triangle { <-0.264109, 1.258236, 0.687542>, <-0.399692, 1.230126, 0.691342>, <-0.411450, 1.266312, 0.654508> }
triangle { <-0.411450, 1.266312, 0.654508>, <-0.271878, 1.295249, 0.650255>, <-0.264109, 1.258236, 0.687542> }
triangle { <-0.271878, 1.295249, 0.650255>, <-0.411450, 1.266312, 0.654508>, <-0.420670, 1.294690, 0.616723> }
triangle { <-0.420670, 1.294690, 0.616723>, <-0.277971, 1.324276, 0.612004>, <-0.271878, 1.295249, 0.650255> }
triangle { <-0.277971, 1.324276, 0.612004>, <-0.420670, 1.294690, 0.616723>, <-0.427297, 1.315086, 0.578217> }
triangle { <-0.427297, 1.315086, 0.578217>, <-0.282350, 1.345138, 0.573024>, <-0.277971, 1.324276, 0.612004> }
triangle { <-0.282350, 1.345138, 0.573024>, <-0.427297, 1.315086, 0.578217>, <-0.431290, 1.327375, 0.539230> }
triangle { <-0.431290, 1.327375, 0.539230>, <-0.284989, 1.357707, 0.533557>, <-0.282350, 1.345138, 0.573024> }
triangle { <-0.284989, 1.357707, 0.533557>, <-0.431290, 1.327375, 0.539230>, <-0.432624, 1.331479, 0.500000> }
triangle { <-0.432624, 1.331479, 0.500000>, <-0.285870, 1.361905, 0.493844>, <-0.284989, 1.357707, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.044662, 0.099630, 0.998440> }
triangle { <-0.044662, 0.099630, 0.998440>, <-0.033943, 0.104467, 0.998459>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.033943, 0.104467, 0.998459>, <-0.044662, 0.099630, 0.998440>, <-0.089048, 0.198646, 0.993768> }
triangle { <-0.089048, 0.198646, 0.993768>, <-0.067677, 0.208289, 0.993844>, <-0.033943, 0.104467, 0.998459> }
triangle { <-0.067677, 0.208289, 0.993844>, <-0.089048, 0.198646, 0.993768>, <-0.132885, 0.296437, 0.986015> }
triangle { <-0.132885, 0.296437, 0.986015>, <-0.100994, 0.310828, 0.986185>, <-0.067677, 0.208289, 0.993844> }
triangle { <-0.100994, 0.310828, 0.986185>, <-0.132885, 0.296437, 0.986015>, <-0.175903, 0.392400, 0.975227> }
triangle { <-0.175903, 0.392400, 0.975227>, <-0.133688, 0.411450, 0.975528>, <-0.100994, 0.310828, 0.986185> }
triangle { <-0.133688, 0.411450, 0.975528>, <-0.175903, 0.392400, 0.975227>, <-0.217837, 0.485945, 0.961471> }
triangle { <-0.217837, 0.485945, 0.961471>, <-0.165558, 0.509535, 0.961940>, <-0.133688, 0.411450, 0.975528> }
triangle { <-0.165558, 0.509535, 0.961940>, <-0.217837, 0.485945, 0.961471>, <-0.258427, 0.576493, 0.944832> }
triangle { <-0.258427, 0.576493, 0.944832>, <-0.196407, 0.604479, 0.945503>, <-0.165558, 0.509535, 0.961940> }
triangle { <-0.196407, 0.604479, 0.945503>, <-0.258427, 0.576493, 0.944832>, <-0.297424, 0.663487, 0.925413> }
triangle { <-0.297424, 0.663487, 0.925413>, <-0.226045, 0.695696, 0.926320>, <-0.196407, 0.604479, 0.945503> }
triangle { <-0.226045, 0.695696, 0.926320>, <-0.297424, 0.663487, 0.925413>, <-0.334588, 0.746390, 0.903333> }
triangle { <-0.334588, 0.746390, 0.903333>, <-0.254290, 0.782624, 0.904508>, <-0.226045, 0.695696, 0.926320> }
triangle { <-0.254290, 0.782624, 0.904508>, <-0.334588, 0.746390, 0.903333>, <-0.369688, 0.824691, 0.878728> }
triangle { <-0.369688, 0.824691, 0.878728>, <-0.280967, 0.864727, 0.880203>, <-0.254290, 0.782624, 0.904508> }
triangle { <-0.280967, 0.864727, 0.880203>, <-0.369688, 0.824691, 0.878728>, <-0.402509, 0.897909, 0.851750> }
triangle { <-0.402509, 0.897909, 0.851750>, <-0.305911, 0.941498, 0.853553>, <-0.280967, 0.864727, 0.880203> }
triangle { <-0.305911, 0.941498, 0.853553>, <-0.402509, 0.897909, 0.851750>, <-0.432849, 0.965590, 0.822566> }
triangle { <-0.432849, 0.965590, 0.822566>, <-0.328970, 1.012465, 0.824724>, <-0.305911, 0.941498, 0.853553> }
triangle { <-0.328970, 1.012465, 0.824724>, <-0.432849, 0.965590, 0.822566>, <-0.460520, 1.027318, 0.791355> }
triangle { <-0.460520, 1.027318, 0.791355>, <-0.350000, 1.077189, 0.793893>, <-0.328970, 1.012465, 0.824724> }
triangle { <-0.350000, 1.077189, 0.793893>, <-0.460520, 1.027318, 0.791355>, <-0.485352, 1.082712, 0.758310> }
triangle { <-0.485352, 1.082712, 0.758310>, <-0.368872, 1.135273, 0.761249>, <-0.350000, 1.077189, 0.793893> }
triangle { <-0.368872, 1.135273, 0.761249>, <-0.485352, 1.082712, 0.758310>, <-0.507191, 1.131431, 0.723634> }
triangle { <-0.507191, 1.131431, 0.723634>, <-0.385471, 1.186357, 0.726995>, <-0.368872, 1.135273, 0.761249> }
triangle { <-0.385471, 1.186357, 0.726995>, <-0.507191, 1.131431, 0.723634>, <-0.525904, 1.173174, 0.687542> }
triangle { <-0.525904, 1.173174, 0.687542>, <-0.399692, 1.230126, 0.691342>, <-0.385471, 1.186357, 0.726995> }
triangle { <-0.399692, 1.230126, 0.691342>, <-0.525904, 1.173174, 0.687542>, <-0.541374, 1.207684, 0.650255> }
triangle { <-0.541374, 1.207684, 0.650255>, <-0.411450, 1.266312, 0.654508>, <-0.399692, 1.230126, 0.691342> }
triangle { <-0.411450, 1.266312, 0.654508>, <-0.541374, 1.207684, 0.650255>, <-0.553506, 1.234749, 0.612004> }
triangle { <-0.553506, 1.234749, 0.612004>, <-0.420670, 1.294690, 0.616723>, <-0.411450, 1.266312, 0.654508> }
triangle { <-0.420670, 1.294690, 0.616723>, <-0.553506, 1.234749, 0.612004>, <-0.562226, 1.254201, 0.573024> }
triangle { <-0.562226, 1.254201, 0.573024>, <-0.427297, 1.315086, 0.578217>, <-0.420670, 1.294690, 0.616723> }
triangle { <-0.427297, 1.315086, 0.578217>, <-0.562226, 1.254201, 0.573024>, <-0.567480, 1.265920, 0.533557> }
triangle { <-0.567480, 1.265920, 0.533557>, <-0.431290, 1.327375, 0.539230>, <-0.427297, 1.315086, 0.578217> }
triangle { <-0.431290, 1.327375, 0.539230>, <-0.567480, 1.265920, 0.533557>, <-0.569234, 1.269834, 0.493844> }
triangle { <-0.569234, 1.269834, 0.493844>, <-0.432624, 1.331479, 0.500000>, <-0.431290, 1.327375, 0.539230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.053838, 0.092750, 0.998383> }
triangle { <-0.053838, 0.092750, 0.998383>, <-0.044662, 0.099630, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.044662, 0.099630, 0.998440>, <-0.053838, 0.092750, 0.998383>, <-0.107345, 0.184928, 0.993543> }
triangle { <-0.107345, 0.184928, 0.993543>, <-0.089048, 0.198646, 0.993768>, <-0.044662, 0.099630, 0.998440> }
triangle { <-0.089048, 0.198646, 0.993768>, <-0.107345, 0.184928, 0.993543>, <-0.160189, 0.275966, 0.985509> }
triangle { <-0.160189, 0.275966, 0.985509>, <-0.132885, 0.296437, 0.986015>, <-0.089048, 0.198646, 0.993768> }
triangle { <-0.132885, 0.296437, 0.986015>, <-0.160189, 0.275966, 0.985509>, <-0.212046, 0.365302, 0.974331> }
triangle { <-0.212046, 0.365302, 0.974331>, <-0.175903, 0.392400, 0.975227>, <-0.132885, 0.296437, 0.986015> }
triangle { <-0.175903, 0.392400, 0.975227>, <-0.212046, 0.365302, 0.974331>, <-0.262596, 0.452387, 0.960077> }
triangle { <-0.262596, 0.452387, 0.960077>, <-0.217837, 0.485945, 0.961471>, <-0.175903, 0.392400, 0.975227> }
triangle { <-0.217837, 0.485945, 0.961471>, <-0.262596, 0.452387, 0.960077>, <-0.311527, 0.536682, 0.942836> }
triangle { <-0.311527, 0.536682, 0.942836>, <-0.258427, 0.576493, 0.944832>, <-0.217837, 0.485945, 0.961471> }
triangle { <-0.258427, 0.576493, 0.944832>, <-0.311527, 0.536682, 0.942836>, <-0.358537, 0.617668, 0.922714> }
triangle { <-0.358537, 0.617668, 0.922714>, <-0.297424, 0.663487, 0.925413>, <-0.258427, 0.576493, 0.944832> }
triangle { <-0.297424, 0.663487, 0.925413>, <-0.358537, 0.617668, 0.922714>, <-0.403336, 0.694846, 0.899835> }
triangle { <-0.403336, 0.694846, 0.899835>, <-0.334588, 0.746390, 0.903333>, <-0.297424, 0.663487, 0.925413> }
triangle { <-0.334588, 0.746390, 0.903333>, <-0.403336, 0.694846, 0.899835>, <-0.445649, 0.767741, 0.874340> }
triangle { <-0.445649, 0.767741, 0.874340>, <-0.369688, 0.824691, 0.878728>, <-0.334588, 0.746390, 0.903333> }
triangle { <-0.369688, 0.824691, 0.878728>, <-0.445649, 0.767741, 0.874340>, <-0.485214, 0.835901, 0.846386> }
triangle { <-0.485214, 0.835901, 0.846386>, <-0.402509, 0.897909, 0.851750>, <-0.369688, 0.824691, 0.878728> }
triangle { <-0.402509, 0.897909, 0.851750>, <-0.485214, 0.835901, 0.846386>, <-0.521788, 0.898909, 0.816145> }
triangle { <-0.521788, 0.898909, 0.816145>, <-0.432849, 0.965590, 0.822566>, <-0.402509, 0.897909, 0.851750> }
triangle { <-0.432849, 0.965590, 0.822566>, <-0.521788, 0.898909, 0.816145>, <-0.555145, 0.956374, 0.783805> }
triangle { <-0.555145, 0.956374, 0.783805>, <-0.460520, 1.027318, 0.791355>, <-0.432849, 0.965590, 0.822566> }
triangle { <-0.460520, 1.027318, 0.791355>, <-0.555145, 0.956374, 0.783805>, <-0.585079, 1.007943, 0.749564> }
triangle { <-0.585079, 1.007943, 0.749564>, <-0.485352, 1.082712, 0.758310>, <-0.460520, 1.027318, 0.791355> }
triangle { <-0.485352, 1.082712, 0.758310>, <-0.585079, 1.007943, 0.749564>, <-0.611406, 1.053297, 0.713633> }
triangle { <-0.611406, 1.053297, 0.713633>, <-0.507191, 1.131431, 0.723634>, <-0.485352, 1.082712, 0.758310> }
triangle { <-0.507191, 1.131431, 0.723634>, <-0.611406, 1.053297, 0.713633>, <-0.633963, 1.092158, 0.676235> }
triangle { <-0.633963, 1.092158, 0.676235>, <-0.525904, 1.173174, 0.687542>, <-0.507191, 1.131431, 0.723634> }
triangle { <-0.525904, 1.173174, 0.687542>, <-0.633963, 1.092158, 0.676235>, <-0.652612, 1.124285, 0.637599> }
triangle { <-0.652612, 1.124285, 0.637599>, <-0.541374, 1.207684, 0.650255>, <-0.525904, 1.173174, 0.687542> }
triangle { <-0.541374, 1.207684, 0.650255>, <-0.652612, 1.124285, 0.637599>, <-0.667237, 1.149480, 0.597964> }
triangle { <-0.667237, 1.149480, 0.597964>, <-0.553506, 1.234749, 0.612004>, <-0.541374, 1.207684, 0.650255> }
triangle { <-0.553506, 1.234749, 0.612004>, <-0.667237, 1.149480, 0.597964>, <-0.677748, 1.167589, 0.557574> }
triangle { <-0.677748, 1.167589, 0.557574>, <-0.562226, 1.254201, 0.573024>, <-0.553506, 1.234749, 0.612004> }
triangle { <-0.562226, 1.254201, 0.573024>, <-0.677748, 1.167589, 0.557574>, <-0.684081, 1.178499, 0.516678> }
triangle { <-0.684081, 1.178499, 0.516678>, <-0.567480, 1.265920, 0.533557>, <-0.562226, 1.254201, 0.573024> }
triangle { <-0.567480, 1.265920, 0.533557>, <-0.684081, 1.178499, 0.516678>, <-0.686196, 1.182143, 0.475528> }
triangle { <-0.686196, 1.182143, 0.475528>, <-0.569234, 1.269834, 0.493844>, <-0.567480, 1.265920, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.060926, 0.084472, 0.998291> }
triangle { <-0.060926, 0.084472, 0.998291>, <-0.053838, 0.092750, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.053838, 0.092750, 0.998383>, <-0.060926, 0.084472, 0.998291>, <-0.121476, 0.168423, 0.993173> }
triangle { <-0.121476, 0.168423, 0.993173>, <-0.107345, 0.184928, 0.993543>, <-0.053838, 0.092750, 0.998383> }
triangle { <-0.107345, 0.184928, 0.993543>, <-0.121476, 0.168423, 0.993173>, <-0.181277, 0.251335, 0.984679> }
triangle { <-0.181277, 0.251335, 0.984679>, <-0.160189, 0.275966, 0.985509>, <-0.107345, 0.184928, 0.993543> }
triangle { <-0.160189, 0.275966, 0.985509>, <-0.181277, 0.251335, 0.984679>, <-0.239960, 0.332698, 0.972861> }
triangle { <-0.239960, 0.332698, 0.972861>, <-0.212046, 0.365302, 0.974331>, <-0.160189, 0.275966, 0.985509> }
triangle { <-0.212046, 0.365302, 0.974331>, <-0.239960, 0.332698, 0.972861>, <-0.297164, 0.412010, 0.957791> }
triangle { <-0.297164, 0.412010, 0.957791>, <-0.262596, 0.452387, 0.960077>, <-0.212046, 0.365302, 0.974331> }
triangle { <-0.262596, 0.452387, 0.960077>, <-0.297164, 0.412010, 0.957791>, <-0.352536, 0.488782, 0.939563> }
triangle { <-0.352536, 0.488782, 0.939563>, <-0.311527, 0.536682, 0.942836>, <-0.262596, 0.452387, 0.960077> }
triangle { <-0.311527, 0.536682, 0.942836>, <-0.352536, 0.488782, 0.939563>, <-0.405734, 0.562540, 0.918289> }
triangle { <-0.405734, 0.562540, 0.918289>, <-0.358537, 0.617668, 0.922714>, <-0.311527, 0.536682, 0.942836> }
triangle { <-0.358537, 0.617668, 0.922714>, <-0.405734, 0.562540, 0.918289>, <-0.456431, 0.632830, 0.894101> }
triangle { <-0.456431, 0.632830, 0.894101>, <-0.403336, 0.694846, 0.899835>, <-0.358537, 0.617668, 0.922714> }
triangle { <-0.403336, 0.694846, 0.899835>, <-0.456431, 0.632830, 0.894101>, <-0.504314, 0.699218, 0.867146> }
triangle { <-0.504314, 0.699218, 0.867146>, <-0.445649, 0.767741, 0.874340>, <-0.403336, 0.694846, 0.899835> }
triangle { <-0.445649, 0.767741, 0.874340>, <-0.504314, 0.699218, 0.867146>, <-0.549088, 0.761296, 0.837592> }
triangle { <-0.549088, 0.761296, 0.837592>, <-0.485214, 0.835901, 0.846386>, <-0.445649, 0.767741, 0.874340> }
triangle { <-0.485214, 0.835901, 0.846386>, <-0.549088, 0.761296, 0.837592>, <-0.590476, 0.818679, 0.805620> }
triangle { <-0.590476, 0.818679, 0.805620>, <-0.521788, 0.898909, 0.816145>, <-0.485214, 0.835901, 0.846386> }
triangle { <-0.521788, 0.898909, 0.816145>, <-0.590476, 0.818679, 0.805620>, <-0.628224, 0.871016, 0.771428> }
triangle { <-0.628224, 0.871016, 0.771428>, <-0.555145, 0.956374, 0.783805>, <-0.521788, 0.898909, 0.816145> }
triangle { <-0.555145, 0.956374, 0.783805>, <-0.628224, 0.871016, 0.771428>, <-0.662098, 0.917982, 0.735227> }
triangle { <-0.662098, 0.917982, 0.735227>, <-0.585079, 1.007943, 0.749564>, <-0.555145, 0.956374, 0.783805> }
triangle { <-0.585079, 1.007943, 0.749564>, <-0.662098, 0.917982, 0.735227>, <-0.691891, 0.959289, 0.697240> }
triangle { <-0.691891, 0.959289, 0.697240>, <-0.611406, 1.053297, 0.713633>, <-0.585079, 1.007943, 0.749564> }
triangle { <-0.611406, 1.053297, 0.713633>, <-0.691891, 0.959289, 0.697240>, <-0.717418, 0.994681, 0.657700> }
triangle { <-0.717418, 0.994681, 0.657700>, <-0.633963, 1.092158, 0.676235>, <-0.611406, 1.053297, 0.713633> }
triangle { <-0.633963, 1.092158, 0.676235>, <-0.717418, 0.994681, 0.657700>, <-0.738521, 1.023940, 0.616852> }
triangle { <-0.738521, 1.023940, 0.616852>, <-0.652612, 1.124285, 0.637599>, <-0.633963, 1.092158, 0.676235> }
triangle { <-0.652612, 1.124285, 0.637599>, <-0.738521, 1.023940, 0.616852>, <-0.755072, 1.046887, 0.574948> }
triangle { <-0.755072, 1.046887, 0.574948>, <-0.667237, 1.149480, 0.597964>, <-0.652612, 1.124285, 0.637599> }
triangle { <-0.667237, 1.149480, 0.597964>, <-0.755072, 1.046887, 0.574948>, <-0.766967, 1.063380, 0.532246> }
triangle { <-0.766967, 1.063380, 0.532246>, <-0.677748, 1.167589, 0.557574>, <-0.667237, 1.149480, 0.597964> }
triangle { <-0.677748, 1.167589, 0.557574>, <-0.766967, 1.063380, 0.532246>, <-0.774134, 1.073316, 0.489009> }
triangle { <-0.774134, 1.073316, 0.489009>, <-0.684081, 1.178499, 0.516678>, <-0.677748, 1.167589, 0.557574> }
triangle { <-0.684081, 1.178499, 0.516678>, <-0.774134, 1.073316, 0.489009>, <-0.776527, 1.076635, 0.445503> }
triangle { <-0.776527, 1.076635, 0.445503>, <-0.686196, 1.182143, 0.475528>, <-0.684081, 1.178499, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.065647, 0.075592, 0.998164> }
triangle { <-0.065647, 0.075592, 0.998164>, <-0.060926, 0.084472, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.060926, 0.084472, 0.998291>, <-0.065647, 0.075592, 0.998164>, <-0.130890, 0.150718, 0.992669> }
triangle { <-0.130890, 0.150718, 0.992669>, <-0.121476, 0.168423, 0.993173>, <-0.060926, 0.084472, 0.998291> }
triangle { <-0.121476, 0.168423, 0.993173>, <-0.130890, 0.150718, 0.992669>, <-0.195326, 0.224914, 0.983547> }
triangle { <-0.195326, 0.224914, 0.983547>, <-0.181277, 0.251335, 0.984679>, <-0.121476, 0.168423, 0.993173> }
triangle { <-0.181277, 0.251335, 0.984679>, <-0.195326, 0.224914, 0.983547>, <-0.258557, 0.297724, 0.970855> }
triangle { <-0.258557, 0.297724, 0.970855>, <-0.239960, 0.332698, 0.972861>, <-0.181277, 0.251335, 0.984679> }
triangle { <-0.239960, 0.332698, 0.972861>, <-0.258557, 0.297724, 0.970855>, <-0.320195, 0.368698, 0.954671> }
triangle { <-0.320195, 0.368698, 0.954671>, <-0.297164, 0.412010, 0.957791>, <-0.239960, 0.332698, 0.972861> }
triangle { <-0.297164, 0.412010, 0.957791>, <-0.320195, 0.368698, 0.954671>, <-0.379858, 0.437400, 0.935095> }
triangle { <-0.379858, 0.437400, 0.935095>, <-0.352536, 0.488782, 0.939563>, <-0.297164, 0.412010, 0.957791> }
triangle { <-0.352536, 0.488782, 0.939563>, <-0.379858, 0.437400, 0.935095>, <-0.437179, 0.503404, 0.912248> }
triangle { <-0.437179, 0.503404, 0.912248>, <-0.405734, 0.562540, 0.918289>, <-0.352536, 0.488782, 0.939563> }
triangle { <-0.405734, 0.562540, 0.918289>, <-0.437179, 0.503404, 0.912248>, <-0.491805, 0.566305, 0.886271> }
triangle { <-0.491805, 0.566305, 0.886271>, <-0.456431, 0.632830, 0.894101>, <-0.405734, 0.562540, 0.918289> }
triangle { <-0.456431, 0.632830, 0.894101>, <-0.491805, 0.566305, 0.886271>, <-0.543399, 0.625714, 0.857324> }
triangle { <-0.543399, 0.625714, 0.857324>, <-0.504314, 0.699218, 0.867146>, <-0.456431, 0.632830, 0.894101> }
triangle { <-0.504314, 0.699218, 0.867146>, <-0.543399, 0.625714, 0.857324>, <-0.591642, 0.681266, 0.825585> }
triangle { <-0.591642, 0.681266, 0.825585>, <-0.549088, 0.761296, 0.837592>, <-0.504314, 0.699218, 0.867146> }
triangle { <-0.549088, 0.761296, 0.837592>, <-0.591642, 0.681266, 0.825585>, <-0.636238, 0.732617, 0.791249> }
triangle { <-0.636238, 0.732617, 0.791249>, <-0.590476, 0.818679, 0.805620>, <-0.549088, 0.761296, 0.837592> }
triangle { <-0.590476, 0.818679, 0.805620>, <-0.636238, 0.732617, 0.791249>, <-0.676912, 0.779452, 0.754530> }
triangle { <-0.676912, 0.779452, 0.754530>, <-0.628224, 0.871016, 0.771428>, <-0.590476, 0.818679, 0.805620> }
triangle { <-0.628224, 0.871016, 0.771428>, <-0.676912, 0.779452, 0.754530>, <-0.713412, 0.821481, 0.715652> }
triangle { <-0.713412, 0.821481, 0.715652>, <-0.662098, 0.917982, 0.735227>, <-0.628224, 0.871016, 0.771428> }
triangle { <-0.662098, 0.917982, 0.735227>, <-0.713412, 0.821481, 0.715652>, <-0.745513, 0.858445, 0.674856> }
triangle { <-0.745513, 0.858445, 0.674856>, <-0.691891, 0.959289, 0.697240>, <-0.662098, 0.917982, 0.735227> }
triangle { <-0.691891, 0.959289, 0.697240>, <-0.745513, 0.858445, 0.674856>, <-0.773018, 0.890117, 0.632393> }
triangle { <-0.773018, 0.890117, 0.632393>, <-0.717418, 0.994681, 0.657700>, <-0.691891, 0.959289, 0.697240> }
triangle { <-0.717418, 0.994681, 0.657700>, <-0.773018, 0.890117, 0.632393>, <-0.795757, 0.916301, 0.588525> }
triangle { <-0.795757, 0.916301, 0.588525>, <-0.738521, 1.023940, 0.616852>, <-0.717418, 0.994681, 0.657700> }
triangle { <-0.738521, 1.023940, 0.616852>, <-0.795757, 0.916301, 0.588525>, <-0.813590, 0.936835, 0.543523> }
triangle { <-0.813590, 0.936835, 0.543523>, <-0.755072, 1.046887, 0.574948>, <-0.738521, 1.023940, 0.616852> }
triangle { <-0.755072, 1.046887, 0.574948>, <-0.813590, 0.936835, 0.543523>, <-0.826408, 0.951594, 0.497664> }
triangle { <-0.826408, 0.951594, 0.497664>, <-0.766967, 1.063380, 0.532246>, <-0.755072, 1.046887, 0.574948> }
triangle { <-0.766967, 1.063380, 0.532246>, <-0.826408, 0.951594, 0.497664>, <-0.834129, 0.960486, 0.451230> }
triangle { <-0.834129, 0.960486, 0.451230>, <-0.774134, 1.073316, 0.489009>, <-0.766967, 1.063380, 0.532246> }
triangle { <-0.774134, 1.073316, 0.489009>, <-0.834129, 0.960486, 0.451230>, <-0.836709, 0.963456, 0.404508> }
triangle { <-0.836709, 0.963456, 0.404508>, <-0.776527, 1.076635, 0.445503>, <-0.774134, 1.073316, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.068035, 0.066946, 0.998007> }
triangle { <-0.068035, 0.066946, 0.998007>, <-0.065647, 0.075592, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.065647, 0.075592, 0.998164>, <-0.068035, 0.066946, 0.998007>, <-0.135651, 0.133480, 0.992041> }
triangle { <-0.135651, 0.133480, 0.992041>, <-0.130890, 0.150718, 0.992669>, <-0.065647, 0.075592, 0.998164> }
triangle { <-0.130890, 0.150718, 0.992669>, <-0.135651, 0.133480, 0.992041>, <-0.202431, 0.199190, 0.982139> }
triangle { <-0.202431, 0.199190, 0.982139>, <-0.195326, 0.224914, 0.983547>, <-0.130890, 0.150718, 0.992669> }
triangle { <-0.195326, 0.224914, 0.983547>, <-0.202431, 0.199190, 0.982139>, <-0.267963, 0.263673, 0.968361> }
triangle { <-0.267963, 0.263673, 0.968361>, <-0.258557, 0.297724, 0.970855>, <-0.195326, 0.224914, 0.983547> }
triangle { <-0.258557, 0.297724, 0.970855>, <-0.267963, 0.263673, 0.968361>, <-0.331842, 0.326530, 0.950792> }
triangle { <-0.331842, 0.326530, 0.950792>, <-0.320195, 0.368698, 0.954671>, <-0.258557, 0.297724, 0.970855> }
triangle { <-0.320195, 0.368698, 0.954671>, <-0.331842, 0.326530, 0.950792>, <-0.393676, 0.387373, 0.929542> }
triangle { <-0.393676, 0.387373, 0.929542>, <-0.379858, 0.437400, 0.935095>, <-0.320195, 0.368698, 0.954671> }
triangle { <-0.379858, 0.437400, 0.935095>, <-0.393676, 0.387373, 0.929542>, <-0.453082, 0.445829, 0.904740> }
triangle { <-0.453082, 0.445829, 0.904740>, <-0.437179, 0.503404, 0.912248>, <-0.379858, 0.437400, 0.935095> }
triangle { <-0.437179, 0.503404, 0.912248>, <-0.453082, 0.445829, 0.904740>, <-0.509695, 0.501536, 0.876540> }
triangle { <-0.509695, 0.501536, 0.876540>, <-0.491805, 0.566305, 0.886271>, <-0.437179, 0.503404, 0.912248> }
triangle { <-0.491805, 0.566305, 0.886271>, <-0.509695, 0.501536, 0.876540>, <-0.563166, 0.554150, 0.845115> }
triangle { <-0.563166, 0.554150, 0.845115>, <-0.543399, 0.625714, 0.857324>, <-0.491805, 0.566305, 0.886271> }
triangle { <-0.543399, 0.625714, 0.857324>, <-0.563166, 0.554150, 0.845115>, <-0.613165, 0.603348, 0.810660> }
triangle { <-0.613165, 0.603348, 0.810660>, <-0.591642, 0.681266, 0.825585>, <-0.543399, 0.625714, 0.857324> }
triangle { <-0.591642, 0.681266, 0.825585>, <-0.613165, 0.603348, 0.810660>, <-0.659383, 0.648827, 0.773387> }
triangle { <-0.659383, 0.648827, 0.773387>, <-0.636238, 0.732617, 0.791249>, <-0.591642, 0.681266, 0.825585> }
triangle { <-0.636238, 0.732617, 0.791249>, <-0.659383, 0.648827, 0.773387>, <-0.701536, 0.690305, 0.733525> }
triangle { <-0.701536, 0.690305, 0.733525>, <-0.676912, 0.779452, 0.754530>, <-0.636238, 0.732617, 0.791249> }
triangle { <-0.676912, 0.779452, 0.754530>, <-0.701536, 0.690305, 0.733525>, <-0.739363, 0.727527, 0.691321> }
triangle { <-0.739363, 0.727527, 0.691321>, <-0.713412, 0.821481, 0.715652>, <-0.676912, 0.779452, 0.754530> }
triangle { <-0.713412, 0.821481, 0.715652>, <-0.739363, 0.727527, 0.691321>, <-0.772632, 0.760263, 0.647034> }
triangle { <-0.772632, 0.760263, 0.647034>, <-0.745513, 0.858445, 0.674856>, <-0.713412, 0.821481, 0.715652> }
triangle { <-0.745513, 0.858445, 0.674856>, <-0.772632, 0.760263, 0.647034>, <-0.801138, 0.788313, 0.600938> }
triangle { <-0.801138, 0.788313, 0.600938>, <-0.773018, 0.890117, 0.632393>, <-0.745513, 0.858445, 0.674856> }
triangle { <-0.773018, 0.890117, 0.632393>, <-0.801138, 0.788313, 0.600938>, <-0.824705, 0.811502, 0.553316> }
triangle { <-0.824705, 0.811502, 0.553316>, <-0.795757, 0.916301, 0.588525>, <-0.773018, 0.890117, 0.632393> }
triangle { <-0.795757, 0.916301, 0.588525>, <-0.824705, 0.811502, 0.553316>, <-0.843186, 0.829688, 0.504463> }
triangle { <-0.843186, 0.829688, 0.504463>, <-0.813590, 0.936835, 0.543523>, <-0.795757, 0.916301, 0.588525> }
triangle { <-0.813590, 0.936835, 0.543523>, <-0.843186, 0.829688, 0.504463>, <-0.856470, 0.842758, 0.454680> }
triangle { <-0.856470, 0.842758, 0.454680>, <-0.826408, 0.951594, 0.497664>, <-0.813590, 0.936835, 0.543523> }
triangle { <-0.826408, 0.951594, 0.497664>, <-0.856470, 0.842758, 0.454680>, <-0.864473, 0.850633, 0.404273> }
triangle { <-0.864473, 0.850633, 0.404273>, <-0.834129, 0.960486, 0.451230>, <-0.826408, 0.951594, 0.497664> }
triangle { <-0.834129, 0.960486, 0.451230>, <-0.864473, 0.850633, 0.404273>, <-0.867146, 0.853263, 0.353553> }
triangle { <-0.867146, 0.853263, 0.353553>, <-0.836709, 0.963456, 0.404508>, <-0.834129, 0.960486, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.068422, 0.059295, 0.997823> }
triangle { <-0.068422, 0.059295, 0.997823>, <-0.068035, 0.066946, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.068035, 0.066946, 0.998007>, <-0.068422, 0.059295, 0.997823>, <-0.136422, 0.118225, 0.991307> }
triangle { <-0.136422, 0.118225, 0.991307>, <-0.135651, 0.133480, 0.992041>, <-0.068035, 0.066946, 0.998007> }
triangle { <-0.135651, 0.133480, 0.992041>, <-0.136422, 0.118225, 0.991307>, <-0.203582, 0.176426, 0.980490> }
triangle { <-0.203582, 0.176426, 0.980490>, <-0.202431, 0.199190, 0.982139>, <-0.135651, 0.133480, 0.992041> }
triangle { <-0.202431, 0.199190, 0.982139>, <-0.203582, 0.176426, 0.980490>, <-0.269486, 0.233540, 0.965441> }
triangle { <-0.269486, 0.233540, 0.965441>, <-0.267963, 0.263673, 0.968361>, <-0.202431, 0.199190, 0.982139> }
triangle { <-0.267963, 0.263673, 0.968361>, <-0.269486, 0.233540, 0.965441>, <-0.333728, 0.289213, 0.946251> }
triangle { <-0.333728, 0.289213, 0.946251>, <-0.331842, 0.326530, 0.950792>, <-0.267963, 0.263673, 0.968361> }
triangle { <-0.331842, 0.326530, 0.950792>, <-0.333728, 0.289213, 0.946251>, <-0.395913, 0.343103, 0.923039> }
triangle { <-0.395913, 0.343103, 0.923039>, <-0.393676, 0.387373, 0.929542>, <-0.331842, 0.326530, 0.950792> }
triangle { <-0.393676, 0.387373, 0.929542>, <-0.395913, 0.343103, 0.923039>, <-0.455657, 0.394878, 0.895948> }
triangle { <-0.455657, 0.394878, 0.895948>, <-0.453082, 0.445829, 0.904740>, <-0.393676, 0.387373, 0.929542> }
triangle { <-0.453082, 0.445829, 0.904740>, <-0.455657, 0.394878, 0.895948>, <-0.512592, 0.444219, 0.865145> }
triangle { <-0.512592, 0.444219, 0.865145>, <-0.509695, 0.501536, 0.876540>, <-0.453082, 0.445829, 0.904740> }
triangle { <-0.509695, 0.501536, 0.876540>, <-0.512592, 0.444219, 0.865145>, <-0.566367, 0.490821, 0.830821> }
triangle { <-0.566367, 0.490821, 0.830821>, <-0.563166, 0.554150, 0.845115>, <-0.509695, 0.501536, 0.876540> }
triangle { <-0.563166, 0.554150, 0.845115>, <-0.566367, 0.490821, 0.830821>, <-0.616650, 0.534396, 0.793186> }
triangle { <-0.616650, 0.534396, 0.793186>, <-0.613165, 0.603348, 0.810660>, <-0.563166, 0.554150, 0.845115> }
triangle { <-0.613165, 0.603348, 0.810660>, <-0.616650, 0.534396, 0.793186>, <-0.663130, 0.574677, 0.752473> }
triangle { <-0.663130, 0.574677, 0.752473>, <-0.659383, 0.648827, 0.773387>, <-0.613165, 0.603348, 0.810660> }
triangle { <-0.659383, 0.648827, 0.773387>, <-0.663130, 0.574677, 0.752473>, <-0.705523, 0.611415, 0.708932> }
triangle { <-0.705523, 0.611415, 0.708932>, <-0.701536, 0.690305, 0.733525>, <-0.659383, 0.648827, 0.773387> }
triangle { <-0.701536, 0.690305, 0.733525>, <-0.705523, 0.611415, 0.708932>, <-0.743565, 0.644383, 0.662833> }
triangle { <-0.743565, 0.644383, 0.662833>, <-0.739363, 0.727527, 0.691321>, <-0.701536, 0.690305, 0.733525> }
triangle { <-0.739363, 0.727527, 0.691321>, <-0.743565, 0.644383, 0.662833>, <-0.777024, 0.673378, 0.614459> }
triangle { <-0.777024, 0.673378, 0.614459>, <-0.772632, 0.760263, 0.647034>, <-0.739363, 0.727527, 0.691321> }
triangle { <-0.772632, 0.760263, 0.647034>, <-0.777024, 0.673378, 0.614459>, <-0.805691, 0.698222, 0.564108> }
triangle { <-0.805691, 0.698222, 0.564108>, <-0.801138, 0.788313, 0.600938>, <-0.772632, 0.760263, 0.647034> }
triangle { <-0.801138, 0.788313, 0.600938>, <-0.805691, 0.698222, 0.564108>, <-0.829392, 0.718761, 0.512092> }
triangle { <-0.829392, 0.718761, 0.512092>, <-0.824705, 0.811502, 0.553316>, <-0.801138, 0.788313, 0.600938> }
triangle { <-0.824705, 0.811502, 0.553316>, <-0.829392, 0.718761, 0.512092>, <-0.847979, 0.734869, 0.458730> }
triangle { <-0.847979, 0.734869, 0.458730>, <-0.843186, 0.829688, 0.504463>, <-0.824705, 0.811502, 0.553316> }
triangle { <-0.843186, 0.829688, 0.504463>, <-0.847979, 0.734869, 0.458730>, <-0.861337, 0.746446, 0.404352> }
triangle { <-0.861337, 0.746446, 0.404352>, <-0.856470, 0.842758, 0.454680>, <-0.843186, 0.829688, 0.504463> }
triangle { <-0.856470, 0.842758, 0.454680>, <-0.861337, 0.746446, 0.404352>, <-0.869386, 0.753421, 0.349293> }
triangle { <-0.869386, 0.753421, 0.349293>, <-0.864473, 0.850633, 0.404273>, <-0.856470, 0.842758, 0.454680> }
triangle { <-0.864473, 0.850633, 0.404273>, <-0.869386, 0.753421, 0.349293>, <-0.872074, 0.755750, 0.293893> }
triangle { <-0.872074, 0.755750, 0.293893>, <-0.867146, 0.853263, 0.353553>, <-0.864473, 0.850633, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.067391, 0.053219, 0.997617> }
triangle { <-0.067391, 0.053219, 0.997617>, <-0.068422, 0.059295, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.068422, 0.059295, 0.997823>, <-0.067391, 0.053219, 0.997617>, <-0.134367, 0.106110, 0.990483> }
triangle { <-0.134367, 0.106110, 0.990483>, <-0.136422, 0.118225, 0.991307>, <-0.068422, 0.059295, 0.997823> }
triangle { <-0.136422, 0.118225, 0.991307>, <-0.134367, 0.106110, 0.990483>, <-0.200514, 0.158347, 0.978642> }
triangle { <-0.200514, 0.158347, 0.978642>, <-0.203582, 0.176426, 0.980490>, <-0.136422, 0.118225, 0.991307> }
triangle { <-0.203582, 0.176426, 0.980490>, <-0.200514, 0.158347, 0.978642>, <-0.265425, 0.209608, 0.962166> }
triangle { <-0.265425, 0.209608, 0.962166>, <-0.269486, 0.233540, 0.965441>, <-0.203582, 0.176426, 0.980490> }
triangle { <-0.269486, 0.233540, 0.965441>, <-0.265425, 0.209608, 0.962166>, <-0.328699, 0.259576, 0.941159> }
triangle { <-0.328699, 0.259576, 0.941159>, <-0.333728, 0.289213, 0.946251>, <-0.269486, 0.233540, 0.965441> }
triangle { <-0.333728, 0.289213, 0.946251>, <-0.328699, 0.259576, 0.941159>, <-0.389947, 0.307944, 0.915748> }
triangle { <-0.389947, 0.307944, 0.915748>, <-0.395913, 0.343103, 0.923039>, <-0.333728, 0.289213, 0.946251> }
triangle { <-0.395913, 0.343103, 0.923039>, <-0.389947, 0.307944, 0.915748>, <-0.448791, 0.354413, 0.886090> }
triangle { <-0.448791, 0.354413, 0.886090>, <-0.455657, 0.394878, 0.895948>, <-0.395913, 0.343103, 0.923039> }
triangle { <-0.455657, 0.394878, 0.895948>, <-0.448791, 0.354413, 0.886090>, <-0.504868, 0.398698, 0.852369> }
triangle { <-0.504868, 0.398698, 0.852369>, <-0.512592, 0.444219, 0.865145>, <-0.455657, 0.394878, 0.895948> }
triangle { <-0.512592, 0.444219, 0.865145>, <-0.504868, 0.398698, 0.852369>, <-0.557832, 0.440524, 0.814793> }
triangle { <-0.557832, 0.440524, 0.814793>, <-0.566367, 0.490821, 0.830821>, <-0.512592, 0.444219, 0.865145> }
triangle { <-0.566367, 0.490821, 0.830821>, <-0.557832, 0.440524, 0.814793>, <-0.607357, 0.479634, 0.773592> }
triangle { <-0.607357, 0.479634, 0.773592>, <-0.616650, 0.534396, 0.793186>, <-0.566367, 0.490821, 0.830821> }
triangle { <-0.616650, 0.534396, 0.793186>, <-0.607357, 0.479634, 0.773592>, <-0.653138, 0.515787, 0.729022> }
triangle { <-0.653138, 0.515787, 0.729022>, <-0.663130, 0.574677, 0.752473>, <-0.616650, 0.534396, 0.793186> }
triangle { <-0.663130, 0.574677, 0.752473>, <-0.653138, 0.515787, 0.729022>, <-0.694891, 0.548760, 0.681356> }
triangle { <-0.694891, 0.548760, 0.681356>, <-0.705523, 0.611415, 0.708932>, <-0.663130, 0.574677, 0.752473> }
triangle { <-0.705523, 0.611415, 0.708932>, <-0.694891, 0.548760, 0.681356>, <-0.732361, 0.578350, 0.630889> }
triangle { <-0.732361, 0.578350, 0.630889>, <-0.743565, 0.644383, 0.662833>, <-0.705523, 0.611415, 0.708932> }
triangle { <-0.743565, 0.644383, 0.662833>, <-0.732361, 0.578350, 0.630889>, <-0.765315, 0.604374, 0.577932> }
triangle { <-0.765315, 0.604374, 0.577932>, <-0.777024, 0.673378, 0.614459>, <-0.743565, 0.644383, 0.662833> }
triangle { <-0.777024, 0.673378, 0.614459>, <-0.765315, 0.604374, 0.577932>, <-0.793550, 0.626672, 0.522811> }
triangle { <-0.793550, 0.626672, 0.522811>, <-0.805691, 0.698222, 0.564108>, <-0.777024, 0.673378, 0.614459> }
triangle { <-0.805691, 0.698222, 0.564108>, <-0.793550, 0.626672, 0.522811>, <-0.816894, 0.645106, 0.465867> }
triangle { <-0.816894, 0.645106, 0.465867>, <-0.829392, 0.718761, 0.512092>, <-0.805691, 0.698222, 0.564108> }
triangle { <-0.829392, 0.718761, 0.512092>, <-0.816894, 0.645106, 0.465867>, <-0.835200, 0.659563, 0.407450> }
triangle { <-0.835200, 0.659563, 0.407450>, <-0.847979, 0.734869, 0.458730>, <-0.829392, 0.718761, 0.512092> }
triangle { <-0.847979, 0.734869, 0.458730>, <-0.835200, 0.659563, 0.407450>, <-0.848358, 0.669954, 0.347920> }
triangle { <-0.848358, 0.669954, 0.347920>, <-0.861337, 0.746446, 0.404352>, <-0.847979, 0.734869, 0.458730> }
triangle { <-0.861337, 0.746446, 0.404352>, <-0.848358, 0.669954, 0.347920>, <-0.856285, 0.676214, 0.287645> }
triangle { <-0.856285, 0.676214, 0.287645>, <-0.869386, 0.753421, 0.349293>, <-0.861337, 0.746446, 0.404352> }
triangle { <-0.869386, 0.753421, 0.349293>, <-0.856285, 0.676214, 0.287645>, <-0.858933, 0.678305, 0.226995> }
triangle { <-0.858933, 0.678305, 0.226995>, <-0.872074, 0.755750, 0.293893>, <-0.869386, 0.753421, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.065693, 0.049037, 0.997394> }
triangle { <-0.065693, 0.049037, 0.997394>, <-0.067391, 0.053219, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.067391, 0.053219, 0.997617>, <-0.065693, 0.049037, 0.997394>, <-0.130980, 0.097771, 0.989591> }
triangle { <-0.130980, 0.097771, 0.989591>, <-0.134367, 0.106110, 0.990483>, <-0.067391, 0.053219, 0.997617> }
triangle { <-0.134367, 0.106110, 0.990483>, <-0.130980, 0.097771, 0.989591>, <-0.195461, 0.145903, 0.976639> }
triangle { <-0.195461, 0.145903, 0.976639>, <-0.200514, 0.158347, 0.978642>, <-0.134367, 0.106110, 0.990483> }
triangle { <-0.200514, 0.158347, 0.978642>, <-0.195461, 0.145903, 0.976639>, <-0.258736, 0.193135, 0.958619> }
triangle { <-0.258736, 0.193135, 0.958619>, <-0.265425, 0.209608, 0.962166>, <-0.200514, 0.158347, 0.978642> }
triangle { <-0.265425, 0.209608, 0.962166>, <-0.258736, 0.193135, 0.958619>, <-0.320416, 0.239177, 0.935641> }
triangle { <-0.320416, 0.239177, 0.935641>, <-0.328699, 0.259576, 0.941159>, <-0.265425, 0.209608, 0.962166> }
triangle { <-0.328699, 0.259576, 0.941159>, <-0.320416, 0.239177, 0.935641>, <-0.380120, 0.283744, 0.907847> }
triangle { <-0.380120, 0.283744, 0.907847>, <-0.389947, 0.307944, 0.915748>, <-0.328699, 0.259576, 0.941159> }
triangle { <-0.389947, 0.307944, 0.915748>, <-0.380120, 0.283744, 0.907847>, <-0.437481, 0.326561, 0.875409> }
triangle { <-0.437481, 0.326561, 0.875409>, <-0.448791, 0.354413, 0.886090>, <-0.389947, 0.307944, 0.915748> }
triangle { <-0.448791, 0.354413, 0.886090>, <-0.437481, 0.326561, 0.875409>, <-0.492144, 0.367365, 0.838525> }
triangle { <-0.492144, 0.367365, 0.838525>, <-0.504868, 0.398698, 0.852369>, <-0.448791, 0.354413, 0.886090> }
triangle { <-0.504868, 0.398698, 0.852369>, <-0.492144, 0.367365, 0.838525>, <-0.543774, 0.405904, 0.797425> }
triangle { <-0.543774, 0.405904, 0.797425>, <-0.557832, 0.440524, 0.814793>, <-0.504868, 0.398698, 0.852369> }
triangle { <-0.557832, 0.440524, 0.814793>, <-0.543774, 0.405904, 0.797425>, <-0.592051, 0.441941, 0.752361> }
triangle { <-0.592051, 0.441941, 0.752361>, <-0.607357, 0.479634, 0.773592>, <-0.557832, 0.440524, 0.814793> }
triangle { <-0.607357, 0.479634, 0.773592>, <-0.592051, 0.441941, 0.752361>, <-0.636677, 0.475253, 0.703611> }
triangle { <-0.636677, 0.475253, 0.703611>, <-0.653138, 0.515787, 0.729022>, <-0.607357, 0.479634, 0.773592> }
triangle { <-0.653138, 0.515787, 0.729022>, <-0.636677, 0.475253, 0.703611>, <-0.677379, 0.505635, 0.651476> }
triangle { <-0.677379, 0.505635, 0.651476>, <-0.694891, 0.548760, 0.681356>, <-0.653138, 0.515787, 0.729022> }
triangle { <-0.694891, 0.548760, 0.681356>, <-0.677379, 0.505635, 0.651476>, <-0.713904, 0.532899, 0.596277> }
triangle { <-0.713904, 0.532899, 0.596277>, <-0.732361, 0.578350, 0.630889>, <-0.694891, 0.548760, 0.681356> }
triangle { <-0.732361, 0.578350, 0.630889>, <-0.713904, 0.532899, 0.596277>, <-0.746027, 0.556878, 0.538354> }
triangle { <-0.746027, 0.556878, 0.538354>, <-0.765315, 0.604374, 0.577932>, <-0.732361, 0.578350, 0.630889> }
triangle { <-0.765315, 0.604374, 0.577932>, <-0.746027, 0.556878, 0.538354>, <-0.773551, 0.577424, 0.478064> }
triangle { <-0.773551, 0.577424, 0.478064>, <-0.793550, 0.626672, 0.522811>, <-0.765315, 0.604374, 0.577932> }
triangle { <-0.793550, 0.626672, 0.522811>, <-0.773551, 0.577424, 0.478064>, <-0.796306, 0.594409, 0.415780> }
triangle { <-0.796306, 0.594409, 0.415780>, <-0.816894, 0.645106, 0.465867>, <-0.793550, 0.626672, 0.522811> }
triangle { <-0.816894, 0.645106, 0.465867>, <-0.796306, 0.594409, 0.415780>, <-0.814152, 0.607730, 0.351885> }
triangle { <-0.814152, 0.607730, 0.351885>, <-0.835200, 0.659563, 0.407450>, <-0.816894, 0.645106, 0.465867> }
triangle { <-0.835200, 0.659563, 0.407450>, <-0.814152, 0.607730, 0.351885>, <-0.826978, 0.617304, 0.286773> }
triangle { <-0.826978, 0.617304, 0.286773>, <-0.848358, 0.669954, 0.347920>, <-0.835200, 0.659563, 0.407450> }
triangle { <-0.848358, 0.669954, 0.347920>, <-0.826978, 0.617304, 0.286773>, <-0.834705, 0.623072, 0.220845> }
triangle { <-0.834705, 0.623072, 0.220845>, <-0.856285, 0.676214, 0.287645>, <-0.848358, 0.669954, 0.347920> }
triangle { <-0.856285, 0.676214, 0.287645>, <-0.834705, 0.623072, 0.220845>, <-0.837286, 0.624999, 0.154508> }
triangle { <-0.837286, 0.624999, 0.154508>, <-0.858933, 0.678305, 0.226995>, <-0.856285, 0.676214, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.064136, 0.046765, 0.997158> }
triangle { <-0.064136, 0.046765, 0.997158>, <-0.065693, 0.049037, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.065693, 0.049037, 0.997394>, <-0.064136, 0.046765, 0.997158>, <-0.127877, 0.093242, 0.988651> }
triangle { <-0.127877, 0.093242, 0.988651>, <-0.130980, 0.097771, 0.989591>, <-0.065693, 0.049037, 0.997394> }
triangle { <-0.130980, 0.097771, 0.989591>, <-0.127877, 0.093242, 0.988651>, <-0.190830, 0.139144, 0.974531> }
triangle { <-0.190830, 0.139144, 0.974531>, <-0.195461, 0.145903, 0.976639>, <-0.130980, 0.097771, 0.989591> }
triangle { <-0.195461, 0.145903, 0.976639>, <-0.190830, 0.139144, 0.974531>, <-0.252606, 0.184187, 0.954885> }
triangle { <-0.252606, 0.184187, 0.954885>, <-0.258736, 0.193135, 0.958619>, <-0.195461, 0.145903, 0.976639> }
triangle { <-0.258736, 0.193135, 0.958619>, <-0.252606, 0.184187, 0.954885>, <-0.312825, 0.228096, 0.929833> }
triangle { <-0.312825, 0.228096, 0.929833>, <-0.320416, 0.239177, 0.935641>, <-0.258736, 0.193135, 0.958619> }
triangle { <-0.320416, 0.239177, 0.935641>, <-0.312825, 0.228096, 0.929833>, <-0.371115, 0.270598, 0.899532> }
triangle { <-0.371115, 0.270598, 0.899532>, <-0.380120, 0.283744, 0.907847>, <-0.320416, 0.239177, 0.935641> }
triangle { <-0.380120, 0.283744, 0.907847>, <-0.371115, 0.270598, 0.899532>, <-0.427117, 0.311432, 0.864166> }
triangle { <-0.427117, 0.311432, 0.864166>, <-0.437481, 0.326561, 0.875409>, <-0.380120, 0.283744, 0.907847> }
triangle { <-0.437481, 0.326561, 0.875409>, <-0.427117, 0.311432, 0.864166>, <-0.480485, 0.350345, 0.823955> }
triangle { <-0.480485, 0.350345, 0.823955>, <-0.492144, 0.367365, 0.838525>, <-0.437481, 0.326561, 0.875409> }
triangle { <-0.492144, 0.367365, 0.838525>, <-0.480485, 0.350345, 0.823955>, <-0.530892, 0.387099, 0.779146> }
triangle { <-0.530892, 0.387099, 0.779146>, <-0.543774, 0.405904, 0.797425>, <-0.492144, 0.367365, 0.838525> }
triangle { <-0.543774, 0.405904, 0.797425>, <-0.530892, 0.387099, 0.779146>, <-0.578025, 0.421466, 0.730016> }
triangle { <-0.578025, 0.421466, 0.730016>, <-0.592051, 0.441941, 0.752361>, <-0.543774, 0.405904, 0.797425> }
triangle { <-0.592051, 0.441941, 0.752361>, <-0.578025, 0.421466, 0.730016>, <-0.621594, 0.453235, 0.676867> }
triangle { <-0.621594, 0.453235, 0.676867>, <-0.636677, 0.475253, 0.703611>, <-0.592051, 0.441941, 0.752361> }
triangle { <-0.636677, 0.475253, 0.703611>, <-0.621594, 0.453235, 0.676867>, <-0.661331, 0.482209, 0.620028> }
triangle { <-0.661331, 0.482209, 0.620028>, <-0.677379, 0.505635, 0.651476>, <-0.636677, 0.475253, 0.703611> }
triangle { <-0.677379, 0.505635, 0.651476>, <-0.661331, 0.482209, 0.620028>, <-0.696991, 0.508210, 0.559847> }
triangle { <-0.696991, 0.508210, 0.559847>, <-0.713904, 0.532899, 0.596277>, <-0.677379, 0.505635, 0.651476> }
triangle { <-0.713904, 0.532899, 0.596277>, <-0.696991, 0.508210, 0.559847>, <-0.728354, 0.531078, 0.496698> }
triangle { <-0.728354, 0.531078, 0.496698>, <-0.746027, 0.556878, 0.538354>, <-0.713904, 0.532899, 0.596277> }
triangle { <-0.746027, 0.556878, 0.538354>, <-0.728354, 0.531078, 0.496698>, <-0.755226, 0.550672, 0.430968> }
triangle { <-0.755226, 0.550672, 0.430968>, <-0.773551, 0.577424, 0.478064>, <-0.746027, 0.556878, 0.538354> }
triangle { <-0.773551, 0.577424, 0.478064>, <-0.755226, 0.550672, 0.430968>, <-0.777442, 0.566871, 0.363064> }
triangle { <-0.777442, 0.566871, 0.363064>, <-0.796306, 0.594409, 0.415780>, <-0.773551, 0.577424, 0.478064> }
triangle { <-0.796306, 0.594409, 0.415780>, <-0.777442, 0.566871, 0.363064>, <-0.794864, 0.579574, 0.293403> }
triangle { <-0.794864, 0.579574, 0.293403>, <-0.814152, 0.607730, 0.351885>, <-0.796306, 0.594409, 0.415780> }
triangle { <-0.814152, 0.607730, 0.351885>, <-0.794864, 0.579574, 0.293403>, <-0.807386, 0.588705, 0.222416> }
triangle { <-0.807386, 0.588705, 0.222416>, <-0.826978, 0.617304, 0.286773>, <-0.814152, 0.607730, 0.351885> }
triangle { <-0.826978, 0.617304, 0.286773>, <-0.807386, 0.588705, 0.222416>, <-0.814931, 0.594206, 0.150539> }
triangle { <-0.814931, 0.594206, 0.150539>, <-0.834705, 0.623072, 0.220845>, <-0.826978, 0.617304, 0.286773> }
triangle { <-0.834705, 0.623072, 0.220845>, <-0.814931, 0.594206, 0.150539>, <-0.817451, 0.596043, 0.078217> }
triangle { <-0.817451, 0.596043, 0.078217>, <-0.837286, 0.624999, 0.154508>, <-0.834705, 0.623072, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.063475, 0.046117, 0.996917> }
triangle { <-0.063475, 0.046117, 0.996917>, <-0.064136, 0.046765, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.064136, 0.046765, 0.997158>, <-0.063475, 0.046117, 0.996917>, <-0.126558, 0.091950, 0.987688> }
triangle { <-0.126558, 0.091950, 0.987688>, <-0.127877, 0.093242, 0.988651>, <-0.064136, 0.046765, 0.997158> }
triangle { <-0.127877, 0.093242, 0.988651>, <-0.126558, 0.091950, 0.987688>, <-0.188861, 0.137216, 0.972370> }
triangle { <-0.188861, 0.137216, 0.972370>, <-0.190830, 0.139144, 0.974531>, <-0.127877, 0.093242, 0.988651> }
triangle { <-0.190830, 0.139144, 0.974531>, <-0.188861, 0.137216, 0.972370>, <-0.250000, 0.181636, 0.951057> }
triangle { <-0.250000, 0.181636, 0.951057>, <-0.252606, 0.184187, 0.954885>, <-0.190830, 0.139144, 0.974531> }
triangle { <-0.252606, 0.184187, 0.954885>, <-0.250000, 0.181636, 0.951057>, <-0.309597, 0.224936, 0.923880> }
triangle { <-0.309597, 0.224936, 0.923880>, <-0.312825, 0.228096, 0.929833>, <-0.252606, 0.184187, 0.954885> }
triangle { <-0.312825, 0.228096, 0.929833>, <-0.309597, 0.224936, 0.923880>, <-0.367286, 0.266849, 0.891007> }
triangle { <-0.367286, 0.266849, 0.891007>, <-0.371115, 0.270598, 0.899532>, <-0.312825, 0.228096, 0.929833> }
triangle { <-0.371115, 0.270598, 0.899532>, <-0.367286, 0.266849, 0.891007>, <-0.422710, 0.307117, 0.852640> }
triangle { <-0.422710, 0.307117, 0.852640>, <-0.427117, 0.311432, 0.864166>, <-0.371115, 0.270598, 0.899532> }
triangle { <-0.427117, 0.311432, 0.864166>, <-0.422710, 0.307117, 0.852640>, <-0.475528, 0.345492, 0.809017> }
triangle { <-0.475528, 0.345492, 0.809017>, <-0.480485, 0.350345, 0.823955>, <-0.427117, 0.311432, 0.864166> }
triangle { <-0.480485, 0.350345, 0.823955>, <-0.475528, 0.345492, 0.809017>, <-0.525415, 0.381736, 0.760406> }
triangle { <-0.525415, 0.381736, 0.760406>, <-0.530892, 0.387099, 0.779146>, <-0.480485, 0.350345, 0.823955> }
triangle { <-0.530892, 0.387099, 0.779146>, <-0.525415, 0.381736, 0.760406>, <-0.572061, 0.415627, 0.707107> }
triangle { <-0.572061, 0.415627, 0.707107>, <-0.578025, 0.421466, 0.730016>, <-0.530892, 0.387099, 0.779146> }
triangle { <-0.578025, 0.421466, 0.730016>, <-0.572061, 0.415627, 0.707107>, <-0.615181, 0.446955, 0.649448> }
triangle { <-0.615181, 0.446955, 0.649448>, <-0.621594, 0.453235, 0.676867>, <-0.578025, 0.421466, 0.730016> }
triangle { <-0.621594, 0.453235, 0.676867>, <-0.615181, 0.446955, 0.649448>, <-0.654508, 0.475528, 0.587785> }
triangle { <-0.654508, 0.475528, 0.587785>, <-0.661331, 0.482209, 0.620028>, <-0.621594, 0.453235, 0.676867> }
triangle { <-0.661331, 0.482209, 0.620028>, <-0.654508, 0.475528, 0.587785>, <-0.689800, 0.501169, 0.522499> }
triangle { <-0.689800, 0.501169, 0.522499>, <-0.696991, 0.508210, 0.559847>, <-0.661331, 0.482209, 0.620028> }
triangle { <-0.696991, 0.508210, 0.559847>, <-0.689800, 0.501169, 0.522499>, <-0.720839, 0.523720, 0.453990> }
triangle { <-0.720839, 0.523720, 0.453990>, <-0.728354, 0.531078, 0.496698>, <-0.696991, 0.508210, 0.559847> }
triangle { <-0.728354, 0.531078, 0.496698>, <-0.720839, 0.523720, 0.453990>, <-0.747434, 0.543043, 0.382683> }
triangle { <-0.747434, 0.543043, 0.382683>, <-0.755226, 0.550672, 0.430968>, <-0.728354, 0.531078, 0.496698> }
triangle { <-0.755226, 0.550672, 0.430968>, <-0.747434, 0.543043, 0.382683>, <-0.769421, 0.559017, 0.309017> }
triangle { <-0.769421, 0.559017, 0.309017>, <-0.777442, 0.566871, 0.363064>, <-0.755226, 0.550672, 0.430968> }
triangle { <-0.777442, 0.566871, 0.363064>, <-0.769421, 0.559017, 0.309017>, <-0.786664, 0.571545, 0.233445> }
triangle { <-0.786664, 0.571545, 0.233445>, <-0.794864, 0.579574, 0.293403>, <-0.777442, 0.566871, 0.363064> }
triangle { <-0.794864, 0.579574, 0.293403>, <-0.786664, 0.571545, 0.233445>, <-0.799057, 0.580549, 0.156434> }
triangle { <-0.799057, 0.580549, 0.156434>, <-0.807386, 0.588705, 0.222416>, <-0.794864, 0.579574, 0.293403> }
triangle { <-0.807386, 0.588705, 0.222416>, <-0.799057, 0.580549, 0.156434>, <-0.806523, 0.585973, 0.078459> }
triangle { <-0.806523, 0.585973, 0.078459>, <-0.814931, 0.594206, 0.150539>, <-0.807386, 0.588705, 0.222416> }
triangle { <-0.814931, 0.594206, 0.150539>, <-0.806523, 0.585973, 0.078459>, <-0.809017, 0.587785, 0.000000> }
triangle { <-0.809017, 0.587785, 0.000000>, <-0.817451, 0.596043, 0.078217>, <-0.814931, 0.594206, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.064295, 0.046546, 0.997158> }
triangle { <-0.064295, 0.046546, 0.997158>, <-0.063475, 0.046117, 0.996917>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.063475, 0.046117, 0.996917>, <-0.064295, 0.046546, 0.997158>, <-0.128194, 0.092805, 0.988651> }
triangle { <-0.128194, 0.092805, 0.988651>, <-0.126558, 0.091950, 0.987688>, <-0.063475, 0.046117, 0.996917> }
triangle { <-0.126558, 0.091950, 0.987688>, <-0.128194, 0.092805, 0.988651>, <-0.191303, 0.138492, 0.974531> }
triangle { <-0.191303, 0.138492, 0.974531>, <-0.188861, 0.137216, 0.972370>, <-0.126558, 0.091950, 0.987688> }
triangle { <-0.188861, 0.137216, 0.972370>, <-0.191303, 0.138492, 0.974531>, <-0.253232, 0.183326, 0.954885> }
triangle { <-0.253232, 0.183326, 0.954885>, <-0.250000, 0.181636, 0.951057>, <-0.188861, 0.137216, 0.972370> }
triangle { <-0.250000, 0.181636, 0.951057>, <-0.253232, 0.183326, 0.954885>, <-0.313600, 0.227029, 0.929833> }
triangle { <-0.313600, 0.227029, 0.929833>, <-0.309597, 0.224936, 0.923880>, <-0.250000, 0.181636, 0.951057> }
triangle { <-0.309597, 0.224936, 0.923880>, <-0.313600, 0.227029, 0.929833>, <-0.372035, 0.269332, 0.899532> }
triangle { <-0.372035, 0.269332, 0.899532>, <-0.367286, 0.266849, 0.891007>, <-0.309597, 0.224936, 0.923880> }
triangle { <-0.367286, 0.266849, 0.891007>, <-0.372035, 0.269332, 0.899532>, <-0.428175, 0.309974, 0.864166> }
triangle { <-0.428175, 0.309974, 0.864166>, <-0.422710, 0.307117, 0.852640>, <-0.367286, 0.266849, 0.891007> }
triangle { <-0.422710, 0.307117, 0.852640>, <-0.428175, 0.309974, 0.864166>, <-0.481676, 0.348706, 0.823955> }
triangle { <-0.481676, 0.348706, 0.823955>, <-0.475528, 0.345492, 0.809017>, <-0.422710, 0.307117, 0.852640> }
triangle { <-0.475528, 0.345492, 0.809017>, <-0.481676, 0.348706, 0.823955>, <-0.532208, 0.385288, 0.779146> }
triangle { <-0.532208, 0.385288, 0.779146>, <-0.525415, 0.381736, 0.760406>, <-0.475528, 0.345492, 0.809017> }
triangle { <-0.525415, 0.381736, 0.760406>, <-0.532208, 0.385288, 0.779146>, <-0.579458, 0.419494, 0.730016> }
triangle { <-0.579458, 0.419494, 0.730016>, <-0.572061, 0.415627, 0.707107>, <-0.525415, 0.381736, 0.760406> }
triangle { <-0.572061, 0.415627, 0.707107>, <-0.579458, 0.419494, 0.730016>, <-0.623135, 0.451114, 0.676867> }
triangle { <-0.623135, 0.451114, 0.676867>, <-0.615181, 0.446955, 0.649448>, <-0.572061, 0.415627, 0.707107> }
triangle { <-0.615181, 0.446955, 0.649448>, <-0.623135, 0.451114, 0.676867>, <-0.662971, 0.479953, 0.620028> }
triangle { <-0.662971, 0.479953, 0.620028>, <-0.654508, 0.475528, 0.587785>, <-0.615181, 0.446955, 0.649448> }
triangle { <-0.654508, 0.475528, 0.587785>, <-0.662971, 0.479953, 0.620028>, <-0.698719, 0.505832, 0.559847> }
triangle { <-0.698719, 0.505832, 0.559847>, <-0.689800, 0.501169, 0.522499>, <-0.654508, 0.475528, 0.587785> }
triangle { <-0.689800, 0.501169, 0.522499>, <-0.698719, 0.505832, 0.559847>, <-0.730159, 0.528593, 0.496698> }
triangle { <-0.730159, 0.528593, 0.496698>, <-0.720839, 0.523720, 0.453990>, <-0.689800, 0.501169, 0.522499> }
triangle { <-0.720839, 0.523720, 0.453990>, <-0.730159, 0.528593, 0.496698>, <-0.757098, 0.548095, 0.430968> }
triangle { <-0.757098, 0.548095, 0.430968>, <-0.747434, 0.543043, 0.382683>, <-0.720839, 0.523720, 0.453990> }
triangle { <-0.747434, 0.543043, 0.382683>, <-0.757098, 0.548095, 0.430968>, <-0.779369, 0.564218, 0.363064> }
triangle { <-0.779369, 0.564218, 0.363064>, <-0.769421, 0.559017, 0.309017>, <-0.747434, 0.543043, 0.382683> }
triangle { <-0.769421, 0.559017, 0.309017>, <-0.779369, 0.564218, 0.363064>, <-0.796835, 0.576863, 0.293403> }
triangle { <-0.796835, 0.576863, 0.293403>, <-0.786664, 0.571545, 0.233445>, <-0.769421, 0.559017, 0.309017> }
triangle { <-0.786664, 0.571545, 0.233445>, <-0.796835, 0.576863, 0.293403>, <-0.809388, 0.585950, 0.222416> }
triangle { <-0.809388, 0.585950, 0.222416>, <-0.799057, 0.580549, 0.156434>, <-0.786664, 0.571545, 0.233445> }
triangle { <-0.799057, 0.580549, 0.156434>, <-0.809388, 0.585950, 0.222416>, <-0.816951, 0.591425, 0.150539> }
triangle { <-0.816951, 0.591425, 0.150539>, <-0.806523, 0.585973, 0.078459>, <-0.799057, 0.580549, 0.156434> }
triangle { <-0.806523, 0.585973, 0.078459>, <-0.816951, 0.591425, 0.150539>, <-0.819477, 0.593254, 0.078217> }
triangle { <-0.819477, 0.593254, 0.078217>, <-0.809017, 0.587785, 0.000000>, <-0.806523, 0.585973, 0.078459> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.066937, 0.047324, 0.997394> }
triangle { <-0.066937, 0.047324, 0.997394>, <-0.064295, 0.046546, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.064295, 0.046546, 0.997158>, <-0.066937, 0.047324, 0.997394>, <-0.133461, 0.094357, 0.989591> }
triangle { <-0.133461, 0.094357, 0.989591>, <-0.128194, 0.092805, 0.988651>, <-0.064295, 0.046546, 0.997158> }
triangle { <-0.128194, 0.092805, 0.988651>, <-0.133461, 0.094357, 0.989591>, <-0.199163, 0.140807, 0.976639> }
triangle { <-0.199163, 0.140807, 0.976639>, <-0.191303, 0.138492, 0.974531>, <-0.128194, 0.092805, 0.988651> }
triangle { <-0.191303, 0.138492, 0.974531>, <-0.199163, 0.140807, 0.976639>, <-0.263636, 0.186390, 0.958619> }
triangle { <-0.263636, 0.186390, 0.958619>, <-0.253232, 0.183326, 0.954885>, <-0.191303, 0.138492, 0.974531> }
triangle { <-0.253232, 0.183326, 0.954885>, <-0.263636, 0.186390, 0.958619>, <-0.326484, 0.230824, 0.935641> }
triangle { <-0.326484, 0.230824, 0.935641>, <-0.313600, 0.227029, 0.929833>, <-0.253232, 0.183326, 0.954885> }
triangle { <-0.313600, 0.227029, 0.929833>, <-0.326484, 0.230824, 0.935641>, <-0.387320, 0.273834, 0.907847> }
triangle { <-0.387320, 0.273834, 0.907847>, <-0.372035, 0.269332, 0.899532>, <-0.313600, 0.227029, 0.929833> }
triangle { <-0.372035, 0.269332, 0.899532>, <-0.387320, 0.273834, 0.907847>, <-0.445767, 0.315156, 0.875409> }
triangle { <-0.445767, 0.315156, 0.875409>, <-0.428175, 0.309974, 0.864166>, <-0.372035, 0.269332, 0.899532> }
triangle { <-0.428175, 0.309974, 0.864166>, <-0.445767, 0.315156, 0.875409>, <-0.501466, 0.354535, 0.838525> }
triangle { <-0.501466, 0.354535, 0.838525>, <-0.481676, 0.348706, 0.823955>, <-0.428175, 0.309974, 0.864166> }
triangle { <-0.481676, 0.348706, 0.823955>, <-0.501466, 0.354535, 0.838525>, <-0.554073, 0.391728, 0.797425> }
triangle { <-0.554073, 0.391728, 0.797425>, <-0.532208, 0.385288, 0.779146>, <-0.481676, 0.348706, 0.823955> }
triangle { <-0.532208, 0.385288, 0.779146>, <-0.554073, 0.391728, 0.797425>, <-0.603265, 0.426506, 0.752361> }
triangle { <-0.603265, 0.426506, 0.752361>, <-0.579458, 0.419494, 0.730016>, <-0.532208, 0.385288, 0.779146> }
triangle { <-0.579458, 0.419494, 0.730016>, <-0.603265, 0.426506, 0.752361>, <-0.648737, 0.458655, 0.703611> }
triangle { <-0.648737, 0.458655, 0.703611>, <-0.623135, 0.451114, 0.676867>, <-0.579458, 0.419494, 0.730016> }
triangle { <-0.623135, 0.451114, 0.676867>, <-0.648737, 0.458655, 0.703611>, <-0.690209, 0.487976, 0.651476> }
triangle { <-0.690209, 0.487976, 0.651476>, <-0.662971, 0.479953, 0.620028>, <-0.623135, 0.451114, 0.676867> }
triangle { <-0.662971, 0.479953, 0.620028>, <-0.690209, 0.487976, 0.651476>, <-0.727426, 0.514288, 0.596277> }
triangle { <-0.727426, 0.514288, 0.596277>, <-0.698719, 0.505832, 0.559847>, <-0.662971, 0.479953, 0.620028> }
triangle { <-0.698719, 0.505832, 0.559847>, <-0.727426, 0.514288, 0.596277>, <-0.760158, 0.537429, 0.538354> }
triangle { <-0.760158, 0.537429, 0.538354>, <-0.730159, 0.528593, 0.496698>, <-0.698719, 0.505832, 0.559847> }
triangle { <-0.730159, 0.528593, 0.496698>, <-0.760158, 0.537429, 0.538354>, <-0.788203, 0.557257, 0.478064> }
triangle { <-0.788203, 0.557257, 0.478064>, <-0.757098, 0.548095, 0.430968>, <-0.730159, 0.528593, 0.496698> }
triangle { <-0.757098, 0.548095, 0.430968>, <-0.788203, 0.557257, 0.478064>, <-0.811389, 0.573650, 0.415780> }
triangle { <-0.811389, 0.573650, 0.415780>, <-0.779369, 0.564218, 0.363064>, <-0.757098, 0.548095, 0.430968> }
triangle { <-0.779369, 0.564218, 0.363064>, <-0.811389, 0.573650, 0.415780>, <-0.829573, 0.586505, 0.351885> }
triangle { <-0.829573, 0.586505, 0.351885>, <-0.796835, 0.576863, 0.293403>, <-0.779369, 0.564218, 0.363064> }
triangle { <-0.796835, 0.576863, 0.293403>, <-0.829573, 0.586505, 0.351885>, <-0.842641, 0.595745, 0.286773> }
triangle { <-0.842641, 0.595745, 0.286773>, <-0.809388, 0.585950, 0.222416>, <-0.796835, 0.576863, 0.293403> }
triangle { <-0.809388, 0.585950, 0.222416>, <-0.842641, 0.595745, 0.286773>, <-0.850515, 0.601312, 0.220845> }
triangle { <-0.850515, 0.601312, 0.220845>, <-0.816951, 0.591425, 0.150539>, <-0.809388, 0.585950, 0.222416> }
triangle { <-0.816951, 0.591425, 0.150539>, <-0.850515, 0.601312, 0.220845>, <-0.853145, 0.603171, 0.154508> }
triangle { <-0.853145, 0.603171, 0.154508>, <-0.819477, 0.593254, 0.078217>, <-0.816951, 0.591425, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.071439, 0.047647, 0.997617> }
triangle { <-0.071439, 0.047647, 0.997617>, <-0.066937, 0.047324, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.066937, 0.047324, 0.997394>, <-0.071439, 0.047647, 0.997617>, <-0.142438, 0.095000, 0.990483> }
triangle { <-0.142438, 0.095000, 0.990483>, <-0.133461, 0.094357, 0.989591>, <-0.066937, 0.047324, 0.997394> }
triangle { <-0.133461, 0.094357, 0.989591>, <-0.142438, 0.095000, 0.990483>, <-0.212559, 0.141768, 0.978642> }
triangle { <-0.212559, 0.141768, 0.978642>, <-0.199163, 0.140807, 0.976639>, <-0.133461, 0.094357, 0.989591> }
triangle { <-0.199163, 0.140807, 0.976639>, <-0.212559, 0.141768, 0.978642>, <-0.281370, 0.187662, 0.962166> }
triangle { <-0.281370, 0.187662, 0.962166>, <-0.263636, 0.186390, 0.958619>, <-0.199163, 0.140807, 0.976639> }
triangle { <-0.263636, 0.186390, 0.958619>, <-0.281370, 0.187662, 0.962166>, <-0.348445, 0.232398, 0.941159> }
triangle { <-0.348445, 0.232398, 0.941159>, <-0.326484, 0.230824, 0.935641>, <-0.263636, 0.186390, 0.958619> }
triangle { <-0.326484, 0.230824, 0.935641>, <-0.348445, 0.232398, 0.941159>, <-0.413372, 0.275702, 0.915748> }
triangle { <-0.413372, 0.275702, 0.915748>, <-0.387320, 0.273834, 0.907847>, <-0.326484, 0.230824, 0.935641> }
triangle { <-0.387320, 0.273834, 0.907847>, <-0.413372, 0.275702, 0.915748>, <-0.475751, 0.317306, 0.886090> }
triangle { <-0.475751, 0.317306, 0.886090>, <-0.445767, 0.315156, 0.875409>, <-0.387320, 0.273834, 0.907847> }
triangle { <-0.445767, 0.315156, 0.875409>, <-0.475751, 0.317306, 0.886090>, <-0.535197, 0.356954, 0.852369> }
triangle { <-0.535197, 0.356954, 0.852369>, <-0.501466, 0.354535, 0.838525>, <-0.445767, 0.315156, 0.875409> }
triangle { <-0.501466, 0.354535, 0.838525>, <-0.535197, 0.356954, 0.852369>, <-0.591343, 0.394401, 0.814793> }
triangle { <-0.591343, 0.394401, 0.814793>, <-0.554073, 0.391728, 0.797425>, <-0.501466, 0.354535, 0.838525> }
triangle { <-0.554073, 0.391728, 0.797425>, <-0.591343, 0.394401, 0.814793>, <-0.643843, 0.429416, 0.773592> }
triangle { <-0.643843, 0.429416, 0.773592>, <-0.603265, 0.426506, 0.752361>, <-0.554073, 0.391728, 0.797425> }
triangle { <-0.603265, 0.426506, 0.752361>, <-0.643843, 0.429416, 0.773592>, <-0.692373, 0.461784, 0.729022> }
triangle { <-0.692373, 0.461784, 0.729022>, <-0.648737, 0.458655, 0.703611>, <-0.603265, 0.426506, 0.752361> }
triangle { <-0.648737, 0.458655, 0.703611>, <-0.692373, 0.461784, 0.729022>, <-0.736635, 0.491305, 0.681356> }
triangle { <-0.736635, 0.491305, 0.681356>, <-0.690209, 0.487976, 0.651476>, <-0.648737, 0.458655, 0.703611> }
triangle { <-0.690209, 0.487976, 0.651476>, <-0.736635, 0.491305, 0.681356>, <-0.776355, 0.517796, 0.630889> }
triangle { <-0.776355, 0.517796, 0.630889>, <-0.727426, 0.514288, 0.596277>, <-0.690209, 0.487976, 0.651476> }
triangle { <-0.727426, 0.514288, 0.596277>, <-0.776355, 0.517796, 0.630889>, <-0.811289, 0.541096, 0.577932> }
triangle { <-0.811289, 0.541096, 0.577932>, <-0.760158, 0.537429, 0.538354>, <-0.727426, 0.514288, 0.596277> }
triangle { <-0.760158, 0.537429, 0.538354>, <-0.811289, 0.541096, 0.577932>, <-0.841221, 0.561059, 0.522811> }
triangle { <-0.841221, 0.561059, 0.522811>, <-0.788203, 0.557257, 0.478064>, <-0.760158, 0.537429, 0.538354> }
triangle { <-0.788203, 0.557257, 0.478064>, <-0.841221, 0.561059, 0.522811>, <-0.865967, 0.577563, 0.465867> }
triangle { <-0.865967, 0.577563, 0.465867>, <-0.811389, 0.573650, 0.415780>, <-0.788203, 0.557257, 0.478064> }
triangle { <-0.811389, 0.573650, 0.415780>, <-0.865967, 0.577563, 0.465867>, <-0.885373, 0.590507, 0.407450> }
triangle { <-0.885373, 0.590507, 0.407450>, <-0.829573, 0.586505, 0.351885>, <-0.811389, 0.573650, 0.415780> }
triangle { <-0.829573, 0.586505, 0.351885>, <-0.885373, 0.590507, 0.407450>, <-0.899321, 0.599809, 0.347920> }
triangle { <-0.899321, 0.599809, 0.347920>, <-0.842641, 0.595745, 0.286773>, <-0.829573, 0.586505, 0.351885> }
triangle { <-0.842641, 0.595745, 0.286773>, <-0.899321, 0.599809, 0.347920>, <-0.907724, 0.605414, 0.287645> }
triangle { <-0.907724, 0.605414, 0.287645>, <-0.850515, 0.601312, 0.220845>, <-0.842641, 0.595745, 0.286773> }
triangle { <-0.850515, 0.601312, 0.220845>, <-0.907724, 0.605414, 0.287645>, <-0.910531, 0.607286, 0.226995> }
triangle { <-0.910531, 0.607286, 0.226995>, <-0.853145, 0.603171, 0.154508>, <-0.850515, 0.601312, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.077537, 0.046750, 0.997823> }
triangle { <-0.077537, 0.046750, 0.997823>, <-0.071439, 0.047647, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.071439, 0.047647, 0.997617>, <-0.077537, 0.046750, 0.997823>, <-0.154596, 0.093212, 0.991307> }
triangle { <-0.154596, 0.093212, 0.991307>, <-0.142438, 0.095000, 0.990483>, <-0.071439, 0.047647, 0.997617> }
triangle { <-0.142438, 0.095000, 0.990483>, <-0.154596, 0.093212, 0.991307>, <-0.230702, 0.139099, 0.980490> }
triangle { <-0.230702, 0.139099, 0.980490>, <-0.212559, 0.141768, 0.978642>, <-0.142438, 0.095000, 0.990483> }
triangle { <-0.212559, 0.141768, 0.978642>, <-0.230702, 0.139099, 0.980490>, <-0.305385, 0.184128, 0.965441> }
triangle { <-0.305385, 0.184128, 0.965441>, <-0.281370, 0.187662, 0.962166>, <-0.212559, 0.141768, 0.978642> }
triangle { <-0.281370, 0.187662, 0.962166>, <-0.305385, 0.184128, 0.965441>, <-0.378186, 0.228023, 0.946251> }
triangle { <-0.378186, 0.228023, 0.946251>, <-0.348445, 0.232398, 0.941159>, <-0.281370, 0.187662, 0.962166> }
triangle { <-0.348445, 0.232398, 0.941159>, <-0.378186, 0.228023, 0.946251>, <-0.448655, 0.270511, 0.923039> }
triangle { <-0.448655, 0.270511, 0.923039>, <-0.413372, 0.275702, 0.915748>, <-0.348445, 0.232398, 0.941159> }
triangle { <-0.413372, 0.275702, 0.915748>, <-0.448655, 0.270511, 0.923039>, <-0.516358, 0.311332, 0.895948> }
triangle { <-0.516358, 0.311332, 0.895948>, <-0.475751, 0.317306, 0.886090>, <-0.413372, 0.275702, 0.915748> }
triangle { <-0.475751, 0.317306, 0.886090>, <-0.516358, 0.311332, 0.895948>, <-0.580877, 0.350233, 0.865145> }
triangle { <-0.580877, 0.350233, 0.865145>, <-0.535197, 0.356954, 0.852369>, <-0.475751, 0.317306, 0.886090> }
triangle { <-0.535197, 0.356954, 0.852369>, <-0.580877, 0.350233, 0.865145>, <-0.641815, 0.386975, 0.830821> }
triangle { <-0.641815, 0.386975, 0.830821>, <-0.591343, 0.394401, 0.814793>, <-0.535197, 0.356954, 0.852369> }
triangle { <-0.591343, 0.394401, 0.814793>, <-0.641815, 0.386975, 0.830821>, <-0.698796, 0.421331, 0.793186> }
triangle { <-0.698796, 0.421331, 0.793186>, <-0.643843, 0.429416, 0.773592>, <-0.591343, 0.394401, 0.814793> }
triangle { <-0.643843, 0.429416, 0.773592>, <-0.698796, 0.421331, 0.793186>, <-0.751469, 0.453090, 0.752473> }
triangle { <-0.751469, 0.453090, 0.752473>, <-0.692373, 0.461784, 0.729022>, <-0.643843, 0.429416, 0.773592> }
triangle { <-0.692373, 0.461784, 0.729022>, <-0.751469, 0.453090, 0.752473>, <-0.799509, 0.482054, 0.708932> }
triangle { <-0.799509, 0.482054, 0.708932>, <-0.736635, 0.491305, 0.681356>, <-0.692373, 0.461784, 0.729022> }
triangle { <-0.736635, 0.491305, 0.681356>, <-0.799509, 0.482054, 0.708932>, <-0.842619, 0.508047, 0.662833> }
triangle { <-0.842619, 0.508047, 0.662833>, <-0.776355, 0.517796, 0.630889>, <-0.736635, 0.491305, 0.681356> }
triangle { <-0.776355, 0.517796, 0.630889>, <-0.842619, 0.508047, 0.662833>, <-0.880535, 0.530908, 0.614459> }
triangle { <-0.880535, 0.530908, 0.614459>, <-0.811289, 0.541096, 0.577932>, <-0.776355, 0.517796, 0.630889> }
triangle { <-0.811289, 0.541096, 0.577932>, <-0.880535, 0.530908, 0.614459>, <-0.913021, 0.550496, 0.564108> }
triangle { <-0.913021, 0.550496, 0.564108>, <-0.841221, 0.561059, 0.522811>, <-0.811289, 0.541096, 0.577932> }
triangle { <-0.841221, 0.561059, 0.522811>, <-0.913021, 0.550496, 0.564108>, <-0.939879, 0.566689, 0.512092> }
triangle { <-0.939879, 0.566689, 0.512092>, <-0.865967, 0.577563, 0.465867>, <-0.841221, 0.561059, 0.522811> }
triangle { <-0.865967, 0.577563, 0.465867>, <-0.939879, 0.566689, 0.512092>, <-0.960942, 0.579389, 0.458730> }
triangle { <-0.960942, 0.579389, 0.458730>, <-0.885373, 0.590507, 0.407450>, <-0.865967, 0.577563, 0.465867> }
triangle { <-0.885373, 0.590507, 0.407450>, <-0.960942, 0.579389, 0.458730>, <-0.976080, 0.588516, 0.404352> }
triangle { <-0.976080, 0.588516, 0.404352>, <-0.899321, 0.599809, 0.347920>, <-0.885373, 0.590507, 0.407450> }
triangle { <-0.899321, 0.599809, 0.347920>, <-0.976080, 0.588516, 0.404352>, <-0.985201, 0.594015, 0.349293> }
triangle { <-0.985201, 0.594015, 0.349293>, <-0.907724, 0.605414, 0.287645>, <-0.899321, 0.599809, 0.347920> }
triangle { <-0.907724, 0.605414, 0.287645>, <-0.985201, 0.594015, 0.349293>, <-0.988247, 0.595852, 0.293893> }
triangle { <-0.988247, 0.595852, 0.293893>, <-0.910531, 0.607286, 0.226995>, <-0.907724, 0.605414, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.084694, 0.044018, 0.998007> }
triangle { <-0.084694, 0.044018, 0.998007>, <-0.077537, 0.046750, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.077537, 0.046750, 0.997823>, <-0.084694, 0.044018, 0.998007>, <-0.168865, 0.087765, 0.992041> }
triangle { <-0.168865, 0.087765, 0.992041>, <-0.154596, 0.093212, 0.991307>, <-0.077537, 0.046750, 0.997823> }
triangle { <-0.154596, 0.093212, 0.991307>, <-0.168865, 0.087765, 0.992041>, <-0.251996, 0.130970, 0.982139> }
triangle { <-0.251996, 0.130970, 0.982139>, <-0.230702, 0.139099, 0.980490>, <-0.154596, 0.093212, 0.991307> }
triangle { <-0.230702, 0.139099, 0.980490>, <-0.251996, 0.130970, 0.982139>, <-0.333573, 0.173368, 0.968361> }
triangle { <-0.333573, 0.173368, 0.968361>, <-0.305385, 0.184128, 0.965441>, <-0.230702, 0.139099, 0.980490> }
triangle { <-0.305385, 0.184128, 0.965441>, <-0.333573, 0.173368, 0.968361>, <-0.413093, 0.214698, 0.950792> }
triangle { <-0.413093, 0.214698, 0.950792>, <-0.378186, 0.228023, 0.946251>, <-0.305385, 0.184128, 0.965441> }
triangle { <-0.378186, 0.228023, 0.946251>, <-0.413093, 0.214698, 0.950792>, <-0.490067, 0.254703, 0.929542> }
triangle { <-0.490067, 0.254703, 0.929542>, <-0.448655, 0.270511, 0.923039>, <-0.378186, 0.228023, 0.946251> }
triangle { <-0.448655, 0.270511, 0.923039>, <-0.490067, 0.254703, 0.929542>, <-0.564019, 0.293138, 0.904740> }
triangle { <-0.564019, 0.293138, 0.904740>, <-0.516358, 0.311332, 0.895948>, <-0.448655, 0.270511, 0.923039> }
triangle { <-0.516358, 0.311332, 0.895948>, <-0.564019, 0.293138, 0.904740>, <-0.634493, 0.329766, 0.876540> }
triangle { <-0.634493, 0.329766, 0.876540>, <-0.580877, 0.350233, 0.865145>, <-0.516358, 0.311332, 0.895948> }
triangle { <-0.580877, 0.350233, 0.865145>, <-0.634493, 0.329766, 0.876540>, <-0.701056, 0.364361, 0.845115> }
triangle { <-0.701056, 0.364361, 0.845115>, <-0.641815, 0.386975, 0.830821>, <-0.580877, 0.350233, 0.865145> }
triangle { <-0.641815, 0.386975, 0.830821>, <-0.701056, 0.364361, 0.845115>, <-0.763297, 0.396709, 0.810660> }
triangle { <-0.763297, 0.396709, 0.810660>, <-0.698796, 0.421331, 0.793186>, <-0.641815, 0.386975, 0.830821> }
triangle { <-0.698796, 0.421331, 0.793186>, <-0.763297, 0.396709, 0.810660>, <-0.820831, 0.426612, 0.773387> }
triangle { <-0.820831, 0.426612, 0.773387>, <-0.751469, 0.453090, 0.752473>, <-0.698796, 0.421331, 0.793186> }
triangle { <-0.751469, 0.453090, 0.752473>, <-0.820831, 0.426612, 0.773387>, <-0.873305, 0.453884, 0.733525> }
triangle { <-0.873305, 0.453884, 0.733525>, <-0.799509, 0.482054, 0.708932>, <-0.751469, 0.453090, 0.752473> }
triangle { <-0.799509, 0.482054, 0.708932>, <-0.873305, 0.453884, 0.733525>, <-0.920395, 0.478358, 0.691321> }
triangle { <-0.920395, 0.478358, 0.691321>, <-0.842619, 0.508047, 0.662833>, <-0.799509, 0.482054, 0.708932> }
triangle { <-0.842619, 0.508047, 0.662833>, <-0.920395, 0.478358, 0.691321>, <-0.961810, 0.499883, 0.647034> }
triangle { <-0.961810, 0.499883, 0.647034>, <-0.880535, 0.530908, 0.614459>, <-0.842619, 0.508047, 0.662833> }
triangle { <-0.880535, 0.530908, 0.614459>, <-0.961810, 0.499883, 0.647034>, <-0.997295, 0.518326, 0.600938> }
triangle { <-0.997295, 0.518326, 0.600938>, <-0.913021, 0.550496, 0.564108>, <-0.880535, 0.530908, 0.614459> }
triangle { <-0.913021, 0.550496, 0.564108>, <-0.997295, 0.518326, 0.600938>, <-1.026632, 0.533573, 0.553316> }
triangle { <-1.026632, 0.533573, 0.553316>, <-0.939879, 0.566689, 0.512092>, <-0.913021, 0.550496, 0.564108> }
triangle { <-0.939879, 0.566689, 0.512092>, <-1.026632, 0.533573, 0.553316>, <-1.049639, 0.545530, 0.504463> }
triangle { <-1.049639, 0.545530, 0.504463>, <-0.960942, 0.579389, 0.458730>, <-0.939879, 0.566689, 0.512092> }
triangle { <-0.960942, 0.579389, 0.458730>, <-1.049639, 0.545530, 0.504463>, <-1.066174, 0.554124, 0.454680> }
triangle { <-1.066174, 0.554124, 0.454680>, <-0.976080, 0.588516, 0.404352>, <-0.960942, 0.579389, 0.458730> }
triangle { <-0.976080, 0.588516, 0.404352>, <-1.066174, 0.554124, 0.454680>, <-1.076137, 0.559302, 0.404273> }
triangle { <-1.076137, 0.559302, 0.404273>, <-0.985201, 0.594015, 0.349293>, <-0.976080, 0.588516, 0.404352> }
triangle { <-0.985201, 0.594015, 0.349293>, <-1.076137, 0.559302, 0.404273>, <-1.079464, 0.561032, 0.353553> }
triangle { <-1.079464, 0.561032, 0.353553>, <-0.988247, 0.595852, 0.293893>, <-0.985201, 0.594015, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.092178, 0.039075, 0.998164> }
triangle { <-0.092178, 0.039075, 0.998164>, <-0.084694, 0.044018, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.084694, 0.044018, 0.998007>, <-0.092178, 0.039075, 0.998164>, <-0.183788, 0.077910, 0.992669> }
triangle { <-0.183788, 0.077910, 0.992669>, <-0.168865, 0.087765, 0.992041>, <-0.084694, 0.044018, 0.998007> }
triangle { <-0.168865, 0.087765, 0.992041>, <-0.183788, 0.077910, 0.992669>, <-0.274265, 0.116264, 0.983547> }
triangle { <-0.274265, 0.116264, 0.983547>, <-0.251996, 0.130970, 0.982139>, <-0.168865, 0.087765, 0.992041> }
triangle { <-0.251996, 0.130970, 0.982139>, <-0.274265, 0.116264, 0.983547>, <-0.363051, 0.153901, 0.970855> }
triangle { <-0.363051, 0.153901, 0.970855>, <-0.333573, 0.173368, 0.968361>, <-0.251996, 0.130970, 0.982139> }
triangle { <-0.333573, 0.173368, 0.968361>, <-0.363051, 0.153901, 0.970855>, <-0.449599, 0.190589, 0.954671> }
triangle { <-0.449599, 0.190589, 0.954671>, <-0.413093, 0.214698, 0.950792>, <-0.333573, 0.173368, 0.968361> }
triangle { <-0.413093, 0.214698, 0.950792>, <-0.449599, 0.190589, 0.954671>, <-0.533374, 0.226102, 0.935095> }
triangle { <-0.533374, 0.226102, 0.935095>, <-0.490067, 0.254703, 0.929542>, <-0.413093, 0.214698, 0.950792> }
triangle { <-0.490067, 0.254703, 0.929542>, <-0.533374, 0.226102, 0.935095>, <-0.613862, 0.260222, 0.912248> }
triangle { <-0.613862, 0.260222, 0.912248>, <-0.564019, 0.293138, 0.904740>, <-0.490067, 0.254703, 0.929542> }
triangle { <-0.564019, 0.293138, 0.904740>, <-0.613862, 0.260222, 0.912248>, <-0.690564, 0.292737, 0.886271> }
triangle { <-0.690564, 0.292737, 0.886271>, <-0.634493, 0.329766, 0.876540>, <-0.564019, 0.293138, 0.904740> }
triangle { <-0.634493, 0.329766, 0.876540>, <-0.690564, 0.292737, 0.886271>, <-0.763009, 0.323447, 0.857324> }
triangle { <-0.763009, 0.323447, 0.857324>, <-0.701056, 0.364361, 0.845115>, <-0.634493, 0.329766, 0.876540> }
triangle { <-0.701056, 0.364361, 0.845115>, <-0.763009, 0.323447, 0.857324>, <-0.830750, 0.352163, 0.825585> }
triangle { <-0.830750, 0.352163, 0.825585>, <-0.763297, 0.396709, 0.810660>, <-0.701056, 0.364361, 0.845115> }
triangle { <-0.763297, 0.396709, 0.810660>, <-0.830750, 0.352163, 0.825585>, <-0.893369, 0.378707, 0.791249> }
triangle { <-0.893369, 0.378707, 0.791249>, <-0.820831, 0.426612, 0.773387>, <-0.763297, 0.396709, 0.810660> }
triangle { <-0.820831, 0.426612, 0.773387>, <-0.893369, 0.378707, 0.791249>, <-0.950480, 0.402917, 0.754530> }
triangle { <-0.950480, 0.402917, 0.754530>, <-0.873305, 0.453884, 0.733525>, <-0.820831, 0.426612, 0.773387> }
triangle { <-0.873305, 0.453884, 0.733525>, <-0.950480, 0.402917, 0.754530>, <-1.001731, 0.424643, 0.715652> }
triangle { <-1.001731, 0.424643, 0.715652>, <-0.920395, 0.478358, 0.691321>, <-0.873305, 0.453884, 0.733525> }
triangle { <-0.920395, 0.478358, 0.691321>, <-1.001731, 0.424643, 0.715652>, <-1.046806, 0.443751, 0.674856> }
triangle { <-1.046806, 0.443751, 0.674856>, <-0.961810, 0.499883, 0.647034>, <-0.920395, 0.478358, 0.691321> }
triangle { <-0.961810, 0.499883, 0.647034>, <-1.046806, 0.443751, 0.674856>, <-1.085427, 0.460123, 0.632393> }
triangle { <-1.085427, 0.460123, 0.632393>, <-0.997295, 0.518326, 0.600938>, <-0.961810, 0.499883, 0.647034> }
triangle { <-0.997295, 0.518326, 0.600938>, <-1.085427, 0.460123, 0.632393>, <-1.117356, 0.473658, 0.588525> }
triangle { <-1.117356, 0.473658, 0.588525>, <-1.026632, 0.533573, 0.553316>, <-0.997295, 0.518326, 0.600938> }
triangle { <-1.026632, 0.533573, 0.553316>, <-1.117356, 0.473658, 0.588525>, <-1.142396, 0.484273, 0.543523> }
triangle { <-1.142396, 0.484273, 0.543523>, <-1.049639, 0.545530, 0.504463>, <-1.026632, 0.533573, 0.553316> }
triangle { <-1.049639, 0.545530, 0.504463>, <-1.142396, 0.484273, 0.543523>, <-1.160393, 0.491902, 0.497664> }
triangle { <-1.160393, 0.491902, 0.497664>, <-1.066174, 0.554124, 0.454680>, <-1.049639, 0.545530, 0.504463> }
triangle { <-1.066174, 0.554124, 0.454680>, <-1.160393, 0.491902, 0.497664>, <-1.171236, 0.496498, 0.451230> }
triangle { <-1.171236, 0.496498, 0.451230>, <-1.076137, 0.559302, 0.404273>, <-1.066174, 0.554124, 0.454680> }
triangle { <-1.076137, 0.559302, 0.404273>, <-1.171236, 0.496498, 0.451230>, <-1.174858, 0.498033, 0.404508> }
triangle { <-1.174858, 0.498033, 0.404508>, <-1.079464, 0.561032, 0.353553>, <-1.076137, 0.559302, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.099164, 0.031841, 0.998291> }
triangle { <-0.099164, 0.031841, 0.998291>, <-0.092178, 0.039075, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.092178, 0.039075, 0.998164>, <-0.099164, 0.031841, 0.998291>, <-0.197718, 0.063485, 0.993173> }
triangle { <-0.197718, 0.063485, 0.993173>, <-0.183788, 0.077910, 0.992669>, <-0.092178, 0.039075, 0.998164> }
triangle { <-0.183788, 0.077910, 0.992669>, <-0.197718, 0.063485, 0.993173>, <-0.295052, 0.094737, 0.984679> }
triangle { <-0.295052, 0.094737, 0.984679>, <-0.274265, 0.116264, 0.983547>, <-0.183788, 0.077910, 0.992669> }
triangle { <-0.274265, 0.116264, 0.983547>, <-0.295052, 0.094737, 0.984679>, <-0.390567, 0.125406, 0.972861> }
triangle { <-0.390567, 0.125406, 0.972861>, <-0.363051, 0.153901, 0.970855>, <-0.274265, 0.116264, 0.983547> }
triangle { <-0.363051, 0.153901, 0.970855>, <-0.390567, 0.125406, 0.972861>, <-0.483674, 0.155302, 0.957791> }
triangle { <-0.483674, 0.155302, 0.957791>, <-0.449599, 0.190589, 0.954671>, <-0.363051, 0.153901, 0.970855> }
triangle { <-0.449599, 0.190589, 0.954671>, <-0.483674, 0.155302, 0.957791>, <-0.573799, 0.184240, 0.939563> }
triangle { <-0.573799, 0.184240, 0.939563>, <-0.533374, 0.226102, 0.935095>, <-0.449599, 0.190589, 0.954671> }
triangle { <-0.533374, 0.226102, 0.935095>, <-0.573799, 0.184240, 0.939563>, <-0.660386, 0.212042, 0.918289> }
triangle { <-0.660386, 0.212042, 0.918289>, <-0.613862, 0.260222, 0.912248>, <-0.533374, 0.226102, 0.935095> }
triangle { <-0.613862, 0.260222, 0.912248>, <-0.660386, 0.212042, 0.918289>, <-0.742902, 0.238537, 0.894101> }
triangle { <-0.742902, 0.238537, 0.894101>, <-0.690564, 0.292737, 0.886271>, <-0.613862, 0.260222, 0.912248> }
triangle { <-0.690564, 0.292737, 0.886271>, <-0.742902, 0.238537, 0.894101>, <-0.820838, 0.263561, 0.867146> }
triangle { <-0.820838, 0.263561, 0.867146>, <-0.763009, 0.323447, 0.857324>, <-0.690564, 0.292737, 0.886271> }
triangle { <-0.763009, 0.323447, 0.857324>, <-0.820838, 0.263561, 0.867146>, <-0.893713, 0.286960, 0.837592> }
triangle { <-0.893713, 0.286960, 0.837592>, <-0.830750, 0.352163, 0.825585>, <-0.763009, 0.323447, 0.857324> }
triangle { <-0.830750, 0.352163, 0.825585>, <-0.893713, 0.286960, 0.837592>, <-0.961078, 0.308590, 0.805620> }
triangle { <-0.961078, 0.308590, 0.805620>, <-0.893369, 0.378707, 0.791249>, <-0.830750, 0.352163, 0.825585> }
triangle { <-0.893369, 0.378707, 0.791249>, <-0.961078, 0.308590, 0.805620>, <-1.022517, 0.328318, 0.771428> }
triangle { <-1.022517, 0.328318, 0.771428>, <-0.950480, 0.402917, 0.754530>, <-0.893369, 0.378707, 0.791249> }
triangle { <-0.950480, 0.402917, 0.754530>, <-1.022517, 0.328318, 0.771428>, <-1.077652, 0.346021, 0.735227> }
triangle { <-1.077652, 0.346021, 0.735227>, <-1.001731, 0.424643, 0.715652>, <-0.950480, 0.402917, 0.754530> }
triangle { <-1.001731, 0.424643, 0.715652>, <-1.077652, 0.346021, 0.735227>, <-1.126144, 0.361591, 0.697240> }
triangle { <-1.126144, 0.361591, 0.697240>, <-1.046806, 0.443751, 0.674856>, <-1.001731, 0.424643, 0.715652> }
triangle { <-1.046806, 0.443751, 0.674856>, <-1.126144, 0.361591, 0.697240>, <-1.167692, 0.374932, 0.657700> }
triangle { <-1.167692, 0.374932, 0.657700>, <-1.085427, 0.460123, 0.632393>, <-1.046806, 0.443751, 0.674856> }
triangle { <-1.085427, 0.460123, 0.632393>, <-1.167692, 0.374932, 0.657700>, <-1.202041, 0.385961, 0.616852> }
triangle { <-1.202041, 0.385961, 0.616852>, <-1.117356, 0.473658, 0.588525>, <-1.085427, 0.460123, 0.632393> }
triangle { <-1.117356, 0.473658, 0.588525>, <-1.202041, 0.385961, 0.616852>, <-1.228979, 0.394610, 0.574948> }
triangle { <-1.228979, 0.394610, 0.574948>, <-1.142396, 0.484273, 0.543523>, <-1.117356, 0.473658, 0.588525> }
triangle { <-1.142396, 0.484273, 0.543523>, <-1.228979, 0.394610, 0.574948>, <-1.248340, 0.400827, 0.532246> }
triangle { <-1.248340, 0.400827, 0.532246>, <-1.160393, 0.491902, 0.497664>, <-1.142396, 0.484273, 0.543523> }
triangle { <-1.160393, 0.491902, 0.497664>, <-1.248340, 0.400827, 0.532246>, <-1.260004, 0.404572, 0.489009> }
triangle { <-1.260004, 0.404572, 0.489009>, <-1.171236, 0.496498, 0.451230>, <-1.160393, 0.491902, 0.497664> }
triangle { <-1.171236, 0.496498, 0.451230>, <-1.260004, 0.404572, 0.489009>, <-1.263901, 0.405823, 0.445503> }
triangle { <-1.263901, 0.405823, 0.445503>, <-1.174858, 0.498033, 0.404508>, <-1.171236, 0.496498, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.104847, 0.022542, 0.998383> }
triangle { <-0.104847, 0.022542, 0.998383>, <-0.099164, 0.031841, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.099164, 0.031841, 0.998291>, <-0.104847, 0.022542, 0.998383>, <-0.209048, 0.044945, 0.993543> }
triangle { <-0.209048, 0.044945, 0.993543>, <-0.197718, 0.063485, 0.993173>, <-0.099164, 0.031841, 0.998291> }
triangle { <-0.197718, 0.063485, 0.993173>, <-0.209048, 0.044945, 0.993543>, <-0.311960, 0.067071, 0.985509> }
triangle { <-0.311960, 0.067071, 0.985509>, <-0.295052, 0.094737, 0.984679>, <-0.197718, 0.063485, 0.993173> }
triangle { <-0.295052, 0.094737, 0.984679>, <-0.311960, 0.067071, 0.985509>, <-0.412949, 0.088783, 0.974331> }
triangle { <-0.412949, 0.088783, 0.974331>, <-0.390567, 0.125406, 0.972861>, <-0.295052, 0.094737, 0.984679> }
triangle { <-0.390567, 0.125406, 0.972861>, <-0.412949, 0.088783, 0.974331>, <-0.511392, 0.109949, 0.960077> }
triangle { <-0.511392, 0.109949, 0.960077>, <-0.483674, 0.155302, 0.957791>, <-0.390567, 0.125406, 0.972861> }
triangle { <-0.483674, 0.155302, 0.957791>, <-0.511392, 0.109949, 0.960077>, <-0.606682, 0.130436, 0.942836> }
triangle { <-0.606682, 0.130436, 0.942836>, <-0.573799, 0.184240, 0.939563>, <-0.483674, 0.155302, 0.957791> }
triangle { <-0.573799, 0.184240, 0.939563>, <-0.606682, 0.130436, 0.942836>, <-0.698231, 0.150119, 0.922714> }
triangle { <-0.698231, 0.150119, 0.922714>, <-0.660386, 0.212042, 0.918289>, <-0.573799, 0.184240, 0.939563> }
triangle { <-0.660386, 0.212042, 0.918289>, <-0.698231, 0.150119, 0.922714>, <-0.785476, 0.168876, 0.899835> }
triangle { <-0.785476, 0.168876, 0.899835>, <-0.742902, 0.238537, 0.894101>, <-0.660386, 0.212042, 0.918289> }
triangle { <-0.742902, 0.238537, 0.894101>, <-0.785476, 0.168876, 0.899835>, <-0.867878, 0.186592, 0.874340> }
triangle { <-0.867878, 0.186592, 0.874340>, <-0.820838, 0.263561, 0.867146>, <-0.742902, 0.238537, 0.894101> }
triangle { <-0.820838, 0.263561, 0.867146>, <-0.867878, 0.186592, 0.874340>, <-0.944929, 0.203158, 0.846386> }
triangle { <-0.944929, 0.203158, 0.846386>, <-0.893713, 0.286960, 0.837592>, <-0.820838, 0.263561, 0.867146> }
triangle { <-0.893713, 0.286960, 0.837592>, <-0.944929, 0.203158, 0.846386>, <-1.016154, 0.218472, 0.816145> }
triangle { <-1.016154, 0.218472, 0.816145>, <-0.961078, 0.308590, 0.805620>, <-0.893713, 0.286960, 0.837592> }
triangle { <-0.961078, 0.308590, 0.805620>, <-1.016154, 0.218472, 0.816145>, <-1.081115, 0.232438, 0.783805> }
triangle { <-1.081115, 0.232438, 0.783805>, <-1.022517, 0.328318, 0.771428>, <-0.961078, 0.308590, 0.805620> }
triangle { <-1.022517, 0.328318, 0.771428>, <-1.081115, 0.232438, 0.783805>, <-1.139410, 0.244971, 0.749564> }
triangle { <-1.139410, 0.244971, 0.749564>, <-1.077652, 0.346021, 0.735227>, <-1.022517, 0.328318, 0.771428> }
triangle { <-1.077652, 0.346021, 0.735227>, <-1.139410, 0.244971, 0.749564>, <-1.190680, 0.255994, 0.713633> }
triangle { <-1.190680, 0.255994, 0.713633>, <-1.126144, 0.361591, 0.697240>, <-1.077652, 0.346021, 0.735227> }
triangle { <-1.126144, 0.361591, 0.697240>, <-1.190680, 0.255994, 0.713633>, <-1.234609, 0.265439, 0.676235> }
triangle { <-1.234609, 0.265439, 0.676235>, <-1.167692, 0.374932, 0.657700>, <-1.126144, 0.361591, 0.697240> }
triangle { <-1.167692, 0.374932, 0.657700>, <-1.234609, 0.265439, 0.676235>, <-1.270927, 0.273247, 0.637599> }
triangle { <-1.270927, 0.273247, 0.637599>, <-1.202041, 0.385961, 0.616852>, <-1.167692, 0.374932, 0.657700> }
triangle { <-1.202041, 0.385961, 0.616852>, <-1.270927, 0.273247, 0.637599>, <-1.299408, 0.279371, 0.597964> }
triangle { <-1.299408, 0.279371, 0.597964>, <-1.228979, 0.394610, 0.574948>, <-1.202041, 0.385961, 0.616852> }
triangle { <-1.228979, 0.394610, 0.574948>, <-1.299408, 0.279371, 0.597964>, <-1.319879, 0.283772, 0.557574> }
triangle { <-1.319879, 0.283772, 0.557574>, <-1.248340, 0.400827, 0.532246>, <-1.228979, 0.394610, 0.574948> }
triangle { <-1.248340, 0.400827, 0.532246>, <-1.319879, 0.283772, 0.557574>, <-1.332212, 0.286424, 0.516678> }
triangle { <-1.332212, 0.286424, 0.516678>, <-1.260004, 0.404572, 0.489009>, <-1.248340, 0.400827, 0.532246> }
triangle { <-1.260004, 0.404572, 0.489009>, <-1.332212, 0.286424, 0.516678>, <-1.336331, 0.287309, 0.475528> }
triangle { <-1.336331, 0.287309, 0.475528>, <-1.263901, 0.405823, 0.445503>, <-1.260004, 0.404572, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.108555, 0.011688, 0.998440> }
triangle { <-0.108555, 0.011688, 0.998440>, <-0.104847, 0.022542, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.104847, 0.022542, 0.998383>, <-0.108555, 0.011688, 0.998440>, <-0.216441, 0.023305, 0.993768> }
triangle { <-0.216441, 0.023305, 0.993768>, <-0.209048, 0.044945, 0.993543>, <-0.104847, 0.022542, 0.998383> }
triangle { <-0.209048, 0.044945, 0.993543>, <-0.216441, 0.023305, 0.993768>, <-0.322992, 0.034777, 0.986015> }
triangle { <-0.322992, 0.034777, 0.986015>, <-0.311960, 0.067071, 0.985509>, <-0.209048, 0.044945, 0.993543> }
triangle { <-0.311960, 0.067071, 0.985509>, <-0.322992, 0.034777, 0.986015>, <-0.427552, 0.046035, 0.975227> }
triangle { <-0.427552, 0.046035, 0.975227>, <-0.412949, 0.088783, 0.974331>, <-0.311960, 0.067071, 0.985509> }
triangle { <-0.412949, 0.088783, 0.974331>, <-0.427552, 0.046035, 0.975227>, <-0.529476, 0.057010, 0.961471> }
triangle { <-0.529476, 0.057010, 0.961471>, <-0.511392, 0.109949, 0.960077>, <-0.412949, 0.088783, 0.974331> }
triangle { <-0.511392, 0.109949, 0.960077>, <-0.529476, 0.057010, 0.961471>, <-0.628136, 0.067633, 0.944832> }
triangle { <-0.628136, 0.067633, 0.944832>, <-0.606682, 0.130436, 0.942836>, <-0.511392, 0.109949, 0.960077> }
triangle { <-0.606682, 0.130436, 0.942836>, <-0.628136, 0.067633, 0.944832>, <-0.722922, 0.077838, 0.925413> }
triangle { <-0.722922, 0.077838, 0.925413>, <-0.698231, 0.150119, 0.922714>, <-0.606682, 0.130436, 0.942836> }
triangle { <-0.698231, 0.150119, 0.922714>, <-0.722922, 0.077838, 0.925413>, <-0.813252, 0.087564, 0.903333> }
triangle { <-0.813252, 0.087564, 0.903333>, <-0.785476, 0.168876, 0.899835>, <-0.698231, 0.150119, 0.922714> }
triangle { <-0.785476, 0.168876, 0.899835>, <-0.813252, 0.087564, 0.903333>, <-0.898568, 0.096751, 0.878728> }
triangle { <-0.898568, 0.096751, 0.878728>, <-0.867878, 0.186592, 0.874340>, <-0.785476, 0.168876, 0.899835> }
triangle { <-0.867878, 0.186592, 0.874340>, <-0.898568, 0.096751, 0.878728>, <-0.978344, 0.105340, 0.851750> }
triangle { <-0.978344, 0.105340, 0.851750>, <-0.944929, 0.203158, 0.846386>, <-0.867878, 0.186592, 0.874340> }
triangle { <-0.944929, 0.203158, 0.846386>, <-0.978344, 0.105340, 0.851750>, <-1.052088, 0.113280, 0.822566> }
triangle { <-1.052088, 0.113280, 0.822566>, <-1.016154, 0.218472, 0.816145>, <-0.944929, 0.203158, 0.846386> }
triangle { <-1.016154, 0.218472, 0.816145>, <-1.052088, 0.113280, 0.822566>, <-1.119346, 0.120522, 0.791355> }
triangle { <-1.119346, 0.120522, 0.791355>, <-1.081115, 0.232438, 0.783805>, <-1.016154, 0.218472, 0.816145> }
triangle { <-1.081115, 0.232438, 0.783805>, <-1.119346, 0.120522, 0.791355>, <-1.179702, 0.127021, 0.758310> }
triangle { <-1.179702, 0.127021, 0.758310>, <-1.139410, 0.244971, 0.749564>, <-1.081115, 0.232438, 0.783805> }
triangle { <-1.139410, 0.244971, 0.749564>, <-1.179702, 0.127021, 0.758310>, <-1.232785, 0.132736, 0.723634> }
triangle { <-1.232785, 0.132736, 0.723634>, <-1.190680, 0.255994, 0.713633>, <-1.139410, 0.244971, 0.749564> }
triangle { <-1.190680, 0.255994, 0.713633>, <-1.232785, 0.132736, 0.723634>, <-1.278268, 0.137634, 0.687542> }
triangle { <-1.278268, 0.137634, 0.687542>, <-1.234609, 0.265439, 0.676235>, <-1.190680, 0.255994, 0.713633> }
triangle { <-1.234609, 0.265439, 0.676235>, <-1.278268, 0.137634, 0.687542>, <-1.315870, 0.141682, 0.650255> }
triangle { <-1.315870, 0.141682, 0.650255>, <-1.270927, 0.273247, 0.637599>, <-1.234609, 0.265439, 0.676235> }
triangle { <-1.270927, 0.273247, 0.637599>, <-1.315870, 0.141682, 0.650255>, <-1.345359, 0.144857, 0.612004> }
triangle { <-1.345359, 0.144857, 0.612004>, <-1.299408, 0.279371, 0.597964>, <-1.270927, 0.273247, 0.637599> }
triangle { <-1.299408, 0.279371, 0.597964>, <-1.345359, 0.144857, 0.612004>, <-1.366553, 0.147139, 0.573024> }
triangle { <-1.366553, 0.147139, 0.573024>, <-1.319879, 0.283772, 0.557574>, <-1.299408, 0.279371, 0.597964> }
triangle { <-1.319879, 0.283772, 0.557574>, <-1.366553, 0.147139, 0.573024>, <-1.379322, 0.148514, 0.533557> }
triangle { <-1.379322, 0.148514, 0.533557>, <-1.332212, 0.286424, 0.516678>, <-1.319879, 0.283772, 0.557574> }
triangle { <-1.332212, 0.286424, 0.516678>, <-1.379322, 0.148514, 0.533557>, <-1.383587, 0.148974, 0.493844> }
triangle { <-1.383587, 0.148974, 0.493844>, <-1.336331, 0.287309, 0.475528>, <-1.332212, 0.286424, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.109843, -0.000000, 0.998459> }
triangle { <-0.109843, -0.000000, 0.998459>, <-0.108555, 0.011688, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.108555, 0.011688, 0.998440>, <-0.109843, -0.000000, 0.998459>, <-0.219008, -0.000000, 0.993844> }
triangle { <-0.219008, -0.000000, 0.993844>, <-0.216441, 0.023305, 0.993768>, <-0.108555, 0.011688, 0.998440> }
triangle { <-0.216441, 0.023305, 0.993768>, <-0.219008, -0.000000, 0.993844>, <-0.326824, -0.000000, 0.986185> }
triangle { <-0.326824, -0.000000, 0.986185>, <-0.322992, 0.034777, 0.986015>, <-0.216441, 0.023305, 0.993768> }
triangle { <-0.322992, 0.034777, 0.986015>, <-0.326824, -0.000000, 0.986185>, <-0.432624, -0.000000, 0.975528> }
triangle { <-0.432624, -0.000000, 0.975528>, <-0.427552, 0.046035, 0.975227>, <-0.322992, 0.034777, 0.986015> }
triangle { <-0.427552, 0.046035, 0.975227>, <-0.432624, -0.000000, 0.975528>, <-0.535757, -0.000000, 0.961940> }
triangle { <-0.535757, -0.000000, 0.961940>, <-0.529476, 0.057010, 0.961471>, <-0.427552, 0.046035, 0.975227> }
triangle { <-0.529476, 0.057010, 0.961471>, <-0.535757, -0.000000, 0.961940>, <-0.635587, -0.000000, 0.945503> }
triangle { <-0.635587, -0.000000, 0.945503>, <-0.628136, 0.067633, 0.944832>, <-0.529476, 0.057010, 0.961471> }
triangle { <-0.628136, 0.067633, 0.944832>, <-0.635587, -0.000000, 0.945503>, <-0.731498, -0.000000, 0.926320> }
triangle { <-0.731498, -0.000000, 0.926320>, <-0.722922, 0.077838, 0.925413>, <-0.628136, 0.067633, 0.944832> }
triangle { <-0.722922, 0.077838, 0.925413>, <-0.731498, -0.000000, 0.926320>, <-0.822899, -0.000000, 0.904508> }
triangle { <-0.822899, -0.000000, 0.904508>, <-0.813252, 0.087564, 0.903333>, <-0.722922, 0.077838, 0.925413> }
triangle { <-0.813252, 0.087564, 0.903333>, <-0.822899, -0.000000, 0.904508>, <-0.909227, -0.000000, 0.880203> }
triangle { <-0.909227, -0.000000, 0.880203>, <-0.898568, 0.096751, 0.878728>, <-0.813252, 0.087564, 0.903333> }
triangle { <-0.898568, 0.096751, 0.878728>, <-0.909227, -0.000000, 0.880203>, <-0.989949, -0.000000, 0.853553> }
triangle { <-0.989949, -0.000000, 0.853553>, <-0.978344, 0.105340, 0.851750>, <-0.898568, 0.096751, 0.878728> }
triangle { <-0.978344, 0.105340, 0.851750>, <-0.989949, -0.000000, 0.853553>, <-1.064568, -0.000000, 0.824724> }
triangle { <-1.064568, -0.000000, 0.824724>, <-1.052088, 0.113280, 0.822566>, <-0.978344, 0.105340, 0.851750> }
triangle { <-1.052088, 0.113280, 0.822566>, <-1.064568, -0.000000, 0.824724>, <-1.132624, -0.000000, 0.793893> }
triangle { <-1.132624, -0.000000, 0.793893>, <-1.119346, 0.120522, 0.791355>, <-1.052088, 0.113280, 0.822566> }
triangle { <-1.119346, 0.120522, 0.791355>, <-1.132624, -0.000000, 0.793893>, <-1.193696, -0.000000, 0.761249> }
triangle { <-1.193696, -0.000000, 0.761249>, <-1.179702, 0.127021, 0.758310>, <-1.119346, 0.120522, 0.791355> }
triangle { <-1.179702, 0.127021, 0.758310>, <-1.193696, -0.000000, 0.761249>, <-1.247409, -0.000000, 0.726995> }
triangle { <-1.247409, -0.000000, 0.726995>, <-1.232785, 0.132736, 0.723634>, <-1.179702, 0.127021, 0.758310> }
triangle { <-1.232785, 0.132736, 0.723634>, <-1.247409, -0.000000, 0.726995>, <-1.293431, -0.000000, 0.691342> }
triangle { <-1.293431, -0.000000, 0.691342>, <-1.278268, 0.137634, 0.687542>, <-1.232785, 0.132736, 0.723634> }
triangle { <-1.278268, 0.137634, 0.687542>, <-1.293431, -0.000000, 0.691342>, <-1.331479, -0.000000, 0.654508> }
triangle { <-1.331479, -0.000000, 0.654508>, <-1.315870, 0.141682, 0.650255>, <-1.278268, 0.137634, 0.687542> }
triangle { <-1.315870, 0.141682, 0.650255>, <-1.331479, -0.000000, 0.654508>, <-1.361318, -0.000000, 0.616723> }
triangle { <-1.361318, -0.000000, 0.616723>, <-1.345359, 0.144857, 0.612004>, <-1.315870, 0.141682, 0.650255> }
triangle { <-1.345359, 0.144857, 0.612004>, <-1.361318, -0.000000, 0.616723>, <-1.382764, -0.000000, 0.578217> }
triangle { <-1.382764, -0.000000, 0.578217>, <-1.366553, 0.147139, 0.573024>, <-1.345359, 0.144857, 0.612004> }
triangle { <-1.366553, 0.147139, 0.573024>, <-1.382764, -0.000000, 0.578217>, <-1.395684, -0.000000, 0.539230> }
triangle { <-1.395684, -0.000000, 0.539230>, <-1.379322, 0.148514, 0.533557>, <-1.366553, 0.147139, 0.573024> }
triangle { <-1.379322, 0.148514, 0.533557>, <-1.395684, -0.000000, 0.539230>, <-1.400000, -0.000000, 0.500000> }
triangle { <-1.400000, -0.000000, 0.500000>, <-1.383587, 0.148974, 0.493844>, <-1.379322, 0.148514, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.108555, -0.011688, 0.998440> }
triangle { <-0.108555, -0.011688, 0.998440>, <-0.109843, -0.000000, 0.998459>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.109843, -0.000000, 0.998459>, <-0.108555, -0.011688, 0.998440>, <-0.216441, -0.023305, 0.993768> }
triangle { <-0.216441, -0.023305, 0.993768>, <-0.219008, -0.000000, 0.993844>, <-0.109843, -0.000000, 0.998459> }
triangle { <-0.219008, -0.000000, 0.993844>, <-0.216441, -0.023305, 0.993768>, <-0.322992, -0.034777, 0.986015> }
triangle { <-0.322992, -0.034777, 0.986015>, <-0.326824, -0.000000, 0.986185>, <-0.219008, -0.000000, 0.993844> }
triangle { <-0.326824, -0.000000, 0.986185>, <-0.322992, -0.034777, 0.986015>, <-0.427552, -0.046035, 0.975227> }
triangle { <-0.427552, -0.046035, 0.975227>, <-0.432624, -0.000000, 0.975528>, <-0.326824, -0.000000, 0.986185> }
triangle { <-0.432624, -0.000000, 0.975528>, <-0.427552, -0.046035, 0.975227>, <-0.529476, -0.057010, 0.961471> }
triangle { <-0.529476, -0.057010, 0.961471>, <-0.535757, -0.000000, 0.961940>, <-0.432624, -0.000000, 0.975528> }
triangle { <-0.535757, -0.000000, 0.961940>, <-0.529476, -0.057010, 0.961471>, <-0.628136, -0.067633, 0.944832> }
triangle { <-0.628136, -0.067633, 0.944832>, <-0.635587, -0.000000, 0.945503>, <-0.535757, -0.000000, 0.961940> }
triangle { <-0.635587, -0.000000, 0.945503>, <-0.628136, -0.067633, 0.944832>, <-0.722922, -0.077838, 0.925413> }
triangle { <-0.722922, -0.077838, 0.925413>, <-0.731498, -0.000000, 0.926320>, <-0.635587, -0.000000, 0.945503> }
triangle { <-0.731498, -0.000000, 0.926320>, <-0.722922, -0.077838, 0.925413>, <-0.813252, -0.087564, 0.903333> }
triangle { <-0.813252, -0.087564, 0.903333>, <-0.822899, -0.000000, 0.904508>, <-0.731498, -0.000000, 0.926320> }
triangle { <-0.822899, -0.000000, 0.904508>, <-0.813252, -0.087564, 0.903333>, <-0.898568, -0.096751, 0.878728> }
triangle { <-0.898568, -0.096751, 0.878728>, <-0.909227, -0.000000, 0.880203>, <-0.822899, -0.000000, 0.904508> }
triangle { <-0.909227, -0.000000, 0.880203>, <-0.898568, -0.096751, 0.878728>, <-0.978344, -0.105340, 0.851750> }
triangle { <-0.978344, -0.105340, 0.851750>, <-0.989949, -0.000000, 0.853553>, <-0.909227, -0.000000, 0.880203> }
triangle { <-0.989949, -0.000000, 0.853553>, <-0.978344, -0.105340, 0.851750>, <-1.052088, -0.113280, 0.822566> }
triangle { <-1.052088, -0.113280, 0.822566>, <-1.064568, -0.000000, 0.824724>, <-0.989949, -0.000000, 0.853553> }
triangle { <-1.064568, -0.000000, 0.824724>, <-1.052088, -0.113280, 0.822566>, <-1.119346, -0.120522, 0.791355> }
triangle { <-1.119346, -0.120522, 0.791355>, <-1.132624, -0.000000, 0.793893>, <-1.064568, -0.000000, 0.824724> }
triangle { <-1.132624, -0.000000, 0.793893>, <-1.119346, -0.120522, 0.791355>, <-1.179702, -0.127021, 0.758310> }
triangle { <-1.179702, -0.127021, 0.758310>, <-1.193696, -0.000000, 0.761249>, <-1.132624, -0.000000, 0.793893> }
triangle { <-1.193696, -0.000000, 0.761249>, <-1.179702, -0.127021, 0.758310>, <-1.232785, -0.132736, 0.723634> }
triangle { <-1.232785, -0.132736, 0.723634>, <-1.247409, -0.000000, 0.726995>, <-1.193696, -0.000000, 0.761249> }
triangle { <-1.247409, -0.000000, 0.726995>, <-1.232785, -0.132736, 0.723634>, <-1.278268, -0.137634, 0.687542> }
triangle { <-1.278268, -0.137634, 0.687542>, <-1.293431, -0.000000, 0.691342>, <-1.247409, -0.000000, 0.726995> }
triangle { <-1.293431, -0.000000, 0.691342>, <-1.278268, -0.137634, 0.687542>, <-1.315870, -0.141682, 0.650255> }
triangle { <-1.315870, -0.141682, 0.650255>, <-1.331479, -0.000000, 0.654508>, <-1.293431, -0.000000, 0.691342> }
triangle { <-1.331479, -0.000000, 0.654508>, <-1.315870, -0.141682, 0.650255>, <-1.345359, -0.144857, 0.612004> }
triangle { <-1.345359, -0.144857, 0.612004>, <-1.361318, -0.000000, 0.616723>, <-1.331479, -0.000000, 0.654508> }
triangle { <-1.361318, -0.000000, 0.616723>, <-1.345359, -0.144857, 0.612004>, <-1.366553, -0.147139, 0.573024> }
triangle { <-1.366553, -0.147139, 0.573024>, <-1.382764, -0.000000, 0.578217>, <-1.361318, -0.000000, 0.616723> }
triangle { <-1.382764, -0.000000, 0.578217>, <-1.366553, -0.147139, 0.573024>, <-1.379322, -0.148514, 0.533557> }
triangle { <-1.379322, -0.148514, 0.533557>, <-1.395684, -0.000000, 0.539230>, <-1.382764, -0.000000, 0.578217> }
triangle { <-1.395684, -0.000000, 0.539230>, <-1.379322, -0.148514, 0.533557>, <-1.383587, -0.148974, 0.493844> }
triangle { <-1.383587, -0.148974, 0.493844>, <-1.400000, -0.000000, 0.500000>, <-1.395684, -0.000000, 0.539230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.104847, -0.022542, 0.998383> }
triangle { <-0.104847, -0.022542, 0.998383>, <-0.108555, -0.011688, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.108555, -0.011688, 0.998440>, <-0.104847, -0.022542, 0.998383>, <-0.209048, -0.044945, 0.993543> }
triangle { <-0.209048, -0.044945, 0.993543>, <-0.216441, -0.023305, 0.993768>, <-0.108555, -0.011688, 0.998440> }
triangle { <-0.216441, -0.023305, 0.993768>, <-0.209048, -0.044945, 0.993543>, <-0.311960, -0.067071, 0.985509> }
triangle { <-0.311960, -0.067071, 0.985509>, <-0.322992, -0.034777, 0.986015>, <-0.216441, -0.023305, 0.993768> }
triangle { <-0.322992, -0.034777, 0.986015>, <-0.311960, -0.067071, 0.985509>, <-0.412949, -0.088783, 0.974331> }
triangle { <-0.412949, -0.088783, 0.974331>, <-0.427552, -0.046035, 0.975227>, <-0.322992, -0.034777, 0.986015> }
triangle { <-0.427552, -0.046035, 0.975227>, <-0.412949, -0.088783, 0.974331>, <-0.511392, -0.109949, 0.960077> }
triangle { <-0.511392, -0.109949, 0.960077>, <-0.529476, -0.057010, 0.961471>, <-0.427552, -0.046035, 0.975227> }
triangle { <-0.529476, -0.057010, 0.961471>, <-0.511392, -0.109949, 0.960077>, <-0.606682, -0.130436, 0.942836> }
triangle { <-0.606682, -0.130436, 0.942836>, <-0.628136, -0.067633, 0.944832>, <-0.529476, -0.057010, 0.961471> }
triangle { <-0.628136, -0.067633, 0.944832>, <-0.606682, -0.130436, 0.942836>, <-0.698231, -0.150119, 0.922714> }
triangle { <-0.698231, -0.150119, 0.922714>, <-0.722922, -0.077838, 0.925413>, <-0.628136, -0.067633, 0.944832> }
triangle { <-0.722922, -0.077838, 0.925413>, <-0.698231, -0.150119, 0.922714>, <-0.785476, -0.168876, 0.899835> }
triangle { <-0.785476, -0.168876, 0.899835>, <-0.813252, -0.087564, 0.903333>, <-0.722922, -0.077838, 0.925413> }
triangle { <-0.813252, -0.087564, 0.903333>, <-0.785476, -0.168876, 0.899835>, <-0.867878, -0.186592, 0.874340> }
triangle { <-0.867878, -0.186592, 0.874340>, <-0.898568, -0.096751, 0.878728>, <-0.813252, -0.087564, 0.903333> }
triangle { <-0.898568, -0.096751, 0.878728>, <-0.867878, -0.186592, 0.874340>, <-0.944929, -0.203158, 0.846386> }
triangle { <-0.944929, -0.203158, 0.846386>, <-0.978344, -0.105340, 0.851750>, <-0.898568, -0.096751, 0.878728> }
triangle { <-0.978344, -0.105340, 0.851750>, <-0.944929, -0.203158, 0.846386>, <-1.016154, -0.218472, 0.816145> }
triangle { <-1.016154, -0.218472, 0.816145>, <-1.052088, -0.113280, 0.822566>, <-0.978344, -0.105340, 0.851750> }
triangle { <-1.052088, -0.113280, 0.822566>, <-1.016154, -0.218472, 0.816145>, <-1.081115, -0.232438, 0.783805> }
triangle { <-1.081115, -0.232438, 0.783805>, <-1.119346, -0.120522, 0.791355>, <-1.052088, -0.113280, 0.822566> }
triangle { <-1.119346, -0.120522, 0.791355>, <-1.081115, -0.232438, 0.783805>, <-1.139410, -0.244971, 0.749564> }
triangle { <-1.139410, -0.244971, 0.749564>, <-1.179702, -0.127021, 0.758310>, <-1.119346, -0.120522, 0.791355> }
triangle { <-1.179702, -0.127021, 0.758310>, <-1.139410, -0.244971, 0.749564>, <-1.190680, -0.255994, 0.713633> }
triangle { <-1.190680, -0.255994, 0.713633>, <-1.232785, -0.132736, 0.723634>, <-1.179702, -0.127021, 0.758310> }
triangle { <-1.232785, -0.132736, 0.723634>, <-1.190680, -0.255994, 0.713633>, <-1.234609, -0.265439, 0.676235> }
triangle { <-1.234609, -0.265439, 0.676235>, <-1.278268, -0.137634, 0.687542>, <-1.232785, -0.132736, 0.723634> }
triangle { <-1.278268, -0.137634, 0.687542>, <-1.234609, -0.265439, 0.676235>, <-1.270927, -0.273247, 0.637599> }
triangle { <-1.270927, -0.273247, 0.637599>, <-1.315870, -0.141682, 0.650255>, <-1.278268, -0.137634, 0.687542> }
triangle { <-1.315870, -0.141682, 0.650255>, <-1.270927, -0.273247, 0.637599>, <-1.299408, -0.279371, 0.597964> }
triangle { <-1.299408, -0.279371, 0.597964>, <-1.345359, -0.144857, 0.612004>, <-1.315870, -0.141682, 0.650255> }
triangle { <-1.345359, -0.144857, 0.612004>, <-1.299408, -0.279371, 0.597964>, <-1.319879, -0.283772, 0.557574> }
triangle { <-1.319879, -0.283772, 0.557574>, <-1.366553, -0.147139, 0.573024>, <-1.345359, -0.144857, 0.612004> }
triangle { <-1.366553, -0.147139, 0.573024>, <-1.319879, -0.283772, 0.557574>, <-1.332212, -0.286424, 0.516678> }
triangle { <-1.332212, -0.286424, 0.516678>, <-1.379322, -0.148514, 0.533557>, <-1.366553, -0.147139, 0.573024> }
triangle { <-1.379322, -0.148514, 0.533557>, <-1.332212, -0.286424, 0.516678>, <-1.336331, -0.287309, 0.475528> }
triangle { <-1.336331, -0.287309, 0.475528>, <-1.383587, -0.148974, 0.493844>, <-1.379322, -0.148514, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.099164, -0.031841, 0.998291> }
triangle { <-0.099164, -0.031841, 0.998291>, <-0.104847, -0.022542, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.104847, -0.022542, 0.998383>, <-0.099164, -0.031841, 0.998291>, <-0.197718, -0.063485, 0.993173> }
triangle { <-0.197718, -0.063485, 0.993173>, <-0.209048, -0.044945, 0.993543>, <-0.104847, -0.022542, 0.998383> }
triangle { <-0.209048, -0.044945, 0.993543>, <-0.197718, -0.063485, 0.993173>, <-0.295052, -0.094737, 0.984679> }
triangle { <-0.295052, -0.094737, 0.984679>, <-0.311960, -0.067071, 0.985509>, <-0.209048, -0.044945, 0.993543> }
triangle { <-0.311960, -0.067071, 0.985509>, <-0.295052, -0.094737, 0.984679>, <-0.390567, -0.125406, 0.972861> }
triangle { <-0.390567, -0.125406, 0.972861>, <-0.412949, -0.088783, 0.974331>, <-0.311960, -0.067071, 0.985509> }
triangle { <-0.412949, -0.088783, 0.974331>, <-0.390567, -0.125406, 0.972861>, <-0.483674, -0.155302, 0.957791> }
triangle { <-0.483674, -0.155302, 0.957791>, <-0.511392, -0.109949, 0.960077>, <-0.412949, -0.088783, 0.974331> }
triangle { <-0.511392, -0.109949, 0.960077>, <-0.483674, -0.155302, 0.957791>, <-0.573799, -0.184240, 0.939563> }
triangle { <-0.573799, -0.184240, 0.939563>, <-0.606682, -0.130436, 0.942836>, <-0.511392, -0.109949, 0.960077> }
triangle { <-0.606682, -0.130436, 0.942836>, <-0.573799, -0.184240, 0.939563>, <-0.660386, -0.212042, 0.918289> }
triangle { <-0.660386, -0.212042, 0.918289>, <-0.698231, -0.150119, 0.922714>, <-0.606682, -0.130436, 0.942836> }
triangle { <-0.698231, -0.150119, 0.922714>, <-0.660386, -0.212042, 0.918289>, <-0.742902, -0.238537, 0.894101> }
triangle { <-0.742902, -0.238537, 0.894101>, <-0.785476, -0.168876, 0.899835>, <-0.698231, -0.150119, 0.922714> }
triangle { <-0.785476, -0.168876, 0.899835>, <-0.742902, -0.238537, 0.894101>, <-0.820838, -0.263561, 0.867146> }
triangle { <-0.820838, -0.263561, 0.867146>, <-0.867878, -0.186592, 0.874340>, <-0.785476, -0.168876, 0.899835> }
triangle { <-0.867878, -0.186592, 0.874340>, <-0.820838, -0.263561, 0.867146>, <-0.893713, -0.286960, 0.837592> }
triangle { <-0.893713, -0.286960, 0.837592>, <-0.944929, -0.203158, 0.846386>, <-0.867878, -0.186592, 0.874340> }
triangle { <-0.944929, -0.203158, 0.846386>, <-0.893713, -0.286960, 0.837592>, <-0.961078, -0.308590, 0.805620> }
triangle { <-0.961078, -0.308590, 0.805620>, <-1.016154, -0.218472, 0.816145>, <-0.944929, -0.203158, 0.846386> }
triangle { <-1.016154, -0.218472, 0.816145>, <-0.961078, -0.308590, 0.805620>, <-1.022517, -0.328318, 0.771428> }
triangle { <-1.022517, -0.328318, 0.771428>, <-1.081115, -0.232438, 0.783805>, <-1.016154, -0.218472, 0.816145> }
triangle { <-1.081115, -0.232438, 0.783805>, <-1.022517, -0.328318, 0.771428>, <-1.077652, -0.346021, 0.735227> }
triangle { <-1.077652, -0.346021, 0.735227>, <-1.139410, -0.244971, 0.749564>, <-1.081115, -0.232438, 0.783805> }
triangle { <-1.139410, -0.244971, 0.749564>, <-1.077652, -0.346021, 0.735227>, <-1.126144, -0.361591, 0.697240> }
triangle { <-1.126144, -0.361591, 0.697240>, <-1.190680, -0.255994, 0.713633>, <-1.139410, -0.244971, 0.749564> }
triangle { <-1.190680, -0.255994, 0.713633>, <-1.126144, -0.361591, 0.697240>, <-1.167692, -0.374932, 0.657700> }
triangle { <-1.167692, -0.374932, 0.657700>, <-1.234609, -0.265439, 0.676235>, <-1.190680, -0.255994, 0.713633> }
triangle { <-1.234609, -0.265439, 0.676235>, <-1.167692, -0.374932, 0.657700>, <-1.202041, -0.385961, 0.616852> }
triangle { <-1.202041, -0.385961, 0.616852>, <-1.270927, -0.273247, 0.637599>, <-1.234609, -0.265439, 0.676235> }
triangle { <-1.270927, -0.273247, 0.637599>, <-1.202041, -0.385961, 0.616852>, <-1.228979, -0.394610, 0.574948> }
triangle { <-1.228979, -0.394610, 0.574948>, <-1.299408, -0.279371, 0.597964>, <-1.270927, -0.273247, 0.637599> }
triangle { <-1.299408, -0.279371, 0.597964>, <-1.228979, -0.394610, 0.574948>, <-1.248340, -0.400827, 0.532246> }
triangle { <-1.248340, -0.400827, 0.532246>, <-1.319879, -0.283772, 0.557574>, <-1.299408, -0.279371, 0.597964> }
triangle { <-1.319879, -0.283772, 0.557574>, <-1.248340, -0.400827, 0.532246>, <-1.260004, -0.404572, 0.489009> }
triangle { <-1.260004, -0.404572, 0.489009>, <-1.332212, -0.286424, 0.516678>, <-1.319879, -0.283772, 0.557574> }
triangle { <-1.332212, -0.286424, 0.516678>, <-1.260004, -0.404572, 0.489009>, <-1.263901, -0.405823, 0.445503> }
triangle { <-1.263901, -0.405823, 0.445503>, <-1.336331, -0.287309, 0.475528>, <-1.332212, -0.286424, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.092178, -0.039075, 0.998164> }
triangle { <-0.092178, -0.039075, 0.998164>, <-0.099164, -0.031841, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.099164, -0.031841, 0.998291>, <-0.092178, -0.039075, 0.998164>, <-0.183788, -0.077910, 0.992669> }
triangle { <-0.183788, -0.077910, 0.992669>, <-0.197718, -0.063485, 0.993173>, <-0.099164, -0.031841, 0.998291> }
triangle { <-0.197718, -0.063485, 0.993173>, <-0.183788, -0.077910, 0.992669>, <-0.274265, -0.116264, 0.983547> }
triangle { <-0.274265, -0.116264, 0.983547>, <-0.295052, -0.094737, 0.984679>, <-0.197718, -0.063485, 0.993173> }
triangle { <-0.295052, -0.094737, 0.984679>, <-0.274265, -0.116264, 0.983547>, <-0.363051, -0.153901, 0.970855> }
triangle { <-0.363051, -0.153901, 0.970855>, <-0.390567, -0.125406, 0.972861>, <-0.295052, -0.094737, 0.984679> }
triangle { <-0.390567, -0.125406, 0.972861>, <-0.363051, -0.153901, 0.970855>, <-0.449599, -0.190589, 0.954671> }
triangle { <-0.449599, -0.190589, 0.954671>, <-0.483674, -0.155302, 0.957791>, <-0.390567, -0.125406, 0.972861> }
triangle { <-0.483674, -0.155302, 0.957791>, <-0.449599, -0.190589, 0.954671>, <-0.533374, -0.226102, 0.935095> }
triangle { <-0.533374, -0.226102, 0.935095>, <-0.573799, -0.184240, 0.939563>, <-0.483674, -0.155302, 0.957791> }
triangle { <-0.573799, -0.184240, 0.939563>, <-0.533374, -0.226102, 0.935095>, <-0.613862, -0.260222, 0.912248> }
triangle { <-0.613862, -0.260222, 0.912248>, <-0.660386, -0.212042, 0.918289>, <-0.573799, -0.184240, 0.939563> }
triangle { <-0.660386, -0.212042, 0.918289>, <-0.613862, -0.260222, 0.912248>, <-0.690564, -0.292737, 0.886271> }
triangle { <-0.690564, -0.292737, 0.886271>, <-0.742902, -0.238537, 0.894101>, <-0.660386, -0.212042, 0.918289> }
triangle { <-0.742902, -0.238537, 0.894101>, <-0.690564, -0.292737, 0.886271>, <-0.763009, -0.323447, 0.857324> }
triangle { <-0.763009, -0.323447, 0.857324>, <-0.820838, -0.263561, 0.867146>, <-0.742902, -0.238537, 0.894101> }
triangle { <-0.820838, -0.263561, 0.867146>, <-0.763009, -0.323447, 0.857324>, <-0.830750, -0.352163, 0.825585> }
triangle { <-0.830750, -0.352163, 0.825585>, <-0.893713, -0.286960, 0.837592>, <-0.820838, -0.263561, 0.867146> }
triangle { <-0.893713, -0.286960, 0.837592>, <-0.830750, -0.352163, 0.825585>, <-0.893369, -0.378707, 0.791249> }
triangle { <-0.893369, -0.378707, 0.791249>, <-0.961078, -0.308590, 0.805620>, <-0.893713, -0.286960, 0.837592> }
triangle { <-0.961078, -0.308590, 0.805620>, <-0.893369, -0.378707, 0.791249>, <-0.950480, -0.402917, 0.754530> }
triangle { <-0.950480, -0.402917, 0.754530>, <-1.022517, -0.328318, 0.771428>, <-0.961078, -0.308590, 0.805620> }
triangle { <-1.022517, -0.328318, 0.771428>, <-0.950480, -0.402917, 0.754530>, <-1.001731, -0.424643, 0.715652> }
triangle { <-1.001731, -0.424643, 0.715652>, <-1.077652, -0.346021, 0.735227>, <-1.022517, -0.328318, 0.771428> }
triangle { <-1.077652, -0.346021, 0.735227>, <-1.001731, -0.424643, 0.715652>, <-1.046806, -0.443751, 0.674856> }
triangle { <-1.046806, -0.443751, 0.674856>, <-1.126144, -0.361591, 0.697240>, <-1.077652, -0.346021, 0.735227> }
triangle { <-1.126144, -0.361591, 0.697240>, <-1.046806, -0.443751, 0.674856>, <-1.085427, -0.460123, 0.632393> }
triangle { <-1.085427, -0.460123, 0.632393>, <-1.167692, -0.374932, 0.657700>, <-1.126144, -0.361591, 0.697240> }
triangle { <-1.167692, -0.374932, 0.657700>, <-1.085427, -0.460123, 0.632393>, <-1.117356, -0.473658, 0.588525> }
triangle { <-1.117356, -0.473658, 0.588525>, <-1.202041, -0.385961, 0.616852>, <-1.167692, -0.374932, 0.657700> }
triangle { <-1.202041, -0.385961, 0.616852>, <-1.117356, -0.473658, 0.588525>, <-1.142396, -0.484273, 0.543523> }
triangle { <-1.142396, -0.484273, 0.543523>, <-1.228979, -0.394610, 0.574948>, <-1.202041, -0.385961, 0.616852> }
triangle { <-1.228979, -0.394610, 0.574948>, <-1.142396, -0.484273, 0.543523>, <-1.160393, -0.491902, 0.497664> }
triangle { <-1.160393, -0.491902, 0.497664>, <-1.248340, -0.400827, 0.532246>, <-1.228979, -0.394610, 0.574948> }
triangle { <-1.248340, -0.400827, 0.532246>, <-1.160393, -0.491902, 0.497664>, <-1.171236, -0.496498, 0.451230> }
triangle { <-1.171236, -0.496498, 0.451230>, <-1.260004, -0.404572, 0.489009>, <-1.248340, -0.400827, 0.532246> }
triangle { <-1.260004, -0.404572, 0.489009>, <-1.171236, -0.496498, 0.451230>, <-1.174858, -0.498033, 0.404508> }
triangle { <-1.174858, -0.498033, 0.404508>, <-1.263901, -0.405823, 0.445503>, <-1.260004, -0.404572, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.084694, -0.044018, 0.998007> }
triangle { <-0.084694, -0.044018, 0.998007>, <-0.092178, -0.039075, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.092178, -0.039075, 0.998164>, <-0.084694, -0.044018, 0.998007>, <-0.168865, -0.087765, 0.992041> }
triangle { <-0.168865, -0.087765, 0.992041>, <-0.183788, -0.077910, 0.992669>, <-0.092178, -0.039075, 0.998164> }
triangle { <-0.183788, -0.077910, 0.992669>, <-0.168865, -0.087765, 0.992041>, <-0.251996, -0.130970, 0.982139> }
triangle { <-0.251996, -0.130970, 0.982139>, <-0.274265, -0.116264, 0.983547>, <-0.183788, -0.077910, 0.992669> }
triangle { <-0.274265, -0.116264, 0.983547>, <-0.251996, -0.130970, 0.982139>, <-0.333573, -0.173368, 0.968361> }
triangle { <-0.333573, -0.173368, 0.968361>, <-0.363051, -0.153901, 0.970855>, <-0.274265, -0.116264, 0.983547> }
triangle { <-0.363051, -0.153901, 0.970855>, <-0.333573, -0.173368, 0.968361>, <-0.413093, -0.214698, 0.950792> }
triangle { <-0.413093, -0.214698, 0.950792>, <-0.449599, -0.190589, 0.954671>, <-0.363051, -0.153901, 0.970855> }
triangle { <-0.449599, -0.190589, 0.954671>, <-0.413093, -0.214698, 0.950792>, <-0.490067, -0.254703, 0.929542> }
triangle { <-0.490067, -0.254703, 0.929542>, <-0.533374, -0.226102, 0.935095>, <-0.449599, -0.190589, 0.954671> }
triangle { <-0.533374, -0.226102, 0.935095>, <-0.490067, -0.254703, 0.929542>, <-0.564019, -0.293138, 0.904740> }
triangle { <-0.564019, -0.293138, 0.904740>, <-0.613862, -0.260222, 0.912248>, <-0.533374, -0.226102, 0.935095> }
triangle { <-0.613862, -0.260222, 0.912248>, <-0.564019, -0.293138, 0.904740>, <-0.634493, -0.329766, 0.876540> }
triangle { <-0.634493, -0.329766, 0.876540>, <-0.690564, -0.292737, 0.886271>, <-0.613862, -0.260222, 0.912248> }
triangle { <-0.690564, -0.292737, 0.886271>, <-0.634493, -0.329766, 0.876540>, <-0.701056, -0.364361, 0.845115> }
triangle { <-0.701056, -0.364361, 0.845115>, <-0.763009, -0.323447, 0.857324>, <-0.690564, -0.292737, 0.886271> }
triangle { <-0.763009, -0.323447, 0.857324>, <-0.701056, -0.364361, 0.845115>, <-0.763297, -0.396709, 0.810660> }
triangle { <-0.763297, -0.396709, 0.810660>, <-0.830750, -0.352163, 0.825585>, <-0.763009, -0.323447, 0.857324> }
triangle { <-0.830750, -0.352163, 0.825585>, <-0.763297, -0.396709, 0.810660>, <-0.820831, -0.426612, 0.773387> }
triangle { <-0.820831, -0.426612, 0.773387>, <-0.893369, -0.378707, 0.791249>, <-0.830750, -0.352163, 0.825585> }
triangle { <-0.893369, -0.378707, 0.791249>, <-0.820831, -0.426612, 0.773387>, <-0.873305, -0.453884, 0.733525> }
triangle { <-0.873305, -0.453884, 0.733525>, <-0.950480, -0.402917, 0.754530>, <-0.893369, -0.378707, 0.791249> }
triangle { <-0.950480, -0.402917, 0.754530>, <-0.873305, -0.453884, 0.733525>, <-0.920395, -0.478358, 0.691321> }
triangle { <-0.920395, -0.478358, 0.691321>, <-1.001731, -0.424643, 0.715652>, <-0.950480, -0.402917, 0.754530> }
triangle { <-1.001731, -0.424643, 0.715652>, <-0.920395, -0.478358, 0.691321>, <-0.961810, -0.499883, 0.647034> }
triangle { <-0.961810, -0.499883, 0.647034>, <-1.046806, -0.443751, 0.674856>, <-1.001731, -0.424643, 0.715652> }
triangle { <-1.046806, -0.443751, 0.674856>, <-0.961810, -0.499883, 0.647034>, <-0.997295, -0.518326, 0.600938> }
triangle { <-0.997295, -0.518326, 0.600938>, <-1.085427, -0.460123, 0.632393>, <-1.046806, -0.443751, 0.674856> }
triangle { <-1.085427, -0.460123, 0.632393>, <-0.997295, -0.518326, 0.600938>, <-1.026632, -0.533573, 0.553316> }
triangle { <-1.026632, -0.533573, 0.553316>, <-1.117356, -0.473658, 0.588525>, <-1.085427, -0.460123, 0.632393> }
triangle { <-1.117356, -0.473658, 0.588525>, <-1.026632, -0.533573, 0.553316>, <-1.049639, -0.545530, 0.504463> }
triangle { <-1.049639, -0.545530, 0.504463>, <-1.142396, -0.484273, 0.543523>, <-1.117356, -0.473658, 0.588525> }
triangle { <-1.142396, -0.484273, 0.543523>, <-1.049639, -0.545530, 0.504463>, <-1.066174, -0.554124, 0.454680> }
triangle { <-1.066174, -0.554124, 0.454680>, <-1.160393, -0.491902, 0.497664>, <-1.142396, -0.484273, 0.543523> }
triangle { <-1.160393, -0.491902, 0.497664>, <-1.066174, -0.554124, 0.454680>, <-1.076137, -0.559302, 0.404273> }
triangle { <-1.076137, -0.559302, 0.404273>, <-1.171236, -0.496498, 0.451230>, <-1.160393, -0.491902, 0.497664> }
triangle { <-1.171236, -0.496498, 0.451230>, <-1.076137, -0.559302, 0.404273>, <-1.079464, -0.561032, 0.353553> }
triangle { <-1.079464, -0.561032, 0.353553>, <-1.174858, -0.498033, 0.404508>, <-1.171236, -0.496498, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.077537, -0.046750, 0.997823> }
triangle { <-0.077537, -0.046750, 0.997823>, <-0.084694, -0.044018, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.084694, -0.044018, 0.998007>, <-0.077537, -0.046750, 0.997823>, <-0.154596, -0.093212, 0.991307> }
triangle { <-0.154596, -0.093212, 0.991307>, <-0.168865, -0.087765, 0.992041>, <-0.084694, -0.044018, 0.998007> }
triangle { <-0.168865, -0.087765, 0.992041>, <-0.154596, -0.093212, 0.991307>, <-0.230702, -0.139099, 0.980490> }
triangle { <-0.230702, -0.139099, 0.980490>, <-0.251996, -0.130970, 0.982139>, <-0.168865, -0.087765, 0.992041> }
triangle { <-0.251996, -0.130970, 0.982139>, <-0.230702, -0.139099, 0.980490>, <-0.305385, -0.184128, 0.965441> }
triangle { <-0.305385, -0.184128, 0.965441>, <-0.333573, -0.173368, 0.968361>, <-0.251996, -0.130970, 0.982139> }
triangle { <-0.333573, -0.173368, 0.968361>, <-0.305385, -0.184128, 0.965441>, <-0.378186, -0.228023, 0.946251> }
triangle { <-0.378186, -0.228023, 0.946251>, <-0.413093, -0.214698, 0.950792>, <-0.333573, -0.173368, 0.968361> }
triangle { <-0.413093, -0.214698, 0.950792>, <-0.378186, -0.228023, 0.946251>, <-0.448655, -0.270511, 0.923039> }
triangle { <-0.448655, -0.270511, 0.923039>, <-0.490067, -0.254703, 0.929542>, <-0.413093, -0.214698, 0.950792> }
triangle { <-0.490067, -0.254703, 0.929542>, <-0.448655, -0.270511, 0.923039>, <-0.516358, -0.311332, 0.895948> }
triangle { <-0.516358, -0.311332, 0.895948>, <-0.564019, -0.293138, 0.904740>, <-0.490067, -0.254703, 0.929542> }
triangle { <-0.564019, -0.293138, 0.904740>, <-0.516358, -0.311332, 0.895948>, <-0.580877, -0.350233, 0.865145> }
triangle { <-0.580877, -0.350233, 0.865145>, <-0.634493, -0.329766, 0.876540>, <-0.564019, -0.293138, 0.904740> }
triangle { <-0.634493, -0.329766, 0.876540>, <-0.580877, -0.350233, 0.865145>, <-0.641815, -0.386975, 0.830821> }
triangle { <-0.641815, -0.386975, 0.830821>, <-0.701056, -0.364361, 0.845115>, <-0.634493, -0.329766, 0.876540> }
triangle { <-0.701056, -0.364361, 0.845115>, <-0.641815, -0.386975, 0.830821>, <-0.698796, -0.421331, 0.793186> }
triangle { <-0.698796, -0.421331, 0.793186>, <-0.763297, -0.396709, 0.810660>, <-0.701056, -0.364361, 0.845115> }
triangle { <-0.763297, -0.396709, 0.810660>, <-0.698796, -0.421331, 0.793186>, <-0.751469, -0.453090, 0.752473> }
triangle { <-0.751469, -0.453090, 0.752473>, <-0.820831, -0.426612, 0.773387>, <-0.763297, -0.396709, 0.810660> }
triangle { <-0.820831, -0.426612, 0.773387>, <-0.751469, -0.453090, 0.752473>, <-0.799509, -0.482054, 0.708932> }
triangle { <-0.799509, -0.482054, 0.708932>, <-0.873305, -0.453884, 0.733525>, <-0.820831, -0.426612, 0.773387> }
triangle { <-0.873305, -0.453884, 0.733525>, <-0.799509, -0.482054, 0.708932>, <-0.842619, -0.508047, 0.662833> }
triangle { <-0.842619, -0.508047, 0.662833>, <-0.920395, -0.478358, 0.691321>, <-0.873305, -0.453884, 0.733525> }
triangle { <-0.920395, -0.478358, 0.691321>, <-0.842619, -0.508047, 0.662833>, <-0.880535, -0.530908, 0.614459> }
triangle { <-0.880535, -0.530908, 0.614459>, <-0.961810, -0.499883, 0.647034>, <-0.920395, -0.478358, 0.691321> }
triangle { <-0.961810, -0.499883, 0.647034>, <-0.880535, -0.530908, 0.614459>, <-0.913021, -0.550496, 0.564108> }
triangle { <-0.913021, -0.550496, 0.564108>, <-0.997295, -0.518326, 0.600938>, <-0.961810, -0.499883, 0.647034> }
triangle { <-0.997295, -0.518326, 0.600938>, <-0.913021, -0.550496, 0.564108>, <-0.939879, -0.566689, 0.512092> }
triangle { <-0.939879, -0.566689, 0.512092>, <-1.026632, -0.533573, 0.553316>, <-0.997295, -0.518326, 0.600938> }
triangle { <-1.026632, -0.533573, 0.553316>, <-0.939879, -0.566689, 0.512092>, <-0.960942, -0.579389, 0.458730> }
triangle { <-0.960942, -0.579389, 0.458730>, <-1.049639, -0.545530, 0.504463>, <-1.026632, -0.533573, 0.553316> }
triangle { <-1.049639, -0.545530, 0.504463>, <-0.960942, -0.579389, 0.458730>, <-0.976080, -0.588516, 0.404352> }
triangle { <-0.976080, -0.588516, 0.404352>, <-1.066174, -0.554124, 0.454680>, <-1.049639, -0.545530, 0.504463> }
triangle { <-1.066174, -0.554124, 0.454680>, <-0.976080, -0.588516, 0.404352>, <-0.985201, -0.594015, 0.349293> }
triangle { <-0.985201, -0.594015, 0.349293>, <-1.076137, -0.559302, 0.404273>, <-1.066174, -0.554124, 0.454680> }
triangle { <-1.076137, -0.559302, 0.404273>, <-0.985201, -0.594015, 0.349293>, <-0.988247, -0.595852, 0.293893> }
triangle { <-0.988247, -0.595852, 0.293893>, <-1.079464, -0.561032, 0.353553>, <-1.076137, -0.559302, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.071439, -0.047647, 0.997617> }
triangle { <-0.071439, -0.047647, 0.997617>, <-0.077537, -0.046750, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.077537, -0.046750, 0.997823>, <-0.071439, -0.047647, 0.997617>, <-0.142438, -0.095000, 0.990483> }
triangle { <-0.142438, -0.095000, 0.990483>, <-0.154596, -0.093212, 0.991307>, <-0.077537, -0.046750, 0.997823> }
triangle { <-0.154596, -0.093212, 0.991307>, <-0.142438, -0.095000, 0.990483>, <-0.212559, -0.141768, 0.978642> }
triangle { <-0.212559, -0.141768, 0.978642>, <-0.230702, -0.139099, 0.980490>, <-0.154596, -0.093212, 0.991307> }
triangle { <-0.230702, -0.139099, 0.980490>, <-0.212559, -0.141768, 0.978642>, <-0.281370, -0.187662, 0.962166> }
triangle { <-0.281370, -0.187662, 0.962166>, <-0.305385, -0.184128, 0.965441>, <-0.230702, -0.139099, 0.980490> }
triangle { <-0.305385, -0.184128, 0.965441>, <-0.281370, -0.187662, 0.962166>, <-0.348445, -0.232398, 0.941159> }
triangle { <-0.348445, -0.232398, 0.941159>, <-0.378186, -0.228023, 0.946251>, <-0.305385, -0.184128, 0.965441> }
triangle { <-0.378186, -0.228023, 0.946251>, <-0.348445, -0.232398, 0.941159>, <-0.413372, -0.275702, 0.915748> }
triangle { <-0.413372, -0.275702, 0.915748>, <-0.448655, -0.270511, 0.923039>, <-0.378186, -0.228023, 0.946251> }
triangle { <-0.448655, -0.270511, 0.923039>, <-0.413372, -0.275702, 0.915748>, <-0.475751, -0.317306, 0.886090> }
triangle { <-0.475751, -0.317306, 0.886090>, <-0.516358, -0.311332, 0.895948>, <-0.448655, -0.270511, 0.923039> }
triangle { <-0.516358, -0.311332, 0.895948>, <-0.475751, -0.317306, 0.886090>, <-0.535197, -0.356954, 0.852369> }
triangle { <-0.535197, -0.356954, 0.852369>, <-0.580877, -0.350233, 0.865145>, <-0.516358, -0.311332, 0.895948> }
triangle { <-0.580877, -0.350233, 0.865145>, <-0.535197, -0.356954, 0.852369>, <-0.591343, -0.394401, 0.814793> }
triangle { <-0.591343, -0.394401, 0.814793>, <-0.641815, -0.386975, 0.830821>, <-0.580877, -0.350233, 0.865145> }
triangle { <-0.641815, -0.386975, 0.830821>, <-0.591343, -0.394401, 0.814793>, <-0.643843, -0.429416, 0.773592> }
triangle { <-0.643843, -0.429416, 0.773592>, <-0.698796, -0.421331, 0.793186>, <-0.641815, -0.386975, 0.830821> }
triangle { <-0.698796, -0.421331, 0.793186>, <-0.643843, -0.429416, 0.773592>, <-0.692373, -0.461784, 0.729022> }
triangle { <-0.692373, -0.461784, 0.729022>, <-0.751469, -0.453090, 0.752473>, <-0.698796, -0.421331, 0.793186> }
triangle { <-0.751469, -0.453090, 0.752473>, <-0.692373, -0.461784, 0.729022>, <-0.736635, -0.491305, 0.681356> }
triangle { <-0.736635, -0.491305, 0.681356>, <-0.799509, -0.482054, 0.708932>, <-0.751469, -0.453090, 0.752473> }
triangle { <-0.799509, -0.482054, 0.708932>, <-0.736635, -0.491305, 0.681356>, <-0.776355, -0.517796, 0.630889> }
triangle { <-0.776355, -0.517796, 0.630889>, <-0.842619, -0.508047, 0.662833>, <-0.799509, -0.482054, 0.708932> }
triangle { <-0.842619, -0.508047, 0.662833>, <-0.776355, -0.517796, 0.630889>, <-0.811289, -0.541096, 0.577932> }
triangle { <-0.811289, -0.541096, 0.577932>, <-0.880535, -0.530908, 0.614459>, <-0.842619, -0.508047, 0.662833> }
triangle { <-0.880535, -0.530908, 0.614459>, <-0.811289, -0.541096, 0.577932>, <-0.841221, -0.561059, 0.522811> }
triangle { <-0.841221, -0.561059, 0.522811>, <-0.913021, -0.550496, 0.564108>, <-0.880535, -0.530908, 0.614459> }
triangle { <-0.913021, -0.550496, 0.564108>, <-0.841221, -0.561059, 0.522811>, <-0.865967, -0.577563, 0.465867> }
triangle { <-0.865967, -0.577563, 0.465867>, <-0.939879, -0.566689, 0.512092>, <-0.913021, -0.550496, 0.564108> }
triangle { <-0.939879, -0.566689, 0.512092>, <-0.865967, -0.577563, 0.465867>, <-0.885373, -0.590507, 0.407450> }
triangle { <-0.885373, -0.590507, 0.407450>, <-0.960942, -0.579389, 0.458730>, <-0.939879, -0.566689, 0.512092> }
triangle { <-0.960942, -0.579389, 0.458730>, <-0.885373, -0.590507, 0.407450>, <-0.899321, -0.599809, 0.347920> }
triangle { <-0.899321, -0.599809, 0.347920>, <-0.976080, -0.588516, 0.404352>, <-0.960942, -0.579389, 0.458730> }
triangle { <-0.976080, -0.588516, 0.404352>, <-0.899321, -0.599809, 0.347920>, <-0.907724, -0.605414, 0.287645> }
triangle { <-0.907724, -0.605414, 0.287645>, <-0.985201, -0.594015, 0.349293>, <-0.976080, -0.588516, 0.404352> }
triangle { <-0.985201, -0.594015, 0.349293>, <-0.907724, -0.605414, 0.287645>, <-0.910531, -0.607286, 0.226995> }
triangle { <-0.910531, -0.607286, 0.226995>, <-0.988247, -0.595852, 0.293893>, <-0.985201, -0.594015, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.066937, -0.047324, 0.997394> }
triangle { <-0.066937, -0.047324, 0.997394>, <-0.071439, -0.047647, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.071439, -0.047647, 0.997617>, <-0.066937, -0.047324, 0.997394>, <-0.133461, -0.094357, 0.989591> }
triangle { <-0.133461, -0.094357, 0.989591>, <-0.142438, -0.095000, 0.990483>, <-0.071439, -0.047647, 0.997617> }
triangle { <-0.142438, -0.095000, 0.990483>, <-0.133461, -0.094357, 0.989591>, <-0.199163, -0.140807, 0.976639> }
triangle { <-0.199163, -0.140807, 0.976639>, <-0.212559, -0.141768, 0.978642>, <-0.142438, -0.095000, 0.990483> }
triangle { <-0.212559, -0.141768, 0.978642>, <-0.199163, -0.140807, 0.976639>, <-0.263636, -0.186390, 0.958619> }
triangle { <-0.263636, -0.186390, 0.958619>, <-0.281370, -0.187662, 0.962166>, <-0.212559, -0.141768, 0.978642> }
triangle { <-0.281370, -0.187662, 0.962166>, <-0.263636, -0.186390, 0.958619>, <-0.326484, -0.230824, 0.935641> }
triangle { <-0.326484, -0.230824, 0.935641>, <-0.348445, -0.232398, 0.941159>, <-0.281370, -0.187662, 0.962166> }
triangle { <-0.348445, -0.232398, 0.941159>, <-0.326484, -0.230824, 0.935641>, <-0.387320, -0.273834, 0.907847> }
triangle { <-0.387320, -0.273834, 0.907847>, <-0.413372, -0.275702, 0.915748>, <-0.348445, -0.232398, 0.941159> }
triangle { <-0.413372, -0.275702, 0.915748>, <-0.387320, -0.273834, 0.907847>, <-0.445767, -0.315156, 0.875409> }
triangle { <-0.445767, -0.315156, 0.875409>, <-0.475751, -0.317306, 0.886090>, <-0.413372, -0.275702, 0.915748> }
triangle { <-0.475751, -0.317306, 0.886090>, <-0.445767, -0.315156, 0.875409>, <-0.501466, -0.354535, 0.838525> }
triangle { <-0.501466, -0.354535, 0.838525>, <-0.535197, -0.356954, 0.852369>, <-0.475751, -0.317306, 0.886090> }
triangle { <-0.535197, -0.356954, 0.852369>, <-0.501466, -0.354535, 0.838525>, <-0.554073, -0.391728, 0.797425> }
triangle { <-0.554073, -0.391728, 0.797425>, <-0.591343, -0.394401, 0.814793>, <-0.535197, -0.356954, 0.852369> }
triangle { <-0.591343, -0.394401, 0.814793>, <-0.554073, -0.391728, 0.797425>, <-0.603265, -0.426506, 0.752361> }
triangle { <-0.603265, -0.426506, 0.752361>, <-0.643843, -0.429416, 0.773592>, <-0.591343, -0.394401, 0.814793> }
triangle { <-0.643843, -0.429416, 0.773592>, <-0.603265, -0.426506, 0.752361>, <-0.648737, -0.458655, 0.703611> }
triangle { <-0.648737, -0.458655, 0.703611>, <-0.692373, -0.461784, 0.729022>, <-0.643843, -0.429416, 0.773592> }
triangle { <-0.692373, -0.461784, 0.729022>, <-0.648737, -0.458655, 0.703611>, <-0.690209, -0.487976, 0.651476> }
triangle { <-0.690209, -0.487976, 0.651476>, <-0.736635, -0.491305, 0.681356>, <-0.692373, -0.461784, 0.729022> }
triangle { <-0.736635, -0.491305, 0.681356>, <-0.690209, -0.487976, 0.651476>, <-0.727426, -0.514288, 0.596277> }
triangle { <-0.727426, -0.514288, 0.596277>, <-0.776355, -0.517796, 0.630889>, <-0.736635, -0.491305, 0.681356> }
triangle { <-0.776355, -0.517796, 0.630889>, <-0.727426, -0.514288, 0.596277>, <-0.760158, -0.537429, 0.538354> }
triangle { <-0.760158, -0.537429, 0.538354>, <-0.811289, -0.541096, 0.577932>, <-0.776355, -0.517796, 0.630889> }
triangle { <-0.811289, -0.541096, 0.577932>, <-0.760158, -0.537429, 0.538354>, <-0.788203, -0.557257, 0.478064> }
triangle { <-0.788203, -0.557257, 0.478064>, <-0.841221, -0.561059, 0.522811>, <-0.811289, -0.541096, 0.577932> }
triangle { <-0.841221, -0.561059, 0.522811>, <-0.788203, -0.557257, 0.478064>, <-0.811389, -0.573650, 0.415780> }
triangle { <-0.811389, -0.573650, 0.415780>, <-0.865967, -0.577563, 0.465867>, <-0.841221, -0.561059, 0.522811> }
triangle { <-0.865967, -0.577563, 0.465867>, <-0.811389, -0.573650, 0.415780>, <-0.829573, -0.586505, 0.351885> }
triangle { <-0.829573, -0.586505, 0.351885>, <-0.885373, -0.590507, 0.407450>, <-0.865967, -0.577563, 0.465867> }
triangle { <-0.885373, -0.590507, 0.407450>, <-0.829573, -0.586505, 0.351885>, <-0.842641, -0.595745, 0.286773> }
triangle { <-0.842641, -0.595745, 0.286773>, <-0.899321, -0.599809, 0.347920>, <-0.885373, -0.590507, 0.407450> }
triangle { <-0.899321, -0.599809, 0.347920>, <-0.842641, -0.595745, 0.286773>, <-0.850515, -0.601312, 0.220845> }
triangle { <-0.850515, -0.601312, 0.220845>, <-0.907724, -0.605414, 0.287645>, <-0.899321, -0.599809, 0.347920> }
triangle { <-0.907724, -0.605414, 0.287645>, <-0.850515, -0.601312, 0.220845>, <-0.853145, -0.603171, 0.154508> }
triangle { <-0.853145, -0.603171, 0.154508>, <-0.910531, -0.607286, 0.226995>, <-0.907724, -0.605414, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.064295, -0.046546, 0.997158> }
triangle { <-0.064295, -0.046546, 0.997158>, <-0.066937, -0.047324, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.066937, -0.047324, 0.997394>, <-0.064295, -0.046546, 0.997158>, <-0.128194, -0.092805, 0.988651> }
triangle { <-0.128194, -0.092805, 0.988651>, <-0.133461, -0.094357, 0.989591>, <-0.066937, -0.047324, 0.997394> }
triangle { <-0.133461, -0.094357, 0.989591>, <-0.128194, -0.092805, 0.988651>, <-0.191303, -0.138492, 0.974531> }
triangle { <-0.191303, -0.138492, 0.974531>, <-0.199163, -0.140807, 0.976639>, <-0.133461, -0.094357, 0.989591> }
triangle { <-0.199163, -0.140807, 0.976639>, <-0.191303, -0.138492, 0.974531>, <-0.253232, -0.183326, 0.954885> }
triangle { <-0.253232, -0.183326, 0.954885>, <-0.263636, -0.186390, 0.958619>, <-0.199163, -0.140807, 0.976639> }
triangle { <-0.263636, -0.186390, 0.958619>, <-0.253232, -0.183326, 0.954885>, <-0.313600, -0.227029, 0.929833> }
triangle { <-0.313600, -0.227029, 0.929833>, <-0.326484, -0.230824, 0.935641>, <-0.263636, -0.186390, 0.958619> }
triangle { <-0.326484, -0.230824, 0.935641>, <-0.313600, -0.227029, 0.929833>, <-0.372035, -0.269332, 0.899532> }
triangle { <-0.372035, -0.269332, 0.899532>, <-0.387320, -0.273834, 0.907847>, <-0.326484, -0.230824, 0.935641> }
triangle { <-0.387320, -0.273834, 0.907847>, <-0.372035, -0.269332, 0.899532>, <-0.428175, -0.309974, 0.864166> }
triangle { <-0.428175, -0.309974, 0.864166>, <-0.445767, -0.315156, 0.875409>, <-0.387320, -0.273834, 0.907847> }
triangle { <-0.445767, -0.315156, 0.875409>, <-0.428175, -0.309974, 0.864166>, <-0.481676, -0.348706, 0.823955> }
triangle { <-0.481676, -0.348706, 0.823955>, <-0.501466, -0.354535, 0.838525>, <-0.445767, -0.315156, 0.875409> }
triangle { <-0.501466, -0.354535, 0.838525>, <-0.481676, -0.348706, 0.823955>, <-0.532208, -0.385288, 0.779146> }
triangle { <-0.532208, -0.385288, 0.779146>, <-0.554073, -0.391728, 0.797425>, <-0.501466, -0.354535, 0.838525> }
triangle { <-0.554073, -0.391728, 0.797425>, <-0.532208, -0.385288, 0.779146>, <-0.579458, -0.419494, 0.730016> }
triangle { <-0.579458, -0.419494, 0.730016>, <-0.603265, -0.426506, 0.752361>, <-0.554073, -0.391728, 0.797425> }
triangle { <-0.603265, -0.426506, 0.752361>, <-0.579458, -0.419494, 0.730016>, <-0.623135, -0.451114, 0.676867> }
triangle { <-0.623135, -0.451114, 0.676867>, <-0.648737, -0.458655, 0.703611>, <-0.603265, -0.426506, 0.752361> }
triangle { <-0.648737, -0.458655, 0.703611>, <-0.623135, -0.451114, 0.676867>, <-0.662971, -0.479953, 0.620028> }
triangle { <-0.662971, -0.479953, 0.620028>, <-0.690209, -0.487976, 0.651476>, <-0.648737, -0.458655, 0.703611> }
triangle { <-0.690209, -0.487976, 0.651476>, <-0.662971, -0.479953, 0.620028>, <-0.698719, -0.505832, 0.559847> }
triangle { <-0.698719, -0.505832, 0.559847>, <-0.727426, -0.514288, 0.596277>, <-0.690209, -0.487976, 0.651476> }
triangle { <-0.727426, -0.514288, 0.596277>, <-0.698719, -0.505832, 0.559847>, <-0.730159, -0.528593, 0.496698> }
triangle { <-0.730159, -0.528593, 0.496698>, <-0.760158, -0.537429, 0.538354>, <-0.727426, -0.514288, 0.596277> }
triangle { <-0.760158, -0.537429, 0.538354>, <-0.730159, -0.528593, 0.496698>, <-0.757098, -0.548095, 0.430968> }
triangle { <-0.757098, -0.548095, 0.430968>, <-0.788203, -0.557257, 0.478064>, <-0.760158, -0.537429, 0.538354> }
triangle { <-0.788203, -0.557257, 0.478064>, <-0.757098, -0.548095, 0.430968>, <-0.779369, -0.564218, 0.363064> }
triangle { <-0.779369, -0.564218, 0.363064>, <-0.811389, -0.573650, 0.415780>, <-0.788203, -0.557257, 0.478064> }
triangle { <-0.811389, -0.573650, 0.415780>, <-0.779369, -0.564218, 0.363064>, <-0.796835, -0.576863, 0.293403> }
triangle { <-0.796835, -0.576863, 0.293403>, <-0.829573, -0.586505, 0.351885>, <-0.811389, -0.573650, 0.415780> }
triangle { <-0.829573, -0.586505, 0.351885>, <-0.796835, -0.576863, 0.293403>, <-0.809388, -0.585950, 0.222416> }
triangle { <-0.809388, -0.585950, 0.222416>, <-0.842641, -0.595745, 0.286773>, <-0.829573, -0.586505, 0.351885> }
triangle { <-0.842641, -0.595745, 0.286773>, <-0.809388, -0.585950, 0.222416>, <-0.816951, -0.591425, 0.150539> }
triangle { <-0.816951, -0.591425, 0.150539>, <-0.850515, -0.601312, 0.220845>, <-0.842641, -0.595745, 0.286773> }
triangle { <-0.850515, -0.601312, 0.220845>, <-0.816951, -0.591425, 0.150539>, <-0.819477, -0.593254, 0.078217> }
triangle { <-0.819477, -0.593254, 0.078217>, <-0.853145, -0.603171, 0.154508>, <-0.850515, -0.601312, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.063475, -0.046117, 0.996917> }
triangle { <-0.063475, -0.046117, 0.996917>, <-0.064295, -0.046546, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.064295, -0.046546, 0.997158>, <-0.063475, -0.046117, 0.996917>, <-0.126558, -0.091950, 0.987688> }
triangle { <-0.126558, -0.091950, 0.987688>, <-0.128194, -0.092805, 0.988651>, <-0.064295, -0.046546, 0.997158> }
triangle { <-0.128194, -0.092805, 0.988651>, <-0.126558, -0.091950, 0.987688>, <-0.188861, -0.137216, 0.972370> }
triangle { <-0.188861, -0.137216, 0.972370>, <-0.191303, -0.138492, 0.974531>, <-0.128194, -0.092805, 0.988651> }
triangle { <-0.191303, -0.138492, 0.974531>, <-0.188861, -0.137216, 0.972370>, <-0.250000, -0.181636, 0.951057> }
triangle { <-0.250000, -0.181636, 0.951057>, <-0.253232, -0.183326, 0.954885>, <-0.191303, -0.138492, 0.974531> }
triangle { <-0.253232, -0.183326, 0.954885>, <-0.250000, -0.181636, 0.951057>, <-0.309597, -0.224936, 0.923880> }
triangle { <-0.309597, -0.224936, 0.923880>, <-0.313600, -0.227029, 0.929833>, <-0.253232, -0.183326, 0.954885> }
triangle { <-0.313600, -0.227029, 0.929833>, <-0.309597, -0.224936, 0.923880>, <-0.367286, -0.266849, 0.891007> }
triangle { <-0.367286, -0.266849, 0.891007>, <-0.372035, -0.269332, 0.899532>, <-0.313600, -0.227029, 0.929833> }
triangle { <-0.372035, -0.269332, 0.899532>, <-0.367286, -0.266849, 0.891007>, <-0.422710, -0.307117, 0.852640> }
triangle { <-0.422710, -0.307117, 0.852640>, <-0.428175, -0.309974, 0.864166>, <-0.372035, -0.269332, 0.899532> }
triangle { <-0.428175, -0.309974, 0.864166>, <-0.422710, -0.307117, 0.852640>, <-0.475528, -0.345492, 0.809017> }
triangle { <-0.475528, -0.345492, 0.809017>, <-0.481676, -0.348706, 0.823955>, <-0.428175, -0.309974, 0.864166> }
triangle { <-0.481676, -0.348706, 0.823955>, <-0.475528, -0.345492, 0.809017>, <-0.525415, -0.381736, 0.760406> }
triangle { <-0.525415, -0.381736, 0.760406>, <-0.532208, -0.385288, 0.779146>, <-0.481676, -0.348706, 0.823955> }
triangle { <-0.532208, -0.385288, 0.779146>, <-0.525415, -0.381736, 0.760406>, <-0.572061, -0.415627, 0.707107> }
triangle { <-0.572061, -0.415627, 0.707107>, <-0.579458, -0.419494, 0.730016>, <-0.532208, -0.385288, 0.779146> }
triangle { <-0.579458, -0.419494, 0.730016>, <-0.572061, -0.415627, 0.707107>, <-0.615181, -0.446955, 0.649448> }
triangle { <-0.615181, -0.446955, 0.649448>, <-0.623135, -0.451114, 0.676867>, <-0.579458, -0.419494, 0.730016> }
triangle { <-0.623135, -0.451114, 0.676867>, <-0.615181, -0.446955, 0.649448>, <-0.654508, -0.475528, 0.587785> }
triangle { <-0.654508, -0.475528, 0.587785>, <-0.662971, -0.479953, 0.620028>, <-0.623135, -0.451114, 0.676867> }
triangle { <-0.662971, -0.479953, 0.620028>, <-0.654508, -0.475528, 0.587785>, <-0.689800, -0.501169, 0.522499> }
triangle { <-0.689800, -0.501169, 0.522499>, <-0.698719, -0.505832, 0.559847>, <-0.662971, -0.479953, 0.620028> }
triangle { <-0.698719, -0.505832, 0.559847>, <-0.689800, -0.501169, 0.522499>, <-0.720839, -0.523720, 0.453990> }
triangle { <-0.720839, -0.523720, 0.453990>, <-0.730159, -0.528593, 0.496698>, <-0.698719, -0.505832, 0.559847> }
triangle { <-0.730159, -0.528593, 0.496698>, <-0.720839, -0.523720, 0.453990>, <-0.747434, -0.543043, 0.382683> }
triangle { <-0.747434, -0.543043, 0.382683>, <-0.757098, -0.548095, 0.430968>, <-0.730159, -0.528593, 0.496698> }
triangle { <-0.757098, -0.548095, 0.430968>, <-0.747434, -0.543043, 0.382683>, <-0.769421, -0.559017, 0.309017> }
triangle { <-0.769421, -0.559017, 0.309017>, <-0.779369, -0.564218, 0.363064>, <-0.757098, -0.548095, 0.430968> }
triangle { <-0.779369, -0.564218, 0.363064>, <-0.769421, -0.559017, 0.309017>, <-0.786664, -0.571545, 0.233445> }
triangle { <-0.786664, -0.571545, 0.233445>, <-0.796835, -0.576863, 0.293403>, <-0.779369, -0.564218, 0.363064> }
triangle { <-0.796835, -0.576863, 0.293403>, <-0.786664, -0.571545, 0.233445>, <-0.799057, -0.580549, 0.156434> }
triangle { <-0.799057, -0.580549, 0.156434>, <-0.809388, -0.585950, 0.222416>, <-0.796835, -0.576863, 0.293403> }
triangle { <-0.809388, -0.585950, 0.222416>, <-0.799057, -0.580549, 0.156434>, <-0.806523, -0.585973, 0.078459> }
triangle { <-0.806523, -0.585973, 0.078459>, <-0.816951, -0.591425, 0.150539>, <-0.809388, -0.585950, 0.222416> }
triangle { <-0.816951, -0.591425, 0.150539>, <-0.806523, -0.585973, 0.078459>, <-0.809017, -0.587785, 0.000000> }
triangle { <-0.809017, -0.587785, 0.000000>, <-0.819477, -0.593254, 0.078217>, <-0.816951, -0.591425, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.064136, -0.046765, 0.997158> }
triangle { <-0.064136, -0.046765, 0.997158>, <-0.063475, -0.046117, 0.996917>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.063475, -0.046117, 0.996917>, <-0.064136, -0.046765, 0.997158>, <-0.127877, -0.093242, 0.988651> }
triangle { <-0.127877, -0.093242, 0.988651>, <-0.126558, -0.091950, 0.987688>, <-0.063475, -0.046117, 0.996917> }
triangle { <-0.126558, -0.091950, 0.987688>, <-0.127877, -0.093242, 0.988651>, <-0.190830, -0.139144, 0.974531> }
triangle { <-0.190830, -0.139144, 0.974531>, <-0.188861, -0.137216, 0.972370>, <-0.126558, -0.091950, 0.987688> }
triangle { <-0.188861, -0.137216, 0.972370>, <-0.190830, -0.139144, 0.974531>, <-0.252606, -0.184187, 0.954885> }
triangle { <-0.252606, -0.184187, 0.954885>, <-0.250000, -0.181636, 0.951057>, <-0.188861, -0.137216, 0.972370> }
triangle { <-0.250000, -0.181636, 0.951057>, <-0.252606, -0.184187, 0.954885>, <-0.312825, -0.228096, 0.929833> }
triangle { <-0.312825, -0.228096, 0.929833>, <-0.309597, -0.224936, 0.923880>, <-0.250000, -0.181636, 0.951057> }
triangle { <-0.309597, -0.224936, 0.923880>, <-0.312825, -0.228096, 0.929833>, <-0.371115, -0.270598, 0.899532> }
triangle { <-0.371115, -0.270598, 0.899532>, <-0.367286, -0.266849, 0.891007>, <-0.309597, -0.224936, 0.923880> }
triangle { <-0.367286, -0.266849, 0.891007>, <-0.371115, -0.270598, 0.899532>, <-0.427117, -0.311432, 0.864166> }
triangle { <-0.427117, -0.311432, 0.864166>, <-0.422710, -0.307117, 0.852640>, <-0.367286, -0.266849, 0.891007> }
triangle { <-0.422710, -0.307117, 0.852640>, <-0.427117, -0.311432, 0.864166>, <-0.480485, -0.350345, 0.823955> }
triangle { <-0.480485, -0.350345, 0.823955>, <-0.475528, -0.345492, 0.809017>, <-0.422710, -0.307117, 0.852640> }
triangle { <-0.475528, -0.345492, 0.809017>, <-0.480485, -0.350345, 0.823955>, <-0.530892, -0.387099, 0.779146> }
triangle { <-0.530892, -0.387099, 0.779146>, <-0.525415, -0.381736, 0.760406>, <-0.475528, -0.345492, 0.809017> }
triangle { <-0.525415, -0.381736, 0.760406>, <-0.530892, -0.387099, 0.779146>, <-0.578025, -0.421466, 0.730016> }
triangle { <-0.578025, -0.421466, 0.730016>, <-0.572061, -0.415627, 0.707107>, <-0.525415, -0.381736, 0.760406> }
triangle { <-0.572061, -0.415627, 0.707107>, <-0.578025, -0.421466, 0.730016>, <-0.621594, -0.453235, 0.676867> }
triangle { <-0.621594, -0.453235, 0.676867>, <-0.615181, -0.446955, 0.649448>, <-0.572061, -0.415627, 0.707107> }
triangle { <-0.615181, -0.446955, 0.649448>, <-0.621594, -0.453235, 0.676867>, <-0.661331, -0.482209, 0.620028> }
triangle { <-0.661331, -0.482209, 0.620028>, <-0.654508, -0.475528, 0.587785>, <-0.615181, -0.446955, 0.649448> }
triangle { <-0.654508, -0.475528, 0.587785>, <-0.661331, -0.482209, 0.620028>, <-0.696991, -0.508210, 0.559847> }
triangle { <-0.696991, -0.508210, 0.559847>, <-0.689800, -0.501169, 0.522499>, <-0.654508, -0.475528, 0.587785> }
triangle { <-0.689800, -0.501169, 0.522499>, <-0.696991, -0.508210, 0.559847>, <-0.728354, -0.531078, 0.496698> }
triangle { <-0.728354, -0.531078, 0.496698>, <-0.720839, -0.523720, 0.453990>, <-0.689800, -0.501169, 0.522499> }
triangle { <-0.720839, -0.523720, 0.453990>, <-0.728354, -0.531078, 0.496698>, <-0.755226, -0.550672, 0.430968> }
triangle { <-0.755226, -0.550672, 0.430968>, <-0.747434, -0.543043, 0.382683>, <-0.720839, -0.523720, 0.453990> }
triangle { <-0.747434, -0.543043, 0.382683>, <-0.755226, -0.550672, 0.430968>, <-0.777442, -0.566871, 0.363064> }
triangle { <-0.777442, -0.566871, 0.363064>, <-0.769421, -0.559017, 0.309017>, <-0.747434, -0.543043, 0.382683> }
triangle { <-0.769421, -0.559017, 0.309017>, <-0.777442, -0.566871, 0.363064>, <-0.794864, -0.579574, 0.293403> }
triangle { <-0.794864, -0.579574, 0.293403>, <-0.786664, -0.571545, 0.233445>, <-0.769421, -0.559017, 0.309017> }
triangle { <-0.786664, -0.571545, 0.233445>, <-0.794864, -0.579574, 0.293403>, <-0.807386, -0.588705, 0.222416> }
triangle { <-0.807386, -0.588705, 0.222416>, <-0.799057, -0.580549, 0.156434>, <-0.786664, -0.571545, 0.233445> }
triangle { <-0.799057, -0.580549, 0.156434>, <-0.807386, -0.588705, 0.222416>, <-0.814931, -0.594206, 0.150539> }
triangle { <-0.814931, -0.594206, 0.150539>, <-0.806523, -0.585973, 0.078459>, <-0.799057, -0.580549, 0.156434> }
triangle { <-0.806523, -0.585973, 0.078459>, <-0.814931, -0.594206, 0.150539>, <-0.817451, -0.596043, 0.078217> }
triangle { <-0.817451, -0.596043, 0.078217>, <-0.809017, -0.587785, 0.000000>, <-0.806523, -0.585973, 0.078459> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.065693, -0.049037, 0.997394> }
triangle { <-0.065693, -0.049037, 0.997394>, <-0.064136, -0.046765, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.064136, -0.046765, 0.997158>, <-0.065693, -0.049037, 0.997394>, <-0.130980, -0.097771, 0.989591> }
triangle { <-0.130980, -0.097771, 0.989591>, <-0.127877, -0.093242, 0.988651>, <-0.064136, -0.046765, 0.997158> }
triangle { <-0.127877, -0.093242, 0.988651>, <-0.130980, -0.097771, 0.989591>, <-0.195461, -0.145903, 0.976639> }
triangle { <-0.195461, -0.145903, 0.976639>, <-0.190830, -0.139144, 0.974531>, <-0.127877, -0.093242, 0.988651> }
triangle { <-0.190830, -0.139144, 0.974531>, <-0.195461, -0.145903, 0.976639>, <-0.258736, -0.193135, 0.958619> }
triangle { <-0.258736, -0.193135, 0.958619>, <-0.252606, -0.184187, 0.954885>, <-0.190830, -0.139144, 0.974531> }
triangle { <-0.252606, -0.184187, 0.954885>, <-0.258736, -0.193135, 0.958619>, <-0.320416, -0.239177, 0.935641> }
triangle { <-0.320416, -0.239177, 0.935641>, <-0.312825, -0.228096, 0.929833>, <-0.252606, -0.184187, 0.954885> }
triangle { <-0.312825, -0.228096, 0.929833>, <-0.320416, -0.239177, 0.935641>, <-0.380120, -0.283744, 0.907847> }
triangle { <-0.380120, -0.283744, 0.907847>, <-0.371115, -0.270598, 0.899532>, <-0.312825, -0.228096, 0.929833> }
triangle { <-0.371115, -0.270598, 0.899532>, <-0.380120, -0.283744, 0.907847>, <-0.437481, -0.326561, 0.875409> }
triangle { <-0.437481, -0.326561, 0.875409>, <-0.427117, -0.311432, 0.864166>, <-0.371115, -0.270598, 0.899532> }
triangle { <-0.427117, -0.311432, 0.864166>, <-0.437481, -0.326561, 0.875409>, <-0.492144, -0.367365, 0.838525> }
triangle { <-0.492144, -0.367365, 0.838525>, <-0.480485, -0.350345, 0.823955>, <-0.427117, -0.311432, 0.864166> }
triangle { <-0.480485, -0.350345, 0.823955>, <-0.492144, -0.367365, 0.838525>, <-0.543774, -0.405904, 0.797425> }
triangle { <-0.543774, -0.405904, 0.797425>, <-0.530892, -0.387099, 0.779146>, <-0.480485, -0.350345, 0.823955> }
triangle { <-0.530892, -0.387099, 0.779146>, <-0.543774, -0.405904, 0.797425>, <-0.592051, -0.441941, 0.752361> }
triangle { <-0.592051, -0.441941, 0.752361>, <-0.578025, -0.421466, 0.730016>, <-0.530892, -0.387099, 0.779146> }
triangle { <-0.578025, -0.421466, 0.730016>, <-0.592051, -0.441941, 0.752361>, <-0.636677, -0.475253, 0.703611> }
triangle { <-0.636677, -0.475253, 0.703611>, <-0.621594, -0.453235, 0.676867>, <-0.578025, -0.421466, 0.730016> }
triangle { <-0.621594, -0.453235, 0.676867>, <-0.636677, -0.475253, 0.703611>, <-0.677379, -0.505635, 0.651476> }
triangle { <-0.677379, -0.505635, 0.651476>, <-0.661331, -0.482209, 0.620028>, <-0.621594, -0.453235, 0.676867> }
triangle { <-0.661331, -0.482209, 0.620028>, <-0.677379, -0.505635, 0.651476>, <-0.713904, -0.532899, 0.596277> }
triangle { <-0.713904, -0.532899, 0.596277>, <-0.696991, -0.508210, 0.559847>, <-0.661331, -0.482209, 0.620028> }
triangle { <-0.696991, -0.508210, 0.559847>, <-0.713904, -0.532899, 0.596277>, <-0.746027, -0.556878, 0.538354> }
triangle { <-0.746027, -0.556878, 0.538354>, <-0.728354, -0.531078, 0.496698>, <-0.696991, -0.508210, 0.559847> }
triangle { <-0.728354, -0.531078, 0.496698>, <-0.746027, -0.556878, 0.538354>, <-0.773551, -0.577424, 0.478064> }
triangle { <-0.773551, -0.577424, 0.478064>, <-0.755226, -0.550672, 0.430968>, <-0.728354, -0.531078, 0.496698> }
triangle { <-0.755226, -0.550672, 0.430968>, <-0.773551, -0.577424, 0.478064>, <-0.796306, -0.594409, 0.415780> }
triangle { <-0.796306, -0.594409, 0.415780>, <-0.777442, -0.566871, 0.363064>, <-0.755226, -0.550672, 0.430968> }
triangle { <-0.777442, -0.566871, 0.363064>, <-0.796306, -0.594409, 0.415780>, <-0.814152, -0.607730, 0.351885> }
triangle { <-0.814152, -0.607730, 0.351885>, <-0.794864, -0.579574, 0.293403>, <-0.777442, -0.566871, 0.363064> }
triangle { <-0.794864, -0.579574, 0.293403>, <-0.814152, -0.607730, 0.351885>, <-0.826978, -0.617304, 0.286773> }
triangle { <-0.826978, -0.617304, 0.286773>, <-0.807386, -0.588705, 0.222416>, <-0.794864, -0.579574, 0.293403> }
triangle { <-0.807386, -0.588705, 0.222416>, <-0.826978, -0.617304, 0.286773>, <-0.834705, -0.623072, 0.220845> }
triangle { <-0.834705, -0.623072, 0.220845>, <-0.814931, -0.594206, 0.150539>, <-0.807386, -0.588705, 0.222416> }
triangle { <-0.814931, -0.594206, 0.150539>, <-0.834705, -0.623072, 0.220845>, <-0.837286, -0.624999, 0.154508> }
triangle { <-0.837286, -0.624999, 0.154508>, <-0.817451, -0.596043, 0.078217>, <-0.814931, -0.594206, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.067391, -0.053219, 0.997617> }
triangle { <-0.067391, -0.053219, 0.997617>, <-0.065693, -0.049037, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.065693, -0.049037, 0.997394>, <-0.067391, -0.053219, 0.997617>, <-0.134367, -0.106110, 0.990483> }
triangle { <-0.134367, -0.106110, 0.990483>, <-0.130980, -0.097771, 0.989591>, <-0.065693, -0.049037, 0.997394> }
triangle { <-0.130980, -0.097771, 0.989591>, <-0.134367, -0.106110, 0.990483>, <-0.200514, -0.158347, 0.978642> }
triangle { <-0.200514, -0.158347, 0.978642>, <-0.195461, -0.145903, 0.976639>, <-0.130980, -0.097771, 0.989591> }
triangle { <-0.195461, -0.145903, 0.976639>, <-0.200514, -0.158347, 0.978642>, <-0.265425, -0.209608, 0.962166> }
triangle { <-0.265425, -0.209608, 0.962166>, <-0.258736, -0.193135, 0.958619>, <-0.195461, -0.145903, 0.976639> }
triangle { <-0.258736, -0.193135, 0.958619>, <-0.265425, -0.209608, 0.962166>, <-0.328699, -0.259576, 0.941159> }
triangle { <-0.328699, -0.259576, 0.941159>, <-0.320416, -0.239177, 0.935641>, <-0.258736, -0.193135, 0.958619> }
triangle { <-0.320416, -0.239177, 0.935641>, <-0.328699, -0.259576, 0.941159>, <-0.389947, -0.307944, 0.915748> }
triangle { <-0.389947, -0.307944, 0.915748>, <-0.380120, -0.283744, 0.907847>, <-0.320416, -0.239177, 0.935641> }
triangle { <-0.380120, -0.283744, 0.907847>, <-0.389947, -0.307944, 0.915748>, <-0.448791, -0.354413, 0.886090> }
triangle { <-0.448791, -0.354413, 0.886090>, <-0.437481, -0.326561, 0.875409>, <-0.380120, -0.283744, 0.907847> }
triangle { <-0.437481, -0.326561, 0.875409>, <-0.448791, -0.354413, 0.886090>, <-0.504868, -0.398698, 0.852369> }
triangle { <-0.504868, -0.398698, 0.852369>, <-0.492144, -0.367365, 0.838525>, <-0.437481, -0.326561, 0.875409> }
triangle { <-0.492144, -0.367365, 0.838525>, <-0.504868, -0.398698, 0.852369>, <-0.557832, -0.440524, 0.814793> }
triangle { <-0.557832, -0.440524, 0.814793>, <-0.543774, -0.405904, 0.797425>, <-0.492144, -0.367365, 0.838525> }
triangle { <-0.543774, -0.405904, 0.797425>, <-0.557832, -0.440524, 0.814793>, <-0.607357, -0.479634, 0.773592> }
triangle { <-0.607357, -0.479634, 0.773592>, <-0.592051, -0.441941, 0.752361>, <-0.543774, -0.405904, 0.797425> }
triangle { <-0.592051, -0.441941, 0.752361>, <-0.607357, -0.479634, 0.773592>, <-0.653138, -0.515787, 0.729022> }
triangle { <-0.653138, -0.515787, 0.729022>, <-0.636677, -0.475253, 0.703611>, <-0.592051, -0.441941, 0.752361> }
triangle { <-0.636677, -0.475253, 0.703611>, <-0.653138, -0.515787, 0.729022>, <-0.694891, -0.548760, 0.681356> }
triangle { <-0.694891, -0.548760, 0.681356>, <-0.677379, -0.505635, 0.651476>, <-0.636677, -0.475253, 0.703611> }
triangle { <-0.677379, -0.505635, 0.651476>, <-0.694891, -0.548760, 0.681356>, <-0.732361, -0.578350, 0.630889> }
triangle { <-0.732361, -0.578350, 0.630889>, <-0.713904, -0.532899, 0.596277>, <-0.677379, -0.505635, 0.651476> }
triangle { <-0.713904, -0.532899, 0.596277>, <-0.732361, -0.578350, 0.630889>, <-0.765315, -0.604374, 0.577932> }
triangle { <-0.765315, -0.604374, 0.577932>, <-0.746027, -0.556878, 0.538354>, <-0.713904, -0.532899, 0.596277> }
triangle { <-0.746027, -0.556878, 0.538354>, <-0.765315, -0.604374, 0.577932>, <-0.793550, -0.626672, 0.522811> }
triangle { <-0.793550, -0.626672, 0.522811>, <-0.773551, -0.577424, 0.478064>, <-0.746027, -0.556878, 0.538354> }
triangle { <-0.773551, -0.577424, 0.478064>, <-0.793550, -0.626672, 0.522811>, <-0.816894, -0.645106, 0.465867> }
triangle { <-0.816894, -0.645106, 0.465867>, <-0.796306, -0.594409, 0.415780>, <-0.773551, -0.577424, 0.478064> }
triangle { <-0.796306, -0.594409, 0.415780>, <-0.816894, -0.645106, 0.465867>, <-0.835200, -0.659563, 0.407450> }
triangle { <-0.835200, -0.659563, 0.407450>, <-0.814152, -0.607730, 0.351885>, <-0.796306, -0.594409, 0.415780> }
triangle { <-0.814152, -0.607730, 0.351885>, <-0.835200, -0.659563, 0.407450>, <-0.848358, -0.669954, 0.347920> }
triangle { <-0.848358, -0.669954, 0.347920>, <-0.826978, -0.617304, 0.286773>, <-0.814152, -0.607730, 0.351885> }
triangle { <-0.826978, -0.617304, 0.286773>, <-0.848358, -0.669954, 0.347920>, <-0.856285, -0.676214, 0.287645> }
triangle { <-0.856285, -0.676214, 0.287645>, <-0.834705, -0.623072, 0.220845>, <-0.826978, -0.617304, 0.286773> }
triangle { <-0.834705, -0.623072, 0.220845>, <-0.856285, -0.676214, 0.287645>, <-0.858933, -0.678305, 0.226995> }
triangle { <-0.858933, -0.678305, 0.226995>, <-0.837286, -0.624999, 0.154508>, <-0.834705, -0.623072, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.068422, -0.059295, 0.997823> }
triangle { <-0.068422, -0.059295, 0.997823>, <-0.067391, -0.053219, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.067391, -0.053219, 0.997617>, <-0.068422, -0.059295, 0.997823>, <-0.136422, -0.118225, 0.991307> }
triangle { <-0.136422, -0.118225, 0.991307>, <-0.134367, -0.106110, 0.990483>, <-0.067391, -0.053219, 0.997617> }
triangle { <-0.134367, -0.106110, 0.990483>, <-0.136422, -0.118225, 0.991307>, <-0.203582, -0.176426, 0.980490> }
triangle { <-0.203582, -0.176426, 0.980490>, <-0.200514, -0.158347, 0.978642>, <-0.134367, -0.106110, 0.990483> }
triangle { <-0.200514, -0.158347, 0.978642>, <-0.203582, -0.176426, 0.980490>, <-0.269486, -0.233540, 0.965441> }
triangle { <-0.269486, -0.233540, 0.965441>, <-0.265425, -0.209608, 0.962166>, <-0.200514, -0.158347, 0.978642> }
triangle { <-0.265425, -0.209608, 0.962166>, <-0.269486, -0.233540, 0.965441>, <-0.333728, -0.289213, 0.946251> }
triangle { <-0.333728, -0.289213, 0.946251>, <-0.328699, -0.259576, 0.941159>, <-0.265425, -0.209608, 0.962166> }
triangle { <-0.328699, -0.259576, 0.941159>, <-0.333728, -0.289213, 0.946251>, <-0.395913, -0.343103, 0.923039> }
triangle { <-0.395913, -0.343103, 0.923039>, <-0.389947, -0.307944, 0.915748>, <-0.328699, -0.259576, 0.941159> }
triangle { <-0.389947, -0.307944, 0.915748>, <-0.395913, -0.343103, 0.923039>, <-0.455657, -0.394878, 0.895948> }
triangle { <-0.455657, -0.394878, 0.895948>, <-0.448791, -0.354413, 0.886090>, <-0.389947, -0.307944, 0.915748> }
triangle { <-0.448791, -0.354413, 0.886090>, <-0.455657, -0.394878, 0.895948>, <-0.512592, -0.444219, 0.865145> }
triangle { <-0.512592, -0.444219, 0.865145>, <-0.504868, -0.398698, 0.852369>, <-0.448791, -0.354413, 0.886090> }
triangle { <-0.504868, -0.398698, 0.852369>, <-0.512592, -0.444219, 0.865145>, <-0.566367, -0.490821, 0.830821> }
triangle { <-0.566367, -0.490821, 0.830821>, <-0.557832, -0.440524, 0.814793>, <-0.504868, -0.398698, 0.852369> }
triangle { <-0.557832, -0.440524, 0.814793>, <-0.566367, -0.490821, 0.830821>, <-0.616650, -0.534396, 0.793186> }
triangle { <-0.616650, -0.534396, 0.793186>, <-0.607357, -0.479634, 0.773592>, <-0.557832, -0.440524, 0.814793> }
triangle { <-0.607357, -0.479634, 0.773592>, <-0.616650, -0.534396, 0.793186>, <-0.663130, -0.574677, 0.752473> }
triangle { <-0.663130, -0.574677, 0.752473>, <-0.653138, -0.515787, 0.729022>, <-0.607357, -0.479634, 0.773592> }
triangle { <-0.653138, -0.515787, 0.729022>, <-0.663130, -0.574677, 0.752473>, <-0.705523, -0.611415, 0.708932> }
triangle { <-0.705523, -0.611415, 0.708932>, <-0.694891, -0.548760, 0.681356>, <-0.653138, -0.515787, 0.729022> }
triangle { <-0.694891, -0.548760, 0.681356>, <-0.705523, -0.611415, 0.708932>, <-0.743565, -0.644383, 0.662833> }
triangle { <-0.743565, -0.644383, 0.662833>, <-0.732361, -0.578350, 0.630889>, <-0.694891, -0.548760, 0.681356> }
triangle { <-0.732361, -0.578350, 0.630889>, <-0.743565, -0.644383, 0.662833>, <-0.777024, -0.673378, 0.614459> }
triangle { <-0.777024, -0.673378, 0.614459>, <-0.765315, -0.604374, 0.577932>, <-0.732361, -0.578350, 0.630889> }
triangle { <-0.765315, -0.604374, 0.577932>, <-0.777024, -0.673378, 0.614459>, <-0.805691, -0.698222, 0.564108> }
triangle { <-0.805691, -0.698222, 0.564108>, <-0.793550, -0.626672, 0.522811>, <-0.765315, -0.604374, 0.577932> }
triangle { <-0.793550, -0.626672, 0.522811>, <-0.805691, -0.698222, 0.564108>, <-0.829392, -0.718761, 0.512092> }
triangle { <-0.829392, -0.718761, 0.512092>, <-0.816894, -0.645106, 0.465867>, <-0.793550, -0.626672, 0.522811> }
triangle { <-0.816894, -0.645106, 0.465867>, <-0.829392, -0.718761, 0.512092>, <-0.847979, -0.734869, 0.458730> }
triangle { <-0.847979, -0.734869, 0.458730>, <-0.835200, -0.659563, 0.407450>, <-0.816894, -0.645106, 0.465867> }
triangle { <-0.835200, -0.659563, 0.407450>, <-0.847979, -0.734869, 0.458730>, <-0.861337, -0.746446, 0.404352> }
triangle { <-0.861337, -0.746446, 0.404352>, <-0.848358, -0.669954, 0.347920>, <-0.835200, -0.659563, 0.407450> }
triangle { <-0.848358, -0.669954, 0.347920>, <-0.861337, -0.746446, 0.404352>, <-0.869386, -0.753421, 0.349293> }
triangle { <-0.869386, -0.753421, 0.349293>, <-0.856285, -0.676214, 0.287645>, <-0.848358, -0.669954, 0.347920> }
triangle { <-0.856285, -0.676214, 0.287645>, <-0.869386, -0.753421, 0.349293>, <-0.872074, -0.755750, 0.293893> }
triangle { <-0.872074, -0.755750, 0.293893>, <-0.858933, -0.678305, 0.226995>, <-0.856285, -0.676214, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.068035, -0.066946, 0.998007> }
triangle { <-0.068035, -0.066946, 0.998007>, <-0.068422, -0.059295, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.068422, -0.059295, 0.997823>, <-0.068035, -0.066946, 0.998007>, <-0.135651, -0.133480, 0.992041> }
triangle { <-0.135651, -0.133480, 0.992041>, <-0.136422, -0.118225, 0.991307>, <-0.068422, -0.059295, 0.997823> }
triangle { <-0.136422, -0.118225, 0.991307>, <-0.135651, -0.133480, 0.992041>, <-0.202431, -0.199190, 0.982139> }
triangle { <-0.202431, -0.199190, 0.982139>, <-0.203582, -0.176426, 0.980490>, <-0.136422, -0.118225, 0.991307> }
triangle { <-0.203582, -0.176426, 0.980490>, <-0.202431, -0.199190, 0.982139>, <-0.267963, -0.263673, 0.968361> }
triangle { <-0.267963, -0.263673, 0.968361>, <-0.269486, -0.233540, 0.965441>, <-0.203582, -0.176426, 0.980490> }
triangle { <-0.269486, -0.233540, 0.965441>, <-0.267963, -0.263673, 0.968361>, <-0.331842, -0.326530, 0.950792> }
triangle { <-0.331842, -0.326530, 0.950792>, <-0.333728, -0.289213, 0.946251>, <-0.269486, -0.233540, 0.965441> }
triangle { <-0.333728, -0.289213, 0.946251>, <-0.331842, -0.326530, 0.950792>, <-0.393676, -0.387373, 0.929542> }
triangle { <-0.393676, -0.387373, 0.929542>, <-0.395913, -0.343103, 0.923039>, <-0.333728, -0.289213, 0.946251> }
triangle { <-0.395913, -0.343103, 0.923039>, <-0.393676, -0.387373, 0.929542>, <-0.453082, -0.445829, 0.904740> }
triangle { <-0.453082, -0.445829, 0.904740>, <-0.455657, -0.394878, 0.895948>, <-0.395913, -0.343103, 0.923039> }
triangle { <-0.455657, -0.394878, 0.895948>, <-0.453082, -0.445829, 0.904740>, <-0.509695, -0.501536, 0.876540> }
triangle { <-0.509695, -0.501536, 0.876540>, <-0.512592, -0.444219, 0.865145>, <-0.455657, -0.394878, 0.895948> }
triangle { <-0.512592, -0.444219, 0.865145>, <-0.509695, -0.501536, 0.876540>, <-0.563166, -0.554150, 0.845115> }
triangle { <-0.563166, -0.554150, 0.845115>, <-0.566367, -0.490821, 0.830821>, <-0.512592, -0.444219, 0.865145> }
triangle { <-0.566367, -0.490821, 0.830821>, <-0.563166, -0.554150, 0.845115>, <-0.613165, -0.603348, 0.810660> }
triangle { <-0.613165, -0.603348, 0.810660>, <-0.616650, -0.534396, 0.793186>, <-0.566367, -0.490821, 0.830821> }
triangle { <-0.616650, -0.534396, 0.793186>, <-0.613165, -0.603348, 0.810660>, <-0.659383, -0.648827, 0.773387> }
triangle { <-0.659383, -0.648827, 0.773387>, <-0.663130, -0.574677, 0.752473>, <-0.616650, -0.534396, 0.793186> }
triangle { <-0.663130, -0.574677, 0.752473>, <-0.659383, -0.648827, 0.773387>, <-0.701536, -0.690305, 0.733525> }
triangle { <-0.701536, -0.690305, 0.733525>, <-0.705523, -0.611415, 0.708932>, <-0.663130, -0.574677, 0.752473> }
triangle { <-0.705523, -0.611415, 0.708932>, <-0.701536, -0.690305, 0.733525>, <-0.739363, -0.727527, 0.691321> }
triangle { <-0.739363, -0.727527, 0.691321>, <-0.743565, -0.644383, 0.662833>, <-0.705523, -0.611415, 0.708932> }
triangle { <-0.743565, -0.644383, 0.662833>, <-0.739363, -0.727527, 0.691321>, <-0.772632, -0.760263, 0.647034> }
triangle { <-0.772632, -0.760263, 0.647034>, <-0.777024, -0.673378, 0.614459>, <-0.743565, -0.644383, 0.662833> }
triangle { <-0.777024, -0.673378, 0.614459>, <-0.772632, -0.760263, 0.647034>, <-0.801138, -0.788313, 0.600938> }
triangle { <-0.801138, -0.788313, 0.600938>, <-0.805691, -0.698222, 0.564108>, <-0.777024, -0.673378, 0.614459> }
triangle { <-0.805691, -0.698222, 0.564108>, <-0.801138, -0.788313, 0.600938>, <-0.824705, -0.811502, 0.553316> }
triangle { <-0.824705, -0.811502, 0.553316>, <-0.829392, -0.718761, 0.512092>, <-0.805691, -0.698222, 0.564108> }
triangle { <-0.829392, -0.718761, 0.512092>, <-0.824705, -0.811502, 0.553316>, <-0.843186, -0.829688, 0.504463> }
triangle { <-0.843186, -0.829688, 0.504463>, <-0.847979, -0.734869, 0.458730>, <-0.829392, -0.718761, 0.512092> }
triangle { <-0.847979, -0.734869, 0.458730>, <-0.843186, -0.829688, 0.504463>, <-0.856470, -0.842758, 0.454680> }
triangle { <-0.856470, -0.842758, 0.454680>, <-0.861337, -0.746446, 0.404352>, <-0.847979, -0.734869, 0.458730> }
triangle { <-0.861337, -0.746446, 0.404352>, <-0.856470, -0.842758, 0.454680>, <-0.864473, -0.850633, 0.404273> }
triangle { <-0.864473, -0.850633, 0.404273>, <-0.869386, -0.753421, 0.349293>, <-0.861337, -0.746446, 0.404352> }
triangle { <-0.869386, -0.753421, 0.349293>, <-0.864473, -0.850633, 0.404273>, <-0.867146, -0.853263, 0.353553> }
triangle { <-0.867146, -0.853263, 0.353553>, <-0.872074, -0.755750, 0.293893>, <-0.869386, -0.753421, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.065647, -0.075592, 0.998164> }
triangle { <-0.065647, -0.075592, 0.998164>, <-0.068035, -0.066946, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.068035, -0.066946, 0.998007>, <-0.065647, -0.075592, 0.998164>, <-0.130890, -0.150718, 0.992669> }
triangle { <-0.130890, -0.150718, 0.992669>, <-0.135651, -0.133480, 0.992041>, <-0.068035, -0.066946, 0.998007> }
triangle { <-0.135651, -0.133480, 0.992041>, <-0.130890, -0.150718, 0.992669>, <-0.195326, -0.224914, 0.983547> }
triangle { <-0.195326, -0.224914, 0.983547>, <-0.202431, -0.199190, 0.982139>, <-0.135651, -0.133480, 0.992041> }
triangle { <-0.202431, -0.199190, 0.982139>, <-0.195326, -0.224914, 0.983547>, <-0.258557, -0.297724, 0.970855> }
triangle { <-0.258557, -0.297724, 0.970855>, <-0.267963, -0.263673, 0.968361>, <-0.202431, -0.199190, 0.982139> }
triangle { <-0.267963, -0.263673, 0.968361>, <-0.258557, -0.297724, 0.970855>, <-0.320195, -0.368698, 0.954671> }
triangle { <-0.320195, -0.368698, 0.954671>, <-0.331842, -0.326530, 0.950792>, <-0.267963, -0.263673, 0.968361> }
triangle { <-0.331842, -0.326530, 0.950792>, <-0.320195, -0.368698, 0.954671>, <-0.379858, -0.437400, 0.935095> }
triangle { <-0.379858, -0.437400, 0.935095>, <-0.393676, -0.387373, 0.929542>, <-0.331842, -0.326530, 0.950792> }
triangle { <-0.393676, -0.387373, 0.929542>, <-0.379858, -0.437400, 0.935095>, <-0.437179, -0.503404, 0.912248> }
triangle { <-0.437179, -0.503404, 0.912248>, <-0.453082, -0.445829, 0.904740>, <-0.393676, -0.387373, 0.929542> }
triangle { <-0.453082, -0.445829, 0.904740>, <-0.437179, -0.503404, 0.912248>, <-0.491805, -0.566305, 0.886271> }
triangle { <-0.491805, -0.566305, 0.886271>, <-0.509695, -0.501536, 0.876540>, <-0.453082, -0.445829, 0.904740> }
triangle { <-0.509695, -0.501536, 0.876540>, <-0.491805, -0.566305, 0.886271>, <-0.543399, -0.625714, 0.857324> }
triangle { <-0.543399, -0.625714, 0.857324>, <-0.563166, -0.554150, 0.845115>, <-0.509695, -0.501536, 0.876540> }
triangle { <-0.563166, -0.554150, 0.845115>, <-0.543399, -0.625714, 0.857324>, <-0.591642, -0.681266, 0.825585> }
triangle { <-0.591642, -0.681266, 0.825585>, <-0.613165, -0.603348, 0.810660>, <-0.563166, -0.554150, 0.845115> }
triangle { <-0.613165, -0.603348, 0.810660>, <-0.591642, -0.681266, 0.825585>, <-0.636238, -0.732617, 0.791249> }
triangle { <-0.636238, -0.732617, 0.791249>, <-0.659383, -0.648827, 0.773387>, <-0.613165, -0.603348, 0.810660> }
triangle { <-0.659383, -0.648827, 0.773387>, <-0.636238, -0.732617, 0.791249>, <-0.676912, -0.779452, 0.754530> }
triangle { <-0.676912, -0.779452, 0.754530>, <-0.701536, -0.690305, 0.733525>, <-0.659383, -0.648827, 0.773387> }
triangle { <-0.701536, -0.690305, 0.733525>, <-0.676912, -0.779452, 0.754530>, <-0.713412, -0.821481, 0.715652> }
triangle { <-0.713412, -0.821481, 0.715652>, <-0.739363, -0.727527, 0.691321>, <-0.701536, -0.690305, 0.733525> }
triangle { <-0.739363, -0.727527, 0.691321>, <-0.713412, -0.821481, 0.715652>, <-0.745513, -0.858445, 0.674856> }
triangle { <-0.745513, -0.858445, 0.674856>, <-0.772632, -0.760263, 0.647034>, <-0.739363, -0.727527, 0.691321> }
triangle { <-0.772632, -0.760263, 0.647034>, <-0.745513, -0.858445, 0.674856>, <-0.773018, -0.890117, 0.632393> }
triangle { <-0.773018, -0.890117, 0.632393>, <-0.801138, -0.788313, 0.600938>, <-0.772632, -0.760263, 0.647034> }
triangle { <-0.801138, -0.788313, 0.600938>, <-0.773018, -0.890117, 0.632393>, <-0.795757, -0.916301, 0.588525> }
triangle { <-0.795757, -0.916301, 0.588525>, <-0.824705, -0.811502, 0.553316>, <-0.801138, -0.788313, 0.600938> }
triangle { <-0.824705, -0.811502, 0.553316>, <-0.795757, -0.916301, 0.588525>, <-0.813590, -0.936835, 0.543523> }
triangle { <-0.813590, -0.936835, 0.543523>, <-0.843186, -0.829688, 0.504463>, <-0.824705, -0.811502, 0.553316> }
triangle { <-0.843186, -0.829688, 0.504463>, <-0.813590, -0.936835, 0.543523>, <-0.826408, -0.951594, 0.497664> }
triangle { <-0.826408, -0.951594, 0.497664>, <-0.856470, -0.842758, 0.454680>, <-0.843186, -0.829688, 0.504463> }
triangle { <-0.856470, -0.842758, 0.454680>, <-0.826408, -0.951594, 0.497664>, <-0.834129, -0.960486, 0.451230> }
triangle { <-0.834129, -0.960486, 0.451230>, <-0.864473, -0.850633, 0.404273>, <-0.856470, -0.842758, 0.454680> }
triangle { <-0.864473, -0.850633, 0.404273>, <-0.834129, -0.960486, 0.451230>, <-0.836709, -0.963456, 0.404508> }
triangle { <-0.836709, -0.963456, 0.404508>, <-0.867146, -0.853263, 0.353553>, <-0.864473, -0.850633, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.060926, -0.084472, 0.998291> }
triangle { <-0.060926, -0.084472, 0.998291>, <-0.065647, -0.075592, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.065647, -0.075592, 0.998164>, <-0.060926, -0.084472, 0.998291>, <-0.121476, -0.168423, 0.993173> }
triangle { <-0.121476, -0.168423, 0.993173>, <-0.130890, -0.150718, 0.992669>, <-0.065647, -0.075592, 0.998164> }
triangle { <-0.130890, -0.150718, 0.992669>, <-0.121476, -0.168423, 0.993173>, <-0.181277, -0.251335, 0.984679> }
triangle { <-0.181277, -0.251335, 0.984679>, <-0.195326, -0.224914, 0.983547>, <-0.130890, -0.150718, 0.992669> }
triangle { <-0.195326, -0.224914, 0.983547>, <-0.181277, -0.251335, 0.984679>, <-0.239960, -0.332698, 0.972861> }
triangle { <-0.239960, -0.332698, 0.972861>, <-0.258557, -0.297724, 0.970855>, <-0.195326, -0.224914, 0.983547> }
triangle { <-0.258557, -0.297724, 0.970855>, <-0.239960, -0.332698, 0.972861>, <-0.297164, -0.412010, 0.957791> }
triangle { <-0.297164, -0.412010, 0.957791>, <-0.320195, -0.368698, 0.954671>, <-0.258557, -0.297724, 0.970855> }
triangle { <-0.320195, -0.368698, 0.954671>, <-0.297164, -0.412010, 0.957791>, <-0.352536, -0.488782, 0.939563> }
triangle { <-0.352536, -0.488782, 0.939563>, <-0.379858, -0.437400, 0.935095>, <-0.320195, -0.368698, 0.954671> }
triangle { <-0.379858, -0.437400, 0.935095>, <-0.352536, -0.488782, 0.939563>, <-0.405734, -0.562540, 0.918289> }
triangle { <-0.405734, -0.562540, 0.918289>, <-0.437179, -0.503404, 0.912248>, <-0.379858, -0.437400, 0.935095> }
triangle { <-0.437179, -0.503404, 0.912248>, <-0.405734, -0.562540, 0.918289>, <-0.456431, -0.632830, 0.894101> }
triangle { <-0.456431, -0.632830, 0.894101>, <-0.491805, -0.566305, 0.886271>, <-0.437179, -0.503404, 0.912248> }
triangle { <-0.491805, -0.566305, 0.886271>, <-0.456431, -0.632830, 0.894101>, <-0.504314, -0.699218, 0.867146> }
triangle { <-0.504314, -0.699218, 0.867146>, <-0.543399, -0.625714, 0.857324>, <-0.491805, -0.566305, 0.886271> }
triangle { <-0.543399, -0.625714, 0.857324>, <-0.504314, -0.699218, 0.867146>, <-0.549088, -0.761296, 0.837592> }
triangle { <-0.549088, -0.761296, 0.837592>, <-0.591642, -0.681266, 0.825585>, <-0.543399, -0.625714, 0.857324> }
triangle { <-0.591642, -0.681266, 0.825585>, <-0.549088, -0.761296, 0.837592>, <-0.590476, -0.818679, 0.805620> }
triangle { <-0.590476, -0.818679, 0.805620>, <-0.636238, -0.732617, 0.791249>, <-0.591642, -0.681266, 0.825585> }
triangle { <-0.636238, -0.732617, 0.791249>, <-0.590476, -0.818679, 0.805620>, <-0.628224, -0.871016, 0.771428> }
triangle { <-0.628224, -0.871016, 0.771428>, <-0.676912, -0.779452, 0.754530>, <-0.636238, -0.732617, 0.791249> }
triangle { <-0.676912, -0.779452, 0.754530>, <-0.628224, -0.871016, 0.771428>, <-0.662098, -0.917982, 0.735227> }
triangle { <-0.662098, -0.917982, 0.735227>, <-0.713412, -0.821481, 0.715652>, <-0.676912, -0.779452, 0.754530> }
triangle { <-0.713412, -0.821481, 0.715652>, <-0.662098, -0.917982, 0.735227>, <-0.691891, -0.959289, 0.697240> }
triangle { <-0.691891, -0.959289, 0.697240>, <-0.745513, -0.858445, 0.674856>, <-0.713412, -0.821481, 0.715652> }
triangle { <-0.745513, -0.858445, 0.674856>, <-0.691891, -0.959289, 0.697240>, <-0.717418, -0.994681, 0.657700> }
triangle { <-0.717418, -0.994681, 0.657700>, <-0.773018, -0.890117, 0.632393>, <-0.745513, -0.858445, 0.674856> }
triangle { <-0.773018, -0.890117, 0.632393>, <-0.717418, -0.994681, 0.657700>, <-0.738521, -1.023940, 0.616852> }
triangle { <-0.738521, -1.023940, 0.616852>, <-0.795757, -0.916301, 0.588525>, <-0.773018, -0.890117, 0.632393> }
triangle { <-0.795757, -0.916301, 0.588525>, <-0.738521, -1.023940, 0.616852>, <-0.755072, -1.046887, 0.574948> }
triangle { <-0.755072, -1.046887, 0.574948>, <-0.813590, -0.936835, 0.543523>, <-0.795757, -0.916301, 0.588525> }
triangle { <-0.813590, -0.936835, 0.543523>, <-0.755072, -1.046887, 0.574948>, <-0.766967, -1.063380, 0.532246> }
triangle { <-0.766967, -1.063380, 0.532246>, <-0.826408, -0.951594, 0.497664>, <-0.813590, -0.936835, 0.543523> }
triangle { <-0.826408, -0.951594, 0.497664>, <-0.766967, -1.063380, 0.532246>, <-0.774134, -1.073316, 0.489009> }
triangle { <-0.774134, -1.073316, 0.489009>, <-0.834129, -0.960486, 0.451230>, <-0.826408, -0.951594, 0.497664> }
triangle { <-0.834129, -0.960486, 0.451230>, <-0.774134, -1.073316, 0.489009>, <-0.776527, -1.076635, 0.445503> }
triangle { <-0.776527, -1.076635, 0.445503>, <-0.836709, -0.963456, 0.404508>, <-0.834129, -0.960486, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.053838, -0.092750, 0.998383> }
triangle { <-0.053838, -0.092750, 0.998383>, <-0.060926, -0.084472, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.060926, -0.084472, 0.998291>, <-0.053838, -0.092750, 0.998383>, <-0.107345, -0.184928, 0.993543> }
triangle { <-0.107345, -0.184928, 0.993543>, <-0.121476, -0.168423, 0.993173>, <-0.060926, -0.084472, 0.998291> }
triangle { <-0.121476, -0.168423, 0.993173>, <-0.107345, -0.184928, 0.993543>, <-0.160189, -0.275966, 0.985509> }
triangle { <-0.160189, -0.275966, 0.985509>, <-0.181277, -0.251335, 0.984679>, <-0.121476, -0.168423, 0.993173> }
triangle { <-0.181277, -0.251335, 0.984679>, <-0.160189, -0.275966, 0.985509>, <-0.212046, -0.365302, 0.974331> }
triangle { <-0.212046, -0.365302, 0.974331>, <-0.239960, -0.332698, 0.972861>, <-0.181277, -0.251335, 0.984679> }
triangle { <-0.239960, -0.332698, 0.972861>, <-0.212046, -0.365302, 0.974331>, <-0.262596, -0.452387, 0.960077> }
triangle { <-0.262596, -0.452387, 0.960077>, <-0.297164, -0.412010, 0.957791>, <-0.239960, -0.332698, 0.972861> }
triangle { <-0.297164, -0.412010, 0.957791>, <-0.262596, -0.452387, 0.960077>, <-0.311527, -0.536682, 0.942836> }
triangle { <-0.311527, -0.536682, 0.942836>, <-0.352536, -0.488782, 0.939563>, <-0.297164, -0.412010, 0.957791> }
triangle { <-0.352536, -0.488782, 0.939563>, <-0.311527, -0.536682, 0.942836>, <-0.358537, -0.617668, 0.922714> }
triangle { <-0.358537, -0.617668, 0.922714>, <-0.405734, -0.562540, 0.918289>, <-0.352536, -0.488782, 0.939563> }
triangle { <-0.405734, -0.562540, 0.918289>, <-0.358537, -0.617668, 0.922714>, <-0.403336, -0.694846, 0.899835> }
triangle { <-0.403336, -0.694846, 0.899835>, <-0.456431, -0.632830, 0.894101>, <-0.405734, -0.562540, 0.918289> }
triangle { <-0.456431, -0.632830, 0.894101>, <-0.403336, -0.694846, 0.899835>, <-0.445649, -0.767741, 0.874340> }
triangle { <-0.445649, -0.767741, 0.874340>, <-0.504314, -0.699218, 0.867146>, <-0.456431, -0.632830, 0.894101> }
triangle { <-0.504314, -0.699218, 0.867146>, <-0.445649, -0.767741, 0.874340>, <-0.485214, -0.835901, 0.846386> }
triangle { <-0.485214, -0.835901, 0.846386>, <-0.549088, -0.761296, 0.837592>, <-0.504314, -0.699218, 0.867146> }
triangle { <-0.549088, -0.761296, 0.837592>, <-0.485214, -0.835901, 0.846386>, <-0.521788, -0.898909, 0.816145> }
triangle { <-0.521788, -0.898909, 0.816145>, <-0.590476, -0.818679, 0.805620>, <-0.549088, -0.761296, 0.837592> }
triangle { <-0.590476, -0.818679, 0.805620>, <-0.521788, -0.898909, 0.816145>, <-0.555145, -0.956374, 0.783805> }
triangle { <-0.555145, -0.956374, 0.783805>, <-0.628224, -0.871016, 0.771428>, <-0.590476, -0.818679, 0.805620> }
triangle { <-0.628224, -0.871016, 0.771428>, <-0.555145, -0.956374, 0.783805>, <-0.585079, -1.007943, 0.749564> }
triangle { <-0.585079, -1.007943, 0.749564>, <-0.662098, -0.917982, 0.735227>, <-0.628224, -0.871016, 0.771428> }
triangle { <-0.662098, -0.917982, 0.735227>, <-0.585079, -1.007943, 0.749564>, <-0.611406, -1.053297, 0.713633> }
triangle { <-0.611406, -1.053297, 0.713633>, <-0.691891, -0.959289, 0.697240>, <-0.662098, -0.917982, 0.735227> }
triangle { <-0.691891, -0.959289, 0.697240>, <-0.611406, -1.053297, 0.713633>, <-0.633963, -1.092158, 0.676235> }
triangle { <-0.633963, -1.092158, 0.676235>, <-0.717418, -0.994681, 0.657700>, <-0.691891, -0.959289, 0.697240> }
triangle { <-0.717418, -0.994681, 0.657700>, <-0.633963, -1.092158, 0.676235>, <-0.652612, -1.124285, 0.637599> }
triangle { <-0.652612, -1.124285, 0.637599>, <-0.738521, -1.023940, 0.616852>, <-0.717418, -0.994681, 0.657700> }
triangle { <-0.738521, -1.023940, 0.616852>, <-0.652612, -1.124285, 0.637599>, <-0.667237, -1.149480, 0.597964> }
triangle { <-0.667237, -1.149480, 0.597964>, <-0.755072, -1.046887, 0.574948>, <-0.738521, -1.023940, 0.616852> }
triangle { <-0.755072, -1.046887, 0.574948>, <-0.667237, -1.149480, 0.597964>, <-0.677748, -1.167589, 0.557574> }
triangle { <-0.677748, -1.167589, 0.557574>, <-0.766967, -1.063380, 0.532246>, <-0.755072, -1.046887, 0.574948> }
triangle { <-0.766967, -1.063380, 0.532246>, <-0.677748, -1.167589, 0.557574>, <-0.684081, -1.178499, 0.516678> }
triangle { <-0.684081, -1.178499, 0.516678>, <-0.774134, -1.073316, 0.489009>, <-0.766967, -1.063380, 0.532246> }
triangle { <-0.774134, -1.073316, 0.489009>, <-0.684081, -1.178499, 0.516678>, <-0.686196, -1.182143, 0.475528> }
triangle { <-0.686196, -1.182143, 0.475528>, <-0.776527, -1.076635, 0.445503>, <-0.774134, -1.073316, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.044662, -0.099630, 0.998440> }
triangle { <-0.044662, -0.099630, 0.998440>, <-0.053838, -0.092750, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.053838, -0.092750, 0.998383>, <-0.044662, -0.099630, 0.998440>, <-0.089048, -0.198646, 0.993768> }
triangle { <-0.089048, -0.198646, 0.993768>, <-0.107345, -0.184928, 0.993543>, <-0.053838, -0.092750, 0.998383> }
triangle { <-0.107345, -0.184928, 0.993543>, <-0.089048, -0.198646, 0.993768>, <-0.132885, -0.296437, 0.986015> }
triangle { <-0.132885, -0.296437, 0.986015>, <-0.160189, -0.275966, 0.985509>, <-0.107345, -0.184928, 0.993543> }
triangle { <-0.160189, -0.275966, 0.985509>, <-0.132885, -0.296437, 0.986015>, <-0.175903, -0.392400, 0.975227> }
triangle { <-0.175903, -0.392400, 0.975227>, <-0.212046, -0.365302, 0.974331>, <-0.160189, -0.275966, 0.985509> }
triangle { <-0.212046, -0.365302, 0.974331>, <-0.175903, -0.392400, 0.975227>, <-0.217837, -0.485945, 0.961471> }
triangle { <-0.217837, -0.485945, 0.961471>, <-0.262596, -0.452387, 0.960077>, <-0.212046, -0.365302, 0.974331> }
triangle { <-0.262596, -0.452387, 0.960077>, <-0.217837, -0.485945, 0.961471>, <-0.258427, -0.576493, 0.944832> }
triangle { <-0.258427, -0.576493, 0.944832>, <-0.311527, -0.536682, 0.942836>, <-0.262596, -0.452387, 0.960077> }
triangle { <-0.311527, -0.536682, 0.942836>, <-0.258427, -0.576493, 0.944832>, <-0.297424, -0.663487, 0.925413> }
triangle { <-0.297424, -0.663487, 0.925413>, <-0.358537, -0.617668, 0.922714>, <-0.311527, -0.536682, 0.942836> }
triangle { <-0.358537, -0.617668, 0.922714>, <-0.297424, -0.663487, 0.925413>, <-0.334588, -0.746390, 0.903333> }
triangle { <-0.334588, -0.746390, 0.903333>, <-0.403336, -0.694846, 0.899835>, <-0.358537, -0.617668, 0.922714> }
triangle { <-0.403336, -0.694846, 0.899835>, <-0.334588, -0.746390, 0.903333>, <-0.369688, -0.824691, 0.878728> }
triangle { <-0.369688, -0.824691, 0.878728>, <-0.445649, -0.767741, 0.874340>, <-0.403336, -0.694846, 0.899835> }
triangle { <-0.445649, -0.767741, 0.874340>, <-0.369688, -0.824691, 0.878728>, <-0.402509, -0.897909, 0.851750> }
triangle { <-0.402509, -0.897909, 0.851750>, <-0.485214, -0.835901, 0.846386>, <-0.445649, -0.767741, 0.874340> }
triangle { <-0.485214, -0.835901, 0.846386>, <-0.402509, -0.897909, 0.851750>, <-0.432849, -0.965590, 0.822566> }
triangle { <-0.432849, -0.965590, 0.822566>, <-0.521788, -0.898909, 0.816145>, <-0.485214, -0.835901, 0.846386> }
triangle { <-0.521788, -0.898909, 0.816145>, <-0.432849, -0.965590, 0.822566>, <-0.460520, -1.027318, 0.791355> }
triangle { <-0.460520, -1.027318, 0.791355>, <-0.555145, -0.956374, 0.783805>, <-0.521788, -0.898909, 0.816145> }
triangle { <-0.555145, -0.956374, 0.783805>, <-0.460520, -1.027318, 0.791355>, <-0.485352, -1.082712, 0.758310> }
triangle { <-0.485352, -1.082712, 0.758310>, <-0.585079, -1.007943, 0.749564>, <-0.555145, -0.956374, 0.783805> }
triangle { <-0.585079, -1.007943, 0.749564>, <-0.485352, -1.082712, 0.758310>, <-0.507191, -1.131431, 0.723634> }
triangle { <-0.507191, -1.131431, 0.723634>, <-0.611406, -1.053297, 0.713633>, <-0.585079, -1.007943, 0.749564> }
triangle { <-0.611406, -1.053297, 0.713633>, <-0.507191, -1.131431, 0.723634>, <-0.525904, -1.173174, 0.687542> }
triangle { <-0.525904, -1.173174, 0.687542>, <-0.633963, -1.092158, 0.676235>, <-0.611406, -1.053297, 0.713633> }
triangle { <-0.633963, -1.092158, 0.676235>, <-0.525904, -1.173174, 0.687542>, <-0.541374, -1.207684, 0.650255> }
triangle { <-0.541374, -1.207684, 0.650255>, <-0.652612, -1.124285, 0.637599>, <-0.633963, -1.092158, 0.676235> }
triangle { <-0.652612, -1.124285, 0.637599>, <-0.541374, -1.207684, 0.650255>, <-0.553506, -1.234749, 0.612004> }
triangle { <-0.553506, -1.234749, 0.612004>, <-0.667237, -1.149480, 0.597964>, <-0.652612, -1.124285, 0.637599> }
triangle { <-0.667237, -1.149480, 0.597964>, <-0.553506, -1.234749, 0.612004>, <-0.562226, -1.254201, 0.573024> }
triangle { <-0.562226, -1.254201, 0.573024>, <-0.677748, -1.167589, 0.557574>, <-0.667237, -1.149480, 0.597964> }
triangle { <-0.677748, -1.167589, 0.557574>, <-0.562226, -1.254201, 0.573024>, <-0.567480, -1.265920, 0.533557> }
triangle { <-0.567480, -1.265920, 0.533557>, <-0.684081, -1.178499, 0.516678>, <-0.677748, -1.167589, 0.557574> }
triangle { <-0.684081, -1.178499, 0.516678>, <-0.567480, -1.265920, 0.533557>, <-0.569234, -1.269834, 0.493844> }
triangle { <-0.569234, -1.269834, 0.493844>, <-0.686196, -1.182143, 0.475528>, <-0.684081, -1.178499, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.033943, -0.104467, 0.998459> }
triangle { <-0.033943, -0.104467, 0.998459>, <-0.044662, -0.099630, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.044662, -0.099630, 0.998440>, <-0.033943, -0.104467, 0.998459>, <-0.067677, -0.208289, 0.993844> }
triangle { <-0.067677, -0.208289, 0.993844>, <-0.089048, -0.198646, 0.993768>, <-0.044662, -0.099630, 0.998440> }
triangle { <-0.089048, -0.198646, 0.993768>, <-0.067677, -0.208289, 0.993844>, <-0.100994, -0.310828, 0.986185> }
triangle { <-0.100994, -0.310828, 0.986185>, <-0.132885, -0.296437, 0.986015>, <-0.089048, -0.198646, 0.993768> }
triangle { <-0.132885, -0.296437, 0.986015>, <-0.100994, -0.310828, 0.986185>, <-0.133688, -0.411450, 0.975528> }
triangle { <-0.133688, -0.411450, 0.975528>, <-0.175903, -0.392400, 0.975227>, <-0.132885, -0.296437, 0.986015> }
triangle { <-0.175903, -0.392400, 0.975227>, <-0.133688, -0.411450, 0.975528>, <-0.165558, -0.509535, 0.961940> }
triangle { <-0.165558, -0.509535, 0.961940>, <-0.217837, -0.485945, 0.961471>, <-0.175903, -0.392400, 0.975227> }
triangle { <-0.217837, -0.485945, 0.961471>, <-0.165558, -0.509535, 0.961940>, <-0.196407, -0.604479, 0.945503> }
triangle { <-0.196407, -0.604479, 0.945503>, <-0.258427, -0.576493, 0.944832>, <-0.217837, -0.485945, 0.961471> }
triangle { <-0.258427, -0.576493, 0.944832>, <-0.196407, -0.604479, 0.945503>, <-0.226045, -0.695696, 0.926320> }
triangle { <-0.226045, -0.695696, 0.926320>, <-0.297424, -0.663487, 0.925413>, <-0.258427, -0.576493, 0.944832> }
triangle { <-0.297424, -0.663487, 0.925413>, <-0.226045, -0.695696, 0.926320>, <-0.254290, -0.782624, 0.904508> }
triangle { <-0.254290, -0.782624, 0.904508>, <-0.334588, -0.746390, 0.903333>, <-0.297424, -0.663487, 0.925413> }
triangle { <-0.334588, -0.746390, 0.903333>, <-0.254290, -0.782624, 0.904508>, <-0.280967, -0.864727, 0.880203> }
triangle { <-0.280967, -0.864727, 0.880203>, <-0.369688, -0.824691, 0.878728>, <-0.334588, -0.746390, 0.903333> }
triangle { <-0.369688, -0.824691, 0.878728>, <-0.280967, -0.864727, 0.880203>, <-0.305911, -0.941498, 0.853553> }
triangle { <-0.305911, -0.941498, 0.853553>, <-0.402509, -0.897909, 0.851750>, <-0.369688, -0.824691, 0.878728> }
triangle { <-0.402509, -0.897909, 0.851750>, <-0.305911, -0.941498, 0.853553>, <-0.328970, -1.012465, 0.824724> }
triangle { <-0.328970, -1.012465, 0.824724>, <-0.432849, -0.965590, 0.822566>, <-0.402509, -0.897909, 0.851750> }
triangle { <-0.432849, -0.965590, 0.822566>, <-0.328970, -1.012465, 0.824724>, <-0.350000, -1.077189, 0.793893> }
triangle { <-0.350000, -1.077189, 0.793893>, <-0.460520, -1.027318, 0.791355>, <-0.432849, -0.965590, 0.822566> }
triangle { <-0.460520, -1.027318, 0.791355>, <-0.350000, -1.077189, 0.793893>, <-0.368872, -1.135273, 0.761249> }
triangle { <-0.368872, -1.135273, 0.761249>, <-0.485352, -1.082712, 0.758310>, <-0.460520, -1.027318, 0.791355> }
triangle { <-0.485352, -1.082712, 0.758310>, <-0.368872, -1.135273, 0.761249>, <-0.385471, -1.186357, 0.726995> }
triangle { <-0.385471, -1.186357, 0.726995>, <-0.507191, -1.131431, 0.723634>, <-0.485352, -1.082712, 0.758310> }
triangle { <-0.507191, -1.131431, 0.723634>, <-0.385471, -1.186357, 0.726995>, <-0.399692, -1.230126, 0.691342> }
triangle { <-0.399692, -1.230126, 0.691342>, <-0.525904, -1.173174, 0.687542>, <-0.507191, -1.131431, 0.723634> }
triangle { <-0.525904, -1.173174, 0.687542>, <-0.399692, -1.230126, 0.691342>, <-0.411450, -1.266312, 0.654508> }
triangle { <-0.411450, -1.266312, 0.654508>, <-0.541374, -1.207684, 0.650255>, <-0.525904, -1.173174, 0.687542> }
triangle { <-0.541374, -1.207684, 0.650255>, <-0.411450, -1.266312, 0.654508>, <-0.420670, -1.294690, 0.616723> }
triangle { <-0.420670, -1.294690, 0.616723>, <-0.553506, -1.234749, 0.612004>, <-0.541374, -1.207684, 0.650255> }
triangle { <-0.553506, -1.234749, 0.612004>, <-0.420670, -1.294690, 0.616723>, <-0.427297, -1.315086, 0.578217> }
triangle { <-0.427297, -1.315086, 0.578217>, <-0.562226, -1.254201, 0.573024>, <-0.553506, -1.234749, 0.612004> }
triangle { <-0.562226, -1.254201, 0.573024>, <-0.427297, -1.315086, 0.578217>, <-0.431290, -1.327375, 0.539230> }
triangle { <-0.431290, -1.327375, 0.539230>, <-0.567480, -1.265920, 0.533557>, <-0.562226, -1.254201, 0.573024> }
triangle { <-0.567480, -1.265920, 0.533557>, <-0.431290, -1.327375, 0.539230>, <-0.432624, -1.331479, 0.500000> }
triangle { <-0.432624, -1.331479, 0.500000>, <-0.569234, -1.269834, 0.493844>, <-0.567480, -1.265920, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.022429, -0.106854, 0.998440> }
triangle { <-0.022429, -0.106854, 0.998440>, <-0.033943, -0.104467, 0.998459>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.033943, -0.104467, 0.998459>, <-0.022429, -0.106854, 0.998440>, <-0.044720, -0.213049, 0.993768> }
triangle { <-0.044720, -0.213049, 0.993768>, <-0.067677, -0.208289, 0.993844>, <-0.033943, -0.104467, 0.998459> }
triangle { <-0.067677, -0.208289, 0.993844>, <-0.044720, -0.213049, 0.993768>, <-0.066735, -0.317930, 0.986015> }
triangle { <-0.066735, -0.317930, 0.986015>, <-0.100994, -0.310828, 0.986185>, <-0.067677, -0.208289, 0.993844> }
triangle { <-0.100994, -0.310828, 0.986185>, <-0.066735, -0.317930, 0.986015>, <-0.088339, -0.420852, 0.975227> }
triangle { <-0.088339, -0.420852, 0.975227>, <-0.133688, -0.411450, 0.975528>, <-0.100994, -0.310828, 0.986185> }
triangle { <-0.133688, -0.411450, 0.975528>, <-0.088339, -0.420852, 0.975227>, <-0.109398, -0.521179, 0.961471> }
triangle { <-0.109398, -0.521179, 0.961471>, <-0.165558, -0.509535, 0.961940>, <-0.133688, -0.411450, 0.975528> }
triangle { <-0.165558, -0.509535, 0.961940>, <-0.109398, -0.521179, 0.961471>, <-0.129782, -0.618292, 0.944832> }
triangle { <-0.129782, -0.618292, 0.944832>, <-0.196407, -0.604479, 0.945503>, <-0.165558, -0.509535, 0.961940> }
triangle { <-0.196407, -0.604479, 0.945503>, <-0.129782, -0.618292, 0.944832>, <-0.149367, -0.711593, 0.925413> }
triangle { <-0.149367, -0.711593, 0.925413>, <-0.226045, -0.695696, 0.926320>, <-0.196407, -0.604479, 0.945503> }
triangle { <-0.226045, -0.695696, 0.926320>, <-0.149367, -0.711593, 0.925413>, <-0.168030, -0.800508, 0.903333> }
triangle { <-0.168030, -0.800508, 0.903333>, <-0.254290, -0.782624, 0.904508>, <-0.226045, -0.695696, 0.926320> }
triangle { <-0.254290, -0.782624, 0.904508>, <-0.168030, -0.800508, 0.903333>, <-0.185658, -0.884487, 0.878728> }
triangle { <-0.185658, -0.884487, 0.878728>, <-0.280967, -0.864727, 0.880203>, <-0.254290, -0.782624, 0.904508> }
triangle { <-0.280967, -0.864727, 0.880203>, <-0.185658, -0.884487, 0.878728>, <-0.202140, -0.963012, 0.851750> }
triangle { <-0.202140, -0.963012, 0.851750>, <-0.305911, -0.941498, 0.853553>, <-0.280967, -0.864727, 0.880203> }
triangle { <-0.305911, -0.941498, 0.853553>, <-0.202140, -0.963012, 0.851750>, <-0.217377, -1.035601, 0.822566> }
triangle { <-0.217377, -1.035601, 0.822566>, <-0.328970, -1.012465, 0.824724>, <-0.305911, -0.941498, 0.853553> }
triangle { <-0.328970, -1.012465, 0.824724>, <-0.217377, -1.035601, 0.822566>, <-0.231273, -1.101804, 0.791355> }
triangle { <-0.231273, -1.101804, 0.791355>, <-0.350000, -1.077189, 0.793893>, <-0.328970, -1.012465, 0.824724> }
triangle { <-0.350000, -1.077189, 0.793893>, <-0.231273, -1.101804, 0.791355>, <-0.243744, -1.161215, 0.758310> }
triangle { <-0.243744, -1.161215, 0.758310>, <-0.368872, -1.135273, 0.761249>, <-0.350000, -1.077189, 0.793893> }
triangle { <-0.368872, -1.135273, 0.761249>, <-0.243744, -1.161215, 0.758310>, <-0.254712, -1.213466, 0.723634> }
triangle { <-0.254712, -1.213466, 0.723634>, <-0.385471, -1.186357, 0.726995>, <-0.368872, -1.135273, 0.761249> }
triangle { <-0.385471, -1.186357, 0.726995>, <-0.254712, -1.213466, 0.723634>, <-0.264109, -1.258236, 0.687542> }
triangle { <-0.264109, -1.258236, 0.687542>, <-0.399692, -1.230126, 0.691342>, <-0.385471, -1.186357, 0.726995> }
triangle { <-0.399692, -1.230126, 0.691342>, <-0.264109, -1.258236, 0.687542>, <-0.271878, -1.295249, 0.650255> }
triangle { <-0.271878, -1.295249, 0.650255>, <-0.411450, -1.266312, 0.654508>, <-0.399692, -1.230126, 0.691342> }
triangle { <-0.411450, -1.266312, 0.654508>, <-0.271878, -1.295249, 0.650255>, <-0.277971, -1.324276, 0.612004> }
triangle { <-0.277971, -1.324276, 0.612004>, <-0.420670, -1.294690, 0.616723>, <-0.411450, -1.266312, 0.654508> }
triangle { <-0.420670, -1.294690, 0.616723>, <-0.277971, -1.324276, 0.612004>, <-0.282350, -1.345138, 0.573024> }
triangle { <-0.282350, -1.345138, 0.573024>, <-0.427297, -1.315086, 0.578217>, <-0.420670, -1.294690, 0.616723> }
triangle { <-0.427297, -1.315086, 0.578217>, <-0.282350, -1.345138, 0.573024>, <-0.284989, -1.357707, 0.533557> }
triangle { <-0.284989, -1.357707, 0.533557>, <-0.431290, -1.327375, 0.539230>, <-0.427297, -1.315086, 0.578217> }
triangle { <-0.431290, -1.327375, 0.539230>, <-0.284989, -1.357707, 0.533557>, <-0.285870, -1.361905, 0.493844> }
triangle { <-0.285870, -1.361905, 0.493844>, <-0.432624, -1.331479, 0.500000>, <-0.431290, -1.327375, 0.539230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.010961, -0.106682, 0.998383> }
triangle { <-0.010961, -0.106682, 0.998383>, <-0.022429, -0.106854, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.022429, -0.106854, 0.998440>, <-0.010961, -0.106682, 0.998383>, <-0.021854, -0.212706, 0.993543> }
triangle { <-0.021854, -0.212706, 0.993543>, <-0.044720, -0.213049, 0.993768>, <-0.022429, -0.106854, 0.998440> }
triangle { <-0.044720, -0.213049, 0.993768>, <-0.021854, -0.212706, 0.993543>, <-0.032613, -0.317418, 0.985509> }
triangle { <-0.032613, -0.317418, 0.985509>, <-0.066735, -0.317930, 0.986015>, <-0.044720, -0.213049, 0.993768> }
triangle { <-0.066735, -0.317930, 0.986015>, <-0.032613, -0.317418, 0.985509>, <-0.043170, -0.420174, 0.974331> }
triangle { <-0.043170, -0.420174, 0.974331>, <-0.088339, -0.420852, 0.975227>, <-0.066735, -0.317930, 0.986015> }
triangle { <-0.088339, -0.420852, 0.975227>, <-0.043170, -0.420174, 0.974331>, <-0.053462, -0.520339, 0.960077> }
triangle { <-0.053462, -0.520339, 0.960077>, <-0.109398, -0.521179, 0.961471>, <-0.088339, -0.420852, 0.975227> }
triangle { <-0.109398, -0.521179, 0.961471>, <-0.053462, -0.520339, 0.960077>, <-0.063423, -0.617295, 0.942836> }
triangle { <-0.063423, -0.617295, 0.942836>, <-0.129782, -0.618292, 0.944832>, <-0.109398, -0.521179, 0.961471> }
triangle { <-0.129782, -0.618292, 0.944832>, <-0.063423, -0.617295, 0.942836>, <-0.072994, -0.710447, 0.922714> }
triangle { <-0.072994, -0.710447, 0.922714>, <-0.149367, -0.711593, 0.925413>, <-0.129782, -0.618292, 0.944832> }
triangle { <-0.149367, -0.711593, 0.925413>, <-0.072994, -0.710447, 0.922714>, <-0.082115, -0.799218, 0.899835> }
triangle { <-0.082115, -0.799218, 0.899835>, <-0.168030, -0.800508, 0.903333>, <-0.149367, -0.711593, 0.925413> }
triangle { <-0.168030, -0.800508, 0.903333>, <-0.082115, -0.799218, 0.899835>, <-0.090729, -0.883061, 0.874340> }
triangle { <-0.090729, -0.883061, 0.874340>, <-0.185658, -0.884487, 0.878728>, <-0.168030, -0.800508, 0.903333> }
triangle { <-0.185658, -0.884487, 0.878728>, <-0.090729, -0.883061, 0.874340>, <-0.098784, -0.961460, 0.846386> }
triangle { <-0.098784, -0.961460, 0.846386>, <-0.202140, -0.963012, 0.851750>, <-0.185658, -0.884487, 0.878728> }
triangle { <-0.202140, -0.963012, 0.851750>, <-0.098784, -0.961460, 0.846386>, <-0.106230, -1.033932, 0.816145> }
triangle { <-0.106230, -1.033932, 0.816145>, <-0.217377, -1.035601, 0.822566>, <-0.202140, -0.963012, 0.851750> }
triangle { <-0.217377, -1.035601, 0.822566>, <-0.106230, -1.033932, 0.816145>, <-0.113021, -1.100029, 0.783805> }
triangle { <-0.113021, -1.100029, 0.783805>, <-0.231273, -1.101804, 0.791355>, <-0.217377, -1.035601, 0.822566> }
triangle { <-0.231273, -1.101804, 0.791355>, <-0.113021, -1.100029, 0.783805>, <-0.119115, -1.159343, 0.749564> }
triangle { <-0.119115, -1.159343, 0.749564>, <-0.243744, -1.161215, 0.758310>, <-0.231273, -1.101804, 0.791355> }
triangle { <-0.243744, -1.161215, 0.758310>, <-0.119115, -1.159343, 0.749564>, <-0.124475, -1.211511, 0.713633> }
triangle { <-0.124475, -1.211511, 0.713633>, <-0.254712, -1.213466, 0.723634>, <-0.243744, -1.161215, 0.758310> }
triangle { <-0.254712, -1.213466, 0.723634>, <-0.124475, -1.211511, 0.713633>, <-0.129068, -1.256208, 0.676235> }
triangle { <-0.129068, -1.256208, 0.676235>, <-0.264109, -1.258236, 0.687542>, <-0.254712, -1.213466, 0.723634> }
triangle { <-0.264109, -1.258236, 0.687542>, <-0.129068, -1.256208, 0.676235>, <-0.132864, -1.293161, 0.637599> }
triangle { <-0.132864, -1.293161, 0.637599>, <-0.271878, -1.295249, 0.650255>, <-0.264109, -1.258236, 0.687542> }
triangle { <-0.271878, -1.295249, 0.650255>, <-0.132864, -1.293161, 0.637599>, <-0.135842, -1.322141, 0.597964> }
triangle { <-0.135842, -1.322141, 0.597964>, <-0.277971, -1.324276, 0.612004>, <-0.271878, -1.295249, 0.650255> }
triangle { <-0.277971, -1.324276, 0.612004>, <-0.135842, -1.322141, 0.597964>, <-0.137982, -1.342970, 0.557574> }
triangle { <-0.137982, -1.342970, 0.557574>, <-0.282350, -1.345138, 0.573024>, <-0.277971, -1.324276, 0.612004> }
triangle { <-0.282350, -1.345138, 0.573024>, <-0.137982, -1.342970, 0.557574>, <-0.139271, -1.355519, 0.516678> }
triangle { <-0.139271, -1.355519, 0.516678>, <-0.284989, -1.357707, 0.533557>, <-0.282350, -1.345138, 0.573024> }
triangle { <-0.284989, -1.357707, 0.533557>, <-0.139271, -1.355519, 0.516678>, <-0.139702, -1.359710, 0.475528> }
triangle { <-0.139702, -1.359710, 0.475528>, <-0.285870, -1.361905, 0.493844>, <-0.284989, -1.357707, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000361, -0.104150, 0.998291> }
triangle { <-0.000361, -0.104150, 0.998291>, <-0.010961, -0.106682, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.010961, -0.106682, 0.998383>, <-0.000361, -0.104150, 0.998291>, <-0.000721, -0.207658, 0.993173> }
triangle { <-0.000721, -0.207658, 0.993173>, <-0.021854, -0.212706, 0.993543>, <-0.010961, -0.106682, 0.998383> }
triangle { <-0.021854, -0.212706, 0.993543>, <-0.000721, -0.207658, 0.993173>, <-0.001075, -0.309886, 0.984679> }
triangle { <-0.001075, -0.309886, 0.984679>, <-0.032613, -0.317418, 0.985509>, <-0.021854, -0.212706, 0.993543> }
triangle { <-0.032613, -0.317418, 0.985509>, <-0.001075, -0.309886, 0.984679>, <-0.001423, -0.410204, 0.972861> }
triangle { <-0.001423, -0.410204, 0.972861>, <-0.043170, -0.420174, 0.974331>, <-0.032613, -0.317418, 0.985509> }
triangle { <-0.043170, -0.420174, 0.974331>, <-0.001423, -0.410204, 0.972861>, <-0.001763, -0.507992, 0.957791> }
triangle { <-0.001763, -0.507992, 0.957791>, <-0.053462, -0.520339, 0.960077>, <-0.043170, -0.420174, 0.974331> }
triangle { <-0.053462, -0.520339, 0.960077>, <-0.001763, -0.507992, 0.957791>, <-0.002091, -0.602648, 0.939563> }
triangle { <-0.002091, -0.602648, 0.939563>, <-0.063423, -0.617295, 0.942836>, <-0.053462, -0.520339, 0.960077> }
triangle { <-0.063423, -0.617295, 0.942836>, <-0.002091, -0.602648, 0.939563>, <-0.002407, -0.693589, 0.918289> }
triangle { <-0.002407, -0.693589, 0.918289>, <-0.072994, -0.710447, 0.922714>, <-0.063423, -0.617295, 0.942836> }
triangle { <-0.072994, -0.710447, 0.922714>, <-0.002407, -0.693589, 0.918289>, <-0.002707, -0.780254, 0.894101> }
triangle { <-0.002707, -0.780254, 0.894101>, <-0.082115, -0.799218, 0.899835>, <-0.072994, -0.710447, 0.922714> }
triangle { <-0.082115, -0.799218, 0.899835>, <-0.002707, -0.780254, 0.894101>, <-0.002991, -0.862108, 0.867146> }
triangle { <-0.002991, -0.862108, 0.867146>, <-0.090729, -0.883061, 0.874340>, <-0.082115, -0.799218, 0.899835> }
triangle { <-0.090729, -0.883061, 0.874340>, <-0.002991, -0.862108, 0.867146>, <-0.003257, -0.938647, 0.837592> }
triangle { <-0.003257, -0.938647, 0.837592>, <-0.098784, -0.961460, 0.846386>, <-0.090729, -0.883061, 0.874340> }
triangle { <-0.098784, -0.961460, 0.846386>, <-0.003257, -0.938647, 0.837592>, <-0.003503, -1.009399, 0.805620> }
triangle { <-0.003503, -1.009399, 0.805620>, <-0.106230, -1.033932, 0.816145>, <-0.098784, -0.961460, 0.846386> }
triangle { <-0.106230, -1.033932, 0.816145>, <-0.003503, -1.009399, 0.805620>, <-0.003726, -1.073927, 0.771428> }
triangle { <-0.003726, -1.073927, 0.771428>, <-0.113021, -1.100029, 0.783805>, <-0.106230, -1.033932, 0.816145> }
triangle { <-0.113021, -1.100029, 0.783805>, <-0.003726, -1.073927, 0.771428>, <-0.003927, -1.131835, 0.735227> }
triangle { <-0.003927, -1.131835, 0.735227>, <-0.119115, -1.159343, 0.749564>, <-0.113021, -1.100029, 0.783805> }
triangle { <-0.119115, -1.159343, 0.749564>, <-0.003927, -1.131835, 0.735227>, <-0.004104, -1.182764, 0.697240> }
triangle { <-0.004104, -1.182764, 0.697240>, <-0.124475, -1.211511, 0.713633>, <-0.119115, -1.159343, 0.749564> }
triangle { <-0.124475, -1.211511, 0.713633>, <-0.004104, -1.182764, 0.697240>, <-0.004256, -1.226401, 0.657700> }
triangle { <-0.004256, -1.226401, 0.657700>, <-0.129068, -1.256208, 0.676235>, <-0.124475, -1.211511, 0.713633> }
triangle { <-0.129068, -1.256208, 0.676235>, <-0.004256, -1.226401, 0.657700>, <-0.004381, -1.262477, 0.616852> }
triangle { <-0.004381, -1.262477, 0.616852>, <-0.132864, -1.293161, 0.637599>, <-0.129068, -1.256208, 0.676235> }
triangle { <-0.132864, -1.293161, 0.637599>, <-0.004381, -1.262477, 0.616852>, <-0.004479, -1.290770, 0.574948> }
triangle { <-0.004479, -1.290770, 0.574948>, <-0.135842, -1.322141, 0.597964>, <-0.132864, -1.293161, 0.637599> }
triangle { <-0.135842, -1.322141, 0.597964>, <-0.004479, -1.290770, 0.574948>, <-0.004549, -1.311104, 0.532246> }
triangle { <-0.004549, -1.311104, 0.532246>, <-0.137982, -1.342970, 0.557574>, <-0.135842, -1.322141, 0.597964> }
triangle { <-0.137982, -1.342970, 0.557574>, <-0.004549, -1.311104, 0.532246>, <-0.004592, -1.323355, 0.489009> }
triangle { <-0.004592, -1.323355, 0.489009>, <-0.139271, -1.355519, 0.516678>, <-0.137982, -1.342970, 0.557574> }
triangle { <-0.139271, -1.355519, 0.516678>, <-0.004592, -1.323355, 0.489009>, <-0.004606, -1.327447, 0.445503> }
triangle { <-0.004606, -1.327447, 0.445503>, <-0.139702, -1.359710, 0.475528>, <-0.139271, -1.355519, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.008678, -0.099742, 0.998164> }
triangle { <0.008678, -0.099742, 0.998164>, <-0.000361, -0.104150, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.000361, -0.104150, 0.998291>, <0.008678, -0.099742, 0.998164>, <0.017303, -0.198868, 0.992669> }
triangle { <0.017303, -0.198868, 0.992669>, <-0.000721, -0.207658, 0.993173>, <-0.000361, -0.104150, 0.998291> }
triangle { <-0.000721, -0.207658, 0.993173>, <0.017303, -0.198868, 0.992669>, <0.025821, -0.296769, 0.983547> }
triangle { <0.025821, -0.296769, 0.983547>, <-0.001075, -0.309886, 0.984679>, <-0.000721, -0.207658, 0.993173> }
triangle { <-0.001075, -0.309886, 0.984679>, <0.025821, -0.296769, 0.983547>, <0.034179, -0.392840, 0.970855> }
triangle { <0.034179, -0.392840, 0.970855>, <-0.001423, -0.410204, 0.972861>, <-0.001075, -0.309886, 0.984679> }
triangle { <-0.001423, -0.410204, 0.972861>, <0.034179, -0.392840, 0.970855>, <0.042327, -0.486489, 0.954671> }
triangle { <0.042327, -0.486489, 0.954671>, <-0.001763, -0.507992, 0.957791>, <-0.001423, -0.410204, 0.972861> }
triangle { <-0.001763, -0.507992, 0.957791>, <0.042327, -0.486489, 0.954671>, <0.050214, -0.577139, 0.935095> }
triangle { <0.050214, -0.577139, 0.935095>, <-0.002091, -0.602648, 0.939563>, <-0.001763, -0.507992, 0.957791> }
triangle { <-0.002091, -0.602648, 0.939563>, <0.050214, -0.577139, 0.935095>, <0.057792, -0.664230, 0.912248> }
triangle { <0.057792, -0.664230, 0.912248>, <-0.002407, -0.693589, 0.918289>, <-0.002091, -0.602648, 0.939563> }
triangle { <-0.002407, -0.693589, 0.918289>, <0.057792, -0.664230, 0.912248>, <0.065013, -0.747226, 0.886271> }
triangle { <0.065013, -0.747226, 0.886271>, <-0.002707, -0.780254, 0.894101>, <-0.002407, -0.693589, 0.918289> }
triangle { <-0.002707, -0.780254, 0.894101>, <0.065013, -0.747226, 0.886271>, <0.071833, -0.825615, 0.857324> }
triangle { <0.071833, -0.825615, 0.857324>, <-0.002991, -0.862108, 0.867146>, <-0.002707, -0.780254, 0.894101> }
triangle { <-0.002991, -0.862108, 0.867146>, <0.071833, -0.825615, 0.857324>, <0.078211, -0.898914, 0.825585> }
triangle { <0.078211, -0.898914, 0.825585>, <-0.003257, -0.938647, 0.837592>, <-0.002991, -0.862108, 0.867146> }
triangle { <-0.003257, -0.938647, 0.837592>, <0.078211, -0.898914, 0.825585>, <0.084106, -0.966671, 0.791249> }
triangle { <0.084106, -0.966671, 0.791249>, <-0.003503, -1.009399, 0.805620>, <-0.003257, -0.938647, 0.837592> }
triangle { <-0.003503, -1.009399, 0.805620>, <0.084106, -0.966671, 0.791249>, <0.089483, -1.028469, 0.754530> }
triangle { <0.089483, -1.028469, 0.754530>, <-0.003726, -1.073927, 0.771428>, <-0.003503, -1.009399, 0.805620> }
triangle { <-0.003726, -1.073927, 0.771428>, <0.089483, -1.028469, 0.754530>, <0.094308, -1.083925, 0.715652> }
triangle { <0.094308, -1.083925, 0.715652>, <-0.003927, -1.131835, 0.735227>, <-0.003726, -1.073927, 0.771428> }
triangle { <-0.003927, -1.131835, 0.735227>, <0.094308, -1.083925, 0.715652>, <0.098551, -1.132698, 0.674856> }
triangle { <0.098551, -1.132698, 0.674856>, <-0.004104, -1.182764, 0.697240>, <-0.003927, -1.131835, 0.735227> }
triangle { <-0.004104, -1.182764, 0.697240>, <0.098551, -1.132698, 0.674856>, <0.102187, -1.174488, 0.632393> }
triangle { <0.102187, -1.174488, 0.632393>, <-0.004256, -1.226401, 0.657700>, <-0.004104, -1.182764, 0.697240> }
triangle { <-0.004256, -1.226401, 0.657700>, <0.102187, -1.174488, 0.632393>, <0.105193, -1.209037, 0.588525> }
triangle { <0.105193, -1.209037, 0.588525>, <-0.004381, -1.262477, 0.616852>, <-0.004256, -1.226401, 0.657700> }
triangle { <-0.004381, -1.262477, 0.616852>, <0.105193, -1.209037, 0.588525>, <0.107551, -1.236132, 0.543523> }
triangle { <0.107551, -1.236132, 0.543523>, <-0.004479, -1.290770, 0.574948>, <-0.004381, -1.262477, 0.616852> }
triangle { <-0.004479, -1.290770, 0.574948>, <0.107551, -1.236132, 0.543523>, <0.109245, -1.255606, 0.497664> }
triangle { <0.109245, -1.255606, 0.497664>, <-0.004549, -1.311104, 0.532246>, <-0.004479, -1.290770, 0.574948> }
triangle { <-0.004549, -1.311104, 0.532246>, <0.109245, -1.255606, 0.497664>, <0.110266, -1.267338, 0.451230> }
triangle { <0.110266, -1.267338, 0.451230>, <-0.004592, -1.323355, 0.489009>, <-0.004549, -1.311104, 0.532246> }
triangle { <-0.004592, -1.323355, 0.489009>, <0.110266, -1.267338, 0.451230>, <0.110607, -1.271257, 0.404508> }
triangle { <0.110607, -1.271257, 0.404508>, <-0.004606, -1.327447, 0.445503>, <-0.004592, -1.323355, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.015692, -0.094151, 0.998007> }
triangle { <0.015692, -0.094151, 0.998007>, <0.008678, -0.099742, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <0.008678, -0.099742, 0.998164>, <0.015692, -0.094151, 0.998007>, <0.031287, -0.187721, 0.992041> }
triangle { <0.031287, -0.187721, 0.992041>, <0.017303, -0.198868, 0.992669>, <0.008678, -0.099742, 0.998164> }
triangle { <0.017303, -0.198868, 0.992669>, <0.031287, -0.187721, 0.992041>, <0.046689, -0.280134, 0.982139> }
triangle { <0.046689, -0.280134, 0.982139>, <0.025821, -0.296769, 0.983547>, <0.017303, -0.198868, 0.992669> }
triangle { <0.025821, -0.296769, 0.983547>, <0.046689, -0.280134, 0.982139>, <0.061803, -0.370820, 0.968361> }
triangle { <0.061803, -0.370820, 0.968361>, <0.034179, -0.392840, 0.970855>, <0.025821, -0.296769, 0.983547> }
triangle { <0.034179, -0.392840, 0.970855>, <0.061803, -0.370820, 0.968361>, <0.076537, -0.459220, 0.950792> }
triangle { <0.076537, -0.459220, 0.950792>, <0.042327, -0.486489, 0.954671>, <0.034179, -0.392840, 0.970855> }
triangle { <0.042327, -0.486489, 0.954671>, <0.076537, -0.459220, 0.950792>, <0.090798, -0.544789, 0.929542> }
triangle { <0.090798, -0.544789, 0.929542>, <0.050214, -0.577139, 0.935095>, <0.042327, -0.486489, 0.954671> }
triangle { <0.050214, -0.577139, 0.935095>, <0.090798, -0.544789, 0.929542>, <0.104500, -0.626998, 0.904740> }
triangle { <0.104500, -0.626998, 0.904740>, <0.057792, -0.664230, 0.912248>, <0.050214, -0.577139, 0.935095> }
triangle { <0.057792, -0.664230, 0.912248>, <0.104500, -0.626998, 0.904740>, <0.117557, -0.705342, 0.876540> }
triangle { <0.117557, -0.705342, 0.876540>, <0.065013, -0.747226, 0.886271>, <0.057792, -0.664230, 0.912248> }
triangle { <0.065013, -0.747226, 0.886271>, <0.117557, -0.705342, 0.876540>, <0.129890, -0.779338, 0.845115> }
triangle { <0.129890, -0.779338, 0.845115>, <0.071833, -0.825615, 0.857324>, <0.065013, -0.747226, 0.886271> }
triangle { <0.071833, -0.825615, 0.857324>, <0.129890, -0.779338, 0.845115>, <0.141421, -0.848528, 0.810660> }
triangle { <0.141421, -0.848528, 0.810660>, <0.078211, -0.898914, 0.825585>, <0.071833, -0.825615, 0.857324> }
triangle { <0.078211, -0.898914, 0.825585>, <0.141421, -0.848528, 0.810660>, <0.152081, -0.912487, 0.773387> }
triangle { <0.152081, -0.912487, 0.773387>, <0.084106, -0.966671, 0.791249>, <0.078211, -0.898914, 0.825585> }
triangle { <0.084106, -0.966671, 0.791249>, <0.152081, -0.912487, 0.773387>, <0.161803, -0.970820, 0.733525> }
triangle { <0.161803, -0.970820, 0.733525>, <0.089483, -1.028469, 0.754530>, <0.084106, -0.966671, 0.791249> }
triangle { <0.089483, -1.028469, 0.754530>, <0.161803, -0.970820, 0.733525>, <0.170528, -1.023168, 0.691321> }
triangle { <0.170528, -1.023168, 0.691321>, <0.094308, -1.083925, 0.715652>, <0.089483, -1.028469, 0.754530> }
triangle { <0.094308, -1.083925, 0.715652>, <0.170528, -1.023168, 0.691321>, <0.178201, -1.069208, 0.647034> }
triangle { <0.178201, -1.069208, 0.647034>, <0.098551, -1.132698, 0.674856>, <0.094308, -1.083925, 0.715652> }
triangle { <0.098551, -1.132698, 0.674856>, <0.178201, -1.069208, 0.647034>, <0.184776, -1.108655, 0.600938> }
triangle { <0.184776, -1.108655, 0.600938>, <0.102187, -1.174488, 0.632393>, <0.098551, -1.132698, 0.674856> }
triangle { <0.102187, -1.174488, 0.632393>, <0.184776, -1.108655, 0.600938>, <0.190211, -1.141268, 0.553316> }
triangle { <0.190211, -1.141268, 0.553316>, <0.105193, -1.209037, 0.588525>, <0.102187, -1.174488, 0.632393> }
triangle { <0.105193, -1.209037, 0.588525>, <0.190211, -1.141268, 0.553316>, <0.194474, -1.166844, 0.504463> }
triangle { <0.194474, -1.166844, 0.504463>, <0.107551, -1.236132, 0.543523>, <0.105193, -1.209037, 0.588525> }
triangle { <0.107551, -1.236132, 0.543523>, <0.194474, -1.166844, 0.504463>, <0.197538, -1.185226, 0.454680> }
triangle { <0.197538, -1.185226, 0.454680>, <0.109245, -1.255606, 0.497664>, <0.107551, -1.236132, 0.543523> }
triangle { <0.109245, -1.255606, 0.497664>, <0.197538, -1.185226, 0.454680>, <0.199383, -1.196301, 0.404273> }
triangle { <0.199383, -1.196301, 0.404273>, <0.110266, -1.267338, 0.451230>, <0.109245, -1.255606, 0.497664> }
triangle { <0.110266, -1.267338, 0.451230>, <0.199383, -1.196301, 0.404273>, <0.200000, -1.200000, 0.353553> }
triangle { <0.200000, -1.200000, 0.353553>, <0.110607, -1.271257, 0.404508>, <0.110266, -1.267338, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.020502, -0.088189, 0.997823> }
triangle { <0.020502, -0.088189, 0.997823>, <0.015692, -0.094151, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <0.015692, -0.094151, 0.998007>, <0.020502, -0.088189, 0.997823>, <0.040877, -0.175833, 0.991307> }
triangle { <0.040877, -0.175833, 0.991307>, <0.031287, -0.187721, 0.992041>, <0.015692, -0.094151, 0.998007> }
triangle { <0.031287, -0.187721, 0.992041>, <0.040877, -0.175833, 0.991307>, <0.061000, -0.262394, 0.980490> }
triangle { <0.061000, -0.262394, 0.980490>, <0.046689, -0.280134, 0.982139>, <0.031287, -0.187721, 0.992041> }
triangle { <0.046689, -0.280134, 0.982139>, <0.061000, -0.262394, 0.980490>, <0.080747, -0.347337, 0.965441> }
triangle { <0.080747, -0.347337, 0.965441>, <0.061803, -0.370820, 0.968361>, <0.046689, -0.280134, 0.982139> }
triangle { <0.061803, -0.370820, 0.968361>, <0.080747, -0.347337, 0.965441>, <0.099997, -0.430139, 0.946251> }
triangle { <0.099997, -0.430139, 0.946251>, <0.076537, -0.459220, 0.950792>, <0.061803, -0.370820, 0.968361> }
triangle { <0.076537, -0.459220, 0.950792>, <0.099997, -0.430139, 0.946251>, <0.118629, -0.510289, 0.923039> }
triangle { <0.118629, -0.510289, 0.923039>, <0.090798, -0.544789, 0.929542>, <0.076537, -0.459220, 0.950792> }
triangle { <0.090798, -0.544789, 0.929542>, <0.118629, -0.510289, 0.923039>, <0.136531, -0.587292, 0.895948> }
triangle { <0.136531, -0.587292, 0.895948>, <0.104500, -0.626998, 0.904740>, <0.090798, -0.544789, 0.929542> }
triangle { <0.104500, -0.626998, 0.904740>, <0.136531, -0.587292, 0.895948>, <0.153591, -0.660675, 0.865145> }
triangle { <0.153591, -0.660675, 0.865145>, <0.117557, -0.705342, 0.876540>, <0.104500, -0.626998, 0.904740> }
triangle { <0.117557, -0.705342, 0.876540>, <0.153591, -0.660675, 0.865145>, <0.169703, -0.729984, 0.830821> }
triangle { <0.169703, -0.729984, 0.830821>, <0.129890, -0.779338, 0.845115>, <0.117557, -0.705342, 0.876540> }
triangle { <0.129890, -0.779338, 0.845115>, <0.169703, -0.729984, 0.830821>, <0.184770, -0.794793, 0.793186> }
triangle { <0.184770, -0.794793, 0.793186>, <0.141421, -0.848528, 0.810660>, <0.129890, -0.779338, 0.845115> }
triangle { <0.141421, -0.848528, 0.810660>, <0.184770, -0.794793, 0.793186>, <0.198697, -0.854702, 0.752473> }
triangle { <0.198697, -0.854702, 0.752473>, <0.152081, -0.912487, 0.773387>, <0.141421, -0.848528, 0.810660> }
triangle { <0.152081, -0.912487, 0.773387>, <0.198697, -0.854702, 0.752473>, <0.211399, -0.909341, 0.708932> }
triangle { <0.211399, -0.909341, 0.708932>, <0.161803, -0.970820, 0.733525>, <0.152081, -0.912487, 0.773387> }
triangle { <0.161803, -0.970820, 0.733525>, <0.211399, -0.909341, 0.708932>, <0.222798, -0.958374, 0.662833> }
triangle { <0.222798, -0.958374, 0.662833>, <0.170528, -1.023168, 0.691321>, <0.161803, -0.970820, 0.733525> }
triangle { <0.170528, -1.023168, 0.691321>, <0.222798, -0.958374, 0.662833>, <0.232823, -1.001498, 0.614459> }
triangle { <0.232823, -1.001498, 0.614459>, <0.178201, -1.069208, 0.647034>, <0.170528, -1.023168, 0.691321> }
triangle { <0.178201, -1.069208, 0.647034>, <0.232823, -1.001498, 0.614459>, <0.241413, -1.038447, 0.564108> }
triangle { <0.241413, -1.038447, 0.564108>, <0.184776, -1.108655, 0.600938>, <0.178201, -1.069208, 0.647034> }
triangle { <0.184776, -1.108655, 0.600938>, <0.241413, -1.038447, 0.564108>, <0.248515, -1.068994, 0.512092> }
triangle { <0.248515, -1.068994, 0.512092>, <0.190211, -1.141268, 0.553316>, <0.184776, -1.108655, 0.600938> }
triangle { <0.190211, -1.141268, 0.553316>, <0.248515, -1.068994, 0.512092>, <0.254084, -1.092951, 0.458730> }
triangle { <0.254084, -1.092951, 0.458730>, <0.194474, -1.166844, 0.504463>, <0.190211, -1.141268, 0.553316> }
triangle { <0.194474, -1.166844, 0.504463>, <0.254084, -1.092951, 0.458730>, <0.258087, -1.110169, 0.404352> }
triangle { <0.258087, -1.110169, 0.404352>, <0.197538, -1.185226, 0.454680>, <0.194474, -1.166844, 0.504463> }
triangle { <0.197538, -1.185226, 0.454680>, <0.258087, -1.110169, 0.404352>, <0.260498, -1.120542, 0.349293> }
triangle { <0.260498, -1.120542, 0.349293>, <0.199383, -1.196301, 0.404273>, <0.197538, -1.185226, 0.454680> }
triangle { <0.199383, -1.196301, 0.404273>, <0.260498, -1.120542, 0.349293>, <0.261304, -1.124007, 0.293893> }
triangle { <0.261304, -1.124007, 0.293893>, <0.200000, -1.200000, 0.353553>, <0.199383, -1.196301, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.023239, -0.082667, 0.997617> }
triangle { <0.023239, -0.082667, 0.997617>, <0.020502, -0.088189, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <0.020502, -0.088189, 0.997823>, <0.023239, -0.082667, 0.997617>, <0.046335, -0.164824, 0.990483> }
triangle { <0.046335, -0.164824, 0.990483>, <0.040877, -0.175833, 0.991307>, <0.020502, -0.088189, 0.997823> }
triangle { <0.040877, -0.175833, 0.991307>, <0.046335, -0.164824, 0.990483>, <0.069145, -0.245965, 0.978642> }
triangle { <0.069145, -0.245965, 0.978642>, <0.061000, -0.262394, 0.980490>, <0.040877, -0.175833, 0.991307> }
triangle { <0.061000, -0.262394, 0.980490>, <0.069145, -0.245965, 0.978642>, <0.091529, -0.325589, 0.962166> }
triangle { <0.091529, -0.325589, 0.962166>, <0.080747, -0.347337, 0.965441>, <0.061000, -0.262394, 0.980490> }
triangle { <0.080747, -0.347337, 0.965441>, <0.091529, -0.325589, 0.962166>, <0.113348, -0.403206, 0.941159> }
triangle { <0.113348, -0.403206, 0.941159>, <0.099997, -0.430139, 0.946251>, <0.080747, -0.347337, 0.965441> }
triangle { <0.099997, -0.430139, 0.946251>, <0.113348, -0.403206, 0.941159>, <0.134469, -0.478337, 0.915748> }
triangle { <0.134469, -0.478337, 0.915748>, <0.118629, -0.510289, 0.923039>, <0.099997, -0.430139, 0.946251> }
triangle { <0.118629, -0.510289, 0.923039>, <0.134469, -0.478337, 0.915748>, <0.154761, -0.550519, 0.886090> }
triangle { <0.154761, -0.550519, 0.886090>, <0.136531, -0.587292, 0.895948>, <0.118629, -0.510289, 0.923039> }
triangle { <0.136531, -0.587292, 0.895948>, <0.154761, -0.550519, 0.886090>, <0.174098, -0.619307, 0.852369> }
triangle { <0.174098, -0.619307, 0.852369>, <0.153591, -0.660675, 0.865145>, <0.136531, -0.587292, 0.895948> }
triangle { <0.153591, -0.660675, 0.865145>, <0.174098, -0.619307, 0.852369>, <0.192362, -0.684277, 0.814793> }
triangle { <0.192362, -0.684277, 0.814793>, <0.169703, -0.729984, 0.830821>, <0.153591, -0.660675, 0.865145> }
triangle { <0.169703, -0.729984, 0.830821>, <0.192362, -0.684277, 0.814793>, <0.209441, -0.745028, 0.773592> }
triangle { <0.209441, -0.745028, 0.773592>, <0.184770, -0.794793, 0.793186>, <0.169703, -0.729984, 0.830821> }
triangle { <0.184770, -0.794793, 0.793186>, <0.209441, -0.745028, 0.773592>, <0.225227, -0.801185, 0.729022> }
triangle { <0.225227, -0.801185, 0.729022>, <0.198697, -0.854702, 0.752473>, <0.184770, -0.794793, 0.793186> }
triangle { <0.198697, -0.854702, 0.752473>, <0.225227, -0.801185, 0.729022>, <0.239626, -0.852403, 0.681356> }
triangle { <0.239626, -0.852403, 0.681356>, <0.211399, -0.909341, 0.708932>, <0.198697, -0.854702, 0.752473> }
triangle { <0.211399, -0.909341, 0.708932>, <0.239626, -0.852403, 0.681356>, <0.252547, -0.898366, 0.630889> }
triangle { <0.252547, -0.898366, 0.630889>, <0.222798, -0.958374, 0.662833>, <0.211399, -0.909341, 0.708932> }
triangle { <0.222798, -0.958374, 0.662833>, <0.252547, -0.898366, 0.630889>, <0.263910, -0.938790, 0.577932> }
triangle { <0.263910, -0.938790, 0.577932>, <0.232823, -1.001498, 0.614459>, <0.222798, -0.958374, 0.662833> }
triangle { <0.232823, -1.001498, 0.614459>, <0.263910, -0.938790, 0.577932>, <0.273647, -0.973426, 0.522811> }
triangle { <0.273647, -0.973426, 0.522811>, <0.241413, -1.038447, 0.564108>, <0.232823, -1.001498, 0.614459> }
triangle { <0.241413, -1.038447, 0.564108>, <0.273647, -0.973426, 0.522811>, <0.281697, -1.002060, 0.465867> }
triangle { <0.281697, -1.002060, 0.465867>, <0.248515, -1.068994, 0.512092>, <0.241413, -1.038447, 0.564108> }
triangle { <0.248515, -1.068994, 0.512092>, <0.281697, -1.002060, 0.465867>, <0.288010, -1.024516, 0.407450> }
triangle { <0.288010, -1.024516, 0.407450>, <0.254084, -1.092951, 0.458730>, <0.248515, -1.068994, 0.512092> }
triangle { <0.254084, -1.092951, 0.458730>, <0.288010, -1.024516, 0.407450>, <0.292547, -1.040656, 0.347920> }
triangle { <0.292547, -1.040656, 0.347920>, <0.258087, -1.110169, 0.404352>, <0.254084, -1.092951, 0.458730> }
triangle { <0.258087, -1.110169, 0.404352>, <0.292547, -1.040656, 0.347920>, <0.295281, -1.050380, 0.287645> }
triangle { <0.295281, -1.050380, 0.287645>, <0.260498, -1.120542, 0.349293>, <0.258087, -1.110169, 0.404352> }
triangle { <0.260498, -1.120542, 0.349293>, <0.295281, -1.050380, 0.287645>, <0.296194, -1.053628, 0.226995> }
triangle { <0.296194, -1.053628, 0.226995>, <0.261304, -1.124007, 0.293893>, <0.260498, -1.120542, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024323, -0.078285, 0.997394> }
triangle { <0.024323, -0.078285, 0.997394>, <0.023239, -0.082667, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <0.023239, -0.082667, 0.997617>, <0.024323, -0.078285, 0.997394>, <0.048497, -0.156087, 0.989591> }
triangle { <0.048497, -0.156087, 0.989591>, <0.046335, -0.164824, 0.990483>, <0.023239, -0.082667, 0.997617> }
triangle { <0.046335, -0.164824, 0.990483>, <0.048497, -0.156087, 0.989591>, <0.072371, -0.232927, 0.976639> }
triangle { <0.072371, -0.232927, 0.976639>, <0.069145, -0.245965, 0.978642>, <0.046335, -0.164824, 0.990483> }
triangle { <0.069145, -0.245965, 0.978642>, <0.072371, -0.232927, 0.976639>, <0.095799, -0.308331, 0.958619> }
triangle { <0.095799, -0.308331, 0.958619>, <0.091529, -0.325589, 0.962166>, <0.069145, -0.245965, 0.978642> }
triangle { <0.091529, -0.325589, 0.962166>, <0.095799, -0.308331, 0.958619>, <0.118637, -0.381834, 0.935641> }
triangle { <0.118637, -0.381834, 0.935641>, <0.113348, -0.403206, 0.941159>, <0.091529, -0.325589, 0.962166> }
triangle { <0.113348, -0.403206, 0.941159>, <0.118637, -0.381834, 0.935641>, <0.140743, -0.452982, 0.907847> }
triangle { <0.140743, -0.452982, 0.907847>, <0.134469, -0.478337, 0.915748>, <0.113348, -0.403206, 0.941159> }
triangle { <0.134469, -0.478337, 0.915748>, <0.140743, -0.452982, 0.907847>, <0.161982, -0.521338, 0.875409> }
triangle { <0.161982, -0.521338, 0.875409>, <0.154761, -0.550519, 0.886090>, <0.134469, -0.478337, 0.915748> }
triangle { <0.154761, -0.550519, 0.886090>, <0.161982, -0.521338, 0.875409>, <0.182221, -0.586480, 0.838525> }
triangle { <0.182221, -0.586480, 0.838525>, <0.174098, -0.619307, 0.852369>, <0.154761, -0.550519, 0.886090> }
triangle { <0.174098, -0.619307, 0.852369>, <0.182221, -0.586480, 0.838525>, <0.201338, -0.648006, 0.797425> }
triangle { <0.201338, -0.648006, 0.797425>, <0.192362, -0.684277, 0.814793>, <0.174098, -0.619307, 0.852369> }
triangle { <0.192362, -0.684277, 0.814793>, <0.201338, -0.648006, 0.797425>, <0.219213, -0.705537, 0.752361> }
triangle { <0.219213, -0.705537, 0.752361>, <0.209441, -0.745028, 0.773592>, <0.192362, -0.684277, 0.814793> }
triangle { <0.209441, -0.745028, 0.773592>, <0.219213, -0.705537, 0.752361>, <0.235736, -0.758717, 0.703611> }
triangle { <0.235736, -0.758717, 0.703611>, <0.225227, -0.801185, 0.729022>, <0.209441, -0.745028, 0.773592> }
triangle { <0.225227, -0.801185, 0.729022>, <0.235736, -0.758717, 0.703611>, <0.250806, -0.807220, 0.651476> }
triangle { <0.250806, -0.807220, 0.651476>, <0.239626, -0.852403, 0.681356>, <0.225227, -0.801185, 0.729022> }
triangle { <0.239626, -0.852403, 0.681356>, <0.250806, -0.807220, 0.651476>, <0.264330, -0.850747, 0.596277> }
triangle { <0.264330, -0.850747, 0.596277>, <0.252547, -0.898366, 0.630889>, <0.239626, -0.852403, 0.681356> }
triangle { <0.252547, -0.898366, 0.630889>, <0.264330, -0.850747, 0.596277>, <0.276224, -0.889028, 0.538354> }
triangle { <0.276224, -0.889028, 0.538354>, <0.263910, -0.938790, 0.577932>, <0.252547, -0.898366, 0.630889> }
triangle { <0.263910, -0.938790, 0.577932>, <0.276224, -0.889028, 0.538354>, <0.286415, -0.921828, 0.478064> }
triangle { <0.286415, -0.921828, 0.478064>, <0.273647, -0.973426, 0.522811>, <0.263910, -0.938790, 0.577932> }
triangle { <0.273647, -0.973426, 0.522811>, <0.286415, -0.921828, 0.478064>, <0.294840, -0.948944, 0.415780> }
triangle { <0.294840, -0.948944, 0.415780>, <0.281697, -1.002060, 0.465867>, <0.273647, -0.973426, 0.522811> }
triangle { <0.281697, -1.002060, 0.465867>, <0.294840, -0.948944, 0.415780>, <0.301448, -0.970211, 0.351885> }
triangle { <0.301448, -0.970211, 0.351885>, <0.288010, -1.024516, 0.407450>, <0.281697, -1.002060, 0.465867> }
triangle { <0.288010, -1.024516, 0.407450>, <0.301448, -0.970211, 0.351885>, <0.306197, -0.985495, 0.286773> }
triangle { <0.306197, -0.985495, 0.286773>, <0.292547, -1.040656, 0.347920>, <0.288010, -1.024516, 0.407450> }
triangle { <0.292547, -1.040656, 0.347920>, <0.306197, -0.985495, 0.286773>, <0.309058, -0.994703, 0.220845> }
triangle { <0.309058, -0.994703, 0.220845>, <0.295281, -1.050380, 0.287645>, <0.292547, -1.040656, 0.347920> }
triangle { <0.295281, -1.050380, 0.287645>, <0.309058, -0.994703, 0.220845>, <0.310013, -0.997779, 0.154508> }
triangle { <0.310013, -0.997779, 0.154508>, <0.296194, -1.053628, 0.226995>, <0.295281, -1.050380, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024400, -0.075532, 0.997158> }
triangle { <0.024400, -0.075532, 0.997158>, <0.024323, -0.078285, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024323, -0.078285, 0.997394>, <0.024400, -0.075532, 0.997158>, <0.048649, -0.150599, 0.988651> }
triangle { <0.048649, -0.150599, 0.988651>, <0.048497, -0.156087, 0.989591>, <0.024323, -0.078285, 0.997394> }
triangle { <0.048497, -0.156087, 0.989591>, <0.048649, -0.150599, 0.988651>, <0.072598, -0.224737, 0.974531> }
triangle { <0.072598, -0.224737, 0.974531>, <0.072371, -0.232927, 0.976639>, <0.048497, -0.156087, 0.989591> }
triangle { <0.072371, -0.232927, 0.976639>, <0.072598, -0.224737, 0.974531>, <0.096100, -0.297489, 0.954885> }
triangle { <0.096100, -0.297489, 0.954885>, <0.095799, -0.308331, 0.958619>, <0.072371, -0.232927, 0.976639> }
triangle { <0.095799, -0.308331, 0.958619>, <0.096100, -0.297489, 0.954885>, <0.119009, -0.368407, 0.929833> }
triangle { <0.119009, -0.368407, 0.929833>, <0.118637, -0.381834, 0.935641>, <0.095799, -0.308331, 0.958619> }
triangle { <0.118637, -0.381834, 0.935641>, <0.119009, -0.368407, 0.929833>, <0.141185, -0.437054, 0.899532> }
triangle { <0.141185, -0.437054, 0.899532>, <0.140743, -0.452982, 0.907847>, <0.118637, -0.381834, 0.935641> }
triangle { <0.140743, -0.452982, 0.907847>, <0.141185, -0.437054, 0.899532>, <0.162490, -0.503006, 0.864166> }
triangle { <0.162490, -0.503006, 0.864166>, <0.161982, -0.521338, 0.875409>, <0.140743, -0.452982, 0.907847> }
triangle { <0.161982, -0.521338, 0.875409>, <0.162490, -0.503006, 0.864166>, <0.182793, -0.565858, 0.823955> }
triangle { <0.182793, -0.565858, 0.823955>, <0.182221, -0.586480, 0.838525>, <0.161982, -0.521338, 0.875409> }
triangle { <0.182221, -0.586480, 0.838525>, <0.182793, -0.565858, 0.823955>, <0.201969, -0.625220, 0.779146> }
triangle { <0.201969, -0.625220, 0.779146>, <0.201338, -0.648006, 0.797425>, <0.182221, -0.586480, 0.838525> }
triangle { <0.201338, -0.648006, 0.797425>, <0.201969, -0.625220, 0.779146>, <0.219900, -0.680728, 0.730016> }
triangle { <0.219900, -0.680728, 0.730016>, <0.219213, -0.705537, 0.752361>, <0.201338, -0.648006, 0.797425> }
triangle { <0.219213, -0.705537, 0.752361>, <0.219900, -0.680728, 0.730016>, <0.236476, -0.732039, 0.676867> }
triangle { <0.236476, -0.732039, 0.676867>, <0.235736, -0.758717, 0.703611>, <0.219213, -0.705537, 0.752361> }
triangle { <0.235736, -0.758717, 0.703611>, <0.236476, -0.732039, 0.676867>, <0.251593, -0.778836, 0.620028> }
triangle { <0.251593, -0.778836, 0.620028>, <0.250806, -0.807220, 0.651476>, <0.235736, -0.758717, 0.703611> }
triangle { <0.250806, -0.807220, 0.651476>, <0.251593, -0.778836, 0.620028>, <0.265159, -0.820832, 0.559847> }
triangle { <0.265159, -0.820832, 0.559847>, <0.264330, -0.850747, 0.596277>, <0.250806, -0.807220, 0.651476> }
triangle { <0.264330, -0.850747, 0.596277>, <0.265159, -0.820832, 0.559847>, <0.277091, -0.857767, 0.496698> }
triangle { <0.277091, -0.857767, 0.496698>, <0.276224, -0.889028, 0.538354>, <0.264330, -0.850747, 0.596277> }
triangle { <0.276224, -0.889028, 0.538354>, <0.277091, -0.857767, 0.496698>, <0.287314, -0.889414, 0.430968> }
triangle { <0.287314, -0.889414, 0.430968>, <0.286415, -0.921828, 0.478064>, <0.276224, -0.889028, 0.538354> }
triangle { <0.286415, -0.921828, 0.478064>, <0.287314, -0.889414, 0.430968>, <0.295765, -0.915577, 0.363064> }
triangle { <0.295765, -0.915577, 0.363064>, <0.294840, -0.948944, 0.415780>, <0.286415, -0.921828, 0.478064> }
triangle { <0.294840, -0.948944, 0.415780>, <0.295765, -0.915577, 0.363064>, <0.302393, -0.936095, 0.293403> }
triangle { <0.302393, -0.936095, 0.293403>, <0.301448, -0.970211, 0.351885>, <0.294840, -0.948944, 0.415780> }
triangle { <0.301448, -0.970211, 0.351885>, <0.302393, -0.936095, 0.293403>, <0.307157, -0.950842, 0.222416> }
triangle { <0.307157, -0.950842, 0.222416>, <0.306197, -0.985495, 0.286773>, <0.301448, -0.970211, 0.351885> }
triangle { <0.306197, -0.985495, 0.286773>, <0.307157, -0.950842, 0.222416>, <0.310027, -0.959727, 0.150539> }
triangle { <0.310027, -0.959727, 0.150539>, <0.309058, -0.994703, 0.220845>, <0.306197, -0.985495, 0.286773> }
triangle { <0.309058, -0.994703, 0.220845>, <0.310027, -0.959727, 0.150539>, <0.310986, -0.962694, 0.078217> }
triangle { <0.310986, -0.962694, 0.078217>, <0.310013, -0.997779, 0.154508>, <0.309058, -0.994703, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024245, -0.074619, 0.996917> }
triangle { <0.024245, -0.074619, 0.996917>, <0.024400, -0.075532, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024400, -0.075532, 0.997158>, <0.024245, -0.074619, 0.996917>, <0.048341, -0.148778, 0.987688> }
triangle { <0.048341, -0.148778, 0.987688>, <0.048649, -0.150599, 0.988651>, <0.024400, -0.075532, 0.997158> }
triangle { <0.048649, -0.150599, 0.988651>, <0.048341, -0.148778, 0.987688>, <0.072139, -0.222020, 0.972370> }
triangle { <0.072139, -0.222020, 0.972370>, <0.072598, -0.224737, 0.974531>, <0.048649, -0.150599, 0.988651> }
triangle { <0.072598, -0.224737, 0.974531>, <0.072139, -0.222020, 0.972370>, <0.095492, -0.293893, 0.951057> }
triangle { <0.095492, -0.293893, 0.951057>, <0.096100, -0.297489, 0.954885>, <0.072598, -0.224737, 0.974531> }
triangle { <0.096100, -0.297489, 0.954885>, <0.095492, -0.293893, 0.951057>, <0.118256, -0.363954, 0.923880> }
triangle { <0.118256, -0.363954, 0.923880>, <0.119009, -0.368407, 0.929833>, <0.096100, -0.297489, 0.954885> }
triangle { <0.119009, -0.368407, 0.929833>, <0.118256, -0.363954, 0.923880>, <0.140291, -0.431771, 0.891007> }
triangle { <0.140291, -0.431771, 0.891007>, <0.141185, -0.437054, 0.899532>, <0.119009, -0.368407, 0.929833> }
triangle { <0.141185, -0.437054, 0.899532>, <0.140291, -0.431771, 0.891007>, <0.161461, -0.496926, 0.852640> }
triangle { <0.161461, -0.496926, 0.852640>, <0.162490, -0.503006, 0.864166>, <0.141185, -0.437054, 0.899532> }
triangle { <0.162490, -0.503006, 0.864166>, <0.161461, -0.496926, 0.852640>, <0.181636, -0.559017, 0.809017> }
triangle { <0.181636, -0.559017, 0.809017>, <0.182793, -0.565858, 0.823955>, <0.162490, -0.503006, 0.864166> }
triangle { <0.182793, -0.565858, 0.823955>, <0.181636, -0.559017, 0.809017>, <0.200690, -0.617662, 0.760406> }
triangle { <0.200690, -0.617662, 0.760406>, <0.201969, -0.625220, 0.779146>, <0.182793, -0.565858, 0.823955> }
triangle { <0.201969, -0.625220, 0.779146>, <0.200690, -0.617662, 0.760406>, <0.218508, -0.672499, 0.707107> }
triangle { <0.218508, -0.672499, 0.707107>, <0.219900, -0.680728, 0.730016>, <0.201969, -0.625220, 0.779146> }
triangle { <0.219900, -0.680728, 0.730016>, <0.218508, -0.672499, 0.707107>, <0.234978, -0.723189, 0.649448> }
triangle { <0.234978, -0.723189, 0.649448>, <0.236476, -0.732039, 0.676867>, <0.219900, -0.680728, 0.730016> }
triangle { <0.236476, -0.732039, 0.676867>, <0.234978, -0.723189, 0.649448>, <0.250000, -0.769421, 0.587785> }
triangle { <0.250000, -0.769421, 0.587785>, <0.251593, -0.778836, 0.620028>, <0.236476, -0.732039, 0.676867> }
triangle { <0.251593, -0.778836, 0.620028>, <0.250000, -0.769421, 0.587785>, <0.263480, -0.810909, 0.522499> }
triangle { <0.263480, -0.810909, 0.522499>, <0.265159, -0.820832, 0.559847>, <0.251593, -0.778836, 0.620028> }
triangle { <0.265159, -0.820832, 0.559847>, <0.263480, -0.810909, 0.522499>, <0.275336, -0.847398, 0.453991> }
triangle { <0.275336, -0.847398, 0.453991>, <0.277091, -0.857767, 0.496698>, <0.265159, -0.820832, 0.559847> }
triangle { <0.277091, -0.857767, 0.496698>, <0.275336, -0.847398, 0.453991>, <0.285494, -0.878662, 0.382683> }
triangle { <0.285494, -0.878662, 0.382683>, <0.287314, -0.889414, 0.430968>, <0.277091, -0.857767, 0.496698> }
triangle { <0.287314, -0.889414, 0.430968>, <0.285494, -0.878662, 0.382683>, <0.293893, -0.904508, 0.309017> }
triangle { <0.293893, -0.904508, 0.309017>, <0.295765, -0.915577, 0.363064>, <0.287314, -0.889414, 0.430968> }
triangle { <0.295765, -0.915577, 0.363064>, <0.293893, -0.904508, 0.309017>, <0.300479, -0.924779, 0.233445> }
triangle { <0.300479, -0.924779, 0.233445>, <0.302393, -0.936095, 0.293403>, <0.295765, -0.915577, 0.363064> }
triangle { <0.302393, -0.936095, 0.293403>, <0.300479, -0.924779, 0.233445>, <0.305212, -0.939347, 0.156434> }
triangle { <0.305212, -0.939347, 0.156434>, <0.307157, -0.950842, 0.222416>, <0.302393, -0.936095, 0.293403> }
triangle { <0.307157, -0.950842, 0.222416>, <0.305212, -0.939347, 0.156434>, <0.308064, -0.948125, 0.078459> }
triangle { <0.308064, -0.948125, 0.078459>, <0.310027, -0.959727, 0.150539>, <0.307157, -0.950842, 0.222416> }
triangle { <0.310027, -0.959727, 0.150539>, <0.308064, -0.948125, 0.078459>, <0.309017, -0.951057, 0.000000> }
triangle { <0.309017, -0.951057, 0.000000>, <0.310986, -0.962694, 0.078217>, <0.310027, -0.959727, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024657, -0.075449, 0.997158> }
triangle { <0.024657, -0.075449, 0.997158>, <0.024245, -0.074619, 0.996917>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024245, -0.074619, 0.996917>, <0.024657, -0.075449, 0.997158>, <0.049162, -0.150432, 0.988651> }
triangle { <0.049162, -0.150432, 0.988651>, <0.048341, -0.148778, 0.987688>, <0.024245, -0.074619, 0.996917> }
triangle { <0.048341, -0.148778, 0.987688>, <0.049162, -0.150432, 0.988651>, <0.073364, -0.224488, 0.974531> }
triangle { <0.073364, -0.224488, 0.974531>, <0.072139, -0.222020, 0.972370>, <0.048341, -0.148778, 0.987688> }
triangle { <0.072139, -0.222020, 0.972370>, <0.073364, -0.224488, 0.974531>, <0.097113, -0.297160, 0.954885> }
triangle { <0.097113, -0.297160, 0.954885>, <0.095492, -0.293893, 0.951057>, <0.072139, -0.222020, 0.972370> }
triangle { <0.095492, -0.293893, 0.951057>, <0.097113, -0.297160, 0.954885>, <0.120264, -0.368000, 0.929833> }
triangle { <0.120264, -0.368000, 0.929833>, <0.118256, -0.363954, 0.923880>, <0.095492, -0.293893, 0.951057> }
triangle { <0.118256, -0.363954, 0.923880>, <0.120264, -0.368000, 0.929833>, <0.142673, -0.436570, 0.899532> }
triangle { <0.142673, -0.436570, 0.899532>, <0.140291, -0.431771, 0.891007>, <0.118256, -0.363954, 0.923880> }
triangle { <0.140291, -0.431771, 0.891007>, <0.142673, -0.436570, 0.899532>, <0.164203, -0.502450, 0.864166> }
triangle { <0.164203, -0.502450, 0.864166>, <0.161461, -0.496926, 0.852640>, <0.140291, -0.431771, 0.891007> }
triangle { <0.161461, -0.496926, 0.852640>, <0.164203, -0.502450, 0.864166>, <0.184720, -0.565231, 0.823955> }
triangle { <0.184720, -0.565231, 0.823955>, <0.181636, -0.559017, 0.809017>, <0.161461, -0.496926, 0.852640> }
triangle { <0.181636, -0.559017, 0.809017>, <0.184720, -0.565231, 0.823955>, <0.204099, -0.624528, 0.779146> }
triangle { <0.204099, -0.624528, 0.779146>, <0.200690, -0.617662, 0.760406>, <0.181636, -0.559017, 0.809017> }
triangle { <0.200690, -0.617662, 0.760406>, <0.204099, -0.624528, 0.779146>, <0.222219, -0.679974, 0.730016> }
triangle { <0.222219, -0.679974, 0.730016>, <0.218508, -0.672499, 0.707107>, <0.200690, -0.617662, 0.760406> }
triangle { <0.218508, -0.672499, 0.707107>, <0.222219, -0.679974, 0.730016>, <0.238969, -0.731229, 0.676867> }
triangle { <0.238969, -0.731229, 0.676867>, <0.234978, -0.723189, 0.649448>, <0.218508, -0.672499, 0.707107> }
triangle { <0.234978, -0.723189, 0.649448>, <0.238969, -0.731229, 0.676867>, <0.254245, -0.777974, 0.620028> }
triangle { <0.254245, -0.777974, 0.620028>, <0.250000, -0.769421, 0.587785>, <0.234978, -0.723189, 0.649448> }
triangle { <0.250000, -0.769421, 0.587785>, <0.254245, -0.777974, 0.620028>, <0.267955, -0.819924, 0.559847> }
triangle { <0.267955, -0.819924, 0.559847>, <0.263480, -0.810909, 0.522499>, <0.250000, -0.769421, 0.587785> }
triangle { <0.263480, -0.810909, 0.522499>, <0.267955, -0.819924, 0.559847>, <0.280012, -0.856818, 0.496698> }
triangle { <0.280012, -0.856818, 0.496698>, <0.275336, -0.847398, 0.453991>, <0.263480, -0.810909, 0.522499> }
triangle { <0.275336, -0.847398, 0.453991>, <0.280012, -0.856818, 0.496698>, <0.290343, -0.888429, 0.430968> }
triangle { <0.290343, -0.888429, 0.430968>, <0.285494, -0.878662, 0.382683>, <0.275336, -0.847398, 0.453991> }
triangle { <0.285494, -0.878662, 0.382683>, <0.290343, -0.888429, 0.430968>, <0.298883, -0.914564, 0.363064> }
triangle { <0.298883, -0.914564, 0.363064>, <0.293893, -0.904508, 0.309017>, <0.285494, -0.878662, 0.382683> }
triangle { <0.293893, -0.904508, 0.309017>, <0.298883, -0.914564, 0.363064>, <0.305582, -0.935059, 0.293403> }
triangle { <0.305582, -0.935059, 0.293403>, <0.300479, -0.924779, 0.233445>, <0.293893, -0.904508, 0.309017> }
triangle { <0.300479, -0.924779, 0.233445>, <0.305582, -0.935059, 0.293403>, <0.310396, -0.949790, 0.222416> }
triangle { <0.310396, -0.949790, 0.222416>, <0.305212, -0.939347, 0.156434>, <0.300479, -0.924779, 0.233445> }
triangle { <0.305212, -0.939347, 0.156434>, <0.310396, -0.949790, 0.222416>, <0.313296, -0.958665, 0.150539> }
triangle { <0.313296, -0.958665, 0.150539>, <0.308064, -0.948125, 0.078459>, <0.305212, -0.939347, 0.156434> }
triangle { <0.308064, -0.948125, 0.078459>, <0.313296, -0.958665, 0.150539>, <0.314265, -0.961629, 0.078217> }
triangle { <0.314265, -0.961629, 0.078217>, <0.309017, -0.951057, 0.000000>, <0.308064, -0.948125, 0.078459> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.026337, -0.077631, 0.997394> }
triangle { <0.026337, -0.077631, 0.997394>, <0.024657, -0.075449, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024657, -0.075449, 0.997158>, <0.026337, -0.077631, 0.997394>, <0.052511, -0.154783, 0.989591> }
triangle { <0.052511, -0.154783, 0.989591>, <0.049162, -0.150432, 0.988651>, <0.024657, -0.075449, 0.997158> }
triangle { <0.049162, -0.150432, 0.988651>, <0.052511, -0.154783, 0.989591>, <0.078361, -0.230981, 0.976639> }
triangle { <0.078361, -0.230981, 0.976639>, <0.073364, -0.224488, 0.974531>, <0.049162, -0.150432, 0.988651> }
triangle { <0.073364, -0.224488, 0.974531>, <0.078361, -0.230981, 0.976639>, <0.103729, -0.305754, 0.958619> }
triangle { <0.103729, -0.305754, 0.958619>, <0.097113, -0.297160, 0.954885>, <0.073364, -0.224488, 0.974531> }
triangle { <0.097113, -0.297160, 0.954885>, <0.103729, -0.305754, 0.958619>, <0.128457, -0.378643, 0.935641> }
triangle { <0.128457, -0.378643, 0.935641>, <0.120264, -0.368000, 0.929833>, <0.097113, -0.297160, 0.954885> }
triangle { <0.120264, -0.368000, 0.929833>, <0.128457, -0.378643, 0.935641>, <0.152393, -0.449197, 0.907847> }
triangle { <0.152393, -0.449197, 0.907847>, <0.142673, -0.436570, 0.899532>, <0.120264, -0.368000, 0.929833> }
triangle { <0.142673, -0.436570, 0.899532>, <0.152393, -0.449197, 0.907847>, <0.175389, -0.516982, 0.875409> }
triangle { <0.175389, -0.516982, 0.875409>, <0.164203, -0.502450, 0.864166>, <0.142673, -0.436570, 0.899532> }
triangle { <0.164203, -0.502450, 0.864166>, <0.175389, -0.516982, 0.875409>, <0.197304, -0.581579, 0.838525> }
triangle { <0.197304, -0.581579, 0.838525>, <0.184720, -0.565231, 0.823955>, <0.164203, -0.502450, 0.864166> }
triangle { <0.184720, -0.565231, 0.823955>, <0.197304, -0.581579, 0.838525>, <0.218003, -0.642591, 0.797425> }
triangle { <0.218003, -0.642591, 0.797425>, <0.204099, -0.624528, 0.779146>, <0.184720, -0.565231, 0.823955> }
triangle { <0.204099, -0.624528, 0.779146>, <0.218003, -0.642591, 0.797425>, <0.237357, -0.699641, 0.752361> }
triangle { <0.237357, -0.699641, 0.752361>, <0.222219, -0.679974, 0.730016>, <0.204099, -0.624528, 0.779146> }
triangle { <0.222219, -0.679974, 0.730016>, <0.237357, -0.699641, 0.752361>, <0.255248, -0.752377, 0.703611> }
triangle { <0.255248, -0.752377, 0.703611>, <0.238969, -0.731229, 0.676867>, <0.222219, -0.679974, 0.730016> }
triangle { <0.238969, -0.731229, 0.676867>, <0.255248, -0.752377, 0.703611>, <0.271566, -0.800475, 0.651476> }
triangle { <0.271566, -0.800475, 0.651476>, <0.254245, -0.777974, 0.620028>, <0.238969, -0.731229, 0.676867> }
triangle { <0.254245, -0.777974, 0.620028>, <0.271566, -0.800475, 0.651476>, <0.286209, -0.843638, 0.596277> }
triangle { <0.286209, -0.843638, 0.596277>, <0.267955, -0.819924, 0.559847>, <0.254245, -0.777974, 0.620028> }
triangle { <0.267955, -0.819924, 0.559847>, <0.286209, -0.843638, 0.596277>, <0.299088, -0.881599, 0.538354> }
triangle { <0.299088, -0.881599, 0.538354>, <0.280012, -0.856818, 0.496698>, <0.267955, -0.819924, 0.559847> }
triangle { <0.280012, -0.856818, 0.496698>, <0.299088, -0.881599, 0.538354>, <0.310122, -0.914125, 0.478064> }
triangle { <0.310122, -0.914125, 0.478064>, <0.290343, -0.888429, 0.430968>, <0.280012, -0.856818, 0.496698> }
triangle { <0.290343, -0.888429, 0.430968>, <0.310122, -0.914125, 0.478064>, <0.319245, -0.941015, 0.415780> }
triangle { <0.319245, -0.941015, 0.415780>, <0.298883, -0.914564, 0.363064>, <0.290343, -0.888429, 0.430968> }
triangle { <0.298883, -0.914564, 0.363064>, <0.319245, -0.941015, 0.415780>, <0.326399, -0.962103, 0.351885> }
triangle { <0.326399, -0.962103, 0.351885>, <0.305582, -0.935059, 0.293403>, <0.298883, -0.914564, 0.363064> }
triangle { <0.305582, -0.935059, 0.293403>, <0.326399, -0.962103, 0.351885>, <0.331541, -0.977260, 0.286773> }
triangle { <0.331541, -0.977260, 0.286773>, <0.310396, -0.949790, 0.222416>, <0.305582, -0.935059, 0.293403> }
triangle { <0.310396, -0.949790, 0.222416>, <0.331541, -0.977260, 0.286773>, <0.334639, -0.986392, 0.220845> }
triangle { <0.334639, -0.986392, 0.220845>, <0.313296, -0.958665, 0.150539>, <0.310396, -0.949790, 0.222416> }
triangle { <0.313296, -0.958665, 0.150539>, <0.334639, -0.986392, 0.220845>, <0.335674, -0.989442, 0.154508> }
triangle { <0.335674, -0.989442, 0.154508>, <0.314265, -0.961629, 0.078217>, <0.313296, -0.958665, 0.150539> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.029789, -0.080538, 0.997617> }
triangle { <0.029789, -0.080538, 0.997617>, <0.026337, -0.077631, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <0.026337, -0.077631, 0.997394>, <0.029789, -0.080538, 0.997617>, <0.059395, -0.160580, 0.990483> }
triangle { <0.059395, -0.160580, 0.990483>, <0.052511, -0.154783, 0.989591>, <0.026337, -0.077631, 0.997394> }
triangle { <0.052511, -0.154783, 0.989591>, <0.059395, -0.160580, 0.990483>, <0.088635, -0.239632, 0.978642> }
triangle { <0.088635, -0.239632, 0.978642>, <0.078361, -0.230981, 0.976639>, <0.052511, -0.154783, 0.989591> }
triangle { <0.078361, -0.230981, 0.976639>, <0.088635, -0.239632, 0.978642>, <0.117328, -0.317206, 0.962166> }
triangle { <0.117328, -0.317206, 0.962166>, <0.103729, -0.305754, 0.958619>, <0.078361, -0.230981, 0.976639> }
triangle { <0.103729, -0.305754, 0.958619>, <0.117328, -0.317206, 0.962166>, <0.145298, -0.392825, 0.941159> }
triangle { <0.145298, -0.392825, 0.941159>, <0.128457, -0.378643, 0.935641>, <0.103729, -0.305754, 0.958619> }
triangle { <0.128457, -0.378643, 0.935641>, <0.145298, -0.392825, 0.941159>, <0.172372, -0.466022, 0.915748> }
triangle { <0.172372, -0.466022, 0.915748>, <0.152393, -0.449197, 0.907847>, <0.128457, -0.378643, 0.935641> }
triangle { <0.152393, -0.449197, 0.907847>, <0.172372, -0.466022, 0.915748>, <0.198383, -0.536345, 0.886090> }
triangle { <0.198383, -0.536345, 0.886090>, <0.175389, -0.516982, 0.875409>, <0.152393, -0.449197, 0.907847> }
triangle { <0.175389, -0.516982, 0.875409>, <0.198383, -0.536345, 0.886090>, <0.223171, -0.603362, 0.852369> }
triangle { <0.223171, -0.603362, 0.852369>, <0.197304, -0.581579, 0.838525>, <0.175389, -0.516982, 0.875409> }
triangle { <0.197304, -0.581579, 0.838525>, <0.223171, -0.603362, 0.852369>, <0.246583, -0.666659, 0.814793> }
triangle { <0.246583, -0.666659, 0.814793>, <0.218003, -0.642591, 0.797425>, <0.197304, -0.581579, 0.838525> }
triangle { <0.218003, -0.642591, 0.797425>, <0.246583, -0.666659, 0.814793>, <0.268475, -0.725846, 0.773592> }
triangle { <0.268475, -0.725846, 0.773592>, <0.237357, -0.699641, 0.752361>, <0.218003, -0.642591, 0.797425> }
triangle { <0.237357, -0.699641, 0.752361>, <0.268475, -0.725846, 0.773592>, <0.288712, -0.780558, 0.729022> }
triangle { <0.288712, -0.780558, 0.729022>, <0.255248, -0.752377, 0.703611>, <0.237357, -0.699641, 0.752361> }
triangle { <0.255248, -0.752377, 0.703611>, <0.288712, -0.780558, 0.729022>, <0.307169, -0.830457, 0.681356> }
triangle { <0.307169, -0.830457, 0.681356>, <0.271566, -0.800475, 0.651476>, <0.255248, -0.752377, 0.703611> }
triangle { <0.271566, -0.800475, 0.651476>, <0.307169, -0.830457, 0.681356>, <0.323732, -0.875236, 0.630889> }
triangle { <0.323732, -0.875236, 0.630889>, <0.286209, -0.843638, 0.596277>, <0.271566, -0.800475, 0.651476> }
triangle { <0.286209, -0.843638, 0.596277>, <0.323732, -0.875236, 0.630889>, <0.338299, -0.914619, 0.577932> }
triangle { <0.338299, -0.914619, 0.577932>, <0.299088, -0.881599, 0.538354>, <0.286209, -0.843638, 0.596277> }
triangle { <0.299088, -0.881599, 0.538354>, <0.338299, -0.914619, 0.577932>, <0.350780, -0.948364, 0.522811> }
triangle { <0.350780, -0.948364, 0.522811>, <0.310122, -0.914125, 0.478064>, <0.299088, -0.881599, 0.538354> }
triangle { <0.310122, -0.914125, 0.478064>, <0.350780, -0.948364, 0.522811>, <0.361099, -0.976261, 0.465867> }
triangle { <0.361099, -0.976261, 0.465867>, <0.319245, -0.941015, 0.415780>, <0.310122, -0.914125, 0.478064> }
triangle { <0.319245, -0.941015, 0.415780>, <0.361099, -0.976261, 0.465867>, <0.369191, -0.998139, 0.407450> }
triangle { <0.369191, -0.998139, 0.407450>, <0.326399, -0.962103, 0.351885>, <0.319245, -0.941015, 0.415780> }
triangle { <0.326399, -0.962103, 0.351885>, <0.369191, -0.998139, 0.407450>, <0.375007, -1.013863, 0.347920> }
triangle { <0.375007, -1.013863, 0.347920>, <0.331541, -0.977260, 0.286773>, <0.326399, -0.962103, 0.351885> }
triangle { <0.331541, -0.977260, 0.286773>, <0.375007, -1.013863, 0.347920>, <0.378511, -1.023337, 0.287645> }
triangle { <0.378511, -1.023337, 0.287645>, <0.334639, -0.986392, 0.220845>, <0.331541, -0.977260, 0.286773> }
triangle { <0.334639, -0.986392, 0.220845>, <0.378511, -1.023337, 0.287645>, <0.379681, -1.026501, 0.226995> }
triangle { <0.379681, -1.026501, 0.226995>, <0.335674, -0.989442, 0.154508>, <0.334639, -0.986392, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.035250, -0.083397, 0.997823> }
triangle { <0.035250, -0.083397, 0.997823>, <0.029789, -0.080538, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <0.029789, -0.080538, 0.997617>, <0.035250, -0.083397, 0.997823>, <0.070282, -0.166279, 0.991307> }
triangle { <0.070282, -0.166279, 0.991307>, <0.059395, -0.160580, 0.990483>, <0.029789, -0.080538, 0.997617> }
triangle { <0.059395, -0.160580, 0.990483>, <0.070282, -0.166279, 0.991307>, <0.104881, -0.248136, 0.980490> }
triangle { <0.104881, -0.248136, 0.980490>, <0.088635, -0.239632, 0.978642>, <0.059395, -0.160580, 0.990483> }
triangle { <0.088635, -0.239632, 0.978642>, <0.104881, -0.248136, 0.980490>, <0.138834, -0.328464, 0.965441> }
triangle { <0.138834, -0.328464, 0.965441>, <0.117328, -0.317206, 0.962166>, <0.088635, -0.239632, 0.978642> }
triangle { <0.117328, -0.317206, 0.962166>, <0.138834, -0.328464, 0.965441>, <0.171930, -0.406766, 0.946251> }
triangle { <0.171930, -0.406766, 0.946251>, <0.145298, -0.392825, 0.941159>, <0.117328, -0.317206, 0.962166> }
triangle { <0.145298, -0.392825, 0.941159>, <0.171930, -0.406766, 0.946251>, <0.203967, -0.482561, 0.923039> }
triangle { <0.203967, -0.482561, 0.923039>, <0.172372, -0.466022, 0.915748>, <0.145298, -0.392825, 0.941159> }
triangle { <0.172372, -0.466022, 0.915748>, <0.203967, -0.482561, 0.923039>, <0.234746, -0.555380, 0.895948> }
triangle { <0.234746, -0.555380, 0.895948>, <0.198383, -0.536345, 0.886090>, <0.172372, -0.466022, 0.915748> }
triangle { <0.198383, -0.536345, 0.886090>, <0.234746, -0.555380, 0.895948>, <0.264078, -0.624775, 0.865145> }
triangle { <0.264078, -0.624775, 0.865145>, <0.223171, -0.603362, 0.852369>, <0.198383, -0.536345, 0.886090> }
triangle { <0.223171, -0.603362, 0.852369>, <0.264078, -0.624775, 0.865145>, <0.291781, -0.690319, 0.830821> }
triangle { <0.291781, -0.690319, 0.830821>, <0.246583, -0.666659, 0.814793>, <0.223171, -0.603362, 0.852369> }
triangle { <0.246583, -0.666659, 0.814793>, <0.291781, -0.690319, 0.830821>, <0.317686, -0.751606, 0.793186> }
triangle { <0.317686, -0.751606, 0.793186>, <0.268475, -0.725846, 0.773592>, <0.246583, -0.666659, 0.814793> }
triangle { <0.268475, -0.725846, 0.773592>, <0.317686, -0.751606, 0.793186>, <0.341632, -0.808259, 0.752473> }
triangle { <0.341632, -0.808259, 0.752473>, <0.288712, -0.780558, 0.729022>, <0.268475, -0.725846, 0.773592> }
triangle { <0.288712, -0.780558, 0.729022>, <0.341632, -0.808259, 0.752473>, <0.363472, -0.859930, 0.708932> }
triangle { <0.363472, -0.859930, 0.708932>, <0.307169, -0.830457, 0.681356>, <0.288712, -0.780558, 0.729022> }
triangle { <0.307169, -0.830457, 0.681356>, <0.363472, -0.859930, 0.708932>, <0.383070, -0.906298, 0.662833> }
triangle { <0.383070, -0.906298, 0.662833>, <0.323732, -0.875236, 0.630889>, <0.307169, -0.830457, 0.681356> }
triangle { <0.323732, -0.875236, 0.630889>, <0.383070, -0.906298, 0.662833>, <0.400307, -0.947079, 0.614459> }
triangle { <0.400307, -0.947079, 0.614459>, <0.338299, -0.914619, 0.577932>, <0.323732, -0.875236, 0.630889> }
triangle { <0.338299, -0.914619, 0.577932>, <0.400307, -0.947079, 0.614459>, <0.415076, -0.982021, 0.564108> }
triangle { <0.415076, -0.982021, 0.564108>, <0.350780, -0.948364, 0.522811>, <0.338299, -0.914619, 0.577932> }
triangle { <0.350780, -0.948364, 0.522811>, <0.415076, -0.982021, 0.564108>, <0.427286, -1.010908, 0.512092> }
triangle { <0.427286, -1.010908, 0.512092>, <0.361099, -0.976261, 0.465867>, <0.350780, -0.948364, 0.522811> }
triangle { <0.361099, -0.976261, 0.465867>, <0.427286, -1.010908, 0.512092>, <0.436862, -1.033563, 0.458730> }
triangle { <0.436862, -1.033563, 0.458730>, <0.369191, -0.998139, 0.407450>, <0.361099, -0.976261, 0.465867> }
triangle { <0.369191, -0.998139, 0.407450>, <0.436862, -1.033563, 0.458730>, <0.443744, -1.049845, 0.404352> }
triangle { <0.443744, -1.049845, 0.404352>, <0.375007, -1.013863, 0.347920>, <0.369191, -0.998139, 0.407450> }
triangle { <0.375007, -1.013863, 0.347920>, <0.443744, -1.049845, 0.404352>, <0.447891, -1.059655, 0.349293> }
triangle { <0.447891, -1.059655, 0.349293>, <0.378511, -1.023337, 0.287645>, <0.375007, -1.013863, 0.347920> }
triangle { <0.378511, -1.023337, 0.287645>, <0.447891, -1.059655, 0.349293>, <0.449276, -1.062931, 0.293893> }
triangle { <0.449276, -1.062931, 0.293893>, <0.379681, -1.026501, 0.226995>, <0.378511, -1.023337, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.042646, -0.085393, 0.998007> }
triangle { <0.042646, -0.085393, 0.998007>, <0.035250, -0.083397, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <0.035250, -0.083397, 0.997823>, <0.042646, -0.085393, 0.998007>, <0.085028, -0.170260, 0.992041> }
triangle { <0.085028, -0.170260, 0.992041>, <0.070282, -0.166279, 0.991307>, <0.035250, -0.083397, 0.997823> }
triangle { <0.070282, -0.166279, 0.991307>, <0.085028, -0.170260, 0.992041>, <0.126887, -0.254077, 0.982139> }
triangle { <0.126887, -0.254077, 0.982139>, <0.104881, -0.248136, 0.980490>, <0.070282, -0.166279, 0.991307> }
triangle { <0.104881, -0.248136, 0.980490>, <0.126887, -0.254077, 0.982139>, <0.167963, -0.336327, 0.968361> }
triangle { <0.167963, -0.336327, 0.968361>, <0.138834, -0.328464, 0.965441>, <0.104881, -0.248136, 0.980490> }
triangle { <0.138834, -0.328464, 0.965441>, <0.167963, -0.336327, 0.968361>, <0.208003, -0.416504, 0.950792> }
triangle { <0.208003, -0.416504, 0.950792>, <0.171930, -0.406766, 0.946251>, <0.138834, -0.328464, 0.965441> }
triangle { <0.171930, -0.406766, 0.946251>, <0.208003, -0.416504, 0.950792>, <0.246761, -0.494113, 0.929542> }
triangle { <0.246761, -0.494113, 0.929542>, <0.203967, -0.482561, 0.923039>, <0.171930, -0.406766, 0.946251> }
triangle { <0.203967, -0.482561, 0.923039>, <0.246761, -0.494113, 0.929542>, <0.283998, -0.568676, 0.904740> }
triangle { <0.283998, -0.568676, 0.904740>, <0.234746, -0.555380, 0.895948>, <0.203967, -0.482561, 0.923039> }
triangle { <0.234746, -0.555380, 0.895948>, <0.283998, -0.568676, 0.904740>, <0.319484, -0.639732, 0.876540> }
triangle { <0.319484, -0.639732, 0.876540>, <0.264078, -0.624775, 0.865145>, <0.234746, -0.555380, 0.895948> }
triangle { <0.264078, -0.624775, 0.865145>, <0.319484, -0.639732, 0.876540>, <0.353000, -0.706845, 0.845115> }
triangle { <0.353000, -0.706845, 0.845115>, <0.291781, -0.690319, 0.830821>, <0.264078, -0.624775, 0.865145> }
triangle { <0.291781, -0.690319, 0.830821>, <0.353000, -0.706845, 0.845115>, <0.384340, -0.769599, 0.810660> }
triangle { <0.384340, -0.769599, 0.810660>, <0.317686, -0.751606, 0.793186>, <0.291781, -0.690319, 0.830821> }
triangle { <0.317686, -0.751606, 0.793186>, <0.384340, -0.769599, 0.810660>, <0.413310, -0.827609, 0.773387> }
triangle { <0.413310, -0.827609, 0.773387>, <0.341632, -0.808259, 0.752473>, <0.317686, -0.751606, 0.793186> }
triangle { <0.341632, -0.808259, 0.752473>, <0.413310, -0.827609, 0.773387>, <0.439732, -0.880516, 0.733525> }
triangle { <0.439732, -0.880516, 0.733525>, <0.363472, -0.859930, 0.708932>, <0.341632, -0.808259, 0.752473> }
triangle { <0.363472, -0.859930, 0.708932>, <0.439732, -0.880516, 0.733525>, <0.463443, -0.927994, 0.691321> }
triangle { <0.463443, -0.927994, 0.691321>, <0.383070, -0.906298, 0.662833>, <0.363472, -0.859930, 0.708932> }
triangle { <0.383070, -0.906298, 0.662833>, <0.463443, -0.927994, 0.691321>, <0.484297, -0.969751, 0.647034> }
triangle { <0.484297, -0.969751, 0.647034>, <0.400307, -0.947079, 0.614459>, <0.383070, -0.906298, 0.662833> }
triangle { <0.400307, -0.947079, 0.614459>, <0.484297, -0.969751, 0.647034>, <0.502164, -1.005530, 0.600938> }
triangle { <0.502164, -1.005530, 0.600938>, <0.415076, -0.982021, 0.564108>, <0.400307, -0.947079, 0.614459> }
triangle { <0.415076, -0.982021, 0.564108>, <0.502164, -1.005530, 0.600938>, <0.516936, -1.035108, 0.553316> }
triangle { <0.516936, -1.035108, 0.553316>, <0.427286, -1.010908, 0.512092>, <0.415076, -0.982021, 0.564108> }
triangle { <0.427286, -1.010908, 0.512092>, <0.516936, -1.035108, 0.553316>, <0.528521, -1.058305, 0.504463> }
triangle { <0.528521, -1.058305, 0.504463>, <0.436862, -1.033563, 0.458730>, <0.427286, -1.010908, 0.512092> }
triangle { <0.436862, -1.033563, 0.458730>, <0.528521, -1.058305, 0.504463>, <0.536847, -1.074978, 0.454680> }
triangle { <0.536847, -1.074978, 0.454680>, <0.443744, -1.049845, 0.404352>, <0.436862, -1.033563, 0.458730> }
triangle { <0.443744, -1.049845, 0.404352>, <0.536847, -1.074978, 0.454680>, <0.541863, -1.085022, 0.404273> }
triangle { <0.541863, -1.085022, 0.404273>, <0.447891, -1.059655, 0.349293>, <0.443744, -1.049845, 0.404352> }
triangle { <0.447891, -1.059655, 0.349293>, <0.541863, -1.085022, 0.404273>, <0.543539, -1.088377, 0.353553> }
triangle { <0.543539, -1.088377, 0.353553>, <0.449276, -1.062931, 0.293893>, <0.447891, -1.059655, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.051606, -0.085794, 0.998164> }
triangle { <0.051606, -0.085794, 0.998164>, <0.042646, -0.085393, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <0.042646, -0.085393, 0.998007>, <0.051606, -0.085794, 0.998164>, <0.102894, -0.171058, 0.992669> }
triangle { <0.102894, -0.171058, 0.992669>, <0.085028, -0.170260, 0.992041>, <0.042646, -0.085393, 0.998007> }
triangle { <0.085028, -0.170260, 0.992041>, <0.102894, -0.171058, 0.992669>, <0.153547, -0.255268, 0.983547> }
triangle { <0.153547, -0.255268, 0.983547>, <0.126887, -0.254077, 0.982139>, <0.085028, -0.170260, 0.992041> }
triangle { <0.126887, -0.254077, 0.982139>, <0.153547, -0.255268, 0.983547>, <0.203254, -0.337904, 0.970855> }
triangle { <0.203254, -0.337904, 0.970855>, <0.167963, -0.336327, 0.968361>, <0.126887, -0.254077, 0.982139> }
triangle { <0.167963, -0.336327, 0.968361>, <0.203254, -0.337904, 0.970855>, <0.251708, -0.418457, 0.954671> }
triangle { <0.251708, -0.418457, 0.954671>, <0.208003, -0.416504, 0.950792>, <0.167963, -0.336327, 0.968361> }
triangle { <0.208003, -0.416504, 0.950792>, <0.251708, -0.418457, 0.954671>, <0.298609, -0.496430, 0.935095> }
triangle { <0.298609, -0.496430, 0.935095>, <0.246761, -0.494113, 0.929542>, <0.208003, -0.416504, 0.950792> }
triangle { <0.246761, -0.494113, 0.929542>, <0.298609, -0.496430, 0.935095>, <0.343670, -0.571343, 0.912248> }
triangle { <0.343670, -0.571343, 0.912248>, <0.283998, -0.568676, 0.904740>, <0.246761, -0.494113, 0.929542> }
triangle { <0.283998, -0.568676, 0.904740>, <0.343670, -0.571343, 0.912248>, <0.386612, -0.642732, 0.886271> }
triangle { <0.386612, -0.642732, 0.886271>, <0.319484, -0.639732, 0.876540>, <0.283998, -0.568676, 0.904740> }
triangle { <0.319484, -0.639732, 0.876540>, <0.386612, -0.642732, 0.886271>, <0.427170, -0.710159, 0.857324> }
triangle { <0.427170, -0.710159, 0.857324>, <0.353000, -0.706845, 0.845115>, <0.319484, -0.639732, 0.876540> }
triangle { <0.353000, -0.706845, 0.845115>, <0.427170, -0.710159, 0.857324>, <0.465095, -0.773208, 0.825585> }
triangle { <0.465095, -0.773208, 0.825585>, <0.384340, -0.769599, 0.810660>, <0.353000, -0.706845, 0.845115> }
triangle { <0.384340, -0.769599, 0.810660>, <0.465095, -0.773208, 0.825585>, <0.500152, -0.831490, 0.791249> }
triangle { <0.500152, -0.831490, 0.791249>, <0.413310, -0.827609, 0.773387>, <0.384340, -0.769599, 0.810660> }
triangle { <0.413310, -0.827609, 0.773387>, <0.500152, -0.831490, 0.791249>, <0.532126, -0.884645, 0.754530> }
triangle { <0.532126, -0.884645, 0.754530>, <0.439732, -0.880516, 0.733525>, <0.413310, -0.827609, 0.773387> }
triangle { <0.439732, -0.880516, 0.733525>, <0.532126, -0.884645, 0.754530>, <0.560818, -0.932346, 0.715652> }
triangle { <0.560818, -0.932346, 0.715652>, <0.463443, -0.927994, 0.691321>, <0.439732, -0.880516, 0.733525> }
triangle { <0.463443, -0.927994, 0.691321>, <0.560818, -0.932346, 0.715652>, <0.586054, -0.974299, 0.674856> }
triangle { <0.586054, -0.974299, 0.674856>, <0.484297, -0.969751, 0.647034>, <0.463443, -0.927994, 0.691321> }
triangle { <0.484297, -0.969751, 0.647034>, <0.586054, -0.974299, 0.674856>, <0.607676, -1.010245, 0.632393> }
triangle { <0.607676, -1.010245, 0.632393>, <0.502164, -1.005530, 0.600938>, <0.484297, -0.969751, 0.647034> }
triangle { <0.502164, -1.005530, 0.600938>, <0.607676, -1.010245, 0.632393>, <0.625551, -1.039963, 0.588525> }
triangle { <0.625551, -1.039963, 0.588525>, <0.516936, -1.035108, 0.553316>, <0.502164, -1.005530, 0.600938> }
triangle { <0.516936, -1.035108, 0.553316>, <0.625551, -1.039963, 0.588525>, <0.639570, -1.063268, 0.543523> }
triangle { <0.639570, -1.063268, 0.543523>, <0.528521, -1.058305, 0.504463>, <0.516936, -1.035108, 0.553316> }
triangle { <0.528521, -1.058305, 0.504463>, <0.639570, -1.063268, 0.543523>, <0.649646, -1.080019, 0.497664> }
triangle { <0.649646, -1.080019, 0.497664>, <0.536847, -1.074978, 0.454680>, <0.528521, -1.058305, 0.504463> }
triangle { <0.536847, -1.074978, 0.454680>, <0.649646, -1.080019, 0.497664>, <0.655716, -1.090111, 0.451230> }
triangle { <0.655716, -1.090111, 0.451230>, <0.541863, -1.085022, 0.404273>, <0.536847, -1.074978, 0.454680> }
triangle { <0.541863, -1.085022, 0.404273>, <0.655716, -1.090111, 0.451230>, <0.657743, -1.093481, 0.404508> }
triangle { <0.657743, -1.093481, 0.404508>, <0.543539, -1.088377, 0.353553>, <0.541863, -1.085022, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.061510, -0.084047, 0.998291> }
triangle { <0.061510, -0.084047, 0.998291>, <0.051606, -0.085794, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <0.051606, -0.085794, 0.998164>, <0.061510, -0.084047, 0.998291>, <0.122642, -0.167576, 0.993173> }
triangle { <0.122642, -0.167576, 0.993173>, <0.102894, -0.171058, 0.992669>, <0.051606, -0.085794, 0.998164> }
triangle { <0.102894, -0.171058, 0.992669>, <0.122642, -0.167576, 0.993173>, <0.183017, -0.250071, 0.984679> }
triangle { <0.183017, -0.250071, 0.984679>, <0.153547, -0.255268, 0.983547>, <0.102894, -0.171058, 0.992669> }
triangle { <0.153547, -0.255268, 0.983547>, <0.183017, -0.250071, 0.984679>, <0.242263, -0.331025, 0.972861> }
triangle { <0.242263, -0.331025, 0.972861>, <0.203254, -0.337904, 0.970855>, <0.153547, -0.255268, 0.983547> }
triangle { <0.203254, -0.337904, 0.970855>, <0.242263, -0.331025, 0.972861>, <0.300016, -0.409938, 0.957791> }
triangle { <0.300016, -0.409938, 0.957791>, <0.251708, -0.418457, 0.954671>, <0.203254, -0.337904, 0.970855> }
triangle { <0.251708, -0.418457, 0.954671>, <0.300016, -0.409938, 0.957791>, <0.355920, -0.486324, 0.939563> }
triangle { <0.355920, -0.486324, 0.939563>, <0.298609, -0.496430, 0.935095>, <0.251708, -0.418457, 0.954671> }
triangle { <0.298609, -0.496430, 0.935095>, <0.355920, -0.486324, 0.939563>, <0.409629, -0.559711, 0.918289> }
triangle { <0.409629, -0.559711, 0.918289>, <0.343670, -0.571343, 0.912248>, <0.298609, -0.496430, 0.935095> }
triangle { <0.343670, -0.571343, 0.912248>, <0.409629, -0.559711, 0.918289>, <0.460812, -0.629647, 0.894101> }
triangle { <0.460812, -0.629647, 0.894101>, <0.386612, -0.642732, 0.886271>, <0.343670, -0.571343, 0.912248> }
triangle { <0.386612, -0.642732, 0.886271>, <0.460812, -0.629647, 0.894101>, <0.509154, -0.695702, 0.867146> }
triangle { <0.509154, -0.695702, 0.867146>, <0.427170, -0.710159, 0.857324>, <0.386612, -0.642732, 0.886271> }
triangle { <0.427170, -0.710159, 0.857324>, <0.509154, -0.695702, 0.867146>, <0.554358, -0.757467, 0.837592> }
triangle { <0.554358, -0.757467, 0.837592>, <0.465095, -0.773208, 0.825585>, <0.427170, -0.710159, 0.857324> }
triangle { <0.465095, -0.773208, 0.825585>, <0.554358, -0.757467, 0.837592>, <0.596143, -0.814562, 0.805620> }
triangle { <0.596143, -0.814562, 0.805620>, <0.500152, -0.831490, 0.791249>, <0.465095, -0.773208, 0.825585> }
triangle { <0.500152, -0.831490, 0.791249>, <0.596143, -0.814562, 0.805620>, <0.634253, -0.866635, 0.771428> }
triangle { <0.634253, -0.866635, 0.771428>, <0.532126, -0.884645, 0.754530>, <0.500152, -0.831490, 0.791249> }
triangle { <0.532126, -0.884645, 0.754530>, <0.634253, -0.866635, 0.771428>, <0.668453, -0.913365, 0.735227> }
triangle { <0.668453, -0.913365, 0.735227>, <0.560818, -0.932346, 0.715652>, <0.532126, -0.884645, 0.754530> }
triangle { <0.560818, -0.932346, 0.715652>, <0.668453, -0.913365, 0.735227>, <0.698532, -0.954464, 0.697240> }
triangle { <0.698532, -0.954464, 0.697240>, <0.586054, -0.974299, 0.674856>, <0.560818, -0.932346, 0.715652> }
triangle { <0.586054, -0.974299, 0.674856>, <0.698532, -0.954464, 0.697240>, <0.724303, -0.989678, 0.657700> }
triangle { <0.724303, -0.989678, 0.657700>, <0.607676, -1.010245, 0.632393>, <0.586054, -0.974299, 0.674856> }
triangle { <0.607676, -1.010245, 0.632393>, <0.724303, -0.989678, 0.657700>, <0.745610, -1.018791, 0.616852> }
triangle { <0.745610, -1.018791, 0.616852>, <0.625551, -1.039963, 0.588525>, <0.607676, -1.010245, 0.632393> }
triangle { <0.625551, -1.039963, 0.588525>, <0.745610, -1.018791, 0.616852>, <0.762319, -1.041622, 0.574948> }
triangle { <0.762319, -1.041622, 0.574948>, <0.639570, -1.063268, 0.543523>, <0.625551, -1.039963, 0.588525> }
triangle { <0.639570, -1.063268, 0.543523>, <0.762319, -1.041622, 0.574948>, <0.774328, -1.058031, 0.532246> }
triangle { <0.774328, -1.058031, 0.532246>, <0.649646, -1.080019, 0.497664>, <0.639570, -1.063268, 0.543523> }
triangle { <0.649646, -1.080019, 0.497664>, <0.774328, -1.058031, 0.532246>, <0.781564, -1.067918, 0.489009> }
triangle { <0.781564, -1.067918, 0.489009>, <0.655716, -1.090111, 0.451230>, <0.649646, -1.080019, 0.497664> }
triangle { <0.655716, -1.090111, 0.451230>, <0.781564, -1.067918, 0.489009>, <0.783980, -1.071220, 0.445503> }
triangle { <0.783980, -1.071220, 0.445503>, <0.657743, -1.093481, 0.404508>, <0.655716, -1.090111, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.071573, -0.079865, 0.998383> }
triangle { <0.071573, -0.079865, 0.998383>, <0.061510, -0.084047, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <0.061510, -0.084047, 0.998291>, <0.071573, -0.079865, 0.998383>, <0.142706, -0.159237, 0.993543> }
triangle { <0.142706, -0.159237, 0.993543>, <0.122642, -0.167576, 0.993173>, <0.061510, -0.084047, 0.998291> }
triangle { <0.122642, -0.167576, 0.993173>, <0.142706, -0.159237, 0.993543>, <0.212958, -0.237627, 0.985509> }
triangle { <0.212958, -0.237627, 0.985509>, <0.183017, -0.250071, 0.984679>, <0.122642, -0.167576, 0.993173> }
triangle { <0.183017, -0.250071, 0.984679>, <0.212958, -0.237627, 0.985509>, <0.281897, -0.314553, 0.974331> }
triangle { <0.281897, -0.314553, 0.974331>, <0.242263, -0.331025, 0.972861>, <0.183017, -0.250071, 0.984679> }
triangle { <0.242263, -0.331025, 0.972861>, <0.281897, -0.314553, 0.974331>, <0.349099, -0.389539, 0.960077> }
triangle { <0.349099, -0.389539, 0.960077>, <0.300016, -0.409938, 0.957791>, <0.242263, -0.331025, 0.972861> }
triangle { <0.300016, -0.409938, 0.957791>, <0.349099, -0.389539, 0.960077>, <0.414148, -0.462123, 0.942836> }
triangle { <0.414148, -0.462123, 0.942836>, <0.355920, -0.486324, 0.939563>, <0.300016, -0.409938, 0.957791> }
triangle { <0.355920, -0.486324, 0.939563>, <0.414148, -0.462123, 0.942836>, <0.476643, -0.531859, 0.922714> }
triangle { <0.476643, -0.531859, 0.922714>, <0.409629, -0.559711, 0.918289>, <0.355920, -0.486324, 0.939563> }
triangle { <0.409629, -0.559711, 0.918289>, <0.476643, -0.531859, 0.922714>, <0.536200, -0.598315, 0.899835> }
triangle { <0.536200, -0.598315, 0.899835>, <0.460812, -0.629647, 0.894101>, <0.409629, -0.559711, 0.918289> }
triangle { <0.460812, -0.629647, 0.894101>, <0.536200, -0.598315, 0.899835>, <0.592452, -0.661082, 0.874340> }
triangle { <0.592452, -0.661082, 0.874340>, <0.509154, -0.695702, 0.867146>, <0.460812, -0.629647, 0.894101> }
triangle { <0.509154, -0.695702, 0.867146>, <0.592452, -0.661082, 0.874340>, <0.645050, -0.719774, 0.846386> }
triangle { <0.645050, -0.719774, 0.846386>, <0.554358, -0.757467, 0.837592>, <0.509154, -0.695702, 0.867146> }
triangle { <0.554358, -0.757467, 0.837592>, <0.645050, -0.719774, 0.846386>, <0.693672, -0.774028, 0.816145> }
triangle { <0.693672, -0.774028, 0.816145>, <0.596143, -0.814562, 0.805620>, <0.554358, -0.757467, 0.837592> }
triangle { <0.596143, -0.814562, 0.805620>, <0.693672, -0.774028, 0.816145>, <0.738017, -0.823510, 0.783805> }
triangle { <0.738017, -0.823510, 0.783805>, <0.634253, -0.866635, 0.771428>, <0.596143, -0.814562, 0.805620> }
triangle { <0.634253, -0.866635, 0.771428>, <0.738017, -0.823510, 0.783805>, <0.777811, -0.867914, 0.749564> }
triangle { <0.777811, -0.867914, 0.749564>, <0.668453, -0.913365, 0.735227>, <0.634253, -0.866635, 0.771428> }
triangle { <0.668453, -0.913365, 0.735227>, <0.777811, -0.867914, 0.749564>, <0.812811, -0.906968, 0.713633> }
triangle { <0.812811, -0.906968, 0.713633>, <0.698532, -0.954464, 0.697240>, <0.668453, -0.913365, 0.735227> }
triangle { <0.698532, -0.954464, 0.697240>, <0.812811, -0.906968, 0.713633>, <0.842799, -0.940430, 0.676235> }
triangle { <0.842799, -0.940430, 0.676235>, <0.724303, -0.989678, 0.657700>, <0.698532, -0.954464, 0.697240> }
triangle { <0.724303, -0.989678, 0.657700>, <0.842799, -0.940430, 0.676235>, <0.867590, -0.968094, 0.637599> }
triangle { <0.867590, -0.968094, 0.637599>, <0.745610, -1.018791, 0.616852>, <0.724303, -0.989678, 0.657700> }
triangle { <0.745610, -1.018791, 0.616852>, <0.867590, -0.968094, 0.637599>, <0.887033, -0.989789, 0.597964> }
triangle { <0.887033, -0.989789, 0.597964>, <0.762319, -1.041622, 0.574948>, <0.745610, -1.018791, 0.616852> }
triangle { <0.762319, -1.041622, 0.574948>, <0.887033, -0.989789, 0.597964>, <0.901007, -1.005382, 0.557574> }
triangle { <0.901007, -1.005382, 0.557574>, <0.774328, -1.058031, 0.532246>, <0.762319, -1.041622, 0.574948> }
triangle { <0.774328, -1.058031, 0.532246>, <0.901007, -1.005382, 0.557574>, <0.909426, -1.014776, 0.516678> }
triangle { <0.909426, -1.014776, 0.516678>, <0.781564, -1.067918, 0.489009>, <0.774328, -1.058031, 0.532246> }
triangle { <0.781564, -1.067918, 0.489009>, <0.909426, -1.014776, 0.516678>, <0.912239, -1.017914, 0.475528> }
triangle { <0.912239, -1.017914, 0.475528>, <0.783980, -1.071220, 0.445503>, <0.781564, -1.067918, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.080953, -0.073263, 0.998440> }
triangle { <0.080953, -0.073263, 0.998440>, <0.071573, -0.079865, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <0.071573, -0.079865, 0.998383>, <0.080953, -0.073263, 0.998440>, <0.161406, -0.146074, 0.993768> }
triangle { <0.161406, -0.146074, 0.993768>, <0.142706, -0.159237, 0.993543>, <0.071573, -0.079865, 0.998383> }
triangle { <0.142706, -0.159237, 0.993543>, <0.161406, -0.146074, 0.993768>, <0.240865, -0.217985, 0.986015> }
triangle { <0.240865, -0.217985, 0.986015>, <0.212958, -0.237627, 0.985509>, <0.142706, -0.159237, 0.993543> }
triangle { <0.212958, -0.237627, 0.985509>, <0.240865, -0.217985, 0.986015>, <0.318838, -0.288552, 0.975227> }
triangle { <0.318838, -0.288552, 0.975227>, <0.281897, -0.314553, 0.974331>, <0.212958, -0.237627, 0.985509> }
triangle { <0.281897, -0.314553, 0.974331>, <0.318838, -0.288552, 0.975227>, <0.394846, -0.357340, 0.961471> }
triangle { <0.394846, -0.357340, 0.961471>, <0.349099, -0.389539, 0.960077>, <0.281897, -0.314553, 0.974331> }
triangle { <0.349099, -0.389539, 0.960077>, <0.394846, -0.357340, 0.961471>, <0.468419, -0.423925, 0.944832> }
triangle { <0.468419, -0.423925, 0.944832>, <0.414148, -0.462123, 0.942836>, <0.349099, -0.389539, 0.960077> }
triangle { <0.414148, -0.462123, 0.942836>, <0.468419, -0.423925, 0.944832>, <0.539104, -0.487896, 0.925413> }
triangle { <0.539104, -0.487896, 0.925413>, <0.476643, -0.531859, 0.922714>, <0.414148, -0.462123, 0.942836> }
triangle { <0.476643, -0.531859, 0.922714>, <0.539104, -0.487896, 0.925413>, <0.606466, -0.548859, 0.903333> }
triangle { <0.606466, -0.548859, 0.903333>, <0.536200, -0.598315, 0.899835>, <0.476643, -0.531859, 0.922714> }
triangle { <0.536200, -0.598315, 0.899835>, <0.606466, -0.548859, 0.903333>, <0.670088, -0.606438, 0.878728> }
triangle { <0.670088, -0.606438, 0.878728>, <0.592452, -0.661082, 0.874340>, <0.536200, -0.598315, 0.899835> }
triangle { <0.592452, -0.661082, 0.874340>, <0.670088, -0.606438, 0.878728>, <0.729580, -0.660278, 0.851750> }
triangle { <0.729580, -0.660278, 0.851750>, <0.645050, -0.719774, 0.846386>, <0.592452, -0.661082, 0.874340> }
triangle { <0.645050, -0.719774, 0.846386>, <0.729580, -0.660278, 0.851750>, <0.784573, -0.710048, 0.822566> }
triangle { <0.784573, -0.710048, 0.822566>, <0.693672, -0.774028, 0.816145>, <0.645050, -0.719774, 0.846386> }
triangle { <0.693672, -0.774028, 0.816145>, <0.784573, -0.710048, 0.822566>, <0.834729, -0.755439, 0.791355> }
triangle { <0.834729, -0.755439, 0.791355>, <0.738017, -0.823510, 0.783805>, <0.693672, -0.774028, 0.816145> }
triangle { <0.738017, -0.823510, 0.783805>, <0.834729, -0.755439, 0.791355>, <0.879738, -0.796174, 0.758310> }
triangle { <0.879738, -0.796174, 0.758310>, <0.777811, -0.867914, 0.749564>, <0.738017, -0.823510, 0.783805> }
triangle { <0.777811, -0.867914, 0.749564>, <0.879738, -0.796174, 0.758310>, <0.919324, -0.831999, 0.723634> }
triangle { <0.919324, -0.831999, 0.723634>, <0.812811, -0.906968, 0.713633>, <0.777811, -0.867914, 0.749564> }
triangle { <0.812811, -0.906968, 0.713633>, <0.919324, -0.831999, 0.723634>, <0.953242, -0.862695, 0.687542> }
triangle { <0.953242, -0.862695, 0.687542>, <0.842799, -0.940430, 0.676235>, <0.812811, -0.906968, 0.713633> }
triangle { <0.842799, -0.940430, 0.676235>, <0.953242, -0.862695, 0.687542>, <0.981282, -0.888072, 0.650255> }
triangle { <0.981282, -0.888072, 0.650255>, <0.867590, -0.968094, 0.637599>, <0.842799, -0.940430, 0.676235> }
triangle { <0.867590, -0.968094, 0.637599>, <0.981282, -0.888072, 0.650255>, <1.003273, -0.907974, 0.612004> }
triangle { <1.003273, -0.907974, 0.612004>, <0.887033, -0.989789, 0.597964>, <0.867590, -0.968094, 0.637599> }
triangle { <0.887033, -0.989789, 0.597964>, <1.003273, -0.907974, 0.612004>, <1.019078, -0.922278, 0.573024> }
triangle { <1.019078, -0.922278, 0.573024>, <0.901007, -1.005382, 0.557574>, <0.887033, -0.989789, 0.597964> }
triangle { <0.901007, -1.005382, 0.557574>, <1.019078, -0.922278, 0.573024>, <1.028601, -0.930896, 0.533557> }
triangle { <1.028601, -0.930896, 0.533557>, <0.909426, -1.014776, 0.516678>, <0.901007, -1.005382, 0.557574> }
triangle { <0.909426, -1.014776, 0.516678>, <1.028601, -0.930896, 0.533557>, <1.031781, -0.933774, 0.493844> }
triangle { <1.031781, -0.933774, 0.493844>, <0.912239, -1.017914, 0.475528>, <0.909426, -1.014776, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.088865, -0.064564, 0.998459> }
triangle { <0.088865, -0.064564, 0.998459>, <0.080953, -0.073263, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <0.080953, -0.073263, 0.998440>, <0.088865, -0.064564, 0.998459>, <0.177181, -0.128730, 0.993844> }
triangle { <0.177181, -0.128730, 0.993844>, <0.161406, -0.146074, 0.993768>, <0.080953, -0.073263, 0.998440> }
triangle { <0.161406, -0.146074, 0.993768>, <0.177181, -0.128730, 0.993844>, <0.264406, -0.192102, 0.986185> }
triangle { <0.264406, -0.192102, 0.986185>, <0.240865, -0.217985, 0.986015>, <0.161406, -0.146074, 0.993768> }
triangle { <0.240865, -0.217985, 0.986015>, <0.264406, -0.192102, 0.986185>, <0.350000, -0.254290, 0.975528> }
triangle { <0.350000, -0.254290, 0.975528>, <0.318838, -0.288552, 0.975227>, <0.240865, -0.217985, 0.986015> }
triangle { <0.318838, -0.288552, 0.975227>, <0.350000, -0.254290, 0.975528>, <0.433436, -0.314910, 0.961940> }
triangle { <0.433436, -0.314910, 0.961940>, <0.394846, -0.357340, 0.961471>, <0.318838, -0.288552, 0.975227> }
triangle { <0.394846, -0.357340, 0.961471>, <0.433436, -0.314910, 0.961940>, <0.514200, -0.373588, 0.945503> }
triangle { <0.514200, -0.373588, 0.945503>, <0.468419, -0.423925, 0.944832>, <0.394846, -0.357340, 0.961471> }
triangle { <0.468419, -0.423925, 0.944832>, <0.514200, -0.373588, 0.945503>, <0.591794, -0.429964, 0.926320> }
triangle { <0.591794, -0.429964, 0.926320>, <0.539104, -0.487896, 0.925413>, <0.468419, -0.423925, 0.944832> }
triangle { <0.539104, -0.487896, 0.925413>, <0.591794, -0.429964, 0.926320>, <0.665740, -0.483688, 0.904508> }
triangle { <0.665740, -0.483688, 0.904508>, <0.606466, -0.548859, 0.903333>, <0.539104, -0.487896, 0.925413> }
triangle { <0.606466, -0.548859, 0.903333>, <0.665740, -0.483688, 0.904508>, <0.735580, -0.534430, 0.880203> }
triangle { <0.735580, -0.534430, 0.880203>, <0.670088, -0.606438, 0.878728>, <0.606466, -0.548859, 0.903333> }
triangle { <0.670088, -0.606438, 0.878728>, <0.735580, -0.534430, 0.880203>, <0.800886, -0.581878, 0.853553> }
triangle { <0.800886, -0.581878, 0.853553>, <0.729580, -0.660278, 0.851750>, <0.670088, -0.606438, 0.878728> }
triangle { <0.729580, -0.660278, 0.851750>, <0.800886, -0.581878, 0.853553>, <0.861254, -0.625738, 0.824724> }
triangle { <0.861254, -0.625738, 0.824724>, <0.784573, -0.710048, 0.822566>, <0.729580, -0.660278, 0.851750> }
triangle { <0.784573, -0.710048, 0.822566>, <0.861254, -0.625738, 0.824724>, <0.916312, -0.665740, 0.793893> }
triangle { <0.916312, -0.665740, 0.793893>, <0.834729, -0.755439, 0.791355>, <0.784573, -0.710048, 0.822566> }
triangle { <0.834729, -0.755439, 0.791355>, <0.916312, -0.665740, 0.793893>, <0.965721, -0.701637, 0.761249> }
triangle { <0.965721, -0.701637, 0.761249>, <0.879738, -0.796174, 0.758310>, <0.834729, -0.755439, 0.791355> }
triangle { <0.879738, -0.796174, 0.758310>, <0.965721, -0.701637, 0.761249>, <1.009175, -0.733209, 0.726995> }
triangle { <1.009175, -0.733209, 0.726995>, <0.919324, -0.831999, 0.723634>, <0.879738, -0.796174, 0.758310> }
triangle { <0.919324, -0.831999, 0.723634>, <1.009175, -0.733209, 0.726995>, <1.046408, -0.760260, 0.691342> }
triangle { <1.046408, -0.760260, 0.691342>, <0.953242, -0.862695, 0.687542>, <0.919324, -0.831999, 0.723634> }
triangle { <0.953242, -0.862695, 0.687542>, <1.046408, -0.760260, 0.691342>, <1.077189, -0.782624, 0.654508> }
triangle { <1.077189, -0.782624, 0.654508>, <0.981282, -0.888072, 0.650255>, <0.953242, -0.862695, 0.687542> }
triangle { <0.981282, -0.888072, 0.650255>, <1.077189, -0.782624, 0.654508>, <1.101329, -0.800163, 0.616723> }
triangle { <1.101329, -0.800163, 0.616723>, <1.003273, -0.907974, 0.612004>, <0.981282, -0.888072, 0.650255> }
triangle { <1.003273, -0.907974, 0.612004>, <1.101329, -0.800163, 0.616723>, <1.118679, -0.812768, 0.578217> }
triangle { <1.118679, -0.812768, 0.578217>, <1.019078, -0.922278, 0.573024>, <1.003273, -0.907974, 0.612004> }
triangle { <1.019078, -0.922278, 0.573024>, <1.118679, -0.812768, 0.578217>, <1.129132, -0.820363, 0.539230> }
triangle { <1.129132, -0.820363, 0.539230>, <1.028601, -0.930896, 0.533557>, <1.019078, -0.922278, 0.573024> }
triangle { <1.028601, -0.930896, 0.533557>, <1.129132, -0.820363, 0.539230>, <1.132624, -0.822899, 0.500000> }
triangle { <1.132624, -0.822899, 0.500000>, <1.031781, -0.933774, 0.493844>, <1.028601, -0.930896, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.094693, -0.054351, 0.998440> }
triangle { <0.094693, -0.054351, 0.998440>, <0.088865, -0.064564, 0.998459>, <0.000000, 0.000000, 1.000000> }
triangle { <0.088865, -0.064564, 0.998459>, <0.094693, -0.054351, 0.998440>, <0.188802, -0.108367, 0.993768> }
triangle { <0.188802, -0.108367, 0.993768>, <0.177181, -0.128730, 0.993844>, <0.088865, -0.064564, 0.998459> }
triangle { <0.177181, -0.128730, 0.993844>, <0.188802, -0.108367, 0.993768>, <0.281748, -0.161715, 0.986015> }
triangle { <0.281748, -0.161715, 0.986015>, <0.264406, -0.192102, 0.986185>, <0.177181, -0.128730, 0.993844> }
triangle { <0.264406, -0.192102, 0.986185>, <0.281748, -0.161715, 0.986015>, <0.372956, -0.214065, 0.975227> }
triangle { <0.372956, -0.214065, 0.975227>, <0.350000, -0.254290, 0.975528>, <0.264406, -0.192102, 0.986185> }
triangle { <0.350000, -0.254290, 0.975528>, <0.372956, -0.214065, 0.975227>, <0.461865, -0.265096, 0.961471> }
triangle { <0.461865, -0.265096, 0.961471>, <0.433436, -0.314910, 0.961940>, <0.350000, -0.254290, 0.975528> }
triangle { <0.433436, -0.314910, 0.961940>, <0.461865, -0.265096, 0.961471>, <0.547926, -0.314493, 0.944832> }
triangle { <0.547926, -0.314493, 0.944832>, <0.514200, -0.373588, 0.945503>, <0.433436, -0.314910, 0.961940> }
triangle { <0.514200, -0.373588, 0.945503>, <0.547926, -0.314493, 0.944832>, <0.630609, -0.361950, 0.925413> }
triangle { <0.630609, -0.361950, 0.925413>, <0.591794, -0.429964, 0.926320>, <0.514200, -0.373588, 0.945503> }
triangle { <0.591794, -0.429964, 0.926320>, <0.630609, -0.361950, 0.925413>, <0.709404, -0.407177, 0.903333> }
triangle { <0.709404, -0.407177, 0.903333>, <0.665740, -0.483688, 0.904508>, <0.591794, -0.429964, 0.926320> }
triangle { <0.665740, -0.483688, 0.904508>, <0.709404, -0.407177, 0.903333>, <0.783825, -0.449892, 0.878728> }
triangle { <0.783825, -0.449892, 0.878728>, <0.735580, -0.534430, 0.880203>, <0.665740, -0.483688, 0.904508> }
triangle { <0.735580, -0.534430, 0.880203>, <0.783825, -0.449892, 0.878728>, <0.853414, -0.489834, 0.851750> }
triangle { <0.853414, -0.489834, 0.851750>, <0.800886, -0.581878, 0.853553>, <0.735580, -0.534430, 0.880203> }
triangle { <0.800886, -0.581878, 0.853553>, <0.853414, -0.489834, 0.851750>, <0.917742, -0.526756, 0.822566> }
triangle { <0.917742, -0.526756, 0.822566>, <0.861254, -0.625738, 0.824724>, <0.800886, -0.581878, 0.853553> }
triangle { <0.861254, -0.625738, 0.824724>, <0.917742, -0.526756, 0.822566>, <0.976411, -0.560430, 0.791355> }
triangle { <0.976411, -0.560430, 0.791355>, <0.916312, -0.665740, 0.793893>, <0.861254, -0.625738, 0.824724> }
triangle { <0.916312, -0.665740, 0.793893>, <0.976411, -0.560430, 0.791355>, <1.029060, -0.590650, 0.758310> }
triangle { <1.029060, -0.590650, 0.758310>, <0.965721, -0.701637, 0.761249>, <0.916312, -0.665740, 0.793893> }
triangle { <0.965721, -0.701637, 0.761249>, <1.029060, -0.590650, 0.758310>, <1.075365, -0.617227, 0.723634> }
triangle { <1.075365, -0.617227, 0.723634>, <1.009175, -0.733209, 0.726995>, <0.965721, -0.701637, 0.761249> }
triangle { <1.009175, -0.733209, 0.726995>, <1.075365, -0.617227, 0.723634>, <1.115040, -0.639999, 0.687542> }
triangle { <1.115040, -0.639999, 0.687542>, <1.046408, -0.760260, 0.691342>, <1.009175, -0.733209, 0.726995> }
triangle { <1.046408, -0.760260, 0.691342>, <1.115040, -0.639999, 0.687542>, <1.147840, -0.658826, 0.650255> }
triangle { <1.147840, -0.658826, 0.650255>, <1.077189, -0.782624, 0.654508>, <1.046408, -0.760260, 0.691342> }
triangle { <1.077189, -0.782624, 0.654508>, <1.147840, -0.658826, 0.650255>, <1.173563, -0.673590, 0.612004> }
triangle { <1.173563, -0.673590, 0.612004>, <1.101329, -0.800163, 0.616723>, <1.077189, -0.782624, 0.654508> }
triangle { <1.101329, -0.800163, 0.616723>, <1.173563, -0.673590, 0.612004>, <1.192051, -0.684201, 0.573024> }
triangle { <1.192051, -0.684201, 0.573024>, <1.118679, -0.812768, 0.578217>, <1.101329, -0.800163, 0.616723> }
triangle { <1.118679, -0.812768, 0.578217>, <1.192051, -0.684201, 0.573024>, <1.203190, -0.690595, 0.533557> }
triangle { <1.203190, -0.690595, 0.533557>, <1.129132, -0.820363, 0.539230>, <1.118679, -0.812768, 0.578217> }
triangle { <1.129132, -0.820363, 0.539230>, <1.203190, -0.690595, 0.533557>, <1.206910, -0.692730, 0.493844> }
triangle { <1.206910, -0.692730, 0.493844>, <1.132624, -0.822899, 0.500000>, <1.129132, -0.820363, 0.539230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.098073, -0.043391, 0.998383> }
triangle { <0.098073, -0.043391, 0.998383>, <0.094693, -0.054351, 0.998440>, <0.000000, 0.000000, 1.000000> }
triangle { <0.094693, -0.054351, 0.998440>, <0.098073, -0.043391, 0.998383>, <0.195542, -0.086514, 0.993543> }
triangle { <0.195542, -0.086514, 0.993543>, <0.188802, -0.108367, 0.993768>, <0.094693, -0.054351, 0.998440> }
triangle { <0.188802, -0.108367, 0.993768>, <0.195542, -0.086514, 0.993543>, <0.291805, -0.129104, 0.985509> }
triangle { <0.291805, -0.129104, 0.985509>, <0.281748, -0.161715, 0.986015>, <0.188802, -0.108367, 0.993768> }
triangle { <0.281748, -0.161715, 0.986015>, <0.291805, -0.129104, 0.985509>, <0.386268, -0.170898, 0.974331> }
triangle { <0.386268, -0.170898, 0.974331>, <0.372956, -0.214065, 0.975227>, <0.281748, -0.161715, 0.986015> }
triangle { <0.372956, -0.214065, 0.975227>, <0.386268, -0.170898, 0.974331>, <0.478351, -0.211638, 0.960077> }
triangle { <0.478351, -0.211638, 0.960077>, <0.461865, -0.265096, 0.961471>, <0.372956, -0.214065, 0.975227> }
triangle { <0.461865, -0.265096, 0.961471>, <0.478351, -0.211638, 0.960077>, <0.567484, -0.251074, 0.942836> }
triangle { <0.567484, -0.251074, 0.942836>, <0.547926, -0.314493, 0.944832>, <0.461865, -0.265096, 0.961471> }
triangle { <0.547926, -0.314493, 0.944832>, <0.567484, -0.251074, 0.942836>, <0.653118, -0.288961, 0.922714> }
triangle { <0.653118, -0.288961, 0.922714>, <0.630609, -0.361950, 0.925413>, <0.547926, -0.314493, 0.944832> }
triangle { <0.630609, -0.361950, 0.925413>, <0.653118, -0.288961, 0.922714>, <0.734726, -0.325067, 0.899835> }
triangle { <0.734726, -0.325067, 0.899835>, <0.709404, -0.407177, 0.903333>, <0.630609, -0.361950, 0.925413> }
triangle { <0.709404, -0.407177, 0.903333>, <0.734726, -0.325067, 0.899835>, <0.811804, -0.359169, 0.874340> }
triangle { <0.811804, -0.359169, 0.874340>, <0.783825, -0.449892, 0.878728>, <0.709404, -0.407177, 0.903333> }
triangle { <0.783825, -0.449892, 0.878728>, <0.811804, -0.359169, 0.874340>, <0.883877, -0.391057, 0.846386> }
triangle { <0.883877, -0.391057, 0.846386>, <0.853414, -0.489834, 0.851750>, <0.783825, -0.449892, 0.878728> }
triangle { <0.853414, -0.489834, 0.851750>, <0.883877, -0.391057, 0.846386>, <0.950501, -0.420533, 0.816145> }
triangle { <0.950501, -0.420533, 0.816145>, <0.917742, -0.526756, 0.822566>, <0.853414, -0.489834, 0.851750> }
triangle { <0.917742, -0.526756, 0.822566>, <0.950501, -0.420533, 0.816145>, <1.011264, -0.447417, 0.783805> }
triangle { <1.011264, -0.447417, 0.783805>, <0.976411, -0.560430, 0.791355>, <0.917742, -0.526756, 0.822566> }
triangle { <0.976411, -0.560430, 0.791355>, <1.011264, -0.447417, 0.783805>, <1.065792, -0.471542, 0.749564> }
triangle { <1.065792, -0.471542, 0.749564>, <1.029060, -0.590650, 0.758310>, <0.976411, -0.560430, 0.791355> }
triangle { <1.029060, -0.590650, 0.758310>, <1.065792, -0.471542, 0.749564>, <1.113750, -0.492760, 0.713633> }
triangle { <1.113750, -0.492760, 0.713633>, <1.075365, -0.617227, 0.723634>, <1.029060, -0.590650, 0.758310> }
triangle { <1.075365, -0.617227, 0.723634>, <1.113750, -0.492760, 0.713633>, <1.154841, -0.510940, 0.676235> }
triangle { <1.154841, -0.510940, 0.676235>, <1.115040, -0.639999, 0.687542>, <1.075365, -0.617227, 0.723634> }
triangle { <1.115040, -0.639999, 0.687542>, <1.154841, -0.510940, 0.676235>, <1.188812, -0.525970, 0.637599> }
triangle { <1.188812, -0.525970, 0.637599>, <1.147840, -0.658826, 0.650255>, <1.115040, -0.639999, 0.687542> }
triangle { <1.147840, -0.658826, 0.650255>, <1.188812, -0.525970, 0.637599>, <1.215454, -0.537757, 0.597964> }
triangle { <1.215454, -0.537757, 0.597964>, <1.173563, -0.673590, 0.612004>, <1.147840, -0.658826, 0.650255> }
triangle { <1.173563, -0.673590, 0.612004>, <1.215454, -0.537757, 0.597964>, <1.234601, -0.546229, 0.557574> }
triangle { <1.234601, -0.546229, 0.557574>, <1.192051, -0.684201, 0.573024>, <1.173563, -0.673590, 0.612004> }
triangle { <1.192051, -0.684201, 0.573024>, <1.234601, -0.546229, 0.557574>, <1.246138, -0.551333, 0.516678> }
triangle { <1.246138, -0.551333, 0.516678>, <1.203190, -0.690595, 0.533557>, <1.192051, -0.684201, 0.573024> }
triangle { <1.203190, -0.690595, 0.533557>, <1.246138, -0.551333, 0.516678>, <1.249991, -0.553038, 0.475528> }
triangle { <1.249991, -0.553038, 0.475528>, <1.206910, -0.692730, 0.493844>, <1.203190, -0.690595, 0.533557> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.098941, -0.032528, 0.998291> }
triangle { <0.098941, -0.032528, 0.998291>, <0.098073, -0.043391, 0.998383>, <0.000000, 0.000000, 1.000000> }
triangle { <0.098073, -0.043391, 0.998383>, <0.098941, -0.032528, 0.998291>, <0.197272, -0.064855, 0.993173> }
triangle { <0.197272, -0.064855, 0.993173>, <0.195542, -0.086514, 0.993543>, <0.098073, -0.043391, 0.998383> }
triangle { <0.195542, -0.086514, 0.993543>, <0.197272, -0.064855, 0.993173>, <0.294387, -0.096783, 0.984679> }
triangle { <0.294387, -0.096783, 0.984679>, <0.291805, -0.129104, 0.985509>, <0.195542, -0.086514, 0.993543> }
triangle { <0.291805, -0.129104, 0.985509>, <0.294387, -0.096783, 0.984679>, <0.389687, -0.128114, 0.972861> }
triangle { <0.389687, -0.128114, 0.972861>, <0.386268, -0.170898, 0.974331>, <0.291805, -0.129104, 0.985509> }
triangle { <0.386268, -0.170898, 0.974331>, <0.389687, -0.128114, 0.972861>, <0.482584, -0.158655, 0.957791> }
triangle { <0.482584, -0.158655, 0.957791>, <0.478351, -0.211638, 0.960077>, <0.386268, -0.170898, 0.974331> }
triangle { <0.478351, -0.211638, 0.960077>, <0.482584, -0.158655, 0.957791>, <0.572506, -0.188217, 0.939563> }
triangle { <0.572506, -0.188217, 0.939563>, <0.567484, -0.251074, 0.942836>, <0.478351, -0.211638, 0.960077> }
triangle { <0.567484, -0.251074, 0.942836>, <0.572506, -0.188217, 0.939563>, <0.658899, -0.216620, 0.918289> }
triangle { <0.658899, -0.216620, 0.918289>, <0.653118, -0.288961, 0.922714>, <0.567484, -0.251074, 0.942836> }
triangle { <0.653118, -0.288961, 0.922714>, <0.658899, -0.216620, 0.918289>, <0.741229, -0.243687, 0.894101> }
triangle { <0.741229, -0.243687, 0.894101>, <0.734726, -0.325067, 0.899835>, <0.653118, -0.288961, 0.922714> }
triangle { <0.734726, -0.325067, 0.899835>, <0.741229, -0.243687, 0.894101>, <0.818989, -0.269251, 0.867146> }
triangle { <0.818989, -0.269251, 0.867146>, <0.811804, -0.359169, 0.874340>, <0.734726, -0.325067, 0.899835> }
triangle { <0.811804, -0.359169, 0.874340>, <0.818989, -0.269251, 0.867146>, <0.891700, -0.293155, 0.837592> }
triangle { <0.891700, -0.293155, 0.837592>, <0.883877, -0.391057, 0.846386>, <0.811804, -0.359169, 0.874340> }
triangle { <0.883877, -0.391057, 0.846386>, <0.891700, -0.293155, 0.837592>, <0.958913, -0.315252, 0.805620> }
triangle { <0.958913, -0.315252, 0.805620>, <0.950501, -0.420533, 0.816145>, <0.883877, -0.391057, 0.846386> }
triangle { <0.950501, -0.420533, 0.816145>, <0.958913, -0.315252, 0.805620>, <1.020214, -0.335406, 0.771428> }
triangle { <1.020214, -0.335406, 0.771428>, <1.011264, -0.447417, 0.783805>, <0.950501, -0.420533, 0.816145> }
triangle { <1.011264, -0.447417, 0.783805>, <1.020214, -0.335406, 0.771428>, <1.075225, -0.353491, 0.735227> }
triangle { <1.075225, -0.353491, 0.735227>, <1.065792, -0.471542, 0.749564>, <1.011264, -0.447417, 0.783805> }
triangle { <1.065792, -0.471542, 0.749564>, <1.075225, -0.353491, 0.735227>, <1.123607, -0.369397, 0.697240> }
triangle { <1.123607, -0.369397, 0.697240>, <1.113750, -0.492760, 0.713633>, <1.065792, -0.471542, 0.749564> }
triangle { <1.113750, -0.492760, 0.713633>, <1.123607, -0.369397, 0.697240>, <1.165062, -0.383026, 0.657700> }
triangle { <1.165062, -0.383026, 0.657700>, <1.154841, -0.510940, 0.676235>, <1.113750, -0.492760, 0.713633> }
triangle { <1.154841, -0.510940, 0.676235>, <1.165062, -0.383026, 0.657700>, <1.199333, -0.394293, 0.616852> }
triangle { <1.199333, -0.394293, 0.616852>, <1.188812, -0.525970, 0.637599>, <1.154841, -0.510940, 0.676235> }
triangle { <1.188812, -0.525970, 0.637599>, <1.199333, -0.394293, 0.616852>, <1.226211, -0.403129, 0.574948> }
triangle { <1.226211, -0.403129, 0.574948>, <1.215454, -0.537757, 0.597964>, <1.188812, -0.525970, 0.637599> }
triangle { <1.215454, -0.537757, 0.597964>, <1.226211, -0.403129, 0.574948>, <1.245528, -0.409480, 0.532246> }
triangle { <1.245528, -0.409480, 0.532246>, <1.234601, -0.546229, 0.557574>, <1.215454, -0.537757, 0.597964> }
triangle { <1.234601, -0.546229, 0.557574>, <1.245528, -0.409480, 0.532246>, <1.257166, -0.413306, 0.489009> }
triangle { <1.257166, -0.413306, 0.489009>, <1.246138, -0.551333, 0.516678>, <1.234601, -0.546229, 0.557574> }
triangle { <1.246138, -0.551333, 0.516678>, <1.257166, -0.413306, 0.489009>, <1.261054, -0.414584, 0.445503> }
triangle { <1.261054, -0.414584, 0.445503>, <1.249991, -0.553038, 0.475528>, <1.246138, -0.551333, 0.516678> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.097542, -0.022569, 0.998164> }
triangle { <0.097542, -0.022569, 0.998164>, <0.098941, -0.032528, 0.998291>, <0.000000, 0.000000, 1.000000> }
triangle { <0.098941, -0.032528, 0.998291>, <0.097542, -0.022569, 0.998164>, <0.194482, -0.044998, 0.992669> }
triangle { <0.194482, -0.044998, 0.992669>, <0.197272, -0.064855, 0.993173>, <0.098941, -0.032528, 0.998291> }
triangle { <0.197272, -0.064855, 0.993173>, <0.194482, -0.044998, 0.992669>, <0.290223, -0.067150, 0.983547> }
triangle { <0.290223, -0.067150, 0.983547>, <0.294387, -0.096783, 0.984679>, <0.197272, -0.064855, 0.993173> }
triangle { <0.294387, -0.096783, 0.984679>, <0.290223, -0.067150, 0.983547>, <0.384175, -0.088888, 0.970855> }
triangle { <0.384175, -0.088888, 0.970855>, <0.389687, -0.128114, 0.972861>, <0.294387, -0.096783, 0.984679> }
triangle { <0.389687, -0.128114, 0.972861>, <0.384175, -0.088888, 0.970855>, <0.475758, -0.110078, 0.954671> }
triangle { <0.475758, -0.110078, 0.954671>, <0.482584, -0.158655, 0.957791>, <0.389687, -0.128114, 0.972861> }
triangle { <0.482584, -0.158655, 0.957791>, <0.475758, -0.110078, 0.954671>, <0.564409, -0.130589, 0.935095> }
triangle { <0.564409, -0.130589, 0.935095>, <0.572506, -0.188217, 0.939563>, <0.482584, -0.158655, 0.957791> }
triangle { <0.572506, -0.188217, 0.939563>, <0.564409, -0.130589, 0.935095>, <0.649579, -0.150295, 0.912248> }
triangle { <0.649579, -0.150295, 0.912248>, <0.658899, -0.216620, 0.918289>, <0.572506, -0.188217, 0.939563> }
triangle { <0.658899, -0.216620, 0.918289>, <0.649579, -0.150295, 0.912248>, <0.730744, -0.169075, 0.886271> }
triangle { <0.730744, -0.169075, 0.886271>, <0.741229, -0.243687, 0.894101>, <0.658899, -0.216620, 0.918289> }
triangle { <0.741229, -0.243687, 0.894101>, <0.730744, -0.169075, 0.886271>, <0.807405, -0.186812, 0.857324> }
triangle { <0.807405, -0.186812, 0.857324>, <0.818989, -0.269251, 0.867146>, <0.741229, -0.243687, 0.894101> }
triangle { <0.818989, -0.269251, 0.867146>, <0.807405, -0.186812, 0.857324>, <0.879087, -0.203397, 0.825585> }
triangle { <0.879087, -0.203397, 0.825585>, <0.891700, -0.293155, 0.837592>, <0.818989, -0.269251, 0.867146> }
triangle { <0.891700, -0.293155, 0.837592>, <0.879087, -0.203397, 0.825585>, <0.945349, -0.218728, 0.791249> }
triangle { <0.945349, -0.218728, 0.791249>, <0.958913, -0.315252, 0.805620>, <0.891700, -0.293155, 0.837592> }
triangle { <0.958913, -0.315252, 0.805620>, <0.945349, -0.218728, 0.791249>, <1.005783, -0.232711, 0.754530> }
triangle { <1.005783, -0.232711, 0.754530>, <1.020214, -0.335406, 0.771428>, <0.958913, -0.315252, 0.805620> }
triangle { <1.020214, -0.335406, 0.771428>, <1.005783, -0.232711, 0.754530>, <1.060016, -0.245259, 0.715652> }
triangle { <1.060016, -0.245259, 0.715652>, <1.075225, -0.353491, 0.735227>, <1.020214, -0.335406, 0.771428> }
triangle { <1.075225, -0.353491, 0.735227>, <1.060016, -0.245259, 0.715652>, <1.107714, -0.256295, 0.674856> }
triangle { <1.107714, -0.256295, 0.674856>, <1.123607, -0.369397, 0.697240>, <1.075225, -0.353491, 0.735227> }
triangle { <1.123607, -0.369397, 0.697240>, <1.107714, -0.256295, 0.674856>, <1.148582, -0.265751, 0.632393> }
triangle { <1.148582, -0.265751, 0.632393>, <1.165062, -0.383026, 0.657700>, <1.123607, -0.369397, 0.697240> }
triangle { <1.165062, -0.383026, 0.657700>, <1.148582, -0.265751, 0.632393>, <1.182369, -0.273568, 0.588525> }
triangle { <1.182369, -0.273568, 0.588525>, <1.199333, -0.394293, 0.616852>, <1.165062, -0.383026, 0.657700> }
triangle { <1.199333, -0.394293, 0.616852>, <1.182369, -0.273568, 0.588525>, <1.208866, -0.279699, 0.543523> }
triangle { <1.208866, -0.279699, 0.543523>, <1.226211, -0.403129, 0.574948>, <1.199333, -0.394293, 0.616852> }
triangle { <1.226211, -0.403129, 0.574948>, <1.208866, -0.279699, 0.543523>, <1.227911, -0.284105, 0.497664> }
triangle { <1.227911, -0.284105, 0.497664>, <1.245528, -0.409480, 0.532246>, <1.226211, -0.403129, 0.574948> }
triangle { <1.245528, -0.409480, 0.532246>, <1.227911, -0.284105, 0.497664>, <1.239384, -0.286760, 0.451230> }
triangle { <1.239384, -0.286760, 0.451230>, <1.257166, -0.413306, 0.489009>, <1.245528, -0.409480, 0.532246> }
triangle { <1.257166, -0.413306, 0.489009>, <1.239384, -0.286760, 0.451230>, <1.243217, -0.287647, 0.404508> }
triangle { <1.243217, -0.287647, 0.404508>, <1.261054, -0.414584, 0.445503>, <1.257166, -0.413306, 0.489009> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.094392, -0.014170, 0.998007> }
triangle { <0.094392, -0.014170, 0.998007>, <0.097542, -0.022569, 0.998164>, <0.000000, 0.000000, 1.000000> }
triangle { <0.097542, -0.022569, 0.998164>, <0.094392, -0.014170, 0.998007>, <0.188202, -0.028253, 0.992041> }
triangle { <0.188202, -0.028253, 0.992041>, <0.194482, -0.044998, 0.992669>, <0.097542, -0.022569, 0.998164> }
triangle { <0.194482, -0.044998, 0.992669>, <0.188202, -0.028253, 0.992041>, <0.280851, -0.042162, 0.982139> }
triangle { <0.280851, -0.042162, 0.982139>, <0.290223, -0.067150, 0.983547>, <0.194482, -0.044998, 0.992669> }
triangle { <0.290223, -0.067150, 0.983547>, <0.280851, -0.042162, 0.982139>, <0.371769, -0.055811, 0.968361> }
triangle { <0.371769, -0.055811, 0.968361>, <0.384175, -0.088888, 0.970855>, <0.290223, -0.067150, 0.983547> }
triangle { <0.384175, -0.088888, 0.970855>, <0.371769, -0.055811, 0.968361>, <0.460395, -0.069116, 0.950792> }
triangle { <0.460395, -0.069116, 0.950792>, <0.475758, -0.110078, 0.954671>, <0.384175, -0.088888, 0.970855> }
triangle { <0.475758, -0.110078, 0.954671>, <0.460395, -0.069116, 0.950792>, <0.546183, -0.081995, 0.929542> }
triangle { <0.546183, -0.081995, 0.929542>, <0.564409, -0.130589, 0.935095>, <0.475758, -0.110078, 0.954671> }
triangle { <0.564409, -0.130589, 0.935095>, <0.546183, -0.081995, 0.929542>, <0.628603, -0.094368, 0.904740> }
triangle { <0.628603, -0.094368, 0.904740>, <0.649579, -0.150295, 0.912248>, <0.564409, -0.130589, 0.935095> }
triangle { <0.649579, -0.150295, 0.912248>, <0.628603, -0.094368, 0.904740>, <0.707148, -0.106159, 0.876540> }
triangle { <0.707148, -0.106159, 0.876540>, <0.730744, -0.169075, 0.886271>, <0.649579, -0.150295, 0.912248> }
triangle { <0.730744, -0.169075, 0.886271>, <0.707148, -0.106159, 0.876540>, <0.781332, -0.117296, 0.845115> }
triangle { <0.781332, -0.117296, 0.845115>, <0.807405, -0.186812, 0.857324>, <0.730744, -0.169075, 0.886271> }
triangle { <0.807405, -0.186812, 0.857324>, <0.781332, -0.117296, 0.845115>, <0.850700, -0.127710, 0.810660> }
triangle { <0.850700, -0.127710, 0.810660>, <0.879087, -0.203397, 0.825585>, <0.807405, -0.186812, 0.857324> }
triangle { <0.879087, -0.203397, 0.825585>, <0.850700, -0.127710, 0.810660>, <0.914823, -0.137336, 0.773387> }
triangle { <0.914823, -0.137336, 0.773387>, <0.945349, -0.218728, 0.791249>, <0.879087, -0.203397, 0.825585> }
triangle { <0.945349, -0.218728, 0.791249>, <0.914823, -0.137336, 0.773387>, <0.973305, -0.146116, 0.733525> }
triangle { <0.973305, -0.146116, 0.733525>, <1.005783, -0.232711, 0.754530>, <0.945349, -0.218728, 0.791249> }
triangle { <1.005783, -0.232711, 0.754530>, <0.973305, -0.146116, 0.733525>, <1.025787, -0.153995, 0.691321> }
triangle { <1.025787, -0.153995, 0.691321>, <1.060016, -0.245259, 0.715652>, <1.005783, -0.232711, 0.754530> }
triangle { <1.060016, -0.245259, 0.715652>, <1.025787, -0.153995, 0.691321>, <1.071944, -0.160924, 0.647034> }
triangle { <1.071944, -0.160924, 0.647034>, <1.107714, -0.256295, 0.674856>, <1.060016, -0.245259, 0.715652> }
triangle { <1.107714, -0.256295, 0.674856>, <1.071944, -0.160924, 0.647034>, <1.111493, -0.166861, 0.600938> }
triangle { <1.111493, -0.166861, 0.600938>, <1.148582, -0.265751, 0.632393>, <1.107714, -0.256295, 0.674856> }
triangle { <1.148582, -0.265751, 0.632393>, <1.111493, -0.166861, 0.600938>, <1.144189, -0.171769, 0.553316> }
triangle { <1.144189, -0.171769, 0.553316>, <1.182369, -0.273568, 0.588525>, <1.148582, -0.265751, 0.632393> }
triangle { <1.182369, -0.273568, 0.588525>, <1.144189, -0.171769, 0.553316>, <1.169830, -0.175619, 0.504463> }
triangle { <1.169830, -0.175619, 0.504463>, <1.208866, -0.279699, 0.543523>, <1.182369, -0.273568, 0.588525> }
triangle { <1.208866, -0.279699, 0.543523>, <1.169830, -0.175619, 0.504463>, <1.188259, -0.178385, 0.454680> }
triangle { <1.188259, -0.178385, 0.454680>, <1.227911, -0.284105, 0.497664>, <1.208866, -0.279699, 0.543523> }
triangle { <1.227911, -0.284105, 0.497664>, <1.188259, -0.178385, 0.454680>, <1.199363, -0.180052, 0.404273> }
triangle { <1.199363, -0.180052, 0.404273>, <1.239384, -0.286760, 0.451230>, <1.227911, -0.284105, 0.497664> }
triangle { <1.239384, -0.286760, 0.451230>, <1.199363, -0.180052, 0.404273>, <1.203071, -0.180609, 0.353553> }
triangle { <1.203071, -0.180609, 0.353553>, <1.243217, -0.287647, 0.404508>, <1.239384, -0.286760, 0.451230> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.090208, -0.007754, 0.997823> }
triangle { <0.090208, -0.007754, 0.997823>, <0.094392, -0.014170, 0.998007>, <0.000000, 0.000000, 1.000000> }
triangle { <0.094392, -0.014170, 0.998007>, <0.090208, -0.007754, 0.997823>, <0.179859, -0.015459, 0.991307> }
triangle { <0.179859, -0.015459, 0.991307>, <0.188202, -0.028253, 0.992041>, <0.094392, -0.014170, 0.998007> }
triangle { <0.188202, -0.028253, 0.992041>, <0.179859, -0.015459, 0.991307>, <0.268402, -0.023070, 0.980490> }
triangle { <0.268402, -0.023070, 0.980490>, <0.280851, -0.042162, 0.982139>, <0.188202, -0.028253, 0.992041> }
triangle { <0.280851, -0.042162, 0.982139>, <0.268402, -0.023070, 0.980490>, <0.355290, -0.030538, 0.965441> }
triangle { <0.355290, -0.030538, 0.965441>, <0.371769, -0.055811, 0.968361>, <0.280851, -0.042162, 0.982139> }
triangle { <0.371769, -0.055811, 0.968361>, <0.355290, -0.030538, 0.965441>, <0.439987, -0.037818, 0.946251> }
triangle { <0.439987, -0.037818, 0.946251>, <0.460395, -0.069116, 0.950792>, <0.371769, -0.055811, 0.968361> }
triangle { <0.460395, -0.069116, 0.950792>, <0.439987, -0.037818, 0.946251>, <0.521972, -0.044864, 0.923039> }
triangle { <0.521972, -0.044864, 0.923039>, <0.546183, -0.081995, 0.929542>, <0.460395, -0.069116, 0.950792> }
triangle { <0.546183, -0.081995, 0.929542>, <0.521972, -0.044864, 0.923039>, <0.600738, -0.051635, 0.895948> }
triangle { <0.600738, -0.051635, 0.895948>, <0.628603, -0.094368, 0.904740>, <0.546183, -0.081995, 0.929542> }
triangle { <0.628603, -0.094368, 0.904740>, <0.600738, -0.051635, 0.895948>, <0.675801, -0.058086, 0.865145> }
triangle { <0.675801, -0.058086, 0.865145>, <0.707148, -0.106159, 0.876540>, <0.628603, -0.094368, 0.904740> }
triangle { <0.707148, -0.106159, 0.876540>, <0.675801, -0.058086, 0.865145>, <0.746697, -0.064180, 0.830821> }
triangle { <0.746697, -0.064180, 0.830821>, <0.781332, -0.117296, 0.845115>, <0.707148, -0.106159, 0.876540> }
triangle { <0.781332, -0.117296, 0.845115>, <0.746697, -0.064180, 0.830821>, <0.812990, -0.069878, 0.793186> }
triangle { <0.812990, -0.069878, 0.793186>, <0.850700, -0.127710, 0.810660>, <0.781332, -0.117296, 0.845115> }
triangle { <0.850700, -0.127710, 0.810660>, <0.812990, -0.069878, 0.793186>, <0.874270, -0.075145, 0.752473> }
triangle { <0.874270, -0.075145, 0.752473>, <0.914823, -0.137336, 0.773387>, <0.850700, -0.127710, 0.810660> }
triangle { <0.914823, -0.137336, 0.773387>, <0.874270, -0.075145, 0.752473>, <0.930161, -0.079949, 0.708932> }
triangle { <0.930161, -0.079949, 0.708932>, <0.973305, -0.146116, 0.733525>, <0.914823, -0.137336, 0.773387> }
triangle { <0.973305, -0.146116, 0.733525>, <0.930161, -0.079949, 0.708932>, <0.980316, -0.084260, 0.662833> }
triangle { <0.980316, -0.084260, 0.662833>, <1.025787, -0.153995, 0.691321>, <0.973305, -0.146116, 0.733525> }
triangle { <1.025787, -0.153995, 0.691321>, <0.980316, -0.084260, 0.662833>, <1.024427, -0.088052, 0.614459> }
triangle { <1.024427, -0.088052, 0.614459>, <1.071944, -0.160924, 0.647034>, <1.025787, -0.153995, 0.691321> }
triangle { <1.071944, -0.160924, 0.647034>, <1.024427, -0.088052, 0.614459>, <1.062223, -0.091300, 0.564108> }
triangle { <1.062223, -0.091300, 0.564108>, <1.111493, -0.166861, 0.600938>, <1.071944, -0.160924, 0.647034> }
triangle { <1.111493, -0.166861, 0.600938>, <1.062223, -0.091300, 0.564108>, <1.093469, -0.093986, 0.512092> }
triangle { <1.093469, -0.093986, 0.512092>, <1.144189, -0.171769, 0.553316>, <1.111493, -0.166861, 0.600938> }
triangle { <1.144189, -0.171769, 0.553316>, <1.093469, -0.093986, 0.512092>, <1.117974, -0.096092, 0.458730> }
triangle { <1.117974, -0.096092, 0.458730>, <1.169830, -0.175619, 0.504463>, <1.144189, -0.171769, 0.553316> }
triangle { <1.169830, -0.175619, 0.504463>, <1.117974, -0.096092, 0.458730>, <1.135586, -0.097606, 0.404352> }
triangle { <1.135586, -0.097606, 0.404352>, <1.188259, -0.178385, 0.454680>, <1.169830, -0.175619, 0.504463> }
triangle { <1.188259, -0.178385, 0.454680>, <1.135586, -0.097606, 0.404352>, <1.146197, -0.098518, 0.349293> }
triangle { <1.146197, -0.098518, 0.349293>, <1.199363, -0.180052, 0.404273>, <1.188259, -0.178385, 0.454680> }
triangle { <1.199363, -0.180052, 0.404273>, <1.146197, -0.098518, 0.349293>, <1.149742, -0.098823, 0.293893> }
triangle { <1.149742, -0.098823, 0.293893>, <1.203071, -0.180609, 0.353553>, <1.199363, -0.180052, 0.404273> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.085802, -0.003444, 0.997617> }
triangle { <0.085802, -0.003444, 0.997617>, <0.090208, -0.007754, 0.997823>, <0.000000, 0.000000, 1.000000> }
triangle { <0.090208, -0.007754, 0.997823>, <0.085802, -0.003444, 0.997617>, <0.171075, -0.006866, 0.990483> }
triangle { <0.171075, -0.006866, 0.990483>, <0.179859, -0.015459, 0.991307>, <0.090208, -0.007754, 0.997823> }
triangle { <0.179859, -0.015459, 0.991307>, <0.171075, -0.006866, 0.990483>, <0.255293, -0.010246, 0.978642> }
triangle { <0.255293, -0.010246, 0.978642>, <0.268402, -0.023070, 0.980490>, <0.179859, -0.015459, 0.991307> }
triangle { <0.268402, -0.023070, 0.980490>, <0.255293, -0.010246, 0.978642>, <0.337938, -0.013563, 0.962166> }
triangle { <0.337938, -0.013563, 0.962166>, <0.355290, -0.030538, 0.965441>, <0.268402, -0.023070, 0.980490> }
triangle { <0.355290, -0.030538, 0.965441>, <0.337938, -0.013563, 0.962166>, <0.418498, -0.016797, 0.941159> }
triangle { <0.418498, -0.016797, 0.941159>, <0.439987, -0.037818, 0.946251>, <0.355290, -0.030538, 0.965441> }
triangle { <0.439987, -0.037818, 0.946251>, <0.418498, -0.016797, 0.941159>, <0.496479, -0.019927, 0.915748> }
triangle { <0.496479, -0.019927, 0.915748>, <0.521972, -0.044864, 0.923039>, <0.439987, -0.037818, 0.946251> }
triangle { <0.521972, -0.044864, 0.923039>, <0.496479, -0.019927, 0.915748>, <0.571399, -0.022934, 0.886090> }
triangle { <0.571399, -0.022934, 0.886090>, <0.600738, -0.051635, 0.895948>, <0.521972, -0.044864, 0.923039> }
triangle { <0.600738, -0.051635, 0.895948>, <0.571399, -0.022934, 0.886090>, <0.642795, -0.025799, 0.852369> }
triangle { <0.642795, -0.025799, 0.852369>, <0.675801, -0.058086, 0.865145>, <0.600738, -0.051635, 0.895948> }
triangle { <0.675801, -0.058086, 0.865145>, <0.642795, -0.025799, 0.852369>, <0.710229, -0.028506, 0.814793> }
triangle { <0.710229, -0.028506, 0.814793>, <0.746697, -0.064180, 0.830821>, <0.675801, -0.058086, 0.865145> }
triangle { <0.746697, -0.064180, 0.830821>, <0.710229, -0.028506, 0.814793>, <0.773284, -0.031036, 0.773592> }
triangle { <0.773284, -0.031036, 0.773592>, <0.812990, -0.069878, 0.793186>, <0.746697, -0.064180, 0.830821> }
triangle { <0.812990, -0.069878, 0.793186>, <0.773284, -0.031036, 0.773592>, <0.831571, -0.033376, 0.729022> }
triangle { <0.831571, -0.033376, 0.729022>, <0.874270, -0.075145, 0.752473>, <0.812990, -0.069878, 0.793186> }
triangle { <0.874270, -0.075145, 0.752473>, <0.831571, -0.033376, 0.729022>, <0.884732, -0.035510, 0.681356> }
triangle { <0.884732, -0.035510, 0.681356>, <0.930161, -0.079949, 0.708932>, <0.874270, -0.075145, 0.752473> }
triangle { <0.930161, -0.079949, 0.708932>, <0.884732, -0.035510, 0.681356>, <0.932438, -0.037424, 0.630889> }
triangle { <0.932438, -0.037424, 0.630889>, <0.980316, -0.084260, 0.662833>, <0.930161, -0.079949, 0.708932> }
triangle { <0.980316, -0.084260, 0.662833>, <0.932438, -0.037424, 0.630889>, <0.974395, -0.039108, 0.577932> }
triangle { <0.974395, -0.039108, 0.577932>, <1.024427, -0.088052, 0.614459>, <0.980316, -0.084260, 0.662833> }
triangle { <1.024427, -0.088052, 0.614459>, <0.974395, -0.039108, 0.577932>, <1.010344, -0.040551, 0.522811> }
triangle { <1.010344, -0.040551, 0.522811>, <1.062223, -0.091300, 0.564108>, <1.024427, -0.088052, 0.614459> }
triangle { <1.062223, -0.091300, 0.564108>, <1.010344, -0.040551, 0.522811>, <1.040065, -0.041744, 0.465867> }
triangle { <1.040065, -0.041744, 0.465867>, <1.093469, -0.093986, 0.512092>, <1.062223, -0.091300, 0.564108> }
triangle { <1.093469, -0.093986, 0.512092>, <1.040065, -0.041744, 0.465867>, <1.063373, -0.042679, 0.407450> }
triangle { <1.063373, -0.042679, 0.407450>, <1.117974, -0.096092, 0.458730>, <1.093469, -0.093986, 0.512092> }
triangle { <1.117974, -0.096092, 0.458730>, <1.063373, -0.042679, 0.407450>, <1.080125, -0.043352, 0.347920> }
triangle { <1.080125, -0.043352, 0.347920>, <1.135586, -0.097606, 0.404352>, <1.117974, -0.096092, 0.458730> }
triangle { <1.135586, -0.097606, 0.404352>, <1.080125, -0.043352, 0.347920>, <1.090218, -0.043757, 0.287645> }
triangle { <1.090218, -0.043757, 0.287645>, <1.146197, -0.098518, 0.349293>, <1.135586, -0.097606, 0.404352> }
triangle { <1.146197, -0.098518, 0.349293>, <1.090218, -0.043757, 0.287645>, <1.093589, -0.043892, 0.226995> }
triangle { <1.093589, -0.043892, 0.226995>, <1.149742, -0.098823, 0.293893>, <1.146197, -0.098518, 0.349293> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.081970, -0.001058, 0.997394> }
triangle { <0.081970, -0.001058, 0.997394>, <0.085802, -0.003444, 0.997617>, <0.000000, 0.000000, 1.000000> }
triangle { <0.085802, -0.003444, 0.997617>, <0.081970, -0.001058, 0.997394>, <0.163434, -0.002110, 0.989591> }
triangle { <0.163434, -0.002110, 0.989591>, <0.171075, -0.006866, 0.990483>, <0.085802, -0.003444, 0.997617> }
triangle { <0.171075, -0.006866, 0.990483>, <0.163434, -0.002110, 0.989591>, <0.243891, -0.003149, 0.976639> }
triangle { <0.243891, -0.003149, 0.976639>, <0.255293, -0.010246, 0.978642>, <0.171075, -0.006866, 0.990483> }
triangle { <0.255293, -0.010246, 0.978642>, <0.243891, -0.003149, 0.976639>, <0.322844, -0.004169, 0.958619> }
triangle { <0.322844, -0.004169, 0.958619>, <0.337938, -0.013563, 0.962166>, <0.255293, -0.010246, 0.978642> }
triangle { <0.337938, -0.013563, 0.962166>, <0.322844, -0.004169, 0.958619>, <0.399806, -0.005163, 0.935641> }
triangle { <0.399806, -0.005163, 0.935641>, <0.418498, -0.016797, 0.941159>, <0.337938, -0.013563, 0.962166> }
triangle { <0.418498, -0.016797, 0.941159>, <0.399806, -0.005163, 0.935641>, <0.474304, -0.006125, 0.907847> }
triangle { <0.474304, -0.006125, 0.907847>, <0.496479, -0.019927, 0.915748>, <0.418498, -0.016797, 0.941159> }
triangle { <0.496479, -0.019927, 0.915748>, <0.474304, -0.006125, 0.907847>, <0.545877, -0.007049, 0.875409> }
triangle { <0.545877, -0.007049, 0.875409>, <0.571399, -0.022934, 0.886090>, <0.496479, -0.019927, 0.915748> }
triangle { <0.571399, -0.022934, 0.886090>, <0.545877, -0.007049, 0.875409>, <0.614085, -0.007929, 0.838525> }
triangle { <0.614085, -0.007929, 0.838525>, <0.642795, -0.025799, 0.852369>, <0.571399, -0.022934, 0.886090> }
triangle { <0.642795, -0.025799, 0.852369>, <0.614085, -0.007929, 0.838525>, <0.678507, -0.008761, 0.797425> }
triangle { <0.678507, -0.008761, 0.797425>, <0.710229, -0.028506, 0.814793>, <0.642795, -0.025799, 0.852369> }
triangle { <0.710229, -0.028506, 0.814793>, <0.678507, -0.008761, 0.797425>, <0.738746, -0.009539, 0.752361> }
triangle { <0.738746, -0.009539, 0.752361>, <0.773284, -0.031036, 0.773592>, <0.710229, -0.028506, 0.814793> }
triangle { <0.773284, -0.031036, 0.773592>, <0.738746, -0.009539, 0.752361>, <0.794430, -0.010258, 0.703611> }
triangle { <0.794430, -0.010258, 0.703611>, <0.831571, -0.033376, 0.729022>, <0.773284, -0.031036, 0.773592> }
triangle { <0.831571, -0.033376, 0.729022>, <0.794430, -0.010258, 0.703611>, <0.845216, -0.010914, 0.651476> }
triangle { <0.845216, -0.010914, 0.651476>, <0.884732, -0.035510, 0.681356>, <0.831571, -0.033376, 0.729022> }
triangle { <0.884732, -0.035510, 0.681356>, <0.845216, -0.010914, 0.651476>, <0.890791, -0.011503, 0.596277> }
triangle { <0.890791, -0.011503, 0.596277>, <0.932438, -0.037424, 0.630889>, <0.884732, -0.035510, 0.681356> }
triangle { <0.932438, -0.037424, 0.630889>, <0.890791, -0.011503, 0.596277>, <0.930874, -0.012020, 0.538354> }
triangle { <0.930874, -0.012020, 0.538354>, <0.974395, -0.039108, 0.577932>, <0.932438, -0.037424, 0.630889> }
triangle { <0.974395, -0.039108, 0.577932>, <0.930874, -0.012020, 0.538354>, <0.965218, -0.012464, 0.478064> }
triangle { <0.965218, -0.012464, 0.478064>, <1.010344, -0.040551, 0.522811>, <0.974395, -0.039108, 0.577932> }
triangle { <1.010344, -0.040551, 0.522811>, <0.965218, -0.012464, 0.478064>, <0.993611, -0.012830, 0.415780> }
triangle { <0.993611, -0.012830, 0.415780>, <1.040065, -0.041744, 0.465867>, <1.010344, -0.040551, 0.522811> }
triangle { <1.040065, -0.041744, 0.465867>, <0.993611, -0.012830, 0.415780>, <1.015878, -0.013118, 0.351885> }
triangle { <1.015878, -0.013118, 0.351885>, <1.063373, -0.042679, 0.407450>, <1.040065, -0.041744, 0.465867> }
triangle { <1.063373, -0.042679, 0.407450>, <1.015878, -0.013118, 0.351885>, <1.031881, -0.013324, 0.286773> }
triangle { <1.031881, -0.013324, 0.286773>, <1.080125, -0.043352, 0.347920>, <1.063373, -0.042679, 0.407450> }
triangle { <1.080125, -0.043352, 0.347920>, <1.031881, -0.013324, 0.286773>, <1.041523, -0.013449, 0.220845> }
triangle { <1.041523, -0.013449, 0.220845>, <1.090218, -0.043757, 0.287645>, <1.080125, -0.043352, 0.347920> }
triangle { <1.090218, -0.043757, 0.287645>, <1.041523, -0.013449, 0.220845>, <1.044744, -0.013490, 0.154508> }
triangle { <1.044744, -0.013490, 0.154508>, <1.093589, -0.043892, 0.226995>, <1.090218, -0.043757, 0.287645> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.079375, -0.000135, 0.997158> }
triangle { <0.079375, -0.000135, 0.997158>, <0.081970, -0.001058, 0.997394>, <0.000000, 0.000000, 1.000000> }
triangle { <0.081970, -0.001058, 0.997394>, <0.079375, -0.000135, 0.997158>, <0.158261, -0.000270, 0.988651> }
triangle { <0.158261, -0.000270, 0.988651>, <0.163434, -0.002110, 0.989591>, <0.081970, -0.001058, 0.997394> }
triangle { <0.163434, -0.002110, 0.989591>, <0.158261, -0.000270, 0.988651>, <0.236171, -0.000402, 0.974531> }
triangle { <0.236171, -0.000402, 0.974531>, <0.243891, -0.003149, 0.976639>, <0.163434, -0.002110, 0.989591> }
triangle { <0.243891, -0.003149, 0.976639>, <0.236171, -0.000402, 0.974531>, <0.312625, -0.000533, 0.954885> }
triangle { <0.312625, -0.000533, 0.954885>, <0.322844, -0.004169, 0.958619>, <0.243891, -0.003149, 0.976639> }
triangle { <0.322844, -0.004169, 0.958619>, <0.312625, -0.000533, 0.954885>, <0.387152, -0.000660, 0.929833> }
triangle { <0.387152, -0.000660, 0.929833>, <0.399806, -0.005163, 0.935641>, <0.322844, -0.004169, 0.958619> }
triangle { <0.399806, -0.005163, 0.935641>, <0.387152, -0.000660, 0.929833>, <0.459292, -0.000783, 0.899532> }
triangle { <0.459292, -0.000783, 0.899532>, <0.474304, -0.006125, 0.907847>, <0.399806, -0.005163, 0.935641> }
triangle { <0.474304, -0.006125, 0.907847>, <0.459292, -0.000783, 0.899532>, <0.528600, -0.000901, 0.864166> }
triangle { <0.528600, -0.000901, 0.864166>, <0.545877, -0.007049, 0.875409>, <0.474304, -0.006125, 0.907847> }
triangle { <0.545877, -0.007049, 0.875409>, <0.528600, -0.000901, 0.864166>, <0.594649, -0.001013, 0.823955> }
triangle { <0.594649, -0.001013, 0.823955>, <0.614085, -0.007929, 0.838525>, <0.545877, -0.007049, 0.875409> }
triangle { <0.614085, -0.007929, 0.838525>, <0.594649, -0.001013, 0.823955>, <0.657032, -0.001119, 0.779146> }
triangle { <0.657032, -0.001119, 0.779146>, <0.678507, -0.008761, 0.797425>, <0.614085, -0.007929, 0.838525> }
triangle { <0.678507, -0.008761, 0.797425>, <0.657032, -0.001119, 0.779146>, <0.715364, -0.001219, 0.730016> }
triangle { <0.715364, -0.001219, 0.730016>, <0.738746, -0.009539, 0.752361>, <0.678507, -0.008761, 0.797425> }
triangle { <0.738746, -0.009539, 0.752361>, <0.715364, -0.001219, 0.730016>, <0.769285, -0.001311, 0.676867> }
triangle { <0.769285, -0.001311, 0.676867>, <0.794430, -0.010258, 0.703611>, <0.738746, -0.009539, 0.752361> }
triangle { <0.794430, -0.010258, 0.703611>, <0.769285, -0.001311, 0.676867>, <0.818464, -0.001395, 0.620028> }
triangle { <0.818464, -0.001395, 0.620028>, <0.845216, -0.010914, 0.651476>, <0.794430, -0.010258, 0.703611> }
triangle { <0.845216, -0.010914, 0.651476>, <0.818464, -0.001395, 0.620028>, <0.862596, -0.001470, 0.559847> }
triangle { <0.862596, -0.001470, 0.559847>, <0.890791, -0.011503, 0.596277>, <0.845216, -0.010914, 0.651476> }
triangle { <0.890791, -0.011503, 0.596277>, <0.862596, -0.001470, 0.559847>, <0.901411, -0.001536, 0.496698> }
triangle { <0.901411, -0.001536, 0.496698>, <0.930874, -0.012020, 0.538354>, <0.890791, -0.011503, 0.596277> }
triangle { <0.930874, -0.012020, 0.538354>, <0.901411, -0.001536, 0.496698>, <0.934667, -0.001593, 0.430968> }
triangle { <0.934667, -0.001593, 0.430968>, <0.965218, -0.012464, 0.478064>, <0.930874, -0.012020, 0.538354> }
triangle { <0.965218, -0.012464, 0.478064>, <0.934667, -0.001593, 0.430968>, <0.962162, -0.001639, 0.363064> }
triangle { <0.962162, -0.001639, 0.363064>, <0.993611, -0.012830, 0.415780>, <0.965218, -0.012464, 0.478064> }
triangle { <0.993611, -0.012830, 0.415780>, <0.962162, -0.001639, 0.363064>, <0.983724, -0.001676, 0.293403> }
triangle { <0.983724, -0.001676, 0.293403>, <1.015878, -0.013118, 0.351885>, <0.993611, -0.012830, 0.415780> }
triangle { <1.015878, -0.013118, 0.351885>, <0.983724, -0.001676, 0.293403>, <0.999221, -0.001702, 0.222416> }
triangle { <0.999221, -0.001702, 0.222416>, <1.031881, -0.013324, 0.286773>, <1.015878, -0.013118, 0.351885> }
triangle { <1.031881, -0.013324, 0.286773>, <0.999221, -0.001702, 0.222416>, <1.008558, -0.001718, 0.150539> }
triangle { <1.008558, -0.001718, 0.150539>, <1.041523, -0.013449, 0.220845>, <1.031881, -0.013324, 0.286773> }
triangle { <1.041523, -0.013449, 0.220845>, <1.008558, -0.001718, 0.150539>, <1.011677, -0.001724, 0.078217> }
triangle { <1.011677, -0.001724, 0.078217>, <1.044744, -0.013490, 0.154508>, <1.041523, -0.013449, 0.220845> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.078459, 0.000000, 0.996917> }
triangle { <0.078459, 0.000000, 0.996917>, <0.079375, -0.000135, 0.997158>, <0.000000, 0.000000, 1.000000> }
triangle { <0.079375, -0.000135, 0.997158>, <0.078459, 0.000000, 0.996917>, <0.156434, 0.000000, 0.987688> }
triangle { <0.156434, 0.000000, 0.987688>, <0.158261, -0.000270, 0.988651>, <0.079375, -0.000135, 0.997158> }
triangle { <0.158261, -0.000270, 0.988651>, <0.156434, 0.000000, 0.987688>, <0.233445, 0.000000, 0.972370> }
triangle { <0.233445, 0.000000, 0.972370>, <0.236171, -0.000402, 0.974531>, <0.158261, -0.000270, 0.988651> }
triangle { <0.236171, -0.000402, 0.974531>, <0.233445, 0.000000, 0.972370>, <0.309017, 0.000000, 0.951057> }
triangle { <0.309017, 0.000000, 0.951057>, <0.312625, -0.000533, 0.954885>, <0.236171, -0.000402, 0.974531> }
triangle { <0.312625, -0.000533, 0.954885>, <0.309017, 0.000000, 0.951057>, <0.382683, 0.000000, 0.923880> }
triangle { <0.382683, 0.000000, 0.923880>, <0.387152, -0.000660, 0.929833>, <0.312625, -0.000533, 0.954885> }
triangle { <0.387152, -0.000660, 0.929833>, <0.382683, 0.000000, 0.923880>, <0.453990, 0.000000, 0.891007> }
triangle { <0.453990, 0.000000, 0.891007>, <0.459292, -0.000783, 0.899532>, <0.387152, -0.000660, 0.929833> }
triangle { <0.459292, -0.000783, 0.899532>, <0.453990, 0.000000, 0.891007>, <0.522499, 0.000000, 0.852640> }
triangle { <0.522499, 0.000000, 0.852640>, <0.528600, -0.000901, 0.864166>, <0.459292, -0.000783, 0.899532> }
triangle { <0.528600, -0.000901, 0.864166>, <0.522499, 0.000000, 0.852640>, <0.587785, 0.000000, 0.809017> }
triangle { <0.587785, 0.000000, 0.809017>, <0.594649, -0.001013, 0.823955>, <0.528600, -0.000901, 0.864166> }
triangle { <0.594649, -0.001013, 0.823955>, <0.587785, 0.000000, 0.809017>, <0.649448, 0.000000, 0.760406> }
triangle { <0.649448, 0.000000, 0.760406>, <0.657032, -0.001119, 0.779146>, <0.594649, -0.001013, 0.823955> }
triangle { <0.657032, -0.001119, 0.779146>, <0.649448, 0.000000, 0.760406>, <0.707107, 0.000000, 0.707107> }
triangle { <0.707107, 0.000000, 0.707107>, <0.715364, -0.001219, 0.730016>, <0.657032, -0.001119, 0.779146> }
triangle { <0.715364, -0.001219, 0.730016>, <0.707107, 0.000000, 0.707107>, <0.760406, 0.000000, 0.649448> }
triangle { <0.760406, 0.000000, 0.649448>, <0.769285, -0.001311, 0.676867>, <0.715364, -0.001219, 0.730016> }
triangle { <0.769285, -0.001311, 0.676867>, <0.760406, 0.000000, 0.649448>, <0.809017, 0.000000, 0.587785> }
triangle { <0.809017, 0.000000, 0.587785>, <0.818464, -0.001395, 0.620028>, <0.769285, -0.001311, 0.676867> }
triangle { <0.818464, -0.001395, 0.620028>, <0.809017, 0.000000, 0.587785>, <0.852640, 0.000000, 0.522499> }
triangle { <0.852640, 0.000000, 0.522499>, <0.862596, -0.001470, 0.559847>, <0.818464, -0.001395, 0.620028> }
triangle { <0.862596, -0.001470, 0.559847>, <0.852640, 0.000000, 0.522499>, <0.891007, 0.000000, 0.453991> }
triangle { <0.891007, 0.000000, 0.453991>, <0.901411, -0.001536, 0.496698>, <0.862596, -0.001470, 0.559847> }
triangle { <0.901411, -0.001536, 0.496698>, <0.891007, 0.000000, 0.453991>, <0.923880, 0.000000, 0.382683> }
triangle { <0.923880, 0.000000, 0.382683>, <0.934667, -0.001593, 0.430968>, <0.901411, -0.001536, 0.496698> }
triangle { <0.934667, -0.001593, 0.430968>, <0.923880, 0.000000, 0.382683>, <0.951057, 0.000000, 0.309017> }
triangle { <0.951057, 0.000000, 0.309017>, <0.962162, -0.001639, 0.363064>, <0.934667, -0.001593, 0.430968> }
triangle { <0.962162, -0.001639, 0.363064>, <0.951057, 0.000000, 0.309017>, <0.972370, 0.000000, 0.233445> }
triangle { <0.972370, 0.000000, 0.233445>, <0.983724, -0.001676, 0.293403>, <0.962162, -0.001639, 0.363064> }
triangle { <0.983724, -0.001676, 0.293403>, <0.972370, 0.000000, 0.233445>, <0.987688, 0.000000, 0.156434> }
triangle { <0.987688, 0.000000, 0.156434>, <0.999221, -0.001702, 0.222416>, <0.983724, -0.001676, 0.293403> }
triangle { <0.999221, -0.001702, 0.222416>, <0.987688, 0.000000, 0.156434>, <0.996917, 0.000000, 0.078459> }
triangle { <0.996917, 0.000000, 0.078459>, <1.008558, -0.001718, 0.150539>, <0.999221, -0.001702, 0.222416> }
triangle { <1.008558, -0.001718, 0.150539>, <0.996917, 0.000000, 0.078459>, <1.000000, 0.000000, 0.000000> }
triangle { <1.000000, 0.000000, 0.000000>, <1.011677, -0.001724, 0.078217>, <1.008558, -0.001718, 0.150539> }
// Attributes returned success!
  scale <2.0, 2.0, 1.0>
  rotate -15.0*y
  translate  <17.207191, 0.0, 24.676574>
}
#declare LampHead = union {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      ColorBlack1
    }
    hollow
    scale 2.0
    rotate 15.0*y
    translate  <-6.409134, 6.5879, 32.090958>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 open
    material {
      ColorBlack1
    }
    scale <2.0, 2.0, 3.0>
    rotate 15.0*y
    translate  <-7.28138, 6.765951, 29.020157>
  }
  rotate <-0.0, -15.0, 0.0>
  translate  <21.781955, -6.908542, 4.970302>
}
#declare LampNeck = union { 
  object {
    bicubic_patch { type 1 flatness 0.0154 u_steps 5 v_steps 2,
      <-1.000000, 0.512819, 0.046620>, <-1.000000, -0.307692, 0.093240>, <1.000000, -0.307692, 0.093240>, <1.000000, 0.512820, 0.046620>, 
      <-1.000000, 0.559439, 2.000000>, <-1.000000, -0.214452, 2.000000>, <1.000000, -0.214452, 2.000000>, <1.000000, 0.559440, 2.000000>, 
      <-1.000000, 0.559439, 4.000000>, <-1.000000, -0.214452, 4.000000>, <1.000000, -0.214452, 4.000000>, <1.000000, 0.559440, 4.000000>, 
      <-1.000000, 1.934730, 6.163170>, <-1.000000, 1.743590, 6.839161>, <1.000000, 1.743590, 6.839161>, <1.000000, 1.934732, 6.163170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0154 u_steps 5 v_steps 2,
      <1.000000, 0.512820, 0.046620>, <1.000000, 1.333333, 0.000000>, <-1.000000, 1.333330, 0.000000>, <-1.000000, 0.512819, 0.046620>, 
      <1.000000, 0.559440, 2.000000>, <1.000000, 1.333333, 2.000000>, <-1.000000, 1.333330, 2.000000>, <-1.000000, 0.559439, 2.000000>, 
      <1.000000, 0.559440, 4.000000>, <1.000000, 1.333333, 4.000000>, <-1.000000, 1.333330, 4.000000>, <-1.000000, 0.559439, 4.000000>, 
      <1.000000, 1.934732, 6.163170>, <1.000000, 2.125874, 5.487179>, <-1.000000, 2.125871, 5.487179>, <-1.000000, 1.934730, 6.163170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0154 u_steps 5 v_steps 2,
      <-1.000000, 1.934730, 6.163170>, <-1.000000, 1.743590, 6.839161>, <1.000000, 1.743590, 6.839161>, <1.000000, 1.934732, 6.163170>, 
      <-1.000000, 3.310022, 8.326340>, <-1.000000, 3.701632, 9.678322>, <1.000000, 3.701632, 9.678322>, <1.000000, 3.310023, 8.326340>, 
      <-1.000000, 4.055942, 9.860140>, <-1.000000, 3.701632, 11.678322>, <1.000000, 3.701632, 11.678322>, <1.000000, 4.055944, 9.860140>, 
      <-1.000000, 5.361304, 10.787879>, <-1.000000, 6.312354, 11.533800>, <1.000000, 6.312354, 11.533800>, <1.000000, 5.361305, 10.787879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0154 u_steps 5 v_steps 2,
      <1.000000, 1.934732, 6.163170>, <1.000000, 2.125874, 5.487179>, <-1.000000, 2.125871, 5.487179>, <-1.000000, 1.934730, 6.163170>, 
      <1.000000, 3.310023, 8.326340>, <1.000000, 2.918415, 6.974359>, <-1.000000, 2.918412, 6.974359>, <-1.000000, 3.310022, 8.326340>, 
      <1.000000, 4.055944, 9.860140>, <1.000000, 4.410256, 8.041958>, <-1.000000, 4.410253, 8.041958>, <-1.000000, 4.055942, 9.860140>, 
      <1.000000, 5.361305, 10.787879>, <1.000000, 4.410256, 10.041958>, <-1.000000, 4.410253, 10.041958>, <-1.000000, 5.361304, 10.787879>
    }
  }
  material {
    ColorBlack
  }
  scale <0.302799, 1.0, 1.0>
  rotate <-15.0, 0.0, 90.0>
  translate  <17.309365, -0.309338, 25.23551>
}
union { // Lamp
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      ColorBlack1
    }
    scale <2.4, 2.4, 0.75>
    rotate -15.0*y
    translate  <17.108592, 0.0, 24.505795>
  }
  object { DomeFace1 }
  object { LampHead }
  object { LampNeck }
  material {
    ColorBlack1
  }
  rotate 15.0*y
  translate  <-9.358221, 6.908542, 2.091603>
}


#declare RotSweep001 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  translate  <-7.0, -5.0, 2.0>
}
#declare RotSweep004 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  rotate <180.0, 0.0, 180.0>
  translate  <-7.0, -5.0, 7.0>
}
#declare Legs4 = union {
  object { RotSweep001 }
  object { RotSweep004 }
}
#declare RotSweep002 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  translate  <-7.0, -5.0, 2.0>
}
#declare RotSweep005 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  rotate <180.0, 0.0, 180.0>
  translate  <-7.0, -5.0, 7.0>
}
#declare Legs1 = union {
  object { RotSweep002 }
  object { RotSweep005 }
  translate  14.0*x
}
#declare RotSweep003 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  translate  <-7.0, -5.0, 2.0>
}
#declare RotSweep006 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  rotate <180.0, 0.0, 180.0>
  translate  <-7.0, -5.0, 7.0>
}
#declare Legs2 = union {
  object { RotSweep003 }
  object { RotSweep006 }
  translate  <14.0, 9.0, 0.0>
}
#declare RotSweep007 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  translate  <-7.0, -5.0, 2.0>
}
#declare RotSweep008 = lathe {
  linear_spline
  25  // control points
  <1.06993, -2.118881>,
  <1.147319, -2.111364>,
  <1.312354, -1.863636>,
  <1.370629, -1.702797>,
  <1.334877, -1.44463>,
  <1.221921, -1.270486>,
  <1.02851, -1.241976>,
  <0.963473, -1.182676>,
  <0.926318, -1.095285>,
  <0.924997, -1.013095>,
  <0.986277, -0.845637>,
  <1.124226, -0.55434>,
  <1.022005, -0.278922>,
  <1.257809, -0.129779>,
  <1.361305, -0.002331>,
  <1.369674, 0.129946>,
  <1.320862, 0.338566>,
  <1.258741, 0.492541>,
  <1.146737, 0.625256>,
  <0.965035, 0.787879>,
  <0.917308, 1.139697>,
  <1.334499, 1.317483>,
  <1.156935, 1.588089>,
  <0.79021, 1.897436>,
  <0.793706, 3.083217>
  rotate <90,0,90>
  rotate <180.0, 0.0, 180.0>
  translate  <-7.0, -5.0, 7.0>
}
#declare Legs3 = union {
  object { RotSweep007 }
  object { RotSweep008 }
  translate  9.0*y
}
#declare Legs = union {
  object { Legs4 }
  object { Legs1 }
  object { Legs2 }
  object { Legs3 }
}
#declare Chairtop = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 8.0, 0.5>
    rotate -90.0*x
    translate  <0.0, 7.656208, 8.012311>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.8, 0.75>
    rotate -90.0*z
    translate  <9.481935, -3.382976, 8.505854>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.8, 0.75>
    rotate -90.0*z
    translate  <-9.481935, -3.382976, 8.606683>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 8.0, 0.5>
    translate  0.534154*z
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.5, 0.5>
    rotate <180.0, -75.0, 180.0>
    translate  <-8.599621, -3.382855, 4.43428>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.5, 0.5>
    rotate <180.0, 75.0, 180.0>
    translate  <8.551526, -3.382855, 4.43428>
  }
  material {
    DMFDarkOak
  }
  translate  <0.0, -0.534154, 9.25867>
}
#declare RndCube001 = merge {
  sphere { <3.5000, 5.5000, -1.0000>, 1.5000 }
  sphere { <3.5000, -5.5000, -1.0000>, 1.5000 }
  sphere { <-3.5000, -5.5000, -1.0000>, 1.5000 }
  sphere { <-3.5000, 5.5000, -1.0000>, 1.5000 }
  sphere { <3.5000, 5.5000, 1.0000>, 1.5000 }
  sphere { <3.5000, -5.5000, 1.0000>, 1.5000 }
  sphere { <-3.5000, -5.5000, 1.0000>, 1.5000 }
  sphere { <-3.5000, 5.5000, 1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, -1.0000>, <-3.5000, 5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, -5.5000, -1.0000>, <-3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, -5.5000, 1.0000>, <-3.5000, -5.5000, 1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, 1.0000>, <-3.5000, 5.5000, 1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, 1.0000>, <3.5000, 5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, -5.5000, 1.0000>, <3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <-3.5000, -5.5000, 1.0000>, <-3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <-3.5000, 5.5000, 1.0000>, <-3.5000, 5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, -1.0000>, <3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, 1.0000>, <3.5000, -5.5000, 1.0000>, 1.5000 }
  cylinder { <-3.5000, 5.5000, 1.0000>, <-3.5000, -5.5000, 1.0000>, 1.5000 }
  cylinder { <-3.5000, 5.5000, -1.0000>, <-3.5000, -5.5000, -1.0000>, 1.5000 }
  box { <-3.5000, -5.5000, -0.5000> <3.5000, 5.5000, 0.5000> }
  box { <-3.5000, -7.0000, 1.0000> <3.5000, 7.0000, -1.0000> }
  box { <-5.0000, -5.5000, 1.0000> <5.0000, 5.5000, -1.0000> }
// Attributes returned success!
  material {
    Candy_Cane
  }
  translate  <0.0, 10.148927, 11.457705>
}
#declare RndCube002 = merge {
  sphere { <3.5000, 5.5000, -1.0000>, 1.5000 }
  sphere { <3.5000, -5.5000, -1.0000>, 1.5000 }
  sphere { <-3.5000, -5.5000, -1.0000>, 1.5000 }
  sphere { <-3.5000, 5.5000, -1.0000>, 1.5000 }
  sphere { <3.5000, 5.5000, 1.0000>, 1.5000 }
  sphere { <3.5000, -5.5000, 1.0000>, 1.5000 }
  sphere { <-3.5000, -5.5000, 1.0000>, 1.5000 }
  sphere { <-3.5000, 5.5000, 1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, -1.0000>, <-3.5000, 5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, -5.5000, -1.0000>, <-3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, -5.5000, 1.0000>, <-3.5000, -5.5000, 1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, 1.0000>, <-3.5000, 5.5000, 1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, 1.0000>, <3.5000, 5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, -5.5000, 1.0000>, <3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <-3.5000, -5.5000, 1.0000>, <-3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <-3.5000, 5.5000, 1.0000>, <-3.5000, 5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, -1.0000>, <3.5000, -5.5000, -1.0000>, 1.5000 }
  cylinder { <3.5000, 5.5000, 1.0000>, <3.5000, -5.5000, 1.0000>, 1.5000 }
  cylinder { <-3.5000, 5.5000, 1.0000>, <-3.5000, -5.5000, 1.0000>, 1.5000 }
  cylinder { <-3.5000, 5.5000, -1.0000>, <-3.5000, -5.5000, -1.0000>, 1.5000 }
  box { <-3.5000, -5.5000, -0.5000> <3.5000, 5.5000, 0.5000> }
  box { <-3.5000, -7.0000, 1.0000> <3.5000, 7.0000, -1.0000> }
  box { <-5.0000, -5.5000, 1.0000> <5.0000, 5.5000, -1.0000> }
// Attributes returned success!
  material {
    Candy_Cane
  }
  scale <1.0, 0.25, 0.5>
  rotate -90.0*x
  translate  <0.098599, 16.835426, 22.43047>
}
#declare Pillows = union {
  object { RndCube001 }
  object { RndCube002 }
  translate  -11.217235*y
}
union { // Chair
  object { Legs }
  object { Chairtop }
  object { Pillows }
  material {
    DMFDarkOak
  }
  rotate 135.0*z
  translate  <-35.960241, -28.089242, 0.27888>
}


